/*
 * Copyright 2020 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef IMX8QM_MEK_ANDROID_AUTO_H
#define IMX8QM_MEK_ANDROID_AUTO_H

#define CONFIG_USB_GADGET_VBUS_DRAW	2
#define CONFIG_SKIP_RESOURCE_CHECKING

/* USB OTG controller configs */
#ifdef CONFIG_USB_EHCI_HCD
#ifndef CONFIG_MXC_USB_PORTSC
#define CONFIG_MXC_USB_PORTSC		(PORT_PTS_UTMI | PORT_PTS_PTW)
#endif
#endif

#define FSL_FASTBOOT_FB_DEV "mmc"

#define IMX_HDMI_FIRMWARE_LOAD_ADDR (CONFIG_SYS_SDRAM_BASE + SZ_64M)
#define IMX_HDMITX_FIRMWARE_SIZE 0x20000
#define IMX_HDMIRX_FIRMWARE_SIZE 0x20000

#undef CONFIG_EXTRA_ENV_SETTINGS
#undef CONFIG_BOOTCOMMAND

#define CONFIG_EXTRA_ENV_SETTINGS					\
	"splashpos=m,m\0"	  \
	"fdt_high=0xffffffffffffffff\0"	  \
	"initrd_high=0xffffffffffffffff\0" \

/* Undefine some macros to save boot time */
#undef CONFIG_FEC_MXC
#undef CONFIG_USB_HOST_ETHER
#undef CONFIG_ARCH_MISC_INIT
#undef CONFIG_SCSI
#undef CONFIG_SCSI_AHCI
#undef CONFIG_SCSI_AHCI_PLAT
#undef CONFIG_CMD_SCSI
#undef CONFIG_LIBATA
#undef CONFIG_SATA_IMX
#undef CONFIG_FSL_HSIO
#undef CONFIG_PCIE_IMX8X
#undef CONFIG_CMD_PCI
#undef CONFIG_PCI
#undef CONFIG_SYS_LONGHELP
#undef CONFIG_AUTO_COMPLETE
#undef CONFIG_MII
#undef CONFIG_PHYLIB
#undef CONFIG_PHY_ATHEROS
#undef CONFIG_CMD_FUSE
#undef CONFIG_USB_FUNCTION_MASS_STORAGE
#undef CONFIG_CMD_USB
#undef CONFIG_CMD_USB_MASS_STORAGE
#undef CONFIG_FAT_WRITE

#ifdef CONFIG_IMX_TRUSTY_OS
#define AVB_RPMB
#define NS_ARCH_ARM64 1
#define KEYSLOT_HWPARTITION_ID	2
#define KEYSLOT_BLKS		0x3FFF

#ifdef CONFIG_ID_ATTESTATION
#define ATTESTATION_ID_BRAND "Android"
#define ATTESTATION_ID_DEVICE "mek_8q"
#define ATTESTATION_ID_MANUFACTURER "nxp"
#define ATTESTATION_ID_MODEL "MEK-MX8Q"
#endif

#endif

#ifdef CONFIG_DUAL_BOOTLOADER
#define BOOTLOADER_RBIDX_OFFSET  0x3FE000
#define BOOTLOADER_RBIDX_START   0x3FF000
#define BOOTLOADER_RBIDX_LEN     0x08
#define BOOTLOADER_RBIDX_INITVAL 0
#define CONFIG_SYS_SPL_PTE_RAM_BASE 0x801F8000
#endif


#ifdef CONFIG_SPL_BUILD
#undef CONFIG_BLK
#define CONFIG_FSL_CAAM_KB
#define CONFIG_SPL_CRYPTO_SUPPORT
#define CONFIG_SYS_FSL_SEC_LE
#endif

#if defined(CONFIG_XEN)
#include "imx8qm_mek_android_auto_xen.h"
#endif

#endif /* IMX8QM_MEK_ANDROID_AUTO_H */
