/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2019 NXP
 */

#ifndef __IMX8MP_EVK_H
#define __IMX8MP_EVK_H

#include <linux/sizes.h>
#include <asm/arch/imx-regs.h>

#include "imx_env.h"

#define CONFIG_POST CONFIG_SYS_POST_MEMORY

/* use SNVS LPGPR0_alias for post memory
 * these registers persist reset and are guaranteed to be 0 from cold boot */
#define CONFIG_SYS_POST_WORD_ADDR 0x30370090

#define CONFIG_SPL_MAX_SIZE		(152 * 1024)
#define CONFIG_SYS_MONITOR_LEN		(512 * 1024)
#define CONFIG_SYS_MMCSD_RAW_MODE_U_BOOT_USE_SECTOR
#define CONFIG_SYS_MMCSD_RAW_MODE_U_BOOT_SECTOR	0x300
#define CONFIG_SYS_MMCSD_FS_BOOT_PARTITION	1
#define CONFIG_SYS_UBOOT_BASE	(QSPI0_AMBA_BASE + CONFIG_SYS_MMCSD_RAW_MODE_U_BOOT_SECTOR * 512)
#define CONFIG_SYS_BOOTM_LEN		SZ_64M

#ifdef CONFIG_SPL_BUILD
#define CONFIG_SPL_STACK		0x187FF0
#define CONFIG_SPL_BSS_START_ADDR      0x0095e000
#define CONFIG_SPL_BSS_MAX_SIZE        0x2000	/* 8 KB */
#define CONFIG_SYS_SPL_MALLOC_START    0x42200000
#define CONFIG_SYS_SPL_MALLOC_SIZE     SZ_512K	/* 512 KB */

#define CONFIG_MALLOC_F_ADDR		0x184000 /* malloc f used before GD_FLG_FULL_MALLOC_INIT set */

#define CONFIG_SPL_ABORT_ON_RAW_IMAGE

#define CONFIG_SYS_I2C

#define CONFIG_SYS_ALT_MEMTEST

#endif

#define CONFIG_POWER
#define CONFIG_POWER_I2C
#define CONFIG_POWER_PCA9450

#define CONFIG_CMD_READ
#define CONFIG_SERIAL_TAG
#define CONFIG_FASTBOOT_USB_DEV 0

#define CONFIG_REMAKE_ELF
/* ENET Config */
/* ENET1 */
#if defined(CONFIG_CMD_NET)

#define CONFIG_ETHPRIME "eth0"
#define CONFIG_FEC_XCV_TYPE             RGMII
#define FEC_QUIRK_ENET_MAC
/* use phy_find_by_mask with mask = 0xffffffff
 * the addr defined in the dts will be ignored
 */
#define CONFIG_FEC_MXC_PHYADDR -1

#ifdef CONFIG_DWC_ETH_QOS
#define CONFIG_SYS_NONCACHED_MEMORY     (1 * SZ_1M)     /* 1M */
/* use phy_find_by_mask with mask = 0xffffffff
 * the addr defined in the dts will be ignored
 */
#define DWC_NET_PHYADDR -1
#endif

#define PHY_ANEG_TIMEOUT 20000

#endif

#define CONFIG_EXTRA_ENV_SETTINGS		\
	"console=ttymxc1,115200\0" \
	"fdt_addr=0x45000000\0"			\
	"fdt_size=0x20000\0"			\
	"overlay_addr=0x45020000\0"		\
	"boot_fit=try\0" \
	"mmcdev="__stringify(CONFIG_SYS_MMC_ENV_DEV)"\0" \
	"mmcpart=" __stringify(CONFIG_SYS_MMC_IMG_LOAD_PART) "\0" \
	"mmcroot=" CONFIG_MMCROOT " rootwait rw\0" \
	"mmcautodetect=yes\0" \
	"mmcargs=setenv bootargs console=${console} root=${mmcroot} ${optargs}\0" \
	"script=boot/boot.scr\0" \
	"loadbootscript=load mmc ${mmcdev}:${mmcpart} ${loadaddr} ${script};\0" \
	"bootscript=echo Running bootscript from mmc ...; " \
		"source; " \
		"log rec none warning \"\" 0 bootscript \"boot script did not boot\"\0" \
	"image=boot/Image\0" \
	"loadimage=load mmc ${mmcdev}:${mmcpart} ${loadaddr} ${image} " \
		"|| run loadimage_mmcboot\0" \
	"loadimage_mmcboot=" \
		/* read everything from 5MB onwards. This only works for emmc. */ \
		/* mmcboot partition image must be fit */ \
		"if mmc dev ${mmcdev} ${mmcpart} && mmc read ${loadaddr} 0x2800 0xc800 " \
			"&& mmc dev ${mmcdev} 0 && iminfo quiet; then " \
				"boot_fit=yes; " \
			"else " \
				"log rec none warning \"\" 0 loadimage " \
					"\"Could not load linux image!\"; " \
				"false; " /* false required to fail 'run loadimage' */ \
			"fi\0" \
	"fdt_file=boot/" CONFIG_DEFAULT_FDT_FILE "\0" \
	"loadfdt=" \
		"if load mmc ${mmcdev}:${mmcpart} ${fdt_addr} ${fdt_file}; then " \
			"echo \"Loading fdt ${fdt_file}\" " \
			"&& fdt addr ${fdt_addr} && fdt resize ${fdt_size}; " \
		"else " \
			"log rec none warning \"\" 0 loadfdt \"Could not load fdt file!\"; " \
			"false; " /* false required to fail 'run loadfdt' */ \
		"fi\0" \
	"overlays_list=boot/overlays.txt\0" \
	"load_overlays_list=" \
		"load mmc ${mmcdev}:${mmcpart} ${overlay_addr} ${overlays_list} " \
			"&& env import -t ${overlay_addr} ${filesize}\0" \
	"apply_overlays=" \
		"for overlay in ${fdt_overlays}; do " \
			"if load mmc ${mmcdev}:${mmcpart} ${overlay_addr} /boot/${overlay}; then " \
				"echo \"Applying fdt overlay: ${overlay}\"; " \
				"fdt apply ${overlay_addr}; " \
			"else " \
				"echo \"Warning: fdt overlay ${overlay} not found!\"; " \
			"fi; " \
		"done; setenv fdt_overlays\0" \
	"fitconf_base=#armadillo\0" \
	"apply_fit_overlays=" \
		"for overlay in ${fdt_overlays}; do " \
			"echo \"Appending overlay ${overlay}\"; " \
			"fitconf=\"${fitconf}#${overlay}\"; " \
		"done; setenv fdt_overlays\0" \
	"mmcboot=echo Booting from mmc ...; " \
		"run mmcargs; " \
		"if test ${boot_fit} = yes || test ${boot_fit} = try && iminfo quiet; then " \
			"run apply_fit_overlays; " \
			"run load_overlays_list && run apply_fit_overlays; " \
			"bootm ${loadaddr}\"${fitconf_base}${fitconf}\"; " \
			"log rec none warning \"\" 0 mmcboot \"Could not boot fit image\"; " \
		"elif run loadfdt; then " \
			"run apply_overlays; " /* once first, if fdt_overlays is manually set */ \
			"run load_overlays_list && run apply_overlays; " \
			"booti ${loadaddr} - ${fdt_addr}; " \
			"log rec none warning \"\" 0 mmcboot \"Could not boot image\"; " \
		"fi\0" \
	"upgrade_available=1\0" \
	"rollback_mmc=" \
		/* refuse to rollback if dek offset is set, would not be bootable */ \
		/* this check to be superseded by common upgrade_available check */ \
		"test -z \"${dek_spl_offset}\" && saveenv && " \
		"mmc partconf " __stringify(CONFIG_SYS_MMC_ENV_DEV) " 0 ${fallback} 0 && reset\0" \
	"rollback_other=setenv mmcpart \"${fallback}\"; " \
		"setenv mmcroot \"mmcblk${mmcdev}p${fallback} rootwait ro\"; " \
		"saveenv; reset\0" \
	"setfallback=" \
		"setexpr fallback 3 - ${mmcpart}; " /* 2 -> 1, 1 -> 2. And recheck. */ \
		"test \"${fallback}\" = 1 || test \"${fallback}\" = 2\0" \
	"rollback=" \
		"setenv bootcount; " \
		"if test \"${upgrade_available}\" -gt 0 && run setfallback; then " \
			"log rec none warning \"\" 0 rollback " \
				"\"Rolling back to mmcblk${mmcdev}p${fallback}\"; " \
			"if test \"${mmcdev}\" = " __stringify(CONFIG_SYS_MMC_ENV_DEV) "; then " \
				"run rollback_mmc; " \
			"else " \
				"run rollback_other; " \
			"fi; " \
		"elif test \"${upgrade_available}\" -gt 0; then " \
			"log rec none warning \"\" 0 rollback " \
				"\"Cannot compute rollback target from mmcpart ${mmcpart}\"; " \
		"else " \
			"log rec none warning \"\" 0 rollback " \
				"\"Rollback target is not ready, refusing to rollback.\"; " \
		"fi; " \
		/* reset if rollback failed: we're not booting either way... */ \
		"saveenv; reset\0" \
	"altbootcmd=" \
		"log rec none warning \"\" 0 altbootcmd " \
			"\"Counted $bootlimit consecutive unfinished boots\"; " \
		"run rollback\0" \
	"update_encrypted_boot=" \
		"test \"${encrypted_update_available}\" = 1 && " \
		/* there can be only one attempt: */ \
		/* we unset encrypted_update_available first so userspace */ \
		/* can assume rolled back boot is broken if offset env is set */ \
		/* conversely, userspace should setenv offsets, write non-bootable */ \
		/* boot image and only then set encrypted_update_available. */ \
		"setenv encrypted_update_available && saveenv && " \
		"test -n \"${dek_spl_offset}\" && " \
		"test -n \"${dek_fit_offset}\" && " \
		"run setfallback && " \
		"log rec none warning \"\" 0 update_encrypted_boot " \
			"\"Writing encrypted boot to mmcblk2boot${fallback}\" && " \
		"if mmc dev 2 ${fallback} && " \
		"mmc read 0x40500000 0 0x2000 && " \
		"setexpr offset 0x40500000 + ${dek_spl_offset} && " \
		"cp ${offset} 0x40400000 8 && " /* cannot update in place */ \
		"dek_blob 0x40400000 ${offset} 256 && " \
		"setexpr offset 0x40500000 + ${dek_fit_offset} && " \
		"cp ${offset} 0x40402000 8 && " /* cannot update in place */ \
		"dek_blob 0x40402000 ${offset} 256 && " \
		"mmc write 0x40500000 0 0x2000 && " \
		/* clear other env vars then boot into new image */ \
		"setenv upgrade_available 1 && " \
		"setenv dek_spl_offset && setenv dek_fit_offset; then " \
			"run rollback_mmc; " \
		"else " \
			"log rec none warning \"\" 0 update_encrypted_boot " \
				"\"Flashing new boot image failed!!\"; " \
		"fi\0" \
	"optargs=quiet nokaslr\0" \
	"timeoffset=32400\0"


#define CONFIG_BOOTCOMMAND \
	"mmc dev ${mmcdev}; sleep 0.5; if mmc rescan; then " \
		"run update_encrypted_boot; " \
		"if run loadbootscript; then " \
			"run bootscript; " \
		"else " \
			"run loadimage && run mmcboot; " \
		"fi; " \
	"fi; " \
	"run rollback;"

#ifdef CONFIG_ENV_WRITEABLE_LIST
/* In this mode we define envs we want to allow overriding at run time
 * Possible flags are as follow:
 * type flags:
 *  - s: string
 *  - d: decimal
 *  - x: hexadecimal
 *  - b: boolean
 *  - i: IP address
 *  - m: MAC address
 * access flags:
 *  - a: any
 *  - r: read-only
 *  - o: write-once
 *  - c: change-default
 *  - w: writeable
 *
 *  The following example value allows:
 *  - rollback related variables
 *  - encrypted uboot related variables
 *  - network settings (mac addresses, interface selection for uboot net commands)
 */
#define CFG_ENV_FLAGS_LIST_STATIC \
	"bootcount:dw,upgrade_available:dw" \
	",encrypted_update_available:bw,dek_spl_offset:xw,dek_fit_offset:xw" \
	",ethaddr:mw,eth1addr:mw,ethact:sw,ethprime:sw"
#endif

/* Link Definitions */
#define CONFIG_LOADADDR			0x40480000

#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR

#define CONFIG_SYS_INIT_RAM_ADDR	0x40000000
#define CONFIG_SYS_INIT_RAM_SIZE	0x80000
#define CONFIG_SYS_INIT_SP_OFFSET \
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR \
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

#define CONFIG_ENV_OVERWRITE
#define CONFIG_ENV_SPI_BUS		CONFIG_SF_DEFAULT_BUS
#define CONFIG_ENV_SPI_CS		CONFIG_SF_DEFAULT_CS
#define CONFIG_ENV_SPI_MODE		CONFIG_SF_DEFAULT_MODE
#define CONFIG_ENV_SPI_MAX_HZ		CONFIG_SF_DEFAULT_SPEED

#define CONFIG_SYS_MMC_ENV_DEV		2   /* USDHC2 */
#define CONFIG_SYS_MMC_ENV_PART		1
#define CONFIG_MMCROOT			"/dev/mmcblk2p1"  /* USDHC2 */

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		SZ_32M

/* Totally 2GB DDR */
#define CONFIG_SYS_SDRAM_BASE		0x40000000
#define PHYS_SDRAM			0x40000000
#define PHYS_SDRAM_SIZE			0x80000000	/* 2 GB */

#define CONFIG_SYS_MEMTEST_START	0x60000000
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_MEMTEST_START + \
					(PHYS_SDRAM_SIZE >> 1))

#define CONFIG_MXC_UART_BASE		UART2_BASE_ADDR

/* Monitor Command Prompt */
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_SYS_CBSIZE		2048
#define CONFIG_SYS_MAXARGS		64
#define CONFIG_SYS_BARGSIZE CONFIG_SYS_CBSIZE
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE + \
					sizeof(CONFIG_SYS_PROMPT) + 16)

#define CONFIG_IMX_BOOTAUX
#define CONFIG_FSL_USDHC

#ifdef CONFIG_TARGET_IMX8MP_DDR4_EVK
#define CONFIG_SYS_FSL_USDHC_NUM	1
#else
#define CONFIG_SYS_FSL_USDHC_NUM	2
#endif
#define CONFIG_SYS_FSL_ESDHC_ADDR	0

#define CONFIG_SYS_MMC_IMG_LOAD_PART	1

#ifdef CONFIG_FSL_FSPI
#define FSL_FSPI_FLASH_SIZE		SZ_32M
#define FSL_FSPI_FLASH_NUM		1
#define FSPI0_BASE_ADDR			0x30bb0000
#define FSPI0_AMBA_BASE			0x0
#define CONFIG_FSPI_QUAD_SUPPORT

#define CONFIG_SYS_FSL_FSPI_AHB
#endif

#ifdef CONFIG_NAND_MXS
#define CONFIG_CMD_NAND_TRIMFFS

/* NAND stuff */
#define CONFIG_SYS_MAX_NAND_DEVICE     1
#define CONFIG_SYS_NAND_BASE           0x20000000
#define CONFIG_SYS_NAND_5_ADDR_CYCLE
#define CONFIG_SYS_NAND_ONFI_DETECTION
#define CONFIG_SYS_NAND_USE_FLASH_BBT
#endif /* CONFIG_NAND_MXS */

#define CONFIG_SYS_I2C_SPEED		100000

/* USB configs */
#ifndef CONFIG_SPL_BUILD
#define CONFIG_CMD_USB
#define CONFIG_USB_STORAGE

#define CONFIG_CMD_USB_MASS_STORAGE
#define CONFIG_USB_GADGET_MASS_STORAGE
#define CONFIG_USB_FUNCTION_MASS_STORAGE
#endif

#define CONFIG_USB_MAX_CONTROLLER_COUNT         2
#define CONFIG_USBD_HS
#define CONFIG_USB_GADGET_VBUS_DRAW 2

#ifdef CONFIG_DM_VIDEO
#define CONFIG_VIDEO_LOGO
#define CONFIG_SPLASH_SCREEN
#define CONFIG_SPLASH_SCREEN_ALIGN
#define CONFIG_CMD_BMP
#define CONFIG_BMP_16BPP
#define CONFIG_BMP_24BPP
#define CONFIG_BMP_32BPP
#define CONFIG_VIDEO_BMP_RLE8
#define CONFIG_VIDEO_BMP_LOGO
#endif

#ifdef CONFIG_ANDROID_SUPPORT
#include "imx8mp_evk_android.h"
#endif

#endif
