/*
 * Copyright (C) 2017 Yasushi SHOJI <yashi@atmark-techno.com>
 *
 * Configuration settings for Atmark Techno Armadillo-640
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
#ifndef __ARMADILLO640_CONFIG_H
#define __ARMADILLO640_CONFIG_H

#include "mx6_common.h"

#ifdef CONFIG_SPL
#include "imx6_spl.h"
#endif

/* cancel autoboot for maintenance mode */
#if defined(CONFIG_SUPPORT_MAINTENANCE_MODE) && !defined(__ASSEMBLY__)
int is_maintenance_mode(void);
#endif

/* Physical Memory Map */
// #define CONFIG_NR_DRAM_BANKS		1
#define CONFIG_SYS_SDRAM_BASE 0x80000000

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		(16 * SZ_1M)

// #define CONFIG_ENV_SIZE			SZ_512K
// #define CONFIG_ENV_OFFSET		SZ_512K

/* MTFC8GAKAJCN_1M workaround */
#define MTFC8GAKAJCN_1M_DEVICE_NUM		(0)
#define MTFC8GAKAJCN_1M_DEVICE_ID		"J55L"
#define MTFC8GAKAJCN_1M_DEVICE_ID_OFFSET	(2)

/* Memory Map */
#define CONFIG_SYS_INIT_RAM_ADDR	IRAM_BASE_ADDR
#define CONFIG_SYS_INIT_RAM_SIZE	IRAM_SIZE
#define CONFIG_SYS_INIT_SP_ADDR		(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_RAM_SIZE)

/* CONFIG_MXC_UART */

#if defined CONFIG_CONSOLE_UART1
#define CONFIG_MXC_UART_BASE		UART1_BASE
#define CONSOLE_TTY			"ttymxc0,115200"
#elif defined CONFIG_CONSOLE_UART3
#define CONFIG_MXC_UART_BASE		UART3_BASE
#define CONSOLE_TTY			"ttymxc2,115200"
#endif

/* USB Configs */
#define CONFIG_EHCI_HCD_INIT_AFTER_RESET
#define CONFIG_MXC_USB_PORTSC  (PORT_PTS_UTMI | PORT_PTS_PTW)
#define CONFIG_MXC_USB_FLAGS   0
#define CONFIG_USB_MAX_CONTROLLER_COUNT 2

/* PMIC */
#define CONFIG_POWER
#define CONFIG_POWER_I2C
#define CONFIG_POWER_PFUZE3000
#define CONFIG_POWER_PFUZE3000_I2C_ADDR	0x08

#ifndef __ASSEMBLY__
void wlan_rtc_i2c_scl(int bit);
void wlan_rtc_i2c_sda(int bit);
int wlan_rtc_i2c_read(void);
#endif

#define I2C_INIT
#define I2C_ACTIVE
#define I2C_TRISTATE

/* MMC Configs */
#define CONFIG_SYS_FSL_ESDHC_ADDR  USDHC1_BASE_ADDR
#define CONFIG_SYS_MMC_ENV_DEV		0
#define CONFIG_SYS_MMC_ENV_PART		1
#define CONFIG_SYS_MMC_IMG_LOAD_PART	1
#define CONFIG_MMCROOT			"/dev/mmcblk0p1"

/* Ethernet */
#ifdef CONFIG_FEC_MXC
#define CONFIG_FEC_XCV_TYPE RMII
#define CONFIG_FEC_MXC_PHYADDR		0
#define IMX_FEC_BASE			ENET_BASE_ADDR
#endif

#ifdef CONFIG_SYS_BOOT_DEVICE_SELECT
#define MMCDEV "${mmcdev}"
#else
#define MMCDEV "0"
#endif
#define CONFIG_BOOTCOMMAND \
	"mmc dev ${mmcdev}; sleep 0.5; if mmc rescan; then " \
		"if run loadbootscript; then " \
			"run bootscript; " \
		"else " \
			"run loadimage && run mmcboot; " \
		"fi; " \
		"run rollback; " \
	"fi;"

#define FDT_FILE_AUTODETECT "yes"

#define CONFIG_EXTRA_ENV_SETTINGS \
	"console=" CONSOLE_TTY "\0" \
	"fdt_addr=0x83500000\0"			\
	"fdt_size=0x20000\0"			\
	"overlay_addr=0x83520000\0"		\
	"boot_fit=no\0" \
	"mmcdev=" __stringify(CONFIG_SYS_MMC_ENV_DEV) "\0" \
	"mmcpart=" __stringify(CONFIG_SYS_MMC_IMG_LOAD_PART) "\0" \
	"mmcroot=" CONFIG_MMCROOT " rootwait rw\0" \
	"mmcautodetect=yes\0" \
	"mmcargs=setenv bootargs console=${console} root=${mmcroot} ${optargs}\0" \
	"script=boot/boot.scr\0" \
	"loadbootscript=load mmc ${mmcdev}:${mmcpart} ${loadaddr} ${script};\0" \
	"bootscript=echo Running bootscript from mmc ...; " \
		"source; " \
		"log rec none warning \"\" 0 bootscript \"boot script did not boot\"\0" \
	"image=boot/uImage\0" \
	"loadimage=load mmc ${mmcdev}:${mmcpart} ${loadaddr} ${image}\0" \
	"fdt_file=boot/" CONFIG_DEFAULT_FDT_FILE "\0" \
	"loadfdt=" \
		"if load mmc ${mmcdev}:${mmcpart} ${fdt_addr} ${fdt_file}; then " \
			"echo \"Loading fdt ${fdt_file}\" " \
			"&& fdt addr ${fdt_addr} && fdt resize ${fdt_size}; " \
		"else " \
			"log rec none warning \"\" 0 loadfdt \"Could not load fdt file!\"; " \
			"false; " /* false required to fail 'run loadfdt' */ \
		"fi\0" \
	"overlays_list=boot/overlays.txt\0" \
	"load_overlays_list=" \
		"load mmc ${mmcdev}:${mmcpart} ${overlay_addr} ${overlays_list} " \
			"&& env import -t ${overlay_addr} ${filesize}\0" \
	"apply_overlays=" \
		"for overlay in ${fdt_overlays}; do " \
			"if load mmc ${mmcdev}:${mmcpart} ${overlay_addr} /boot/${overlay}; then " \
				"echo \"Applying fdt overlay: ${overlay}\"; " \
				"fdt apply ${overlay_addr}; " \
			"else " \
				"echo \"Warning: fdt overlay ${overlay} not found!\"; " \
			"fi; " \
		"done; setenv fdt_overlays\0" \
	"fitconf_base=#armadillo\0" \
	"apply_fit_overlays=" \
		"for overlay in ${fdt_overlays}; do " \
			"echo \"Appending overlay ${overlay}\"; " \
			"fitconf=\"${fitconf}#${overlay}\"; " \
		"done; setenv fdt_overlays\0" \
	"mmcboot=echo Booting from mmc ...; " \
		"run mmcargs; " \
		"if test ${boot_fit} = yes; then " \
			"run apply_fit_overlays; " \
			"run load_overlays_list && run apply_fit_overlays; " \
			"bootm ${loadaddr}\"${fitconf_base}${fitconf}\"; " \
			"log rec none warning \"\" 0 mmcboot \"Could not boot fit image\"; " \
		"elif run loadfdt; then " \
			"run apply_overlays; " /* once first, if fdt_overlays is manually set */ \
			"run load_overlays_list && run apply_overlays; " \
			"bootm ${loadaddr} - ${fdt_addr}; " \
			"log rec none warning \"\" 0 mmcboot \"Could not boot image\"; " \
		"fi\0" \
	"upgrade_available=1\0" \
	"rollback_mmc=saveenv && " \
		"mmc partconf " __stringify(CONFIG_SYS_MMC_ENV_DEV) " 0 ${fallback} 0 && reset\0" \
	"rollback_other=setenv mmcpart \"${fallback}\"; " \
		"setenv mmcroot \"mmcblk${mmcdev}p${fallback} rootwait ro\"; " \
		"saveenv; reset\0" \
	"setfallback=" \
		"setexpr fallback 3 - ${mmcpart}; " /* 2 -> 1, 1 -> 2. And recheck. */ \
		"test \"${fallback}\" = 1 || test \"${fallback}\" = 2\0" \
	"rollback=" \
		"setenv bootcount; " \
		"if test \"${upgrade_available}\" -gt 0 && run setfallback; then " \
			"log rec none warning \"\" 0 rollback " \
				"\"Rolling back to mmcblk${mmcdev}p${fallback}\"; " \
			"if test \"${mmcdev}\" = " __stringify(CONFIG_SYS_MMC_ENV_DEV) "; then " \
				"run rollback_mmc; " \
			"else " \
				"run rollback_other; " \
			"fi; " \
		"elif test \"${upgrade_available}\" -gt 0; then " \
			"log rec none warning \"\" 0 rollback " \
				"\"Cannot compute rollback target from mmcpart ${mmcpart}\"; " \
		"else " \
			"log rec none warning \"\" 0 rollback " \
				"\"Rollback target is not ready, refusing to rollback.\"; " \
		"fi; " \
		/* reset if rollback failed: we're not booting either way... */ \
		"saveenv; reset\0" \
	"altbootcmd=" \
		"log rec none warning \"\" 0 altbootcmd " \
			"\"Counted $bootlimit consecutive unfinished boots\"; " \
		"run rollback\0" \
	"optargs=quiet\0" \
	"timeoffset=32400\0" \
	"stdin=mxc_serial\0" \
	"stdout=mxc_serial\0" \
	"stderr=mxc_serial\0" \
	"fdtautodetect=" FDT_FILE_AUTODETECT

#ifdef CONFIG_ENV_WRITEABLE_LIST
/* In this mode we define envs we want to allow overriding at run time
 * Possible flags are as follow:
 * type flags:
 *  - s: string
 *  - d: decimal
 *  - x: hexadecimal
 *  - b: boolean
 *  - i: IP address
 *  - m: MAC address
 * access flags:
 *  - a: any
 *  - r: read-only
 *  - o: write-once
 *  - c: change-default
 *  - w: writeable
 *
 *  The following example value allows:
 *  - rollback related variables
 *  - network settings (mac address)
 */
#define CFG_ENV_FLAGS_LIST_STATIC \
	"bootcount:dw,upgrade_available:bw" \
	",ethaddr:mw"
#endif

#define CONFIG_BOARD_LATE_INIT

#endif
