/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) DENX
 * Written-by: Albert ARIBAUD <albert.aribaud@3adev.fr>
 *
 * Original code (C) Copyright 2010
 * Robert Aigner (ra@spiid.net)
 */
#ifndef _EVM_H_
#define _EVM_H_


const omap3_sysinfo sysinfo = {
	DDR_DISCRETE,
	"OMAP3 Cairo board",
	"NAND",
};

/*
 * OMAP3 Cairo handheld hardware revision
 */
enum {
	OMAP3_CAIRO_BOARD_GEN_1 = 0,	/* Cairo handheld V01 */
	OMAP3_CAIRO_BOARD_GEN_2,
};

#define MUX_CAIRO() \
MUX_VAL(CONTROL_PADCONF_GPIO112, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO113, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO114, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO115, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO126, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO127, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO128, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPIO129, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D0, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_D1, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_D2, (IEN | DIS | SB_HIZ | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D3, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_D4, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_D5, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D6, (IEN | PTD | EN | SB_HIZ | SB_PD | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D7, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D8, (IEN | DIS | SB_HIZ | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D9, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_D10, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_CAM_D11, (IEN | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_FLD, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_HS, (IEN | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_PCLK, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_STROBE, (IDIS | PTU | EN | SB_HI | SB_PU | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_VS, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_WEN, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_XCLKA, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_CAM_XCLKB, (IEN | DIS | SB_HIZ | SB_PD | M7)) \
MUX_VAL(CONTROL_PADCONF_DSS_ACBIAS, (IDIS | PTD | EN | SB_HIZ | SB_PD | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA0, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA1, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA2, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA3, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA4, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA5, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA6, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA7, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA8, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA9, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA10, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA11, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA12, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA13, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA14, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA15, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA16, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA17, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA18, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA19, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA20, (IDIS | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA21, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA22, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_DATA23, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_HSYNC, (IDIS | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_PCLK, (IDIS | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_DSS_VSYNC, (IDIS | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_ETK_CLK_ES2, (IDIS | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_CTL_ES2, (IDIS | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D0_ES2, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D1_ES2, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D2_ES2, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D3_ES2, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D4_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D5_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D6_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D7_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D8_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D9_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D10_ES2, (IDIS | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D11_ES2, (IDIS | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D12_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D13_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D14_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_ETK_D15_ES2, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A1, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A2, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A3, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A4, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A5, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A6, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A7, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A8, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A9, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A10, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_A11, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_CLK, (IEN | DIS | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D0, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D1, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D2, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D3, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D4, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D5, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D6, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D7, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D8, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D9, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D10, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D11, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D12, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D13, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D14, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_D15, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NADV_ALE, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NBE0_CLE, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NBE1, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS0, (IDIS | DIS | SB_HIZ | SB_PD | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS1, (IEN | DIS | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS2, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS3, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS4, (IDIS | DIS | SB_HIZ | SB_PD | M3)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS5, (IDIS | DIS | SB_HIZ | SB_PD | M3)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS6, (IDIS | DIS | SB_HIZ | SB_PD | M3)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NCS7, (IDIS | DIS | SB_HIZ | SB_PD | M3)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NOE, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NWE, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_NWP, (IDIS | DIS | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_WAIT0, (IEN | DIS | SB_HIZ | M0)) \
MUX_VAL(CONTROL_PADCONF_GPMC_WAIT1, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_WAIT2, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_GPMC_WAIT3, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_HDQ_SIO, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_CLK, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA0, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA1, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA2, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA3, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA4, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA5, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA6, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DATA7, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_DIR, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_NXT, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_HSUSB0_STP, (IDIS | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_I2C1_SCL, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_I2C1_SDA, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_I2C2_SCL, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_I2C2_SDA, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_I2C3_SCL, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_I2C3_SDA, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_I2C4_SCL, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_I2C4_SDA, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_JTAG_EMU0, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_EMU1, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_NTRST, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_RTCK, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_TCK, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_TDI, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_TDO, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_JTAG_TMS, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_MCBSP_CLKS, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_CLKR, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_CLKX, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_DR, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_DX, (IEN | DIS | SB_HIZ | SB_PD | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_FSR, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP1_FSX, (IEN | DIS | SB_HIZ | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP2_CLKX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP2_DR, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP2_DX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP2_FSX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP3_CLKX, (IDIS | DIS | SB_HIZ | SB_PU | M1)) \
MUX_VAL(CONTROL_PADCONF_MCBSP3_DR, (IDIS | PTD | EN | SB_LOW | SB_PD | M4)) \
MUX_VAL(CONTROL_PADCONF_MCBSP3_DX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP3_FSX, (IEN | PTU | EN | SB_HIZ | SB_PU | M1)) \
MUX_VAL(CONTROL_PADCONF_MCBSP4_CLKX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP4_DR, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP4_DX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCBSP4_FSX, (IEN | PTD | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_CLK, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_CS0, (IEN | PTU | EN | SB_HIZ | SB_PD | M0)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_CS1, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_CS2, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_CS3, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_SIMO, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_MCSPI1_SOMI, (IEN | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_MCSPI2_CLK, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MCSPI2_CS0, (IEN | PTU | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MCSPI2_CS1, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MCSPI2_SIMO, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MCSPI2_SOMI, (IEN | PTD | EN | M3)) \
MUX_VAL(CONTROL_PADCONF_MMC1_CLK, (IDIS | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC1_CMD, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC1_DAT0, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC1_DAT1, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC1_DAT2, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC1_DAT3, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_CLK, (IEN | PTD | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_CMD, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT0, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT1, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT2, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT3, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT4, (IDIS | DIS | SB_HIZ | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT5, (IDIS | DIS | SB_HIZ | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT6, (IDIS | DIS | SB_HIZ | M0)) \
MUX_VAL(CONTROL_PADCONF_MMC2_DAT7, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A0, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A1, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A2, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A3, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A4, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A5, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A6, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A7, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A8, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A9, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A10, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A11, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A12, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A13, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_A14, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_BA0, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_BA1, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_CKE0, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_CKE1, (IDIS | DIS | M7)) \
MUX_VAL(CONTROL_PADCONF_SDRC_CLK, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D0, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D1, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D2, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D3, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D4, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D5, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D6, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D7, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D8, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D9, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D10, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D11, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D12, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D13, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D14, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D15, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D16, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D17, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D18, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D19, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D20, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D21, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D22, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D23, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D24, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D25, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D26, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D27, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D28, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D29, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D30, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_D31, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DM0, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DM1, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DM2, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DM3, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DQS0, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DQS1, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DQS2, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_DQS3, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NCAS, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NCLK, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NCS0, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NCS1, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NRAS, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SDRC_NWE, (IDIS | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_32K, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT0, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT1, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT2, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT3, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT4, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT5, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_BOOT6, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_CLKOUT1, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_CLKOUT2, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_CLKREQ, (IEN | DIS | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_NIRQ, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_NRESWARM, (IEN | PTU | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_SYS_OFF_MODE, (IDIS | PTD | EN | M0)) \
MUX_VAL(CONTROL_PADCONF_UART1_CTS, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART1_RTS, (IDIS | DIS | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART1_RX, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART1_TX, (IDIS | DIS | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART2_CTS, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_UART2_RTS, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_UART2_RX, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_UART2_TX, (IEN | PTU | EN | M7)) \
MUX_VAL(CONTROL_PADCONF_UART3_CTS_RCTX, \
	(IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART3_RTS_SD, (IDIS | DIS | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART3_RX_IRRX, (IEN | PTU | EN | SB_HIZ | SB_PU | M0)) \
MUX_VAL(CONTROL_PADCONF_UART3_TX_IRTX, (IDIS | DIS | SB_HIZ | SB_PU | M0)) \

#endif
