// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2017,2019-2020 NXP
 *
 * Contains firmware in octet string format for SJA1105.
 *
 */

#include <common.h>
#include <errno.h>
#include <sja1105_cfg.h>

#define SJA1105_VAL_DEVICEID_1_2              0xAE00030EUL

/*
 * Obtained from encoding the SCH-29288 EVB 1-2 configuration firmware from
 * sja1105 driver, found in Auto Linux BSP14.0.
 * To regenerate this, use the file with the following command:
 * 'xxd -i <filename>'
 */
unsigned char sja1105_cfg_mra2lt_1_2_bin[] = {
	0x0e, 0x03, 0x00, 0xae, 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00,
	0x2b, 0xa0, 0x1c, 0x9a, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x25, 0x04,
	0xc0, 0x8a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0xea, 0x9b, 0x8c, 0x4c, 0x00, 0x00, 0x00, 0x06, 0x50, 0x00, 0x00, 0x00,
	0x6b, 0x25, 0x6f, 0x21, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x07,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x07,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x07,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0b,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0b,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x13, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x13,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x13, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x13, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x13,
	0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x13, 0x00, 0x00, 0xfb, 0xfe,
	0xff, 0xff, 0xff, 0x13, 0x00, 0x00, 0xfb, 0xfe, 0xff, 0xff, 0xff, 0x13,
	0xc1, 0x63, 0x99, 0xe9, 0x00, 0x00, 0x00, 0x07, 0x02, 0x00, 0x00, 0x00,
	0xf2, 0xcb, 0x0b, 0x7d, 0x00, 0x00, 0x00, 0x58, 0x11, 0xf0, 0x3f, 0x00,
	0x75, 0x32, 0xfe, 0x68, 0x00, 0x00, 0x00, 0x08, 0x1a, 0x00, 0x00, 0x00,
	0x53, 0x23, 0xf6, 0x6a, 0x00, 0x00, 0x00, 0x10, 0x8d, 0xf5, 0xbd, 0xf7,
	0x00, 0x00, 0x00, 0x10, 0x8d, 0xf5, 0x7b, 0xef, 0x00, 0x00, 0x00, 0x10,
	0x8d, 0xf5, 0xf7, 0xde, 0x00, 0x00, 0x00, 0x10, 0x8d, 0xf5, 0xef, 0xbd,
	0x00, 0x00, 0x00, 0x10, 0x8d, 0xf5, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x24, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x24, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6,
	0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x92, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xda, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c,
	0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0x00,
	0x06, 0xe0, 0x42, 0x67, 0x00, 0x00, 0x00, 0x09, 0x28, 0x00, 0x00, 0x00,
	0xc9, 0x3a, 0xb4, 0x0d, 0x00, 0x00, 0x00, 0x80, 0x03, 0xac, 0x08, 0xfe,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x01, 0xfc, 0x08, 0xe4, 0x4f, 0x40, 0xbf,
	0x02, 0xfb, 0x17, 0xe0, 0xcf, 0x40, 0xff, 0x06, 0xfc, 0x3b, 0xf0, 0xff,
	0x00, 0x00, 0x00, 0x80, 0x03, 0xac, 0x08, 0xfe, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x01, 0xfc, 0x08, 0xe4, 0x4f, 0x40, 0xbf, 0x02, 0xfb, 0x17, 0xe0,
	0xcf, 0x40, 0xff, 0x06, 0xfc, 0x3b, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x80,
	0x03, 0xac, 0x08, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x04, 0x01, 0xfc, 0x08,
	0xe4, 0x4f, 0x40, 0xbf, 0x02, 0xfb, 0x17, 0xe0, 0xcf, 0x40, 0xff, 0x06,
	0xfc, 0x3b, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x80, 0x03, 0xac, 0x08, 0xfe,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x01, 0xfc, 0x08, 0xe4, 0x4f, 0x40, 0xbf,
	0x02, 0xfb, 0x17, 0xe0, 0xcf, 0x40, 0xff, 0x06, 0xfc, 0x3b, 0xf0, 0xff,
	0x00, 0x00, 0x00, 0x80, 0x03, 0xac, 0x08, 0xfe, 0x01, 0x00, 0x00, 0x00,
	0x02, 0x01, 0xfc, 0x08, 0xe4, 0x4f, 0x40, 0xbf, 0x02, 0xfb, 0x17, 0xe0,
	0xcf, 0x40, 0xff, 0x06, 0xfc, 0x3b, 0xf0, 0xff, 0x96, 0x83, 0xd7, 0x5d,
	0x00, 0x00, 0x00, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x8f, 0x8c, 0xd0, 0x12,
	0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x04,
	0x20, 0x00, 0x01, 0x00, 0x78, 0x1d, 0xe3, 0x34, 0x00, 0x00, 0x00, 0x0e,
	0x03, 0x00, 0x00, 0x00, 0xe6, 0xce, 0xa7, 0xc8, 0x00, 0xc0, 0x71, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb9, 0x04, 0xf7, 0xc3,
	0x00, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x00, 0xbc, 0xdf, 0xa0, 0x8a,
	0x00, 0x00, 0x00, 0x80, 0xfb, 0x3f, 0xf0, 0x0d, 0x98, 0x80, 0xb7, 0xb2,
	0xf7, 0x0d, 0x98, 0x40, 0x8c, 0x31, 0xc9, 0xe6, 0x00, 0x00, 0x00, 0x11,
	0x0b, 0x00, 0x00, 0x00, 0x5a, 0xe6, 0xa3, 0xef, 0x00, 0x00, 0xc0, 0x01,
	0x00, 0x00, 0x04, 0x42, 0x45, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x37, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x45, 0xd8, 0x05, 0x85, 0xce, 0x00, 0x00, 0x00, 0x4e,
	0x01, 0x00, 0x00, 0x00, 0x24, 0x5e, 0x5d, 0x3a, 0x00, 0x00, 0x0c, 0x48,
	0xb2, 0x59, 0xf6, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x8c, 0x09, 0xc5, 0x7f
};

static struct sja1105_cfgs_s sja1105_cfgs_m[] = {
	{SJA1105_VAL_DEVICEID_1_2, 0, ARRAY_SIZE(sja1105_cfg_mra2lt_1_2_bin),
		sja1105_cfg_mra2lt_1_2_bin},
	{0x0UL, 0,   0, NULL}
};

struct sja1105_cfgs_s *sja1105_cfgs = &sja1105_cfgs_m[0];
