/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright (C) 2016-2018 Intel Corporation <www.intel.com>
 *
 */

#ifndef _HANDOFF_S10_H_
#define _HANDOFF_S10_H_

/*
 * Offset for HW handoff from Quartus tools
 */
#define S10_HANDOFF_BASE		0xFFE3F000
#define S10_HANDOFF_MUX		(S10_HANDOFF_BASE + 0x10)
#define S10_HANDOFF_IOCTL		(S10_HANDOFF_BASE + 0x1A0)
#define S10_HANDOFF_FPGA		(S10_HANDOFF_BASE + 0x330)
#define S10_HANODFF_DELAY		(S10_HANDOFF_BASE + 0x3F0)
#define S10_HANDOFF_CLOCK		(S10_HANDOFF_BASE + 0x580)
#define S10_HANDOFF_MISC		(S10_HANDOFF_BASE + 0x610)
#define S10_HANDOFF_MAGIC_MUX	0x504D5558
#define S10_HANDOFF_MAGIC_IOCTL	0x494F4354
#define S10_HANDOFF_MAGIC_FPGA	0x46504741
#define S10_HANDOFF_MAGIC_DELAY	0x444C4159
#define S10_HANDOFF_MAGIC_CLOCK	0x434C4B53
#define S10_HANDOFF_MAGIC_MISC	0x4D495343
#define S10_HANDOFF_OFFSET_LENGTH	0x4
#define S10_HANDOFF_OFFSET_DATA	0x10

#ifdef CONFIG_TARGET_SOCFPGA_STRATIX10
#define HANDOFF_CLOCK_OSC	(S10_HANDOFF_BASE + 0x608)
#define HANDOFF_CLOCK_FPGA	(S10_HANDOFF_BASE + 0x60C)
#else
#define HANDOFF_CLOCK_OSC	(S10_HANDOFF_BASE + 0x5fc)
#define HANDOFF_CLOCK_FPGA	(S10_HANDOFF_BASE + 0x600)
#endif

#define S10_HANDOFF_SIZE	4096

#endif /* _HANDOFF_S10_H_ */
