/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 *
 * Author:
 *	Peng Fan <Peng.Fan@freescale.com>
 */

#ifndef __ARCH_ARM_MACH_MX7_CCM_REGS_H__
#define __ARCH_ARM_MACH_MX7_CCM_REGS_H__

#include <asm/arch/imx-regs.h>
#include <asm/io.h>

#define	CCM_GPR0_OFFSET			0x0
#define	CCM_OBSERVE0_OFFSET		0x0400
#define	CCM_SCTRL0_OFFSET		0x0800
#define	CCM_CCGR0_OFFSET		0x4000
#define	CCM_ROOT0_TARGET_OFFSET		0x8000

#ifndef __ASSEMBLY__

struct mxc_ccm_ccgr {
	uint32_t ccgr;
	uint32_t ccgr_set;
	uint32_t ccgr_clr;
	uint32_t ccgr_tog;
};

struct mxc_ccm_root_slice {
	uint32_t target_root;
	uint32_t target_root_set;
	uint32_t target_root_clr;
	uint32_t target_root_tog;
	uint32_t reserved_0[4];
	uint32_t post;
	uint32_t post_root_set;
	uint32_t post_root_clr;
	uint32_t post_root_tog;
	uint32_t pre;
	uint32_t pre_root_set;
	uint32_t pre_root_clr;
	uint32_t pre_root_tog;
	uint32_t reserved_1[12];
	uint32_t access_ctrl;
	uint32_t access_ctrl_root_set;
	uint32_t access_ctrl_root_clr;
	uint32_t access_ctrl_root_tog;
};

/** CCM - Peripheral register structure */
struct mxc_ccm_reg {
	uint32_t gpr0;
	uint32_t gpr0_set;
	uint32_t gpr0_clr;
	uint32_t gpr0_tog;
	uint32_t reserved_0[4092];
	struct mxc_ccm_ccgr ccgr_array[191];	/* offset 0x4000 */
	uint32_t reserved_1[3332];
	struct mxc_ccm_root_slice root[125];	/* offset 0x8000 */

};

struct mxc_ccm_anatop_reg {
	uint32_t ctrl_24m;			/* offset 0x0000 */
	uint32_t ctrl_24m_set;
	uint32_t ctrl_24m_clr;
	uint32_t ctrl_24m_tog;
	uint32_t rcosc_config0;			/* offset 0x0010 */
	uint32_t rcosc_config0_set;
	uint32_t rcosc_config0_clr;
	uint32_t rcosc_config0_tog;
	uint32_t rcosc_config1;			/* offset 0x0020 */
	uint32_t rcosc_config1_set;
	uint32_t rcosc_config1_clr;
	uint32_t rcosc_config1_tog;
	uint32_t rcosc_config2;			/* offset 0x0030 */
	uint32_t rcosc_config2_set;
	uint32_t rcosc_config2_clr;
	uint32_t rcosc_config2_tog;
	uint8_t reserved_0[16];
	uint32_t osc_32k;			/* offset 0x0050 */
	uint32_t osc_32k_set;
	uint32_t osc_32k_clr;
	uint32_t osc_32k_tog;
	uint32_t pll_arm;			/* offset 0x0060 */
	uint32_t pll_arm_set;
	uint32_t pll_arm_clr;
	uint32_t pll_arm_tog;
	uint32_t pll_ddr;			/* offset 0x0070 */
	uint32_t pll_ddr_set;
	uint32_t pll_ddr_clr;
	uint32_t pll_ddr_tog;
	uint32_t pll_ddr_ss;			/* offset 0x0080 */
	uint8_t reserved_1[12];
	uint32_t pll_ddr_num;			/* offset 0x0090 */
	uint8_t reserved_2[12];
	uint32_t pll_ddr_denom;			/* offset 0x00a0 */
	uint8_t reserved_3[12];
	uint32_t pll_480;			/* offset 0x00b0 */
	uint32_t pll_480_set;
	uint32_t pll_480_clr;
	uint32_t pll_480_tog;
	uint32_t pfd_480a;			/* offset 0x00c0 */
	uint32_t pfd_480a_set;
	uint32_t pfd_480a_clr;
	uint32_t pfd_480a_tog;
	uint32_t pfd_480b;			/* offset 0x00d0 */
	uint32_t pfd_480b_set;
	uint32_t pfd_480b_clr;
	uint32_t pfd_480b_tog;
	uint32_t pll_enet;			/* offset 0x00e0 */
	uint32_t pll_enet_set;
	uint32_t pll_enet_clr;
	uint32_t pll_enet_tog;
	uint32_t pll_audio;			/* offset 0x00f0 */
	uint32_t pll_audio_set;
	uint32_t pll_audio_clr;
	uint32_t pll_audio_tog;
	uint32_t pll_audio_ss;			/* offset 0x0100 */
	uint8_t reserved_4[12];
	uint32_t pll_audio_num;			/* offset 0x0110 */
	uint8_t reserved_5[12];
	uint32_t pll_audio_denom;		/* offset 0x0120 */
	uint8_t reserved_6[12];
	uint32_t pll_video;			/* offset 0x0130 */
	uint32_t pll_video_set;
	uint32_t pll_video_clr;
	uint32_t pll_video_tog;
	uint32_t pll_video_ss;			/* offset 0x0140 */
	uint8_t reserved_7[12];
	uint32_t pll_video_num;			/* offset 0x0150 */
	uint8_t reserved_8[12];
	uint32_t pll_video_denom;		/* offset 0x0160 */
	uint8_t reserved_9[12];
	uint32_t clk_misc0;			/* offset 0x0170 */
	uint32_t clk_misc0_set;
	uint32_t clk_misc0_clr;
	uint32_t clk_misc0_tog;
	uint32_t clk_rsvd;			/* offset 0x0180 */
	uint8_t reserved_10[124];
	uint32_t reg_1p0a;			/* offset 0x0200 */
	uint32_t reg_1p0a_set;
	uint32_t reg_1p0a_clr;
	uint32_t reg_1p0a_tog;
	uint32_t reg_1p0d;			/* offsest 0x0210 */
	uint32_t reg_1p0d_set;
	uint32_t reg_1p0d_clr;
	uint32_t reg_1p0d_tog;
	uint32_t reg_hsic_1p2;			/* offset 0x0220 */
	uint32_t reg_hsic_1p2_set;
	uint32_t reg_hsic_1p2_clr;
	uint32_t reg_hsic_1p2_tog;
	uint32_t reg_lpsr_1p0;			/* offset 0x0230 */
	uint32_t reg_lpsr_1p0_set;
	uint32_t reg_lpsr_1p0_clr;
	uint32_t reg_lpsr_1p0_tog;
	uint32_t reg_3p0;			/* offset 0x0240 */
	uint32_t reg_3p0_set;
	uint32_t reg_3p0_clr;
	uint32_t reg_3p0_tog;
	uint32_t reg_snvs;			/* offset 0x0250 */
	uint32_t reg_snvs_set;
	uint32_t reg_snvs_clr;
	uint32_t reg_snvs_tog;
	uint32_t analog_debug_misc0;		/* offset 0x0260 */
	uint32_t analog_debug_misc0_set;
	uint32_t analog_debug_misc0_clr;
	uint32_t analog_debug_misc0_tog;
	uint32_t ref;				/* offset 0x0270 */
	uint32_t ref_set;
	uint32_t ref_clr;
	uint32_t ref_tog;
	uint8_t reserved_11[128];
	uint32_t tempsense0;			/* offset 0x0300 */
	uint32_t tempsense0_set;
	uint32_t tempsense0_clr;
	uint32_t tempsense0_tog;
	uint32_t tempsense1;			/* offset 0x0310 */
	uint32_t tempsense1_set;
	uint32_t tempsense1_clr;
	uint32_t tempsense1_tog;
	uint32_t tempsense_trim;		/* offset 0x0320 */
	uint32_t tempsense_trim_set;
	uint32_t tempsense_trim_clr;
	uint32_t tempsense_trim_tog;
	uint32_t lowpwr_ctrl;			/* offset 0x0330 */
	uint32_t lowpwr_ctrl_set;
	uint32_t lowpwr_ctrl_clr;
	uint32_t lowpwr_ctrl_tog;
	uint32_t snvs_tamper_offset_ctrl;	/* offset 0x0340 */
	uint32_t snvs_tamper_offset_ctrl_set;
	uint32_t snvs_tamper_offset_ctrl_clr;
	uint32_t snvs_tamper_offset_ctrl_tog;
	uint32_t snvs_tamper_pull_ctrl;		/* offset 0x0350 */
	uint32_t snvs_tamper_pull_ctrl_set;
	uint32_t snvs_tamper_pull_ctrl_clr;
	uint32_t snvs_tamper_pull_ctrl_tog;
	uint32_t snvs_test;			/* offset 0x0360 */
	uint32_t snvs_test_set;
	uint32_t snvs_test_clr;
	uint32_t snvs_test_tog;
	uint32_t snvs_tamper_trim_ctrl;		/* offset 0x0370 */
	uint32_t snvs_tamper_trim_ctrl_set;
	uint32_t snvs_tamper_trim_ctrl_ctrl;
	uint32_t snvs_tamper_trim_ctrl_tog;
	uint32_t snvs_misc_ctrl;		/* offset 0x0380 */
	uint32_t snvs_misc_ctrl_set;
	uint32_t snvs_misc_ctrl_clr;
	uint32_t snvs_misc_ctrl_tog;
	uint8_t reserved_12[112];
	uint32_t misc;				/* offset 0x0400 */
	uint8_t reserved_13[252];
	uint32_t adc0;				/* offset 0x0500 */
	uint8_t reserved_14[12];
	uint32_t adc1;				/* offset 0x0510 */
	uint8_t reserved_15[748];
	uint32_t digprog;			/* offset 0x0800 */
};
#endif

#define ANADIG_CLK_MISC0_PFD_480_AUTOGATE_EN_MASK	(0x01 << 17)

#define ANADIG_PLL_LOCK					0x80000000

#define ANADIG_PLL_ARM_PWDN_MASK			(0x01 << 12)
#define ANADIG_PLL_480_PWDN_MASK			(0x01 << 12)
#define ANADIG_PLL_DDR_PWDN_MASK			(0x01 << 20)
#define ANADIG_PLL_ENET_PWDN_MASK			(0x01 << 5)
#define ANADIG_PLL_VIDEO_PWDN_MASK			(0x01 << 12)


#define ANATOP_PFD480B_PFD4_FRAC_MASK			0x0000003f
#define ANATOP_PFD480B_PFD4_FRAC_320M_VAL		0x0000001B
#define ANATOP_PFD480B_PFD4_FRAC_392M_VAL		0x00000016
#define ANATOP_PFD480B_PFD4_FRAC_432M_VAL		0x00000014

/* PLL_ARM Bit Fields */
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_MASK		0x7F
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_SHIFT		0
#define CCM_ANALOG_PLL_ARM_HALF_LF_MASK			0x80
#define CCM_ANALOG_PLL_ARM_HALF_LF_SHIFT		7
#define CCM_ANALOG_PLL_ARM_DOUBLE_LF_MASK		0x100
#define CCM_ANALOG_PLL_ARM_DOUBLE_LF_SHIFT		8
#define CCM_ANALOG_PLL_ARM_HALF_CP_MASK			0x200
#define CCM_ANALOG_PLL_ARM_HALF_CP_SHIFT		9
#define CCM_ANALOG_PLL_ARM_DOUBLE_CP_MASK		0x400
#define CCM_ANALOG_PLL_ARM_DOUBLE_CP_SHIFT		10
#define CCM_ANALOG_PLL_ARM_HOLD_RING_OFF_MASK		0x800
#define CCM_ANALOG_PLL_ARM_HOLD_RING_OFF_SHIFT		11
#define CCM_ANALOG_PLL_ARM_POWERDOWN_MASK		0x1000
#define CCM_ANALOG_PLL_ARM_POWERDOWN_SHIFT		12
#define CCM_ANALOG_PLL_ARM_ENABLE_CLK_MASK		0x2000
#define CCM_ANALOG_PLL_ARM_ENABLE_CLK_SHIFT		13
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_MASK		0xC000
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_SHIFT		14
#define CCM_ANALOG_PLL_ARM_BYPASS_MASK			0x10000
#define CCM_ANALOG_PLL_ARM_BYPASS_SHIFT			16
#define CCM_ANALOG_PLL_ARM_LVDS_SEL_MASK		0x20000
#define CCM_ANALOG_PLL_ARM_LVDS_SEL_SHIFT		17
#define CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL_MASK		0x40000
#define CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL_SHIFT		18
#define CCM_ANALOG_PLL_ARM_PLL_SEL_MASK			0x80000
#define CCM_ANALOG_PLL_ARM_PLL_SEL_SHIFT		19
#define CCM_ANALOG_PLL_ARM_PLL_ARM_OVERRIDE_MASK	0x100000
#define CCM_ANALOG_PLL_ARM_PLL_ARM_OVERRIDE_SHIFT	20
#define CCM_ANALOG_PLL_ARM_RSVD0_MASK			0x7FE00000
#define CCM_ANALOG_PLL_ARM_RSVD0_SHIFT			21
#define CCM_ANALOG_PLL_ARM_LOCK_MASK			0x80000000
#define CCM_ANALOG_PLL_ARM_LOCK_SHIFT			31

/* PLL_DDR Bit Fields */
#define CCM_ANALOG_PLL_DDR_DIV_SELECT_MASK		0x7F
#define CCM_ANALOG_PLL_DDR_DIV_SELECT_SHIFT		0
#define CCM_ANALOG_PLL_DDR_HALF_LF_MASK			0x80
#define CCM_ANALOG_PLL_DDR_HALF_LF_SHIFT		7
#define CCM_ANALOG_PLL_DDR_DOUBLE_LF_MASK		0x100
#define CCM_ANALOG_PLL_DDR_DOUBLE_LF_SHIFT		8
#define CCM_ANALOG_PLL_DDR_HALF_CP_MASK			0x200
#define CCM_ANALOG_PLL_DDR_HALF_CP_SHIFT		9
#define CCM_ANALOG_PLL_DDR_DOUBLE_CP_MASK		0x400
#define CCM_ANALOG_PLL_DDR_DOUBLE_CP_SHIFT		10
#define CCM_ANALOG_PLL_DDR_HOLD_RING_OFF_MASK		0x800
#define CCM_ANALOG_PLL_DDR_HOLD_RING_OFF_SHIFT		11
#define CCM_ANALOG_PLL_DDR_DIV2_ENABLE_CLK_MASK		0x1000
#define CCM_ANALOG_PLL_DDR_DIV2_ENABLE_CLK_SHIFT	12
#define CCM_ANALOG_PLL_DDR_ENABLE_CLK_MASK		0x2000
#define CCM_ANALOG_PLL_DDR_ENABLE_CLK_SHIFT		13
#define CCM_ANALOG_PLL_DDR_BYPASS_CLK_SRC_MASK		0xC000
#define CCM_ANALOG_PLL_DDR_BYPASS_CLK_SRC_SHIFT		14
#define CCM_ANALOG_PLL_DDR_BYPASS_MASK			0x10000
#define CCM_ANALOG_PLL_DDR_BYPASS_SHIFT			16
#define CCM_ANALOG_PLL_DDR_DITHER_ENABLE_MASK		0x20000
#define CCM_ANALOG_PLL_DDR_DITHER_ENABLE_SHIFT		17
#define CCM_ANALOG_PLL_DDR_PFD_OFFSET_EN_MASK		0x40000
#define CCM_ANALOG_PLL_DDR_PFD_OFFSET_EN_SHIFT		18
#define CCM_ANALOG_PLL_DDR_PLL_DDR_OVERRIDE_MASK	0x80000
#define CCM_ANALOG_PLL_DDR_PLL_DDR_OVERRIDE_SHIFT	19
#define CCM_ANALOG_PLL_DDR_POWERDOWN_MASK		0x100000
#define CCM_ANALOG_PLL_DDR_POWERDOWN_SHIFT		20
#define CCM_ANALOG_PLL_DDR_TEST_DIV_SELECT_MASK		0x600000
#define CCM_ANALOG_PLL_DDR_TEST_DIV_SELECT_SHIFT	21
#define CCM_ANALOG_PLL_DDR_RSVD1_MASK			0x7F800000
#define CCM_ANALOG_PLL_DDR_RSVD1_SHIFT			23
#define CCM_ANALOG_PLL_DDR_LOCK_MASK			0x80000000
#define CCM_ANALOG_PLL_DDR_LOCK_SHIFT			31

/* PLL_480 Bit Fields */
#define CCM_ANALOG_PLL_480_DIV_SELECT_MASK		0x1
#define CCM_ANALOG_PLL_480_DIV_SELECT_SHIFT		0
#define CCM_ANALOG_PLL_480_RSVD0_MASK			0xE
#define CCM_ANALOG_PLL_480_RSVD0_SHIFT			1
#define CCM_ANALOG_PLL_480_MAIN_DIV1_CLKGATE_MASK	0x10
#define CCM_ANALOG_PLL_480_MAIN_DIV1_CLKGATE_SHIFT	4
#define CCM_ANALOG_PLL_480_MAIN_DIV2_CLKGATE_MASK	0x20
#define CCM_ANALOG_PLL_480_MAIN_DIV2_CLKGATE_SHIFT	5
#define CCM_ANALOG_PLL_480_MAIN_DIV4_CLKGATE_MASK	0x40
#define CCM_ANALOG_PLL_480_MAIN_DIV4_CLKGATE_SHIFT	6
#define CCM_ANALOG_PLL_480_HALF_LF_MASK			0x80
#define CCM_ANALOG_PLL_480_HALF_LF_SHIFT		7
#define CCM_ANALOG_PLL_480_DOUBLE_LF_MASK		0x100
#define CCM_ANALOG_PLL_480_DOUBLE_LF_SHIFT		8
#define CCM_ANALOG_PLL_480_HALF_CP_MASK			0x200
#define CCM_ANALOG_PLL_480_HALF_CP_SHIFT		9
#define CCM_ANALOG_PLL_480_DOUBLE_CP_MASK		0x400
#define CCM_ANALOG_PLL_480_DOUBLE_CP_SHIFT		10
#define CCM_ANALOG_PLL_480_HOLD_RING_OFF_MASK		0x800
#define CCM_ANALOG_PLL_480_HOLD_RING_OFF_SHIFT		11
#define CCM_ANALOG_PLL_480_POWERDOWN_MASK		0x1000
#define CCM_ANALOG_PLL_480_POWERDOWN_SHIFT		12
#define CCM_ANALOG_PLL_480_ENABLE_CLK_MASK		0x2000
#define CCM_ANALOG_PLL_480_ENABLE_CLK_SHIFT		13
#define CCM_ANALOG_PLL_480_BYPASS_CLK_SRC_MASK		0xC000
#define CCM_ANALOG_PLL_480_BYPASS_CLK_SRC_SHIFT		14
#define CCM_ANALOG_PLL_480_BYPASS_MASK			0x10000
#define CCM_ANALOG_PLL_480_BYPASS_SHIFT			16
#define CCM_ANALOG_PLL_480_PLL_480_OVERRIDE_MASK	0x20000
#define CCM_ANALOG_PLL_480_PLL_480_OVERRIDE_SHIFT	17
#define CCM_ANALOG_PLL_480_PFD0_OVERRIDE_MASK		0x40000
#define CCM_ANALOG_PLL_480_PFD0_OVERRIDE_SHIFT		18
#define CCM_ANALOG_PLL_480_PFD1_OVERRIDE_MASK		0x80000
#define CCM_ANALOG_PLL_480_PFD1_OVERRIDE_SHIFT		19
#define CCM_ANALOG_PLL_480_PFD2_OVERRIDE_MASK		0x100000
#define CCM_ANALOG_PLL_480_PFD2_OVERRIDE_SHIFT		20
#define CCM_ANALOG_PLL_480_PFD3_OVERRIDE_MASK		0x200000
#define CCM_ANALOG_PLL_480_PFD3_OVERRIDE_SHIFT		21
#define CCM_ANALOG_PLL_480_PFD4_OVERRIDE_MASK		0x400000
#define CCM_ANALOG_PLL_480_PFD4_OVERRIDE_SHIFT		22
#define CCM_ANALOG_PLL_480_PFD5_OVERRIDE_MASK		0x800000
#define CCM_ANALOG_PLL_480_PFD5_OVERRIDE_SHIFT		23
#define CCM_ANALOG_PLL_480_PFD6_OVERRIDE_MASK		0x1000000
#define CCM_ANALOG_PLL_480_PFD6_OVERRIDE_SHIFT		24
#define CCM_ANALOG_PLL_480_PFD7_OVERRIDE_MASK		0x2000000
#define CCM_ANALOG_PLL_480_PFD7_OVERRIDE_SHIFT		25
#define CCM_ANALOG_PLL_480_PFD0_DIV2_CLKGATE_MASK	0x4000000
#define CCM_ANALOG_PLL_480_PFD0_DIV2_CLKGATE_SHIFT	26
#define CCM_ANALOG_PLL_480_PFD1_DIV2_CLKGATE_MASK	0x8000000
#define CCM_ANALOG_PLL_480_PFD1_DIV2_CLKGATE_SHIFT	27
#define CCM_ANALOG_PLL_480_PFD2_DIV2_CLKGATE_MASK	0x10000000
#define CCM_ANALOG_PLL_480_PFD2_DIV2_CLKGATE_SHIFT	28
#define CCM_ANALOG_PLL_480_RSVD1_MASK			0x60000000
#define CCM_ANALOG_PLL_480_RSVD1_SHIFT			29
#define CCM_ANALOG_PLL_480_LOCK_MASK			0x80000000
#define CCM_ANALOG_PLL_480_LOCK_SHIFT			31

/* PFD_480A Bit Fields */
#define CCM_ANALOG_PFD_480A_PFD0_FRAC_MASK		0x3F
#define CCM_ANALOG_PFD_480A_PFD0_FRAC_SHIFT		0
#define CCM_ANALOG_PFD_480A_PFD0_STABLE_MASK		0x40
#define CCM_ANALOG_PFD_480A_PFD0_STABLE_SHIFT		6
#define CCM_ANALOG_PFD_480A_PFD0_DIV1_CLKGATE_MASK	0x80
#define CCM_ANALOG_PFD_480A_PFD0_DIV1_CLKGATE_SHIFT	7
#define CCM_ANALOG_PFD_480A_PFD1_FRAC_MASK		0x3F00
#define CCM_ANALOG_PFD_480A_PFD1_FRAC_SHIFT		8
#define CCM_ANALOG_PFD_480A_PFD1_STABLE_MASK		0x4000
#define CCM_ANALOG_PFD_480A_PFD1_STABLE_SHIFT		14
#define CCM_ANALOG_PFD_480A_PFD1_DIV1_CLKGATE_MASK	0x8000
#define CCM_ANALOG_PFD_480A_PFD1_DIV1_CLKGATE_SHIFT	15
#define CCM_ANALOG_PFD_480A_PFD2_FRAC_MASK		0x3F0000
#define CCM_ANALOG_PFD_480A_PFD2_FRAC_SHIFT		16
#define CCM_ANALOG_PFD_480A_PFD2_STABLE_MASK		0x400000
#define CCM_ANALOG_PFD_480A_PFD2_STABLE_SHIFT		22
#define CCM_ANALOG_PFD_480A_PFD2_DIV1_CLKGATE_MASK	0x800000
#define CCM_ANALOG_PFD_480A_PFD2_DIV1_CLKGATE_SHIFT	23
#define CCM_ANALOG_PFD_480A_PFD3_FRAC_MASK		0x3F000000
#define CCM_ANALOG_PFD_480A_PFD3_FRAC_SHIFT		24
#define CCM_ANALOG_PFD_480A_PFD3_STABLE_MASK		0x40000000
#define CCM_ANALOG_PFD_480A_PFD3_STABLE_SHIFT		30
#define CCM_ANALOG_PFD_480A_PFD3_DIV1_CLKGATE_MASK	0x80000000
#define CCM_ANALOG_PFD_480A_PFD3_DIV1_CLKGATE_SHIFT	31
/* PFD_480B Bit Fields */
#define CCM_ANALOG_PFD_480B_PFD4_FRAC_MASK		0x3F
#define CCM_ANALOG_PFD_480B_PFD4_FRAC_SHIFT		0
#define CCM_ANALOG_PFD_480B_PFD4_STABLE_MASK		0x40
#define CCM_ANALOG_PFD_480B_PFD4_STABLE_SHIFT		6
#define CCM_ANALOG_PFD_480B_PFD4_DIV1_CLKGATE_MASK	0x80
#define CCM_ANALOG_PFD_480B_PFD4_DIV1_CLKGATE_SHIFT	7
#define CCM_ANALOG_PFD_480B_PFD5_FRAC_MASK		0x3F00
#define CCM_ANALOG_PFD_480B_PFD5_FRAC_SHIFT		8
#define CCM_ANALOG_PFD_480B_PFD5_STABLE_MASK		0x4000
#define CCM_ANALOG_PFD_480B_PFD5_STABLE_SHIFT		14
#define CCM_ANALOG_PFD_480B_PFD5_DIV1_CLKGATE_MASK	0x8000
#define CCM_ANALOG_PFD_480B_PFD5_DIV1_CLKGATE_SHIFT	15
#define CCM_ANALOG_PFD_480B_PFD6_FRAC_MASK		0x3F0000
#define CCM_ANALOG_PFD_480B_PFD6_FRAC_SHIFT		16
#define CCM_ANALOG_PFD_480B_PFD6_STABLE_MASK		0x400000
#define CCM_ANALOG_PFD_480B_PFD6_STABLE_SHIFT		22
#define CCM_ANALOG_PFD_480B_PFD6_DIV1_CLKGATE_MASK	0x800000
#define CCM_ANALOG_PFD_480B_PFD6_DIV1_CLKGATE_SHIFT	23
#define CCM_ANALOG_PFD_480B_PFD7_FRAC_MASK		0x3F000000
#define CCM_ANALOG_PFD_480B_PFD7_FRAC_SHIFT		24
#define CCM_ANALOG_PFD_480B_PFD7_STABLE_MASK		0x40000000
#define CCM_ANALOG_PFD_480B_PFD7_STABLE_SHIFT		30
#define CCM_ANALOG_PFD_480B_PFD7_DIV1_CLKGATE_MASK	0x80000000
#define CCM_ANALOG_PFD_480B_PFD7_DIV1_CLKGATE_SHIFT	31

/* PLL_ENET Bit Fields */
#define CCM_ANALOG_PLL_ENET_HALF_LF_MASK		0x1
#define CCM_ANALOG_PLL_ENET_HALF_LF_SHIFT		0
#define CCM_ANALOG_PLL_ENET_DOUBLE_LF_MASK		0x2
#define CCM_ANALOG_PLL_ENET_DOUBLE_LF_SHIFT		1
#define CCM_ANALOG_PLL_ENET_HALF_CP_MASK		0x4
#define CCM_ANALOG_PLL_ENET_HALF_CP_SHIFT		2
#define CCM_ANALOG_PLL_ENET_DOUBLE_CP_MASK		0x8
#define CCM_ANALOG_PLL_ENET_DOUBLE_CP_SHIFT		3
#define CCM_ANALOG_PLL_ENET_HOLD_RING_OFF_MASK		0x10
#define CCM_ANALOG_PLL_ENET_HOLD_RING_OFF_SHIFT		4
#define CCM_ANALOG_PLL_ENET_POWERDOWN_MASK		0x20
#define CCM_ANALOG_PLL_ENET_POWERDOWN_SHIFT		5
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_25MHZ_MASK	0x40
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_25MHZ_SHIFT	6
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_40MHZ_MASK	0x80
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_40MHZ_SHIFT	7
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_50MHZ_MASK	0x100
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_50MHZ_SHIFT	8
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_100MHZ_MASK	0x200
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_100MHZ_SHIFT	9
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_125MHZ_MASK	0x400
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_125MHZ_SHIFT	10
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_250MHZ_MASK	0x800
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_250MHZ_SHIFT	11
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_500MHZ_MASK	0x1000
#define CCM_ANALOG_PLL_ENET_ENABLE_CLK_500MHZ_SHIFT	12
#define CCM_ANALOG_PLL_ENET_PLL_ENET_OVERRIDE_MASK	0x2000
#define CCM_ANALOG_PLL_ENET_PLL_ENET_OVERRIDE_SHIFT	13
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_MASK		0xC000
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_SHIFT	14
#define CCM_ANALOG_PLL_ENET_BYPASS_MASK			0x10000
#define CCM_ANALOG_PLL_ENET_BYPASS_SHIFT		16
#define CCM_ANALOG_PLL_ENET_DITHER_ENABLE_MASK		0x20000
#define CCM_ANALOG_PLL_ENET_DITHER_ENABLE_SHIFT		17
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_MASK		0x40000
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_SHIFT		18
#define CCM_ANALOG_PLL_ENET_RSVD1_MASK			0x7FF80000
#define CCM_ANALOG_PLL_ENET_RSVD1_SHIFT			19
#define CCM_ANALOG_PLL_ENET_LOCK_MASK			0x80000000
#define CCM_ANALOG_PLL_ENET_LOCK_SHIFT			31

/* PLL_AUDIO Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK     0x7Fu
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT    0
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_HALF_LF_MASK        0x80u
#define CCM_ANALOG_PLL_AUDIO_HALF_LF_SHIFT       7
#define CCM_ANALOG_PLL_AUDIO_DOUBLE_LF_MASK      0x100u
#define CCM_ANALOG_PLL_AUDIO_DOUBLE_LF_SHIFT     8
#define CCM_ANALOG_PLL_AUDIO_HALF_CP_MASK        0x200u
#define CCM_ANALOG_PLL_AUDIO_HALF_CP_SHIFT       9
#define CCM_ANALOG_PLL_AUDIO_DOUBLE_CP_MASK      0x400u
#define CCM_ANALOG_PLL_AUDIO_DOUBLE_CP_SHIFT     10
#define CCM_ANALOG_PLL_AUDIO_HOLD_RING_OFF_MASK  0x800u
#define CCM_ANALOG_PLL_AUDIO_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_MASK      0x1000u
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_SHIFT     12
#define CCM_ANALOG_PLL_AUDIO_ENABLE_CLK_MASK     0x2000u
#define CCM_ANALOG_PLL_AUDIO_ENABLE_CLK_SHIFT    13
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_MASK         0x10000u
#define CCM_ANALOG_PLL_AUDIO_BYPASS_SHIFT        16
#define CCM_ANALOG_PLL_AUDIO_DITHER_ENABLE_MASK  0x20000u
#define CCM_ANALOG_PLL_AUDIO_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_MASK  0x40000u
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_RSVD0_MASK          0x200000u
#define CCM_ANALOG_PLL_AUDIO_RSVD0_SHIFT         21
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SEL_MASK   0xC00000u
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SEL_SHIFT  22
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SEL(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_AUDIO_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_AUDIO_PLL_AUDIO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_AUDIO_PLL_AUDIO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_AUDIO_RSVD1_MASK          0x7E000000u
#define CCM_ANALOG_PLL_AUDIO_RSVD1_SHIFT         25
#define CCM_ANALOG_PLL_AUDIO_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_RSVD1_SHIFT))&CCM_ANALOG_PLL_AUDIO_RSVD1_MASK)
#define CCM_ANALOG_PLL_AUDIO_LOCK_MASK           0x80000000u
#define CCM_ANALOG_PLL_AUDIO_LOCK_SHIFT          31
/* PLL_AUDIO_SET Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_AUDIO_SET_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_AUDIO_SET_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_AUDIO_SET_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_AUDIO_SET_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_AUDIO_SET_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_AUDIO_SET_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_AUDIO_SET_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_AUDIO_SET_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_AUDIO_SET_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_SET_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_AUDIO_SET_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_SET_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_SET_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_SET_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_AUDIO_SET_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_PLL_AUDIO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_AUDIO_SET_PLL_AUDIO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_AUDIO_SET_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_AUDIO_SET_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_AUDIO_SET_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_RSVD1_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_RSVD1_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_SHIFT      31
/* PLL_AUDIO_CLR Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_AUDIO_CLR_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_AUDIO_CLR_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_AUDIO_CLR_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_AUDIO_CLR_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_AUDIO_CLR_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_AUDIO_CLR_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_AUDIO_CLR_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_AUDIO_CLR_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_AUDIO_CLR_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_CLR_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_AUDIO_CLR_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_CLR_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_CLR_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_CLR_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_AUDIO_CLR_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_PLL_AUDIO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_AUDIO_CLR_PLL_AUDIO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_AUDIO_CLR_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_AUDIO_CLR_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_AUDIO_CLR_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_RSVD1_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_RSVD1_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_SHIFT      31
/* PLL_AUDIO_TOG Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_AUDIO_TOG_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_AUDIO_TOG_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_AUDIO_TOG_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_AUDIO_TOG_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_AUDIO_TOG_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_AUDIO_TOG_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_AUDIO_TOG_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_AUDIO_TOG_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_AUDIO_TOG_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_TOG_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_AUDIO_TOG_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_TOG_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_TOG_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_TOG_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_AUDIO_TOG_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_PLL_AUDIO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_AUDIO_TOG_PLL_AUDIO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_AUDIO_TOG_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_AUDIO_TOG_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_AUDIO_TOG_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_RSVD1_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_RSVD1_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_SHIFT      31
/* PLL_AUDIO_SS Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_SS_STEP_MASK        0x7FFFu
#define CCM_ANALOG_PLL_AUDIO_SS_STEP_SHIFT       0
#define CCM_ANALOG_PLL_AUDIO_SS_STEP(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SS_STEP_SHIFT))&CCM_ANALOG_PLL_AUDIO_SS_STEP_MASK)
#define CCM_ANALOG_PLL_AUDIO_SS_ENABLE_MASK      0x8000u
#define CCM_ANALOG_PLL_AUDIO_SS_ENABLE_SHIFT     15
#define CCM_ANALOG_PLL_AUDIO_SS_STOP_MASK        0xFFFF0000u
#define CCM_ANALOG_PLL_AUDIO_SS_STOP_SHIFT       16
#define CCM_ANALOG_PLL_AUDIO_SS_STOP(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SS_STOP_SHIFT))&CCM_ANALOG_PLL_AUDIO_SS_STOP_MASK)
/* PLL_AUDIO_NUM Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_NUM_A_MASK          0x3FFFFFFFu
#define CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT         0
#define CCM_ANALOG_PLL_AUDIO_NUM_A(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT))&CCM_ANALOG_PLL_AUDIO_NUM_A_MASK)
#define CCM_ANALOG_PLL_AUDIO_NUM_RSVD0_MASK      0xC0000000u
#define CCM_ANALOG_PLL_AUDIO_NUM_RSVD0_SHIFT     30
#define CCM_ANALOG_PLL_AUDIO_NUM_RSVD0(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_NUM_RSVD0_SHIFT))&CCM_ANALOG_PLL_AUDIO_NUM_RSVD0_MASK)
/* PLL_AUDIO_DENOM Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK        0x3FFFFFFFu
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT       0
#define CCM_ANALOG_PLL_AUDIO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT))&CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK)
#define CCM_ANALOG_PLL_AUDIO_DENOM_RSVD0_MASK    0xC0000000u
#define CCM_ANALOG_PLL_AUDIO_DENOM_RSVD0_SHIFT   30
#define CCM_ANALOG_PLL_AUDIO_DENOM_RSVD0(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_DENOM_RSVD0_SHIFT))&CCM_ANALOG_PLL_AUDIO_DENOM_RSVD0_MASK)
/* PLL_VIDEO Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK     0x7Fu
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT    0
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_HALF_LF_MASK        0x80u
#define CCM_ANALOG_PLL_VIDEO_HALF_LF_SHIFT       7
#define CCM_ANALOG_PLL_VIDEO_DOUBLE_LF_MASK      0x100u
#define CCM_ANALOG_PLL_VIDEO_DOUBLE_LF_SHIFT     8
#define CCM_ANALOG_PLL_VIDEO_HALF_CP_MASK        0x200u
#define CCM_ANALOG_PLL_VIDEO_HALF_CP_SHIFT       9
#define CCM_ANALOG_PLL_VIDEO_DOUBLE_CP_MASK      0x400u
#define CCM_ANALOG_PLL_VIDEO_DOUBLE_CP_SHIFT     10
#define CCM_ANALOG_PLL_VIDEO_HOLD_RING_OFF_MASK  0x800u
#define CCM_ANALOG_PLL_VIDEO_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_MASK      0x1000u
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_SHIFT     12
#define CCM_ANALOG_PLL_VIDEO_ENABLE_CLK_MASK     0x2000u
#define CCM_ANALOG_PLL_VIDEO_ENABLE_CLK_SHIFT    13
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_MASK         0x10000u
#define CCM_ANALOG_PLL_VIDEO_BYPASS_SHIFT        16
#define CCM_ANALOG_PLL_VIDEO_DITHER_ENABLE_MASK  0x20000u
#define CCM_ANALOG_PLL_VIDEO_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_MASK  0x40000u
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_RSVD0_MASK          0x200000u
#define CCM_ANALOG_PLL_VIDEO_RSVD0_SHIFT         21
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SEL_MASK   0xC00000u
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SEL_SHIFT  22
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SEL(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_VIDEO_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_VIDEO_PLL_VIDEO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_VIDEO_PLL_VIDEO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_VIDEO_RSVD1_MASK          0x7E000000u
#define CCM_ANALOG_PLL_VIDEO_RSVD1_SHIFT         25
#define CCM_ANALOG_PLL_VIDEO_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_RSVD1_SHIFT))&CCM_ANALOG_PLL_VIDEO_RSVD1_MASK)
#define CCM_ANALOG_PLL_VIDEO_LOCK_MASK           0x80000000u
#define CCM_ANALOG_PLL_VIDEO_LOCK_SHIFT          31
/* PLL_VIDEO_SET Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_VIDEO_SET_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_VIDEO_SET_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_VIDEO_SET_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_VIDEO_SET_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_VIDEO_SET_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_VIDEO_SET_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_VIDEO_SET_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_VIDEO_SET_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_VIDEO_SET_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_SET_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_VIDEO_SET_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_SET_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_SET_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_SET_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_VIDEO_SET_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_PLL_VIDEO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_VIDEO_SET_PLL_VIDEO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_VIDEO_SET_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_VIDEO_SET_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_VIDEO_SET_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_RSVD1_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_RSVD1_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_SHIFT      31
/* PLL_VIDEO_CLR Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_VIDEO_CLR_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_VIDEO_CLR_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_VIDEO_CLR_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_VIDEO_CLR_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_VIDEO_CLR_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_VIDEO_CLR_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_VIDEO_CLR_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_VIDEO_CLR_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_VIDEO_CLR_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_CLR_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_VIDEO_CLR_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_CLR_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_CLR_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_CLR_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_VIDEO_CLR_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_PLL_VIDEO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_VIDEO_CLR_PLL_VIDEO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_VIDEO_CLR_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_VIDEO_CLR_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_VIDEO_CLR_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_RSVD1_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_RSVD1_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_SHIFT      31
/* PLL_VIDEO_TOG Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_HALF_LF_MASK    0x80u
#define CCM_ANALOG_PLL_VIDEO_TOG_HALF_LF_SHIFT   7
#define CCM_ANALOG_PLL_VIDEO_TOG_DOUBLE_LF_MASK  0x100u
#define CCM_ANALOG_PLL_VIDEO_TOG_DOUBLE_LF_SHIFT 8
#define CCM_ANALOG_PLL_VIDEO_TOG_HALF_CP_MASK    0x200u
#define CCM_ANALOG_PLL_VIDEO_TOG_HALF_CP_SHIFT   9
#define CCM_ANALOG_PLL_VIDEO_TOG_DOUBLE_CP_MASK  0x400u
#define CCM_ANALOG_PLL_VIDEO_TOG_DOUBLE_CP_SHIFT 10
#define CCM_ANALOG_PLL_VIDEO_TOG_HOLD_RING_OFF_MASK 0x800u
#define CCM_ANALOG_PLL_VIDEO_TOG_HOLD_RING_OFF_SHIFT 11
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_CLK_MASK 0x2000u
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_CLK_SHIFT 13
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_TOG_DITHER_ENABLE_MASK 0x20000u
#define CCM_ANALOG_PLL_VIDEO_TOG_DITHER_ENABLE_SHIFT 17
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_TOG_TEST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_TOG_TEST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_TOG_TEST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_TEST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_TEST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_RSVD0_MASK      0x200000u
#define CCM_ANALOG_PLL_VIDEO_TOG_RSVD0_SHIFT     21
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SEL_MASK 0xC00000u
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SEL_SHIFT 22
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SEL_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SEL_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_PLL_VIDEO_OVERRIDE_MASK 0x1000000u
#define CCM_ANALOG_PLL_VIDEO_TOG_PLL_VIDEO_OVERRIDE_SHIFT 24
#define CCM_ANALOG_PLL_VIDEO_TOG_RSVD1_MASK      0x7E000000u
#define CCM_ANALOG_PLL_VIDEO_TOG_RSVD1_SHIFT     25
#define CCM_ANALOG_PLL_VIDEO_TOG_RSVD1(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_RSVD1_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_RSVD1_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_SHIFT      31
/* PLL_VIDEO_SS Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_SS_STEP_MASK        0x7FFFu
#define CCM_ANALOG_PLL_VIDEO_SS_STEP_SHIFT       0
#define CCM_ANALOG_PLL_VIDEO_SS_STEP(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SS_STEP_SHIFT))&CCM_ANALOG_PLL_VIDEO_SS_STEP_MASK)
#define CCM_ANALOG_PLL_VIDEO_SS_ENABLE_MASK      0x8000u
#define CCM_ANALOG_PLL_VIDEO_SS_ENABLE_SHIFT     15
#define CCM_ANALOG_PLL_VIDEO_SS_STOP_MASK        0xFFFF0000u
#define CCM_ANALOG_PLL_VIDEO_SS_STOP_SHIFT       16
#define CCM_ANALOG_PLL_VIDEO_SS_STOP(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SS_STOP_SHIFT))&CCM_ANALOG_PLL_VIDEO_SS_STOP_MASK)
/* PLL_VIDEO_NUM Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_NUM_A_MASK          0x3FFFFFFFu
#define CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT         0
#define CCM_ANALOG_PLL_VIDEO_NUM_A(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT))&CCM_ANALOG_PLL_VIDEO_NUM_A_MASK)
#define CCM_ANALOG_PLL_VIDEO_NUM_RSVD0_MASK      0xC0000000u
#define CCM_ANALOG_PLL_VIDEO_NUM_RSVD0_SHIFT     30
#define CCM_ANALOG_PLL_VIDEO_NUM_RSVD0(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_NUM_RSVD0_SHIFT))&CCM_ANALOG_PLL_VIDEO_NUM_RSVD0_MASK)
/* PLL_VIDEO_DENOM Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK        0x3FFFFFFFu
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT       0
#define CCM_ANALOG_PLL_VIDEO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT))&CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK)
#define CCM_ANALOG_PLL_VIDEO_DENOM_RSVD0_MASK    0xC0000000u
#define CCM_ANALOG_PLL_VIDEO_DENOM_RSVD0_SHIFT   30
#define CCM_ANALOG_PLL_VIDEO_DENOM_RSVD0(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_DENOM_RSVD0_SHIFT))&CCM_ANALOG_PLL_VIDEO_DENOM_RSVD0_MASK)
/* CLK_MISC0 Bit Fields */
#define CCM_ANALOG_CLK_MISC0_LVDS1_CLK_SEL_MASK  0x1Fu
#define CCM_ANALOG_CLK_MISC0_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_CLK_MISC0_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_CLK_MISC0_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_CLK_MISC0_LVDSCLK1_OBEN_MASK  0x20u
#define CCM_ANALOG_CLK_MISC0_LVDSCLK1_OBEN_SHIFT 5
#define CCM_ANALOG_CLK_MISC0_LVDSCLK1_IBEN_MASK  0x40u
#define CCM_ANALOG_CLK_MISC0_LVDSCLK1_IBEN_SHIFT 6
#define CCM_ANALOG_CLK_MISC0_ACLK2_PREDIV_MASK   0x80u
#define CCM_ANALOG_CLK_MISC0_ACLK2_PREDIV_SHIFT  7
#define CCM_ANALOG_CLK_MISC0_RSVD0_MASK          0xFFFFFF00u
#define CCM_ANALOG_CLK_MISC0_RSVD0_SHIFT         8
#define CCM_ANALOG_CLK_MISC0_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_RSVD0_SHIFT))&CCM_ANALOG_CLK_MISC0_RSVD0_MASK)
/* CLK_MISC0_SET Bit Fields */
#define CCM_ANALOG_CLK_MISC0_SET_LVDS1_CLK_SEL_MASK 0x1Fu
#define CCM_ANALOG_CLK_MISC0_SET_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_CLK_MISC0_SET_LVDS1_CLK_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_SET_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_CLK_MISC0_SET_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_CLK_MISC0_SET_LVDSCLK1_OBEN_MASK 0x20u
#define CCM_ANALOG_CLK_MISC0_SET_LVDSCLK1_OBEN_SHIFT 5
#define CCM_ANALOG_CLK_MISC0_SET_LVDSCLK1_IBEN_MASK 0x40u
#define CCM_ANALOG_CLK_MISC0_SET_LVDSCLK1_IBEN_SHIFT 6
#define CCM_ANALOG_CLK_MISC0_SET_ACLK2_PREDIV_MASK 0x80u
#define CCM_ANALOG_CLK_MISC0_SET_ACLK2_PREDIV_SHIFT 7
#define CCM_ANALOG_CLK_MISC0_SET_RSVD0_MASK      0xFFFFFF00u
#define CCM_ANALOG_CLK_MISC0_SET_RSVD0_SHIFT     8
#define CCM_ANALOG_CLK_MISC0_SET_RSVD0(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_SET_RSVD0_SHIFT))&CCM_ANALOG_CLK_MISC0_SET_RSVD0_MASK)
/* CLK_MISC0_CLR Bit Fields */
#define CCM_ANALOG_CLK_MISC0_CLR_LVDS1_CLK_SEL_MASK 0x1Fu
#define CCM_ANALOG_CLK_MISC0_CLR_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_CLK_MISC0_CLR_LVDS1_CLK_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_CLR_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_CLK_MISC0_CLR_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_CLK_MISC0_CLR_LVDSCLK1_OBEN_MASK 0x20u
#define CCM_ANALOG_CLK_MISC0_CLR_LVDSCLK1_OBEN_SHIFT 5
#define CCM_ANALOG_CLK_MISC0_CLR_LVDSCLK1_IBEN_MASK 0x40u
#define CCM_ANALOG_CLK_MISC0_CLR_LVDSCLK1_IBEN_SHIFT 6
#define CCM_ANALOG_CLK_MISC0_CLR_ACLK2_PREDIV_MASK 0x80u
#define CCM_ANALOG_CLK_MISC0_CLR_ACLK2_PREDIV_SHIFT 7
#define CCM_ANALOG_CLK_MISC0_CLR_RSVD0_MASK      0xFFFFFF00u
#define CCM_ANALOG_CLK_MISC0_CLR_RSVD0_SHIFT     8
#define CCM_ANALOG_CLK_MISC0_CLR_RSVD0(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_CLR_RSVD0_SHIFT))&CCM_ANALOG_CLK_MISC0_CLR_RSVD0_MASK)
/* CLK_MISC0_TOG Bit Fields */
#define CCM_ANALOG_CLK_MISC0_TOG_LVDS1_CLK_SEL_MASK 0x1Fu
#define CCM_ANALOG_CLK_MISC0_TOG_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_CLK_MISC0_TOG_LVDS1_CLK_SEL(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_TOG_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_CLK_MISC0_TOG_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_CLK_MISC0_TOG_LVDSCLK1_OBEN_MASK 0x20u
#define CCM_ANALOG_CLK_MISC0_TOG_LVDSCLK1_OBEN_SHIFT 5
#define CCM_ANALOG_CLK_MISC0_TOG_LVDSCLK1_IBEN_MASK 0x40u
#define CCM_ANALOG_CLK_MISC0_TOG_LVDSCLK1_IBEN_SHIFT 6
#define CCM_ANALOG_CLK_MISC0_TOG_ACLK2_PREDIV_MASK 0x80u
#define CCM_ANALOG_CLK_MISC0_TOG_ACLK2_PREDIV_SHIFT 7
#define CCM_ANALOG_CLK_MISC0_TOG_RSVD0_MASK      0xFFFFFF00u
#define CCM_ANALOG_CLK_MISC0_TOG_RSVD0_SHIFT     8
#define CCM_ANALOG_CLK_MISC0_TOG_RSVD0(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_CLK_MISC0_TOG_RSVD0_SHIFT))&CCM_ANALOG_CLK_MISC0_TOG_RSVD0_MASK)

/* REG_1P0A Bit Fields */
#define PMU_REG_1P0A_ENABLE_LINREG_MASK          0x1u
#define PMU_REG_1P0A_ENABLE_LINREG_SHIFT         0
#define PMU_REG_1P0A_ENABLE_BO_MASK              0x2u
#define PMU_REG_1P0A_ENABLE_BO_SHIFT             1
#define PMU_REG_1P0A_ENABLE_ILIMIT_MASK          0x4u
#define PMU_REG_1P0A_ENABLE_ILIMIT_SHIFT         2
#define PMU_REG_1P0A_ENABLE_PULLDOWN_MASK        0x8u
#define PMU_REG_1P0A_ENABLE_PULLDOWN_SHIFT       3
#define PMU_REG_1P0A_BO_OFFSET_MASK              0x70u
#define PMU_REG_1P0A_BO_OFFSET_SHIFT             4
#define PMU_REG_1P0A_BO_OFFSET(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_BO_OFFSET_SHIFT))&PMU_REG_1P0A_BO_OFFSET_MASK)
#define PMU_REG_1P0A_ENABLE_PWRUPLOAD_MASK       0x80u
#define PMU_REG_1P0A_ENABLE_PWRUPLOAD_SHIFT      7
#define PMU_REG_1P0A_OUTPUT_TRG_MASK             0x1F00u
#define PMU_REG_1P0A_OUTPUT_TRG_SHIFT            8
#define PMU_REG_1P0A_OUTPUT_TRG(x)               (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_OUTPUT_TRG_SHIFT))&PMU_REG_1P0A_OUTPUT_TRG_MASK)
#define PMU_REG_1P0A_RSVD0_MASK                  0xE000u
#define PMU_REG_1P0A_RSVD0_SHIFT                 13
#define PMU_REG_1P0A_RSVD0(x)                    (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_RSVD0_SHIFT))&PMU_REG_1P0A_RSVD0_MASK)
#define PMU_REG_1P0A_BO_MASK                     0x10000u
#define PMU_REG_1P0A_BO_SHIFT                    16
#define PMU_REG_1P0A_OK_MASK                     0x20000u
#define PMU_REG_1P0A_OK_SHIFT                    17
#define PMU_REG_1P0A_ENABLE_WEAK_LINREG_MASK     0x40000u
#define PMU_REG_1P0A_ENABLE_WEAK_LINREG_SHIFT    18
#define PMU_REG_1P0A_SELREF_WEAK_LINREG_MASK     0x80000u
#define PMU_REG_1P0A_SELREF_WEAK_LINREG_SHIFT    19
#define PMU_REG_1P0A_REG_TEST_MASK               0xF00000u
#define PMU_REG_1P0A_REG_TEST_SHIFT              20
#define PMU_REG_1P0A_REG_TEST(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_REG_TEST_SHIFT))&PMU_REG_1P0A_REG_TEST_MASK)
#define PMU_REG_1P0A_RSVD1_MASK                  0xFF000000u
#define PMU_REG_1P0A_RSVD1_SHIFT                 24
#define PMU_REG_1P0A_RSVD1(x)                    (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_RSVD1_SHIFT))&PMU_REG_1P0A_RSVD1_MASK)
/* REG_1P0A_SET Bit Fields */
#define PMU_REG_1P0A_SET_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0A_SET_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0A_SET_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0A_SET_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0A_SET_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0A_SET_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0A_SET_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0A_SET_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0A_SET_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0A_SET_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0A_SET_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_SET_BO_OFFSET_SHIFT))&PMU_REG_1P0A_SET_BO_OFFSET_MASK)
#define PMU_REG_1P0A_SET_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0A_SET_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0A_SET_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0A_SET_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0A_SET_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_SET_OUTPUT_TRG_SHIFT))&PMU_REG_1P0A_SET_OUTPUT_TRG_MASK)
#define PMU_REG_1P0A_SET_RSVD0_MASK              0xE000u
#define PMU_REG_1P0A_SET_RSVD0_SHIFT             13
#define PMU_REG_1P0A_SET_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_SET_RSVD0_SHIFT))&PMU_REG_1P0A_SET_RSVD0_MASK)
#define PMU_REG_1P0A_SET_BO_MASK                 0x10000u
#define PMU_REG_1P0A_SET_BO_SHIFT                16
#define PMU_REG_1P0A_SET_OK_MASK                 0x20000u
#define PMU_REG_1P0A_SET_OK_SHIFT                17
#define PMU_REG_1P0A_SET_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0A_SET_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0A_SET_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0A_SET_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0A_SET_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0A_SET_REG_TEST_SHIFT          20
#define PMU_REG_1P0A_SET_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_SET_REG_TEST_SHIFT))&PMU_REG_1P0A_SET_REG_TEST_MASK)
#define PMU_REG_1P0A_SET_RSVD1_MASK              0xFF000000u
#define PMU_REG_1P0A_SET_RSVD1_SHIFT             24
#define PMU_REG_1P0A_SET_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_SET_RSVD1_SHIFT))&PMU_REG_1P0A_SET_RSVD1_MASK)
/* REG_1P0A_CLR Bit Fields */
#define PMU_REG_1P0A_CLR_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0A_CLR_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0A_CLR_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0A_CLR_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0A_CLR_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0A_CLR_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0A_CLR_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0A_CLR_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0A_CLR_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0A_CLR_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0A_CLR_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_CLR_BO_OFFSET_SHIFT))&PMU_REG_1P0A_CLR_BO_OFFSET_MASK)
#define PMU_REG_1P0A_CLR_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0A_CLR_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0A_CLR_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0A_CLR_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0A_CLR_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_CLR_OUTPUT_TRG_SHIFT))&PMU_REG_1P0A_CLR_OUTPUT_TRG_MASK)
#define PMU_REG_1P0A_CLR_RSVD0_MASK              0xE000u
#define PMU_REG_1P0A_CLR_RSVD0_SHIFT             13
#define PMU_REG_1P0A_CLR_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_CLR_RSVD0_SHIFT))&PMU_REG_1P0A_CLR_RSVD0_MASK)
#define PMU_REG_1P0A_CLR_BO_MASK                 0x10000u
#define PMU_REG_1P0A_CLR_BO_SHIFT                16
#define PMU_REG_1P0A_CLR_OK_MASK                 0x20000u
#define PMU_REG_1P0A_CLR_OK_SHIFT                17
#define PMU_REG_1P0A_CLR_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0A_CLR_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0A_CLR_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0A_CLR_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0A_CLR_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0A_CLR_REG_TEST_SHIFT          20
#define PMU_REG_1P0A_CLR_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_CLR_REG_TEST_SHIFT))&PMU_REG_1P0A_CLR_REG_TEST_MASK)
#define PMU_REG_1P0A_CLR_RSVD1_MASK              0xFF000000u
#define PMU_REG_1P0A_CLR_RSVD1_SHIFT             24
#define PMU_REG_1P0A_CLR_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_CLR_RSVD1_SHIFT))&PMU_REG_1P0A_CLR_RSVD1_MASK)
/* REG_1P0A_TOG Bit Fields */
#define PMU_REG_1P0A_TOG_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0A_TOG_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0A_TOG_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0A_TOG_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0A_TOG_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0A_TOG_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0A_TOG_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0A_TOG_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0A_TOG_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0A_TOG_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0A_TOG_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_TOG_BO_OFFSET_SHIFT))&PMU_REG_1P0A_TOG_BO_OFFSET_MASK)
#define PMU_REG_1P0A_TOG_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0A_TOG_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0A_TOG_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0A_TOG_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0A_TOG_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_TOG_OUTPUT_TRG_SHIFT))&PMU_REG_1P0A_TOG_OUTPUT_TRG_MASK)
#define PMU_REG_1P0A_TOG_RSVD0_MASK              0xE000u
#define PMU_REG_1P0A_TOG_RSVD0_SHIFT             13
#define PMU_REG_1P0A_TOG_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_TOG_RSVD0_SHIFT))&PMU_REG_1P0A_TOG_RSVD0_MASK)
#define PMU_REG_1P0A_TOG_BO_MASK                 0x10000u
#define PMU_REG_1P0A_TOG_BO_SHIFT                16
#define PMU_REG_1P0A_TOG_OK_MASK                 0x20000u
#define PMU_REG_1P0A_TOG_OK_SHIFT                17
#define PMU_REG_1P0A_TOG_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0A_TOG_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0A_TOG_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0A_TOG_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0A_TOG_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0A_TOG_REG_TEST_SHIFT          20
#define PMU_REG_1P0A_TOG_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_TOG_REG_TEST_SHIFT))&PMU_REG_1P0A_TOG_REG_TEST_MASK)
#define PMU_REG_1P0A_TOG_RSVD1_MASK              0xFF000000u
#define PMU_REG_1P0A_TOG_RSVD1_SHIFT             24
#define PMU_REG_1P0A_TOG_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0A_TOG_RSVD1_SHIFT))&PMU_REG_1P0A_TOG_RSVD1_MASK)
/* REG_1P0D Bit Fields */
#define PMU_REG_1P0D_ENABLE_LINREG_MASK          0x1u
#define PMU_REG_1P0D_ENABLE_LINREG_SHIFT         0
#define PMU_REG_1P0D_ENABLE_BO_MASK              0x2u
#define PMU_REG_1P0D_ENABLE_BO_SHIFT             1
#define PMU_REG_1P0D_ENABLE_ILIMIT_MASK          0x4u
#define PMU_REG_1P0D_ENABLE_ILIMIT_SHIFT         2
#define PMU_REG_1P0D_ENABLE_PULLDOWN_MASK        0x8u
#define PMU_REG_1P0D_ENABLE_PULLDOWN_SHIFT       3
#define PMU_REG_1P0D_BO_OFFSET_MASK              0x70u
#define PMU_REG_1P0D_BO_OFFSET_SHIFT             4
#define PMU_REG_1P0D_BO_OFFSET(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_BO_OFFSET_SHIFT))&PMU_REG_1P0D_BO_OFFSET_MASK)
#define PMU_REG_1P0D_ENABLE_PWRUPLOAD_MASK       0x80u
#define PMU_REG_1P0D_ENABLE_PWRUPLOAD_SHIFT      7
#define PMU_REG_1P0D_OUTPUT_TRG_MASK             0x1F00u
#define PMU_REG_1P0D_OUTPUT_TRG_SHIFT            8
#define PMU_REG_1P0D_OUTPUT_TRG(x)               (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_OUTPUT_TRG_SHIFT))&PMU_REG_1P0D_OUTPUT_TRG_MASK)
#define PMU_REG_1P0D_RSVD0_MASK                  0xE000u
#define PMU_REG_1P0D_RSVD0_SHIFT                 13
#define PMU_REG_1P0D_RSVD0(x)                    (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_RSVD0_SHIFT))&PMU_REG_1P0D_RSVD0_MASK)
#define PMU_REG_1P0D_BO_MASK                     0x10000u
#define PMU_REG_1P0D_BO_SHIFT                    16
#define PMU_REG_1P0D_OK_MASK                     0x20000u
#define PMU_REG_1P0D_OK_SHIFT                    17
#define PMU_REG_1P0D_ENABLE_WEAK_LINREG_MASK     0x40000u
#define PMU_REG_1P0D_ENABLE_WEAK_LINREG_SHIFT    18
#define PMU_REG_1P0D_SELREF_WEAK_LINREG_MASK     0x80000u
#define PMU_REG_1P0D_SELREF_WEAK_LINREG_SHIFT    19
#define PMU_REG_1P0D_REG_TEST_MASK               0xF00000u
#define PMU_REG_1P0D_REG_TEST_SHIFT              20
#define PMU_REG_1P0D_REG_TEST(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_REG_TEST_SHIFT))&PMU_REG_1P0D_REG_TEST_MASK)
#define PMU_REG_1P0D_RSVD1_MASK                  0x7F000000u
#define PMU_REG_1P0D_RSVD1_SHIFT                 24
#define PMU_REG_1P0D_RSVD1(x)                    (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_RSVD1_SHIFT))&PMU_REG_1P0D_RSVD1_MASK)
#define PMU_REG_1P0D_OVERRIDE_MASK               0x80000000u
#define PMU_REG_1P0D_OVERRIDE_SHIFT              31
/* REG_1P0D_SET Bit Fields */
#define PMU_REG_1P0D_SET_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0D_SET_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0D_SET_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0D_SET_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0D_SET_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0D_SET_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0D_SET_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0D_SET_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0D_SET_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0D_SET_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0D_SET_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_SET_BO_OFFSET_SHIFT))&PMU_REG_1P0D_SET_BO_OFFSET_MASK)
#define PMU_REG_1P0D_SET_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0D_SET_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0D_SET_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0D_SET_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0D_SET_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_SET_OUTPUT_TRG_SHIFT))&PMU_REG_1P0D_SET_OUTPUT_TRG_MASK)
#define PMU_REG_1P0D_SET_RSVD0_MASK              0xE000u
#define PMU_REG_1P0D_SET_RSVD0_SHIFT             13
#define PMU_REG_1P0D_SET_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_SET_RSVD0_SHIFT))&PMU_REG_1P0D_SET_RSVD0_MASK)
#define PMU_REG_1P0D_SET_BO_MASK                 0x10000u
#define PMU_REG_1P0D_SET_BO_SHIFT                16
#define PMU_REG_1P0D_SET_OK_MASK                 0x20000u
#define PMU_REG_1P0D_SET_OK_SHIFT                17
#define PMU_REG_1P0D_SET_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0D_SET_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0D_SET_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0D_SET_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0D_SET_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0D_SET_REG_TEST_SHIFT          20
#define PMU_REG_1P0D_SET_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_SET_REG_TEST_SHIFT))&PMU_REG_1P0D_SET_REG_TEST_MASK)
#define PMU_REG_1P0D_SET_RSVD1_MASK              0x7F000000u
#define PMU_REG_1P0D_SET_RSVD1_SHIFT             24
#define PMU_REG_1P0D_SET_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_SET_RSVD1_SHIFT))&PMU_REG_1P0D_SET_RSVD1_MASK)
#define PMU_REG_1P0D_SET_OVERRIDE_MASK           0x80000000u
#define PMU_REG_1P0D_SET_OVERRIDE_SHIFT          31
/* REG_1P0D_CLR Bit Fields */
#define PMU_REG_1P0D_CLR_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0D_CLR_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0D_CLR_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0D_CLR_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0D_CLR_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0D_CLR_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0D_CLR_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0D_CLR_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0D_CLR_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0D_CLR_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0D_CLR_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_CLR_BO_OFFSET_SHIFT))&PMU_REG_1P0D_CLR_BO_OFFSET_MASK)
#define PMU_REG_1P0D_CLR_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0D_CLR_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0D_CLR_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0D_CLR_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0D_CLR_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_CLR_OUTPUT_TRG_SHIFT))&PMU_REG_1P0D_CLR_OUTPUT_TRG_MASK)
#define PMU_REG_1P0D_CLR_RSVD0_MASK              0xE000u
#define PMU_REG_1P0D_CLR_RSVD0_SHIFT             13
#define PMU_REG_1P0D_CLR_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_CLR_RSVD0_SHIFT))&PMU_REG_1P0D_CLR_RSVD0_MASK)
#define PMU_REG_1P0D_CLR_BO_MASK                 0x10000u
#define PMU_REG_1P0D_CLR_BO_SHIFT                16
#define PMU_REG_1P0D_CLR_OK_MASK                 0x20000u
#define PMU_REG_1P0D_CLR_OK_SHIFT                17
#define PMU_REG_1P0D_CLR_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0D_CLR_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0D_CLR_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0D_CLR_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0D_CLR_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0D_CLR_REG_TEST_SHIFT          20
#define PMU_REG_1P0D_CLR_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_CLR_REG_TEST_SHIFT))&PMU_REG_1P0D_CLR_REG_TEST_MASK)
#define PMU_REG_1P0D_CLR_RSVD1_MASK              0x7F000000u
#define PMU_REG_1P0D_CLR_RSVD1_SHIFT             24
#define PMU_REG_1P0D_CLR_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_CLR_RSVD1_SHIFT))&PMU_REG_1P0D_CLR_RSVD1_MASK)
#define PMU_REG_1P0D_CLR_OVERRIDE_MASK           0x80000000u
#define PMU_REG_1P0D_CLR_OVERRIDE_SHIFT          31
/* REG_1P0D_TOG Bit Fields */
#define PMU_REG_1P0D_TOG_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_1P0D_TOG_ENABLE_LINREG_SHIFT     0
#define PMU_REG_1P0D_TOG_ENABLE_BO_MASK          0x2u
#define PMU_REG_1P0D_TOG_ENABLE_BO_SHIFT         1
#define PMU_REG_1P0D_TOG_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_1P0D_TOG_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_1P0D_TOG_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_1P0D_TOG_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_1P0D_TOG_BO_OFFSET_MASK          0x70u
#define PMU_REG_1P0D_TOG_BO_OFFSET_SHIFT         4
#define PMU_REG_1P0D_TOG_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_TOG_BO_OFFSET_SHIFT))&PMU_REG_1P0D_TOG_BO_OFFSET_MASK)
#define PMU_REG_1P0D_TOG_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_1P0D_TOG_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_1P0D_TOG_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_1P0D_TOG_OUTPUT_TRG_SHIFT        8
#define PMU_REG_1P0D_TOG_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_TOG_OUTPUT_TRG_SHIFT))&PMU_REG_1P0D_TOG_OUTPUT_TRG_MASK)
#define PMU_REG_1P0D_TOG_RSVD0_MASK              0xE000u
#define PMU_REG_1P0D_TOG_RSVD0_SHIFT             13
#define PMU_REG_1P0D_TOG_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_TOG_RSVD0_SHIFT))&PMU_REG_1P0D_TOG_RSVD0_MASK)
#define PMU_REG_1P0D_TOG_BO_MASK                 0x10000u
#define PMU_REG_1P0D_TOG_BO_SHIFT                16
#define PMU_REG_1P0D_TOG_OK_MASK                 0x20000u
#define PMU_REG_1P0D_TOG_OK_SHIFT                17
#define PMU_REG_1P0D_TOG_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_1P0D_TOG_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_1P0D_TOG_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_1P0D_TOG_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_1P0D_TOG_REG_TEST_MASK           0xF00000u
#define PMU_REG_1P0D_TOG_REG_TEST_SHIFT          20
#define PMU_REG_1P0D_TOG_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_TOG_REG_TEST_SHIFT))&PMU_REG_1P0D_TOG_REG_TEST_MASK)
#define PMU_REG_1P0D_TOG_RSVD1_MASK              0x7F000000u
#define PMU_REG_1P0D_TOG_RSVD1_SHIFT             24
#define PMU_REG_1P0D_TOG_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_1P0D_TOG_RSVD1_SHIFT))&PMU_REG_1P0D_TOG_RSVD1_MASK)
#define PMU_REG_1P0D_TOG_OVERRIDE_MASK           0x80000000u
#define PMU_REG_1P0D_TOG_OVERRIDE_SHIFT          31
/* REG_HSIC_1P2 Bit Fields */
#define PMU_REG_HSIC_1P2_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_HSIC_1P2_ENABLE_LINREG_SHIFT     0
#define PMU_REG_HSIC_1P2_ENABLE_BO_MASK          0x2u
#define PMU_REG_HSIC_1P2_ENABLE_BO_SHIFT         1
#define PMU_REG_HSIC_1P2_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_HSIC_1P2_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_HSIC_1P2_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_HSIC_1P2_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_HSIC_1P2_BO_OFFSET_MASK          0x70u
#define PMU_REG_HSIC_1P2_BO_OFFSET_SHIFT         4
#define PMU_REG_HSIC_1P2_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_BO_OFFSET_SHIFT))&PMU_REG_HSIC_1P2_BO_OFFSET_MASK)
#define PMU_REG_HSIC_1P2_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_HSIC_1P2_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_HSIC_1P2_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_HSIC_1P2_OUTPUT_TRG_SHIFT        8
#define PMU_REG_HSIC_1P2_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_OUTPUT_TRG_SHIFT))&PMU_REG_HSIC_1P2_OUTPUT_TRG_MASK)
#define PMU_REG_HSIC_1P2_RSVD0_MASK              0xE000u
#define PMU_REG_HSIC_1P2_RSVD0_SHIFT             13
#define PMU_REG_HSIC_1P2_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_RSVD0_SHIFT))&PMU_REG_HSIC_1P2_RSVD0_MASK)
#define PMU_REG_HSIC_1P2_BO_MASK                 0x10000u
#define PMU_REG_HSIC_1P2_BO_SHIFT                16
#define PMU_REG_HSIC_1P2_OK_MASK                 0x20000u
#define PMU_REG_HSIC_1P2_OK_SHIFT                17
#define PMU_REG_HSIC_1P2_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_HSIC_1P2_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_HSIC_1P2_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_HSIC_1P2_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_HSIC_1P2_REG_TEST_MASK           0xF00000u
#define PMU_REG_HSIC_1P2_REG_TEST_SHIFT          20
#define PMU_REG_HSIC_1P2_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_REG_TEST_SHIFT))&PMU_REG_HSIC_1P2_REG_TEST_MASK)
#define PMU_REG_HSIC_1P2_RSVD1_MASK              0x7F000000u
#define PMU_REG_HSIC_1P2_RSVD1_SHIFT             24
#define PMU_REG_HSIC_1P2_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_RSVD1_SHIFT))&PMU_REG_HSIC_1P2_RSVD1_MASK)
#define PMU_REG_HSIC_1P2_OVERRIDE_MASK           0x80000000u
#define PMU_REG_HSIC_1P2_OVERRIDE_SHIFT          31
/* REG_HSIC_1P2_SET Bit Fields */
#define PMU_REG_HSIC_1P2_SET_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_HSIC_1P2_SET_ENABLE_LINREG_SHIFT 0
#define PMU_REG_HSIC_1P2_SET_ENABLE_BO_MASK      0x2u
#define PMU_REG_HSIC_1P2_SET_ENABLE_BO_SHIFT     1
#define PMU_REG_HSIC_1P2_SET_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_HSIC_1P2_SET_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_HSIC_1P2_SET_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_HSIC_1P2_SET_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_HSIC_1P2_SET_BO_OFFSET_MASK      0x70u
#define PMU_REG_HSIC_1P2_SET_BO_OFFSET_SHIFT     4
#define PMU_REG_HSIC_1P2_SET_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_SET_BO_OFFSET_SHIFT))&PMU_REG_HSIC_1P2_SET_BO_OFFSET_MASK)
#define PMU_REG_HSIC_1P2_SET_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_HSIC_1P2_SET_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_HSIC_1P2_SET_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_HSIC_1P2_SET_OUTPUT_TRG_SHIFT    8
#define PMU_REG_HSIC_1P2_SET_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_SET_OUTPUT_TRG_SHIFT))&PMU_REG_HSIC_1P2_SET_OUTPUT_TRG_MASK)
#define PMU_REG_HSIC_1P2_SET_RSVD0_MASK          0xE000u
#define PMU_REG_HSIC_1P2_SET_RSVD0_SHIFT         13
#define PMU_REG_HSIC_1P2_SET_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_SET_RSVD0_SHIFT))&PMU_REG_HSIC_1P2_SET_RSVD0_MASK)
#define PMU_REG_HSIC_1P2_SET_BO_MASK             0x10000u
#define PMU_REG_HSIC_1P2_SET_BO_SHIFT            16
#define PMU_REG_HSIC_1P2_SET_OK_MASK             0x20000u
#define PMU_REG_HSIC_1P2_SET_OK_SHIFT            17
#define PMU_REG_HSIC_1P2_SET_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_HSIC_1P2_SET_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_HSIC_1P2_SET_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_HSIC_1P2_SET_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_HSIC_1P2_SET_REG_TEST_MASK       0xF00000u
#define PMU_REG_HSIC_1P2_SET_REG_TEST_SHIFT      20
#define PMU_REG_HSIC_1P2_SET_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_SET_REG_TEST_SHIFT))&PMU_REG_HSIC_1P2_SET_REG_TEST_MASK)
#define PMU_REG_HSIC_1P2_SET_RSVD1_MASK          0x7F000000u
#define PMU_REG_HSIC_1P2_SET_RSVD1_SHIFT         24
#define PMU_REG_HSIC_1P2_SET_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_SET_RSVD1_SHIFT))&PMU_REG_HSIC_1P2_SET_RSVD1_MASK)
#define PMU_REG_HSIC_1P2_SET_OVERRIDE_MASK       0x80000000u
#define PMU_REG_HSIC_1P2_SET_OVERRIDE_SHIFT      31
/* REG_HSIC_1P2_CLR Bit Fields */
#define PMU_REG_HSIC_1P2_CLR_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_LINREG_SHIFT 0
#define PMU_REG_HSIC_1P2_CLR_ENABLE_BO_MASK      0x2u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_BO_SHIFT     1
#define PMU_REG_HSIC_1P2_CLR_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_HSIC_1P2_CLR_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_HSIC_1P2_CLR_BO_OFFSET_MASK      0x70u
#define PMU_REG_HSIC_1P2_CLR_BO_OFFSET_SHIFT     4
#define PMU_REG_HSIC_1P2_CLR_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_CLR_BO_OFFSET_SHIFT))&PMU_REG_HSIC_1P2_CLR_BO_OFFSET_MASK)
#define PMU_REG_HSIC_1P2_CLR_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_HSIC_1P2_CLR_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_HSIC_1P2_CLR_OUTPUT_TRG_SHIFT    8
#define PMU_REG_HSIC_1P2_CLR_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_CLR_OUTPUT_TRG_SHIFT))&PMU_REG_HSIC_1P2_CLR_OUTPUT_TRG_MASK)
#define PMU_REG_HSIC_1P2_CLR_RSVD0_MASK          0xE000u
#define PMU_REG_HSIC_1P2_CLR_RSVD0_SHIFT         13
#define PMU_REG_HSIC_1P2_CLR_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_CLR_RSVD0_SHIFT))&PMU_REG_HSIC_1P2_CLR_RSVD0_MASK)
#define PMU_REG_HSIC_1P2_CLR_BO_MASK             0x10000u
#define PMU_REG_HSIC_1P2_CLR_BO_SHIFT            16
#define PMU_REG_HSIC_1P2_CLR_OK_MASK             0x20000u
#define PMU_REG_HSIC_1P2_CLR_OK_SHIFT            17
#define PMU_REG_HSIC_1P2_CLR_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_HSIC_1P2_CLR_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_HSIC_1P2_CLR_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_HSIC_1P2_CLR_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_HSIC_1P2_CLR_REG_TEST_MASK       0xF00000u
#define PMU_REG_HSIC_1P2_CLR_REG_TEST_SHIFT      20
#define PMU_REG_HSIC_1P2_CLR_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_CLR_REG_TEST_SHIFT))&PMU_REG_HSIC_1P2_CLR_REG_TEST_MASK)
#define PMU_REG_HSIC_1P2_CLR_RSVD1_MASK          0x7F000000u
#define PMU_REG_HSIC_1P2_CLR_RSVD1_SHIFT         24
#define PMU_REG_HSIC_1P2_CLR_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_CLR_RSVD1_SHIFT))&PMU_REG_HSIC_1P2_CLR_RSVD1_MASK)
#define PMU_REG_HSIC_1P2_CLR_OVERRIDE_MASK       0x80000000u
#define PMU_REG_HSIC_1P2_CLR_OVERRIDE_SHIFT      31
/* REG_HSIC_1P2_TOG Bit Fields */
#define PMU_REG_HSIC_1P2_TOG_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_LINREG_SHIFT 0
#define PMU_REG_HSIC_1P2_TOG_ENABLE_BO_MASK      0x2u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_BO_SHIFT     1
#define PMU_REG_HSIC_1P2_TOG_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_HSIC_1P2_TOG_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_HSIC_1P2_TOG_BO_OFFSET_MASK      0x70u
#define PMU_REG_HSIC_1P2_TOG_BO_OFFSET_SHIFT     4
#define PMU_REG_HSIC_1P2_TOG_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_TOG_BO_OFFSET_SHIFT))&PMU_REG_HSIC_1P2_TOG_BO_OFFSET_MASK)
#define PMU_REG_HSIC_1P2_TOG_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_HSIC_1P2_TOG_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_HSIC_1P2_TOG_OUTPUT_TRG_SHIFT    8
#define PMU_REG_HSIC_1P2_TOG_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_TOG_OUTPUT_TRG_SHIFT))&PMU_REG_HSIC_1P2_TOG_OUTPUT_TRG_MASK)
#define PMU_REG_HSIC_1P2_TOG_RSVD0_MASK          0xE000u
#define PMU_REG_HSIC_1P2_TOG_RSVD0_SHIFT         13
#define PMU_REG_HSIC_1P2_TOG_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_TOG_RSVD0_SHIFT))&PMU_REG_HSIC_1P2_TOG_RSVD0_MASK)
#define PMU_REG_HSIC_1P2_TOG_BO_MASK             0x10000u
#define PMU_REG_HSIC_1P2_TOG_BO_SHIFT            16
#define PMU_REG_HSIC_1P2_TOG_OK_MASK             0x20000u
#define PMU_REG_HSIC_1P2_TOG_OK_SHIFT            17
#define PMU_REG_HSIC_1P2_TOG_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_HSIC_1P2_TOG_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_HSIC_1P2_TOG_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_HSIC_1P2_TOG_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_HSIC_1P2_TOG_REG_TEST_MASK       0xF00000u
#define PMU_REG_HSIC_1P2_TOG_REG_TEST_SHIFT      20
#define PMU_REG_HSIC_1P2_TOG_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_TOG_REG_TEST_SHIFT))&PMU_REG_HSIC_1P2_TOG_REG_TEST_MASK)
#define PMU_REG_HSIC_1P2_TOG_RSVD1_MASK          0x7F000000u
#define PMU_REG_HSIC_1P2_TOG_RSVD1_SHIFT         24
#define PMU_REG_HSIC_1P2_TOG_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_HSIC_1P2_TOG_RSVD1_SHIFT))&PMU_REG_HSIC_1P2_TOG_RSVD1_MASK)
#define PMU_REG_HSIC_1P2_TOG_OVERRIDE_MASK       0x80000000u
#define PMU_REG_HSIC_1P2_TOG_OVERRIDE_SHIFT      31
/* REG_LPSR_1P0 Bit Fields */
#define PMU_REG_LPSR_1P0_ENABLE_LINREG_MASK      0x1u
#define PMU_REG_LPSR_1P0_ENABLE_LINREG_SHIFT     0
#define PMU_REG_LPSR_1P0_ENABLE_BO_MASK          0x2u
#define PMU_REG_LPSR_1P0_ENABLE_BO_SHIFT         1
#define PMU_REG_LPSR_1P0_ENABLE_ILIMIT_MASK      0x4u
#define PMU_REG_LPSR_1P0_ENABLE_ILIMIT_SHIFT     2
#define PMU_REG_LPSR_1P0_ENABLE_PULLDOWN_MASK    0x8u
#define PMU_REG_LPSR_1P0_ENABLE_PULLDOWN_SHIFT   3
#define PMU_REG_LPSR_1P0_BO_OFFSET_MASK          0x70u
#define PMU_REG_LPSR_1P0_BO_OFFSET_SHIFT         4
#define PMU_REG_LPSR_1P0_BO_OFFSET(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_BO_OFFSET_SHIFT))&PMU_REG_LPSR_1P0_BO_OFFSET_MASK)
#define PMU_REG_LPSR_1P0_ENABLE_PWRUPLOAD_MASK   0x80u
#define PMU_REG_LPSR_1P0_ENABLE_PWRUPLOAD_SHIFT  7
#define PMU_REG_LPSR_1P0_OUTPUT_TRG_MASK         0x1F00u
#define PMU_REG_LPSR_1P0_OUTPUT_TRG_SHIFT        8
#define PMU_REG_LPSR_1P0_OUTPUT_TRG(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_OUTPUT_TRG_SHIFT))&PMU_REG_LPSR_1P0_OUTPUT_TRG_MASK)
#define PMU_REG_LPSR_1P0_RSVD0_MASK              0xE000u
#define PMU_REG_LPSR_1P0_RSVD0_SHIFT             13
#define PMU_REG_LPSR_1P0_RSVD0(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_RSVD0_SHIFT))&PMU_REG_LPSR_1P0_RSVD0_MASK)
#define PMU_REG_LPSR_1P0_BO_MASK                 0x10000u
#define PMU_REG_LPSR_1P0_BO_SHIFT                16
#define PMU_REG_LPSR_1P0_OK_MASK                 0x20000u
#define PMU_REG_LPSR_1P0_OK_SHIFT                17
#define PMU_REG_LPSR_1P0_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_LPSR_1P0_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_LPSR_1P0_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_LPSR_1P0_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_LPSR_1P0_REG_TEST_MASK           0xF00000u
#define PMU_REG_LPSR_1P0_REG_TEST_SHIFT          20
#define PMU_REG_LPSR_1P0_REG_TEST(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_REG_TEST_SHIFT))&PMU_REG_LPSR_1P0_REG_TEST_MASK)
#define PMU_REG_LPSR_1P0_RSVD1_MASK              0xFF000000u
#define PMU_REG_LPSR_1P0_RSVD1_SHIFT             24
#define PMU_REG_LPSR_1P0_RSVD1(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_RSVD1_SHIFT))&PMU_REG_LPSR_1P0_RSVD1_MASK)
/* REG_LPSR_1P0_SET Bit Fields */
#define PMU_REG_LPSR_1P0_SET_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_LPSR_1P0_SET_ENABLE_LINREG_SHIFT 0
#define PMU_REG_LPSR_1P0_SET_ENABLE_BO_MASK      0x2u
#define PMU_REG_LPSR_1P0_SET_ENABLE_BO_SHIFT     1
#define PMU_REG_LPSR_1P0_SET_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_LPSR_1P0_SET_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_LPSR_1P0_SET_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_LPSR_1P0_SET_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_LPSR_1P0_SET_BO_OFFSET_MASK      0x70u
#define PMU_REG_LPSR_1P0_SET_BO_OFFSET_SHIFT     4
#define PMU_REG_LPSR_1P0_SET_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_SET_BO_OFFSET_SHIFT))&PMU_REG_LPSR_1P0_SET_BO_OFFSET_MASK)
#define PMU_REG_LPSR_1P0_SET_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_LPSR_1P0_SET_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_LPSR_1P0_SET_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_LPSR_1P0_SET_OUTPUT_TRG_SHIFT    8
#define PMU_REG_LPSR_1P0_SET_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_SET_OUTPUT_TRG_SHIFT))&PMU_REG_LPSR_1P0_SET_OUTPUT_TRG_MASK)
#define PMU_REG_LPSR_1P0_SET_RSVD0_MASK          0xE000u
#define PMU_REG_LPSR_1P0_SET_RSVD0_SHIFT         13
#define PMU_REG_LPSR_1P0_SET_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_SET_RSVD0_SHIFT))&PMU_REG_LPSR_1P0_SET_RSVD0_MASK)
#define PMU_REG_LPSR_1P0_SET_BO_MASK             0x10000u
#define PMU_REG_LPSR_1P0_SET_BO_SHIFT            16
#define PMU_REG_LPSR_1P0_SET_OK_MASK             0x20000u
#define PMU_REG_LPSR_1P0_SET_OK_SHIFT            17
#define PMU_REG_LPSR_1P0_SET_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_LPSR_1P0_SET_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_LPSR_1P0_SET_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_LPSR_1P0_SET_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_LPSR_1P0_SET_REG_TEST_MASK       0xF00000u
#define PMU_REG_LPSR_1P0_SET_REG_TEST_SHIFT      20
#define PMU_REG_LPSR_1P0_SET_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_SET_REG_TEST_SHIFT))&PMU_REG_LPSR_1P0_SET_REG_TEST_MASK)
#define PMU_REG_LPSR_1P0_SET_RSVD1_MASK          0xFF000000u
#define PMU_REG_LPSR_1P0_SET_RSVD1_SHIFT         24
#define PMU_REG_LPSR_1P0_SET_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_SET_RSVD1_SHIFT))&PMU_REG_LPSR_1P0_SET_RSVD1_MASK)
/* REG_LPSR_1P0_CLR Bit Fields */
#define PMU_REG_LPSR_1P0_CLR_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_LINREG_SHIFT 0
#define PMU_REG_LPSR_1P0_CLR_ENABLE_BO_MASK      0x2u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_BO_SHIFT     1
#define PMU_REG_LPSR_1P0_CLR_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_LPSR_1P0_CLR_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_LPSR_1P0_CLR_BO_OFFSET_MASK      0x70u
#define PMU_REG_LPSR_1P0_CLR_BO_OFFSET_SHIFT     4
#define PMU_REG_LPSR_1P0_CLR_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_CLR_BO_OFFSET_SHIFT))&PMU_REG_LPSR_1P0_CLR_BO_OFFSET_MASK)
#define PMU_REG_LPSR_1P0_CLR_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_LPSR_1P0_CLR_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_LPSR_1P0_CLR_OUTPUT_TRG_SHIFT    8
#define PMU_REG_LPSR_1P0_CLR_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_CLR_OUTPUT_TRG_SHIFT))&PMU_REG_LPSR_1P0_CLR_OUTPUT_TRG_MASK)
#define PMU_REG_LPSR_1P0_CLR_RSVD0_MASK          0xE000u
#define PMU_REG_LPSR_1P0_CLR_RSVD0_SHIFT         13
#define PMU_REG_LPSR_1P0_CLR_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_CLR_RSVD0_SHIFT))&PMU_REG_LPSR_1P0_CLR_RSVD0_MASK)
#define PMU_REG_LPSR_1P0_CLR_BO_MASK             0x10000u
#define PMU_REG_LPSR_1P0_CLR_BO_SHIFT            16
#define PMU_REG_LPSR_1P0_CLR_OK_MASK             0x20000u
#define PMU_REG_LPSR_1P0_CLR_OK_SHIFT            17
#define PMU_REG_LPSR_1P0_CLR_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_LPSR_1P0_CLR_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_LPSR_1P0_CLR_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_LPSR_1P0_CLR_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_LPSR_1P0_CLR_REG_TEST_MASK       0xF00000u
#define PMU_REG_LPSR_1P0_CLR_REG_TEST_SHIFT      20
#define PMU_REG_LPSR_1P0_CLR_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_CLR_REG_TEST_SHIFT))&PMU_REG_LPSR_1P0_CLR_REG_TEST_MASK)
#define PMU_REG_LPSR_1P0_CLR_RSVD1_MASK          0xFF000000u
#define PMU_REG_LPSR_1P0_CLR_RSVD1_SHIFT         24
#define PMU_REG_LPSR_1P0_CLR_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_CLR_RSVD1_SHIFT))&PMU_REG_LPSR_1P0_CLR_RSVD1_MASK)
/* REG_LPSR_1P0_TOG Bit Fields */
#define PMU_REG_LPSR_1P0_TOG_ENABLE_LINREG_MASK  0x1u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_LINREG_SHIFT 0
#define PMU_REG_LPSR_1P0_TOG_ENABLE_BO_MASK      0x2u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_BO_SHIFT     1
#define PMU_REG_LPSR_1P0_TOG_ENABLE_ILIMIT_MASK  0x4u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_ILIMIT_SHIFT 2
#define PMU_REG_LPSR_1P0_TOG_ENABLE_PULLDOWN_MASK 0x8u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_PULLDOWN_SHIFT 3
#define PMU_REG_LPSR_1P0_TOG_BO_OFFSET_MASK      0x70u
#define PMU_REG_LPSR_1P0_TOG_BO_OFFSET_SHIFT     4
#define PMU_REG_LPSR_1P0_TOG_BO_OFFSET(x)        (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_TOG_BO_OFFSET_SHIFT))&PMU_REG_LPSR_1P0_TOG_BO_OFFSET_MASK)
#define PMU_REG_LPSR_1P0_TOG_ENABLE_PWRUPLOAD_MASK 0x80u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_PWRUPLOAD_SHIFT 7
#define PMU_REG_LPSR_1P0_TOG_OUTPUT_TRG_MASK     0x1F00u
#define PMU_REG_LPSR_1P0_TOG_OUTPUT_TRG_SHIFT    8
#define PMU_REG_LPSR_1P0_TOG_OUTPUT_TRG(x)       (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_TOG_OUTPUT_TRG_SHIFT))&PMU_REG_LPSR_1P0_TOG_OUTPUT_TRG_MASK)
#define PMU_REG_LPSR_1P0_TOG_RSVD0_MASK          0xE000u
#define PMU_REG_LPSR_1P0_TOG_RSVD0_SHIFT         13
#define PMU_REG_LPSR_1P0_TOG_RSVD0(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_TOG_RSVD0_SHIFT))&PMU_REG_LPSR_1P0_TOG_RSVD0_MASK)
#define PMU_REG_LPSR_1P0_TOG_BO_MASK             0x10000u
#define PMU_REG_LPSR_1P0_TOG_BO_SHIFT            16
#define PMU_REG_LPSR_1P0_TOG_OK_MASK             0x20000u
#define PMU_REG_LPSR_1P0_TOG_OK_SHIFT            17
#define PMU_REG_LPSR_1P0_TOG_ENABLE_WEAK_LINREG_MASK 0x40000u
#define PMU_REG_LPSR_1P0_TOG_ENABLE_WEAK_LINREG_SHIFT 18
#define PMU_REG_LPSR_1P0_TOG_SELREF_WEAK_LINREG_MASK 0x80000u
#define PMU_REG_LPSR_1P0_TOG_SELREF_WEAK_LINREG_SHIFT 19
#define PMU_REG_LPSR_1P0_TOG_REG_TEST_MASK       0xF00000u
#define PMU_REG_LPSR_1P0_TOG_REG_TEST_SHIFT      20
#define PMU_REG_LPSR_1P0_TOG_REG_TEST(x)         (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_TOG_REG_TEST_SHIFT))&PMU_REG_LPSR_1P0_TOG_REG_TEST_MASK)
#define PMU_REG_LPSR_1P0_TOG_RSVD1_MASK          0xFF000000u
#define PMU_REG_LPSR_1P0_TOG_RSVD1_SHIFT         24
#define PMU_REG_LPSR_1P0_TOG_RSVD1(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_LPSR_1P0_TOG_RSVD1_SHIFT))&PMU_REG_LPSR_1P0_TOG_RSVD1_MASK)
/* REG_3P0 Bit Fields */
#define PMU_REG_3P0_ENABLE_LINREG_MASK           0x1u
#define PMU_REG_3P0_ENABLE_LINREG_SHIFT          0
#define PMU_REG_3P0_ENABLE_BO_MASK               0x2u
#define PMU_REG_3P0_ENABLE_BO_SHIFT              1
#define PMU_REG_3P0_ENABLE_ILIMIT_MASK           0x4u
#define PMU_REG_3P0_ENABLE_ILIMIT_SHIFT          2
#define PMU_REG_3P0_RSVD0_MASK                   0x8u
#define PMU_REG_3P0_RSVD0_SHIFT                  3
#define PMU_REG_3P0_BO_OFFSET_MASK               0x70u
#define PMU_REG_3P0_BO_OFFSET_SHIFT              4
#define PMU_REG_3P0_BO_OFFSET(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_BO_OFFSET_SHIFT))&PMU_REG_3P0_BO_OFFSET_MASK)
#define PMU_REG_3P0_VBUS_SEL_MASK                0x80u
#define PMU_REG_3P0_VBUS_SEL_SHIFT               7
#define PMU_REG_3P0_OUTPUT_TRG_MASK              0x1F00u
#define PMU_REG_3P0_OUTPUT_TRG_SHIFT             8
#define PMU_REG_3P0_OUTPUT_TRG(x)                (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_OUTPUT_TRG_SHIFT))&PMU_REG_3P0_OUTPUT_TRG_MASK)
#define PMU_REG_3P0_RSVD1_MASK                   0xE000u
#define PMU_REG_3P0_RSVD1_SHIFT                  13
#define PMU_REG_3P0_RSVD1(x)                     (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_RSVD1_SHIFT))&PMU_REG_3P0_RSVD1_MASK)
#define PMU_REG_3P0_BO_VDD3P0_MASK               0x10000u
#define PMU_REG_3P0_BO_VDD3P0_SHIFT              16
#define PMU_REG_3P0_OK_VDD3P0_MASK               0x20000u
#define PMU_REG_3P0_OK_VDD3P0_SHIFT              17
#define PMU_REG_3P0_REG_TEST_MASK                0x3C0000u
#define PMU_REG_3P0_REG_TEST_SHIFT               18
#define PMU_REG_3P0_REG_TEST(x)                  (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_REG_TEST_SHIFT))&PMU_REG_3P0_REG_TEST_MASK)
#define PMU_REG_3P0_RSVD2_MASK                   0xFFC00000u
#define PMU_REG_3P0_RSVD2_SHIFT                  22
#define PMU_REG_3P0_RSVD2(x)                     (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_RSVD2_SHIFT))&PMU_REG_3P0_RSVD2_MASK)
/* REG_3P0_SET Bit Fields */
#define PMU_REG_3P0_SET_ENABLE_LINREG_MASK       0x1u
#define PMU_REG_3P0_SET_ENABLE_LINREG_SHIFT      0
#define PMU_REG_3P0_SET_ENABLE_BO_MASK           0x2u
#define PMU_REG_3P0_SET_ENABLE_BO_SHIFT          1
#define PMU_REG_3P0_SET_ENABLE_ILIMIT_MASK       0x4u
#define PMU_REG_3P0_SET_ENABLE_ILIMIT_SHIFT      2
#define PMU_REG_3P0_SET_RSVD0_MASK               0x8u
#define PMU_REG_3P0_SET_RSVD0_SHIFT              3
#define PMU_REG_3P0_SET_BO_OFFSET_MASK           0x70u
#define PMU_REG_3P0_SET_BO_OFFSET_SHIFT          4
#define PMU_REG_3P0_SET_BO_OFFSET(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_SET_BO_OFFSET_SHIFT))&PMU_REG_3P0_SET_BO_OFFSET_MASK)
#define PMU_REG_3P0_SET_VBUS_SEL_MASK            0x80u
#define PMU_REG_3P0_SET_VBUS_SEL_SHIFT           7
#define PMU_REG_3P0_SET_OUTPUT_TRG_MASK          0x1F00u
#define PMU_REG_3P0_SET_OUTPUT_TRG_SHIFT         8
#define PMU_REG_3P0_SET_OUTPUT_TRG(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_SET_OUTPUT_TRG_SHIFT))&PMU_REG_3P0_SET_OUTPUT_TRG_MASK)
#define PMU_REG_3P0_SET_RSVD1_MASK               0xE000u
#define PMU_REG_3P0_SET_RSVD1_SHIFT              13
#define PMU_REG_3P0_SET_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_SET_RSVD1_SHIFT))&PMU_REG_3P0_SET_RSVD1_MASK)
#define PMU_REG_3P0_SET_BO_VDD3P0_MASK           0x10000u
#define PMU_REG_3P0_SET_BO_VDD3P0_SHIFT          16
#define PMU_REG_3P0_SET_OK_VDD3P0_MASK           0x20000u
#define PMU_REG_3P0_SET_OK_VDD3P0_SHIFT          17
#define PMU_REG_3P0_SET_REG_TEST_MASK            0x3C0000u
#define PMU_REG_3P0_SET_REG_TEST_SHIFT           18
#define PMU_REG_3P0_SET_REG_TEST(x)              (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_SET_REG_TEST_SHIFT))&PMU_REG_3P0_SET_REG_TEST_MASK)
#define PMU_REG_3P0_SET_RSVD2_MASK               0xFFC00000u
#define PMU_REG_3P0_SET_RSVD2_SHIFT              22
#define PMU_REG_3P0_SET_RSVD2(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_SET_RSVD2_SHIFT))&PMU_REG_3P0_SET_RSVD2_MASK)
/* REG_3P0_CLR Bit Fields */
#define PMU_REG_3P0_CLR_ENABLE_LINREG_MASK       0x1u
#define PMU_REG_3P0_CLR_ENABLE_LINREG_SHIFT      0
#define PMU_REG_3P0_CLR_ENABLE_BO_MASK           0x2u
#define PMU_REG_3P0_CLR_ENABLE_BO_SHIFT          1
#define PMU_REG_3P0_CLR_ENABLE_ILIMIT_MASK       0x4u
#define PMU_REG_3P0_CLR_ENABLE_ILIMIT_SHIFT      2
#define PMU_REG_3P0_CLR_RSVD0_MASK               0x8u
#define PMU_REG_3P0_CLR_RSVD0_SHIFT              3
#define PMU_REG_3P0_CLR_BO_OFFSET_MASK           0x70u
#define PMU_REG_3P0_CLR_BO_OFFSET_SHIFT          4
#define PMU_REG_3P0_CLR_BO_OFFSET(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_CLR_BO_OFFSET_SHIFT))&PMU_REG_3P0_CLR_BO_OFFSET_MASK)
#define PMU_REG_3P0_CLR_VBUS_SEL_MASK            0x80u
#define PMU_REG_3P0_CLR_VBUS_SEL_SHIFT           7
#define PMU_REG_3P0_CLR_OUTPUT_TRG_MASK          0x1F00u
#define PMU_REG_3P0_CLR_OUTPUT_TRG_SHIFT         8
#define PMU_REG_3P0_CLR_OUTPUT_TRG(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_CLR_OUTPUT_TRG_SHIFT))&PMU_REG_3P0_CLR_OUTPUT_TRG_MASK)
#define PMU_REG_3P0_CLR_RSVD1_MASK               0xE000u
#define PMU_REG_3P0_CLR_RSVD1_SHIFT              13
#define PMU_REG_3P0_CLR_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_CLR_RSVD1_SHIFT))&PMU_REG_3P0_CLR_RSVD1_MASK)
#define PMU_REG_3P0_CLR_BO_VDD3P0_MASK           0x10000u
#define PMU_REG_3P0_CLR_BO_VDD3P0_SHIFT          16
#define PMU_REG_3P0_CLR_OK_VDD3P0_MASK           0x20000u
#define PMU_REG_3P0_CLR_OK_VDD3P0_SHIFT          17
#define PMU_REG_3P0_CLR_REG_TEST_MASK            0x3C0000u
#define PMU_REG_3P0_CLR_REG_TEST_SHIFT           18
#define PMU_REG_3P0_CLR_REG_TEST(x)              (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_CLR_REG_TEST_SHIFT))&PMU_REG_3P0_CLR_REG_TEST_MASK)
#define PMU_REG_3P0_CLR_RSVD2_MASK               0xFFC00000u
#define PMU_REG_3P0_CLR_RSVD2_SHIFT              22
#define PMU_REG_3P0_CLR_RSVD2(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_CLR_RSVD2_SHIFT))&PMU_REG_3P0_CLR_RSVD2_MASK)
/* REG_3P0_TOG Bit Fields */
#define PMU_REG_3P0_TOG_ENABLE_LINREG_MASK       0x1u
#define PMU_REG_3P0_TOG_ENABLE_LINREG_SHIFT      0
#define PMU_REG_3P0_TOG_ENABLE_BO_MASK           0x2u
#define PMU_REG_3P0_TOG_ENABLE_BO_SHIFT          1
#define PMU_REG_3P0_TOG_ENABLE_ILIMIT_MASK       0x4u
#define PMU_REG_3P0_TOG_ENABLE_ILIMIT_SHIFT      2
#define PMU_REG_3P0_TOG_RSVD0_MASK               0x8u
#define PMU_REG_3P0_TOG_RSVD0_SHIFT              3
#define PMU_REG_3P0_TOG_BO_OFFSET_MASK           0x70u
#define PMU_REG_3P0_TOG_BO_OFFSET_SHIFT          4
#define PMU_REG_3P0_TOG_BO_OFFSET(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_TOG_BO_OFFSET_SHIFT))&PMU_REG_3P0_TOG_BO_OFFSET_MASK)
#define PMU_REG_3P0_TOG_VBUS_SEL_MASK            0x80u
#define PMU_REG_3P0_TOG_VBUS_SEL_SHIFT           7
#define PMU_REG_3P0_TOG_OUTPUT_TRG_MASK          0x1F00u
#define PMU_REG_3P0_TOG_OUTPUT_TRG_SHIFT         8
#define PMU_REG_3P0_TOG_OUTPUT_TRG(x)            (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_TOG_OUTPUT_TRG_SHIFT))&PMU_REG_3P0_TOG_OUTPUT_TRG_MASK)
#define PMU_REG_3P0_TOG_RSVD1_MASK               0xE000u
#define PMU_REG_3P0_TOG_RSVD1_SHIFT              13
#define PMU_REG_3P0_TOG_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_TOG_RSVD1_SHIFT))&PMU_REG_3P0_TOG_RSVD1_MASK)
#define PMU_REG_3P0_TOG_BO_VDD3P0_MASK           0x10000u
#define PMU_REG_3P0_TOG_BO_VDD3P0_SHIFT          16
#define PMU_REG_3P0_TOG_OK_VDD3P0_MASK           0x20000u
#define PMU_REG_3P0_TOG_OK_VDD3P0_SHIFT          17
#define PMU_REG_3P0_TOG_REG_TEST_MASK            0x3C0000u
#define PMU_REG_3P0_TOG_REG_TEST_SHIFT           18
#define PMU_REG_3P0_TOG_REG_TEST(x)              (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_TOG_REG_TEST_SHIFT))&PMU_REG_3P0_TOG_REG_TEST_MASK)
#define PMU_REG_3P0_TOG_RSVD2_MASK               0xFFC00000u
#define PMU_REG_3P0_TOG_RSVD2_SHIFT              22
#define PMU_REG_3P0_TOG_RSVD2(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REG_3P0_TOG_RSVD2_SHIFT))&PMU_REG_3P0_TOG_RSVD2_MASK)
/* REF Bit Fields */
#define PMU_REF_REFTOP_PWD_MASK                  0x1u
#define PMU_REF_REFTOP_PWD_SHIFT                 0
#define PMU_REF_REFTOP_PWDVBGUP_MASK             0x2u
#define PMU_REF_REFTOP_PWDVBGUP_SHIFT            1
#define PMU_REF_REFTOP_LOWPOWER_MASK             0x4u
#define PMU_REF_REFTOP_LOWPOWER_SHIFT            2
#define PMU_REF_REFTOP_SELFBIASOFF_MASK          0x8u
#define PMU_REF_REFTOP_SELFBIASOFF_SHIFT         3
#define PMU_REF_REFTOP_VBGADJ_MASK               0x70u
#define PMU_REF_REFTOP_VBGADJ_SHIFT              4
#define PMU_REF_REFTOP_VBGADJ(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_REF_REFTOP_VBGADJ_SHIFT))&PMU_REF_REFTOP_VBGADJ_MASK)
#define PMU_REF_REFTOP_VBGUP_MASK                0x80u
#define PMU_REF_REFTOP_VBGUP_SHIFT               7
#define PMU_REF_REFTOP_BIAS_TST_MASK             0x300u
#define PMU_REF_REFTOP_BIAS_TST_SHIFT            8
#define PMU_REF_REFTOP_BIAS_TST(x)               (((uint32_t)(((uint32_t)(x))<<PMU_REF_REFTOP_BIAS_TST_SHIFT))&PMU_REF_REFTOP_BIAS_TST_MASK)
#define PMU_REF_LPBG_SEL_MASK                    0x400u
#define PMU_REF_LPBG_SEL_SHIFT                   10
#define PMU_REF_LPBG_TEST_MASK                   0x800u
#define PMU_REF_LPBG_TEST_SHIFT                  11
#define PMU_REF_REFTOP_IBIAS_OFF_MASK            0x1000u
#define PMU_REF_REFTOP_IBIAS_OFF_SHIFT           12
#define PMU_REF_REFTOP_LINREGREF_EN_MASK         0x2000u
#define PMU_REF_REFTOP_LINREGREF_EN_SHIFT        13
#define PMU_REF_RSVD1_MASK                       0xFFFFC000u
#define PMU_REF_RSVD1_SHIFT                      14
#define PMU_REF_RSVD1(x)                         (((uint32_t)(((uint32_t)(x))<<PMU_REF_RSVD1_SHIFT))&PMU_REF_RSVD1_MASK)
/* REF_SET Bit Fields */
#define PMU_REF_SET_REFTOP_PWD_MASK              0x1u
#define PMU_REF_SET_REFTOP_PWD_SHIFT             0
#define PMU_REF_SET_REFTOP_PWDVBGUP_MASK         0x2u
#define PMU_REF_SET_REFTOP_PWDVBGUP_SHIFT        1
#define PMU_REF_SET_REFTOP_LOWPOWER_MASK         0x4u
#define PMU_REF_SET_REFTOP_LOWPOWER_SHIFT        2
#define PMU_REF_SET_REFTOP_SELFBIASOFF_MASK      0x8u
#define PMU_REF_SET_REFTOP_SELFBIASOFF_SHIFT     3
#define PMU_REF_SET_REFTOP_VBGADJ_MASK           0x70u
#define PMU_REF_SET_REFTOP_VBGADJ_SHIFT          4
#define PMU_REF_SET_REFTOP_VBGADJ(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REF_SET_REFTOP_VBGADJ_SHIFT))&PMU_REF_SET_REFTOP_VBGADJ_MASK)
#define PMU_REF_SET_REFTOP_VBGUP_MASK            0x80u
#define PMU_REF_SET_REFTOP_VBGUP_SHIFT           7
#define PMU_REF_SET_REFTOP_BIAS_TST_MASK         0x300u
#define PMU_REF_SET_REFTOP_BIAS_TST_SHIFT        8
#define PMU_REF_SET_REFTOP_BIAS_TST(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REF_SET_REFTOP_BIAS_TST_SHIFT))&PMU_REF_SET_REFTOP_BIAS_TST_MASK)
#define PMU_REF_SET_LPBG_SEL_MASK                0x400u
#define PMU_REF_SET_LPBG_SEL_SHIFT               10
#define PMU_REF_SET_LPBG_TEST_MASK               0x800u
#define PMU_REF_SET_LPBG_TEST_SHIFT              11
#define PMU_REF_SET_REFTOP_IBIAS_OFF_MASK        0x1000u
#define PMU_REF_SET_REFTOP_IBIAS_OFF_SHIFT       12
#define PMU_REF_SET_REFTOP_LINREGREF_EN_MASK     0x2000u
#define PMU_REF_SET_REFTOP_LINREGREF_EN_SHIFT    13
#define PMU_REF_SET_RSVD1_MASK                   0xFFFFC000u
#define PMU_REF_SET_RSVD1_SHIFT                  14
#define PMU_REF_SET_RSVD1(x)                     (((uint32_t)(((uint32_t)(x))<<PMU_REF_SET_RSVD1_SHIFT))&PMU_REF_SET_RSVD1_MASK)
/* REF_CLR Bit Fields */
#define PMU_REF_CLR_REFTOP_PWD_MASK              0x1u
#define PMU_REF_CLR_REFTOP_PWD_SHIFT             0
#define PMU_REF_CLR_REFTOP_PWDVBGUP_MASK         0x2u
#define PMU_REF_CLR_REFTOP_PWDVBGUP_SHIFT        1
#define PMU_REF_CLR_REFTOP_LOWPOWER_MASK         0x4u
#define PMU_REF_CLR_REFTOP_LOWPOWER_SHIFT        2
#define PMU_REF_CLR_REFTOP_SELFBIASOFF_MASK      0x8u
#define PMU_REF_CLR_REFTOP_SELFBIASOFF_SHIFT     3
#define PMU_REF_CLR_REFTOP_VBGADJ_MASK           0x70u
#define PMU_REF_CLR_REFTOP_VBGADJ_SHIFT          4
#define PMU_REF_CLR_REFTOP_VBGADJ(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REF_CLR_REFTOP_VBGADJ_SHIFT))&PMU_REF_CLR_REFTOP_VBGADJ_MASK)
#define PMU_REF_CLR_REFTOP_VBGUP_MASK            0x80u
#define PMU_REF_CLR_REFTOP_VBGUP_SHIFT           7
#define PMU_REF_CLR_REFTOP_BIAS_TST_MASK         0x300u
#define PMU_REF_CLR_REFTOP_BIAS_TST_SHIFT        8
#define PMU_REF_CLR_REFTOP_BIAS_TST(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REF_CLR_REFTOP_BIAS_TST_SHIFT))&PMU_REF_CLR_REFTOP_BIAS_TST_MASK)
#define PMU_REF_CLR_LPBG_SEL_MASK                0x400u
#define PMU_REF_CLR_LPBG_SEL_SHIFT               10
#define PMU_REF_CLR_LPBG_TEST_MASK               0x800u
#define PMU_REF_CLR_LPBG_TEST_SHIFT              11
#define PMU_REF_CLR_REFTOP_IBIAS_OFF_MASK        0x1000u
#define PMU_REF_CLR_REFTOP_IBIAS_OFF_SHIFT       12
#define PMU_REF_CLR_REFTOP_LINREGREF_EN_MASK     0x2000u
#define PMU_REF_CLR_REFTOP_LINREGREF_EN_SHIFT    13
#define PMU_REF_CLR_RSVD1_MASK                   0xFFFFC000u
#define PMU_REF_CLR_RSVD1_SHIFT                  14
#define PMU_REF_CLR_RSVD1(x)                     (((uint32_t)(((uint32_t)(x))<<PMU_REF_CLR_RSVD1_SHIFT))&PMU_REF_CLR_RSVD1_MASK)
/* REF_TOG Bit Fields */
#define PMU_REF_TOG_REFTOP_PWD_MASK              0x1u
#define PMU_REF_TOG_REFTOP_PWD_SHIFT             0
#define PMU_REF_TOG_REFTOP_PWDVBGUP_MASK         0x2u
#define PMU_REF_TOG_REFTOP_PWDVBGUP_SHIFT        1
#define PMU_REF_TOG_REFTOP_LOWPOWER_MASK         0x4u
#define PMU_REF_TOG_REFTOP_LOWPOWER_SHIFT        2
#define PMU_REF_TOG_REFTOP_SELFBIASOFF_MASK      0x8u
#define PMU_REF_TOG_REFTOP_SELFBIASOFF_SHIFT     3
#define PMU_REF_TOG_REFTOP_VBGADJ_MASK           0x70u
#define PMU_REF_TOG_REFTOP_VBGADJ_SHIFT          4
#define PMU_REF_TOG_REFTOP_VBGADJ(x)             (((uint32_t)(((uint32_t)(x))<<PMU_REF_TOG_REFTOP_VBGADJ_SHIFT))&PMU_REF_TOG_REFTOP_VBGADJ_MASK)
#define PMU_REF_TOG_REFTOP_VBGUP_MASK            0x80u
#define PMU_REF_TOG_REFTOP_VBGUP_SHIFT           7
#define PMU_REF_TOG_REFTOP_BIAS_TST_MASK         0x300u
#define PMU_REF_TOG_REFTOP_BIAS_TST_SHIFT        8
#define PMU_REF_TOG_REFTOP_BIAS_TST(x)           (((uint32_t)(((uint32_t)(x))<<PMU_REF_TOG_REFTOP_BIAS_TST_SHIFT))&PMU_REF_TOG_REFTOP_BIAS_TST_MASK)
#define PMU_REF_TOG_LPBG_SEL_MASK                0x400u
#define PMU_REF_TOG_LPBG_SEL_SHIFT               10
#define PMU_REF_TOG_LPBG_TEST_MASK               0x800u
#define PMU_REF_TOG_LPBG_TEST_SHIFT              11
#define PMU_REF_TOG_REFTOP_IBIAS_OFF_MASK        0x1000u
#define PMU_REF_TOG_REFTOP_IBIAS_OFF_SHIFT       12
#define PMU_REF_TOG_REFTOP_LINREGREF_EN_MASK     0x2000u
#define PMU_REF_TOG_REFTOP_LINREGREF_EN_SHIFT    13
#define PMU_REF_TOG_RSVD1_MASK                   0xFFFFC000u
#define PMU_REF_TOG_RSVD1_SHIFT                  14
#define PMU_REF_TOG_RSVD1(x)                     (((uint32_t)(((uint32_t)(x))<<PMU_REF_TOG_RSVD1_SHIFT))&PMU_REF_TOG_RSVD1_MASK)
/* LOWPWR_CTRL Bit Fields */
#define PMU_LOWPWR_CTRL_STOP_MODE_CONFIG_MASK    0x3u
#define PMU_LOWPWR_CTRL_STOP_MODE_CONFIG_SHIFT   0
#define PMU_LOWPWR_CTRL_STOP_MODE_CONFIG(x)      (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_STOP_MODE_CONFIG_SHIFT))&PMU_LOWPWR_CTRL_STOP_MODE_CONFIG_MASK)
#define PMU_LOWPWR_CTRL_RSVD0_MASK               0xFCu
#define PMU_LOWPWR_CTRL_RSVD0_SHIFT              2
#define PMU_LOWPWR_CTRL_RSVD0(x)                 (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_RSVD0_SHIFT))&PMU_LOWPWR_CTRL_RSVD0_MASK)
#define PMU_LOWPWR_CTRL_L1_PWRGATE_MASK          0x100u
#define PMU_LOWPWR_CTRL_L1_PWRGATE_SHIFT         8
#define PMU_LOWPWR_CTRL_L2_PWRGATE_MASK          0x200u
#define PMU_LOWPWR_CTRL_L2_PWRGATE_SHIFT         9
#define PMU_LOWPWR_CTRL_CPU_PWRGATE_MASK         0x400u
#define PMU_LOWPWR_CTRL_CPU_PWRGATE_SHIFT        10
#define PMU_LOWPWR_CTRL_DISPLAY_PWRGATE_MASK     0x800u
#define PMU_LOWPWR_CTRL_DISPLAY_PWRGATE_SHIFT    11
#define PMU_LOWPWR_CTRL_MIX_PWRGATE_MASK         0x1000u
#define PMU_LOWPWR_CTRL_MIX_PWRGATE_SHIFT        12
#define PMU_LOWPWR_CTRL_GPU_PWRGATE_MASK         0x2000u
#define PMU_LOWPWR_CTRL_GPU_PWRGATE_SHIFT        13
#define PMU_LOWPWR_CTRL_CONTROL0_MASK            0xFFC000u
#define PMU_LOWPWR_CTRL_CONTROL0_SHIFT           14
#define PMU_LOWPWR_CTRL_CONTROL0(x)              (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CONTROL0_SHIFT))&PMU_LOWPWR_CTRL_CONTROL0_MASK)
#define PMU_LOWPWR_CTRL_CONTROL1_MASK            0xFF000000u
#define PMU_LOWPWR_CTRL_CONTROL1_SHIFT           24
#define PMU_LOWPWR_CTRL_CONTROL1(x)              (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CONTROL1_SHIFT))&PMU_LOWPWR_CTRL_CONTROL1_MASK)
/* LOWPWR_CTRL_SET Bit Fields */
#define PMU_LOWPWR_CTRL_SET_STOP_MODE_CONFIG_MASK 0x3u
#define PMU_LOWPWR_CTRL_SET_STOP_MODE_CONFIG_SHIFT 0
#define PMU_LOWPWR_CTRL_SET_STOP_MODE_CONFIG(x)  (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_SET_STOP_MODE_CONFIG_SHIFT))&PMU_LOWPWR_CTRL_SET_STOP_MODE_CONFIG_MASK)
#define PMU_LOWPWR_CTRL_SET_RSVD0_MASK           0xFCu
#define PMU_LOWPWR_CTRL_SET_RSVD0_SHIFT          2
#define PMU_LOWPWR_CTRL_SET_RSVD0(x)             (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_SET_RSVD0_SHIFT))&PMU_LOWPWR_CTRL_SET_RSVD0_MASK)
#define PMU_LOWPWR_CTRL_SET_L1_PWRGATE_MASK      0x100u
#define PMU_LOWPWR_CTRL_SET_L1_PWRGATE_SHIFT     8
#define PMU_LOWPWR_CTRL_SET_L2_PWRGATE_MASK      0x200u
#define PMU_LOWPWR_CTRL_SET_L2_PWRGATE_SHIFT     9
#define PMU_LOWPWR_CTRL_SET_CPU_PWRGATE_MASK     0x400u
#define PMU_LOWPWR_CTRL_SET_CPU_PWRGATE_SHIFT    10
#define PMU_LOWPWR_CTRL_SET_DISPLAY_PWRGATE_MASK 0x800u
#define PMU_LOWPWR_CTRL_SET_DISPLAY_PWRGATE_SHIFT 11
#define PMU_LOWPWR_CTRL_SET_MIX_PWRGATE_MASK     0x1000u
#define PMU_LOWPWR_CTRL_SET_MIX_PWRGATE_SHIFT    12
#define PMU_LOWPWR_CTRL_SET_GPU_PWRGATE_MASK     0x2000u
#define PMU_LOWPWR_CTRL_SET_GPU_PWRGATE_SHIFT    13
#define PMU_LOWPWR_CTRL_SET_CONTROL0_MASK        0xFFC000u
#define PMU_LOWPWR_CTRL_SET_CONTROL0_SHIFT       14
#define PMU_LOWPWR_CTRL_SET_CONTROL0(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_SET_CONTROL0_SHIFT))&PMU_LOWPWR_CTRL_SET_CONTROL0_MASK)
#define PMU_LOWPWR_CTRL_SET_CONTROL1_MASK        0xFF000000u
#define PMU_LOWPWR_CTRL_SET_CONTROL1_SHIFT       24
#define PMU_LOWPWR_CTRL_SET_CONTROL1(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_SET_CONTROL1_SHIFT))&PMU_LOWPWR_CTRL_SET_CONTROL1_MASK)
/* LOWPWR_CTRL_CLR Bit Fields */
#define PMU_LOWPWR_CTRL_CLR_STOP_MODE_CONFIG_MASK 0x3u
#define PMU_LOWPWR_CTRL_CLR_STOP_MODE_CONFIG_SHIFT 0
#define PMU_LOWPWR_CTRL_CLR_STOP_MODE_CONFIG(x)  (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CLR_STOP_MODE_CONFIG_SHIFT))&PMU_LOWPWR_CTRL_CLR_STOP_MODE_CONFIG_MASK)
#define PMU_LOWPWR_CTRL_CLR_RSVD0_MASK           0xFCu
#define PMU_LOWPWR_CTRL_CLR_RSVD0_SHIFT          2
#define PMU_LOWPWR_CTRL_CLR_RSVD0(x)             (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CLR_RSVD0_SHIFT))&PMU_LOWPWR_CTRL_CLR_RSVD0_MASK)
#define PMU_LOWPWR_CTRL_CLR_L1_PWRGATE_MASK      0x100u
#define PMU_LOWPWR_CTRL_CLR_L1_PWRGATE_SHIFT     8
#define PMU_LOWPWR_CTRL_CLR_L2_PWRGATE_MASK      0x200u
#define PMU_LOWPWR_CTRL_CLR_L2_PWRGATE_SHIFT     9
#define PMU_LOWPWR_CTRL_CLR_CPU_PWRGATE_MASK     0x400u
#define PMU_LOWPWR_CTRL_CLR_CPU_PWRGATE_SHIFT    10
#define PMU_LOWPWR_CTRL_CLR_DISPLAY_PWRGATE_MASK 0x800u
#define PMU_LOWPWR_CTRL_CLR_DISPLAY_PWRGATE_SHIFT 11
#define PMU_LOWPWR_CTRL_CLR_MIX_PWRGATE_MASK     0x1000u
#define PMU_LOWPWR_CTRL_CLR_MIX_PWRGATE_SHIFT    12
#define PMU_LOWPWR_CTRL_CLR_GPU_PWRGATE_MASK     0x2000u
#define PMU_LOWPWR_CTRL_CLR_GPU_PWRGATE_SHIFT    13
#define PMU_LOWPWR_CTRL_CLR_CONTROL0_MASK        0xFFC000u
#define PMU_LOWPWR_CTRL_CLR_CONTROL0_SHIFT       14
#define PMU_LOWPWR_CTRL_CLR_CONTROL0(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CLR_CONTROL0_SHIFT))&PMU_LOWPWR_CTRL_CLR_CONTROL0_MASK)
#define PMU_LOWPWR_CTRL_CLR_CONTROL1_MASK        0xFF000000u
#define PMU_LOWPWR_CTRL_CLR_CONTROL1_SHIFT       24
#define PMU_LOWPWR_CTRL_CLR_CONTROL1(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_CLR_CONTROL1_SHIFT))&PMU_LOWPWR_CTRL_CLR_CONTROL1_MASK)
/* LOWPWR_CTRL_TOG Bit Fields */
#define PMU_LOWPWR_CTRL_TOG_STOP_MODE_CONFIG_MASK 0x3u
#define PMU_LOWPWR_CTRL_TOG_STOP_MODE_CONFIG_SHIFT 0
#define PMU_LOWPWR_CTRL_TOG_STOP_MODE_CONFIG(x)  (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_TOG_STOP_MODE_CONFIG_SHIFT))&PMU_LOWPWR_CTRL_TOG_STOP_MODE_CONFIG_MASK)
#define PMU_LOWPWR_CTRL_TOG_RSVD0_MASK           0xFCu
#define PMU_LOWPWR_CTRL_TOG_RSVD0_SHIFT          2
#define PMU_LOWPWR_CTRL_TOG_RSVD0(x)             (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_TOG_RSVD0_SHIFT))&PMU_LOWPWR_CTRL_TOG_RSVD0_MASK)
#define PMU_LOWPWR_CTRL_TOG_L1_PWRGATE_MASK      0x100u
#define PMU_LOWPWR_CTRL_TOG_L1_PWRGATE_SHIFT     8
#define PMU_LOWPWR_CTRL_TOG_L2_PWRGATE_MASK      0x200u
#define PMU_LOWPWR_CTRL_TOG_L2_PWRGATE_SHIFT     9
#define PMU_LOWPWR_CTRL_TOG_CPU_PWRGATE_MASK     0x400u
#define PMU_LOWPWR_CTRL_TOG_CPU_PWRGATE_SHIFT    10
#define PMU_LOWPWR_CTRL_TOG_DISPLAY_PWRGATE_MASK 0x800u
#define PMU_LOWPWR_CTRL_TOG_DISPLAY_PWRGATE_SHIFT 11
#define PMU_LOWPWR_CTRL_TOG_MIX_PWRGATE_MASK     0x1000u
#define PMU_LOWPWR_CTRL_TOG_MIX_PWRGATE_SHIFT    12
#define PMU_LOWPWR_CTRL_TOG_GPU_PWRGATE_MASK     0x2000u
#define PMU_LOWPWR_CTRL_TOG_GPU_PWRGATE_SHIFT    13
#define PMU_LOWPWR_CTRL_TOG_CONTROL0_MASK        0xFFC000u
#define PMU_LOWPWR_CTRL_TOG_CONTROL0_SHIFT       14
#define PMU_LOWPWR_CTRL_TOG_CONTROL0(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_TOG_CONTROL0_SHIFT))&PMU_LOWPWR_CTRL_TOG_CONTROL0_MASK)
#define PMU_LOWPWR_CTRL_TOG_CONTROL1_MASK        0xFF000000u
#define PMU_LOWPWR_CTRL_TOG_CONTROL1_SHIFT       24
#define PMU_LOWPWR_CTRL_TOG_CONTROL1(x)          (((uint32_t)(((uint32_t)(x))<<PMU_LOWPWR_CTRL_TOG_CONTROL1_SHIFT))&PMU_LOWPWR_CTRL_TOG_CONTROL1_MASK)


/* HW_ANADIG_TEMPSENSE0 Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE0_LOW_ALARM_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE0_LOW_ALARM_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE0_LOW_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_LOW_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_LOW_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_HIGH_ALARM_VALUE_MASK 0x3FE00u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_HIGH_ALARM_VALUE_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE0_HIGH_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_HIGH_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_HIGH_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_PANIC_ALARM_VALUE_MASK 0x7FC0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_PANIC_ALARM_VALUE_SHIFT 18
#define TEMPMON_HW_ANADIG_TEMPSENSE0_PANIC_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_PANIC_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_PANIC_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_RSVD1_MASK  0xF8000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_RSVD1_SHIFT 27
#define TEMPMON_HW_ANADIG_TEMPSENSE0_RSVD1(x)    (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_RSVD1_MASK)
/* HW_ANADIG_TEMPSENSE0_SET Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_LOW_ALARM_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_LOW_ALARM_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_LOW_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_SET_LOW_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_SET_LOW_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_HIGH_ALARM_VALUE_MASK 0x3FE00u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_HIGH_ALARM_VALUE_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_HIGH_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_SET_HIGH_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_SET_HIGH_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_PANIC_ALARM_VALUE_MASK 0x7FC0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_PANIC_ALARM_VALUE_SHIFT 18
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_PANIC_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_SET_PANIC_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_SET_PANIC_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_RSVD1_MASK 0xF8000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_RSVD1_SHIFT 27
#define TEMPMON_HW_ANADIG_TEMPSENSE0_SET_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_SET_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_SET_RSVD1_MASK)
/* HW_ANADIG_TEMPSENSE0_CLR Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_LOW_ALARM_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_LOW_ALARM_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_LOW_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_LOW_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_LOW_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_HIGH_ALARM_VALUE_MASK 0x3FE00u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_HIGH_ALARM_VALUE_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_HIGH_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_HIGH_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_HIGH_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_PANIC_ALARM_VALUE_MASK 0x7FC0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_PANIC_ALARM_VALUE_SHIFT 18
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_PANIC_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_PANIC_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_PANIC_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_RSVD1_MASK 0xF8000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_RSVD1_SHIFT 27
#define TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_CLR_RSVD1_MASK)
/* HW_ANADIG_TEMPSENSE0_TOG Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_LOW_ALARM_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_LOW_ALARM_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_LOW_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_LOW_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_LOW_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_HIGH_ALARM_VALUE_MASK 0x3FE00u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_HIGH_ALARM_VALUE_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_HIGH_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_HIGH_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_HIGH_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_PANIC_ALARM_VALUE_MASK 0x7FC0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_PANIC_ALARM_VALUE_SHIFT 18
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_PANIC_ALARM_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_PANIC_ALARM_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_PANIC_ALARM_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_RSVD1_MASK 0xF8000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_RSVD1_SHIFT 27
#define TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE0_TOG_RSVD1_MASK)
/* HW_ANADIG_TEMPSENSE1 Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TEMP_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TEMP_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TEMP_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_TEMP_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_TEMP_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_POWER_DOWN_MASK 0x200u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_POWER_DOWN_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_TEMP_MASK 0x400u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_TEMP_SHIFT 10
#define TEMPMON_HW_ANADIG_TEMPSENSE1_FINISHED_MASK 0x800u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_FINISHED_SHIFT 11
#define TEMPMON_HW_ANADIG_TEMPSENSE1_RSVD0_MASK  0xF000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_RSVD0_SHIFT 12
#define TEMPMON_HW_ANADIG_TEMPSENSE1_RSVD0(x)    (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_FREQ_MASK 0xFFFF0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_FREQ_SHIFT 16
#define TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_FREQ(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_FREQ_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_MEASURE_FREQ_MASK)
/* HW_ANADIG_TEMPSENSE1_SET Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_TEMP_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_TEMP_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_TEMP_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_SET_TEMP_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_SET_TEMP_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_POWER_DOWN_MASK 0x200u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_POWER_DOWN_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_TEMP_MASK 0x400u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_TEMP_SHIFT 10
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_FINISHED_MASK 0x800u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_FINISHED_SHIFT 11
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_RSVD0_MASK 0xF000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_RSVD0_SHIFT 12
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_SET_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_SET_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_FREQ_MASK 0xFFFF0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_FREQ_SHIFT 16
#define TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_FREQ(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_FREQ_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_SET_MEASURE_FREQ_MASK)
/* HW_ANADIG_TEMPSENSE1_CLR Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_TEMP_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_TEMP_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_TEMP_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_TEMP_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_TEMP_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_POWER_DOWN_MASK 0x200u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_POWER_DOWN_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_TEMP_MASK 0x400u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_TEMP_SHIFT 10
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_FINISHED_MASK 0x800u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_FINISHED_SHIFT 11
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_RSVD0_MASK 0xF000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_RSVD0_SHIFT 12
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_FREQ_MASK 0xFFFF0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_FREQ_SHIFT 16
#define TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_FREQ(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_FREQ_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_CLR_MEASURE_FREQ_MASK)
/* HW_ANADIG_TEMPSENSE1_TOG Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_TEMP_VALUE_MASK 0x1FFu
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_TEMP_VALUE_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_TEMP_VALUE(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_TEMP_VALUE_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_TEMP_VALUE_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_POWER_DOWN_MASK 0x200u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_POWER_DOWN_SHIFT 9
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_TEMP_MASK 0x400u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_TEMP_SHIFT 10
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_FINISHED_MASK 0x800u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_FINISHED_SHIFT 11
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_RSVD0_MASK 0xF000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_RSVD0_SHIFT 12
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_FREQ_MASK 0xFFFF0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_FREQ_SHIFT 16
#define TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_FREQ(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_FREQ_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE1_TOG_MEASURE_FREQ_MASK)
/* HW_ANADIG_TEMPSENSE_TRIM Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_VREF_SEL_MASK 0x1Fu
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_VREF_SEL_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_VREF_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_VREF_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_VREF_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD0_MASK 0x60u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD0_SHIFT 5
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_EN_READ_MASK 0x80u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_EN_READ_SHIFT 7
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_VREF_VBE_SEL_MASK 0x1FF00u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_VREF_VBE_SEL_SHIFT 8
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_VREF_VBE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_VREF_VBE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_VREF_VBE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD1_MASK 0xE0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD1_SHIFT 17
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD1_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_SLOPE_SEL_MASK 0xF00000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_SLOPE_SEL_SHIFT 20
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_SLOPE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_SLOPE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_BUF_SLOPE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD2_MASK 0x1F000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD2_SHIFT 24
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD2(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD2_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_RSVD2_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_MUX_ADDR_MASK 0xE0000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_MUX_ADDR_SHIFT 29
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_MUX_ADDR(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_MUX_ADDR_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_T_MUX_ADDR_MASK)
/* HW_ANADIG_TEMPSENSE_TRIM_SET Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_VREF_SEL_MASK 0x1Fu
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_VREF_SEL_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_VREF_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_VREF_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_VREF_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD0_MASK 0x60u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD0_SHIFT 5
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_EN_READ_MASK 0x80u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_EN_READ_SHIFT 7
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_VREF_VBE_SEL_MASK 0x1FF00u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_VREF_VBE_SEL_SHIFT 8
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_VREF_VBE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_VREF_VBE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_VREF_VBE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD1_MASK 0xE0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD1_SHIFT 17
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD1_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_SLOPE_SEL_MASK 0xF00000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_SLOPE_SEL_SHIFT 20
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_SLOPE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_SLOPE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_BUF_SLOPE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD2_MASK 0x1F000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD2_SHIFT 24
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD2(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD2_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_RSVD2_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_MUX_ADDR_MASK 0xE0000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_MUX_ADDR_SHIFT 29
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_MUX_ADDR(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_MUX_ADDR_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_SET_T_MUX_ADDR_MASK)
/* HW_ANADIG_TEMPSENSE_TRIM_CLR Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_VREF_SEL_MASK 0x1Fu
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_VREF_SEL_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_VREF_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_VREF_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_VREF_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD0_MASK 0x60u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD0_SHIFT 5
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_EN_READ_MASK 0x80u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_EN_READ_SHIFT 7
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_VREF_VBE_SEL_MASK 0x1FF00u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_VREF_VBE_SEL_SHIFT 8
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_VREF_VBE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_VREF_VBE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_VREF_VBE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD1_MASK 0xE0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD1_SHIFT 17
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD1_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_SLOPE_SEL_MASK 0xF00000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_SLOPE_SEL_SHIFT 20
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_SLOPE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_SLOPE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_BUF_SLOPE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD2_MASK 0x1F000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD2_SHIFT 24
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD2(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD2_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_RSVD2_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_MUX_ADDR_MASK 0xE0000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_MUX_ADDR_SHIFT 29
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_MUX_ADDR(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_MUX_ADDR_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_CLR_T_MUX_ADDR_MASK)
/* HW_ANADIG_TEMPSENSE_TRIM_TOG Bit Fields */
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_VREF_SEL_MASK 0x1Fu
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_VREF_SEL_SHIFT 0
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_VREF_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_VREF_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_VREF_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD0_MASK 0x60u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD0_SHIFT 5
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD0(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD0_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD0_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_EN_READ_MASK 0x80u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_EN_READ_SHIFT 7
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_VREF_VBE_SEL_MASK 0x1FF00u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_VREF_VBE_SEL_SHIFT 8
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_VREF_VBE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_VREF_VBE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_VREF_VBE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD1_MASK 0xE0000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD1_SHIFT 17
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD1(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD1_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD1_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_SLOPE_SEL_MASK 0xF00000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_SLOPE_SEL_SHIFT 20
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_SLOPE_SEL(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_SLOPE_SEL_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_BUF_SLOPE_SEL_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD2_MASK 0x1F000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD2_SHIFT 24
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD2(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD2_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_RSVD2_MASK)
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_MUX_ADDR_MASK 0xE0000000u
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_MUX_ADDR_SHIFT 29
#define TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_MUX_ADDR(x) (((uint32_t)(((uint32_t)(x))<<TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_MUX_ADDR_SHIFT))&TEMPMON_HW_ANADIG_TEMPSENSE_TRIM_TOG_T_MUX_ADDR_MASK)

#define MXC_CCM_CCGR36_CAAM_DOMAIN3_OFFSET                     12
#define MXC_CCM_CCGR36_CAAM_DOMAIN3_MASK                       (3 << MXC_CCM_CCGR36_CAAM_DOMAIN3_OFFSET)
#define MXC_CCM_CCGR36_CAAM_DOMAIN2_OFFSET                     8
#define MXC_CCM_CCGR36_CAAM_DOMAIN2_MASK                       (3 << MXC_CCM_CCGR36_CAAM_DOMAIN2_OFFSET)
#define MXC_CCM_CCGR36_CAAM_DOMAIN1_OFFSET                     4
#define MXC_CCM_CCGR36_CAAM_DOMAIN1_MASK                       (3 << MXC_CCM_CCGR36_CAAM_DOMAIN1_OFFSET)
#define MXC_CCM_CCGR36_CAAM_DOMAIN0_OFFSET                     0
#define MXC_CCM_CCGR36_CAAM_DOMAIN0_MASK                       (3 << MXC_CCM_CCGR36_CAAM_DOMAIN0_OFFSET)

#define CCM_GPR(i)		(CCM_BASE_ADDR + CCM_GPR0_OFFSET + 0x10 * (i))
#define CCM_OBSERVE(i)		(CCM_BASE_ADDR + CCM_OBSERVE0_OFFSET + 0x10 * (i))
#define CCM_SCTRL(i)		(CCM_BASE_ADDR + CCM_SCTRL0_OFFSET + 0x10 * (i))
#define CCM_CCGR(i)		(CCM_BASE_ADDR + CCM_CCGR0_OFFSET + 0x10 * (i))
#define CCM_ROOT_TARGET(i)	(CCM_BASE_ADDR + CCM_ROOT0_TARGET_OFFSET + 0x80 * (i))

#define CCM_GPR_SET(i)		(CCM_BASE_ADDR + CCM_GPR0_OFFSET + 0x10 * (i) + 4)
#define CCM_OBSERVE_SET(i)	(CCM_BASE_ADDR + CCM_OBSERVE0_OFFSET + 0x10 * (i) + 4)
#define CCM_SCTRL_SET(i)	(CCM_BASE_ADDR + CCM_SCTRL0_OFFSET + 0x10 * (i) + 4)
#define CCM_CCGR_SET(i)		(CCM_BASE_ADDR + CCM_CCGR0_OFFSET + 0x10 * (i) + 4)
#define CCM_ROOT_TARGET_SET(i)	(CCM_BASE_ADDR + CCM_ROOT0_TARGET_OFFSET + 0x80 * (i) + 4)

#define CCM_GPR_CLR(i)		(CCM_BASE_ADDR + CCM_GPR0_OFFSET + 0x10 * (i) + 8)
#define CCM_OBSERVE_CLR(i)	(CCM_BASE_ADDR + CCM_OBSERVE0_OFFSET + 0x10 * (i) + 8)
#define CCM_SCTRL_CLR(i)	(CCM_BASE_ADDR + CCM_SCTRL0_OFFSET + 0x10 * (i) + 8)
#define CCM_CCGR_CLR(i)		(CCM_BASE_ADDR + CCM_CCGR0_OFFSET + 0x10 * (i) + 8)
#define CCM_ROOT_TARGET_CLR(i)	(CCM_BASE_ADDR + CCM_ROOT0_TARGET_OFFSET + 0x80 * (i) + 8)

#define CCM_GPR_TOGGLE(i)	(CCM_BASE_ADDR + CCM_GPR0_OFFSET + 0x10 * (i) + 12)
#define CCM_OBSERVE_TOGGLE(i)	(CCM_BASE_ADDR + CCM_OBSERVE0_OFFSET + 0x10 * (i) + 12)
#define CCM_SCTRL_TOGGLE(i)	(CCM_BASE_ADDR + CCM_SCTRL0_OFFSET + 0x10 * (i) + 12)
#define CCM_CCGR_TOGGLE(i)	(CCM_BASE_ADDR + CCM_CCGR0_OFFSET + 0x10 * (i) + 12)
#define CCM_ROOT_TARGET_TOGGLE(i)	(CCM_BASE_ADDR + CCM_ROOT0_TARGET_OFFSET + 0x80 * (i) + 12)

#define HW_CCM_GPR_WR(i, v)		writel((v), CCM_GPR(i))
#define HW_CCM_CCM_OBSERVE_WR(i, v)	writel((v), CCM_OBSERVE(i))
#define HW_CCM_SCTRL_WR(i, v)		writel((v), CCM_SCTRL(i))
#define HW_CCM_CCGR_WR(i, v)		writel((v), CCM_CCGR(i))
#define HW_CCM_ROOT_TARGET_WR(i, v)	writel((v), CCM_ROOT_TARGET(i))

#define HW_CCM_GPR_RD(i)		readl(CCM_GPR(i))
#define HW_CCM_CCM_OBSERVE_RD(i)	readl(CCM_OBSERVE(i))
#define HW_CCM_SCTRL_RD(i)		readl(CCM_SCTRL(i))
#define HW_CCM_CCGR_RD(i)		readl(CCM_CCGR(i))
#define HW_CCM_ROOT_TARGET_RD(i)	readl(CCM_ROOT_TARGET(i))

#define HW_CCM_GPR_SET(i, v)		writel((v), CCM_GPR_SET(i))
#define HW_CCM_CCM_OBSERVE_SET(i, v)	writel((v), CCM_CCM_OBSERVE_SET(i))
#define HW_CCM_SCTRL_SET(i, v)		writel((v), CCM_SCTRL_SET(i))
#define HW_CCM_CCGR_SET(i, v)		writel((v), CCM_CCGR_SET(i))
#define HW_CCM_ROOT_TARGET_SET(i, v)	writel((v), CCM_ROOT_TARGET_SET(i))

#define HW_CCM_GPR_CLR(i, v)		writel((v), CCM_GPR_CLR(i))
#define HW_CCM_CCM_OBSERVE_CLR(i, v)	writel((v), CCM_CCM_OBSERVE_CLR(i))
#define HW_CCM_SCTRL_CLR(i, v)		writel((v), CCM_SCTRL_CLR(i))
#define HW_CCM_CCGR_CLR(i, v)		writel((v), CCM_CCGR_CLR(i))
#define HW_CCM_ROOT_TARGET_CLR(i, v)	writel((v), CCM_ROOT_TARGET_CLR(i))

#define HW_CCM_GPR_TOGGLE(i, v)		writel((v), CCM_GPR_TOGGLE(i))
#define HW_CCM_CCM_OBSERVE_TOGGLE(i, v)	writel((v), CCM_CCM_OBSERVE_TOGGLE(i))
#define HW_CCM_SCTRL_TOGGLE(i, v)	writel((v), CCM_SCTRL_TOGGLE(i))
#define HW_CCM_CCGR_TOGGLE(i, v)	writel((v), CCM_CCGR_TOGGLE(i))
#define HW_CCM_ROOT_TARGET_TOGGLE(i, v)	writel((v), CCM_ROOT_TARGET_TOGGLE(i))

#define CCM_CLK_ON_MSK	0x03
#define CCM_CLK_ON_N_N	0x00 /* Domain clocks not needed */
#define CCM_CLK_ON_R_W	0x02 /* Domain clocks needed when in RUN and WAIT */

/* CCGR Mapping */
#define CCGR_IDX_DDR 19 /* CCM_CCGR19 */

#define CCM_ROOT_TGT_POST_DIV_SHIFT	0
#define CCM_ROOT_TGT_PRE_DIV_SHIFT	15
#define CCM_ROOT_TGT_MUX_SHIFT		24
#define CCM_ROOT_TGT_ENABLE_SHIFT	28
#define CCM_ROOT_TGT_POST_DIV_MSK	0x3F
#define CCM_ROOT_TGT_PRE_DIV_MSK	(0x07 << CCM_ROOT_TGT_PRE_DIV_SHIFT)
#define CCM_ROOT_TGT_MUX_MSK		(0x07 << CCM_ROOT_TGT_MUX_SHIFT)
#define CCM_ROOT_TGT_ENABLE_MSK		(0x01 << CCM_ROOT_TGT_ENABLE_SHIFT)

#define CCM_ROOT_TGT_POST_DIV(x)	((((x) - 1) << CCM_ROOT_TGT_POST_DIV_SHIFT) & CCM_ROOT_TGT_POST_DIV_MSK)
#define CCM_ROOT_TGT_PRE_DIV(x)		((((x) - 1) << CCM_ROOT_TGT_PRE_DIV_SHIFT) & CCM_ROOT_TGT_PRE_DIV_MSK)
#define CCM_ROOT_TGT_MUX_TO(x)		((((x) - 1) << CCM_ROOT_TGT_MUX_SHIFT) & CCM_ROOT_TGT_MUX_MSK)

/*
 * Field values definition for clock slice TARGET register
 */

#define CLK_ROOT_ON		0x10000000
#define CLK_ROOT_OFF		0x0
#define CLK_ROOT_ENABLE_MASK	0x10000000
#define CLK_ROOT_ENABLE_SHIFT	28

#define CLK_ROOT_ALT0		0x00000000
#define CLK_ROOT_ALT1		0x01000000
#define CLK_ROOT_ALT2		0x02000000
#define CLK_ROOT_ALT3		0x03000000
#define CLK_ROOT_ALT4		0x04000000
#define CLK_ROOT_ALT5		0x05000000
#define CLK_ROOT_ALT6		0x06000000
#define CLK_ROOT_ALT7		0x07000000


#define DRAM_CLK_ROOT_POST_DIV_MASK	0x00000007
#define CLK_ROOT_POST_DIV_MASK	0x0000003f
#define CLK_ROOT_POST_DIV_SHIFT	0
#define CLK_ROOT_POST_DIV(n) ((n << CLK_ROOT_POST_DIV_SHIFT) & CLK_ROOT_POST_DIV_MASK)

#define CLK_ROOT_AUTO_DIV_MASK	0x00000700
#define CLK_ROOT_AUTO_DIV_SHIFT	8
#define CLK_ROOT_AUTO_DIV(n) ((n << CLK_ROOT_AUTO_DIV_SHIFT) & CLK_ROOT_AUTO_DIV_MASK)

#define CLK_ROOT_AUTO_EN_MASK	0x00001000
#define CLK_ROOT_AUTO_EN	0x00001000

#define CLK_ROOT_PRE_DIV_MASK	0x00070000
#define CLK_ROOT_PRE_DIV_SHIFT	16
#define CLK_ROOT_PRE_DIV(n) ((n << CLK_ROOT_PRE_DIV_SHIFT) & CLK_ROOT_PRE_DIV_MASK)

#define CLK_ROOT_MUX_MASK	0x07000000
#define CLK_ROOT_MUX_SHIFT	24

#define CLK_ROOT_EN_MASK	0x10000000

#define CLK_ROOT_AUTO_ON	0x00001000
#define CLK_ROOT_AUTO_OFF	0x0

/* ARM_A7_CLK_ROOT */
#define ARM_A7_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ARM_A7_CLK_ROOT_FROM_PLL_ARM_MAIN_800M_CLK		0x01000000
#define ARM_A7_CLK_ROOT_FROM_PLL_DRAM_MAIN_1066M_CLK		0x03000000
#define ARM_A7_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define ARM_A7_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x05000000
#define ARM_A7_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x02000000
#define ARM_A7_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define ARM_A7_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* ARM_M4_CLK_ROOT */
#define ARM_M4_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ARM_M4_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x04000000
#define ARM_M4_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define ARM_M4_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x03000000
#define ARM_M4_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x02000000
#define ARM_M4_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x05000000
#define ARM_M4_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x06000000
#define ARM_M4_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* ARM_M0_CLK_ROOT */
#define ARM_M0_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ARM_M0_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x04000000
#define ARM_M0_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define ARM_M0_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x03000000
#define ARM_M0_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x02000000
#define ARM_M0_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x05000000
#define ARM_M0_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x06000000
#define ARM_M0_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* MAIN_AXI_CLK_ROOT */
#define MAIN_AXI_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_SYS_PFD1_332M_CLK		0x01000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK			0x04000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x03000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define MAIN_AXI_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000

/* DISP_AXI_CLK_ROOT */
#define DISP_AXI_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_SYS_PFD1_332M_CLK		0x01000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x04000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x05000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x03000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x06000000
#define DISP_AXI_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000

/* ENET_AXI_CLK_ROOT */
#define ENET_AXI_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x04000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x01000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x07000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x03000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define ENET_AXI_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000

/* NAND_USDHC_BUS_CLK_ROOT */
#define NAND_USDHC_BUS_CLK_ROOT_FROM_OSC_24M_CLK		0x00000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x02000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK	0x03000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK	0x01000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK	0x04000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK		0x05000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK	0x06000000
#define NAND_USDHC_BUS_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x07000000

/* AHB_CLK_ROOT */
#define AHB_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define AHB_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define AHB_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK			0x03000000
#define AHB_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK			0x01000000
#define AHB_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x04000000
#define AHB_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define AHB_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000
#define AHB_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK			0x05000000

/* DRAM_PHYM_CLK_ROOT */
#define DRAM_PHYM_CLK_ROOT_FROM_PLL_DRAM_MAIN_1066M_CLK		0x00000000
#define DRAM_PHYM_CLK_ROOT_FROM_PLL_DRAM_PHYM_ALT_CLK_ROOT	0x01000000

/* DRAM_CLK_ROOT */
#define DRAM_CLK_ROOT_FROM_PLL_DRAM_MAIN_1066M_CLK		0x00000000
#define DRAM_CLK_ROOT_FROM_PLL_DRAM_ALT_CLK_ROOT		0x01000000

/* DRAM_PHYM_ALT_CLK_ROOT */
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x01000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK	0x02000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK		0x05000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK	0x03000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x06000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000
#define DRAM_PHYM_ALT_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK	0x04000000

/* DRAM_ALT_CLK_ROOT */
#define DRAM_ALT_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x01000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x02000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x05000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x07000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x03000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x04000000
#define DRAM_ALT_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x06000000

/* USB_HSIC_CLK_ROOT */
#define USB_HSIC_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x01000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK			0x03000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x04000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK			0x05000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x06000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define USB_HSIC_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x02000000

/* PCIE_CTRL_CLK_ROOT */
#define PCIE_CTRL_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x04000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x02000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_SYS_PFD1_332M_CLK		0x06000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x03000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK		0x07000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x05000000
#define PCIE_CTRL_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x01000000

/* PCIE_PHY_CLK_ROOT */
#define PCIE_PHY_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define PCIE_PHY_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x07000000
#define PCIE_PHY_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x02000000
#define PCIE_PHY_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define PCIE_PHY_CLK_ROOT_FROM_EXT_CLK_1			0x03000000
#define PCIE_PHY_CLK_ROOT_FROM_EXT_CLK_2			0x04000000
#define PCIE_PHY_CLK_ROOT_FROM_EXT_CLK_3			0x05000000
#define PCIE_PHY_CLK_ROOT_FROM_EXT_CLK_4			0x06000000

/* EPDC_PIXEL_CLK_ROOT */
#define EPDC_PIXEL_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x03000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD1_332M_CLK		0x01000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK		0x04000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK		0x05000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK		0x06000000
#define EPDC_PIXEL_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000

/* LCDIF_PIXEL_CLK_ROOT */
#define LCDIF_PIXEL_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x02000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK		0x04000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK		0x01000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define LCDIF_PIXEL_CLK_ROOT_FROM_EXT_CLK_3			0x03000000

/* MIPI_DSI_EXTSER_CLK_ROOT */
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_OSC_24M_CLK		0x00000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x05000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK	0x03000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_SYS_PFD0_196M_CLK	0x04000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK		0x02000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK		0x01000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK	0x07000000
#define MIPI_DSI_EXTSER_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK	0x06000000

/* MIPI_CSI_WARP_CLK_ROOT */
#define MIPI_CSI_WARP_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x05000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK	0x03000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_SYS_PFD0_196M_CLK	0x04000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK		0x02000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK		0x01000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x07000000
#define MIPI_CSI_WARP_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000

/* MIPI_DPHY_REF_CLK_ROOT */
#define MIPI_DPHY_REF_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x02000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK	0x01000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_PLL_SYS_PFD5_CLK		0x03000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_REF_1M_CLK			0x04000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_EXT_CLK_2			0x05000000
#define MIPI_DPHY_REF_CLK_ROOT_FROM_EXT_CLK_3			0x07000000

/* SAI1_CLK_ROOT */
#define SAI1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SAI1_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SAI1_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SAI1_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define SAI1_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SAI1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x02000000
#define SAI1_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define SAI1_CLK_ROOT_FROM_EXT_CLK_2				0x07000000

/* SAI2_CLK_ROOT */
#define SAI2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SAI2_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SAI2_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SAI2_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define SAI2_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SAI2_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x02000000
#define SAI2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define SAI2_CLK_ROOT_FROM_EXT_CLK_2				0x07000000

/* SAI3_CLK_ROOT */
#define SAI3_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SAI3_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SAI3_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SAI3_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define SAI3_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SAI3_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x02000000
#define SAI3_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define SAI3_CLK_ROOT_FROM_EXT_CLK_3				0x07000000

/* SPDIF_CLK_ROOT */
#define SPDIF_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SPDIF_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SPDIF_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SPDIF_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define SPDIF_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SPDIF_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x02000000
#define SPDIF_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define SPDIF_CLK_ROOT_FROM_EXT_CLK_3				0x07000000

/* ENET1_REF_CLK_ROOT */
#define ENET1_REF_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x04000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x01000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_25M_CLK		0x03000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define ENET1_REF_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define ENET1_REF_CLK_ROOT_FROM_EXT_CLK_4			0x07000000

/* ENET1_TIME_CLK_ROOT */
#define ENET1_TIME_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET1_TIME_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define ENET1_TIME_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x02000000
#define ENET1_TIME_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000
#define ENET1_TIME_CLK_ROOT_FROM_EXT_CLK_1			0x03000000
#define ENET1_TIME_CLK_ROOT_FROM_EXT_CLK_2			0x04000000
#define ENET1_TIME_CLK_ROOT_FROM_EXT_CLK_3			0x05000000
#define ENET1_TIME_CLK_ROOT_FROM_EXT_CLK_4			0x06000000

/* ENET2_REF_CLK_ROOT */
#define ENET2_REF_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x04000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x01000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_25M_CLK		0x03000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define ENET2_REF_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define ENET2_REF_CLK_ROOT_FROM_EXT_CLK_4			0x07000000

/* ENET2_TIME_CLK_ROOT */
#define ENET2_TIME_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET2_TIME_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define ENET2_TIME_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x02000000
#define ENET2_TIME_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000
#define ENET2_TIME_CLK_ROOT_FROM_EXT_CLK_1			0x03000000
#define ENET2_TIME_CLK_ROOT_FROM_EXT_CLK_2			0x04000000
#define ENET2_TIME_CLK_ROOT_FROM_EXT_CLK_3			0x05000000
#define ENET2_TIME_CLK_ROOT_FROM_EXT_CLK_4			0x06000000

/* ENET_PHY_REF_CLK_ROOT */
#define ENET_PHY_REF_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK	0x04000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK		0x07000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK	0x03000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK	0x02000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_ENET_MAIN_25M_CLK	0x01000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define ENET_PHY_REF_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000

/* EIM_CLK_ROOT */
#define EIM_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define EIM_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define EIM_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK			0x02000000
#define EIM_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK			0x04000000
#define EIM_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK			0x01000000
#define EIM_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK			0x05000000
#define EIM_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define EIM_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK			0x07000000

/* NAND_CLK_ROOT */
#define NAND_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define NAND_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define NAND_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x01000000
#define NAND_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x03000000
#define NAND_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK			0x04000000
#define NAND_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x05000000
#define NAND_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x06000000
#define NAND_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000

/* QSPI_CLK_ROOT */
#define QSPI_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define QSPI_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define QSPI_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define QSPI_CLK_ROOT_FROM_PLL_SYS_PFD3_CLK			0x04000000
#define QSPI_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x01000000
#define QSPI_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x06000000
#define QSPI_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define QSPI_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x03000000

/* USDHC1_CLK_ROOT */
#define USDHC1_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define USDHC1_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define USDHC1_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x01000000
#define USDHC1_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define USDHC1_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x04000000
#define USDHC1_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x06000000
#define USDHC1_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define USDHC1_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x03000000

/* USDHC2_CLK_ROOT */
#define USDHC2_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define USDHC2_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define USDHC2_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x01000000
#define USDHC2_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define USDHC2_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x04000000
#define USDHC2_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x06000000
#define USDHC2_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define USDHC2_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x03000000

/* USDHC3_CLK_ROOT */
#define USDHC3_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define USDHC3_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define USDHC3_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x01000000
#define USDHC3_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define USDHC3_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x04000000
#define USDHC3_CLK_ROOT_FROM_PLL_SYS_PFD6_CLK			0x06000000
#define USDHC3_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define USDHC3_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x03000000

/* CAN1_CLK_ROOT */
#define CAN1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define CAN1_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define CAN1_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x03000000
#define CAN1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define CAN1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x04000000
#define CAN1_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x05000000
#define CAN1_CLK_ROOT_FROM_EXT_CLK_1				0x06000000
#define CAN1_CLK_ROOT_FROM_EXT_CLK_4				0x07000000

/* CAN2_CLK_ROOT */
#define CAN2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define CAN2_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define CAN2_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x03000000
#define CAN2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define CAN2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x04000000
#define CAN2_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x05000000
#define CAN2_CLK_ROOT_FROM_EXT_CLK_1				0x06000000
#define CAN2_CLK_ROOT_FROM_EXT_CLK_3				0x07000000

/* I2C1_CLK_ROOT */
#define I2C1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define I2C1_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define I2C1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define I2C1_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x07000000
#define I2C1_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define I2C1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define I2C1_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x05000000
#define I2C1_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x06000000

/* I2C2_CLK_ROOT */
#define I2C2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define I2C2_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define I2C2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define I2C2_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x07000000
#define I2C2_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define I2C2_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define I2C2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x05000000
#define I2C2_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x06000000

/* I2C3_CLK_ROOT */
#define I2C3_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define I2C3_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define I2C3_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define I2C3_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x07000000
#define I2C3_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define I2C3_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define I2C3_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x05000000
#define I2C3_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x06000000

/* I2C4_CLK_ROOT */
#define I2C4_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define I2C4_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define I2C4_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x01000000
#define I2C4_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x07000000
#define I2C4_CLK_ROOT_FROM_PLL_ENET_MAIN_50M_CLK		0x02000000
#define I2C4_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define I2C4_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x05000000
#define I2C4_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x06000000

/* UART1_CLK_ROOT */
#define UART1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART1_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART1_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART1_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART1_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART1_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART1_CLK_ROOT_FROM_EXT_CLK_4				0x06000000

/* UART2_CLK_ROOT */
#define UART2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART2_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART2_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART2_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART2_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART2_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART2_CLK_ROOT_FROM_EXT_CLK_3				0x06000000

/* UART3_CLK_ROOT */
#define UART3_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART3_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART3_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART3_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART3_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART3_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART3_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART3_CLK_ROOT_FROM_EXT_CLK_4				0x06000000

/* UART4_CLK_ROOT */
#define UART4_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART4_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART4_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART4_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART4_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART4_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART4_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART4_CLK_ROOT_FROM_EXT_CLK_3				0x06000000

/* UART5_CLK_ROOT */
#define UART5_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART5_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART5_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART5_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART5_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART5_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART5_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART5_CLK_ROOT_FROM_EXT_CLK_4				0x06000000

/* UART6_CLK_ROOT */
#define UART6_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART6_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART6_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART6_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART6_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART6_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART6_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART6_CLK_ROOT_FROM_EXT_CLK_3				0x06000000

/* UART7_CLK_ROOT */
#define UART7_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define UART7_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define UART7_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define UART7_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x03000000
#define UART7_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define UART7_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000
#define UART7_CLK_ROOT_FROM_EXT_CLK_2				0x05000000
#define UART7_CLK_ROOT_FROM_EXT_CLK_4				0x06000000

/* ECSPI1_CLK_ROOT */
#define ECSPI1_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ECSPI1_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define ECSPI1_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define ECSPI1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x03000000
#define ECSPI1_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define ECSPI1_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x06000000
#define ECSPI1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define ECSPI1_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* ECSPI2_CLK_ROOT */
#define ECSPI2_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ECSPI2_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define ECSPI2_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define ECSPI2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x03000000
#define ECSPI2_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define ECSPI2_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x06000000
#define ECSPI2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define ECSPI2_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* ECSPI3_CLK_ROOT */
#define ECSPI3_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ECSPI3_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define ECSPI3_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define ECSPI3_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x03000000
#define ECSPI3_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define ECSPI3_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x06000000
#define ECSPI3_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define ECSPI3_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* ECSPI4_CLK_ROOT */
#define ECSPI4_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define ECSPI4_CLK_ROOT_FROM_PLL_SYS_MAIN_480M_CLK		0x04000000
#define ECSPI4_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x01000000
#define ECSPI4_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x03000000
#define ECSPI4_CLK_ROOT_FROM_PLL_SYS_PFD4_CLK			0x05000000
#define ECSPI4_CLK_ROOT_FROM_PLL_ENET_MAIN_250M_CLK		0x06000000
#define ECSPI4_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x02000000
#define ECSPI4_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* PWM1_CLK_ROOT */
#define PWM1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define PWM1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define PWM1_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define PWM1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define PWM1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define PWM1_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000
#define PWM1_CLK_ROOT_FROM_REF_1M_CLK				0x06000000
#define PWM1_CLK_ROOT_FROM_EXT_CLK_1				0x05000000

/* PWM2_CLK_ROOT */
#define PWM2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define PWM2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define PWM2_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define PWM2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define PWM2_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define PWM2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000
#define PWM2_CLK_ROOT_FROM_REF_1M_CLK				0x06000000
#define PWM2_CLK_ROOT_FROM_EXT_CLK_1				0x05000000

/* PWM3_CLK_ROOT */
#define PWM3_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define PWM3_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define PWM3_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define PWM3_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define PWM3_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define PWM3_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000
#define PWM3_CLK_ROOT_FROM_REF_1M_CLK				0x06000000
#define PWM3_CLK_ROOT_FROM_EXT_CLK_2				0x05000000

/* PWM4_CLK_ROOT */
#define PWM4_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define PWM4_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define PWM4_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define PWM4_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define PWM4_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x04000000
#define PWM4_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x07000000
#define PWM4_CLK_ROOT_FROM_REF_1M_CLK				0x06000000
#define PWM4_CLK_ROOT_FROM_EXT_CLK_2				0x05000000

/* FLEXTIMER1_CLK_ROOT */
#define FLEXTIMER1_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define FLEXTIMER1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define FLEXTIMER1_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define FLEXTIMER1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define FLEXTIMER1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x04000000
#define FLEXTIMER1_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000
#define FLEXTIMER1_CLK_ROOT_FROM_REF_1M_CLK			0x06000000
#define FLEXTIMER1_CLK_ROOT_FROM_EXT_CLK_3			0x05000000

/* FLEXTIMER2_CLK_ROOT */
#define FLEXTIMER2_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define FLEXTIMER2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define FLEXTIMER2_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define FLEXTIMER2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define FLEXTIMER2_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x04000000
#define FLEXTIMER2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x07000000
#define FLEXTIMER2_CLK_ROOT_FROM_REF_1M_CLK			0x06000000
#define FLEXTIMER2_CLK_ROOT_FROM_EXT_CLK_3			0x05000000

/* SIM1_CLK_ROOT */
#define SIM1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SIM1_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SIM1_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define SIM1_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SIM1_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define SIM1_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SIM1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x05000000
#define SIM1_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x04000000

/* SIM2_CLK_ROOT */
#define SIM2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define SIM2_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define SIM2_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define SIM2_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define SIM2_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define SIM2_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x06000000
#define SIM2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x05000000
#define SIM2_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x04000000

/* GPT1_CLK_ROOT */
#define GPT1_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define GPT1_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x02000000
#define GPT1_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define GPT1_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define GPT1_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define GPT1_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define GPT1_CLK_ROOT_FROM_REF_1M_CLK				0x05000000
#define GPT1_CLK_ROOT_FROM_EXT_CLK_1				0x07000000

/* GPT2_CLK_ROOT */
#define GPT2_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define GPT2_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x02000000
#define GPT2_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define GPT2_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define GPT2_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define GPT2_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define GPT2_CLK_ROOT_FROM_REF_1M_CLK				0x05000000
#define GPT2_CLK_ROOT_FROM_EXT_CLK_2				0x07000000

/* GPT3_CLK_ROOT */
#define GPT3_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define GPT3_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x02000000
#define GPT3_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define GPT3_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define GPT3_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define GPT3_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define GPT3_CLK_ROOT_FROM_REF_1M_CLK				0x05000000
#define GPT3_CLK_ROOT_FROM_EXT_CLK_3				0x07000000

/* GPT4_CLK_ROOT */
#define GPT4_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define GPT4_CLK_ROOT_FROM_PLL_SYS_PFD0_392M_CLK		0x02000000
#define GPT4_CLK_ROOT_FROM_PLL_ENET_MAIN_100M_CLK		0x01000000
#define GPT4_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x03000000
#define GPT4_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK			0x06000000
#define GPT4_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK			0x04000000
#define GPT4_CLK_ROOT_FROM_REF_1M_CLK				0x05000000
#define GPT4_CLK_ROOT_FROM_EXT_CLK_4				0x07000000

/* TRACE_CLK_ROOT */
#define TRACE_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define TRACE_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define TRACE_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define TRACE_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define TRACE_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x04000000
#define TRACE_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x05000000
#define TRACE_CLK_ROOT_FROM_EXT_CLK_1				0x06000000
#define TRACE_CLK_ROOT_FROM_EXT_CLK_3				0x07000000

/* WDOG_CLK_ROOT */
#define WDOG_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define WDOG_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define WDOG_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define WDOG_CLK_ROOT_FROM_PLL_SYS_PFD1_166M_CLK		0x07000000
#define WDOG_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define WDOG_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x04000000
#define WDOG_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x05000000
#define WDOG_CLK_ROOT_FROM_REF_1M_CLK				0x06000000

/* CSI_MCLK_CLK_ROOT */
#define CSI_MCLK_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x04000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define CSI_MCLK_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* AUDIO_MCLK_CLK_ROOT */
#define AUDIO_MCLK_CLK_ROOT_FROM_OSC_24M_CLK			0x00000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x03000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_SYS_MAIN_120M_CLK		0x02000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_SYS_PFD2_135M_CLK		0x01000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_ENET_MAIN_125M_CLK		0x04000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_AUDIO_MAIN_CLK		0x05000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_VIDEO_MAIN_CLK		0x06000000
#define AUDIO_MCLK_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x07000000

/* WRCLK_CLK_ROOT */
#define WRCLK_CLK_ROOT_FROM_OSC_24M_CLK				0x00000000
#define WRCLK_CLK_ROOT_FROM_PLL_DRAM_MAIN_533M_CLK		0x02000000
#define WRCLK_CLK_ROOT_FROM_PLL_SYS_MAIN_240M_CLK		0x04000000
#define WRCLK_CLK_ROOT_FROM_PLL_SYS_PFD2_270M_CLK		0x05000000
#define WRCLK_CLK_ROOT_FROM_PLL_SYS_PFD7_CLK			0x07000000
#define WRCLK_CLK_ROOT_FROM_PLL_ENET_MAIN_500M_CLK		0x06000000
#define WRCLK_CLK_ROOT_FROM_PLL_ENET_MAIN_40M_CLK		0x01000000
#define WRCLK_CLK_ROOT_FROM_PLL_USB_MAIN_480M_CLK		0x03000000

/* IPP_DO_CLKO1 */
#define IPP_DO_CLKO1_FROM_OSC_24M_CLK				0x00000000
#define IPP_DO_CLKO1_FROM_PLL_DRAM_MAIN_533M_CLK		0x06000000
#define IPP_DO_CLKO1_FROM_PLL_SYS_MAIN_480M_CLK			0x01000000
#define IPP_DO_CLKO1_FROM_PLL_SYS_MAIN_240M_CLK			0x02000000
#define IPP_DO_CLKO1_FROM_PLL_SYS_PFD0_196M_CLK			0x03000000
#define IPP_DO_CLKO1_FROM_PLL_SYS_PFD3_CLK			0x04000000
#define IPP_DO_CLKO1_FROM_PLL_ENET_MAIN_500M_CLK		0x05000000
#define IPP_DO_CLKO1_FROM_REF_1M_CLK				0x07000000

/* IPP_DO_CLKO2 */
#define IPP_DO_CLKO2_FROM_OSC_24M_CLK				0x00000000
#define IPP_DO_CLKO2_FROM_PLL_SYS_MAIN_240M_CLK			0x01000000
#define IPP_DO_CLKO2_FROM_PLL_SYS_PFD0_392M_CLK			0x02000000
#define IPP_DO_CLKO2_FROM_PLL_SYS_PFD1_166M_CLK			0x03000000
#define IPP_DO_CLKO2_FROM_PLL_SYS_PFD4_CLK			0x04000000
#define IPP_DO_CLKO2_FROM_PLL_AUDIO_MAIN_CLK			0x05000000
#define IPP_DO_CLKO2_FROM_PLL_VIDEO_MAIN_CLK			0x06000000
#define IPP_DO_CLKO2_FROM_OSC_32K_CLK				0x07000000

#endif
