/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 * Copyright 2017 - 2018 NXP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX7ULP_PINFUNC_H
#define __DTS_IMX7ULP_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_conf_reg input_reg mux_mode input_val>
 */
#define IMX7ULP_PAD_PTA0__CMP0_IN1_3V                                0x0000 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA0__PTA0                                       0x0000 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA0__LPSPI0_PCS1                                0x0000 0x0104 0x3 0x2
#define IMX7ULP_PAD_PTA0__LPUART0_CTS_B                              0x0000 0x01F8 0x4 0x2
#define IMX7ULP_PAD_PTA0__LPI2C0_SCL                                 0x0000 0x017C 0x5 0x2
#define IMX7ULP_PAD_PTA0__TPM0_CLKIN                                 0x0000 0x01A8 0x6 0x2
#define IMX7ULP_PAD_PTA0__I2S0_RX_BCLK                               0x0000 0x01B8 0x7 0x2
#define IMX7ULP_PAD_PTA0__LLWU0_P0                                   0x0000 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA1__CMP0_IN2_3V                                0x0004 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA1__PTA1                                       0x0004 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA1__LPSPI0_PCS2                                0x0004 0x0108 0x3 0x1
#define IMX7ULP_PAD_PTA1__LPUART0_RTS_B                              0x0004 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA1__LPI2C0_SDA                                 0x0004 0x0180 0x5 0x1
#define IMX7ULP_PAD_PTA1__TPM0_CH0                                   0x0004 0x0138 0x6 0x1
#define IMX7ULP_PAD_PTA1__I2S0_RX_FS                                 0x0004 0x01BC 0x7 0x1
#define IMX7ULP_PAD_PTA2__CMP1_IN2_3V                                0x0008 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA2__PTA2                                       0x0008 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA2__LPSPI0_PCS3                                0x0008 0x010C 0x3 0x1
#define IMX7ULP_PAD_PTA2__LPUART0_TX                                 0x0008 0x0200 0x4 0x1
#define IMX7ULP_PAD_PTA2__LPI2C0_HREQ                                0x0008 0x0178 0x5 0x1
#define IMX7ULP_PAD_PTA2__TPM0_CH1                                   0x0008 0x013C 0x6 0x1
#define IMX7ULP_PAD_PTA2__I2S0_RXD0                                  0x0008 0x01DC 0x7 0x1
#define IMX7ULP_PAD_PTA3__CMP1_IN4_3V                                0x000C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA3__PTA3                                       0x000C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA3__LPSPI0_PCS0                                0x000C 0x0100 0x3 0x1
#define IMX7ULP_PAD_PTA3__LPUART0_RX                                 0x000C 0x01FC 0x4 0x1
#define IMX7ULP_PAD_PTA3__TPM0_CH2                                   0x000C 0x0140 0x6 0x1
#define IMX7ULP_PAD_PTA3__I2S0_RXD1                                  0x000C 0x01E0 0x7 0x1
#define IMX7ULP_PAD_PTA3__CMP0_OUT                                   0x000C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA3__LLWU0_P1                                   0x000C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA4__ADC1_CH3A                                  0x0010 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA4__PTA4                                       0x0010 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA4__LPSPI0_SIN                                 0x0010 0x0114 0x3 0x1
#define IMX7ULP_PAD_PTA4__LPUART1_CTS_B                              0x0010 0x0204 0x4 0x1
#define IMX7ULP_PAD_PTA4__LPI2C1_SCL                                 0x0010 0x0188 0x5 0x1
#define IMX7ULP_PAD_PTA4__TPM0_CH3                                   0x0010 0x0144 0x6 0x1
#define IMX7ULP_PAD_PTA4__I2S0_MCLK                                  0x0010 0x01B4 0x7 0x1
#define IMX7ULP_PAD_PTA5__ADC1_CH3B                                  0x0014 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA5__PTA5                                       0x0014 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA5__LPSPI0_SOUT                                0x0014 0x0118 0x3 0x1
#define IMX7ULP_PAD_PTA5__LPUART1_RTS_B                              0x0014 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA5__LPI2C1_SDA                                 0x0014 0x018C 0x5 0x1
#define IMX7ULP_PAD_PTA5__TPM0_CH4                                   0x0014 0x0148 0x6 0x1
#define IMX7ULP_PAD_PTA5__I2S0_TX_BCLK                               0x0014 0x01C0 0x7 0x1
#define IMX7ULP_PAD_PTA6__ADC1_CH4A                                  0x0018 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA6__PTA6                                       0x0018 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA6__LPSPI0_SCK                                 0x0018 0x0110 0x3 0x1
#define IMX7ULP_PAD_PTA6__LPUART1_TX                                 0x0018 0x020C 0x4 0x1
#define IMX7ULP_PAD_PTA6__LPI2C1_HREQ                                0x0018 0x0184 0x5 0x1
#define IMX7ULP_PAD_PTA6__TPM0_CH5                                   0x0018 0x014C 0x6 0x1
#define IMX7ULP_PAD_PTA6__I2S0_TX_FS                                 0x0018 0x01C4 0x7 0x1
#define IMX7ULP_PAD_PTA7__ADC1_CH4B                                  0x001C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA7__PTA7                                       0x001C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA7__LPUART1_RX                                 0x001C 0x0208 0x4 0x1
#define IMX7ULP_PAD_PTA7__TPM1_CH1                                   0x001C 0x0154 0x6 0x1
#define IMX7ULP_PAD_PTA7__I2S0_TXD0                                  0x001C 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA8__ADC1_CH5A                                  0x0020 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA8__PTA8                                       0x0020 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA8__LPSPI1_PCS1                                0x0020 0x0120 0x3 0x1
#define IMX7ULP_PAD_PTA8__LPUART2_CTS_B                              0x0020 0x0210 0x4 0x1
#define IMX7ULP_PAD_PTA8__LPI2C2_SCL                                 0x0020 0x0194 0x5 0x1
#define IMX7ULP_PAD_PTA8__TPM1_CLKIN                                 0x0020 0x01AC 0x6 0x1
#define IMX7ULP_PAD_PTA8__I2S0_TXD1                                  0x0020 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA9__ADC1_CH5B                                  0x0024 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA9__PTA9                                       0x0024 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA9__LPSPI1_PCS2                                0x0024 0x0124 0x3 0x1
#define IMX7ULP_PAD_PTA9__LPUART2_RTS_B                              0x0024 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA9__LPI2C2_SDA                                 0x0024 0x0198 0x5 0x1
#define IMX7ULP_PAD_PTA9__TPM1_CH0                                   0x0024 0x0150 0x6 0x1
#define IMX7ULP_PAD_PTA9__NMI0_B                                     0x0024 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA10__ADC1_CH6A                                 0x0028 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA10__PTA10                                     0x0028 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA10__LPSPI1_PCS3                               0x0028 0x0128 0x3 0x1
#define IMX7ULP_PAD_PTA10__LPUART2_TX                                0x0028 0x0218 0x4 0x1
#define IMX7ULP_PAD_PTA10__LPI2C2_HREQ                               0x0028 0x0190 0x5 0x1
#define IMX7ULP_PAD_PTA10__TPM2_CLKIN                                0x0028 0x01F4 0x6 0x1
#define IMX7ULP_PAD_PTA10__I2S0_RX_BCLK                              0x0028 0x01B8 0x7 0x1
#define IMX7ULP_PAD_PTA11__ADC1_CH6B                                 0x002C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA11__PTA11                                     0x002C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA11__LPUART2_RX                                0x002C 0x0214 0x4 0x1
#define IMX7ULP_PAD_PTA11__TPM2_CH0                                  0x002C 0x0158 0x6 0x1
#define IMX7ULP_PAD_PTA11__I2S0_RX_FS                                0x002C 0x01BC 0x7 0x2
#define IMX7ULP_PAD_PTA12__ADC1_CH7A                                 0x0030 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA12__PTA12                                     0x0030 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA12__LPSPI1_SIN                                0x0030 0x0130 0x3 0x1
#define IMX7ULP_PAD_PTA12__LPUART3_CTS_B                             0x0030 0x021C 0x4 0x1
#define IMX7ULP_PAD_PTA12__LPI2C3_SCL                                0x0030 0x01A0 0x5 0x1
#define IMX7ULP_PAD_PTA12__TPM2_CH1                                  0x0030 0x015C 0x6 0x1
#define IMX7ULP_PAD_PTA12__I2S0_RXD0                                 0x0030 0x01DC 0x7 0x2
#define IMX7ULP_PAD_PTA13__ADC1_CH7B                                 0x0034 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA13__PTA13                                     0x0034 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA13__LPSPI1_SOUT                               0x0034 0x0134 0x3 0x2
#define IMX7ULP_PAD_PTA13__LPUART3_RTS_B                             0x0034 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA13__LPI2C3_SDA                                0x0034 0x01A4 0x5 0x2
#define IMX7ULP_PAD_PTA13__TPM3_CLKIN                                0x0034 0x01B0 0x6 0x1
#define IMX7ULP_PAD_PTA13__I2S0_RXD1                                 0x0034 0x01E0 0x7 0x2
#define IMX7ULP_PAD_PTA13__CMP0_OUT                                  0x0034 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA13__LLWU0_P2                                  0x0034 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA14__ADC1_CH8A                                 0x0038 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA14__PTA14                                     0x0038 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA14__LPSPI1_SCK                                0x0038 0x012C 0x3 0x2
#define IMX7ULP_PAD_PTA14__LPUART3_TX                                0x0038 0x0224 0x4 0x2
#define IMX7ULP_PAD_PTA14__LPI2C3_HREQ                               0x0038 0x019C 0x5 0x2
#define IMX7ULP_PAD_PTA14__TPM3_CH0                                  0x0038 0x0160 0x6 0x1
#define IMX7ULP_PAD_PTA14__I2S0_MCLK                                 0x0038 0x01B4 0x7 0x2
#define IMX7ULP_PAD_PTA14__LLWU0_P3                                  0x0038 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA15__ADC1_CH8B                                 0x003C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA15__PTA15                                     0x003C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA15__LPSPI1_PCS0                               0x003C 0x011C 0x3 0x1
#define IMX7ULP_PAD_PTA15__LPUART3_RX                                0x003C 0x0220 0x4 0x1
#define IMX7ULP_PAD_PTA15__TPM3_CH1                                  0x003C 0x0164 0x6 0x1
#define IMX7ULP_PAD_PTA15__I2S0_TX_BCLK                              0x003C 0x01C0 0x7 0x2
#define IMX7ULP_PAD_PTA16__CMP1_IN5_3V                               0x0040 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA16__PTA16                                     0x0040 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA16__FXIO0_D0                                  0x0040 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA16__LPSPI0_SOUT                               0x0040 0x0118 0x3 0x2
#define IMX7ULP_PAD_PTA16__LPUART0_CTS_B                             0x0040 0x01F8 0x4 0x1
#define IMX7ULP_PAD_PTA16__LPI2C0_SCL                                0x0040 0x017C 0x5 0x1
#define IMX7ULP_PAD_PTA16__TPM3_CH2                                  0x0040 0x0168 0x6 0x1
#define IMX7ULP_PAD_PTA16__I2S0_TX_FS                                0x0040 0x01C4 0x7 0x2
#define IMX7ULP_PAD_PTA17__CMP1_IN6_3V                               0x0044 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA17__PTA17                                     0x0044 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA17__FXIO0_D1                                  0x0044 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA17__LPSPI0_SCK                                0x0044 0x0110 0x3 0x2
#define IMX7ULP_PAD_PTA17__LPUART0_RTS_B                             0x0044 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA17__LPI2C0_SDA                                0x0044 0x0180 0x5 0x2
#define IMX7ULP_PAD_PTA17__TPM3_CH3                                  0x0044 0x016C 0x6 0x1
#define IMX7ULP_PAD_PTA17__I2S0_TXD0                                 0x0044 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA18__CMP1_IN1_3V                               0x0048 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA18__PTA18                                     0x0048 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA18__FXIO0_D2                                  0x0048 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA18__LPSPI0_PCS0                               0x0048 0x0100 0x3 0x2
#define IMX7ULP_PAD_PTA18__LPUART0_TX                                0x0048 0x0200 0x4 0x2
#define IMX7ULP_PAD_PTA18__LPI2C0_HREQ                               0x0048 0x0178 0x5 0x2
#define IMX7ULP_PAD_PTA18__TPM3_CH4                                  0x0048 0x0170 0x6 0x1
#define IMX7ULP_PAD_PTA18__I2S0_TXD1                                 0x0048 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA18__LLWU0_P4                                  0x0048 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA19__CMP1_IN3_3V                               0x004C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA19__PTA19                                     0x004C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA19__FXIO0_D3                                  0x004C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA19__LPUART0_RX                                0x004C 0x01FC 0x4 0x2
#define IMX7ULP_PAD_PTA19__TPM3_CH5                                  0x004C 0x0174 0x6 0x1
#define IMX7ULP_PAD_PTA19__I2S1_RX_BCLK                              0x004C 0x01CC 0x7 0x1
#define IMX7ULP_PAD_PTA19__LPTMR0_ALT3                               0x004C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA19__LLWU0_P5                                  0x004C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA20__ADC0_CH10A                                0x0050 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA20__PTA20                                     0x0050 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA20__FXIO0_D4                                  0x0050 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA20__LPSPI0_SIN                                0x0050 0x0114 0x3 0x2
#define IMX7ULP_PAD_PTA20__LPUART1_CTS_B                             0x0050 0x0204 0x4 0x2
#define IMX7ULP_PAD_PTA20__LPI2C1_SCL                                0x0050 0x0188 0x5 0x2
#define IMX7ULP_PAD_PTA20__TPM0_CLKIN                                0x0050 0x01A8 0x6 0x1
#define IMX7ULP_PAD_PTA20__I2S1_RX_FS                                0x0050 0x01D0 0x7 0x1
#define IMX7ULP_PAD_PTA21__ADC0_CH10B                                0x0054 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA21__PTA21                                     0x0054 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA21__FXIO0_D5                                  0x0054 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA21__LPSPI0_PCS1                               0x0054 0x0104 0x3 0x1
#define IMX7ULP_PAD_PTA21__LPUART1_RTS_B                             0x0054 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA21__LPI2C1_SDA                                0x0054 0x018C 0x5 0x2
#define IMX7ULP_PAD_PTA21__TPM0_CH0                                  0x0054 0x0138 0x6 0x2
#define IMX7ULP_PAD_PTA21__I2S1_RXD0                                 0x0054 0x01E4 0x7 0x1
#define IMX7ULP_PAD_PTA22__ADC0_CH9A                                 0x0058 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA22__PTA22                                     0x0058 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA22__FXIO0_D6                                  0x0058 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA22__LPSPI0_PCS2                               0x0058 0x0108 0x3 0x2
#define IMX7ULP_PAD_PTA22__LPUART1_TX                                0x0058 0x020C 0x4 0x2
#define IMX7ULP_PAD_PTA22__LPI2C1_HREQ                               0x0058 0x0184 0x5 0x2
#define IMX7ULP_PAD_PTA22__TPM0_CH1                                  0x0058 0x013C 0x6 0x2
#define IMX7ULP_PAD_PTA22__I2S1_RXD1                                 0x0058 0x01E8 0x7 0x1
#define IMX7ULP_PAD_PTA22__LPTMR0_ALT2                               0x0058 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA22__EWM_OUT_B                                 0x0058 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTA23__ADC0_CH9B                                 0x005C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA23__PTA23                                     0x005C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA23__FXIO0_D7                                  0x005C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA23__LPSPI0_PCS3                               0x005C 0x010C 0x3 0x2
#define IMX7ULP_PAD_PTA23__LPUART1_RX                                0x005C 0x0208 0x4 0x2
#define IMX7ULP_PAD_PTA23__TPM0_CH2                                  0x005C 0x0140 0x6 0x2
#define IMX7ULP_PAD_PTA23__I2S1_MCLK                                 0x005C 0x01C8 0x7 0x1
#define IMX7ULP_PAD_PTA23__LLWU0_P6                                  0x005C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTA24__ADC0_CH8A                                 0x0060 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA24__PTA24                                     0x0060 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA24__FXIO0_D8                                  0x0060 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA24__LPSPI1_PCS1                               0x0060 0x0120 0x3 0x2
#define IMX7ULP_PAD_PTA24__LPUART2_CTS_B                             0x0060 0x0210 0x4 0x2
#define IMX7ULP_PAD_PTA24__LPI2C2_SCL                                0x0060 0x0194 0x5 0x2
#define IMX7ULP_PAD_PTA24__TPM0_CH3                                  0x0060 0x0144 0x6 0x2
#define IMX7ULP_PAD_PTA24__I2S1_TX_BCLK                              0x0060 0x01D4 0x7 0x1
#define IMX7ULP_PAD_PTA25__ADC0_CH8B                                 0x0064 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA25__PTA25                                     0x0064 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA25__FXIO0_D9                                  0x0064 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA25__LPSPI1_PCS2                               0x0064 0x0124 0x3 0x2
#define IMX7ULP_PAD_PTA25__LPUART2_RTS_B                             0x0064 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA25__LPI2C2_SDA                                0x0064 0x0198 0x5 0x2
#define IMX7ULP_PAD_PTA25__TPM0_CH4                                  0x0064 0x0148 0x6 0x2
#define IMX7ULP_PAD_PTA25__I2S1_TX_FS                                0x0064 0x01D8 0x7 0x1
#define IMX7ULP_PAD_PTA26__PTA26                                     0x0068 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA26__JTAG_TMS_SWD_DIO                          0x0068 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTA26__FXIO0_D10                                 0x0068 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA26__LPSPI1_PCS3                               0x0068 0x0128 0x3 0x2
#define IMX7ULP_PAD_PTA26__LPUART2_TX                                0x0068 0x0218 0x4 0x2
#define IMX7ULP_PAD_PTA26__LPI2C2_HREQ                               0x0068 0x0190 0x5 0x2
#define IMX7ULP_PAD_PTA26__TPM0_CH5                                  0x0068 0x014C 0x6 0x2
#define IMX7ULP_PAD_PTA26__I2S1_RXD2                                 0x0068 0x01EC 0x7 0x1
#define IMX7ULP_PAD_PTA27__PTA27                                     0x006C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA27__JTAG_TDO                                  0x006C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTA27__FXIO0_D11                                 0x006C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA27__LPUART2_RX                                0x006C 0x0214 0x4 0x2
#define IMX7ULP_PAD_PTA27__TPM1_CH1                                  0x006C 0x0154 0x6 0x2
#define IMX7ULP_PAD_PTA27__I2S1_RXD3                                 0x006C 0x01F0 0x7 0x1
#define IMX7ULP_PAD_PTA28__PTA28                                     0x0070 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA28__JTAG_TDI                                  0x0070 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTA28__FXIO0_D12                                 0x0070 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA28__LPSPI1_SIN                                0x0070 0x0130 0x3 0x2
#define IMX7ULP_PAD_PTA28__LPUART3_CTS_B                             0x0070 0x021C 0x4 0x2
#define IMX7ULP_PAD_PTA28__LPI2C3_SCL                                0x0070 0x01A0 0x5 0x2
#define IMX7ULP_PAD_PTA28__TPM1_CLKIN                                0x0070 0x01AC 0x6 0x2
#define IMX7ULP_PAD_PTA28__I2S1_TXD2                                 0x0070 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA29__PTA29                                     0x0074 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA29__JTAG_TCLK_SWD_CLK                         0x0074 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTA29__FXIO0_D13                                 0x0074 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA29__LPSPI1_SOUT                               0x0074 0x0134 0x3 0x1
#define IMX7ULP_PAD_PTA29__LPUART3_RTS_B                             0x0074 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTA29__LPI2C3_SDA                                0x0074 0x01A4 0x5 0x1
#define IMX7ULP_PAD_PTA29__TPM1_CH0                                  0x0074 0x0150 0x6 0x2
#define IMX7ULP_PAD_PTA29__I2S1_TXD3                                 0x0074 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA30__ADC0_CH1A                                 0x0078 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA30__PTA30                                     0x0078 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA30__FXIO0_D14                                 0x0078 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA30__LPSPI1_SCK                                0x0078 0x012C 0x3 0x1
#define IMX7ULP_PAD_PTA30__LPUART3_TX                                0x0078 0x0224 0x4 0x1
#define IMX7ULP_PAD_PTA30__LPI2C3_HREQ                               0x0078 0x019C 0x5 0x1
#define IMX7ULP_PAD_PTA30__TPM2_CLKIN                                0x0078 0x01F4 0x6 0x2
#define IMX7ULP_PAD_PTA30__I2S1_TXD0                                 0x0078 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA30__JTAG_TRST_B                               0x0078 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTA31__ADC0_CH1B                                 0x007C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTA31__PTA31                                     0x007C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTA31__FXIO0_D15                                 0x007C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTA31__LPSPI1_PCS0                               0x007C 0x011C 0x3 0x2
#define IMX7ULP_PAD_PTA31__LPUART3_RX                                0x007C 0x0220 0x4 0x2
#define IMX7ULP_PAD_PTA31__TPM2_CH0                                  0x007C 0x0158 0x6 0x2
#define IMX7ULP_PAD_PTA31__I2S1_TXD1                                 0x007C 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTA31__LPTMR0_ALT1                               0x007C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTA31__EWM_IN                                    0x007C 0x0228 0xc 0x1
#define IMX7ULP_PAD_PTA31__LLWU0_P7                                  0x007C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB0__ADC0_CH0A                                  0x0080 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB0__PTB0                                       0x0080 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB0__FXIO0_D16                                  0x0080 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB0__LPSPI0_SIN                                 0x0080 0x0114 0x3 0x3
#define IMX7ULP_PAD_PTB0__LPUART0_TX                                 0x0080 0x0200 0x4 0x3
#define IMX7ULP_PAD_PTB0__TPM2_CH1                                   0x0080 0x015C 0x6 0x2
#define IMX7ULP_PAD_PTB0__CLKOUT0                                    0x0080 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTB0__CMP1_OUT                                   0x0080 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB0__EWM_OUT_B                                  0x0080 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTB1__ADC0_CH0B                                  0x0084 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB1__PTB1                                       0x0084 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB1__FXIO0_D17                                  0x0084 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB1__LPSPI0_SOUT                                0x0084 0x0118 0x3 0x3
#define IMX7ULP_PAD_PTB1__LPUART0_RX                                 0x0084 0x01FC 0x4 0x3
#define IMX7ULP_PAD_PTB1__TPM3_CLKIN                                 0x0084 0x01B0 0x6 0x3
#define IMX7ULP_PAD_PTB1__I2S1_TX_BCLK                               0x0084 0x01D4 0x7 0x2
#define IMX7ULP_PAD_PTB1__RTC_CLKOUT                                 0x0084 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB1__EWM_IN                                     0x0084 0x0228 0xc 0x2
#define IMX7ULP_PAD_PTB1__LLWU0_P8                                   0x0084 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB2__ADC0_CH6A                                  0x0088 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB2__PTB2                                       0x0088 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB2__FXIO0_D18                                  0x0088 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB2__LPSPI0_SCK                                 0x0088 0x0110 0x3 0x3
#define IMX7ULP_PAD_PTB2__LPUART1_TX                                 0x0088 0x020C 0x4 0x3
#define IMX7ULP_PAD_PTB2__TPM3_CH0                                   0x0088 0x0160 0x6 0x2
#define IMX7ULP_PAD_PTB2__I2S1_TX_FS                                 0x0088 0x01D8 0x7 0x2
#define IMX7ULP_PAD_PTB2__TRACE_CLKOUT                               0x0088 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB3__ADC0_CH6B                                  0x008C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB3__PTB3                                       0x008C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB3__FXIO0_D19                                  0x008C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB3__LPSPI0_PCS0                                0x008C 0x0100 0x3 0x3
#define IMX7ULP_PAD_PTB3__LPUART1_RX                                 0x008C 0x0208 0x4 0x3
#define IMX7ULP_PAD_PTB3__TPM3_CH1                                   0x008C 0x0164 0x6 0x2
#define IMX7ULP_PAD_PTB3__I2S1_TXD0                                  0x008C 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTB3__TRACE_D0                                   0x008C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB3__LPTMR1_ALT2                                0x008C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB3__LLWU0_P9                                   0x008C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB4__PTB4                                       0x0090 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB4__FXIO0_D20                                  0x0090 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB4__LPSPI0_PCS1                                0x0090 0x0104 0x3 0x3
#define IMX7ULP_PAD_PTB4__LPUART2_TX                                 0x0090 0x0218 0x4 0x3
#define IMX7ULP_PAD_PTB4__LPI2C0_HREQ                                0x0090 0x0178 0x5 0x3
#define IMX7ULP_PAD_PTB4__TPM3_CH2                                   0x0090 0x0168 0x6 0x2
#define IMX7ULP_PAD_PTB4__I2S1_TXD1                                  0x0090 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTB4__QSPIA_DATA7                                0x0090 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB4__TRACE_D1                                   0x0090 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB4__SEC_VIO_B                                  0x0090 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB5__PTB5                                       0x0094 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB5__FXIO0_D21                                  0x0094 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB5__LPSPI0_PCS2                                0x0094 0x0108 0x3 0x3
#define IMX7ULP_PAD_PTB5__LPUART2_RX                                 0x0094 0x0214 0x4 0x3
#define IMX7ULP_PAD_PTB5__LPI2C1_HREQ                                0x0094 0x0184 0x5 0x3
#define IMX7ULP_PAD_PTB5__TPM3_CH3                                   0x0094 0x016C 0x6 0x2
#define IMX7ULP_PAD_PTB5__I2S1_TXD2                                  0x0094 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTB5__QSPIA_DATA6                                0x0094 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB5__TRACE_D2                                   0x0094 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB5__RTC_CLKOUT                                 0x0094 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB6__ADC1_CH1A                                  0x0098 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB6__PTB6                                       0x0098 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB6__FXIO0_D22                                  0x0098 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB6__LPSPI0_PCS3                                0x0098 0x010C 0x3 0x3
#define IMX7ULP_PAD_PTB6__LPUART3_TX                                 0x0098 0x0224 0x4 0x3
#define IMX7ULP_PAD_PTB6__LPI2C0_SCL                                 0x0098 0x017C 0x5 0x3
#define IMX7ULP_PAD_PTB6__TPM3_CH4                                   0x0098 0x0170 0x6 0x2
#define IMX7ULP_PAD_PTB6__I2S1_TXD3                                  0x0098 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTB6__QSPIA_DATA5                                0x0098 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB6__TRACE_D3                                   0x0098 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB6__LPTMR1_ALT3                                0x0098 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB6__LLWU0_P10                                  0x0098 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB7__ADC1_CH1B                                  0x009C 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB7__PTB7                                       0x009C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB7__FXIO0_D23                                  0x009C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB7__LPSPI1_SIN                                 0x009C 0x0130 0x3 0x3
#define IMX7ULP_PAD_PTB7__LPUART3_RX                                 0x009C 0x0220 0x4 0x3
#define IMX7ULP_PAD_PTB7__LPI2C0_SDA                                 0x009C 0x0180 0x5 0x3
#define IMX7ULP_PAD_PTB7__TPM3_CH5                                   0x009C 0x0174 0x6 0x2
#define IMX7ULP_PAD_PTB7__I2S1_MCLK                                  0x009C 0x01C8 0x7 0x2
#define IMX7ULP_PAD_PTB7__QSPIA_SS1_B                                0x009C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB7__CMP1_OUT                                   0x009C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB7__LLWU0_P11                                  0x009C 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB8__ADC0_CH14A_CMP0_IN0                        0x00A0 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB8__PTB8                                       0x00A0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB8__FXIO0_D24                                  0x00A0 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB8__LPSPI1_SOUT                                0x00A0 0x0134 0x3 0x3
#define IMX7ULP_PAD_PTB8__LPI2C1_SCL                                 0x00A0 0x0188 0x5 0x3
#define IMX7ULP_PAD_PTB8__TPM0_CLKIN                                 0x00A0 0x01A8 0x6 0x3
#define IMX7ULP_PAD_PTB8__I2S1_RX_BCLK                               0x00A0 0x01CC 0x7 0x2
#define IMX7ULP_PAD_PTB8__QSPIA_SS0_B                                0x00A0 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB8__RTC_CLKOUT                                 0x00A0 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB9__ADC0_CH14B_CMP0_IN2                        0x00A4 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB9__PTB9                                       0x00A4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB9__FXIO0_D25                                  0x00A4 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB9__LPSPI1_SCK                                 0x00A4 0x012C 0x3 0x3
#define IMX7ULP_PAD_PTB9__LPI2C1_SDA                                 0x00A4 0x018C 0x5 0x3
#define IMX7ULP_PAD_PTB9__TPM0_CH0                                   0x00A4 0x0138 0x6 0x3
#define IMX7ULP_PAD_PTB9__I2S1_RX_FS                                 0x00A4 0x01D0 0x7 0x2
#define IMX7ULP_PAD_PTB9__QSPIA_DQS                                  0x00A4 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB9__LLWU0_P12                                  0x00A4 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB10__CMP0_IN1                                  0x00A8 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB10__PTB10                                     0x00A8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB10__FXIO0_D26                                 0x00A8 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB10__LPSPI1_PCS0                               0x00A8 0x011C 0x3 0x3
#define IMX7ULP_PAD_PTB10__LPI2C2_SCL                                0x00A8 0x0194 0x5 0x3
#define IMX7ULP_PAD_PTB10__TPM0_CH1                                  0x00A8 0x013C 0x6 0x3
#define IMX7ULP_PAD_PTB10__I2S1_RXD0                                 0x00A8 0x01E4 0x7 0x2
#define IMX7ULP_PAD_PTB10__TRACE_D4                                  0x00A8 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB11__CMP0_IN3                                  0x00AC 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB11__PTB11                                     0x00AC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB11__FXIO0_D27                                 0x00AC 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB11__LPSPI1_PCS1                               0x00AC 0x0120 0x3 0x3
#define IMX7ULP_PAD_PTB11__LPI2C2_SDA                                0x00AC 0x0198 0x5 0x3
#define IMX7ULP_PAD_PTB11__TPM1_CLKIN                                0x00AC 0x01AC 0x6 0x3
#define IMX7ULP_PAD_PTB11__I2S1_RXD1                                 0x00AC 0x01E8 0x7 0x2
#define IMX7ULP_PAD_PTB11__TRACE_D5                                  0x00AC 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB12__ADC1_CH13A_CMP1_IN0                       0x00B0 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB12__PTB12                                     0x00B0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB12__FXIO0_D28                                 0x00B0 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB12__LPSPI1_PCS2                               0x00B0 0x0124 0x3 0x3
#define IMX7ULP_PAD_PTB12__LPUART2_TX                                0x00B0 0x0218 0x4 0x4
#define IMX7ULP_PAD_PTB12__LPI2C3_SCL                                0x00B0 0x01A0 0x5 0x3
#define IMX7ULP_PAD_PTB12__TPM1_CH0                                  0x00B0 0x0150 0x6 0x3
#define IMX7ULP_PAD_PTB12__I2S1_RXD2                                 0x00B0 0x01EC 0x7 0x2
#define IMX7ULP_PAD_PTB12__TRACE_D6                                  0x00B0 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB13__ADC1_CH13B_CMP1_IN1                       0x00B4 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB13__PTB13                                     0x00B4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB13__FXIO0_D29                                 0x00B4 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB13__LPSPI1_PCS3                               0x00B4 0x0128 0x3 0x3
#define IMX7ULP_PAD_PTB13__LPUART2_RX                                0x00B4 0x0214 0x4 0x4
#define IMX7ULP_PAD_PTB13__LPI2C3_SDA                                0x00B4 0x01A4 0x5 0x3
#define IMX7ULP_PAD_PTB13__TPM1_CH1                                  0x00B4 0x0154 0x6 0x3
#define IMX7ULP_PAD_PTB13__I2S1_RXD3                                 0x00B4 0x01F0 0x7 0x2
#define IMX7ULP_PAD_PTB13__QSPIA_DATA4                               0x00B4 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB13__TRACE_D7                                  0x00B4 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTB14__ADC1_CH2A                                 0x00B8 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB14__PTB14                                     0x00B8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB14__FXIO0_D30                                 0x00B8 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB14__LPI2C2_HREQ                               0x00B8 0x0190 0x5 0x3
#define IMX7ULP_PAD_PTB14__TPM2_CLKIN                                0x00B8 0x01F4 0x6 0x3
#define IMX7ULP_PAD_PTB14__QSPIA_SS1_B                               0x00B8 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB14__QSPIA_SCLK_B                              0x00B8 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTB14__RTC_CLKOUT                                0x00B8 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTB14__LLWU0_P13                                 0x00B8 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB15__ADC1_CH2B                                 0x00BC 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB15__PTB15                                     0x00BC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB15__FXIO0_D31                                 0x00BC 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTB15__LPI2C3_HREQ                               0x00BC 0x019C 0x5 0x3
#define IMX7ULP_PAD_PTB15__TPM2_CH0                                  0x00BC 0x0158 0x6 0x3
#define IMX7ULP_PAD_PTB15__QSPIA_SCLK                                0x00BC 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB16__ADC0_CH4A                                 0x00C0 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB16__PTB16                                     0x00C0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB16__TPM2_CH1                                  0x00C0 0x015C 0x6 0x3
#define IMX7ULP_PAD_PTB16__QSPIA_DATA3                               0x00C0 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB16__LLWU0_P14                                 0x00C0 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTB17__ADC0_CH4B                                 0x00C4 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB17__PTB17                                     0x00C4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB17__TPM3_CLKIN                                0x00C4 0x01B0 0x6 0x2
#define IMX7ULP_PAD_PTB17__QSPIA_DATA2                               0x00C4 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB18__ADC0_CH5A                                 0x00C8 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB18__PTB18                                     0x00C8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB18__TPM3_CH0                                  0x00C8 0x0160 0x6 0x3
#define IMX7ULP_PAD_PTB18__QSPIA_DATA1                               0x00C8 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB19__ADC0_CH5B                                 0x00CC 0x0000 0x0 0x0
#define IMX7ULP_PAD_PTB19__PTB19                                     0x00CC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTB19__TPM3_CH1                                  0x00CC 0x0164 0x6 0x3
#define IMX7ULP_PAD_PTB19__QSPIA_DATA0                               0x00CC 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTB19__USB0_ID                                   0x00CC 0x0338 0xa 0x0
#define IMX7ULP_PAD_PTB19__LLWU0_P15                                 0x00CC 0x0000 0xd 0x0
#define IMX7ULP_PAD_PTC0__PTC0                                       0x0000 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC0__LPUART4_CTS_B                              0x0000 0x0244 0x4 0x1
#define IMX7ULP_PAD_PTC0__LPI2C4_SCL                                 0x0000 0x0278 0x5 0x1
#define IMX7ULP_PAD_PTC0__TPM4_CLKIN                                 0x0000 0x0298 0x6 0x1
#define IMX7ULP_PAD_PTC0__FB_AD0                                     0x0000 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC0__TRACE_D15                                  0x0000 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC1__PTC1                                       0x0004 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC1__LPUART4_RTS_B                              0x0004 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTC1__LPI2C4_SDA                                 0x0004 0x027C 0x5 0x1
#define IMX7ULP_PAD_PTC1__TPM4_CH0                                   0x0004 0x0280 0x6 0x1
#define IMX7ULP_PAD_PTC1__FB_AD1                                     0x0004 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC1__TRACE_D14                                  0x0004 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC2__PTC2                                       0x0008 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC2__LPUART4_TX                                 0x0008 0x024C 0x4 0x1
#define IMX7ULP_PAD_PTC2__LPI2C4_HREQ                                0x0008 0x0274 0x5 0x1
#define IMX7ULP_PAD_PTC2__TPM4_CH1                                   0x0008 0x0284 0x6 0x1
#define IMX7ULP_PAD_PTC2__FB_AD2                                     0x0008 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC2__TRACE_D13                                  0x0008 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC3__PTC3                                       0x000C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC3__LPUART4_RX                                 0x000C 0x0248 0x4 0x1
#define IMX7ULP_PAD_PTC3__TPM4_CH2                                   0x000C 0x0288 0x6 0x1
#define IMX7ULP_PAD_PTC3__FB_AD3                                     0x000C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC3__TRACE_D12                                  0x000C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC4__PTC4                                       0x0010 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC4__FXIO1_D0                                   0x0010 0x0204 0x2 0x1
#define IMX7ULP_PAD_PTC4__LPSPI2_PCS1                                0x0010 0x02A0 0x3 0x1
#define IMX7ULP_PAD_PTC4__LPUART5_CTS_B                              0x0010 0x0250 0x4 0x1
#define IMX7ULP_PAD_PTC4__LPI2C5_SCL                                 0x0010 0x02BC 0x5 0x1
#define IMX7ULP_PAD_PTC4__TPM4_CH3                                   0x0010 0x028C 0x6 0x1
#define IMX7ULP_PAD_PTC4__FB_AD4                                     0x0010 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC4__TRACE_D11                                  0x0010 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC5__PTC5                                       0x0014 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC5__FXIO1_D1                                   0x0014 0x0208 0x2 0x1
#define IMX7ULP_PAD_PTC5__LPSPI2_PCS2                                0x0014 0x02A4 0x3 0x1
#define IMX7ULP_PAD_PTC5__LPUART5_RTS_B                              0x0014 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTC5__LPI2C5_SDA                                 0x0014 0x02C0 0x5 0x1
#define IMX7ULP_PAD_PTC5__TPM4_CH4                                   0x0014 0x0290 0x6 0x1
#define IMX7ULP_PAD_PTC5__FB_AD5                                     0x0014 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC5__TRACE_D10                                  0x0014 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC6__PTC6                                       0x0018 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC6__FXIO1_D2                                   0x0018 0x020C 0x2 0x1
#define IMX7ULP_PAD_PTC6__LPSPI2_PCS3                                0x0018 0x02A8 0x3 0x1
#define IMX7ULP_PAD_PTC6__LPUART5_TX                                 0x0018 0x0258 0x4 0x1
#define IMX7ULP_PAD_PTC6__LPI2C5_HREQ                                0x0018 0x02B8 0x5 0x1
#define IMX7ULP_PAD_PTC6__TPM4_CH5                                   0x0018 0x0294 0x6 0x1
#define IMX7ULP_PAD_PTC6__FB_AD6                                     0x0018 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC6__TRACE_D9                                   0x0018 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC7__PTC7                                       0x001C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC7__FXIO1_D3                                   0x001C 0x0210 0x2 0x1
#define IMX7ULP_PAD_PTC7__LPUART5_RX                                 0x001C 0x0254 0x4 0x1
#define IMX7ULP_PAD_PTC7__TPM5_CH1                                   0x001C 0x02C8 0x6 0x1
#define IMX7ULP_PAD_PTC7__FB_AD7                                     0x001C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC7__TRACE_D8                                   0x001C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC8__PTC8                                       0x0020 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC8__FXIO1_D4                                   0x0020 0x0214 0x2 0x1
#define IMX7ULP_PAD_PTC8__LPSPI2_SIN                                 0x0020 0x02B0 0x3 0x1
#define IMX7ULP_PAD_PTC8__LPUART6_CTS_B                              0x0020 0x025C 0x4 0x1
#define IMX7ULP_PAD_PTC8__LPI2C6_SCL                                 0x0020 0x02FC 0x5 0x1
#define IMX7ULP_PAD_PTC8__TPM5_CLKIN                                 0x0020 0x02CC 0x6 0x1
#define IMX7ULP_PAD_PTC8__FB_AD8                                     0x0020 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC8__TRACE_D7                                   0x0020 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC9__PTC9                                       0x0024 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC9__FXIO1_D5                                   0x0024 0x0218 0x2 0x1
#define IMX7ULP_PAD_PTC9__LPSPI2_SOUT                                0x0024 0x02B4 0x3 0x1
#define IMX7ULP_PAD_PTC9__LPUART6_RTS_B                              0x0024 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTC9__LPI2C6_SDA                                 0x0024 0x0300 0x5 0x1
#define IMX7ULP_PAD_PTC9__TPM5_CH0                                   0x0024 0x02C4 0x6 0x1
#define IMX7ULP_PAD_PTC9__FB_AD9                                     0x0024 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC9__TRACE_D6                                   0x0024 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC10__PTC10                                     0x0028 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC10__FXIO1_D6                                  0x0028 0x021C 0x2 0x1
#define IMX7ULP_PAD_PTC10__LPSPI2_SCK                                0x0028 0x02AC 0x3 0x1
#define IMX7ULP_PAD_PTC10__LPUART6_TX                                0x0028 0x0264 0x4 0x1
#define IMX7ULP_PAD_PTC10__LPI2C6_HREQ                               0x0028 0x02F8 0x5 0x1
#define IMX7ULP_PAD_PTC10__TPM7_CH3                                  0x0028 0x02E8 0x6 0x1
#define IMX7ULP_PAD_PTC10__FB_AD10                                   0x0028 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC10__TRACE_D5                                  0x0028 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC11__PTC11                                     0x002C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC11__FXIO1_D7                                  0x002C 0x0220 0x2 0x1
#define IMX7ULP_PAD_PTC11__LPSPI2_PCS0                               0x002C 0x029C 0x3 0x1
#define IMX7ULP_PAD_PTC11__LPUART6_RX                                0x002C 0x0260 0x4 0x1
#define IMX7ULP_PAD_PTC11__TPM7_CH4                                  0x002C 0x02EC 0x6 0x1
#define IMX7ULP_PAD_PTC11__FB_AD11                                   0x002C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC11__TRACE_D4                                  0x002C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC12__PTC12                                     0x0030 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC12__FXIO1_D8                                  0x0030 0x0224 0x2 0x1
#define IMX7ULP_PAD_PTC12__LPSPI3_PCS1                               0x0030 0x0314 0x3 0x1
#define IMX7ULP_PAD_PTC12__LPUART7_CTS_B                             0x0030 0x0268 0x4 0x1
#define IMX7ULP_PAD_PTC12__LPI2C7_SCL                                0x0030 0x0308 0x5 0x1
#define IMX7ULP_PAD_PTC12__TPM7_CH5                                  0x0030 0x02F0 0x6 0x1
#define IMX7ULP_PAD_PTC12__FB_AD12                                   0x0030 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC12__TRACE_D3                                  0x0030 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC13__PTC13                                     0x0034 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC13__FXIO1_D9                                  0x0034 0x0228 0x2 0x1
#define IMX7ULP_PAD_PTC13__LPSPI3_PCS2                               0x0034 0x0318 0x3 0x1
#define IMX7ULP_PAD_PTC13__LPUART7_RTS_B                             0x0034 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTC13__LPI2C7_SDA                                0x0034 0x030C 0x5 0x1
#define IMX7ULP_PAD_PTC13__TPM7_CLKIN                                0x0034 0x02F4 0x6 0x1
#define IMX7ULP_PAD_PTC13__FB_AD13                                   0x0034 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC13__TRACE_D2                                  0x0034 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC13__USB0_ID                                   0x0034 0x0338 0xb 0x1
#define IMX7ULP_PAD_PTC14__PTC14                                     0x0038 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC14__FXIO1_D10                                 0x0038 0x022C 0x2 0x1
#define IMX7ULP_PAD_PTC14__LPSPI3_PCS3                               0x0038 0x031C 0x3 0x1
#define IMX7ULP_PAD_PTC14__LPUART7_TX                                0x0038 0x0270 0x4 0x1
#define IMX7ULP_PAD_PTC14__LPI2C7_HREQ                               0x0038 0x0304 0x5 0x1
#define IMX7ULP_PAD_PTC14__TPM7_CH0                                  0x0038 0x02DC 0x6 0x1
#define IMX7ULP_PAD_PTC14__FB_AD14                                   0x0038 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC14__TRACE_D1                                  0x0038 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC15__PTC15                                     0x003C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC15__FXIO1_D11                                 0x003C 0x0230 0x2 0x1
#define IMX7ULP_PAD_PTC15__LPUART7_RX                                0x003C 0x026C 0x4 0x1
#define IMX7ULP_PAD_PTC15__TPM7_CH1                                  0x003C 0x02E0 0x6 0x1
#define IMX7ULP_PAD_PTC15__FB_AD15                                   0x003C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC15__TRACE_D0                                  0x003C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC16__PTC16                                     0x0040 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC16__FXIO1_D12                                 0x0040 0x0234 0x2 0x1
#define IMX7ULP_PAD_PTC16__LPSPI3_SIN                                0x0040 0x0324 0x3 0x1
#define IMX7ULP_PAD_PTC16__TPM7_CH2                                  0x0040 0x02E4 0x6 0x1
#define IMX7ULP_PAD_PTC16__FB_ALE_FB_CS1_B_FB_TS_B                   0x0040 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC16__TRACE_CLKOUT                              0x0040 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTC16__USB1_OC2                                  0x0040 0x0334 0xb 0x1
#define IMX7ULP_PAD_PTC17__PTC17                                     0x0044 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC17__FXIO1_D13                                 0x0044 0x0238 0x2 0x1
#define IMX7ULP_PAD_PTC17__LPSPI3_SOUT                               0x0044 0x0328 0x3 0x1
#define IMX7ULP_PAD_PTC17__TPM6_CLKIN                                0x0044 0x02D8 0x6 0x1
#define IMX7ULP_PAD_PTC17__FB_CS0_B                                  0x0044 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC18__PTC18                                     0x0048 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC18__FXIO1_D14                                 0x0048 0x023C 0x2 0x1
#define IMX7ULP_PAD_PTC18__LPSPI3_SCK                                0x0048 0x0320 0x3 0x1
#define IMX7ULP_PAD_PTC18__TPM6_CH0                                  0x0048 0x02D0 0x6 0x1
#define IMX7ULP_PAD_PTC18__FB_OE_B                                   0x0048 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC18__USB0_ID                                   0x0048 0x0338 0xb 0x2
#define IMX7ULP_PAD_PTC18__VIU_DE                                    0x0048 0x033C 0xc 0x1
#define IMX7ULP_PAD_PTC19__PTC19                                     0x004C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTC19__FXIO1_D15                                 0x004C 0x0240 0x2 0x1
#define IMX7ULP_PAD_PTC19__LPSPI3_PCS0                               0x004C 0x0310 0x3 0x1
#define IMX7ULP_PAD_PTC19__TPM6_CH1                                  0x004C 0x02D4 0x6 0x1
#define IMX7ULP_PAD_PTC19__FB_A16                                    0x004C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTC19__USB0_ID                                   0x004C 0x0338 0xa 0x3
#define IMX7ULP_PAD_PTC19__USB1_PWR2                                 0x004C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTC19__VIU_DE                                    0x004C 0x033C 0xc 0x3
#define IMX7ULP_PAD_PTD0__PTD0                                       0x0080 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD0__SDHC0_RESET_B                              0x0080 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD1__PTD1                                       0x0084 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD1__SDHC0_CMD                                  0x0084 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD2__PTD2                                       0x0088 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD2__SDHC0_CLK                                  0x0088 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD3__PTD3                                       0x008C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD3__SDHC0_D7                                   0x008C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD4__PTD4                                       0x0090 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD4__SDHC0_D6                                   0x0090 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD5__PTD5                                       0x0094 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD5__SDHC0_D5                                   0x0094 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD6__PTD6                                       0x0098 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD6__SDHC0_D4                                   0x0098 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD7__PTD7                                       0x009C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD7__SDHC0_D3                                   0x009C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD8__PTD8                                       0x00A0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD8__TPM4_CLKIN                                 0x00A0 0x0298 0x6 0x2
#define IMX7ULP_PAD_PTD8__SDHC0_D2                                   0x00A0 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD9__PTD9                                       0x00A4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD9__TPM4_CH0                                   0x00A4 0x0280 0x6 0x2
#define IMX7ULP_PAD_PTD9__SDHC0_D1                                   0x00A4 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD10__PTD10                                     0x00A8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD10__TPM4_CH1                                  0x00A8 0x0284 0x6 0x2
#define IMX7ULP_PAD_PTD10__SDHC0_D0                                  0x00A8 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTD11__PTD11                                     0x00AC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTD11__TPM4_CH2                                  0x00AC 0x0288 0x6 0x2
#define IMX7ULP_PAD_PTD11__SDHC0_DQS                                 0x00AC 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE0__PTE0                                       0x0100 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE0__FXIO1_D31                                  0x0100 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE0__LPSPI2_PCS1                                0x0100 0x02A0 0x3 0x2
#define IMX7ULP_PAD_PTE0__LPUART4_CTS_B                              0x0100 0x0244 0x4 0x2
#define IMX7ULP_PAD_PTE0__LPI2C4_SCL                                 0x0100 0x0278 0x5 0x2
#define IMX7ULP_PAD_PTE0__SDHC1_D1                                   0x0100 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE0__FB_A25                                     0x0100 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE1__PTE1                                       0x0104 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE1__FXIO1_D30                                  0x0104 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE1__LPSPI2_PCS2                                0x0104 0x02A4 0x3 0x2
#define IMX7ULP_PAD_PTE1__LPUART4_RTS_B                              0x0104 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTE1__LPI2C4_SDA                                 0x0104 0x027C 0x5 0x2
#define IMX7ULP_PAD_PTE1__SDHC1_D0                                   0x0104 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE1__FB_A26                                     0x0104 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE2__PTE2                                       0x0108 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE2__FXIO1_D29                                  0x0108 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE2__LPSPI2_PCS3                                0x0108 0x02A8 0x3 0x2
#define IMX7ULP_PAD_PTE2__LPUART4_TX                                 0x0108 0x024C 0x4 0x2
#define IMX7ULP_PAD_PTE2__LPI2C4_HREQ                                0x0108 0x0274 0x5 0x2
#define IMX7ULP_PAD_PTE2__SDHC1_CLK                                  0x0108 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE3__PTE3                                       0x010C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE3__FXIO1_D28                                  0x010C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE3__LPUART4_RX                                 0x010C 0x0248 0x4 0x2
#define IMX7ULP_PAD_PTE3__TPM5_CH1                                   0x010C 0x02C8 0x6 0x2
#define IMX7ULP_PAD_PTE3__SDHC1_CMD                                  0x010C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE4__PTE4                                       0x0110 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE4__FXIO1_D27                                  0x0110 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE4__LPSPI2_SIN                                 0x0110 0x02B0 0x3 0x2
#define IMX7ULP_PAD_PTE4__LPUART5_CTS_B                              0x0110 0x0250 0x4 0x2
#define IMX7ULP_PAD_PTE4__LPI2C5_SCL                                 0x0110 0x02BC 0x5 0x2
#define IMX7ULP_PAD_PTE4__TPM5_CLKIN                                 0x0110 0x02CC 0x6 0x2
#define IMX7ULP_PAD_PTE4__SDHC1_D3                                   0x0110 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE5__PTE5                                       0x0114 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE5__FXIO1_D26                                  0x0114 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE5__LPSPI2_SOUT                                0x0114 0x02B4 0x3 0x2
#define IMX7ULP_PAD_PTE5__LPUART5_RTS_B                              0x0114 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTE5__LPI2C5_SDA                                 0x0114 0x02C0 0x5 0x2
#define IMX7ULP_PAD_PTE5__TPM5_CH0                                   0x0114 0x02C4 0x6 0x2
#define IMX7ULP_PAD_PTE5__SDHC1_D2                                   0x0114 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE5__VIU_DE                                     0x0114 0x033C 0xc 0x2
#define IMX7ULP_PAD_PTE6__PTE6                                       0x0118 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE6__FXIO1_D25                                  0x0118 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE6__LPSPI2_SCK                                 0x0118 0x02AC 0x3 0x2
#define IMX7ULP_PAD_PTE6__LPUART5_TX                                 0x0118 0x0258 0x4 0x2
#define IMX7ULP_PAD_PTE6__LPI2C5_HREQ                                0x0118 0x02B8 0x5 0x2
#define IMX7ULP_PAD_PTE6__TPM7_CH3                                   0x0118 0x02E8 0x6 0x2
#define IMX7ULP_PAD_PTE6__SDHC1_D4                                   0x0118 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE6__FB_A17                                     0x0118 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE6__USB0_OC                                    0x0118 0x0330 0xb 0x1
#define IMX7ULP_PAD_PTE7__PTE7                                       0x011C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE7__FXIO1_D24                                  0x011C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE7__LPSPI2_PCS0                                0x011C 0x029C 0x3 0x2
#define IMX7ULP_PAD_PTE7__LPUART5_RX                                 0x011C 0x0254 0x4 0x2
#define IMX7ULP_PAD_PTE7__TPM7_CH4                                   0x011C 0x02EC 0x6 0x2
#define IMX7ULP_PAD_PTE7__SDHC1_D5                                   0x011C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE7__FB_A18                                     0x011C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE7__TRACE_D7                                   0x011C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE7__USB0_PWR                                   0x011C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTE7__VIU_FID                                    0x011C 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE8__PTE8                                       0x0120 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE8__TRACE_D6                                   0x0120 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE8__VIU_D16                                    0x0120 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE8__FXIO1_D23                                  0x0120 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE8__LPSPI3_PCS1                                0x0120 0x0314 0x3 0x2
#define IMX7ULP_PAD_PTE8__LPUART6_CTS_B                              0x0120 0x025C 0x4 0x2
#define IMX7ULP_PAD_PTE8__LPI2C6_SCL                                 0x0120 0x02FC 0x5 0x2
#define IMX7ULP_PAD_PTE8__TPM7_CH5                                   0x0120 0x02F0 0x6 0x2
#define IMX7ULP_PAD_PTE8__SDHC1_WP                                   0x0120 0x0200 0x7 0x1
#define IMX7ULP_PAD_PTE8__SDHC1_D6                                   0x0120 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE8__FB_CS3_B_FB_BE7_0_BLS31_24_B               0x0120 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE9__PTE9                                       0x0124 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE9__TRACE_D5                                   0x0124 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE9__VIU_D17                                    0x0124 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE9__FXIO1_D22                                  0x0124 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE9__LPSPI3_PCS2                                0x0124 0x0318 0x3 0x2
#define IMX7ULP_PAD_PTE9__LPUART6_RTS_B                              0x0124 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTE9__LPI2C6_SDA                                 0x0124 0x0300 0x5 0x2
#define IMX7ULP_PAD_PTE9__TPM7_CLKIN                                 0x0124 0x02F4 0x6 0x2
#define IMX7ULP_PAD_PTE9__SDHC1_CD                                   0x0124 0x032C 0x7 0x1
#define IMX7ULP_PAD_PTE9__SDHC1_D7                                   0x0124 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE9__FB_TBST_B_FB_CS2_B_FB_BE15_8_BLS23_16_B    0x0124 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE10__PTE10                                     0x0128 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE10__TRACE_D4                                  0x0128 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE10__VIU_D18                                   0x0128 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE10__FXIO1_D21                                 0x0128 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE10__LPSPI3_PCS3                               0x0128 0x031C 0x3 0x2
#define IMX7ULP_PAD_PTE10__LPUART6_TX                                0x0128 0x0264 0x4 0x2
#define IMX7ULP_PAD_PTE10__LPI2C6_HREQ                               0x0128 0x02F8 0x5 0x2
#define IMX7ULP_PAD_PTE10__TPM7_CH0                                  0x0128 0x02DC 0x6 0x2
#define IMX7ULP_PAD_PTE10__SDHC1_VS                                  0x0128 0x0000 0x7 0x0
#define IMX7ULP_PAD_PTE10__SDHC1_DQS                                 0x0128 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE10__FB_A19                                    0x0128 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE11__PTE11                                     0x012C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE11__TRACE_D3                                  0x012C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE11__VIU_D19                                   0x012C 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE11__FXIO1_D20                                 0x012C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE11__LPUART6_RX                                0x012C 0x0260 0x4 0x2
#define IMX7ULP_PAD_PTE11__TPM7_CH1                                  0x012C 0x02E0 0x6 0x2
#define IMX7ULP_PAD_PTE11__SDHC1_RESET_B                             0x012C 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE11__FB_A20                                    0x012C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE12__PTE12                                     0x0130 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE12__FXIO1_D19                                 0x0130 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE12__LPSPI3_SIN                                0x0130 0x0324 0x3 0x2
#define IMX7ULP_PAD_PTE12__LPUART7_CTS_B                             0x0130 0x0268 0x4 0x2
#define IMX7ULP_PAD_PTE12__LPI2C7_SCL                                0x0130 0x0308 0x5 0x2
#define IMX7ULP_PAD_PTE12__TPM7_CH2                                  0x0130 0x02E4 0x6 0x2
#define IMX7ULP_PAD_PTE12__SDHC1_WP                                  0x0130 0x0200 0x8 0x2
#define IMX7ULP_PAD_PTE12__FB_A21                                    0x0130 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE12__TRACE_D2                                  0x0130 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE12__USB1_OC2                                  0x0130 0x0334 0xb 0x2
#define IMX7ULP_PAD_PTE12__VIU_D20                                   0x0130 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE13__PTE13                                     0x0134 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE13__FXIO1_D18                                 0x0134 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE13__LPSPI3_SOUT                               0x0134 0x0328 0x3 0x2
#define IMX7ULP_PAD_PTE13__LPUART7_RTS_B                             0x0134 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTE13__LPI2C7_SDA                                0x0134 0x030C 0x5 0x2
#define IMX7ULP_PAD_PTE13__TPM6_CLKIN                                0x0134 0x02D8 0x6 0x2
#define IMX7ULP_PAD_PTE13__SDHC1_CD                                  0x0134 0x032C 0x8 0x2
#define IMX7ULP_PAD_PTE13__FB_A22                                    0x0134 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE13__TRACE_D1                                  0x0134 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE13__USB1_PWR2                                 0x0134 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTE13__VIU_D21                                   0x0134 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE14__PTE14                                     0x0138 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE14__FXIO1_D17                                 0x0138 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE14__LPSPI3_SCK                                0x0138 0x0320 0x3 0x2
#define IMX7ULP_PAD_PTE14__LPUART7_TX                                0x0138 0x0270 0x4 0x2
#define IMX7ULP_PAD_PTE14__LPI2C7_HREQ                               0x0138 0x0304 0x5 0x2
#define IMX7ULP_PAD_PTE14__TPM6_CH0                                  0x0138 0x02D0 0x6 0x2
#define IMX7ULP_PAD_PTE14__SDHC1_VS                                  0x0138 0x0000 0x8 0x0
#define IMX7ULP_PAD_PTE14__FB_A23                                    0x0138 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE14__TRACE_D0                                  0x0138 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE14__USB0_OC                                   0x0138 0x0330 0xb 0x2
#define IMX7ULP_PAD_PTE14__VIU_D22                                   0x0138 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTE15__PTE15                                     0x013C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTE15__FXIO1_D16                                 0x013C 0x0000 0x2 0x0
#define IMX7ULP_PAD_PTE15__LPSPI3_PCS0                               0x013C 0x0310 0x3 0x2
#define IMX7ULP_PAD_PTE15__LPUART7_RX                                0x013C 0x026C 0x4 0x2
#define IMX7ULP_PAD_PTE15__TPM6_CH1                                  0x013C 0x02D4 0x6 0x2
#define IMX7ULP_PAD_PTE15__FB_A24                                    0x013C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTE15__TRACE_CLKOUT                              0x013C 0x0000 0xa 0x0
#define IMX7ULP_PAD_PTE15__USB0_PWR                                  0x013C 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTE15__VIU_D23                                   0x013C 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF0__PTF0                                       0x0180 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF0__LPUART4_CTS_B                              0x0180 0x0244 0x4 0x3
#define IMX7ULP_PAD_PTF0__LPI2C4_SCL                                 0x0180 0x0278 0x5 0x3
#define IMX7ULP_PAD_PTF0__TPM4_CLKIN                                 0x0180 0x0298 0x6 0x3
#define IMX7ULP_PAD_PTF0__FB_RW_B                                    0x0180 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF0__VIU_DE                                     0x0180 0x033C 0xc 0x0
#define IMX7ULP_PAD_PTF1__PTF1                                       0x0184 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF1__LPUART4_RTS_B                              0x0184 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTF1__LPI2C4_SDA                                 0x0184 0x027C 0x5 0x3
#define IMX7ULP_PAD_PTF1__TPM4_CH0                                   0x0184 0x0280 0x6 0x3
#define IMX7ULP_PAD_PTF1__CLKOUT                                     0x0184 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF1__VIU_HSYNC                                  0x0184 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF2__PTF2                                       0x0188 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF2__LPUART4_TX                                 0x0188 0x024C 0x4 0x3
#define IMX7ULP_PAD_PTF2__LPI2C4_HREQ                                0x0188 0x0274 0x5 0x3
#define IMX7ULP_PAD_PTF2__TPM4_CH1                                   0x0188 0x0284 0x6 0x3
#define IMX7ULP_PAD_PTF2__FB_TSIZ1_FB_CS5_B_FB_BE23_16_BLS15_8_B     0x0188 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF2__VIU_VSYNC                                  0x0188 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF3__PTF3                                       0x018C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF3__LPUART4_RX                                 0x018C 0x0248 0x4 0x3
#define IMX7ULP_PAD_PTF3__TPM4_CH2                                   0x018C 0x0288 0x6 0x3
#define IMX7ULP_PAD_PTF3__FB_AD16                                    0x018C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF3__VIU_PCLK                                   0x018C 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF4__PTF4                                       0x0190 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF4__FXIO1_D0                                   0x0190 0x0204 0x2 0x2
#define IMX7ULP_PAD_PTF4__LPSPI2_PCS1                                0x0190 0x02A0 0x3 0x3
#define IMX7ULP_PAD_PTF4__LPUART5_CTS_B                              0x0190 0x0250 0x4 0x3
#define IMX7ULP_PAD_PTF4__LPI2C5_SCL                                 0x0190 0x02BC 0x5 0x3
#define IMX7ULP_PAD_PTF4__TPM4_CH3                                   0x0190 0x028C 0x6 0x2
#define IMX7ULP_PAD_PTF4__FB_AD17                                    0x0190 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF4__VIU_D0                                     0x0190 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF5__PTF5                                       0x0194 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF5__FXIO1_D1                                   0x0194 0x0208 0x2 0x2
#define IMX7ULP_PAD_PTF5__LPSPI2_PCS2                                0x0194 0x02A4 0x3 0x3
#define IMX7ULP_PAD_PTF5__LPUART5_RTS_B                              0x0194 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTF5__LPI2C5_SDA                                 0x0194 0x02C0 0x5 0x3
#define IMX7ULP_PAD_PTF5__TPM4_CH4                                   0x0194 0x0290 0x6 0x2
#define IMX7ULP_PAD_PTF5__FB_AD18                                    0x0194 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF5__VIU_D1                                     0x0194 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF6__PTF6                                       0x0198 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF6__FXIO1_D2                                   0x0198 0x020C 0x2 0x2
#define IMX7ULP_PAD_PTF6__LPSPI2_PCS3                                0x0198 0x02A8 0x3 0x3
#define IMX7ULP_PAD_PTF6__LPUART5_TX                                 0x0198 0x0258 0x4 0x3
#define IMX7ULP_PAD_PTF6__LPI2C5_HREQ                                0x0198 0x02B8 0x5 0x3
#define IMX7ULP_PAD_PTF6__TPM4_CH5                                   0x0198 0x0294 0x6 0x2
#define IMX7ULP_PAD_PTF6__FB_AD19                                    0x0198 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF6__VIU_D2                                     0x0198 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF7__PTF7                                       0x019C 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF7__FXIO1_D3                                   0x019C 0x0210 0x2 0x2
#define IMX7ULP_PAD_PTF7__LPUART5_RX                                 0x019C 0x0254 0x4 0x3
#define IMX7ULP_PAD_PTF7__TPM5_CH1                                   0x019C 0x02C8 0x6 0x3
#define IMX7ULP_PAD_PTF7__FB_AD20                                    0x019C 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF7__VIU_D3                                     0x019C 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF8__PTF8                                       0x01A0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF8__FXIO1_D4                                   0x01A0 0x0214 0x2 0x2
#define IMX7ULP_PAD_PTF8__LPSPI2_SIN                                 0x01A0 0x02B0 0x3 0x3
#define IMX7ULP_PAD_PTF8__LPUART6_CTS_B                              0x01A0 0x025C 0x4 0x3
#define IMX7ULP_PAD_PTF8__LPI2C6_SCL                                 0x01A0 0x02FC 0x5 0x3
#define IMX7ULP_PAD_PTF8__TPM5_CLKIN                                 0x01A0 0x02CC 0x6 0x3
#define IMX7ULP_PAD_PTF8__FB_AD21                                    0x01A0 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF8__USB1_CLK                                   0x01A0 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF8__VIU_D4                                     0x01A0 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF9__PTF9                                       0x01A4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF9__FXIO1_D5                                   0x01A4 0x0218 0x2 0x2
#define IMX7ULP_PAD_PTF9__LPSPI2_SOUT                                0x01A4 0x02B4 0x3 0x3
#define IMX7ULP_PAD_PTF9__LPUART6_RTS_B                              0x01A4 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTF9__LPI2C6_SDA                                 0x01A4 0x0300 0x5 0x3
#define IMX7ULP_PAD_PTF9__TPM5_CH0                                   0x01A4 0x02C4 0x6 0x3
#define IMX7ULP_PAD_PTF9__FB_AD22                                    0x01A4 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF9__USB1_NXT                                   0x01A4 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF9__VIU_D5                                     0x01A4 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF10__PTF10                                     0x01A8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF10__FXIO1_D6                                  0x01A8 0x021C 0x2 0x2
#define IMX7ULP_PAD_PTF10__LPSPI2_SCK                                0x01A8 0x02AC 0x3 0x3
#define IMX7ULP_PAD_PTF10__LPUART6_TX                                0x01A8 0x0264 0x4 0x3
#define IMX7ULP_PAD_PTF10__LPI2C6_HREQ                               0x01A8 0x02F8 0x5 0x3
#define IMX7ULP_PAD_PTF10__TPM7_CH3                                  0x01A8 0x02E8 0x6 0x3
#define IMX7ULP_PAD_PTF10__FB_AD23                                   0x01A8 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF10__USB1_STP                                  0x01A8 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF10__VIU_D6                                    0x01A8 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF11__PTF11                                     0x01AC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF11__FXIO1_D7                                  0x01AC 0x0220 0x2 0x2
#define IMX7ULP_PAD_PTF11__LPSPI2_PCS0                               0x01AC 0x029C 0x3 0x3
#define IMX7ULP_PAD_PTF11__LPUART6_RX                                0x01AC 0x0260 0x4 0x3
#define IMX7ULP_PAD_PTF11__TPM7_CH4                                  0x01AC 0x02EC 0x6 0x3
#define IMX7ULP_PAD_PTF11__FB_CS4_B_FB_TSIZ0_FB_BE31_24_BLS7_0_B     0x01AC 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF11__USB1_DIR                                  0x01AC 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF11__VIU_D7                                    0x01AC 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF12__PTF12                                     0x01B0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF12__FXIO1_D8                                  0x01B0 0x0224 0x2 0x2
#define IMX7ULP_PAD_PTF12__LPSPI3_PCS1                               0x01B0 0x0314 0x3 0x3
#define IMX7ULP_PAD_PTF12__LPUART7_CTS_B                             0x01B0 0x0268 0x4 0x3
#define IMX7ULP_PAD_PTF12__LPI2C7_SCL                                0x01B0 0x0308 0x5 0x3
#define IMX7ULP_PAD_PTF12__TPM7_CH5                                  0x01B0 0x02F0 0x6 0x3
#define IMX7ULP_PAD_PTF12__FB_AD24                                   0x01B0 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF12__USB1_DATA0                                0x01B0 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF12__VIU_D8                                    0x01B0 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF13__PTF13                                     0x01B4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF13__FXIO1_D9                                  0x01B4 0x0228 0x2 0x2
#define IMX7ULP_PAD_PTF13__LPSPI3_PCS2                               0x01B4 0x0318 0x3 0x3
#define IMX7ULP_PAD_PTF13__LPUART7_RTS_B                             0x01B4 0x0000 0x4 0x0
#define IMX7ULP_PAD_PTF13__LPI2C7_SDA                                0x01B4 0x030C 0x5 0x3
#define IMX7ULP_PAD_PTF13__TPM7_CLKIN                                0x01B4 0x02F4 0x6 0x3
#define IMX7ULP_PAD_PTF13__FB_AD25                                   0x01B4 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF13__USB1_DATA1                                0x01B4 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF13__VIU_D9                                    0x01B4 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF14__PTF14                                     0x01B8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF14__FXIO1_D10                                 0x01B8 0x022C 0x2 0x2
#define IMX7ULP_PAD_PTF14__LPSPI3_PCS3                               0x01B8 0x031C 0x3 0x3
#define IMX7ULP_PAD_PTF14__LPUART7_TX                                0x01B8 0x0270 0x4 0x3
#define IMX7ULP_PAD_PTF14__LPI2C7_HREQ                               0x01B8 0x0304 0x5 0x3
#define IMX7ULP_PAD_PTF14__TPM7_CH0                                  0x01B8 0x02DC 0x6 0x3
#define IMX7ULP_PAD_PTF14__FB_AD26                                   0x01B8 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF14__USB1_DATA2                                0x01B8 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF14__VIU_D10                                   0x01B8 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF15__PTF15                                     0x01BC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF15__FXIO1_D11                                 0x01BC 0x0230 0x2 0x2
#define IMX7ULP_PAD_PTF15__LPUART7_RX                                0x01BC 0x026C 0x4 0x3
#define IMX7ULP_PAD_PTF15__TPM7_CH1                                  0x01BC 0x02E0 0x6 0x3
#define IMX7ULP_PAD_PTF15__FB_AD27                                   0x01BC 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF15__USB1_DATA3                                0x01BC 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF15__VIU_D11                                   0x01BC 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF16__PTF16                                     0x01C0 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF16__USB1_DATA4                                0x01C0 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF16__VIU_D12                                   0x01C0 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF16__FXIO1_D12                                 0x01C0 0x0234 0x2 0x2
#define IMX7ULP_PAD_PTF16__LPSPI3_SIN                                0x01C0 0x0324 0x3 0x3
#define IMX7ULP_PAD_PTF16__TPM7_CH2                                  0x01C0 0x02E4 0x6 0x3
#define IMX7ULP_PAD_PTF16__FB_AD28                                   0x01C0 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF17__PTF17                                     0x01C4 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF17__USB1_DATA5                                0x01C4 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF17__VIU_D13                                   0x01C4 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF17__FXIO1_D13                                 0x01C4 0x0238 0x2 0x2
#define IMX7ULP_PAD_PTF17__LPSPI3_SOUT                               0x01C4 0x0328 0x3 0x3
#define IMX7ULP_PAD_PTF17__TPM6_CLKIN                                0x01C4 0x02D8 0x6 0x3
#define IMX7ULP_PAD_PTF17__FB_AD29                                   0x01C4 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF18__PTF18                                     0x01C8 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF18__USB1_DATA6                                0x01C8 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF18__VIU_D14                                   0x01C8 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF18__FXIO1_D14                                 0x01C8 0x023C 0x2 0x2
#define IMX7ULP_PAD_PTF18__LPSPI3_SCK                                0x01C8 0x0320 0x3 0x3
#define IMX7ULP_PAD_PTF18__TPM6_CH0                                  0x01C8 0x02D0 0x6 0x3
#define IMX7ULP_PAD_PTF18__FB_AD30                                   0x01C8 0x0000 0x9 0x0
#define IMX7ULP_PAD_PTF19__PTF19                                     0x01CC 0x0000 0x1 0x0
#define IMX7ULP_PAD_PTF19__USB1_DATA7                                0x01CC 0x0000 0xb 0x0
#define IMX7ULP_PAD_PTF19__VIU_D15                                   0x01CC 0x0000 0xc 0x0
#define IMX7ULP_PAD_PTF19__FXIO1_D15                                 0x01CC 0x0240 0x2 0x2
#define IMX7ULP_PAD_PTF19__LPSPI3_PCS0                               0x01CC 0x0310 0x3 0x3
#define IMX7ULP_PAD_PTF19__TPM6_CH1                                  0x01CC 0x02D4 0x6 0x3
#define IMX7ULP_PAD_PTF19__FB_AD31                                   0x01CC 0x0000 0x9 0x0

#endif /* __DTS_IMX7ULP_PINFUNC_H */
