// SPDX-License-Identifier: MIT

modeSelect();
const manual = document.getElementById("manual_setting");
if (manual !== null) {
    manual.style.display="none";
}
essidSelect();
let focus_flag = false;
let ap_invalid_flag = false;

function modeSelect() {
    if (!("mode_form" in document)) {
        return;
    }
    const mode = document.mode_form.mode;
    const sta = document.getElementById("sta_setting");
    const ap = document.getElementById("ap_setting");
    for(var i = 0; i < mode.length; i++) {
        if(mode[i].checked) {
            if (mode[i].value == "sta") {
                sta.style.display = "block";
                ap.style.display = "none";
            } else {
                sta.style.display = "none";
                ap.style.display = "block";
            }
        }
    }
}

function methodSelect() {
    const method = document.wlan_form.method;
    const manual = document.getElementById("manual_setting");
    for(var i = 0; i < method.length; i++) {
        if(method[i].checked) {
            if (method[i].value == "manual") {
                manual.style.display = "block";
            } else {
                manual.style.display = "none";
            }
        }
    }
}

function hwmodeSelect() {
    const hwmode = document.getElementById("hw_mode");
    const channel = document.getElementById("channel");

    while (channel.options.length) {
        channel.options.remove(0)
    }
    if (hwmode.value == "g") {
        for (let i = 1; i <= 13; i++) {
            channel.options.add(new Option(i));
        }
    } else {
        // hwmode.value == "a"
        for (let i = 36; i <= 48; i += 4) {
            channel.options.add(new Option(i));
        }
    }
}

function essidSelect() {
    const essid = document.getElementById("essid");
    if (essid === null) {
        return;
    }

    let savedid = document.querySelectorAll("label[name=saved_ssid]");
    const messageOverwrite = document.getElementById("overwrite_message");
    messageOverwrite.style.display = "none";
    for(let i = 0; i < savedid.length; i++){
        if (essid.value == savedid[i].innerHTML){
            messageOverwrite.style.display = "block";
            break;
        }
    }
}

function onsubmitAPHandler() {
    const wlan_con_ssid = document.getElementById("wlan_con_ssid");
    if (wlan_con_ssid != null && wlan_con_ssid.innerText !== "--") {
        if (!window.confirm('WLANを切断する必要があります。 よろしいですか？')) {
            return false;
        }
    }
    showLoader();
    return true;
}

function validateAPssid () {
    const elem = document.getElementById('ssid');
    const bytes = new Blob([elem.value]).size;
    if (bytes < 1 || bytes > 32) return false;
    return true;
}

function validateAPpassphrase () {
    const elem = document.getElementById('wpa_passphrase');
    if (!/^[\x20-\x7E]*$/.test(elem.value)) return false;
    if (elem.value.length < 8 || elem.value.length > 63) return false;
    return true;
}

function appendSSID(placeHolder, data) {
    // note we append new SSIDs regardless of filter,
    // they'll be filtered if new key is entered
    for (ssid of data) {
        if (!placeHolder.querySelector('[value="'+ssid.id.replace(/["\\]/g, '\\$&')+'"]')) {
            const element = document.createElement('div');
            element.classList.add('item');

            const input = document.createElement('input');
            input.type = "radio";
            input.name = "essid_list";
            input.value = ssid.id;
            input.id = "essid-" + ssid.id.replace(/["\\]/g, '\\$&');
            input.setAttribute("onclick", "change_essid()");

            const label = document.createElement('label');
            label.htmlFor = input.id;
            label.innerHTML = ssid.id;

            const img = new Image();
            img.src = "static/wlan/images/wlan_signal-" + ssid.strength + ".png";

            label.prepend(img);
            element.appendChild(input);
            element.appendChild(label);
            placeHolder.appendChild(element);
        }
    }
}

function change_essid () {
    document.getElementById('essid').value = document.querySelector('[name="essid_list"]:checked').value;
    document.getElementById('essid_dropdown').style.visibility = "hidden";
    essidSelect();
}

const pollSSID = async () => {
    background_scan.started();
    const ssid_list = document.getElementById('essid_dropdown');
    if (ssid_list) {
        const response = await fetch('/wlan_scan');
        const scanned_ssid = await response.json();
        appendSSID(ssid_list, scanned_ssid);

        if(focus_flag) background_scan.set(3000);
        else background_scan.set(30000);
    }
    background_scan.finished();
}

const background_scan = {
    scan: false,
    timeout: false,
    set: function(time) {
        this.timeout = true;
        scan_timeout = setTimeout(function () {
            pollSSID().catch((error) => {
                console.log(error);
                background_scan.finished();
                console.log("Error occured during scan. Retrying scan . . .")
                background_scan.set(3000);
            })}, time);
    },
    overwrite: function(time) {
        if (this.timeout) clearTimeout(scan_timeout);
        this.set(time);
    },
    started: function () {
        this.scan = true;
        this.timeout = false;
        if (focus_flag) {
            document.getElementById('wlan_load').style.visibility = "visible";
        }
    },
    finished: function () {
        this.scan = false;
        document.getElementById('wlan_load').style.visibility = "hidden";
    },
}

document.getElementById('essid')?.addEventListener("focusin", (event) => {
    focus_flag = true;
    if (!background_scan.scan) background_scan.overwrite(100);
    else document.getElementById('wlan_load').style.visibility = "visible";
    const ssid_list = document.getElementById('essid_dropdown');
    for (var i = 0; i < ssid_list.children.length; i++) {
        ssid_list.children[i].style.removeProperty("display");
    }
    ssid_list.style.visibility = "visible";
});

document.getElementById('essid')?.addEventListener("input", (event) => {
    const cur = document.getElementById("essid").value.toLowerCase();
    const ssid_list = document.getElementById('essid_dropdown');
    for (var i = 0; i < ssid_list.children.length; i++) {
        const child = ssid_list.children[i];
        if (child.children[0].value.toLowerCase().includes(cur)) {
            // remove prop to hide with parent
            child.style.removeProperty("display");
        } else {
            child.style.display = "none";
        }
    }
});

document.getElementById('essid')?.addEventListener("focusout", (event) => {
    focus_flag = false;
    const dropdown = document.getElementById('essid_dropdown')
    if (event.relatedTarget != dropdown) {
        dropdown.style.visibility = "hidden";
    }
});

document.getElementById('essid_dropdown')?.addEventListener("focusout", (event) => {
    event.target.style.visibility = "hidden";
});

document.getElementById('ssid').addEventListener("change", (event) => {
    if (validateAPssid()) event.target.setCustomValidity("");
    else event.target.setCustomValidity("1 ～ 32 バイトの範囲で設定してください");
});

document.getElementById('ssid').addEventListener("invalid", (event) => {
    ap_invalid_flag = true;
    document.getElementById('input_alert_ssid').style.display = "block";
});

document.getElementById('ssid').addEventListener("input", (event) => {
    event.target.setCustomValidity("");
    if(!ap_invalid_flag) return;

    const message = document.getElementById('input_alert_ssid');
    if (validateAPssid()) message.style.display = "none";
    else message.style.display = "block";
});

document.getElementById('wpa_passphrase').addEventListener("change", (event) => {
    if (validateAPpassphrase()) event.target.setCustomValidity("");
    else event.target.setCustomValidity("半角英数字記号を 8 ～ 63 文字の範囲で設定してください");
});

document.getElementById('wpa_passphrase').addEventListener("invalid", (event) => {
    ap_invalid_flag = true;
    document.getElementById('input_alert_passphrase').style.display = "block";
});

document.getElementById('wpa_passphrase').addEventListener("input", (event) => {
    event.target.setCustomValidity("");
    if(!ap_invalid_flag) return;

    const message = document.getElementById('input_alert_passphrase');
    if (validateAPpassphrase()) message.style.display = "none";
    else message.style.display = "block";
});

window.addEventListener('load', (event) => {
    if (document.getElementById('essid') && !background_scan.timeout) {
        background_scan.set(100);
    }
});
