// SPDX-License-Identifier: MIT

function onCopyHandler(elem, tokenId) {
    if(navigator.clipboard) {
        navigator.clipboard.writeText(tokenId).then(
            () => {
                showFeedback(elem, '✔');
            },
            () => {
                showFeedback(elem, '⚠️');
        });
    } else {
        showFeedback(elem, '⚠️');
    }
}

function showFeedback(elem, msg) {
    setTimeout(function() {
        elem.innerText = msg;
    }, 100);

    setTimeout(function() {
        elem.innerText = '📋';
    }, 1000);
}

function close_log_view() {
    document.getElementById("log_view_overlay").style.visibility = "hidden";
    document.body.style.overflow = "";

    // loading class has "transition: all 0.3s;",
    // so wait 500ms for transition to complete before clearing text
    setTimeout(() => {
        var box = document.getElementById("log_text");
        box.innerText = "";
    }, 500);
}

function settings_get_log(ev) {
    ev = ev || window.event;

    // abort normal get to avoid page reloading
    ev.preventDefault();

    document.getElementById("log_view_overlay").style.visibility = "visible";
    document.body.style.overflow = "hidden";
    var box = document.getElementById("log_text");
    box.innerHTML = "<pre></pre><br/>"
    var pre = box.children[0]

    fetch(location.origin + "/settings_get_log")
      .then(response => response.text())
      .then(log_text => {
        pre.innerText = log_text;
      })
      .catch(err => {
        pre.innerText = "ログを取得できませんでした。(" + err + ")";
      });

    return false;
}

document.addEventListener("DOMContentLoaded", function(_ev) {
    var element = document.getElementById("get_log")
        .addEventListener('submit', settings_get_log);
    document.getElementById("log_view_close").addEventListener("click", close_log_view);
});