// SPDX-License-Identifier: MIT

function is_default_value(input) {
    // select
    if (input.selectedOptions)
        return input.selectedOptions[0].defaultSelected;
    // other input
    return input.value == input.defaultValue
}

function disable_unchanged(ev) {
    onsubmitHandler();
    ev = ev || window.event;
    var form = ev.target;

    for (var i = 0; i < form.length; i++) {
        if (! form[i].classList.contains("optional_input"))
            continue;
        // normal input or select
        if (is_default_value(form[i])) {
            form[i].disabled = true;
        }
    }
}

function toggle_details(ev) {
    ev = ev || window.event;
    if (ev.target.innerHTML=="詳細を表示") {
        var show = true;
        ev.target.innerHTML="詳細を非表示";
    } else {
        var show = false;
        ev.target.innerHTML="詳細を表示";
    }
    var elements = document.getElementsByClassName("prop_details");
    for (var i = 0; i < elements.length; i++) {
        if (show) {
            elements[i].classList.remove('hiddenfield');
        } else {
            elements[i].classList.add('hiddenfield');
        }
    }
    // also show ipv4/6 details, but only hide if appropriate...
    if (show) {
        var elements = document.getElementsByClassName("ipv4_manual");
        for (var i = 0; i < elements.length; i++) {
            elements[i].classList.remove('hiddenfield');
        }
        var elements = document.getElementsByClassName("ipv6_manual");
        for (var i = 0; i < elements.length; i++) {
            elements[i].classList.remove('hiddenfield');
        }
        var del_btn = document.getElementById("con_delete_button");
        del_btn.classList.remove('hiddenfield')
    } else {
        var method = document.querySelector("select.toggle_ipv4_manual");
        // default setting has no value
        var val = method.selectedIndex == 0 ? method.children[0].text : method.value;
        if (val != 'manual') {
            // note we don't reset values here
            var elements = document.getElementsByClassName("ipv4_manual");
            for (var i = 0; i < elements.length; i++) {
                elements[i].classList.add('hiddenfield');
            }
        }
        var method = document.querySelector("select.toggle_ipv6_manual");
        var val = method.selectedIndex == 0 ? method.children[0].text : method.value;
        if (val != 'manual') {
            var elements = document.getElementsByClassName("ipv6_manual");
            for (var i = 0; i < elements.length; i++) {
                elements[i].classList.add('hiddenfield');
            }
        }
        var del_btn = document.getElementById("con_delete_button");
        del_btn.classList.add('hiddenfield')
    }
    // disable link
    ev.preventDefault();
}

function toggle_ipv4_manual(ev) {
    ev = ev || window.event;
    var elements = document.getElementsByClassName("ipv4_manual");
    var reset_props = ["ipv4.addresses", "ipv4.gateway"];

    for (var i = 0; i < elements.length; i++) {
        if (ev.target.value == "manual") {
            elements[i].classList.remove('hiddenfield');
        } else {
            elements[i].classList.add('hiddenfield');
            if (ev.x_first_run) // don't touch values on refresh
                continue;
            if (reset_props.includes(elements[i].name) && elements[i].value != '') {
                elements[i].value = '';
                elements[i].setAttribute("x-send", "yes")
            }
        }
    }
}

function toggle_ipv6_manual(ev) {
    ev = ev || window.event;
    var elements = document.getElementsByClassName("ipv6_manual");
    var reset_props = ["ipv6.addresses", "ipv6.gateway"];

    for (var i = 0; i < elements.length; i++) {
        if (ev.target.value == "manual") {
            elements[i].classList.remove('hiddenfield');
        } else {
            elements[i].classList.add('hiddenfield');
            if (ev.x_first_run) // don't touch values on refresh
                continue;
            if (reset_props.includes(elements[i].name) && elements[i].value != '') {
                elements[i].value = '';
                elements[i].setAttribute("x-send", "yes");
            }
        }
    }
}

function form_reset(_ev) {
    var elements = document.getElementsByClassName("optional_input_post");
    for (var i = 0; i < elements.length; i++) {
        elements[i].reset()
    }

    // also fix hidden visibility
    var ev = Object();
    ev.target = Object();
    ev.x_first_run = true;

    var manual = document.querySelector("select.toggle_ipv4_manual");
    ev.target.value = manual.children[0].text;
    toggle_ipv4_manual(ev);

    var manual = document.querySelector("select.toggle_ipv6_manual");
    ev.target.value = manual.children[0].text;
    toggle_ipv6_manual(ev);
}

document.addEventListener("DOMContentLoaded", function(_ev) {
    // create fake event to fix hidden state
    // state is set in html but might be different on refresh
    var ev = Object();
    ev.x_first_run = true;
    var toggle = document.querySelector("select.toggle_ipv4_manual");
    if (toggle) {
        toggle.addEventListener('change', toggle_ipv4_manual);
        // initial value is empty, skip calling then as getting value is annoying
        if (toggle.value != "") {
            ev.target = toggle;
            toggle_ipv4_manual(ev);
        }
    }

    var toggle = document.querySelector("select.toggle_ipv6_manual");
    if (toggle) {
        toggle.addEventListener('change', toggle_ipv6_manual);
        if (toggle.value != "") {
            ev.target = toggle;
            toggle_ipv6_manual(ev);
        }
    }

    var toggle = document.querySelector("button.toggle_details");
    if (toggle) {
        toggle.addEventListener('click', toggle_details);
        // link text always resets on refresh, don't try to toggle it
    }

    var toggle = document.querySelector("button.form_reset");
    if (toggle) {
        toggle.addEventListener('click', form_reset);
    }

    var elements = document.getElementsByClassName("optional_input_post");
    for (var i = 0; i < elements.length; i++) {
        elements[i].addEventListener('submit', disable_unchanged);
        elements[i].reset();
    }
});
