#!/bin/sh -e
# SPDX-License-Identifier: MIT

CON_NAME=$(nmcli -t -f type,name c | awk -F: '$1 == "gsm" { print $2 }')
[ -n "$CON_NAME" ] || CON_NAME="$1"
CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"

if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
	nmcli con del "$CON_NAME"
	persist_file -d "$CON_FILE" || :
fi
