#!/bin/sh -e
# SPDX-License-Identifier: MIT

OUT_INTERFACE="$1"

SYSCTL_CONF="/etc/sysctl.d/abos_web_ipforward.conf"

if iptables -t nat -D POSTROUTING -o "$OUT_INTERFACE" -m comment --comment "abos-web-nat" -j MASQUERADE >/dev/null 2>&1; then
	/etc/init.d/iptables save
	# prevent conflicts with container network settings
	sed -i -e '/NETAVARK/d' /etc/iptables/rules-save
	persist_file /etc/iptables/rules-save
fi

# remove ip_forward conf if no rule left
# we keep live setting because podman also needs it
if ! iptables -t nat -S | grep -q "abos-web"; then
	persist_file -d "$SYSCTL_CONF" || :
fi
