#!/bin/sh -e
# SPDX-License-Identifier: MIT

DEVICE_NAME="$1"
INTERFACE="$2"

if IF_INFO=$(nmcli dev show "$DEVICE_NAME" 2> /dev/null); then
	IP_ADDR=$(echo "$IF_INFO" | awk '$1 == "IP4.ADDRESS[1]:" { print $2 }')
	GATEWAY_ADDR=$(echo "$IF_INFO" | awk '$1 == "IP4.GATEWAY:" { print $2 }')
	DNS=$(echo "$IF_INFO" | awk '$1 == "IP4.DNS[1]:" { print $2 }')
	MAC=$(echo "$IF_INFO" | awk '$1 == "GENERAL.HWADDR:" { print $2 }')
fi

printf "%s" "$IP_ADDR;$GATEWAY_ADDR;$DNS;$MAC"
