#!/bin/sh -e
# SPDX-License-Identifier: MIT

INADYN_CONF="/etc/inadyn/inadyn.conf"

if [ -e "$INADYN_CONF" ]; then
	awk '
		BEGIN {
			# 複数のホスト名を格納する配列を初期化
			host_count = 0;
			provider_count = 0;
		}

		# key=value形式の行を処理（period含む）
		/=/ {
			key = $1;
			value = substr($0, index($0, "=") + 1);
			gsub(/^[ \t]+|[ \t]+$/, "", value);

			if (key == "period") {
				period = value;
			} else if (key == "hostname") {
				hostname = value;
				# ホスト名から不要な引用符などを取り除く
				if (match(hostname, /[a-zA-Z0-9][a-zA-Z0-9.-]+[a-zA-Z0-9]/)) {
					hostname = substr(hostname, RSTART, RLENGTH);
					hosts[host_count++] = hostname;
				}
			}
		}

		# provider行は特別処理
		/^provider/ {
			value = $0;
			sub(/^provider[ \t]+/, "", value);	# 先頭の「provider」を削除
			sub(/[ \t]*[{].*$/, "", value);	   # 末尾の「{...」を削除
			gsub(/^[ \t]+|[ \t]+$/, "", value);   # 前後の空白を削除
			providers[provider_count++] = value;
		}

		END {
			# 基本情報の出力
			if (period) {
				printf("period = %s\n", period);
			}

			# プロバイダー情報の出力
			if (provider_count > 0) {
				# 複数のプロバイダーがある場合
				for (i = 0; i < provider_count; i++) {
					printf("provider%d = %s\n", i+1, providers[i]);
				}
			}

			# ホスト名情報の出力
			if (host_count > 0) {
				# 複数のホスト名がある場合
				for (i = 0; i < host_count; i++) {
					printf("hostname%d = %s\n", i+1, hosts[i]);
				}
			}
		}
	' "$INADYN_CONF"
fi
