#!/bin/sh
# SPDX-License-Identifier: MIT

HOSTAPD_CONF="/etc/hostapd/hostapd.conf"
BRIDGE_IF="br_ap"
if [ -e "$HOSTAPD_CONF" ]; then
	ip=$(ip -o -4 addr list "$BRIDGE_IF" 2> /dev/null | awk '{print $4}')
	awk -F= -v ip="$ip" '
		$1 == "hw_mode" { st=index($0,"="); hwmode=substr($0,st+1) }
		$1 == "channel" { st=index($0,"="); chan=substr($0,st+1) }
		$1 == "ssid" { st=index($0,"="); ssid=substr($0,st+1) }
		END {
				if (hwmode && ssid && chan) {
				printf("%s,%s,%s,%s", ip, hwmode, chan, ssid);
			}
		}' "$HOSTAPD_CONF"
fi
# bridge_addr/netmask,hw_mode,channel,ssid
