#!/bin/sh -e
# SPDX-License-Identifier: MIT

BRIDGE_NAME="$1"
INTERFACE="$2"

BRIDGE_CON_FILE="/etc/NetworkManager/system-connections/$BRIDGE_NAME.nmconnection"

HOSTAPD="/etc/runlevels/default/hostapd"
HOSTAPD_CONF="/etc/hostapd/hostapd.conf"

if nmcli con show "$BRIDGE_NAME" >/dev/null 2>&1; then
	nmcli con del "$BRIDGE_NAME"
	persist_file -d "$BRIDGE_CON_FILE" || :
fi

rc-service hostapd stop
if [ -e "$HOSTAPD" ]; then
	rc-update del hostapd
	persist_file -d "$HOSTAPD" "$HOSTAPD_CONF" || :
fi

NMCLI_IGNORE_IF="$INTERFACE"
if [ "$INTERFACE" = uap0 ] && [ -e /sys/class/net/mlan0 ]; then
	NMCLI_IGNORE_IF=mlan0
fi

if [ -e /etc/NetworkManager/conf.d/90_abosweb_disable_wlan.conf ]; then
	persist_file -d /etc/NetworkManager/conf.d/90_abosweb_disable_wlan.conf
fi
nmcli d set "$NMCLI_IGNORE_IF" managed yes
nmcli d wifi list --rescan yes
