# SPDX-License-Identifier: MIT

ctrl_restore_kernel() {
	local kernel_package image failed="" cloned=""

	case "$(cat /etc/hwrevision)" in
	iot-a6e*|a610*|a640*)
		kernel_package="linux-at-a6"
		image=/boot/uImage
		;;
	iot-g4-*|AGX4500*|x2-*|AX2210*|iot-a9e*)
		kernel_package="linux-at-x2"
		image=/boot/Image
		;;
	*)
		error "Unsupported board $(cat /etc/hwrevision)"
		;;
	esac

	grep -qE "^boot_linux\s" /etc/sw-versions \
		&& error "Encrypted rootfs kernel is not supported"

	# update cache first:
	# 1/ this checks internet connection
	# 2/ is necessary for persist_file -a del, that complains about missing tags otherwise
	info "Checking internet connection..."
	persist_file -a update || error "'apk update' failed, is internet available?"

	# only rollback-clone if there is a kernel right now...
	# (could happen if re-run after failure)
	if [ -e "$image" ]; then
		info "Cloning current partition to other side. Rollback in case of error."
		abos-ctrl rollback-clone && cloned=1
	fi

	info "Removing old kernel"
	# removing kernel first ensures uboot will rollback
	# failures are no longer allowed, continue on error but remember failure
	persist_file -d "$image"

	if grep -qEx 'POST /boot|POST /lib/modules' /etc/swupdate_preserve_files; then
		sed -i -e '/POST \/\(boot\|lib\/modules\)$/d' /etc/swupdate_preserve_files \
			&& persist_file /etc/swupdate_preserve_files \
			|| failed="/etc/swupdate_preserve_files could not be updated
Please remove 'POST /boot' and/or 'POST /lib/modules' manually
"
	fi
	persist_file -a del 'linux-at-*'
	persist_file -dr /lib/modules

	info "Installing kernel package"
	persist_file -a add "$kernel_package@atmark" \
		|| error "Kernel package install failed.
This partition is unbootable! ${cloned:+"rollback should happen automatically if you reboot now,
but "}you should try to install $kernel_package again after fixing the issue:
  persist_file -a add $kernel_package"


	if [ -n "$failed" ]; then
		error "Kernel install succeeded, but $failed"
	fi

	info "Successfully re-installed kernel package"
}


