# SPDX-License-Identifier: MIT

mount_old_cleanup() {
	trap - EXIT INT QUIT TERM
	umount_if_mountpoint /target
	[ -n "$target_ab" ] && [ -e "/dev/mapper/rootfs_$target_ab" ] \
		&& cryptsetup luksClose "rootfs_$target_ab"
}

ctrl_mount_old() {
	dev_from_current
	[ -e "$target_rootpart" ] || error "No such file or directory $target_rootpart"
	if [ -n "$dryrun" ]; then
		info "Would mount to $target_rootpart"
		return
	fi

	local dev="$target_rootpart"
	luks_unlock "rootfs_$target_ab"

	local blk_devno mnt_devno
	if mnt_devno=$(is_mountpoint /target); then
		blk_devno=$(mountpoint -x "$dev") \
			|| error "Could not get devno from $dev"
		[ "$blk_devno" = "$mnt_devno" ] \
			|| error "Another partition is already mounted on /target"
	else
		opts=,ro mount_rootfs "$dev" /target \
			|| error "Could not mount $dev to /target"
	fi
	# umount on failures from here
	trap mount_old_cleanup EXIT INT QUIT TERM
	[ -e "/target/bin/sh" ] && [ -d "/var/log" ] \
		&& [ -d "/target/var/app/volumes" ] \
		&& [ -d "/target/var/app/rollback/volumes" ] \
		&& [ -d "/target/var/lib/containers/storage_readonly" ] \
		|| error "Other rootfs does not look like a valid system, aborting"

	local appdev
	get_appdev
	# failure to mount are not fatal if e.g. missing subvol
	# must also be idempotent.
	is_mountpoint /target/var/lib/containers/storage_readonly \
		|| mount -t btrfs -o "ro,subvol=boot_${target_ab}/containers_storage" \
			"$appdev" "/target/var/lib/containers/storage_readonly" 2>/dev/null \
		|| info "Could not mount target readonly container storage"
	is_mountpoint /target/var/app/rollback/volumes \
		|| mount -t btrfs -o "ro,subvol=boot_${target_ab}/volumes" \
			"$appdev" "/target/var/app/rollback/volumes" 2>/dev/null \
		|| info "Could not mount target rollback volumes"
	local bind
	for bind in /var/app/volumes /var/log /var/tmp; do
		is_mountpoint "/target/$bind" \
			|| mount --bind -o ro "$bind" "/target/$bind"
	done

	trap - EXIT INT QUIT TERM
	info "Mounted $dev to /target successfully." "Unmount it with 'abos-ctrl umount /target' when done"
}
