// SPDX-License-Identifier: MIT

function close_reset_default_log_popup() {
    document.getElementById("reset_default_log_overlay").style.visibility = "hidden";
    var close = document.getElementById("reset_default_log_close");
    close.classList.add("disabled");
    close.disabled = true;
}

function reset_default_log_on_message(ev) {
    var box = document.getElementById("reset_default_log_text");
    if (ev.target.x_first) {
        box.innerHTML = ""
        ev.target.x_first = false;
    }
    var lines = ev.data.split('\n');
    for (var i = 0; i < lines.length; i++) {
        // XXX color ERROR etc
        var p = document.createElement("p");
        p.innerText = lines[i];
        box.appendChild(p);
    }
}

function reset_default_log_on_close(ev) {
    document.getElementById("reset_default_log_loader").style.visibility = "hidden";

    var close = document.getElementById("reset_default_log_close");
    close.classList.remove("disabled");
    close.disabled = false;

    var box = document.getElementById("reset_default_log_text")

    // success if it outputs the following:
    var success_str = 'WARNING: Rebooting!';
    var success = false;
    success ||= box.innerHTML.includes(success_str);

    var summary = success ? "削除しました。再起動完了後リロードしてください。" : "削除できませんでした。";
    document.getElementById("reset_default_log_status").innerText = summary;
}

function reset_default_log_on_error(_ev) {
    // errors can happen if the socket is closed and we're trying to send something
    // at least make the close button visible...
    document.getElementById("reset_default_log_loader").style.visibility = "hidden";
    var close = document.getElementById("reset_default_log_close");
    close.classList.remove("disabled");
    close.disabled = false;

    document.getElementById("reset_default_log_status").innerText = "削除中ににエラーが発生しました。";
}

function reset_default(form) {
    document.getElementById("reset_default_log_title").innerText = "ユーザー設定とユーザーデータの削除";
    document.getElementById("reset_default_log_text").innerHTML = "削除実行中…";
    document.getElementById("reset_default_log_status").innerText = "";
    document.getElementById("reset_default_log_loader").style.visibility = "visible";
    document.getElementById("reset_default_log_overlay").style.visibility = "visible";

    var ws = new WebSocket(location.origin.replace(/^http/, 'ws') + "/settings_reset_default_ws");
    ws.onmessage = reset_default_log_on_message;
    ws.onclose = reset_default_log_on_close;
    ws.onerror = reset_default_log_on_error;
}

function reset_default_start(ev) {
    ev = ev || window.event;

    // abort normal post to avoid page reloading
    ev.preventDefault();
    if (!window.confirm('本当に削除しますか？')) {
        return false;
    }

    // send request and feed popup
    reset_default(ev.target);
    return false;
}

document.addEventListener("DOMContentLoaded", function(_ev) {
    var elements = document.getElementsByClassName("reset_default_post");
    for (var i = 0; i < elements.length; i++) {
        elements[i].addEventListener('submit', reset_default_start);
    }
    document.getElementById("reset_default_log_close").addEventListener("click", close_reset_default_log_popup);
})