#!/bin/sh -e
# SPDX-License-Identifier: MIT

CON_NAME=$(nmcli -t -f type,name c | awk -F: '$1 == "gsm" { print $2 }')
[ -n "$CON_NAME" ] || CON_NAME="$1"
DEVICE="$2"
APN="$3"
AUTH_TYPE="$4"
IPV6="$5"
USER_NAME=""
PASSWORD=""
MCCMNC=""
NOCONNECT=""

CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"
CON_RECOVER_RUNLEVEL="/etc/runlevels/default/connection-recover"
EC25_RESET="/sys/devices/platform/ec25-reset"

trap catch ERR

while [ $# -gt 0 ];
do
	case "$1" in
		"--user")
			shift
			USER_NAME="$1" ;;
		"--password")
			shift
			PASSWORD="$1" ;;
		"--mccmnc")
			shift
			MCCMNC="$1" ;;
		"--noconnect")
			NOCONNECT=1
			;;
		*)
			;;
	esac
	shift
done

catch() {
	if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
		nmcli con del "$CON_NAME"
		persist_file -d "$CON_FILE" || :
	fi
	if [ "$con_recover_status" = "started" ]; then
		rc-service connection-recover start
	fi
	rc-service modemmanager start
	echo "Could not set up wwan connection." >&2
}

wait_modemmanager() {
	local i=0

	# wait for service to come back (on USB reconnect after reset)
	# (normally ~27s)
	while [ "$i" -lt 40 ]; do
		if rc-status -m | grep -q modemmanager; then
			break;
		fi
		sleep 1
		i=$((i+1))
	done
	if [ "$i" = 40 ]; then
		# modem apparently sometimes does not reset
		rc-service modemmanager start
	fi
	# wait for mm to find modem (normally ~22s)
	i=0
	while [ "$i" -lt 33 ]; do
		if mmcli -m any >/dev/null 2>&1; then
			break
		fi
		sleep 1
		i=$((i+1))
	done
}

if [ "$CON_NAME" = "abos_web_wwan" ]; then
	if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
		nmcli con del "$CON_NAME"
		persist_file -d "$CON_FILE" || :
	fi
	CON_NAME="gsm-ttyCommModem"
	CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"
fi

if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
	set -- nmcli con mod "$CON_NAME"
else
	set -- nmcli con add con-name "$CON_NAME" type gsm autoconnect no
fi

set -- "$@" ifname "$DEVICE" apn "$APN" ipv6.method "$IPV6"
if [ -n "$USER_NAME" ]; then
	set -- "$@" user "$USER_NAME"
fi

if [ -n "$PASSWORD" ]; then
	set -- "$@" password "$PASSWORD"
fi

if [ -n "$MCCMNC" ]; then
	set -- "$@" gsm.network-id "$MCCMNC"
fi

if [ "$AUTH_TYPE" = "pap" ]; then
	set -- "$@" ppp.refuse-eap true ppp.refuse-chap true ppp.refuse-mschap true ppp.refuse-mschapv2 true ppp.refuse-pap false
fi

if rc-service connection-recover status | grep -q "started"; then
	con_recover_status="started"
fi

if [ -e "$EC25_RESET" ]; then
	if [ "$con_recover_status" = "started" ]; then
		rc-service connection-recover stop
	fi
	rc-service modemmanager stop
	ec25-clean-reset
	wait_modemmanager
fi

"$@"
[ -n "$NOCONNECT" ] || nmcli con up "$CON_NAME"
nmcli con mod "$CON_NAME" autoconnect yes
persist_file "$CON_FILE"

if [ "$con_recover_status" = "started" ]; then
	rc-service connection-recover restart
	rc-update add connection-recover
	persist_file "$CON_RECOVER_RUNLEVEL"
fi

printf "Setup WWAN connection '%s'\n" "$(nmcli -g connection.uuid con show "$CON_NAME")"

