#!/bin/sh -e
# SPDX-License-Identifier: MIT

CON_NAME=$(nmcli -t -f device,name c | awk -F: '$1 == "ttyCommModem" { print $2 }')

if CON_INFO=$(nmcli con show "$CON_NAME" 2> /dev/null); then
	APN=$(echo "$CON_INFO" | awk '$1 == "gsm.apn:" { print $2 }')
	USER=$(echo "$CON_INFO" | awk '$1 == "gsm.username:" { print $2 }')
	MCCMNC=$(echo "$CON_INFO" | awk '$1 == "gsm.network-id:" { print $2 }')
	REFUSE_PAP=$(echo "$CON_INFO" | awk '$1 == "ppp.refuse-pap:" { print $2 }')

	if MODEM_INFO=$(mmcli -m 0 -K 2> /dev/null); then
		SIM=$(echo "$MODEM_INFO" | awk '$1 == "modem.generic.sim" { print $3 }' | rev | cut -d '/' -f 1 | rev)
		IMSI=$(mmcli -i "$SIM" -K 2> /dev/null | awk '$1 == "sim.properties.imsi" { print $3 }')
		SIGNALQ=$(echo "$MODEM_INFO" | awk '$1 == "modem.generic.signal-quality.value" { print $3 }')
		IMEI=$(echo "$MODEM_INFO" | awk '$1 == "modem.3gpp.imei" { print $3 }')
		BANDS=$(echo "$MODEM_INFO" | awk '$1 ~ /^modem.generic.current-bands.value/ { printf "%s,", $3 }')
		BANDS="${BANDS%,}"
	fi
	if MODEM_LOCATION=$(mmcli -m 0 -K --location-get 2> /dev/null); then
		TAC=$(echo "$MODEM_LOCATION" | awk '$1 == "modem.location.3gpp.tac" { print $3 }')
		CELLID=$(echo "$MODEM_LOCATION" | awk '$1 == "modem.location.3gpp.cid" { print $3 }')
	fi
	if [ -n "$APN" ]; then
		AUTH="CHAP"
	fi

	if [ "$REFUSE_PAP" = "no" ]; then
		AUTH="PAP"
	fi

	printf "%s" "$APN;$USER;$MCCMNC;$AUTH;$IMSI;$SIGNALQ;$IMEI;$BANDS;$TAC;$CELLID"
fi
