#!/bin/sh -e
# SPDX-License-Identifier: MIT

SETTING_NAME="$1"
ENDPOINT="$2"
PUBLICKEY="$3"
SELF_ADDR="$4"
DNS_ADDR="$5"
KEEPALIVE="$6"

CONF_DIR="/etc/atmark/abos_web/wireguard"
CONF_FILE="wg.conf"
INFO_FILE="vpn_info.txt"
PRIVATEKEY="privatekey.txt"
CON_NAME=$(nmcli -t -f type,name c | awk -F: '$1 == "wireguard" { print $2 }')
[ -n "$CON_NAME" ] || CON_NAME="wg"
CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"

trap catch ERR

catch() {
	if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
		nmcli con del "$CON_NAME"
		persist_file -d "$CON_FILE" || :
	fi
	persist_file -d "$CONF_DIR/$CONF_FILE" "$CONF_DIR/$INFO_FILE" || :
}

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

# delete existing connections
if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
	nmcli con del "$CON_NAME"
	persist_file -d "$CON_FILE" || :
fi

if [ ! -e "$CONF_DIR/$PRIVATEKEY" ]; then
	/usr/libexec/abos-web/wireguard_gen_key.sh
fi

umask 177
cat > "$CONF_DIR/$CONF_FILE" <<EOF
[Interface]
PrivateKey = $(cat "$CONF_DIR/$PRIVATEKEY")
Address = $SELF_ADDR
DNS = $DNS_ADDR

[Peer]
PublicKey = $PUBLICKEY
Endpoint = $ENDPOINT
AllowedIPs = 0.0.0.0/0
PersistentKeepalive = $KEEPALIVE
EOF

cat > "$CONF_DIR/$INFO_FILE" <<EOF
$SETTING_NAME
EOF

chmod 644 "$CONF_DIR/$INFO_FILE"
persist_file "$CONF_DIR/$INFO_FILE"

nmcli connection import type wireguard file "$CONF_DIR/$CONF_FILE"

persist_file -r /etc/NetworkManager/system-connections
rm "$CONF_DIR/$CONF_FILE"

/usr/libexec/abos-web/nat_setup.sh wg
