#!/bin/sh
# SPDX-License-Identifier: MIT

ENCRYPTED=""
if [ "$1" = "-e" ]; then
	ENCRYPTED="-e"
fi

if ! PASSWORD="$(cat)" || [ -z "$PASSWORD" ]; then
	echo "No password provided" >&2
	exit 1
fi

if [ "$ENCRYPTED" = "-e" ] && [ "$PASSWORD" = "!" ]; then
	# Adding ABOSWEB_ALLOW_EMPTY_LOGIN=1 ensure ABOS-Web starts even if
	# password is unset after initial setup.
	# Note that `!` will ask for a new password when connecting to abos-web,
	# to completely lock the account add any suffix e.g. `!inval`
	INIT_CONF="/etc/atmark/abos_web/init.conf"
	if [ -f "$INIT_CONF" ] && grep -q "^ABOSWEB_ALLOW_EMPTY_LOGIN=" "$INIT_CONF"; then
		sed -i 's/^ABOSWEB_ALLOW_EMPTY_LOGIN=.*/ABOSWEB_ALLOW_EMPTY_LOGIN=1/' "$INIT_CONF"
	else
		echo "ABOSWEB_ALLOW_EMPTY_LOGIN=1" >> "$INIT_CONF"
	fi && persist_file "$INIT_CONF" || exit
fi

{
	echo "abos-web-admin:$PASSWORD"
	if [ -e /etc/atmark/abos_web/manage_root ]; then
		echo "root:$PASSWORD"
	fi
} | chpasswd $ENCRYPTED || exit

persist_file /etc/shadow
