#!/bin/sh -e
# SPDX-License-Identifier: MIT

INTERFACE="$1"
PROTOCOL="$2"
DPORT="$3"
DESTINATION="$4"
DESTINATION_PORT="$5"

SYSCTL_CONF="/etc/sysctl.d/abos_web_ipforward.conf"

trap catch ERR

catch() {
	if iptables -t nat -D PREROUTING -i "$INTERFACE" -p "$PROTOCOL" -m "$PROTOCOL" --dport "$DPORT" \
		-m comment --comment "abos-web-pf" \
		-j DNAT --to-destination "$DESTINATION:$DESTINATION_PORT" >/dev/null 2>&1; then
		/etc/init.d/iptables save
		persist_file /etc/iptables/rules-save
	fi

	echo "Could not set up nat." >&2
}

if ! [ -e "$SYSCTL_CONF" ]; then
	sysctl net.ipv4.ip_forward=1
	echo "net.ipv4.ip_forward = 1" > "$SYSCTL_CONF"
	persist_file "$SYSCTL_CONF"
fi

# rule already present
if iptables -t nat -C PREROUTING -i "$INTERFACE" -p "$PROTOCOL" -m "$PROTOCOL" --dport "$DPORT" \
	-m comment --comment "abos-web-pf" \
	-j DNAT --to-destination "$DESTINATION:$DESTINATION_PORT"; then
	exit
fi

iptables -t nat -A PREROUTING -i "$INTERFACE" -p "$PROTOCOL" -m "$PROTOCOL" --dport "$DPORT" \
	-m comment --comment "abos-web-pf" \
	-j DNAT --to-destination "$DESTINATION:$DESTINATION_PORT"
/etc/init.d/iptables save
# prevent conflicts with container network settings
sed -i -e '/NETAVARK/d' /etc/iptables/rules-save
rc-update add iptables
persist_file /etc/iptables/rules-save /etc/runlevels/default/iptables
