#!/bin/sh
# SPDX-License-Identifier: MIT

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

list() {
	nmcli -t -c no -f name,uuid,type,device,state con
}

show() {
	local id="$1"

	nmcli -t -c no con show "$id"
}

show_dev() {
	local iface="$1"

	nmcli -t -c no dev show "$iface"
}

mode="$1"
shift

case "$mode" in
list|show|show_dev)
	"$mode" "$@"
	;;
*)
	error "Usage: nmcli_show.sh [list|show con|show_dev interface]"
	;;
esac
