#!/bin/sh -e
# SPDX-License-Identifier: MIT

rescan=yes

while [ "$#" -gt 0 ]; do
	case "$1" in
	"--no-rescan")
		rescan=no;;
	*)
		echo "Bad argument $1" >&2
		exit 1;;
	esac
	shift
done

nmcli -t -c no -f SSID,SIGNAL,BSSID,CHAN,RATE,SECURITY,ACTIVE \
	device wifi list --rescan "$rescan"
