#!/bin/sh -e
# SPDX-License-Identifier: MIT

INADYN="/etc/runlevels/default/inadyn"
INADYN_CONF="/etc/inadyn/inadyn.conf"

# inadyn停止・設定削除
# /var/app/volumes/inadyn配下のキャッシュ削除。IPアドレスキャッシュが残ってるとDDNSサービスにアクセスしない。
# ※デフォルトは/var/cache/inadyn/だが、very importantとのことで、conf.dで/var/app/volumes/inadynに変えている
if [ -d /var/app/volumes/inadyn ] && [ "$(ls -A /var/app/volumes/inadyn 2>/dev/null)" ]; then
	rm /var/app/volumes/inadyn/*
fi

rc-service inadyn stop
if [ -e "$INADYN" ]; then
	rc-update del inadyn
	persist_file -d "$INADYN" "$INADYN_CONF" || :
fi


