# SPDX-License-Identifier: MIT

installer_setting_set() {
	# If even one argument is specified, do not run prompt.
	case ",$disable_jtag,$disable_sd_boot,$disable_bootprompt,$enable_secureboot," in
	*,yes,*)
		[ "$disable_jtag" = "prompt" ] && disable_jtag=""
		[ "$disable_sd_boot" = "prompt" ] && disable_sd_boot=""
		[ "$disable_bootprompt" = "prompt" ] && disable_bootprompt=""
		[ "$enable_secureboot" = "prompt" ] && enable_secureboot=""
	esac

	if [ -n "$disable_jtag" ] && [ "$JTAG_DISABLED" = "yes" ]; then
		info "JTAG disabled setting for production Armadillo is already set"
		disable_jtag=""
	fi
	if [ "$disable_jtag" = "prompt" ]; then
		echo "Would you like to disable JTAG in the installer ? [y/N]"
		prompt_yesno n && disable_jtag="yes"
	fi
	if [ "$disable_jtag" = "yes" ]; then
		echo "JTAG_DISABLED=yes" >> "$baseos_conf" \
			|| error "Could not write to $baseos_conf"
		info "JTAG disabled setting for production Armadillo has been configured."
	fi

	if [ -n "$disable_sd_boot" ] && [ "$SD_BOOT_DISABLED" = "yes" ]; then
		info "SD boot disabled setting for production Armadillo is already set"
		disable_sd_boot=""
	fi
	if [ "$disable_sd_boot" = "prompt" ]; then
		echo "Would you like to disable SD boot in the installer ? [y/N]"
		prompt_yesno n && disable_sd_boot="yes"
	fi
	if [ "$disable_sd_boot" = "yes" ]; then
		echo "SD_BOOT_DISABLED=yes" >> "$baseos_conf" \
			|| error "Could not write to $baseos_conf"
		info "SD boot disabled setting for production Armadillo has been configured."
	fi

	if [ -n "$disable_bootprompt" ] && [ "$BOOTPROMPT_DISABLED" = "yes" ]; then
		info "Boot prompt disabled setting for production Armadillo is already set"
		disable_bootprompt="no"
	fi
	if [ "$disable_bootprompt" = "prompt" ]; then
		echo "Would you like to disable boot prompt in the installer ? [y/N]"
		prompt_yesno n && disable_bootprompt="yes"
	fi
	if [ "$disable_bootprompt" = "yes" ]; then
		echo "BOOTPROMPT_DISABLED=yes" >> "$baseos_conf" \
			|| error "Could not write to $baseos_conf"
		info "Boot prompt disabled setting for production Armadillo has been configured."
	fi

	if device-info --is-secure secureboot; then
		if [ -n "$enable_secureboot" ] && [ "$SECUREBOOT_ENABLED" = "yes" ]; then
			info "Secure boot enabled setting for production Armadillo is already set"
			enable_secureboot="no"
		fi
		if [ "$enable_secureboot" = "prompt" ]; then
			echo "Would you like to enable secure boot in the installer ? [y/N]"
			prompt_yesno n && enable_secureboot="yes"
		fi
		if [ "$enable_secureboot" = "yes" ]; then
			echo "SECUREBOOT_ENABLED=yes" >> "$baseos_conf" \
				|| error "Could not write to $baseos_conf"
			info "Secure boot enabled setting for production Armadillo has been configured."
		fi
	elif [ "$enable_secureboot" = "yes" ]; then
		error "Refused to set secure boot enabled: secure boot disabled on this Armadillo."
	fi

	persist_file "$baseos_conf" \
		|| error "Could not persist $baseos_conf"
}

installer_setting_reset() {
	sed -e '/^JTAG_DISABLED=yes/d' \
	    -e '/^SD_BOOT_DISABLED=yes/d' \
	    -e '/^BOOTPROMPT_DISABLED=yes/d' \
	    -e '/^SECUREBOOT_ENABLED=yes/d' \
	    -i "$baseos_conf" \
		|| error "Could not delete the configuration values in $baseos_conf"

	persist_file "$baseos_conf" \
		|| error "Could not persist $baseos_conf"

	info "Cleaned up all settings."
}

installer_setting_help() {
	echo "Usage: abos-ctrl installer-setting"
	echo
	echo "Configure settings to be reflected in the production Armadillo."
	echo "This command takes the following arguments:"
	echo "bootprompt, jtag, sd_boot, secureboot"
	echo
	echo "This command takes the following options:"
	echo "--reset: Restore all settings to default."
}

ctrl_installer_setting() {
	local baseos_conf="/etc/atmark/baseos.conf"

	if [ -e "$baseos_conf" ]; then
		. "$baseos_conf" \
			|| error "Could not parse $baseos_conf"
	fi

	local mode="set"
	local disable_jtag="prompt" disable_sd_boot="prompt"
	local disable_bootprompt="prompt" enable_secureboot="prompt"
	local all_arg_num="$#"

	while [ "$#" -gt 0 ]; do
		case "$1" in
		"--reset")
			[ "$all_arg_num" = 1 ] \
				|| error "--reset can not be used with other options or arguments."
			mode="reset"
			;;
		"bootprompt")
			disable_bootprompt="yes"
			;;
		"jtag")
			disable_jtag="yes"
			;;
		"sd_boot")
			disable_sd_boot="yes"
			;;
		"secureboot")
			enable_secureboot="yes"
			;;
		*)
			warning "Invalid option $1"
			installer_setting_help >&2
			exit 1
			;;
		esac
		shift
	done

	"installer_setting_$mode"
}
