# SPDX-License-Identifier: MIT

ctrl_check_secure() {
	local baseos_conf="/etc/atmark/baseos.conf"

	if [ -e "$baseos_conf" ]; then
		. "$baseos_conf" \
			|| error "Could not parse $baseos_conf"
	fi

	if [ "$JTAG_DISABLED" = "yes" ]; then
		info "- JTAG access disabled for mass production."
	else
		info "- JTAG access allowed for mass production."
		info "Block JTAG access with: abos-ctrl installer-setting jtag"
	fi

	if [ "$SD_BOOT_DISABLED" = "yes" ]; then
		info "- SD boot access disabled for mass production."
	else
		info "- SD boot access allowed for mass production."
		info "Block SD boot access with: abos-ctrl installer-setting sd_boot"
	fi

	if [ "$BOOTPROMPT_DISABLED" = "yes" ]; then
		info "- boot prompt disabled for mass production."
	else
		info "- boot prompt allowed for mass production."
		info "Block boot prompt with: abos-ctrl installer-setting bootprompt"
	fi

	if [ "$SECUREBOOT_ENABLED" = "yes" ]; then
		info "- Secure boot enabled for mass production."
	elif device-info --is-secure secureboot; then
		info "- Secure boot disabled for mass production."
		info "Enable Secure boot with: abos-ctrl installer-setting secureboot"
	else
		info "- secure boot not enabled."
	fi
}

