# SPDX-License-Identifier: MIT

# helpers for btrfs
mount_cleanup_basemount() {
	trap - EXIT INT QUIT TERM
	umount_if_mountpoint "$basemount"
	if [ -d "$basemount" ]; then
		rmdir "$basemount"
	fi
}

btrfs_subvol_create() {
	local new="$1"
	local basemount="${2:-"$basemount"}"

	[ -e "$basemount/$new" ] && return
	btrfs subvolume create "$basemount/$new" >/dev/null \
		|| error "Could not create $new"
}

btrfs_subvol_delete() {
	local vol="$1"
	local basemount="${2:-"$basemount"}"

	[ -e "$basemount/$vol" ] || return 1
	btrfs subvolume delete "$basemount/$vol" >/dev/null \
		|| error "Could not delete $vol"
}

btrfs_subvol_recursive_delete() {
	local vol="$1"
	local basemount="${2:-$basemount}"

	[ -e "$basemount/$vol" ] || return 1
	# delete subvolumes by id to avoid dealing with paths.
	# subvol list -o prints something like "ID 123 gen..." for child subvolumes.
	btrfs subvol list -o "$basemount/$vol" \
		| while read -r _ id _; do
			btrfs subvol delete -i "$id" "$basemount" >/dev/null \
				|| error "Could not delete $vol's subvolume $id"
		done
	btrfs subvolume delete "$basemount/$vol" >/dev/null \
		|| error "Could not delete $vol"
}

