# SPDX-License-Identifier: MIT

KOTAI_CODE_OFFSET=56

UBOOT_ENVSD="/dev/mmcblk1"
UBOOT_ENVOFFSET="0x3fe000"
UBOOT_ENVREDUND="0x3fa000"
UBOOT_ENVSIZE="0x2000"

board_setup() {
	# reset hwrevision even if it's already set:
	# we could be installing to a newer revision.
	[ -n "$SN" ] || SN=$(get_kotai_code)
	case "$SN" in
	00E4*) echo 'high-g1-es1 at1';;
	*) echo 'unknown-board at1';;
	esac > /target/etc/hwrevision \
		|| error "Could not update /etc/hwrevision"

	case "$SN" in
	# EM05-G and LBES5PL2EL in high-g1-es1 are dtbo to allow easy
	# disabling of features.
	00E4*) # high-g1-es1
		enable_overlay high-g1-es1-lbes5pl2el.dtbo
		enable_overlay high-g1-es1-em05-g.dtbo
		ln -sf /etc/init.d/connection-recover \
			/target/etc/runlevels/default/ \
			|| error "could not enable connection-recover service"
		ln -sf /etc/init.d/wwan-safe-poweroff \
			/target/etc/runlevels/shutdown/ \
			|| error "could not enable wwan-safe-poweroff service"
		;;
	esac
}

