#!/bin/sh

if [ "$4" != disconnect-request ]; then
	exit 0
fi

iface=$(mmcli -b "$2" -K | awk '/bearer.status.interface/ { print $3 }')

if [ -z "$iface" ]; then
	logger -t mm-disconnect-request "disconnect-request for $2 has no interface"
	exit
fi

if pkill -f "pppd\>.*\<$iface\>"; then
	logger -t mm-disconnect-request "Killed $iface pppd"
else
	logger -t mm-disconnect-request "No pppd found for $iface"
fi
