# SPDX-License-Identifier: MIT

KOTAI_CODE_OFFSET=406 # 406 = (1628 / 4) - 1, 1628 = 0x65c

UBOOT_ENVSD="/dev/mmcblk2"
UBOOT_ENVOFFSET="0x3fe000"
UBOOT_ENVREDUND="0x3fa000"
UBOOT_ENVSIZE="0x2000"

USBFILTER_SIM7672='device "05c6" "9330" "QualComm_Compo" ":020201:0a0000:" "QualComm_QualComm_Compo_000000000001"'

get_motherboard_code() {
	read_fuse_nbyte 404 4
}

enable_sim7672_module() {
	ln -sf /etc/init.d/sim7672-boot /target/etc/runlevels/boot/ \
		|| error "Could not enable sim7672-boot service"
	ln -sf /etc/init.d/connection-recover /target/etc/runlevels/default/ \
		|| error "Could not enable connection-recover service"
	ln -sf /etc/init.d/wwan-led /target/etc/runlevels/default/ \
		|| error "Could not enable wwan-led service"
	ln -sf /etc/init.d/wwan-safe-poweroff /target/etc/runlevels/shutdown/ \
		|| error "Could not enable wwan-safe-poweroff service"
	enable_usbfilter_rule "$USBFILTER_SIM7672"
}

disable_hw_settings() {
	disable_usbfilter_rule "$USBFILTER_SIM7672"

	rm -f /target/etc/runlevels/boot/sim7672-boot \
		/target/etc/runlevels/default/connection-recover \
		/target/etc/runlevels/default/wwan-led \
		/target/etc/runlevels/shutdown/wwan-safe-poweroff
}

board_setup() {
	local MB_CODE=

	# reset hwrevision even if it's already set:
	# we could be installing to a newer revision.
	[ -n "$SN" ] || SN=$(get_kotai_code)

	local hwrevision='unknown-board at1'
	local device_info_conf='PRODUCT_NAME=unknown-board at1'

	case "$SN" in
	00E2*|00E3*)
		MB_CODE=$(get_motherboard_code)
		case "$MB_CODE" in
		010[1-2]*)
			hwrevision='iot-a9r at1'
			device_info_conf='PRODUCT_NAME=Armadillo-IoT A9R'
			;;
		esac
		;;
	esac
	echo "$hwrevision" > /target/etc/hwrevision \
		|| error "Could not update /etc/hwrevision"
	mkdir -p /target/usr/lib/device-info \
		|| error "Could not create /target/usr/lib/device-info"
	echo "$device_info_conf" > /target/usr/lib/device-info/device-info.conf \
		|| error "Could not update /target/usr/lib/device-info/device-info.conf"

	disable_hw_settings

	# note: a9r does not setup overlays because they are embedded in kernel;
	# non-wlan boards still have the wlan overlay loaded.
	# We only support A9E + Cat.1 bis, with or without wlan.
	case "$MB_CODE/$SN" in
	010[1-2]*/00E[2-3]*) # Cat.1 bis + WLAN model, Cat.1 bis model
		enable_sim7672_module
		;;
	esac
}
