# SPDX-License-Identifier: MIT

KOTAI_CODE_OFFSET=406 # 406 = (1628 / 4) - 1, 1628 = 0x65c

UBOOT_ENVSD="/dev/mmcblk2"
UBOOT_ENVOFFSET="0x3fe000"
UBOOT_ENVREDUND="0x3fa000"
UBOOT_ENVSIZE="0x2000"

USBFILTER_SIM7672='device "05c6" "9330" "QualComm_Compo" ":020201:0a0000:" "QualComm_QualComm_Compo_000000000001"'

get_motherboard_code() {
	read_fuse_nbyte 404 4
}

enable_sim7672_module() {
	enable_overlay armadillo_iotg_a9e-sim7672.dtbo
	ln -sf /etc/init.d/sim7672-boot /target/etc/runlevels/boot/ \
		|| error "Could not enable sim7672-boot service"
	ln -sf /etc/init.d/connection-recover /target/etc/runlevels/default/ \
		|| error "Could not enable connection-recover service"
	ln -sf /etc/init.d/wwan-led /target/etc/runlevels/default/ \
		|| error "Could not enable wwan-led service"
	ln -sf /etc/init.d/wwan-safe-poweroff /target/etc/runlevels/shutdown/ \
		|| error "Could not enable wwan-safe-poweroff service"
	enable_usbfilter_rule "$USBFILTER_SIM7672"
}

disable_hw_settings() {
	disable_overlay armadillo_iotg_a9e.dtbo armadillo_iotg_a9e-lbes5pl2el.dtbo \
		armadillo_900-evaboard.dtbo armadillo_iotg_a9e-sim7672.dtbo
	disable_usbfilter_rule "$USBFILTER_SIM7672"

	rm -f /target/etc/runlevels/boot/sim7672-boot \
		/target/etc/runlevels/default/connection-recover \
		/target/etc/runlevels/default/wwan-led \
		/target/etc/runlevels/shutdown/wwan-safe-poweroff
}

board_setup() {
	local MB_CODE=

	# reset hwrevision even if it's already set:
	# we could be installing to a newer revision.
	[ -n "$SN" ] || SN=$(get_kotai_code)
	case "$SN" in
	00E2*|00E3*)
		MB_CODE=$(get_motherboard_code)
		case "$MB_CODE" in
		010[1-4]*) echo 'iot-a9e at1';;
		0105*) echo 'armadillo-900-evaboard at1';;
		*) echo 'armadillo-900 at1';;
		esac
		;;
	*) echo 'unknown-board at1';;
	esac > /target/etc/hwrevision \
		|| error "Could not update /etc/hwrevision"

	disable_hw_settings

	case "$MB_CODE/$SN" in
	0101*/00E[2-3]*) # Cat.1 bis + WLAN model
		enable_sim7672_module
		enable_overlay armadillo_iotg_a9e.dtbo armadillo_iotg_a9e-lbes5pl2el.dtbo
		;;
	0102*/00E[2-3]*) # Cat.1 bis model
		enable_sim7672_module
		enable_overlay armadillo_iotg_a9e.dtbo
		;;
	0103*/00E[2-3]*) # WLAN model
		enable_overlay armadillo_iotg_a9e.dtbo armadillo_iotg_a9e-lbes5pl2el.dtbo
		;;
	0104*/00E[2-3]*) # LAN model
		enable_overlay armadillo_iotg_a9e.dtbo
		;;
	0105*/00E[2-3]*) # a900 EVA
		enable_sim7672_module
		enable_overlay armadillo_900-evaboard.dtbo armadillo_iotg_a9e-lbes5pl2el.dtbo
		;;
	*/00E[2-3]*) # a900 module
		;;
	esac
}
