#!/bin/bash

# config

# archs to build
: "${BUILDARCHS="x86_64 armv7 aarch64"}"
: "${VERSION=3.22}"

# mapping from docker arch to alpine arch
declare -A ARCH_MAP=( [x86_64]=amd64 [armv7]=arm32v7 [aarch64]=arm64v8 )
declare -A DOCKER_ARCH_MAP=( [x86_64]=amd64 [armv7]=arm [aarch64]=arm64 )
declare -A DOCKER_VARIANT_MAP=( [x86_64]="" [armv7]=v7 [aarch64]=v8 )

if [[ -z "$AT_VERSION" ]]; then
	AT_VERSION="$VERSION"
	[[ "$VERSION" = edge ]] && AT_VERSION=3.21
fi

if [[ -z "$DOCKER" ]]; then
	command -v docker > /dev/null && DOCKER=docker
	command -v podman > /dev/null && DOCKER=podman
fi
if [[ -z "$DOCKER" ]] || ! command -v "$DOCKER" > /dev/null; then
	echo "docker or podman not found, install either or set \$DOCKER appropriately" >&2
	exit 1
fi

for arch in $BUILDARCHS; do
	if [[ -z "${ARCH_MAP[$arch]}" ]]; then
		echo "$arch is not a valid arch, must be in ${!ARCH_MAP[*]}"
		exit 1
	fi

	container_arch="${DOCKER_ARCH_MAP[$arch]}"
	container_variant="${DOCKER_VARIANT_MAP[$arch]}"
	# docker doesn't support --arch/variant but podman 3.0 in atde doesn't support --platform
	case "$DOCKER" in
	"podman")
		docker_args=( --arch "$container_arch" --variant "$container_variant" )
		;;
	"docker")
		docker_args=( --platform "linux/$container_arch${container_variant:+/$container_variant}" )
		;;
	esac

	"$DOCKER" build  "${docker_args[@]}" \
		--build-arg "arch=${ARCH_MAP[$arch]}" \
		--build-arg "version=${VERSION}" \
		--build-arg "at_version=${AT_VERSION}" \
		-t "alpine-${VERSION}-$arch" \
		baseos
done
