# SPDX-License-Identifier: MIT

KOTAI_CODE_OFFSET=40

UBOOT_ENVSD="/dev/mmcblk1"
UBOOT_ENVOFFSET="0x3fe000"
UBOOT_ENVREDUND="0x3fa000"
UBOOT_ENVSIZE="0x2000"

USBFILTER_ELS31='device "1e2d" "00a0" "GTO" ":020600:0a0000:020201:" "*"'
USBFILTER_SIM7672='device "05c6" "9330" "QualComm_Compo" ":020201:0a0000:" "QualComm_QualComm_Compo_000000000001"'

base_board_eeprom_read() {
	# convert from i2cget little endian to big endian
	i2cget -y 1 0x50 "$1" w \
		| sed -e 's/0x\(..\)\(..\)/\2\1/'
}

base_board_is_atmark_techno() {
	case "$(base_board_eeprom_read 0x00)" in
	"") error "eeprom could not be read";;
	ffff) error "eeprom is not initialized, please setup it.";;
	0001) return 0;;
	esac
	# not atmark techno
	return 1
}

base_board_read_product_id() {
	base_board_eeprom_read 0x02
}

base_board_read_revision() {
	base_board_eeprom_read 0x0A
}

base_board_read_serialno() {
	echo "$(base_board_eeprom_read 4)$(base_board_eeprom_read 6)$(base_board_eeprom_read 8)" \
		| tr  '[:lower:]' '[:upper:]'
}

enable_overlay_lwb5plus() {
    if [ -n "$sd_boot" ]; then
       print_red "ERROR: SD boot cannnot be used because lwb5plus is present"
       fw_setenv -- bootdelay -1
    fi
    enable_overlay armadillo-iotg-a6e-lwb5plus.dtbo
}

enable_ems31_module() {
	enable_overlay armadillo-iotg-a6e-ems31.dtbo
	ln -sf /etc/init.d/ems31-boot /target/etc/runlevels/boot/ \
		|| error "Could not enable ems31-boot service"
	ln -sf /etc/init.d/wwan-led /target/etc/runlevels/default/ \
		|| error "Could not enable wwan-led service"
	ln -sf /etc/init.d/wwan-safe-poweroff /target/etc/runlevels/shutdown/ \
		|| error "Could not enable wwan-safe-poweroff service"
}

enable_els31_module() {
	enable_overlay armadillo-iotg-a6e-els31.dtbo
	ln -sf /etc/init.d/connection-recover /target/etc/runlevels/default/ \
		|| error "Could not enable connection-recover service"
	ln -sf /etc/init.d/modemmanager /target/etc/runlevels/boot/ \
		|| error "Could not enable modemmanager service"
	ln -sf /etc/init.d/wwan-led /target/etc/runlevels/default/ \
		|| error "Could not enable wwan-led service"
	ln -sf /etc/init.d/wwan-safe-poweroff /target/etc/runlevels/shutdown/ \
		|| error "Could not enable wwan-safe-poweroff service"
	enable_usbfilter_rule "$USBFILTER_ELS31"
}

enable_sim7672_module() {
	enable_overlay armadillo-iotg-a6e-sim7672.dtbo
	ln -sf /etc/init.d/sim7672-boot /target/etc/runlevels/boot/ \
		|| error "Could not enable sim7672-boot service"
	ln -sf /etc/init.d/connection-recover /target/etc/runlevels/default/ \
		|| error "Could not enable connection-recover service"
	ln -sf /etc/init.d/wwan-led /target/etc/runlevels/default/ \
		|| error "Could not enable wwan-led service"
	ln -sf /etc/init.d/wwan-safe-poweroff /target/etc/runlevels/shutdown/ \
		|| error "Could not enable wwan-safe-poweroff service"
	enable_usbfilter_rule "$USBFILTER_SIM7672"
}

disable_hw_settings() {
	disable_overlay armadillo-iotg-a6e-ems31.dtbo armadillo-iotg-a6e-els31.dtbo \
		armadillo-iotg-a6e-sim7672.dtbo armadillo-iotg-a6e-lwb5plus.dtbo
	disable_usbfilter_rule "$USBFILTER_ELS31" "$USBFILTER_SIM7672"

	rm -f /target/etc/runlevels/boot/ems31-boot \
		/target/etc/runlevels/default/wwan-led \
		/target/etc/runlevels/shutdown/wwan-safe-poweroff \
		/target/etc/runlevels/default/connection-recover \
		/target/etc/runlevels/boot/modemmanager \
		/target/etc/runlevels/boot/sim7672-boot
}

board_setup() {
	if ! base_board_is_atmark_techno; then
		echo 'unknown-board at1' > /target/etc/hwrevision \
			|| error "Could not udpate /etc/hwrevision"
		return 0
	fi

	[ -n "$SN" ] || SN=$(get_kotai_code)
	case "$SN" in
	00B7*) ;; # a6e-es1/a610
	00CD*) ;; # a6e-es2
	00CE*) ;; # a6e (LTE Cat.M & WLAN)
	00CF*) ;; # a6e-es (LTE Cat.M)
	00D0*) ;; # a6e (LTE Cat.M)
	00D5*) ;; # a6e-es (LAN only)
	00D6*) ;; # a6e (LAN only)
	00D7*) ;; # a6e-es (LTE Cat.1 & WLAN)
	00D8*) ;; # a6e (LTE Cat.1 & WLAN)
	00D9*) ;; # a6e (WLAN)
	00DA*) ;; # a6e (LTE Cat.1)
	00E5*) ;; # a6e-es (LTE Cat.1 bis)
	00E6*) ;; # a6e-es (LTE Cat.1 bis & WLAN)
	00E7*) ;; # a6e-es2 (LAN only)
	00E8*) ;; # a6e-es2 (WLAN)
	00E9*) ;; # a6e (LTE Cat.1 bis & WLAN)
	00EA*) ;; # a6e (LTE Cat.1 bis)
	*)
		echo 'unknown-board at1' > /target/etc/hwrevision \
			|| error "Could not udpate /etc/hwrevision"
		return 0
		;;
	esac
	local board="$(base_board_read_revision)"
	echo "board = $board"
	case "$board" in
	"") error "eeprom could not be read (revision)";;
	ffff) error "eeprom revision is not initialized";;
	0001) echo 'iot-a6e-es1 at1';;
	0002) echo 'iot-a6e-es2 at1';;
	0003) echo 'iot-a6e at1';;
	0004) echo 'iot-a6e at1';;
	*) echo 'unknown-board at1';;
	esac > /target/etc/hwrevision \
		|| error "Could not update /etc/hwrevision"

	# Disable LTE/WLAN dtbos before re-enabling them so re-install on
	# different variant generates sensible overlays
	disable_hw_settings

	local product_id="$(base_board_read_product_id)"
	echo "product_id = $product_id"
	case "$product_id" in
	"") error "eeprom could not be read (product_id)";;
	ffff) error "eeprom product_id is not initialized";;
	0000) echo "WARNING: product_id 0x0000 is reserved";;
	0001)
		echo "EMS31 exists"
		enable_ems31_module
		;;
	0002)
		echo "EMS31 & lwb5plus exists"
		enable_overlay_lwb5plus
		enable_ems31_module
		;;
	0003)
		echo "ELS31 exists"
		enable_els31_module
		;;
	0004)
		echo "ELS31 & lwb5plus exists"
		enable_overlay_lwb5plus
		enable_els31_module
		;;
	0005)
		echo "LAN model"
		;;
	0006)
		echo "lwb5plus exists"
		enable_overlay_lwb5plus
		;;
	0007)
		echo "SIM7672 exists"
		enable_sim7672_module
		;;
	0008)
		echo "SIM7672 & lwb5plus exists"
		enable_overlay_lwb5plus
		enable_sim7672_module
		;;
	*)	echo "WARNING: unknown product_id: $product_id";;
	esac

	# We will now refer to the base board serial number as SN
	SN=$(base_board_read_serialno)
}
