/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details:
 *
 * Copyright (C) 2023 Mitsuhiro Yoshida <mitsuhiro.yoshida@atmark-techno.com>
 */

#ifndef MM_MODEM_HELPERS_QUECTEL_EC25_H
#define MM_MODEM_HELPERS_QUECTEL_EC25_H

#include <glib.h>

#include <ModemManager.h>
#define _LIBMM_INSIDE_MM
#include <libmm-glib.h>

typedef enum {
    MM_QICSGP_CONTEXT_TYPE_UNKNOWN   = 0,
    MM_QICSGP_CONTEXT_TYPE_IPV4      = 1,
    MM_QICSGP_CONTEXT_TYPE_IPV6      = 2,
    MM_QICSGP_CONTEXT_TYPE_IPV4V6    = 1, /* IPV4V6 is the same as IPV4. */
} MMQicsgpContextType;

typedef enum {
    MM_QICSGP_AUTHENTICATION_NONE        = 0,
    MM_QICSGP_AUTHENTICATION_PAP         = 1,
    MM_QICSGP_AUTHENTICATION_CHAP        = 2,
    MM_QICSGP_AUTHENTICATION_PAP_OR_CHAP = 3,
    MM_QICSGP_AUTHENTICATION_UNKNOWN     = 0xFF,
} MMQicsgpAuthentication;

gboolean
mm_quectel_ec25_parse_qicsgp_read_response (const gchar          *response,
                                            MMBearerAllowedAuth  *out_auth,
                                            MMBearerIpFamily     *out_ip_type,
                                            gchar               **out_apn,
                                            gchar               **out_username,
                                            gchar               **out_password,
                                            GError              **error);

void
mm_quectel_ec25_parse_qicsgp_test (gpointer     log_obj,
                                   const gchar *response,
                                   guint       *min_profile_id,
                                   guint       *max_profile_id,
                                   GError      *error);

GList *
mm_quectel_ec25_parse_qiact_read_response (const gchar  *reply,
                                           GError      **error);

gchar *
mm_quectel_ec25_build_qicsgp (const guint                   context_id,
                              const MMQicsgpContextType     context_type,
                              const gchar                  *apn,
                              const gchar                  *username,
                              const gchar                  *password,
                              const MMQicsgpAuthentication  authentication);

MMQicsgpContextType
mm_quectel_ec25_ip_family_to_qicsgp_context_type (const MMBearerIpFamily family);

MMBearerIpFamily
mm_quectel_ec25_qicsgp_context_type_to_ip_family (const MMQicsgpContextType type);

MMBearerIpFamily
mm_quectel_ec25_get_ip_family_from_qicsgp_context_type (const gchar *str);

MMQicsgpAuthentication
mm_quectel_ec25_allowed_auth_to_qicsgp_authentication (const MMBearerAllowedAuth auth,
                                                       const gboolean has_user_pass);

MMBearerAllowedAuth
mm_quectel_ec25_qicsgp_authentication_to_allowed_auth (const MMQicsgpAuthentication authentication);

#endif  /* MM_MODEM_HELPERS_QUECTEL_EC25_H */
