/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details:
 *
 * Copyright (C) 2022 Atmark Techno Inc.
 */

#ifndef MM_BROADBAND_MODEM_CINTERION_ELS31_H
#define MM_BROADBAND_MODEM_CINTERION_ELS31_H

#include "mm-broadband-modem.h"
#include "mm-modem-helpers-cinterion.h"

#define MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31            (mm_broadband_modem_cinterion_els31_get_type ())
#define MM_BROADBAND_MODEM_CINTERION_ELS31(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31, MMBroadbandModemCinterionEls31))
#define MM_BROADBAND_MODEM_CINTERION_ELS31_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31, MMBroadbandModemCinterionEls31Class))
#define MM_IS_BROADBAND_MODEM_CINTERION_ELS31(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31))
#define MM_IS_BROADBAND_MODEM_CINTERION_ELS31_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31))
#define MM_BROADBAND_MODEM_CINTERION_ELS31_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  MM_TYPE_BROADBAND_MODEM_CINTERION_ELS31, MMBroadbandModemCinterionEls31Class))

typedef struct _MMBroadbandModemCinterionEls31 MMBroadbandModemCinterionEls31;
typedef struct _MMBroadbandModemCinterionEls31Class MMBroadbandModemCinterionEls31Class;
typedef struct _MMBroadbandModemCinterionEls31Private MMBroadbandModemCinterionEls31Private;

struct _MMBroadbandModemCinterionEls31 {
    MMBroadbandModem parent;
    MMBroadbandModemCinterionEls31Private *priv;
};

struct _MMBroadbandModemCinterionEls31Class{
    MMBroadbandModemClass parent;
};

GType mm_broadband_modem_cinterion_els31_get_type (void);

MMBroadbandModemCinterionEls31 *mm_broadband_modem_cinterion_els31_new (const gchar  *device,
                                                                        const gchar  *physdev,
                                                                        const gchar **drivers,
                                                                        const gchar  *plugin,
                                                                        guint16       vendor_id,
                                                                        guint16       product_id);

MMCinterionModemFamily mm_broadband_modem_cinterion_els31_get_family (MMBroadbandModemCinterionEls31 * modem);

#endif /* MM_BROADBAND_MODEM_CINTERION_ELS31_H */
