// SPDX-License-Identifier: BSD-3-Clause
/*
 * Aliases to be used with gpio imx pinmux
 * The actual pin config comes from mcuxsdk:
 * core/devices/MIMX8UD5/drivers/fsl_iomuxc.h
 */

#ifndef __DTS_IMX8ULP_PINFUNC_M33_H
#define __DTS_IMX8ULP_PINFUNC_M33_H

/*
 * Constants used for m33 drivers
 */
/**************************
 * TTY
 *************************/
/* tty: port_type */
#define TTY_TYPE_LPUART		0
#define TTY_TYPE_CUSTOM		1
#define TTY_TYPE_M33_CONSOLE	2
#define TTY_TYPE_FLEXIO		3
#define TTY_TYPE_LPUART_1WIRE	4

/* tty: uart_index */
#define LPUART0			0
#define LPUART1			1

/* tty: rs485_flags */
#define LPUART_RS485_ENABLED            (1 << 0)
/* Logical level for driver output enable pin when sending */
#define LPUART_RS485_DE_ON_SEND         (1 << 1)
/* Logical level for driver output enable pin after sent */
#define LPUART_RS485_DE_AFTER_SEND      (1 << 2)
#define LPUART_RS485_RX_DURING_TX       (1 << 4)


/**************************
 * ADC
 *************************/
/* adc: adc_index */
#define ADC0			0
#define ADC1			1

/* adc: adc_side */
/* Single-end mode, only A-side channel is converted. */
#define kLPADC_SampleChannelSingleEndSideA	0x0
/*< Single-end mode, only B-side channel is converted. */
#define kLPADC_SampleChannelSingleEndSideB	0x1
/* Differential mode, the ADC result is (CHnA-CHnB). */
#define kLPADC_SampleChannelDiffBothSideAB	0x2
/* Differential mode, the ADC result is (CHnB-CHnA). */
#define kLPADC_SampleChannelDiffBothSideBA	0x3

/* adc: adc_scale */
/* Use divided input voltage signal. */
#define kLPADC_SamplePartScale			0
/* Full scale (Factor of 1). */
#define kLPADC_SampleFullScale			1

/* adc: adc_average */
/* Number of sampling averaged before giving a result */
#define kLPADC_HardwareAverageCount1		0
#define kLPADC_HardwareAverageCount2		1
#define kLPADC_HardwareAverageCount4		2
#define kLPADC_HardwareAverageCount8		3
#define kLPADC_HardwareAverageCount16		4
#define kLPADC_HardwareAverageCount32		5
#define kLPADC_HardwareAverageCount64		6
#define kLPADC_HardwareAverageCount128		7

/**************************
 * DAC
 *************************/
/* dac: dac_index */
#define DAC0			0
#define DAC1			1

/* dac: dac_vref */
/* The DAC selects DACREF_1 as the reference voltage. */
#define kDAC12_ReferenceVoltageSourceAlt1	0
/* The DAC selects DACREF_2 as the reference voltage. */
#define kDAC12_ReferenceVoltageSourceAlt2	1

/* dac: dac_cref */
/* None of reference current source is enabled. */
#define kDAC12_ReferenceCurrentSourceDisabled	0
/* Use the internal reference current generated by the module itself. */
#define kDAC12_ReferenceCurrentSourceAlt0	1
/* Use the ZTC(Zero Temperature Coefficient) reference current generated
 * by on-chip power management module. */
#define kDAC12_ReferenceCurrentSourceAlt1	2
/* Use the PTAT(Proportional To Absolution Temperature) reference current
 * generated by power management module. */
#define kDAC12_ReferenceCurrentSourceAlt2	3

/* dac: dac_speed */
#define kDAC12_SpeedLowMode	0 /* Low speed mode. */
#define kDAC12_SpeedMiddleMode	1 /* Middle speed mode. */
#define kDAC12_SpeedHighMode	2 /* High speed mode. */


/**************************
 * i2c
 *************************/
/* i2c: port_type */
#define I2C_TYPE_LPI2C		0
#define I2C_TYPE_FLEXIO		1

/* i2c: i2c_index */
#define LPI2C0			0
#define LPI2C1			1


/**************************
 * spi
 *************************/
/* spi: port_type */
#define SPI_TYPE_GPIO		0
#define SPI_TYPE_LPSPI		1

/* spi: lpspi_index */
#define LPSPI0			0
#define LPSPI1			1
#define LPSPI2			2
#define LPSPI3			3

/**************************
 * SAI
 *************************/
/* sai: sai_index */
#define SAI0			0
#define SAI1			1


/**************************
 * flexio
 * For drivers that support it
 *************************/
#define FLEXIO0			0

/* flexio pins */
#define FLEXIO0_PTA8		0
#define FLEXIO0_PTA9		1
#define FLEXIO0_PTA10		2
#define FLEXIO0_PTA11		3
#define FLEXIO0_PTA12		4
#define FLEXIO0_PTA13		5
#define FLEXIO0_PTA14		6
#define FLEXIO0_PTA15		7
#define FLEXIO0_PTA16		8
#define FLEXIO0_PTA17		9
#define FLEXIO0_PTA18		10
#define FLEXIO0_PTA19		11
#define FLEXIO0_PTA20		12
#define FLEXIO0_PTA21		13
#define FLEXIO0_PTA22		14
#define FLEXIO0_PTA23		15
#define FLEXIO0_PTB0		16
#define FLEXIO0_PTB1		17
#define FLEXIO0_PTB2		18
#define FLEXIO0_PTB3		19
#define FLEXIO0_PTB4		20
#define FLEXIO0_PTB5		21
#define FLEXIO0_PTB6		22
#define FLEXIO0_PTB7		23
#define FLEXIO0_PTB8		24
#define FLEXIO0_PTB9		25
#define FLEXIO0_PTB10		26
#define FLEXIO0_PTB11		27
#define FLEXIO0_PTB12		28
#define FLEXIO0_PTB13		29
#define FLEXIO0_PTB14		30
#define FLEXIO0_PTB15		31


/**************************
 * gpio pin numbers
 * (used when we do not need full pinctrl)
 *************************/
#define PIN_PTA0		0x000
#define PIN_PTA1		0x001
#define PIN_PTA2		0x002
#define PIN_PTA3		0x003
#define PIN_PTA4		0x004
#define PIN_PTA5		0x005
#define PIN_PTA6		0x006
#define PIN_PTA7		0x007
#define PIN_PTA8		0x008
#define PIN_PTA9		0x009
#define PIN_PTA10		0x00a
#define PIN_PTA11		0x00b
#define PIN_PTA12		0x00c
#define PIN_PTA13		0x00d
#define PIN_PTA14		0x00e
#define PIN_PTA15		0x00f
#define PIN_PTA16		0x010
#define PIN_PTA17		0x011
#define PIN_PTA18		0x012
#define PIN_PTA19		0x013
#define PIN_PTA20		0x014
#define PIN_PTA21		0x015
#define PIN_PTA22		0x016
#define PIN_PTA23		0x017
#define PIN_PTA24		0x018
#define PIN_PTB0		0x100
#define PIN_PTB1		0x101
#define PIN_PTB2		0x102
#define PIN_PTB3		0x103
#define PIN_PTB4		0x104
#define PIN_PTB5		0x105
#define PIN_PTB6		0x106
#define PIN_PTB7		0x107
#define PIN_PTB8		0x108
#define PIN_PTB9		0x109
#define PIN_PTB10		0x10a
#define PIN_PTB11		0x10b
#define PIN_PTB12		0x10c
#define PIN_PTB13		0x10d
#define PIN_PTB14		0x10e
#define PIN_PTB15		0x10f
#define PIN_PTC0		0x200
#define PIN_PTC1		0x201
#define PIN_PTC2		0x202
#define PIN_PTC3		0x203
#define PIN_PTC4		0x204
#define PIN_PTC5		0x205
#define PIN_PTC6		0x206
#define PIN_PTC7		0x207
#define PIN_PTC8		0x208
#define PIN_PTC9		0x209
#define PIN_PTC10		0x20a
#define PIN_PTC11		0x20b
#define PIN_PTC12		0x20c
#define PIN_PTC13		0x20d
#define PIN_PTC14		0x20e
#define PIN_PTC15		0x20f
#define PIN_PTC16		0x210
#define PIN_PTC17		0x211
#define PIN_PTC18		0x212
#define PIN_PTC19		0x213
#define PIN_PTC20		0x214
#define PIN_PTC21		0x215
#define PIN_PTC22		0x216
#define PIN_PTC23		0x217

/*!
 * @addtogroup iomuxc_driver
 * @{
 */

/*! @file */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @name Pin function ID
 * The pin function ID is a tuple of \<muxRegister muxMode inputRegister inputDaisy configRegister\>
 *
 * @{
 */
#define IOMUXC_PTA0_CMP1_IN2             0x000 0x280A1000 0X0 0x00000000 0x0 0x280A1000
#define IOMUXC_PTA0_PTA0                 0x000 0x280A1000 0X1 0x00000000 0x0 0x280A1000
#define IOMUXC_PTA0_LPSPI0_PCS1          0x000 0x280A1000 0X3 0x00000000 0x0 0x280A1000
#define IOMUXC_PTA0_LPUART0_CTS_B        0x000 0x280A1000 0X4 0x280A1990 0X1 0x280A1000
#define IOMUXC_PTA0_LPI2C0_SCL           0x000 0x280A1000 0X5 0x280A197C 0X1 0x280A1000
#define IOMUXC_PTA0_TPM0_CLKIN           0x000 0x280A1000 0X6 0x280A1958 0X1 0x280A1000
#define IOMUXC_PTA0_I2S0_RX_BCLK         0x000 0x280A1000 0X7 0x280A19B8 0X1 0x280A1000
#define IOMUXC_PTA0_LPTMR0_ALT1          0x000 0x280A1000 0XC 0x280A1928 0X1 0x280A1000
#define IOMUXC_PTA0_WUU0_P0              0x000 0x280A1000 0XD 0x00000000 0x0 0x280A1000
#define IOMUXC_PTA1_CMP1_IN3             0x001 0x280A1004 0X0 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA1_PTA1                 0x001 0x280A1004 0X1 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA1_LPSPI0_PCS2          0x001 0x280A1004 0X3 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA1_LPUART0_RTS_B        0x001 0x280A1004 0X4 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA1_LPI2C0_SDA           0x001 0x280A1004 0X5 0x280A1980 0X1 0x280A1004
#define IOMUXC_PTA1_TPM0_CH0             0x001 0x280A1004 0X6 0x280A1940 0X1 0x280A1004
#define IOMUXC_PTA1_I2S0_RX_FS           0x001 0x280A1004 0X7 0x280A19BC 0X1 0x280A1004
#define IOMUXC_PTA1_EWM0_OUT_B           0x001 0x280A1004 0XC 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA1_RTC_CLKOUT_B         0x001 0x280A1004 0XD 0x00000000 0x0 0x280A1004
#define IOMUXC_PTA2_CMP1_IN4             0x002 0x280A1008 0X0 0x00000000 0x0 0x280A1008
#define IOMUXC_PTA2_PTA2                 0x002 0x280A1008 0X1 0x00000000 0x0 0x280A1008
#define IOMUXC_PTA2_LPSPI0_PCS3          0x002 0x280A1008 0X3 0x00000000 0x0 0x280A1008
#define IOMUXC_PTA2_LPUART0_TX           0x002 0x280A1008 0X4 0x280A1998 0X1 0x280A1008
#define IOMUXC_PTA2_LPI2C0_HREQ          0x002 0x280A1008 0X5 0x280A1978 0X1 0x280A1008
#define IOMUXC_PTA2_TPM0_CH1             0x002 0x280A1008 0X6 0x280A1944 0X1 0x280A1008
#define IOMUXC_PTA2_I2S0_RXD0            0x002 0x280A1008 0X7 0x280A19A8 0X1 0x280A1008
#define IOMUXC_PTA2_WDOG0_RST            0x002 0x280A1008 0XA 0x00000000 0x0 0x280A1008
#define IOMUXC_PTA2_LPTMR0_ALT2          0x002 0x280A1008 0XC 0x280A192C 0X1 0x280A1008
#define IOMUXC_PTA2_RTC_CLKOUT           0x002 0x280A1008 0XD 0x00000000 0x0 0x280A1008
#define IOMUXC_PTA3_CMP1_IN5             0x003 0x280A100C 0X0 0x00000000 0x0 0x280A100C
#define IOMUXC_PTA3_PTA3                 0x003 0x280A100C 0X1 0x00000000 0x0 0x280A100C
#define IOMUXC_PTA3_LPUART0_RX           0x003 0x280A100C 0X4 0x280A1994 0X1 0x280A100C
#define IOMUXC_PTA3_LPI2C1_HREQ          0x003 0x280A100C 0X5 0x280A1984 0X1 0x280A100C
#define IOMUXC_PTA3_TPM0_CH2             0x003 0x280A100C 0X6 0x280A1948 0X1 0x280A100C
#define IOMUXC_PTA3_I2S0_RXD1            0x003 0x280A100C 0X7 0x280A19AC 0X1 0x280A100C
#define IOMUXC_PTA3_PMIC0_MODE2          0x003 0x280A100C 0XA 0x00000000 0x0 0x280A100C
#define IOMUXC_PTA3_CMP0_OUT             0x003 0x280A100C 0XC 0x00000000 0x0 0x280A100C
#define IOMUXC_PTA3_WUU0_P1              0x003 0x280A100C 0XD 0x00000000 0x0 0x280A100C
#define IOMUXC_PTA4_CMP0_IN2             0x004 0x280A1010 0X0 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA4_PTA4                 0x004 0x280A1010 0X1 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA4_LPSPI0_SIN           0x004 0x280A1010 0X3 0x280A18B4 0X1 0x280A1010
#define IOMUXC_PTA4_LPUART1_CTS_B        0x004 0x280A1010 0X4 0x280A199C 0X1 0x280A1010
#define IOMUXC_PTA4_LPI2C1_SCL           0x004 0x280A1010 0X5 0x280A1988 0X1 0x280A1010
#define IOMUXC_PTA4_TPM0_CH3             0x004 0x280A1010 0X6 0x280A194C 0X1 0x280A1010
#define IOMUXC_PTA4_I2S0_MCLK            0x004 0x280A1010 0X7 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA4_EXT_AUD_MCLK0        0x004 0x280A1010 0X8 0x280A180C 0X1 0x280A1010
#define IOMUXC_PTA4_CAN0_TX              0x004 0x280A1010 0X9 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA4_PMIC0_MODE1          0x004 0x280A1010 0XA 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA4_LPTMR0_ALT3          0x004 0x280A1010 0XC 0x280A1930 0X1 0x280A1010
#define IOMUXC_PTA4_WUU0_P2              0x004 0x280A1010 0XD 0x00000000 0x0 0x280A1010
#define IOMUXC_PTA5_CMP0_IN3             0x005 0x280A1014 0X0 0x00000000 0x0 0x280A1014
#define IOMUXC_PTA5_PTA5                 0x005 0x280A1014 0X1 0x00000000 0x0 0x280A1014
#define IOMUXC_PTA5_LPSPI0_SOUT          0x005 0x280A1014 0X3 0x280A18B8 0X1 0x280A1014
#define IOMUXC_PTA5_LPUART1_RTS_B        0x005 0x280A1014 0X4 0x00000000 0x0 0x280A1014
#define IOMUXC_PTA5_LPI2C1_SDA           0x005 0x280A1014 0X5 0x280A198C 0X1 0x280A1014
#define IOMUXC_PTA5_TPM0_CH4             0x005 0x280A1014 0X6 0x00000000 0x0 0x280A1014
#define IOMUXC_PTA5_I2S0_TX_BCLK         0x005 0x280A1014 0X7 0x280A19C0 0X1 0x280A1014
#define IOMUXC_PTA5_CAN0_RX              0x005 0x280A1014 0X9 0x280A19E8 0X1 0x280A1014
#define IOMUXC_PTA5_LPTMR1_ALT1          0x005 0x280A1014 0XC 0x280A1934 0X1 0x280A1014
#define IOMUXC_PTA5_RTC_CLKOUT_B         0x005 0x280A1014 0XD 0x00000000 0x0 0x280A1014
#define IOMUXC_PTA6_CMP0_IN4             0x006 0x280A1018 0X0 0x00000000 0x0 0x280A1018
#define IOMUXC_PTA6_PTA6                 0x006 0x280A1018 0X1 0x00000000 0x0 0x280A1018
#define IOMUXC_PTA6_LPSPI0_SCK           0x006 0x280A1018 0X3 0x280A18B0 0X1 0x280A1018
#define IOMUXC_PTA6_LPUART1_TX           0x006 0x280A1018 0X4 0x280A19A4 0X1 0x280A1018
#define IOMUXC_PTA6_I3C0_SCL             0x006 0x280A1018 0X5 0x280A1898 0X1 0x280A1018
#define IOMUXC_PTA6_TPM0_CH5             0x006 0x280A1018 0X6 0x00000000 0x0 0x280A1018
#define IOMUXC_PTA6_I2S0_TX_FS           0x006 0x280A1018 0X7 0x280A19C4 0X1 0x280A1018
#define IOMUXC_PTA6_SEC0_TX              0x006 0x280A1018 0X9 0x280A1AE8 0X1 0x280A1018
#define IOMUXC_PTA6_RTC_CLKOUT           0x006 0x280A1018 0XC 0x00000000 0x0 0x280A1018
#define IOMUXC_PTA6_WUU0_P3              0x006 0x280A1018 0XD 0x00000000 0x0 0x280A1018
#define IOMUXC_PTA7_CMP0_IN5             0x007 0x280A101C 0X0 0x00000000 0x0 0x280A101C
#define IOMUXC_PTA7_PTA7                 0x007 0x280A101C 0X1 0x00000000 0x0 0x280A101C
#define IOMUXC_PTA7_LPSPI0_PCS0          0x007 0x280A101C 0X3 0x280A18A0 0X1 0x280A101C
#define IOMUXC_PTA7_LPUART1_RX           0x007 0x280A101C 0X4 0x280A19A0 0X1 0x280A101C
#define IOMUXC_PTA7_I3C0_SDA             0x007 0x280A101C 0X5 0x280A189C 0X1 0x280A101C
#define IOMUXC_PTA7_TPM1_CLKIN           0x007 0x280A101C 0X6 0x280A1974 0X1 0x280A101C
#define IOMUXC_PTA7_I2S0_TXD0            0x007 0x280A101C 0X7 0x00000000 0x0 0x280A101C
#define IOMUXC_PTA7_SEC0_RX              0x007 0x280A101C 0X9 0x280A1AE4 0X1 0x280A101C
#define IOMUXC_PTA7_WDOG1_RST            0x007 0x280A101C 0XA 0x00000000 0x0 0x280A101C
#define IOMUXC_PTA7_LPTMR1_ALT2          0x007 0x280A101C 0XC 0x280A1938 0X1 0x280A101C
#define IOMUXC_PTA7_WUU0_P4              0x007 0x280A101C 0XD 0x00000000 0x0 0x280A101C
#define IOMUXC_PTA8_ADC1_CH0A            0x008 0x280A1020 0X0 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_PTA8                 0x008 0x280A1020 0X1 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_FXIO0_D0             0x008 0x280A1020 0X2 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_LPSPI1_PCS1          0x008 0x280A1020 0X3 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_LPUART1_CTS_B        0x008 0x280A1020 0X4 0x280A199C 0X2 0x280A1020
#define IOMUXC_PTA8_LPI2C0_SCL           0x008 0x280A1020 0X5 0x280A197C 0X2 0x280A1020
#define IOMUXC_PTA8_TPM1_CH0             0x008 0x280A1020 0X6 0x280A195C 0X1 0x280A1020
#define IOMUXC_PTA8_I2S0_TXD1            0x008 0x280A1020 0X7 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_PMIC0_MODE0          0x008 0x280A1020 0XA 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA8_LPTMR1_ALT3          0x008 0x280A1020 0XC 0x280A193C 0X1 0x280A1020
#define IOMUXC_PTA8_WUU0_P5              0x008 0x280A1020 0XD 0x00000000 0x0 0x280A1020
#define IOMUXC_PTA9_ADC1_CH0B            0x009 0x280A1024 0X0 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_PTA9                 0x009 0x280A1024 0X1 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_FXIO0_D1             0x009 0x280A1024 0X2 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_LPSPI1_PCS2          0x009 0x280A1024 0X3 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_LPUART1_RTS_B        0x009 0x280A1024 0X4 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_LPI2C0_SDA           0x009 0x280A1024 0X5 0x280A1980 0X2 0x280A1024
#define IOMUXC_PTA9_TPM1_CH1             0x009 0x280A1024 0X6 0x280A1960 0X1 0x280A1024
#define IOMUXC_PTA9_I2S1_RX_BCLK         0x009 0x280A1024 0X7 0x280A19D8 0X1 0x280A1024
#define IOMUXC_PTA9_NMI0_B               0x009 0x280A1024 0XC 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA9_WUU0_P6              0x009 0x280A1024 0XD 0x00000000 0x0 0x280A1024
#define IOMUXC_PTA10_ADC1_CH1A           0x00A 0x280A1028 0X0 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA10_PTA10               0x00A 0x280A1028 0X1 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA10_FXIO0_D2            0x00A 0x280A1028 0X2 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA10_LPSPI1_PCS3         0x00A 0x280A1028 0X3 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA10_LPUART1_TX          0x00A 0x280A1028 0X4 0x280A19A4 0X2 0x280A1028
#define IOMUXC_PTA10_LPI2C0_HREQ         0x00A 0x280A1028 0X5 0x280A1978 0X2 0x280A1028
#define IOMUXC_PTA10_I3C0_PUR            0x00A 0x280A1028 0X6 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA10_I2S1_RX_FS          0x00A 0x280A1028 0X7 0x280A19DC 0X1 0x280A1028
#define IOMUXC_PTA10_EWM0_IN             0x00A 0x280A1028 0XC 0x280A1808 0X1 0x280A1028
#define IOMUXC_PTA10_WUU0_P7             0x00A 0x280A1028 0XD 0x00000000 0x0 0x280A1028
#define IOMUXC_PTA11_ADC1_CH1B           0x00B 0x280A102C 0X0 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA11_PTA11               0x00B 0x280A102C 0X1 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA11_FXIO0_D3            0x00B 0x280A102C 0X2 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA11_LPUART1_RX          0x00B 0x280A102C 0X4 0x280A19A0 0X2 0x280A102C
#define IOMUXC_PTA11_LPI2C1_HREQ         0x00B 0x280A102C 0X5 0x280A1984 0X2 0x280A102C
#define IOMUXC_PTA11_I3C0_PUR            0x00B 0x280A102C 0X6 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA11_I2S1_RXD0           0x00B 0x280A102C 0X7 0x280A19C8 0X1 0x280A102C
#define IOMUXC_PTA11_WDOG0_RST           0x00B 0x280A102C 0XA 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA11_LPTMR0_ALT1         0x00B 0x280A102C 0XC 0x280A1928 0X2 0x280A102C
#define IOMUXC_PTA11_WUU0_P8             0x00B 0x280A102C 0XD 0x00000000 0x0 0x280A102C
#define IOMUXC_PTA12_ADC1_CH2A           0x00C 0x280A1030 0X0 0x00000000 0x0 0x280A1030
#define IOMUXC_PTA12_PTA12               0x00C 0x280A1030 0X1 0x00000000 0x0 0x280A1030
#define IOMUXC_PTA12_FXIO0_D4            0x00C 0x280A1030 0X2 0x00000000 0x0 0x280A1030
#define IOMUXC_PTA12_LPSPI1_SIN          0x00C 0x280A1030 0X3 0x280A18D0 0X1 0x280A1030
#define IOMUXC_PTA12_LPUART0_CTS_B       0x00C 0x280A1030 0X4 0x280A1990 0X2 0x280A1030
#define IOMUXC_PTA12_LPI2C1_SCL          0x00C 0x280A1030 0X5 0x280A1988 0X2 0x280A1030
#define IOMUXC_PTA12_I2S1_RXD1           0x00C 0x280A1030 0X7 0x280A19CC 0X1 0x280A1030
#define IOMUXC_PTA12_CAN0_TX             0x00C 0x280A1030 0X9 0x00000000 0x0 0x280A1030
#define IOMUXC_PTA12_PMIC0_SDA           0x00C 0x280A1030 0XA 0x280A1804 0X1 0x280A1030
#define IOMUXC_PTA12_EWM0_IN             0x00C 0x280A1030 0XC 0x280A1808 0X2 0x280A1030
#define IOMUXC_PTA12_WUU0_P9             0x00C 0x280A1030 0XD 0x00000000 0x0 0x280A1030
#define IOMUXC_PTA13_ADC1_CH2B           0x00D 0x280A1034 0X0 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_PTA13               0x00D 0x280A1034 0X1 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_FXIO0_D5            0x00D 0x280A1034 0X2 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_LPSPI1_SOUT         0x00D 0x280A1034 0X3 0x280A18D4 0X1 0x280A1034
#define IOMUXC_PTA13_LPUART0_RTS_B       0x00D 0x280A1034 0X4 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_LPI2C1_SDA          0x00D 0x280A1034 0X5 0x280A198C 0X2 0x280A1034
#define IOMUXC_PTA13_I2S1_MCLK           0x00D 0x280A1034 0X7 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_EXT_AUD_MCLK0       0x00D 0x280A1034 0X8 0x280A180C 0X2 0x280A1034
#define IOMUXC_PTA13_CAN0_RX             0x00D 0x280A1034 0X9 0x280A19E8 0X2 0x280A1034
#define IOMUXC_PTA13_PMIC0_SCL           0x00D 0x280A1034 0XA 0x280A1800 0X1 0x280A1034
#define IOMUXC_PTA13_CMP0_OUT            0x00D 0x280A1034 0XC 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA13_WUU0_P10            0x00D 0x280A1034 0XD 0x00000000 0x0 0x280A1034
#define IOMUXC_PTA14_ADC1_CH3A           0x00E 0x280A1038 0X0 0x00000000 0x0 0x280A1038
#define IOMUXC_PTA14_PTA14               0x00E 0x280A1038 0X1 0x00000000 0x0 0x280A1038
#define IOMUXC_PTA14_FXIO0_D6            0x00E 0x280A1038 0X2 0x00000000 0x0 0x280A1038
#define IOMUXC_PTA14_LPSPI1_SCK          0x00E 0x280A1038 0X3 0x280A18CC 0X1 0x280A1038
#define IOMUXC_PTA14_LPUART0_TX          0x00E 0x280A1038 0X4 0x280A1998 0X2 0x280A1038
#define IOMUXC_PTA14_I3C0_SCL            0x00E 0x280A1038 0X5 0x280A1898 0X2 0x280A1038
#define IOMUXC_PTA14_TPM0_CLKIN          0x00E 0x280A1038 0X6 0x280A1958 0X2 0x280A1038
#define IOMUXC_PTA14_I2S1_TX_BCLK        0x00E 0x280A1038 0X7 0x280A19E0 0X1 0x280A1038
#define IOMUXC_PTA14_SEC0_TX             0x00E 0x280A1038 0X9 0x280A1AE8 0X2 0x280A1038
#define IOMUXC_PTA14_EWM0_OUT_B          0x00E 0x280A1038 0XC 0x00000000 0x0 0x280A1038
#define IOMUXC_PTA14_WUU0_P11            0x00E 0x280A1038 0XD 0x00000000 0x0 0x280A1038
#define IOMUXC_PTA15_ADC1_CH3B           0x00F 0x280A103C 0X0 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA15_PTA15               0x00F 0x280A103C 0X1 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA15_FXIO0_D7            0x00F 0x280A103C 0X2 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA15_LPSPI1_PCS0         0x00F 0x280A103C 0X3 0x280A18BC 0X1 0x280A103C
#define IOMUXC_PTA15_LPUART0_RX          0x00F 0x280A103C 0X4 0x280A1994 0X2 0x280A103C
#define IOMUXC_PTA15_I3C0_SDA            0x00F 0x280A103C 0X5 0x280A189C 0X2 0x280A103C
#define IOMUXC_PTA15_TPM0_CH0            0x00F 0x280A103C 0X6 0x280A1940 0X2 0x280A103C
#define IOMUXC_PTA15_I2S1_TX_FS          0x00F 0x280A103C 0X7 0x280A19E4 0X1 0x280A103C
#define IOMUXC_PTA15_SEC0_RX             0x00F 0x280A103C 0X9 0x280A1AE4 0X2 0x280A103C
#define IOMUXC_PTA15_CLKOUT0             0x00F 0x280A103C 0XA 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA15_CMP1_OUT            0x00F 0x280A103C 0XC 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA15_WUU0_P12            0x00F 0x280A103C 0XD 0x00000000 0x0 0x280A103C
#define IOMUXC_PTA16_ADC1_CH4A           0x010 0x280A1040 0X0 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_PTA16               0x010 0x280A1040 0X1 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_FXIO0_D8            0x010 0x280A1040 0X2 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_LPSPI1_SIN          0x010 0x280A1040 0X3 0x280A18D0 0X2 0x280A1040
#define IOMUXC_PTA16_LPUART0_CTS_B       0x010 0x280A1040 0X4 0x280A1990 0X3 0x280A1040
#define IOMUXC_PTA16_LPI2C0_SCL          0x010 0x280A1040 0X5 0x280A197C 0X3 0x280A1040
#define IOMUXC_PTA16_TPM0_CH1            0x010 0x280A1040 0X6 0x280A1944 0X2 0x280A1040
#define IOMUXC_PTA16_I2S1_TXD0           0x010 0x280A1040 0X7 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_CAN0_TX             0x010 0x280A1040 0X9 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_RTC_CLKOUT_B        0x010 0x280A1040 0XC 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA16_WUU0_P13            0x010 0x280A1040 0XD 0x00000000 0x0 0x280A1040
#define IOMUXC_PTA17_ADC1_CH4B           0x011 0x280A1044 0X0 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_PTA17               0x011 0x280A1044 0X1 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_FXIO0_D9            0x011 0x280A1044 0X2 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_LPSPI1_SOUT         0x011 0x280A1044 0X3 0x280A18D4 0X2 0x280A1044
#define IOMUXC_PTA17_LPUART0_RTS_B       0x011 0x280A1044 0X4 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_LPI2C0_SDA          0x011 0x280A1044 0X5 0x280A1980 0X3 0x280A1044
#define IOMUXC_PTA17_TPM0_CH2            0x011 0x280A1044 0X6 0x280A1948 0X2 0x280A1044
#define IOMUXC_PTA17_I2S1_TXD1           0x011 0x280A1044 0X7 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_CAN0_RX             0x011 0x280A1044 0X9 0x280A19E8 0X3 0x280A1044
#define IOMUXC_PTA17_WDOG1_RST           0x011 0x280A1044 0XA 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_RTC_CLKOUT          0x011 0x280A1044 0XC 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA17_WUU0_P14            0x011 0x280A1044 0XD 0x00000000 0x0 0x280A1044
#define IOMUXC_PTA18_ADC1_CH5A           0x012 0x280A1048 0X0 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA18_PTA18               0x012 0x280A1048 0X1 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA18_FXIO0_D10           0x012 0x280A1048 0X2 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA18_LPSPI1_SCK          0x012 0x280A1048 0X3 0x280A18CC 0X2 0x280A1048
#define IOMUXC_PTA18_LPUART0_TX          0x012 0x280A1048 0X4 0x280A1998 0X3 0x280A1048
#define IOMUXC_PTA18_LPI2C0_HREQ         0x012 0x280A1048 0X5 0x280A1978 0X3 0x280A1048
#define IOMUXC_PTA18_TPM0_CH3            0x012 0x280A1048 0X6 0x280A194C 0X2 0x280A1048
#define IOMUXC_PTA18_I2S1_TXD2           0x012 0x280A1048 0X7 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA18_NMI1_B              0x012 0x280A1048 0XC 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA18_WUU0_P15            0x012 0x280A1048 0XD 0x00000000 0x0 0x280A1048
#define IOMUXC_PTA19_PTA19               0x013 0x280A104C 0X1 0x00000000 0x0 0x280A104C
#define IOMUXC_PTA19_FXIO0_D11           0x013 0x280A104C 0X2 0x00000000 0x0 0x280A104C
#define IOMUXC_PTA19_LPSPI1_PCS0         0x013 0x280A104C 0X3 0x280A18BC 0X2 0x280A104C
#define IOMUXC_PTA19_LPUART0_RX          0x013 0x280A104C 0X4 0x280A1994 0X3 0x280A104C
#define IOMUXC_PTA19_LPI2C1_HREQ         0x013 0x280A104C 0X5 0x280A1984 0X3 0x280A104C
#define IOMUXC_PTA19_TPM1_CLKIN          0x013 0x280A104C 0X6 0x280A1974 0X2 0x280A104C
#define IOMUXC_PTA19_I2S1_TXD3           0x013 0x280A104C 0X7 0x00000000 0x0 0x280A104C
#define IOMUXC_PTA19_MQS0_LEFT           0x013 0x280A104C 0X8 0x00000000 0x0 0x280A104C
#define IOMUXC_PTA19_JTAG0_TRST_B        0x013 0x280A104C 0XA 0x00000000 0x0 0x280A104C
#define IOMUXC_PTA19_LPTMR0_ALT2         0x013 0x280A104C 0XC 0x280A192C 0X2 0x280A104C
#define IOMUXC_PTA20_PTA20               0x014 0x280A1050 0X1 0x00000000 0x0 0x280A1050
#define IOMUXC_PTA20_FXIO0_D12           0x014 0x280A1050 0X2 0x00000000 0x0 0x280A1050
#define IOMUXC_PTA20_LPSPI0_SIN          0x014 0x280A1050 0X3 0x280A18B4 0X2 0x280A1050
#define IOMUXC_PTA20_LPUART1_CTS_B       0x014 0x280A1050 0X4 0x280A199C 0X3 0x280A1050
#define IOMUXC_PTA20_LPI2C1_SCL          0x014 0x280A1050 0X5 0x280A1988 0X3 0x280A1050
#define IOMUXC_PTA20_TPM1_CH0            0x014 0x280A1050 0X6 0x280A195C 0X2 0x280A1050
#define IOMUXC_PTA20_I2S1_RXD2           0x014 0x280A1050 0X7 0x280A19D0 0X1 0x280A1050
#define IOMUXC_PTA20_JTAG0_TMS_SWD0_DIO  0x014 0x280A1050 0XA 0x00000000 0x0 0x280A1050
#define IOMUXC_PTA20_LPTMR0_ALT3         0x014 0x280A1050 0XC 0x280A1930 0X2 0x280A1050
#define IOMUXC_PTA21_PTA21               0x015 0x280A1054 0X1 0x00000000 0x0 0x280A1054
#define IOMUXC_PTA21_FXIO0_D13           0x015 0x280A1054 0X2 0x00000000 0x0 0x280A1054
#define IOMUXC_PTA21_LPSPI0_SOUT         0x015 0x280A1054 0X3 0x280A18B8 0X2 0x280A1054
#define IOMUXC_PTA21_LPUART1_RTS_B       0x015 0x280A1054 0X4 0x00000000 0x0 0x280A1054
#define IOMUXC_PTA21_LPI2C1_SDA          0x015 0x280A1054 0X5 0x280A198C 0X3 0x280A1054
#define IOMUXC_PTA21_TPM1_CH1            0x015 0x280A1054 0X6 0x280A1960 0X2 0x280A1054
#define IOMUXC_PTA21_I2S1_RXD3           0x015 0x280A1054 0X7 0x280A19D4 0X1 0x280A1054
#define IOMUXC_PTA21_MQS0_RIGHT          0x015 0x280A1054 0X8 0x00000000 0x0 0x280A1054
#define IOMUXC_PTA21_JTAG0_TDO           0x015 0x280A1054 0XA 0x00000000 0x0 0x280A1054
#define IOMUXC_PTA22_PTA22               0x016 0x280A1058 0X1 0x00000000 0x0 0x280A1058
#define IOMUXC_PTA22_FXIO0_D14           0x016 0x280A1058 0X2 0x00000000 0x0 0x280A1058
#define IOMUXC_PTA22_LPSPI0_SCK          0x016 0x280A1058 0X3 0x280A18B0 0X2 0x280A1058
#define IOMUXC_PTA22_LPUART1_TX          0x016 0x280A1058 0X4 0x280A19A4 0X3 0x280A1058
#define IOMUXC_PTA22_I3C0_SCL            0x016 0x280A1058 0X5 0x280A1898 0X3 0x280A1058
#define IOMUXC_PTA22_MQS0_LEFT           0x016 0x280A1058 0X8 0x00000000 0x0 0x280A1058
#define IOMUXC_PTA22_JTAG0_TDI           0x016 0x280A1058 0XA 0x00000000 0x0 0x280A1058
#define IOMUXC_PTA23_PTA23               0x017 0x280A105C 0X1 0x00000000 0x0 0x280A105C
#define IOMUXC_PTA23_FXIO0_D15           0x017 0x280A105C 0X2 0x00000000 0x0 0x280A105C
#define IOMUXC_PTA23_LPSPI0_PCS0         0x017 0x280A105C 0X3 0x280A18A0 0X2 0x280A105C
#define IOMUXC_PTA23_LPUART1_RX          0x017 0x280A105C 0X4 0x280A19A0 0X3 0x280A105C
#define IOMUXC_PTA23_I3C0_SDA            0x017 0x280A105C 0X5 0x280A189C 0X3 0x280A105C
#define IOMUXC_PTA23_MQS0_RIGHT          0x017 0x280A105C 0X8 0x00000000 0x0 0x280A105C
#define IOMUXC_PTA23_JTAG0_TCLK_SWD0_CLK 0x017 0x280A105C 0XA 0x00000000 0x0 0x280A105C
#define IOMUXC_PTA24_ADC1_CH5B           0x018 0x280A1060 0X0 0x00000000 0x0 0x280A1060
#define IOMUXC_PTA24_PTA24               0x018 0x280A1060 0X1 0x00000000 0x0 0x280A1060
#define IOMUXC_PTA24_I3C0_PUR            0x018 0x280A1060 0X5 0x00000000 0x0 0x280A1060
#define IOMUXC_PTA24_EXT_AUD_MCLK0       0x018 0x280A1060 0X8 0x280A180C 0X3 0x280A1060
#define IOMUXC_PTA24_WDOG2_RST           0x018 0x280A1060 0XA 0x00000000 0x0 0x280A1060
#define IOMUXC_PTA24_LPTMR1_ALT1         0x018 0x280A1060 0XC 0x280A1934 0X2 0x280A1060
#define IOMUXC_PTA24_WUU0_P16            0x018 0x280A1060 0XD 0x00000000 0x0 0x280A1060
#define IOMUXC_PTB0_ADC0_CH0A            0x100 0x280A1080 0X0 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_PTB0                 0x100 0x280A1080 0X1 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_FXIO0_D16            0x100 0x280A1080 0X2 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_LPSPI2_PCS1          0x100 0x280A1080 0X3 0x280A1A60 0X1 0x280A1080
#define IOMUXC_PTB0_LPUART2_CTS_B        0x100 0x280A1080 0X4 0x280A1A44 0X1 0x280A1080
#define IOMUXC_PTB0_LPI2C2_SCL           0x100 0x280A1080 0X5 0x280A1A28 0X1 0x280A1080
#define IOMUXC_PTB0_TPM2_CLKIN           0x100 0x280A1080 0X6 0x280A1A04 0X1 0x280A1080
#define IOMUXC_PTB0_I2S2_RXD1            0x100 0x280A1080 0X7 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_MQS0_LEFT            0x100 0x280A1080 0X8 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_MICFIL0_CLK01        0x100 0x280A1080 0X9 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB0_WUU0_P17             0x100 0x280A1080 0XD 0x00000000 0x0 0x280A1080
#define IOMUXC_PTB1_ADC0_CH0B            0x101 0x280A1084 0X0 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_PTB1                 0x101 0x280A1084 0X1 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_FXIO0_D17            0x101 0x280A1084 0X2 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_LPSPI2_PCS2          0x101 0x280A1084 0X3 0x280A1A64 0X1 0x280A1084
#define IOMUXC_PTB1_LPUART2_RTS_B        0x101 0x280A1084 0X4 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_LPI2C2_SDA           0x101 0x280A1084 0X5 0x280A1A2C 0X1 0x280A1084
#define IOMUXC_PTB1_TPM2_CH0             0x101 0x280A1084 0X6 0x280A19EC 0X1 0x280A1084
#define IOMUXC_PTB1_I2S2_RX_BCLK         0x101 0x280A1084 0X7 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_MICFIL0_DATA01       0x101 0x280A1084 0X9 0x280A1AD4 0X1 0x280A1084
#define IOMUXC_PTB1_WDOG2_RST            0x101 0x280A1084 0XA 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB1_WUU0_P18             0x101 0x280A1084 0XD 0x00000000 0x0 0x280A1084
#define IOMUXC_PTB2_ADC0_CH1A            0x102 0x280A1088 0X0 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB2_PTB2                 0x102 0x280A1088 0X1 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB2_FXIO0_D18            0x102 0x280A1088 0X2 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB2_LPSPI2_PCS3          0x102 0x280A1088 0X3 0x280A1A68 0X1 0x280A1088
#define IOMUXC_PTB2_LPUART2_TX           0x102 0x280A1088 0X4 0x280A1A4C 0X1 0x280A1088
#define IOMUXC_PTB2_LPI2C2_HREQ          0x102 0x280A1088 0X5 0x280A1A24 0X1 0x280A1088
#define IOMUXC_PTB2_TPM2_CH1             0x102 0x280A1088 0X6 0x280A19F0 0X1 0x280A1088
#define IOMUXC_PTB2_I2S2_RX_FS           0x102 0x280A1088 0X7 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB2_MICFIL0_CLK01        0x102 0x280A1088 0X9 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB2_LPTMR0_ALT1          0x102 0x280A1088 0XC 0x280A1928 0X3 0x280A1088
#define IOMUXC_PTB2_WUU0_P19             0x102 0x280A1088 0XD 0x00000000 0x0 0x280A1088
#define IOMUXC_PTB3_ADC0_CH1B            0x103 0x280A108C 0X0 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB3_PTB3                 0x103 0x280A108C 0X1 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB3_FXIO0_D19            0x103 0x280A108C 0X2 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB3_LPSPI2_SIN           0x103 0x280A108C 0X3 0x280A1A70 0X1 0x280A108C
#define IOMUXC_PTB3_LPUART2_RX           0x103 0x280A108C 0X4 0x280A1A48 0X1 0x280A108C
#define IOMUXC_PTB3_LPI2C2_HREQ          0x103 0x280A108C 0X5 0x280A1A24 0X2 0x280A108C
#define IOMUXC_PTB3_I3C1_PUR             0x103 0x280A108C 0X6 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB3_I2S2_RXD0            0x103 0x280A108C 0X7 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB3_MICFIL0_DATA23       0x103 0x280A108C 0X9 0x280A1AD8 0X1 0x280A108C
#define IOMUXC_PTB3_LPTMR0_ALT2          0x103 0x280A108C 0XC 0x280A192C 0X3 0x280A108C
#define IOMUXC_PTB3_WUU0_P20             0x103 0x280A108C 0XD 0x00000000 0x0 0x280A108C
#define IOMUXC_PTB4_ADC0_CH2A            0x104 0x280A1090 0X0 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_PTB4                 0x104 0x280A1090 0X1 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_FXIO0_D20            0x104 0x280A1090 0X2 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_LPSPI2_SOUT          0x104 0x280A1090 0X3 0x280A1A74 0X1 0x280A1090
#define IOMUXC_PTB4_LPUART2_CTS_B        0x104 0x280A1090 0X4 0x280A1A44 0X2 0x280A1090
#define IOMUXC_PTB4_LPI2C2_SCL           0x104 0x280A1090 0X5 0x280A1A28 0X2 0x280A1090
#define IOMUXC_PTB4_I2S2_TX_BCLK         0x104 0x280A1090 0X7 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_MICFIL0_CLK01        0x104 0x280A1090 0X9 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_WDOG0_RST            0x104 0x280A1090 0XA 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB4_LPTMR0_ALT3          0x104 0x280A1090 0XC 0x280A1930 0X3 0x280A1090
#define IOMUXC_PTB4_WUU0_P21             0x104 0x280A1090 0XD 0x00000000 0x0 0x280A1090
#define IOMUXC_PTB5_ADC0_CH2B            0x105 0x280A1094 0X0 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_PTB5                 0x105 0x280A1094 0X1 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_FXIO0_D21            0x105 0x280A1094 0X2 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_LPSPI2_SCK           0x105 0x280A1094 0X3 0x280A1A6C 0X1 0x280A1094
#define IOMUXC_PTB5_LPUART2_RTS_B        0x105 0x280A1094 0X4 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_LPI2C2_SDA           0x105 0x280A1094 0X5 0x280A1A2C 0X2 0x280A1094
#define IOMUXC_PTB5_I2S2_TX_FS           0x105 0x280A1094 0X7 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_MICFIL0_DATA45       0x105 0x280A1094 0X9 0x280A1ADC 0X1 0x280A1094
#define IOMUXC_PTB5_WDOG1_RST            0x105 0x280A1094 0XA 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB5_WUU0_P22             0x105 0x280A1094 0XD 0x00000000 0x0 0x280A1094
#define IOMUXC_PTB6_ADC0_CH3A            0x106 0x280A1098 0X0 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB6_PTB6                 0x106 0x280A1098 0X1 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB6_FXIO0_D22            0x106 0x280A1098 0X2 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB6_LPSPI2_PCS0          0x106 0x280A1098 0X3 0x280A1A5C 0X1 0x280A1098
#define IOMUXC_PTB6_LPUART2_TX           0x106 0x280A1098 0X4 0x280A1A4C 0X2 0x280A1098
#define IOMUXC_PTB6_I3C1_SCL             0x106 0x280A1098 0X5 0x280A1A3C 0X1 0x280A1098
#define IOMUXC_PTB6_I2S2_TXD0            0x106 0x280A1098 0X7 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB6_MICFIL0_CLK01        0x106 0x280A1098 0X9 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB6_WUU0_P23             0x106 0x280A1098 0XD 0x00000000 0x0 0x280A1098
#define IOMUXC_PTB7_ADC0_CH3B            0x107 0x280A109C 0X0 0x00000000 0x0 0x280A109C
#define IOMUXC_PTB7_PTB7                 0x107 0x280A109C 0X1 0x00000000 0x0 0x280A109C
#define IOMUXC_PTB7_FXIO0_D23            0x107 0x280A109C 0X2 0x00000000 0x0 0x280A109C
#define IOMUXC_PTB7_LPSPI3_PCS1          0x107 0x280A109C 0X3 0x280A1A7C 0X1 0x280A109C
#define IOMUXC_PTB7_LPUART2_RX           0x107 0x280A109C 0X4 0x280A1A48 0X2 0x280A109C
#define IOMUXC_PTB7_I3C1_SDA             0x107 0x280A109C 0X5 0x280A1A40 0X1 0x280A109C
#define IOMUXC_PTB7_TPM3_CLKIN           0x107 0x280A109C 0X6 0x280A1A20 0X1 0x280A109C
#define IOMUXC_PTB7_I2S2_MCLK            0x107 0x280A109C 0X7 0x00000000 0x0 0x280A109C
#define IOMUXC_PTB7_EXT_AUD_MCLK1        0x107 0x280A109C 0X8 0x280A1810 0X1 0x280A109C
#define IOMUXC_PTB7_MICFIL0_DATA67       0x107 0x280A109C 0X9 0x280A1AE0 0X1 0x280A109C
#define IOMUXC_PTB7_PMIC0_MODE2          0x107 0x280A109C 0XA 0x00000000 0x0 0x280A109C
#define IOMUXC_PTB8_ADC0_CH4A            0x108 0x280A10A0 0X0 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_PTB8                 0x108 0x280A10A0 0X1 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_FXIO0_D24            0x108 0x280A10A0 0X2 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_LPSPI3_PCS2          0x108 0x280A10A0 0X3 0x280A1A80 0X1 0x280A10A0
#define IOMUXC_PTB8_LPUART3_CTS_B        0x108 0x280A10A0 0X4 0x280A1A50 0X1 0x280A10A0
#define IOMUXC_PTB8_LPI2C3_SCL           0x108 0x280A10A0 0X5 0x280A1A34 0X1 0x280A10A0
#define IOMUXC_PTB8_TPM3_CH0             0x108 0x280A10A0 0X6 0x280A1A08 0X1 0x280A10A0
#define IOMUXC_PTB8_I2S2_TXD1            0x108 0x280A10A0 0X7 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_MQS0_RIGHT           0x108 0x280A10A0 0X8 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_MICFIL0_CLK01        0x108 0x280A10A0 0X9 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB8_PMIC0_MODE1          0x108 0x280A10A0 0XA 0x00000000 0x0 0x280A10A0
#define IOMUXC_PTB9_ADC0_CH4B            0x109 0x280A10A4 0X0 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB9_PTB9                 0x109 0x280A10A4 0X1 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB9_FXIO0_D25            0x109 0x280A10A4 0X2 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB9_LPSPI3_PCS3          0x109 0x280A10A4 0X3 0x280A1A84 0X1 0x280A10A4
#define IOMUXC_PTB9_LPUART3_RTS_B        0x109 0x280A10A4 0X4 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB9_LPI2C3_SDA           0x109 0x280A10A4 0X5 0x280A1A38 0X1 0x280A10A4
#define IOMUXC_PTB9_TPM3_CH1             0x109 0x280A10A4 0X6 0x280A1A0C 0X1 0x280A10A4
#define IOMUXC_PTB9_I2S3_TX_BCLK         0x109 0x280A10A4 0X7 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB9_MICFIL0_DATA01       0x109 0x280A10A4 0X9 0x280A1AD4 0X2 0x280A10A4
#define IOMUXC_PTB9_PMIC0_MODE0          0x109 0x280A10A4 0XA 0x00000000 0x0 0x280A10A4
#define IOMUXC_PTB10_ADC0_CH5A           0x10A 0x280A10A8 0X0 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_PTB10               0x10A 0x280A10A8 0X1 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_FXIO0_D26           0x10A 0x280A10A8 0X2 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_LPSPI3_SIN          0x10A 0x280A10A8 0X3 0x280A1A8C 0X1 0x280A10A8
#define IOMUXC_PTB10_LPUART3_RX          0x10A 0x280A10A8 0X4 0x280A1A54 0X1 0x280A10A8
#define IOMUXC_PTB10_LPI2C3_HREQ         0x10A 0x280A10A8 0X5 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_TPM3_CH2            0x10A 0x280A10A8 0X6 0x280A1A10 0X1 0x280A10A8
#define IOMUXC_PTB10_I2S3_TX_FS          0x10A 0x280A10A8 0X7 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_MICFIL0_CLK01       0x10A 0x280A10A8 0X9 0x00000000 0x0 0x280A10A8
#define IOMUXC_PTB10_PMIC0_SDA           0x10A 0x280A10A8 0XA 0x280A1804 0X2 0x280A10A8
#define IOMUXC_PTB11_ADC0_CH5B           0x10B 0x280A10AC 0X0 0x00000000 0x0 0x280A10AC
#define IOMUXC_PTB11_PTB11               0x10B 0x280A10AC 0X1 0x00000000 0x0 0x280A10AC
#define IOMUXC_PTB11_FXIO0_D27           0x10B 0x280A10AC 0X2 0x00000000 0x0 0x280A10AC
#define IOMUXC_PTB11_LPSPI3_SOUT         0x10B 0x280A10AC 0X3 0x280A1A90 0X1 0x280A10AC
#define IOMUXC_PTB11_LPUART3_TX          0x10B 0x280A10AC 0X4 0x280A1A58 0X1 0x280A10AC
#define IOMUXC_PTB11_LPI2C3_SDA          0x10B 0x280A10AC 0X5 0x280A1A38 0X2 0x280A10AC
#define IOMUXC_PTB11_TPM3_CH3            0x10B 0x280A10AC 0X6 0x280A1A14 0X1 0x280A10AC
#define IOMUXC_PTB11_I2S3_TXD0           0x10B 0x280A10AC 0X7 0x00000000 0x0 0x280A10AC
#define IOMUXC_PTB11_MICFIL0_DATA23      0x10B 0x280A10AC 0X9 0x280A1AD8 0X2 0x280A10AC
#define IOMUXC_PTB11_PMIC0_SCL           0x10B 0x280A10AC 0XA 0x280A1800 0X2 0x280A10AC
#define IOMUXC_PTB12_CMP1_IN0            0x10C 0x280A10B0 0X0 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB12_PTB12               0x10C 0x280A10B0 0X1 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB12_FXIO0_D28           0x10C 0x280A10B0 0X2 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB12_LPSPI3_SCK          0x10C 0x280A10B0 0X3 0x280A1A88 0X1 0x280A10B0
#define IOMUXC_PTB12_LPUART3_CTS_B       0x10C 0x280A10B0 0X4 0x280A1A50 0X2 0x280A10B0
#define IOMUXC_PTB12_LPI2C3_SCL          0x10C 0x280A10B0 0X5 0x280A1A34 0X2 0x280A10B0
#define IOMUXC_PTB12_TPM3_CH4            0x10C 0x280A10B0 0X6 0x280A1A18 0X1 0x280A10B0
#define IOMUXC_PTB12_I2S3_RXD0           0x10C 0x280A10B0 0X7 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB12_MICFIL0_CLK01       0x10C 0x280A10B0 0X9 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB12_WUU0_P24            0x10C 0x280A10B0 0XD 0x00000000 0x0 0x280A10B0
#define IOMUXC_PTB13_CMP1_IN1            0x10D 0x280A10B4 0X0 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_PTB13               0x10D 0x280A10B4 0X1 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_FXIO0_D29           0x10D 0x280A10B4 0X2 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_LPSPI3_PCS0         0x10D 0x280A10B4 0X3 0x280A1A78 0X1 0x280A10B4
#define IOMUXC_PTB13_LPUART3_RTS_B       0x10D 0x280A10B4 0X4 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_I3C1_SCL            0x10D 0x280A10B4 0X5 0x280A1A3C 0X2 0x280A10B4
#define IOMUXC_PTB13_TPM3_CH5            0x10D 0x280A10B4 0X6 0x280A1A1C 0X1 0x280A10B4
#define IOMUXC_PTB13_I2S3_RX_BCLK        0x10D 0x280A10B4 0X7 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_MICFIL0_DATA45      0x10D 0x280A10B4 0X9 0x280A1ADC 0X2 0x280A10B4
#define IOMUXC_PTB13_WDOG2_RST           0x10D 0x280A10B4 0XA 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB13_LPTMR1_ALT3         0x10D 0x280A10B4 0XC 0x280A193C 0X2 0x280A10B4
#define IOMUXC_PTB13_WUU0_P25            0x10D 0x280A10B4 0XD 0x00000000 0x0 0x280A10B4
#define IOMUXC_PTB14_CMP0_IN0            0x10E 0x280A10B8 0X0 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB14_PTB14               0x10E 0x280A10B8 0X1 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB14_FXIO0_D30           0x10E 0x280A10B8 0X2 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB14_LPUART3_TX          0x10E 0x280A10B8 0X4 0x280A1A58 0X2 0x280A10B8
#define IOMUXC_PTB14_I3C1_SDA            0x10E 0x280A10B8 0X5 0x280A1A40 0X2 0x280A10B8
#define IOMUXC_PTB14_I2S3_RX_FS          0x10E 0x280A10B8 0X7 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB14_MICFIL0_CLK01       0x10E 0x280A10B8 0X9 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB14_LPTMR1_ALT2         0x10E 0x280A10B8 0XC 0x280A1938 0X2 0x280A10B8
#define IOMUXC_PTB14_WUU0_P26            0x10E 0x280A10B8 0XD 0x00000000 0x0 0x280A10B8
#define IOMUXC_PTB15_CMP0_IN1            0x10F 0x280A10BC 0X0 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTB15_PTB15               0x10F 0x280A10BC 0X1 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTB15_FXIO0_D31           0x10F 0x280A10BC 0X2 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTB15_LPUART3_RX          0x10F 0x280A10BC 0X4 0x280A1A54 0X2 0x280A10BC
#define IOMUXC_PTB15_I3C1_PUR            0x10F 0x280A10BC 0X5 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTB15_I2S3_MCLK           0x10F 0x280A10BC 0X7 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTB15_EXT_AUD_MCLK1       0x10F 0x280A10BC 0X8 0x280A1810 0X2 0x280A10BC
#define IOMUXC_PTB15_MICFIL0_DATA67      0x10F 0x280A10BC 0X9 0x280A1AE0 0X2 0x280A10BC
#define IOMUXC_PTB15_LPTMR1_ALT1         0x10F 0x280A10BC 0XC 0x280A1934 0X3 0x280A10BC
#define IOMUXC_PTB15_WUU0_P27            0x10F 0x280A10BC 0XD 0x00000000 0x0 0x280A10BC
#define IOMUXC_PTC0_PTC0                 0x200 0x280A1100 0X1 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC0_LPSPI2_SIN           0x200 0x280A1100 0X3 0x280A1A70 0X2 0x280A1100
#define IOMUXC_PTC0_FLEXSPI1_B_DQS       0x200 0x280A1100 0X4 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC0_TPM2_CLKIN           0x200 0x280A1100 0X6 0x280A1A04 0X2 0x280A1100
#define IOMUXC_PTC0_I2S3_RXD1            0x200 0x280A1100 0X7 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC0_FLEXSPI0_A_DQS       0x200 0x280A1100 0X8 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC0_MQS0_LEFT            0x200 0x280A1100 0X9 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC0_LP_RTD_DBG_MUX_0     0x200 0x280A1100 0XF 0x00000000 0x0 0x280A1100
#define IOMUXC_PTC1_PTC1                 0x201 0x280A1104 0X1 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC1_LPSPI2_SOUT          0x201 0x280A1104 0X3 0x280A1A74 0X2 0x280A1104
#define IOMUXC_PTC1_FLEXSPI1_B_DATA7     0x201 0x280A1104 0X4 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC1_TPM2_CH0             0x201 0x280A1104 0X6 0x280A19EC 0X2 0x280A1104
#define IOMUXC_PTC1_I2S3_TXD1            0x201 0x280A1104 0X7 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC1_FLEXSPI0_A_DATA7     0x201 0x280A1104 0X8 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC1_MQS0_RIGHT           0x201 0x280A1104 0X9 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC1_LP_RTD_DBG_MUX_1     0x201 0x280A1104 0XF 0x00000000 0x0 0x280A1104
#define IOMUXC_PTC2_PTC2                 0x202 0x280A1108 0X1 0x00000000 0x0 0x280A1108
#define IOMUXC_PTC2_LPSPI2_SCK           0x202 0x280A1108 0X3 0x280A1A6C 0X2 0x280A1108
#define IOMUXC_PTC2_FLEXSPI1_B_DATA6     0x202 0x280A1108 0X4 0x00000000 0x0 0x280A1108
#define IOMUXC_PTC2_TPM2_CH1             0x202 0x280A1108 0X6 0x280A19F0 0X2 0x280A1108
#define IOMUXC_PTC2_I2S0_RX_BCLK         0x202 0x280A1108 0X7 0x280A19B8 0X2 0x280A1108
#define IOMUXC_PTC2_FLEXSPI0_A_DATA6     0x202 0x280A1108 0X8 0x00000000 0x0 0x280A1108
#define IOMUXC_PTC2_LP_RTD_DBG_MUX_2     0x202 0x280A1108 0XF 0x00000000 0x0 0x280A1108
#define IOMUXC_PTC3_PTC3                 0x203 0x280A110C 0X1 0x00000000 0x0 0x280A110C
#define IOMUXC_PTC3_LPSPI2_PCS0          0x203 0x280A110C 0X3 0x280A1A5C 0X2 0x280A110C
#define IOMUXC_PTC3_FLEXSPI1_B_DATA5     0x203 0x280A110C 0X4 0x00000000 0x0 0x280A110C
#define IOMUXC_PTC3_I2S0_RX_FS           0x203 0x280A110C 0X7 0x280A19BC 0X2 0x280A110C
#define IOMUXC_PTC3_FLEXSPI0_A_DATA5     0x203 0x280A110C 0X8 0x00000000 0x0 0x280A110C
#define IOMUXC_PTC3_LP_RTD_DBG_MUX_3     0x203 0x280A110C 0XF 0x00000000 0x0 0x280A110C
#define IOMUXC_PTC4_PTC4                 0x204 0x280A1110 0X1 0x00000000 0x0 0x280A1110
#define IOMUXC_PTC4_LPSPI2_PCS1          0x204 0x280A1110 0X3 0x280A1A60 0X2 0x280A1110
#define IOMUXC_PTC4_FLEXSPI1_B_DATA4     0x204 0x280A1110 0X4 0x00000000 0x0 0x280A1110
#define IOMUXC_PTC4_I2S0_RXD0            0x204 0x280A1110 0X7 0x280A19A8 0X2 0x280A1110
#define IOMUXC_PTC4_FLEXSPI0_A_DATA4     0x204 0x280A1110 0X8 0x00000000 0x0 0x280A1110
#define IOMUXC_PTC4_LP_RTD_DBG_MUX_4     0x204 0x280A1110 0XF 0x00000000 0x0 0x280A1110
#define IOMUXC_PTC5_PTC5                 0x205 0x280A1114 0X1 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_LPSPI2_PCS2          0x205 0x280A1114 0X3 0x280A1A64 0X2 0x280A1114
#define IOMUXC_PTC5_FLEXSPI1_B_SS0_B     0x205 0x280A1114 0X4 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_FLEXSPI1_B_SCLK_B    0x205 0x280A1114 0X5 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_FLEXSPI1_A_SS0_B     0x205 0x280A1114 0X6 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_I2S0_RXD1            0x205 0x280A1114 0X7 0x280A19AC 0X2 0x280A1114
#define IOMUXC_PTC5_FLEXSPI0_A_SS0_B     0x205 0x280A1114 0X8 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_FLEXSPI0_A_SCLK_B    0x205 0x280A1114 0X9 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC5_LP_RTD_DBG_MUX_5     0x205 0x280A1114 0XF 0x00000000 0x0 0x280A1114
#define IOMUXC_PTC6_PTC6                 0x206 0x280A1118 0X1 0x00000000 0x0 0x280A1118
#define IOMUXC_PTC6_LPSPI2_PCS3          0x206 0x280A1118 0X3 0x280A1A68 0X2 0x280A1118
#define IOMUXC_PTC6_FLEXSPI1_B_SCLK      0x206 0x280A1118 0X4 0x00000000 0x0 0x280A1118
#define IOMUXC_PTC6_FLEXSPI1_A_SCLK      0x206 0x280A1118 0X6 0x280A18FC 0X1 0x280A1118
#define IOMUXC_PTC6_I2S0_TXD1            0x206 0x280A1118 0X7 0x00000000 0x0 0x280A1118
#define IOMUXC_PTC6_FLEXSPI0_A_SCLK      0x206 0x280A1118 0X8 0x00000000 0x0 0x280A1118
#define IOMUXC_PTC6_LP_RTD_DBG_MUX_6     0x206 0x280A1118 0XF 0x00000000 0x0 0x280A1118
#define IOMUXC_PTC7_PTC7                 0x207 0x280A111C 0X1 0x00000000 0x0 0x280A111C
#define IOMUXC_PTC7_FLEXSPI1_B_DATA3     0x207 0x280A111C 0X4 0x00000000 0x0 0x280A111C
#define IOMUXC_PTC7_I2S0_TXD0            0x207 0x280A111C 0X7 0x00000000 0x0 0x280A111C
#define IOMUXC_PTC7_FLEXSPI0_A_DATA3     0x207 0x280A111C 0X8 0x00000000 0x0 0x280A111C
#define IOMUXC_PTC7_LP_RTD_DBG_MUX_7     0x207 0x280A111C 0XF 0x00000000 0x0 0x280A111C
#define IOMUXC_PTC8_PTC8                 0x208 0x280A1120 0X1 0x00000000 0x0 0x280A1120
#define IOMUXC_PTC8_FLEXSPI1_B_DATA2     0x208 0x280A1120 0X4 0x00000000 0x0 0x280A1120
#define IOMUXC_PTC8_I2S0_TX_BCLK         0x208 0x280A1120 0X7 0x280A19C0 0X2 0x280A1120
#define IOMUXC_PTC8_FLEXSPI0_A_DATA2     0x208 0x280A1120 0X8 0x00000000 0x0 0x280A1120
#define IOMUXC_PTC8_LP_RTD_DBG_MUX_8     0x208 0x280A1120 0XF 0x00000000 0x0 0x280A1120
#define IOMUXC_PTC9_PTC9                 0x209 0x280A1124 0X1 0x00000000 0x0 0x280A1124
#define IOMUXC_PTC9_FLEXSPI1_B_DATA1     0x209 0x280A1124 0X4 0x00000000 0x0 0x280A1124
#define IOMUXC_PTC9_I2S0_TX_FS           0x209 0x280A1124 0X7 0x280A19C4 0X2 0x280A1124
#define IOMUXC_PTC9_FLEXSPI0_A_DATA1     0x209 0x280A1124 0X8 0x00000000 0x0 0x280A1124
#define IOMUXC_PTC9_LP_RTD_DBG_MUX_9     0x209 0x280A1124 0XF 0x00000000 0x0 0x280A1124
#define IOMUXC_PTC10_PTC10               0x20A 0x280A1128 0X1 0x00000000 0x0 0x280A1128
#define IOMUXC_PTC10_FLEXSPI1_B_DATA0    0x20A 0x280A1128 0X4 0x00000000 0x0 0x280A1128
#define IOMUXC_PTC10_I2S0_MCLK           0x20A 0x280A1128 0X7 0x00000000 0x0 0x280A1128
#define IOMUXC_PTC10_FLEXSPI0_A_DATA0    0x20A 0x280A1128 0X8 0x00000000 0x0 0x280A1128
#define IOMUXC_PTC10_EXT_AUD_MCLK1       0x20A 0x280A1128 0X9 0x280A1810 0X3 0x280A1128
#define IOMUXC_PTC10_LP_RTD_DBG_MUX_10   0x20A 0x280A1128 0XF 0x00000000 0x0 0x280A1128
#define IOMUXC_PTC11_PTC11               0x20B 0x280A112C 0X1 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_FLEXSPI1_B_SS0_B    0x20B 0x280A112C 0X4 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_FLEXSPI1_B_SS1_B    0x20B 0x280A112C 0X5 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_TPM3_CLKIN          0x20B 0x280A112C 0X6 0x280A1A20 0X2 0x280A112C
#define IOMUXC_PTC11_I2S1_RXD3           0x20B 0x280A112C 0X7 0x280A19D4 0X2 0x280A112C
#define IOMUXC_PTC11_FLEXSPI0_A_SS0_B    0x20B 0x280A112C 0X8 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_FLEXSPI0_A_SS1_B    0x20B 0x280A112C 0X9 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_CLKOUT0             0x20B 0x280A112C 0XA 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC11_LP_RTD_DBG_MUX_11   0x20B 0x280A112C 0XF 0x00000000 0x0 0x280A112C
#define IOMUXC_PTC12_PTC12               0x20C 0x280A1130 0X1 0x00000000 0x0 0x280A1130
#define IOMUXC_PTC12_FLEXSPI1_A_DQS      0x20C 0x280A1130 0X4 0x00000000 0x0 0x280A1130
#define IOMUXC_PTC12_TPM3_CH0            0x20C 0x280A1130 0X6 0x280A1A08 0X2 0x280A1130
#define IOMUXC_PTC12_I2S1_RXD2           0x20C 0x280A1130 0X7 0x280A19D0 0X2 0x280A1130
#define IOMUXC_PTC12_FLEXSPI0_B_DQS      0x20C 0x280A1130 0X8 0x00000000 0x0 0x280A1130
#define IOMUXC_PTC12_TRACE0_CLKOUT       0x20C 0x280A1130 0XA 0x00000000 0x0 0x280A1130
#define IOMUXC_PTC12_LP_RTD_DBG_MUX_12   0x20C 0x280A1130 0XF 0x00000000 0x0 0x280A1130
#define IOMUXC_PTC13_PTC13               0x20D 0x280A1134 0X1 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC13_LPSPI3_SIN          0x20D 0x280A1134 0X3 0x280A1A8C 0X2 0x280A1134
#define IOMUXC_PTC13_FLEXSPI1_A_DATA7    0x20D 0x280A1134 0X4 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC13_TPM3_CH1            0x20D 0x280A1134 0X6 0x280A1A0C 0X2 0x280A1134
#define IOMUXC_PTC13_I2S1_TXD3           0x20D 0x280A1134 0X7 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC13_FLEXSPI0_B_DATA7    0x20D 0x280A1134 0X8 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC13_TRACE0_D0           0x20D 0x280A1134 0XA 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC13_LP_RTD_DBG_MUX_13   0x20D 0x280A1134 0XF 0x00000000 0x0 0x280A1134
#define IOMUXC_PTC14_PTC14               0x20E 0x280A1138 0X1 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC14_LPSPI3_SOUT         0x20E 0x280A1138 0X3 0x280A1A90 0X2 0x280A1138
#define IOMUXC_PTC14_FLEXSPI1_A_DATA6    0x20E 0x280A1138 0X4 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC14_TPM3_CH2            0x20E 0x280A1138 0X6 0x280A1A10 0X2 0x280A1138
#define IOMUXC_PTC14_I2S1_TXD2           0x20E 0x280A1138 0X7 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC14_FLEXSPI0_B_DATA6    0x20E 0x280A1138 0X8 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC14_TRACE0_D1           0x20E 0x280A1138 0XA 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC14_LP_RTD_DBG_MUX_14   0x20E 0x280A1138 0XF 0x00000000 0x0 0x280A1138
#define IOMUXC_PTC15_PTC15               0x20F 0x280A113C 0X1 0x00000000 0x0 0x280A113C
#define IOMUXC_PTC15_LPSPI3_SCK          0x20F 0x280A113C 0X3 0x280A1A88 0X2 0x280A113C
#define IOMUXC_PTC15_FLEXSPI1_A_DATA5    0x20F 0x280A113C 0X4 0x00000000 0x0 0x280A113C
#define IOMUXC_PTC15_TPM3_CH3            0x20F 0x280A113C 0X6 0x280A1A14 0X2 0x280A113C
#define IOMUXC_PTC15_I2S1_RX_BCLK        0x20F 0x280A113C 0X7 0x280A19D8 0X2 0x280A113C
#define IOMUXC_PTC15_FLEXSPI0_B_DATA5    0x20F 0x280A113C 0X8 0x00000000 0x0 0x280A113C
#define IOMUXC_PTC15_TRACE0_D2           0x20F 0x280A113C 0XA 0x00000000 0x0 0x280A113C
#define IOMUXC_PTC15_LP_RTD_DBG_MUX_15   0x20F 0x280A113C 0XF 0x00000000 0x0 0x280A113C
#define IOMUXC_PTC16_PTC16               0x210 0x280A1140 0X1 0x00000000 0x0 0x280A1140
#define IOMUXC_PTC16_LPSPI3_PCS0         0x210 0x280A1140 0X3 0x280A1A78 0X2 0x280A1140
#define IOMUXC_PTC16_FLEXSPI1_A_DATA4    0x210 0x280A1140 0X4 0x00000000 0x0 0x280A1140
#define IOMUXC_PTC16_TPM3_CH4            0x210 0x280A1140 0X6 0x280A1A18 0X2 0x280A1140
#define IOMUXC_PTC16_I2S1_RX_FS          0x210 0x280A1140 0X7 0x280A19DC 0X2 0x280A1140
#define IOMUXC_PTC16_FLEXSPI0_B_DATA4    0x210 0x280A1140 0X8 0x00000000 0x0 0x280A1140
#define IOMUXC_PTC16_TRACE0_D3           0x210 0x280A1140 0XA 0x00000000 0x0 0x280A1140
#define IOMUXC_PTC16_LP_RTD_DBG_MUX_16   0x210 0x280A1140 0XF 0x00000000 0x0 0x280A1140
#define IOMUXC_PTC17_PTC17               0x211 0x280A1144 0X1 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC17_LPSPI3_PCS1         0x211 0x280A1144 0X3 0x280A1A7C 0X2 0x280A1144
#define IOMUXC_PTC17_FLEXSPI1_A_SS0_B    0x211 0x280A1144 0X4 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC17_FLEXSPI1_A_SCLK_B   0x211 0x280A1144 0X5 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC17_TPM3_CH5            0x211 0x280A1144 0X6 0x280A1A1C 0X2 0x280A1144
#define IOMUXC_PTC17_I2S1_RXD0           0x211 0x280A1144 0X7 0x280A19C8 0X2 0x280A1144
#define IOMUXC_PTC17_FLEXSPI0_B_SS0_B    0x211 0x280A1144 0X8 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC17_FLEXSPI0_B_SCLK_B   0x211 0x280A1144 0X9 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC17_LP_RTD_DBG_MUX_17   0x211 0x280A1144 0XF 0x00000000 0x0 0x280A1144
#define IOMUXC_PTC18_PTC18               0x212 0x280A1148 0X1 0x00000000 0x0 0x280A1148
#define IOMUXC_PTC18_LPSPI3_PCS2         0x212 0x280A1148 0X3 0x280A1A80 0X2 0x280A1148
#define IOMUXC_PTC18_FLEXSPI1_A_SCLK     0x212 0x280A1148 0X4 0x280A18FC 0X2 0x280A1148
#define IOMUXC_PTC18_I2S1_RXD1           0x212 0x280A1148 0X7 0x280A19CC 0X2 0x280A1148
#define IOMUXC_PTC18_FLEXSPI0_B_SCLK     0x212 0x280A1148 0X8 0x00000000 0x0 0x280A1148
#define IOMUXC_PTC18_LP_RTD_DBG_MUX_18   0x212 0x280A1148 0XF 0x00000000 0x0 0x280A1148
#define IOMUXC_PTC19_PTC19               0x213 0x280A114C 0X1 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC19_LPSPI3_PCS3         0x213 0x280A114C 0X3 0x280A1A84 0X2 0x280A114C
#define IOMUXC_PTC19_FLEXSPI1_A_DATA3    0x213 0x280A114C 0X4 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC19_I2S1_TXD1           0x213 0x280A114C 0X7 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC19_FLEXSPI0_B_DATA3    0x213 0x280A114C 0X8 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC19_TRACE0_D4           0x213 0x280A114C 0XA 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC19_LP_RTD_DBG_MUX_19   0x213 0x280A114C 0XF 0x00000000 0x0 0x280A114C
#define IOMUXC_PTC20_PTC20               0x214 0x280A1150 0X1 0x00000000 0x0 0x280A1150
#define IOMUXC_PTC20_FLEXSPI1_A_DATA2    0x214 0x280A1150 0X4 0x00000000 0x0 0x280A1150
#define IOMUXC_PTC20_I2S1_TXD0           0x214 0x280A1150 0X7 0x00000000 0x0 0x280A1150
#define IOMUXC_PTC20_FLEXSPI0_B_DATA2    0x214 0x280A1150 0X8 0x00000000 0x0 0x280A1150
#define IOMUXC_PTC20_TRACE0_D5           0x214 0x280A1150 0XA 0x00000000 0x0 0x280A1150
#define IOMUXC_PTC21_PTC21               0x215 0x280A1154 0X1 0x00000000 0x0 0x280A1154
#define IOMUXC_PTC21_FLEXSPI1_A_DATA1    0x215 0x280A1154 0X4 0x00000000 0x0 0x280A1154
#define IOMUXC_PTC21_I2S1_TX_BCLK        0x215 0x280A1154 0X7 0x280A19E0 0X2 0x280A1154
#define IOMUXC_PTC21_FLEXSPI0_B_DATA1    0x215 0x280A1154 0X8 0x00000000 0x0 0x280A1154
#define IOMUXC_PTC21_TRACE0_D6           0x215 0x280A1154 0XA 0x00000000 0x0 0x280A1154
#define IOMUXC_PTC22_PTC22               0x216 0x280A1158 0X1 0x00000000 0x0 0x280A1158
#define IOMUXC_PTC22_FLEXSPI1_A_DATA0    0x216 0x280A1158 0X4 0x00000000 0x0 0x280A1158
#define IOMUXC_PTC22_I2S1_TX_FS          0x216 0x280A1158 0X7 0x280A19E4 0X2 0x280A1158
#define IOMUXC_PTC22_FLEXSPI0_B_DATA0    0x216 0x280A1158 0X8 0x00000000 0x0 0x280A1158
#define IOMUXC_PTC22_TRACE0_D7           0x216 0x280A1158 0XA 0x00000000 0x0 0x280A1158
#define IOMUXC_PTC23_PTC23               0x217 0x280A115C 0X1 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_FLEXSPI1_A_SS0_B    0x217 0x280A115C 0X4 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_FLEXSPI1_A_SS1_B    0x217 0x280A115C 0X5 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_I2S1_MCLK           0x217 0x280A115C 0X7 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_FLEXSPI0_B_SS0_B    0x217 0x280A115C 0X8 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_FLEXSPI0_B_SS1_B    0x217 0x280A115C 0X9 0x00000000 0x0 0x280A115C
#define IOMUXC_PTC23_CLKOUT0             0x217 0x280A115C 0XA 0x00000000 0x0 0x280A115C
/*@}*/

#define IOMUXC_PCR_PS_MASK        (0x1U)
#define IOMUXC_PCR_PS_SHIFT       (0U)
#define IOMUXC_PCR_PS(x)          (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_PS_SHIFT)) & IOMUXC_PCR_PS_MASK)
#define IOMUXC_PCR_PE_MASK        (0x2U)
#define IOMUXC_PCR_PE_SHIFT       (1U)
#define IOMUXC_PCR_PE(x)          (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_PE_SHIFT)) & IOMUXC_PCR_PE_MASK)
#define IOMUXC_PCR_SRE_MASK       (0x4U)
#define IOMUXC_PCR_SRE_SHIFT      (2U)
#define IOMUXC_PCR_SRE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_SRE_SHIFT)) & IOMUXC_PCR_SRE_MASK)
#define IOMUXC_PCR_ODE_MASK       (0x20U)
#define IOMUXC_PCR_ODE_SHIFT      (5U)
#define IOMUXC_PCR_ODE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_ODE_SHIFT)) & IOMUXC_PCR_ODE_MASK)
#define IOMUXC_PCR_DSE_MASK       (0x40U)
#define IOMUXC_PCR_DSE_SHIFT      (6U)
#define IOMUXC_PCR_DSE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_DSE_SHIFT)) & IOMUXC_PCR_DSE_MASK)
#define IOMUXC_PCR_MUX_MODE_MASK  (0xF00U)
#define IOMUXC_PCR_MUX_MODE_SHIFT (8U)
#define IOMUXC_PCR_MUX_MODE(x)    (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_MUX_MODE_SHIFT)) & IOMUXC_PCR_MUX_MODE_MASK)
#define IOMUXC_PCR_LK_MASK        (0x8000U)
#define IOMUXC_PCR_LK_SHIFT       (15U)
#define IOMUXC_PCR_LK(x)          (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_LK_SHIFT)) & IOMUXC_PCR_LK_MASK)
#define IOMUXC_PCR_IBE_MASK       (0x10000U)
#define IOMUXC_PCR_IBE_SHIFT      (16U)
#define IOMUXC_PCR_IBE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_IBE_SHIFT)) & IOMUXC_PCR_IBE_MASK)
#define IOMUXC_PCR_OBE_MASK       (0x20000U)
#define IOMUXC_PCR_OBE_SHIFT      (17U)
#define IOMUXC_PCR_OBE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_OBE_SHIFT)) & IOMUXC_PCR_OBE_MASK)
#define IOMUXC_PCR_DFE_MASK       (0x100000U)
#define IOMUXC_PCR_DFE_SHIFT      (20U)
#define IOMUXC_PCR_DFE(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_DFE_SHIFT)) & IOMUXC_PCR_DFE_MASK)
#define IOMUXC_PCR_DFCS_MASK      (0x200000U)
#define IOMUXC_PCR_DFCS_SHIFT     (21U)
#define IOMUXC_PCR_DFCS(x)        (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_DFCS_SHIFT)) & IOMUXC_PCR_DFCS_MASK)
#define IOMUXC_PCR_DFD_MASK       (0x7C00000U)
#define IOMUXC_PCR_DFD_SHIFT      (22U)
#define IOMUXC_PCR_DFD(x)         (((uint32_t)(((uint32_t)(x)) << IOMUXC_PCR_DFD_SHIFT)) & IOMUXC_PCR_DFD_MASK)

#define IOMUXC_PSMI_SSS_MASK  (0xFU)
#define IOMUXC_PSMI_SSS_SHIFT (0U)
#define IOMUXC_PSMI_SSS(x)    (((uint32_t)(((uint32_t)(x)) << IOMUXC_PSMI_SSS_SHIFT)) & IOMUXC_PSMI_SSS_MASK)
#define IOMUXC_PSMI_INV_MASK  (0x8000U)
#define IOMUXC_PSMI_INV_SHIFT (15U)
#define IOMUXC_PSMI_INV(x)    (((uint32_t)(((uint32_t)(x)) << IOMUXC_PSMI_INV_SHIFT)) & IOMUXC_PSMI_INV_MASK)

#endif /* __DTS_IMX8ULP_PINFUNC_M33_H */
