/*
 * Copyright 2018 NXP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/platform_device.h>
#include <linux/err.h>
#include <linux/clk.h>
#include <linux/console.h>
#include <linux/io.h>
#include <linux/bitops.h>
#include <linux/spinlock.h>
#include <linux/mipi_dsi.h>
#include <linux/mxcfb.h>
#include <linux/backlight.h>
#include <video/mipi_display.h>

#include "mipi_dsi.h"

#define RM68191_MAX_DPHY_CLK					(850)

#define CHECK_RETCODE(ret)					\
do {								\
	if (ret < 0) {						\
		dev_err(&mipi_dsi->pdev->dev,			\
			"%s ERR: ret:%d, line:%d.\n",		\
			__func__, ret, __LINE__);		\
		return ret;					\
	}							\
} while (0)

static void parse_variadic(int n, u8 *buf, ...)
{
	int i = 0;
	va_list args;

	if (unlikely(!n)) return;

	va_start(args, buf);

	for (i = 0; i < n; i++)
		buf[i + 1] = (u8)va_arg(args, int);

	va_end(args);
}

#define RM68191_DCS_write_1A_nP(n, addr, ...) {			\
	int err;						\
								\
	buf[0] = addr;						\
	parse_variadic(n, buf, ##__VA_ARGS__);			\
								\
	if (n >= 2)						\
		err = mipi_dsi->mipi_dsi_pkt_write(mipi_dsi,		\
			MIPI_DSI_DCS_LONG_WRITE, (u32*)buf, n + 1);	\
	else if (n == 1)					\
		err = mipi_dsi->mipi_dsi_pkt_write(mipi_dsi,	\
			MIPI_DSI_DCS_SHORT_WRITE_PARAM, (u32*)buf, 0);	\
	else if (n == 0)					\
	{							\
		buf[1] = 0;					\
		err = mipi_dsi->mipi_dsi_pkt_write(mipi_dsi,	\
			MIPI_DSI_DCS_SHORT_WRITE, (u32*)buf, 0);	\
	}							\
	CHECK_RETCODE(err);					\
}

#define RM68191_DCS_write_1A_0P(addr)			\
	RM68191_DCS_write_1A_nP(0, addr)

#define RM68191_DCS_write_1A_1P(addr, ...)		\
	RM68191_DCS_write_1A_nP(1, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_2P(addr, ...)	\
	RM68191_DCS_write_1A_nP(2, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_3P(addr, ...)	\
	RM68191_DCS_write_1A_nP(3, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_4P(addr, ...)	\
	RM68191_DCS_write_1A_nP(4, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_5P(addr, ...)	\
	RM68191_DCS_write_1A_nP(5, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_6P(addr, ...)	\
	RM68191_DCS_write_1A_nP(6, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_7P(addr, ...)	\
	RM68191_DCS_write_1A_nP(7, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_8P(addr, ...)	\
	RM68191_DCS_write_1A_nP(8, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_9P(addr, ...)	\
	RM68191_DCS_write_1A_nP(9, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_10P(addr, ...)	\
	RM68191_DCS_write_1A_nP(10, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_11P(addr, ...)	\
	RM68191_DCS_write_1A_nP(11, addr, __VA_ARGS__)

#define RM68191_DCS_write_1A_16P(addr, ...)	\
	RM68191_DCS_write_1A_nP(16, addr, __VA_ARGS__)

#define ACTIVE_HIGH_NAME	"RK-QHD-SYNC-HIGH"
#define ACTIVE_LOW_NAME		"RK-QHD-SYNC-LOW"

static struct fb_videomode rk_lcd_modedb[] = {
	/* 540 x 960 */
	{
		ACTIVE_HIGH_NAME, 60, 540, 960, 27396,
		30, 32,
		14, 16,
		2, 2,
		0x0,
		FB_VMODE_NONINTERLACED,
		0,
	}, {
		ACTIVE_LOW_NAME, 60, 540, 960, 27396,
		30, 32,
		14, 16,
		2, 2,
		FB_SYNC_OE_LOW_ACT,
		FB_VMODE_NONINTERLACED,
		0,
	},
};

static struct mipi_lcd_config lcd_config = {
	.virtual_ch	= 0x0,
	.data_lane_num  = 2,
	.max_phy_clk    = RM68191_MAX_DPHY_CLK,
	.dpi_fmt	= MIPI_RGB888,
};

void mipid_rm68191_get_lcd_videomode(struct fb_videomode **mode, int *size,
				     struct mipi_lcd_config **data)
{
	*mode = &rk_lcd_modedb[0];
	*size = ARRAY_SIZE(rk_lcd_modedb);
	*data = &lcd_config;
}

int mipid_rm68191_lcd_setup(struct mipi_dsi_info *mipi_dsi)
{
	u8 buf[DSI_CMD_BUF_MAXSIZE];

	dev_dbg(&mipi_dsi->pdev->dev, "MIPI DSI LCD RM68191 setup.\n");

	RM68191_DCS_write_1A_5P(0xF0, 0x55, 0xAA, 0x52, 0x08, 0x03);
	RM68191_DCS_write_1A_9P(0x90, 0x05, 0x16, 0x09, 0x03, 0xCD, 0x00, 0x00, 0x00, 0x00);
	RM68191_DCS_write_1A_9P(0x91, 0x05, 0x16, 0x0B, 0x03, 0xCF, 0x00, 0x00, 0x00, 0x00);
	RM68191_DCS_write_1A_11P(0x92, 0x40, 0x0C, 0x0D, 0x0E, 0x0F, 0x00, 0x8F, 0x00, 0x00, 0x04, 0x08);
	RM68191_DCS_write_1A_8P(0x94, 0x00, 0x08, 0x0C, 0x03, 0xD1, 0x03, 0xD2, 0x0C);
	RM68191_DCS_write_1A_16P(0x95, 0x40, 0x10, 0x00, 0x11, 0x00, 0x12, 0x00, 0x13, 0x00, 0x8F, 0x00, 0x00, 0x00, 0x04, 0x00, 0x08);
	RM68191_DCS_write_1A_2P(0x99, 0x00, 0x00);
	RM68191_DCS_write_1A_11P(0x9A, 0x80, 0x10, 0x03, 0xD5, 0x03, 0xD7, 0x00, 0x00, 0x00, 0x00, 0x50);
	RM68191_DCS_write_1A_6P(0x9B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
	RM68191_DCS_write_1A_2P(0x9C, 0x00, 0x00);
	RM68191_DCS_write_1A_8P(0x9D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00);
	RM68191_DCS_write_1A_2P(0x9E, 0x00, 0x00);
	RM68191_DCS_write_1A_10P(0xA0, 0x84, 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x08, 0x1F, 0x0A, 0x1F);
	RM68191_DCS_write_1A_10P(0xA1, 0x1F, 0x1F, 0x1F, 0x1F, 0x0C, 0x1F, 0x0E, 0x1F, 0x1F, 0x1F);
	RM68191_DCS_write_1A_10P(0xA2, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x02, 0x1F, 0x06, 0x1F);
	RM68191_DCS_write_1A_10P(0xA3, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F);
	RM68191_DCS_write_1A_10P(0xA4, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x07, 0x1F, 0x03, 0x1F, 0x0F);
	RM68191_DCS_write_1A_10P(0xA5, 0x1F, 0x0D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x0B, 0x1F, 0x09);
	RM68191_DCS_write_1A_10P(0xA6, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x01, 0x05);
	RM68191_DCS_write_1A_10P(0xA7, 0x03, 0x07, 0x1F, 0x1F, 0x1F, 0x1F, 0x0B, 0x1F, 0x09, 0x1F);
	RM68191_DCS_write_1A_10P(0xA8, 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x1F, 0x0D, 0x1F, 0x1F, 0x1F);
	RM68191_DCS_write_1A_10P(0xA9, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x1F, 0x01, 0x1F);
	RM68191_DCS_write_1A_10P(0xAA, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F);
	RM68191_DCS_write_1A_10P(0xAB, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x1F, 0x04, 0x1F, 0x0C);
	RM68191_DCS_write_1A_10P(0xAC, 0x1F, 0x0E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x08, 0x1F, 0x0A);
	RM68191_DCS_write_1A_10P(0xAD, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x06, 0x02);
	RM68191_DCS_write_1A_5P(0xF0, 0x55, 0xAA, 0x52, 0x08, 0x02);
	RM68191_DCS_write_1A_1P(0xEA, 0x7D);
	RM68191_DCS_write_1A_5P(0xF0, 0x55, 0xAA, 0x52, 0x08, 0x00);
	RM68191_DCS_write_1A_3P(0xBC, 0x00, 0x00, 0x00);
	RM68191_DCS_write_1A_4P(0xB8, 0x01, 0xAF, 0x8F, 0x8F);
	RM68191_DCS_write_1A_5P(0xF0, 0x55, 0xAA, 0x52, 0x08, 0x01);
	RM68191_DCS_write_1A_16P(0xD1, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xD2, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xD3, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xD4, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_16P(0xD5, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xD6, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xD7, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xD8, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_16P(0xD9, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xDD, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xDE, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xDF, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_16P(0xE0, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xE1, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xE2, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xE3, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_16P(0xE4, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xE5, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xE6, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xE7, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_16P(0xE8, 0x00, 0x00, 0x00, 0x26, 0x00, 0x5E, 0x00, 0x88, 0x00, 0xA8, 0x00, 0xDB, 0x01, 0x02, 0x01, 0x3D);
	RM68191_DCS_write_1A_16P(0xE9, 0x01, 0x67, 0x01, 0xA6, 0x01, 0xD3, 0x02, 0x16, 0x02, 0x49, 0x02, 0x4B, 0x02, 0x7B, 0x02, 0xB3);
	RM68191_DCS_write_1A_16P(0xEA, 0x02, 0xD9, 0x03, 0x0E, 0x03, 0x31, 0x03, 0x61, 0x03, 0x80, 0x03, 0xA5, 0x03, 0xBD, 0x03, 0xD2);
	RM68191_DCS_write_1A_4P(0xEB, 0x03, 0xE5, 0x03, 0xFF);
	RM68191_DCS_write_1A_3P(0xB0, 0x07, 0x07, 0x07);
	RM68191_DCS_write_1A_3P(0xB1, 0x07, 0x07, 0x07);
	RM68191_DCS_write_1A_3P(0xB3, 0x11, 0x11, 0x11);
	RM68191_DCS_write_1A_3P(0xB4, 0x09, 0x09, 0x09);
	RM68191_DCS_write_1A_3P(0xB6, 0x44, 0x44, 0x44);
	RM68191_DCS_write_1A_3P(0xB7, 0x34, 0x34, 0x34);
	RM68191_DCS_write_1A_3P(0xB9, 0x34, 0x34, 0x34);
	RM68191_DCS_write_1A_3P(0xBA, 0x14, 0x14, 0x14);
	RM68191_DCS_write_1A_3P(0xBC, 0x00, 0x98, 0x00);
	RM68191_DCS_write_1A_3P(0xBD, 0x00, 0x98, 0x00);
	RM68191_DCS_write_1A_1P(0xBE, 0x1D);
	RM68191_DCS_write_1A_1P(0x35, 0x00);

	RM68191_DCS_write_1A_0P(0x11);
	mdelay(200);
	RM68191_DCS_write_1A_0P(0x29);
	mdelay(200);

	return 0;
}

static int mipid_bl_update_status(struct backlight_device *bl)
{
	return 0;
}

static int mipid_bl_get_brightness(struct backlight_device *bl)
{
	return 255;
}

static int mipi_bl_check_fb(struct backlight_device *bl, struct fb_info *fbi)
{
	return 0;
}

static const struct backlight_ops mipid_lcd_bl_ops = {
	.update_status = mipid_bl_update_status,
	.get_brightness = mipid_bl_get_brightness,
	.check_fb = mipi_bl_check_fb,
};
