/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _DT_BINDINGS_MICREL_KSZ9131_H
#define _DT_BINDINGS_MICREL_KSZ9131_H

/* LED modes for KSZ9131 embedded PHY */

/* LED MODE field is 4-bit length */
#define KSZ9131_LINK_ACTIVITY		0
#define KSZ9131_LINK1000_ACTIVITY	1
#define KSZ9131_LINK100_ACTIVITY	2
#define KSZ9131_LINK10_ACTIVITY		3
#define KSZ9131_LINK100_1000_ACTIVITY	4
#define KSZ9131_LINK10_1000_ACTIVITY	5
#define KSZ9131_LINK10_100_ACTIVITY	6
#define KSZ9131_DUPLEX_COLLISION	8
#define KSZ9131_COLLISION		9
#define KSZ9131_ACTIVITY		10
#define KSZ9131_AUTO_NEGOTIATION_FAULT	12
#define KSZ9131_FORCE_LED_OFF		14
#define KSZ9131_FORCE_LED_ON		15

/* Used only in software. Not written directly to register. Setting
 * 0x10 here disables activity and collision in led behaviour register.
 */
#define KSZ9131_COMBINATION_DISABLES(x)	(x | 0x10)
#define KSZ9131_LINK		KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK_ACTIVITY)
#define KSZ9131_LINK1000	KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK1000_ACTIVITY)
#define KSZ9131_LINK100		KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK100_ACTIVITY)
#define KSZ9131_LINK10		KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK10_ACTIVITY)
#define KSZ9131_LINK100_1000	KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK100_1000_ACTIVITY)
#define KSZ9131_LINK10_1000	KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK10_1000_ACTIVITY)
#define KSZ9131_LINK10_100	KSZ9131_COMBINATION_DISABLES(KSZ9131_LINK10_100_ACTIVITY)
#define KSZ9131_DUPLEX		KSZ9131_COMBINATION_DISABLES(KSZ9131_DUPLEX_COLLISION)

#endif
