/****************************************************************************
*
*    The MIT License (MIT)
*
*    Copyright (c) 2014 - 2020 Vivante Corporation
*
*    Permission is hereby granted, free of charge, to any person obtaining a
*    copy of this software and associated documentation files (the "Software"),
*    to deal in the Software without restriction, including without limitation
*    the rights to use, copy, modify, merge, publish, distribute, sublicense,
*    and/or sell copies of the Software, and to permit persons to whom the
*    Software is furnished to do so, subject to the following conditions:
*
*    The above copyright notice and this permission notice shall be included in
*    all copies or substantial portions of the Software.
*
*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
*    DEALINGS IN THE SOFTWARE.
*
*****************************************************************************
*
*    The GPL License (GPL)
*
*    Copyright (C) 2014 - 2020 Vivante Corporation
*
*    This program is free software; you can redistribute it and/or
*    modify it under the terms of the GNU General Public License
*    as published by the Free Software Foundation; either version 2
*    of the License, or (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software Foundation,
*    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*
*****************************************************************************
*
*    Note: This software is released under dual MIT and GPL licenses. A
*    recipient may use this file under the terms of either the MIT license or
*    GPL License. If you wish to use only one license not the other, you can
*    indicate your decision by deleting one of the above license notices in your
*    version of this file.
*
*****************************************************************************/


#ifndef __gc_hal_shared_enum_h_
#define __gc_hal_shared_enum_h_

#ifdef __cplusplus
extern "C" {
#endif

/* Chip models. */
typedef enum _gceCHIPMODEL
{
    gcv200  = 0x0200,
    gcv300  = 0x0300,
    gcv320  = 0x0320,
    gcv328  = 0x0328,
    gcv350  = 0x0350,
    gcv355  = 0x0355,
    gcv400  = 0x0400,
    gcv410  = 0x0410,
    gcv420  = 0x0420,
    gcv428  = 0x0428,
    gcv450  = 0x0450,
    gcv500  = 0x0500,
    gcv520  = 0x0520,
    gcv530  = 0x0530,
    gcv600  = 0x0600,
    gcv620  = 0x0620,
    gcv700  = 0x0700,
    gcv800  = 0x0800,
    gcv860  = 0x0860,
    gcv880  = 0x0880,
    gcv900  = 0x0900,
    gcv1000 = 0x1000,
    gcv1500 = 0x1500,
    gcv2000 = 0x2000,
    gcv2100 = 0x2100,
    gcv2200 = 0x2200,
    gcv2500 = 0x2500,
    gcv3000 = 0x3000,
    gcv4000 = 0x4000,
    gcv5000 = 0x5000,
    gcv5200 = 0x5200,
    gcv6400 = 0x6400,
    gcv7000 = 0x7000,
    gcv7400 = 0x7400,
    gcv8000 = 0x8000,
}
gceCHIPMODEL;

/* Chip features. */
typedef enum _gceFEATURE
{
    gcvFEATURE_PIPE_2D = 0,
    gcvFEATURE_PIPE_3D,
    gcvFEATURE_PIPE_VG,
    gcvFEATURE_DC,
    gcvFEATURE_HIGH_DYNAMIC_RANGE,
    gcvFEATURE_MODULE_CG,
    gcvFEATURE_MIN_AREA,
    gcvFEATURE_BUFFER_INTERLEAVING,
    gcvFEATURE_BYTE_WRITE_2D,
    gcvFEATURE_ENDIANNESS_CONFIG,
    gcvFEATURE_DUAL_RETURN_BUS,
    gcvFEATURE_DEBUG_MODE,
    gcvFEATURE_YUY2_RENDER_TARGET,
    gcvFEATURE_FRAGMENT_PROCESSOR,
    gcvFEATURE_2DPE20,
    gcvFEATURE_FAST_CLEAR,
    gcvFEATURE_YUV420_TILER,
    gcvFEATURE_YUY2_AVERAGING,
    gcvFEATURE_FLIP_Y,
    gcvFEATURE_EARLY_Z,
    gcvFEATURE_COMPRESSION,
    gcvFEATURE_MSAA,
    gcvFEATURE_SPECIAL_ANTI_ALIASING,
    gcvFEATURE_SPECIAL_MSAA_LOD,
    gcvFEATURE_422_TEXTURE_COMPRESSION,
    gcvFEATURE_DXT_TEXTURE_COMPRESSION,
    gcvFEATURE_ETC1_TEXTURE_COMPRESSION,
    gcvFEATURE_CORRECT_TEXTURE_CONVERTER,
    gcvFEATURE_TEXTURE_8K,
    gcvFEATURE_SCALER,
    gcvFEATURE_YUV420_SCALER,
    gcvFEATURE_SHADER_HAS_W,
    gcvFEATURE_SHADER_HAS_SIGN,
    gcvFEATURE_SHADER_HAS_FLOOR,
    gcvFEATURE_SHADER_HAS_CEIL,
    gcvFEATURE_SHADER_HAS_SQRT,
    gcvFEATURE_SHADER_HAS_TRIG,
    gcvFEATURE_HZ,
    gcvFEATURE_CORRECT_STENCIL,
    gcvFEATURE_VG20,
    gcvFEATURE_VG_FILTER,
    gcvFEATURE_VG21,
    gcvFEATURE_VG_DOUBLE_BUFFER,
    gcvFEATURE_VG_RESOLUTION_8K,
    gcvFEATURE_MC20,
    gcvFEATURE_SUPER_TILED,
    gcvFEATURE_FAST_CLEAR_FLUSH,
    gcvFEATURE_2D_FILTERBLIT_PLUS_ALPHABLEND,
    gcvFEATURE_2D_DITHER,
    gcvFEATURE_2D_A8_TARGET,
    gcvFEATURE_2D_A8_NO_ALPHA,
    gcvFEATURE_2D_FILTERBLIT_FULLROTATION,
    gcvFEATURE_2D_BITBLIT_FULLROTATION,
    gcvFEATURE_WIDE_LINE,
    gcvFEATURE_FC_FLUSH_STALL,
    gcvFEATURE_FULL_DIRECTFB,
    gcvFEATURE_HALF_FLOAT_PIPE,
    gcvFEATURE_LINE_LOOP,
    gcvFEATURE_2D_YUV_BLIT,
    gcvFEATURE_2D_TILING,
    gcvFEATURE_NON_POWER_OF_TWO,
    gcvFEATURE_3D_TEXTURE,
    gcvFEATURE_TEXTURE_ARRAY,
    gcvFEATURE_TILE_FILLER,
    gcvFEATURE_LOGIC_OP,
    gcvFEATURE_MIXED_STREAMS,
    gcvFEATURE_2D_MULTI_SOURCE_BLT,
    gcvFEATURE_END_EVENT,
    gcvFEATURE_VERTEX_10_10_10_2,
    gcvFEATURE_TEXTURE_10_10_10_2,
    gcvFEATURE_TEXTURE_ANISOTROPIC_FILTERING,
    gcvFEATURE_TEXTURE_FLOAT_HALF_FLOAT,
    gcvFEATURE_2D_ROTATION_STALL_FIX,
    gcvFEATURE_2D_MULTI_SOURCE_BLT_EX,
    gcvFEATURE_BUG_FIXES10,
    gcvFEATURE_2D_MINOR_TILING,
    gcvFEATURE_TEX_COMPRRESSION_SUPERTILED, /* Supertiled compressed textures are supported. */
    gcvFEATURE_FAST_MSAA,
    gcvFEATURE_BUG_FIXED_INDEXED_TRIANGLE_STRIP,
    gcvFEATURE_TEXTURE_TILE_STATUS_READ,
    gcvFEATURE_DEPTH_BIAS_FIX,
    gcvFEATURE_RECT_PRIMITIVE,
    gcvFEATURE_BUG_FIXES11,
    gcvFEATURE_SUPERTILED_TEXTURE,
    gcvFEATURE_2D_NO_COLORBRUSH_INDEX8,
    gcvFEATURE_RS_YUV_TARGET,
    gcvFEATURE_2D_FC_SOURCE, /* For tilestatus compression feature*/
    gcvFEATURE_2D_CC_NOAA_SOURCE,
    gcvFEATURE_PE_DITHER_FIX,
    gcvFEATURE_2D_YUV_SEPARATE_STRIDE,
    gcvFEATURE_FRUSTUM_CLIP_FIX,
    gcvFEATURE_TEXTURE_SWIZZLE,
    gcvFEATURE_PRIMITIVE_RESTART,
    gcvFEATURE_TEXTURE_LINEAR,
    gcvFEATURE_TEXTURE_YUV_ASSEMBLER,
    gcvFEATURE_LINEAR_RENDER_TARGET,
    gcvFEATURE_SHADER_HAS_ATOMIC,
    gcvFEATURE_SHADER_HAS_INSTRUCTION_CACHE,
    gcvFEATURE_SHADER_ENHANCEMENTS2,
    gcvFEATURE_BUG_FIXES7,
    gcvFEATURE_SHADER_HAS_RTNE,
    gcvFEATURE_SHADER_HAS_EXTRA_INSTRUCTIONS2,
    gcvFEATURE_SHADER_ENHANCEMENTS3,
    gcvFEATURE_DYNAMIC_FREQUENCY_SCALING,
    gcvFEATURE_SINGLE_BUFFER,
    gcvFEATURE_OCCLUSION_QUERY,
    gcvFEATURE_2D_GAMMA,
    gcvFEATURE_2D_COLOR_SPACE_CONVERSION,
    gcvFEATURE_2D_SUPER_TILE_VERSION,
    gcvFEATURE_HALTI0,
    gcvFEATURE_HALTI1,
    gcvFEATURE_HALTI2,
    gcvFEATURE_SUPPORT_GCREGTX,
    gcvFEATURE_2D_MIRROR_EXTENSION,
    gcvFEATURE_TEXTURE_ASTC,
    gcvFEATURE_TEXTURE_ASTC_DECODE_FIX,
    gcvFEATURE_TEXTURE_ASTC_BASE_LOD_FIX,
    gcvFEATURE_2D_SUPER_TILE_V1,
    gcvFEATURE_2D_SUPER_TILE_V2,
    gcvFEATURE_2D_SUPER_TILE_V3,
    gcvFEATURE_2D_MULTI_SOURCE_BLT_EX2,
    gcvFEATURE_NEW_RA,
    gcvFEATURE_BUG_FIXED_IMPLICIT_PRIMITIVE_RESTART,
    gcvFEATURE_PE_MULTI_RT_BLEND_ENABLE_CONTROL,
    gcvFEATURE_SMALL_MSAA, /* An upgraded version of Fast MSAA */
    gcvFEATURE_VERTEX_INST_ID_AS_ATTRIBUTE,
    gcvFEATURE_DUAL_16,
    gcvFEATURE_BRANCH_ON_IMMEDIATE_REG,
    gcvFEATURE_2D_COMPRESSION,
    gcvFEATURE_TPC_COMPRESSION,
    gcvFEATURE_TPCV11_COMPRESSION,
    gcvFEATURE_DEC_COMPRESSION,
    gcvFEATURE_DEC300_COMPRESSION,
    gcvFEATURE_DEC400_COMPRESSION,
    /*Its a new core for DEC400 compression*/
    gcvFEATURE_DEC400EX_COMPRESSION,
    gcvFEATURE_DEC_TPC_COMPRESSION,
    gcvFEATURE_DEC_COMPRESSION_TILE_NV12_8BIT,
    gcvFEATURE_DEC_COMPRESSION_TILE_NV12_10BIT,
    gcvFEATURE_2D_OPF_YUV_OUTPUT,
    gcvFEATURE_2D_FILTERBLIT_A8_ALPHA,
    gcvFEATURE_2D_MULTI_SRC_BLT_TO_UNIFIED_DST_RECT,
    gcvFEATURE_2D_MULTI_SRC_BLT_BILINEAR_FILTER,
    gcvFEATURE_2D_MULTI_SRC_BLT_1_5_ENHANCEMENT,
    gcvFEATURE_V2_COMPRESSION_Z16_FIX,
    gcvFEATURE_VERTEX_INST_ID_AS_INTEGER,
    gcvFEATURE_2D_YUV_MODE,
    gcvFEATURE_2D_CACHE_128B256BPERLINE,
    gcvFEATURE_2D_SEPARATE_CACHE,
    gcvFEATURE_2D_MAJOR_SUPER_TILE,
    gcvFEATURE_2D_V4COMPRESSION,
    gcvFEATURE_2D_VMSAA,
    gcvFEATURE_2D_10BIT_OUTPUT_LINEAR,
    gcvFEATURE_2D_YUV420_OUTPUT_LINEAR,
    gcvFEATURE_ACE,
    gcvFEATURE_COLOR_COMPRESSION,
    gcvFEATURE_32BPP_COMPONENT_TEXTURE_CHANNEL_SWIZZLE,
    gcvFEATURE_64BPP_HW_CLEAR_SUPPORT,
    gcvFEATURE_TX_LERP_PRECISION_FIX,
    gcvFEATURE_COMPRESSION_V2,
    gcvFEATURE_MMU,
    gcvFEATURE_COMPRESSION_V3,
    gcvFEATURE_TX_DECOMPRESSOR,
    gcvFEATURE_MRT_TILE_STATUS_BUFFER,
    gcvFEATURE_COMPRESSION_V1,
    gcvFEATURE_V1_COMPRESSION_Z16_DECOMPRESS_FIX,
    gcvFEATURE_RTT,
    gcvFEATURE_GENERIC_ATTRIB,
    gcvFEATURE_2D_ONE_PASS_FILTER,
    gcvFEATURE_2D_ONE_PASS_FILTER_TAP,
    gcvFEATURE_2D_POST_FLIP,
    gcvFEATURE_2D_PIXEL_ALIGNMENT,
    gcvFEATURE_CORRECT_AUTO_DISABLE_COUNT,
    gcvFEATURE_CORRECT_AUTO_DISABLE_COUNT_WIDTH,
    gcvFEATURE_8K_RT,
    gcvFEATURE_HALTI3,
    gcvFEATURE_EEZ,
    gcvFEATURE_INTEGER_SIGNEXT_FIX,
    gcvFEATURE_PSOUTPUT_MAPPING,
    gcvFEATURE_8K_RT_FIX,
    gcvFEATURE_TX_TILE_STATUS_MAPPING,
    gcvFEATURE_SRGB_RT_SUPPORT,
    gcvFEATURE_TEXTURE_16K,
    gcvFEATURE_PA_FARZCLIPPING_FIX,
    gcvFEATURE_PE_DITHER_COLORMASK_FIX,
    gcvFEATURE_ZSCALE_FIX,
    gcvFEATURE_MULTI_PIXELPIPES,
    gcvFEATURE_PIPE_CL,
    gcvFEATURE_BUG_FIXES18,
    gcvFEATURE_UNIFIED_SAMPLERS,
    gcvFEATURE_CL_PS_WALKER,
    gcvFEATURE_NEW_HZ,
    gcvFEATURE_TX_FRAC_PRECISION_6BIT,
    gcvFEATURE_SH_INSTRUCTION_PREFETCH,
    gcvFEATURE_PROBE,
    gcvFEATURE_SINGLE_PIPE_HALTI1,
    gcvFEATURE_BUG_FIXES8, /* This HW feature is wrong, we can't use this to check integer branch!!!*/
    gcvFEATURE_2D_ALL_QUAD,
    gcvFEATURE_SEPARATE_SRC_DST,
    gcvFEATURE_TX_HOR_ALIGN_SEL,
    gcvFEATURE_HALTI4,
    gcvFEATURE_MRT_FC_FIX,
    gcvFEATURE_TESSELLATION,
    gcvFEATURE_DRAW_INDIRECT,
    gcvFEATURE_COMPUTE_INDIRECT,
    gcvFEATURE_MSAA_TEXTURE,
    gcvFEATURE_STENCIL_TEXTURE,
    gcvFEATURE_S8_ONLY_RENDERING,
    gcvFEATURE_D24S8_SAMPLE_STENCIL,
    gcvFEATURE_ADVANCED_BLEND_MODE_PART0,
    gcvFEATURE_RA_DEPTH_WRITE,
    gcvFEATURE_RS_DS_DOWNSAMPLE_NATIVE_SUPPORT,
    gcvFEATURE_S8_MSAA_COMPRESSION,
    gcvFEATURE_MSAA_FRAGMENT_OPERATION,
    gcvFEATURE_FE_START_VERTEX_SUPPORT,
    gcvFEATURE_DIVISOR_STREAM_ADDR_FIX,
    gcvFEATURE_ZERO_ATTRIB_SUPPORT,
    gcvFEATURE_DANGLING_VERTEX_FIX,
    gcvFEATURE_PE_DISABLE_COLOR_PIPE,
    gcvFEATURE_FE_12bit_stride,
    gcvFEATURE_TX_LOD_GUARDBAND,
    gcvFEATURE_HAS_PRODUCTID,
    gcvFEATURE_INTEGER32_FIX,
    gcvFEATURE_TEXTURE_GATHER,
    gcvFEATURE_IMG_INSTRUCTION,
    gcvFEATURE_HELPER_INVOCATION,
    gcvFEATURE_NO_USER_CSC,
    gcvFEATURE_ANDROID_ONLY,
    gcvFEATURE_V2_MSAA_COHERENCY_FIX,
    gcvFEATURE_BLOCK_SIZE_16x16,
    gcvFEATURE_TX_SUPPORT_DEC,
    gcvFEATURE_RSBLT_MSAA_DECOMPRESSION,
    gcvFEATURE_TILEFILLER_32TILE_ALIGNED,
    gcvFEATURE_GEOMETRY_SHADER,
    gcvFEATURE_HALTI5,
    gcvFEATURE_PIPELINE_32_ATTRIBUTES,
    gcvFEATURE_USC,
    gcvFEATURE_CUBEMAP_ARRAY,
    gcvFEATURE_TX_DESCRIPTOR,
    gcvFEATURE_SEPARATE_RT_CTRL,
    gcvFEATURE_RENDER_ARRAY,
    gcvFEATURE_BLT_ENGINE,
    gcvFEATURE_TEXTURE_BUFFER,
    gcvFEATURE_GS_SUPPORT_EMIT,
    gcvFEATURE_SAMPLER_BASE_OFFSET,
    gcvFEATURE_IMAGE_OUT_BOUNDARY_FIX,
    gcvFEATURE_TX_BORDER_CLAMP,
    gcvFEATURE_MSAA_SHADING,
    gcvFEATURE_ADVANCED_SH_INST,
    gcvFEATURE_LOD_FIX_FOR_BASELEVEL,
    gcvFEATURE_MULTIDRAW_INDIRECT,
    gcvFEATURE_DRAW_ELEMENTS_BASE_VERTEX,
    gcvFEATURE_NEW_STEERING_AND_ICACHE_FLUSH, /* Steering base on register base. Trigger-style Icache flush state. */
    gcvFEATURE_PE_DITHER_FIX2,
    gcvFEATURE_INDEX_FETCH_FIX,
    gcvFEATURE_TEX_BASELOD,
    gcvFEATURE_TEX_SEAMLESS_CUBE,
    gcvFEATURE_TEX_ETC2,
    gcvFEATURE_TEX_CUBE_BORDER_LOD,
    gcvFEATURE_FE_ALLOW_STALL_PREFETCH_ENG,
    gcvFEATURE_TX_8BPP_TS_FIX,
    gcvFEATURE_HW_TFB,
    gcvFEATURE_COMPRESSION_V4,
    gcvFEATURE_FENCE_32BIT,
    gcvFEATURE_FENCE_64BIT,
    gcvFEATURE_R8_UNORM,
    gcvFEATURE_TX_DEFAULT_VALUE_FIX,
    gcvFEATURE_TX_8bit_UVFrac,
    gcvFEATURE_TX_MIPFILTER_NONE_FIX,
    gcvFEATURE_MC_STENCIL_CTRL,
    gcvFEATURE_DEPTH_MATH_FIX,
    gcvFEATURE_PE_B2B_PIXEL_FIX,
    gcvFEATURE_TEXTURE_GATHER_OFFSETS,
    gcvFEATURE_TEX_CACHE_FLUSH_FIX,
    gcvFEATURE_WIDELINE_HELPER_FIX,
    gcvFEATURE_LINE_DIAMOND_RULE_FIX,
    gcvFEATURE_MULTIGPU_SYNC_V2,
    gcvFEATURE_DRAW_ID,
    gcvFEATURE_SNAPPAGE_CMD,
    gcvFEATURE_COMMAND_PREFETCH,
    gcvFEATURE_SAMPLEPOS_SWIZZLE_FIX,
    gcvFEATURE_SELECTMAP_SRC0_SWIZZLE_FIX,
    gcvFEATURE_LOADATTR_OOB_FIX,
    gcvFEATURE_RA_DEPTH_WRITE_MSAA1X_FIX,
    gcvFEATURE_MRT_8BIT_DUAL_PIPE_FIX,
    gcvFEATURE_BUG_FIXES1,
    gcvFEATURE_MULTI_SOURCE_BLT,
    gcvFEATURE_ZCOMPRESSION,
    gcvFEATURE_DITHER_AND_FILTER_PLUS_ALPHA_2D,
    gcvFEATURE_ONE_PASS_2D_FILTER,
    gcvFEATURE_TX_FILTER,
    gcvFEATURE_CHIPENABLE_LINK,
    gcvFEATURE_TEXTURE_BIAS_LOD_FIX,
    gcvFEATURE_USE_GL_Z,
    gcvFEATURE_SUPPORT_INTEGER,
    /* PARTLY_SUPPORT_INTEGER_BRANCH:
    **      chips can support all integer types for compare instructions, e.g, CMP, SELECT.
    ** FULLLY_SUPPORT_INTEGER_BRANCH:
    **      chips can support all integer types for JMP instruction.
    ** If PARTLY_SUPPORT_INTEGER_BRANCH is TRUE but FULLLY_SUPPORT_INTEGER_BRANCH is FALSE,
    ** then this chip can only support INT32/UINT32 JMP instruction.
    */
    gcvFEATURE_PARTLY_SUPPORT_INTEGER_BRANCH,
    gcvFEATURE_FULLLY_SUPPORT_INTEGER_BRANCH,
    gcvFEATURE_SUPPORT_INTEGER_ATTRIBUTE,
    gcvFEATURE_SUPPORT_MOVAI,
    gcvFEATURE_NEED_FIX_FOR_CL_X,
    gcvFEATURE_NEED_FIX_FOR_CL_XE,
    gcvFEATURE_HAS_OUTPUT_COUNT_FIX,
    gcvFEATURE_VARYING_PACKING_LIMITATION,
    gcvFEATURE_HIGHP_VARYING_SHIFT,
    gcvFEATURE_BUG_FIXES2,
    gcvFEATURE_64K_L2_CACHE,
    gcvFEATURE_128BTILE,
    gcvFEATURE_ADVANCED_BLEND_OPT,
    gcvFEATURE_SNAPPAGE_CMD_FIX,
    gcvFEATURE_L2_CACHE_FOR_2D_420,
    gcvFEATURE_TILE_STATUS_2BITS,
    gcvFEATURE_EXTRA_SHADER_INSTRUCTIONS0,
    gcvFEATURE_EXTRA_SHADER_INSTRUCTIONS1,
    gcvFEATURE_EXTRA_SHADER_INSTRUCTIONS2,
    gcvFEATURE_MEDIUM_PRECISION,
    gcvFEATURE_FE20_BIT_INDEX,
    gcvFEATURE_BUG_FIXES4,
    gcvFEATURE_BUG_FIXES12,
    gcvFEATURE_VMSAA,
    gcvFEATURE_ROBUST_ATOMIC,
    gcvFEATURE_32F_COLORMASK_FIX,
    gcvFEATURE_NEW_GPIPE,
    gcvFEATURE_RS_NEW_BASEADDR,
    gcvFEATURE_TX_DXT,
    gcvFEATURE_SH_FLAT_INTERPOLATION_DUAL16_FIX,
    gcvFEATURE_EVIS,
    gcvFEATURE_SH_SUPPORT_V4,
    gcvFEATURE_SH_SUPPORT_ALPHA_KILL,
    gcvFEATURE_PE_NO_ALPHA_TEST,
    gcvFEATURE_SH_SNAP2PAGE_MAXPAGES_FIX,
    gcvFEATURE_USC_FULLCACHE_FIX,
    gcvFEATURE_PE_64bit_FENCE_FIX,
    gcvFEATURE_BLT_8bit_256TILE_FC_FIX,
    gcvFEATURE_PE_RGBA16I_FIX,
    gcvFEATURE_BLT_64bpp_MASKED_CLEAR_FIX,
    gcvFEATURE_SH_PSO_MSAA1x_FIX,
    gcvFEATURE_USC_ATOMIC_FIX,
    gcvFEATURE_INDEX_CONST_ON_B0,
    gcvFEATURE_SH_NO_ONECONST_LIMIT,
    gcvFEATURE_EVIS_NO_ABSDIFF,
    gcvFEATURE_EVIS_NO_BITREPLACE,
    gcvFEATURE_EVIS_NO_BOXFILTER,
    gcvFEATURE_EVIS_NO_CORDIAC,
    gcvFEATURE_EVIS_NO_DP32,
    gcvFEATURE_EVIS_NO_FILTER,
    gcvFEATURE_EVIS_NO_IADD,
    gcvFEATURE_EVIS_NO_SELECTADD,
    gcvFEATURE_EVIS_LERP_7OUTPUT,
    gcvFEATURE_EVIS_ACCSQ_8OUTPUT,
    gcvFEATURE_ROBUSTNESS,
    gcvFEATURE_SECURITY,
    gcvFEATURE_TX_YUV_ASSEMBLER_10BIT,
    gcvFEATURE_USC_GOS_ADDR_FIX,
    gcvFEATURE_SUPPORT_MSAA2X,
    gcvFEATURE_TX_DESC_CACHE_CLOCKGATE_FIX,
    gcvFEATURE_TX_INTEGER_COORDINATE,
    gcvFEATURE_PSIO_SAMPLEMASK_IN_R0ZW_FIX,
    gcvFEATURE_MULTI_CORE_BLOCK_SET_CONFIG,
    gcvFEATURE_SH_IMG_LDST_ON_TEMP,
    gcvFEATURE_TX_INTEGER_COORDINATE_V2,
    gcvFEATURE_COMPUTE_ONLY,
    gcvFEATURE_SH_IMG_LDST_CLAMP,
    gcvFEATURE_SH_ICACHE_ALLOC_COUNT_FIX,
    gcvFEATURE_MSAA_OQ_FIX,
    gcvFEATURE_PE_ENHANCEMENTS2,
    gcvFEATURE_PSIO_MSAA_CL_FIX,
    gcvFEATURE_FE_NEED_DUMMYDRAW,
    gcvFEATURE_MULTI_CLUSTER,
    gcvFEATURE_PSIO_INTERLOCK,
    gcvFEATURE_BLIT_COMPRESS_DEST,
    gcvFEATURE_SH_MULTI_WG_PACK,
    gcvFEATURE_FE_ROBUST_FIX,
    gcvFEATURE_TX_ASTC_MULTISLICE_FIX,
    gcvFEATURE_PSIO_DUAL16_32bpc_FIX,
    gcvFEATURE_LS_SUPPORT_PER_COMP_DEPENDENCY,
    gcvFEATURE_COMPRESSION_DEC400,
    gcvFEATURE_SH_TEXLD_U_FIX,
    gcvFEATURE_TX_FLUSH_L1CACHE,
    gcvFEATURE_USC_DEFER_FILL_FIX,
    gcvFEATURE_MC_FCCACHE_BYTEMASK,
    gcvFEATURE_SH_MULTI_WG_PACK_FIX,
    gcvFEATURE_FE_PATCHLIST_FETCH_FIX,
    gcvFEATURE_RA_CG_FIX,
    gcvFEATURE_EVIS_VX2,
    gcvFEATURE_SH_HALF_DEPENDENCY_FIX,
    gcvFEATURE_FE_BASEINSTANCE,
    gcvFEATURE_FE_COMPUREINDIRECT_SKIP_UNIFORM,
    gcvFEATURE_SH_CLOCK_GATE_FIX,
    gcvFEATURE_GPIPE_CLOCK_GATE_FIX,
    gcvFEATURE_TP_ENGINE,
    gcvFEATURE_TX_BORDER_CLAMP_FIX,
    gcvFEATURE_SH_IMAGE_LD_LAST_PIXEL_FIX,
    gcvFEATURE_MULTI_CORE_BLOCK_SET_CONFIG2,
    gcvFEATURE_MULTIGPU_SYNC_V3,
    gcvFEATURE_PE_VMSAA_COVERAGE_CACHE_FIX,
    gcvFEATURE_SECURITY_AHB,
    gcvFEATURE_TX_LERP_LESS_BIT,
    gcvFEATURE_SMALL_BATCH,
    gcvFEATURE_SH_IDIV0_SWZL_EHS,
    gcvFEATURE_SH_CMPLX,
    gcvFEATURE_VIP_V7,
    gcvFEATURE_SH_GM_ENDIAN,
    gcvFEATURE_SH_GM_USC_UNALLOC,
    gcvFEATURE_SH_END_OF_BB,
    gcvFEATURE_ASYNC_BLIT,
    gcvFEATURE_ASYNC_FE_FENCE_FIX,
    gcvFEATURE_PSCS_THROTTLE,
    gcvFEATURE_SEPARATE_LS,
    gcvFEATURE_PA_VARYING_COMPONENT_TOGGLE_FIX,
    gcvFEATURE_TX_MULTISAMPLER_FC_FIX,
    gcvFEATURE_WIDELINE_TRIANGLE_EMU,
    gcvFEATURE_FENCE,
    gcvFEATURE_MCFE,
    gcvFEATURE_NN_INTERLEAVE8,
    gcvFEATURE_TP_REORDER,
    gcvFEATURE_TP_RTNE,
    gcvFEATURE_TP_LRN,
    gcvFEATURE_TP_ROI_POOLING,
    gcvFEATURE_TP_MAX_POOLING_STRIDE1,
    gcvFEATURE_NN_BRICK_MODE,
    gcvFEATURE_NN_BORDER_MODE,
    gcvFEATURE_NN_FP16_ALU,
    gcvFEATURE_NN_BF16_ALU,
    gcvFEATURE_NN_INT16_ALU,
    gcvFEATURE_NN_ZDP3,
    gcvFEATURE_NN_ZDP6,
    gcvFEATURE_PE_DEPTH_ONLY_OQFIX,
    gcvFEATURE_TX_SNORM_SUPPORT,
    gcvFEATURE_HWMANAGED_LS,
    gcvFEATURE_SH_SCATTER_GATHER,
    gcvFEATURE_NN_POWER_ISOLATION,
    gcvFEATURE_SWTILING_PHASE1,
    gcvFEATURE_SWTILING_PHASE2,
    gcvFEATURE_SWTILING_PHASE3,
    gcvFEATURE_TF_QUANTIZATION,
    gcvFEATURE_NN_XYDP9,
    gcvFEATURE_TP_SIMPLE_INT16,
    gcvFEATURE_TP_REAL_INT16,
    gcvFEATURE_NN_FIRST_PIXEL_POOLING,
    gcvFEATURE_NN_STRIDE_SUPPORT,
    gcvFEATURE_NN_XYDP6,
    gcvFEATURE_NN_XYDP0,
    gcvFEATURE_TP_REORDER_FIX,
    gcvFEATURE_NN_CONV1x1_PERF_FIX,
    gcvFEATURE_NN_CACHELINE_MODE_PERF_FIX,
    gcvFEATURE_NN_PER3DTILE_BUBBLE_FIX,
    gcvFEATURE_SH_IO_CG_FIX,
    gcvFEATURE_USC_STAY_LRU,
    gcvFEATURE_NN_NONZERO_MIRROR_BORDER,
    gcvFEATURE_NN_COEF_DECOMPRESS_PERF2X,
    gcvFEATURE_4BIT_INPUT,
    gcvFEATURE_COEF_COMPRESSION_ENHANCEMENT,
    gcvFEATURE_NN_ZDP3_NO_COMPRESS_FIX,
    gcvFEATURE_NN_ASYNC_COPY_PERF_FIX,
    gcvFEATURE_OCB_COUNTER,
    gcvFEATURE_NN_ZXDP3_KERNEL_READ_CONFLICT_FIX,
    gcvFEATURE_NN_FULLCACHE_KERNEL_INTERLEAVE_FIX,
    gcvFEATURE_DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX,
    gcvFEATURE_USC_BOTTLENECK_FIX,
    gcvFEATURE_OCB_REMAP_PHYSICAL_ADDRESS,
    gcFEATURE_BIT_NN_HW_LIMITATION_NATIVE_KER_1x2_2x1,
    gcvFEATURE_NN_SLICE_PADDING_TO_64BYTE_ALIGN,
    gcvFEATURE_NN_DW_1x1_CONV_MERGE,
    gcvFEATURE_TP_REORDER_LAYER_SUSPEND_FIX,
    gcvFEATURE_KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX,
    gcvFEATURE_IMG_POP_PIPELINE_PAUSE_FIX,
    gcvFEATURE_NN_SLOW_OUTPUT,
    gcvFEATURE_NO_NARROW_POST_PROCESS_PIPE,
    gcvFEATURE_TP_NN_PROBE,
    gcvFEATURE_TP_23BITS_POST_MULTIPLIER,
    gcvFEATURE_NN_TRANSPOSE,
    gcvFEATURE_OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX,
    gcvFEATURE_TP_BFLOAT16,
    gcvFEATURE_EVIS2_FLOP_RESET_FIX,
    gcvFEATURE_USC_ASYNC_CP_RTN_FLOP_RESET_FIX,
    gcvFEATURE_USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX,
    gcvFEATURE_NEGATIVE_POST_SHIFT_FIX,
    gcvFEATURE_NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX,
    gcvFEATURE_NN_LEAKY_RELU,
    gcvFEATURE_NN_PRELU,
    gcvFEATURE_NN_NATIVE_STRIDE_TWO,
    gcvFEATURE_NN_TENSOR_ADD,

    gcvFEATURE_IMAGE_LS_NO_FULLMASK_FIX,
    gcvFEATURE_BLT_YUV_OUTPUT,
    gcvFEATURE_PE_TILE_CACHE_FLUSH_FIX,
    gcvFEATURE_SH_ROBUSTNESS_FIX,
    gcvFEATURE_USC_ATOMIC_FIX2,
    gcvFEATURE_MULTIVIEW_RENDER,
    gcvFEATURE_FE_DRAW_DIRECT,
    gcvFEATURE_TX_VKBORDER_MODE,
    gcvFEATURE_TX_UNNORMALIZED_COORD,
    gcvFEATURE_VG_IMAGE_16K,
    gcvFEATURE_MULTICORE_CONFIG,
    gcvFEATURE_PA_LINECLIP_FIX,
    gcvFEATURE_NN_ENGINE,
    gcvFEATURE_NN_ASYNC_COPY_MERGE_FIX,
    gcvFEATURE_NN_CONVOUT_FIFO_DEPTH_FIX,
    gcvFEATURE_NN_SMALLBATCH_PHASE1,
    gcvFEATURE_TP_SMALLBATCH_PHASE1,
    gcvFEATURE_VIP_SCALER,
    gcvFEATURE_VIP_SCALER_4K,
    gcvFEATURE_TX_8bit_UVFrac_ROUNDING_FIX,
    gcvFEATURE_NN_REQ_SLOWARBITRATION_FIX,
    gcvFEATUER_IMAGE_PARTIAL_CACHE,
    gcvFEATURE_FULLCACHE_KERNELHEAD_FIX,
    gcvFEATURE_NN_SINGLEPORT_ACCUMBUFFER,
    gcvFEATURE_NN_SMALLBATCH,
    gcvFEATURE_TP_SMALLBATCH,
    gcvFEATURE_NN_ZDP_INIMAGE_SIZE_FIX,
    gcvFEATURE_HI_REORDER_FIX,
    gcvFEATURE_TP_COEF_COMPRESSION_ENHANCEMENT,
    gcvFEATURE_NN_DEPTHWISE_SUPPORT,
    gcvFEATURE_IMAGE_NOT_PACKED_IN_SRAM_FIX,
    gcvFEATURE_IDLE_BEFORE_FLUSH_COMPLETE_FIX,
    gcvFEATURE_NO_FLUSH_USC_FIX,
    gcvFEATURE_COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX,
    gcvFEATURE_XY_OFFSET_LIMITATION_FIX,
    gcvFEATURE_USC_INVALIDATE_CACHE_LINE_FIX,
    gcvFEATURE_LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX,
    gcvFEATURE_KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX,
    gcvFEATURE_NN_PER_CHANNEL_QUANT,
    gcvFEATURE_NN_NO_Z_LOCATION_OFFSET,
    gcvFEATURE_NN_KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX,
    gcvFEATURE_INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX,
    gcvFEATURE_VIP_DEC400,
    gcvFEATURE_MAX_POINTSIZE_CLAMP,
    gcvFEATURE_2D_FAST_CLEAR, /* For tilestatus Fast Clear feature*/
    gcvFEATURE_NN_PER_CHANNEL_QUANT_ASYM,
    gcvFEATURE_SMALL_BATCH_FLOPS_RESET_FIX,
    gcvFEATURE_SMALL_BATCH_DISBLE_FIX,
    gcvFEATURE_FORMAT_10BIT_CROSS_4K,
    gcvFEATURE_ENDIAN_CONTROL,
    gcvFEATURE_SH_VX2_FLOATING_MAD_FIX,
    gcvFEATURE_PE_A8B8G8R8, /* For PE support A8B8G8R8 format feature*/
    gcvFEATURE_DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX,

    /* AIGPU feature. */
    gcvFEATURE_AI_GPU,
    gcvFEATURE_NN_FAST_FIRST_PIXEL_POOLING,
    gcvFEATURE_NN_FLOAT_POST_MULT,
    gcvFEATURE_NN_ASYMMETRIC_INT8,

    gcvFEATURE_FORMAT_YUV_I010, /*support YUVI010 & P010_LSB format*/

    gcFEATURE_BIT_NN_COMPRESSION_BYPASSS,
    gcFEATURE_BIT_BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE,
    gcFEATURE_BIT_TP_KERNEL_1BYTE_ALGIN,
    gcFEATURE_PREPROCESS_IMG_BUF_640BYTE_LIMIT,
    gcFEATURE_BIT_TPLITE_BFLOAT16,
    gcvFEATURE_VIP_HW_FINAL_RELEASE,
    gcvFEATURE_OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX,
    gcvFEATURE_IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX, /* 2089 */
    gcFEATURE_BIT_V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX, /* 2043 */
    gcFEATURE_BIT_BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX, /* 2111 */
    gcFEATURE_BIT_TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX, /* 2050 */


    gcFEATURE_BIT_USE_SINGLE_PORT_VIPSRAM,
    gcFEATURE_VALUE_DDR_KERNEL_BURST_SIZE,
    gcFEATURE_BIT_TILE_ACCESS_CAPABILITY,
    gcFEATURE_BIT_FAST_DP3_PREPROCESSOR,

    gcvFEATURE_BIT_INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX, /* 2112 */
    gcFEATURE_BIT_DEPTHWISE_16BIT_FORMAT,

    gcvFEATURE_2D_TILESTATUS_ROTATION,/*Fix fastclear feature with rotation*/
    gcFEATURE_BIT_TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX,
    gcvFEATURE_TS_FC_VULKAN_SUPPORT,
    gcFEATURE_BIT_V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX, /* 2044 */
    gcFEATURE_BIT_MAX_TILE_SIZE,
    gcvFEATURE_2D_TARGET_MAJOR_SUPER_TILE, /*target support supertile Y major*/
    gcFEATURE_BIT_INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX,
    gcFEATURE_BIT_NN_IN_TILE_DATA_IS_ALL_PAD_FIX, /* 2131 */

    /* TP reorder the int tile x should be less than 512 */
    gcFEATURE_TP_REORDER_INTILE_X_SIZE_512_FIX,
    gcFEATURE_NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX,
    gcFEATURE_BIT_BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE,
    gcvFEATURE_NN_FLOAT32_IO,
    gcvFEATURE_TP_FLOAT32_IO,

    gcvFEATURE_BIT_USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX,
    gcvFEATURE_BIT_NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX,

    gcvFEATURE_IMGLD_WIDTH_LT16_FIX,

    gcFEATURE_BIT_IMGLD_COMP_COUNT_FIX,
    /* Insert features above this comment only. */
    gcvFEATURE_COUNT                /* Not a feature. */
}
gceFEATURE;

/* Chip Power Status. */
typedef enum _gceCHIPPOWERSTATE
{
    gcvPOWER_INVALID = -1,

    /* Global/base states. */
    gcvPOWER_ON = 0,
    gcvPOWER_IDLE,
    gcvPOWER_SUSPEND,
    gcvPOWER_OFF,

    /* Power on but not global or broadcast. */
    gcvPOWER_ON_AUTO,

    /* Broadcast states. */
    gcvPOWER_FLAG_BROADCAST    = 0x10,
    gcvPOWER_IDLE_BROADCAST    = gcvPOWER_IDLE    | gcvPOWER_FLAG_BROADCAST,
    gcvPOWER_SUSPEND_BROADCAST = gcvPOWER_SUSPEND | gcvPOWER_FLAG_BROADCAST,
    gcvPOWER_OFF_BROADCAST     = gcvPOWER_OFF     | gcvPOWER_FLAG_BROADCAST,


    /* Timeout states. */
    gcvPOWER_FLAG_TIMEOUT      = 0x20,
    gcvPOWER_IDLE_TIMEOUT      = gcvPOWER_IDLE    | gcvPOWER_FLAG_TIMEOUT,
    gcvPOWER_SUSPEND_TIMEOUT   = gcvPOWER_SUSPEND | gcvPOWER_FLAG_TIMEOUT,
    gcvPOWER_OFF_TIMEOUT       = gcvPOWER_OFF     | gcvPOWER_FLAG_TIMEOUT,

}
gceCHIPPOWERSTATE;

/* CPU cache operations */
typedef enum _gceCACHEOPERATION
{
    gcvCACHE_CLEAN      = 0x01, /* Flush CPU cache to mem */
    gcvCACHE_INVALIDATE = 0x02, /* Invalidte CPU cache */
    gcvCACHE_FLUSH      = gcvCACHE_CLEAN  | gcvCACHE_INVALIDATE, /* Both flush & invalidate */
    gcvCACHE_MEMORY_BARRIER = 0x04
}
gceCACHEOPERATION;

/* Surface types. */
typedef enum _gceSURF_TYPE
{
    gcvSURF_TYPE_UNKNOWN = 0,
    gcvSURF_INDEX,
    gcvSURF_VERTEX,
    gcvSURF_TEXTURE,
    gcvSURF_RENDER_TARGET,
    gcvSURF_DEPTH,
    gcvSURF_BITMAP,
    gcvSURF_TILE_STATUS,
    gcvSURF_IMAGE,
    gcvSURF_MASK,
    gcvSURF_SCISSOR,
    gcvSURF_HIERARCHICAL_DEPTH,
    gcvSURF_ICACHE,
    gcvSURF_TXDESC,
    gcvSURF_FENCE,
    gcvSURF_TFBHEADER,
    gcvSURF_NUM_TYPES, /* Make sure this is the last one! */

    /* Combinations. */
    gcvSURF_CMA_LIMIT               = 0x80000000,
    gcvSURF_NO_TILE_STATUS          = 0x100,
    gcvSURF_NO_VIDMEM               = 0x200, /* Used to allocate surfaces with no underlying vidmem node.
                                                   In Android, vidmem node is allocated by another process. */
    gcvSURF_CACHEABLE               = 0x400, /* Used to allocate a cacheable surface */
    gcvSURF_TILE_RLV_FENCE          = 0x800, /* create texture fence as tile */
    gcvSURF_TILE_STATUS_DIRTY       = 0x1000, /* Init tile status to all dirty */
    gcvSURF_LINEAR                  = 0x2000,
    gcvSURF_CREATE_AS_TEXTURE       = 0x4000, /* create it as a texture */
    gcvSURF_PROTECTED_CONTENT       = 0x8000, /* create it as content protected */
    gcvSURF_CREATE_AS_DISPLAYBUFFER = 0x10000, /*create it as a display buffer surface */
    gcvSURF_CONTIGUOUS              = 0x20000, /*create it as contiguous */
    gcvSURF_NO_COMPRESSION          = 0x40000, /* Create it as no compression, valid on when it has tile status. */
    gcvSURF_DEC                     = 0x80000, /* Surface is DEC compressed */
    gcvSURF_NO_HZ                   = 0x100000,
    gcvSURF_3D                      = 0x200000, /* It's 3d surface */
    gcvSURF_DMABUF_EXPORTABLE       = 0x400000, /* master node can be exported as dma-buf fd */
    gcvSURF_CACHE_MODE_128          = 0x800000,
    gcvSURF_TILED                   = 0x1000000, /* force create tile buffer, as we will convert it to supertile according to related hardware feature by default */

    gcvSURF_TEXTURE_LINEAR               = gcvSURF_TEXTURE
                                         | gcvSURF_LINEAR,

    gcvSURF_RENDER_TARGET_LINEAR         = gcvSURF_RENDER_TARGET
                                         | gcvSURF_LINEAR,

    gcvSURF_RENDER_TARGET_NO_TILE_STATUS = gcvSURF_RENDER_TARGET
                                         | gcvSURF_NO_TILE_STATUS,

    gcvSURF_RENDER_TARGET_NO_COMPRESSION = gcvSURF_RENDER_TARGET
                                         | gcvSURF_NO_COMPRESSION,

    gcvSURF_RENDER_TARGET_TS_DIRTY       = gcvSURF_RENDER_TARGET
                                         | gcvSURF_TILE_STATUS_DIRTY,

    gcvSURF_DEPTH_NO_TILE_STATUS         = gcvSURF_DEPTH
                                         | gcvSURF_NO_TILE_STATUS,

    gcvSURF_DEPTH_TS_DIRTY               = gcvSURF_DEPTH
                                         | gcvSURF_TILE_STATUS_DIRTY,

    /* Supported surface types with no vidmem node. */
    gcvSURF_BITMAP_NO_VIDMEM             = gcvSURF_BITMAP
                                         | gcvSURF_NO_VIDMEM,

    gcvSURF_TEXTURE_NO_VIDMEM            = gcvSURF_TEXTURE
                                         | gcvSURF_NO_VIDMEM,

    /* Cacheable surface types with no vidmem node. */
    gcvSURF_CACHEABLE_BITMAP_NO_VIDMEM   = gcvSURF_BITMAP_NO_VIDMEM
                                         | gcvSURF_CACHEABLE,

    gcvSURF_CACHEABLE_BITMAP             = gcvSURF_BITMAP
                                         | gcvSURF_CACHEABLE,

    gcvSURF_TEXTURE_3D                  = gcvSURF_TEXTURE
                                         | gcvSURF_3D
}
gceSURF_TYPE;

/* Surface formats.
** Name rules is from MSB->LSB.
*/
typedef enum _gceSURF_FORMAT
{
    /* Unknown format. */
    gcvSURF_UNKNOWN             = 0,

    /* Palettized formats. */
    gcvSURF_INDEX1              = 100,
    gcvSURF_INDEX4,
    gcvSURF_INDEX8,
#if gcdVG_ONLY
    gcvSURF_INDEX2,
#endif

    /* RGB formats. */
    gcvSURF_A2R2G2B2            = 200,
    gcvSURF_R3G3B2,
    gcvSURF_A8R3G3B2,
    gcvSURF_X4R4G4B4,
    gcvSURF_A4R4G4B4,
    gcvSURF_R4G4B4A4,
    gcvSURF_X1R5G5B5,
    gcvSURF_A1R5G5B5,
    gcvSURF_R5G5B5A1,
    gcvSURF_R5G6B5,
    gcvSURF_R8G8B8,
    gcvSURF_X8R8G8B8,
    gcvSURF_A8R8G8B8,
    gcvSURF_R8G8B8A8,
    gcvSURF_G8R8G8B8,
    gcvSURF_R8G8B8G8,
    gcvSURF_X2R10G10B10,
    gcvSURF_A2R10G10B10,
    gcvSURF_R10G10B10A2,
    gcvSURF_X12R12G12B12,
    gcvSURF_A12R12G12B12,
    gcvSURF_X16R16G16B16,
    gcvSURF_A16R16G16B16,
    gcvSURF_A32R32G32B32,
    gcvSURF_R8G8B8X8,
    gcvSURF_R5G5B5X1,
    gcvSURF_R4G4B4X4,
    gcvSURF_X16R16G16B16_2_A8R8G8B8,
    gcvSURF_A16R16G16B16_2_A8R8G8B8,
    gcvSURF_A32R32G32B32_2_G32R32F,
    gcvSURF_A32R32G32B32_4_A8R8G8B8,
    /* BGR formats. */
    gcvSURF_A4B4G4R4            = 300,
    gcvSURF_A1B5G5R5,
    gcvSURF_B5G6R5,
    gcvSURF_B8G8R8,
    gcvSURF_B16G16R16,
    gcvSURF_X8B8G8R8,
    gcvSURF_A8B8G8R8,
    gcvSURF_A2B10G10R10,
    gcvSURF_X16B16G16R16,
    gcvSURF_A16B16G16R16,
    gcvSURF_B32G32R32,
    gcvSURF_X32B32G32R32,
    gcvSURF_A32B32G32R32,
    gcvSURF_B4G4R4A4,
    gcvSURF_B5G5R5A1,
    gcvSURF_B8G8R8X8,
    gcvSURF_B8G8R8A8,
    gcvSURF_B10G10R10A2,
    gcvSURF_X4B4G4R4,
    gcvSURF_X1B5G5R5,
    gcvSURF_B4G4R4X4,
    gcvSURF_B5G5R5X1,
    gcvSURF_X2B10G10R10,
    gcvSURF_B8G8R8_SNORM,
    gcvSURF_X8B8G8R8_SNORM,
    gcvSURF_A8B8G8R8_SNORM,
    gcvSURF_A8B12G12R12_2_A8R8G8B8,

    /* Compressed formats. */
    gcvSURF_DXT1                = 400,
    gcvSURF_DXT2,
    gcvSURF_DXT3,
    gcvSURF_DXT4,
    gcvSURF_DXT5,
    gcvSURF_CXV8U8,
    gcvSURF_ETC1,
    gcvSURF_R11_EAC,
    gcvSURF_SIGNED_R11_EAC,
    gcvSURF_RG11_EAC,
    gcvSURF_SIGNED_RG11_EAC,
    gcvSURF_RGB8_ETC2,
    gcvSURF_SRGB8_ETC2,
    gcvSURF_RGB8_PUNCHTHROUGH_ALPHA1_ETC2,
    gcvSURF_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2,
    gcvSURF_RGBA8_ETC2_EAC,
    gcvSURF_SRGB8_ALPHA8_ETC2_EAC,

    /* YUV formats. */
    gcvSURF_YUY2                = 500,
    gcvSURF_UYVY,
    gcvSURF_YV12,
    gcvSURF_I420,
    gcvSURF_NV12,
    gcvSURF_NV21,
    gcvSURF_NV16,
    gcvSURF_NV61,
    gcvSURF_YVYU,
    gcvSURF_VYUY,
    gcvSURF_AYUV,
    gcvSURF_YUV420_10_ST,
    gcvSURF_YUV420_TILE_ST,
    gcvSURF_YUV420_TILE_10_ST,
    gcvSURF_NV12_10BIT,
    gcvSURF_NV21_10BIT,
    gcvSURF_NV16_10BIT,
    gcvSURF_NV61_10BIT,
    gcvSURF_P010,
    gcvSURF_P010_LSB,
    gcvSURF_I010,
#if gcdVG_ONLY
    gcvSURF_AYUY2,
    gcvSURF_ANV12,
    gcvSURF_ANV16,
    gcvSURF_AUYVY,
    gcvSURF_YV16,
#endif

    /* Depth formats. */
    gcvSURF_D16                 = 600,
    gcvSURF_D24S8,
    gcvSURF_D32,
    gcvSURF_D24X8,
    gcvSURF_D32F,
    gcvSURF_S8D32F,
    gcvSURF_S8D32F_1_G32R32F,
    gcvSURF_S8D32F_2_A8R8G8B8,
    gcvSURF_D24S8_1_A8R8G8B8,
    gcvSURF_S8,
    gcvSURF_X24S8,
    gcvSURF_X24S8_1_A8R8G8B8,

    /* Alpha formats. */
    gcvSURF_A4                  = 700,
    gcvSURF_A8,
    gcvSURF_A12,
    gcvSURF_A16,
    gcvSURF_A32,
    gcvSURF_A1,

    /* Luminance formats. */
    gcvSURF_L4                  = 800,
    gcvSURF_L8,
    gcvSURF_L12,
    gcvSURF_L16,
    gcvSURF_L32,
    gcvSURF_L1,
    gcvSURF_L8_RAW,

    /* Alpha/Luminance formats. */
    gcvSURF_A4L4                = 900,
    gcvSURF_A2L6,
    gcvSURF_A8L8,
    gcvSURF_A4L12,
    gcvSURF_A12L12,
    gcvSURF_A16L16,

    gcvSURF_A8L8_1_A8R8G8B8,

    gcvSURF_A8L8_RAW,

    /* Bump formats. */
    gcvSURF_L6V5U5              = 1000,
    gcvSURF_V8U8,
    gcvSURF_X8L8V8U8,
    gcvSURF_Q8W8V8U8,
    gcvSURF_A2W10V10U10,
    gcvSURF_V16U16,
    gcvSURF_Q16W16V16U16,

    /* R/RG/RA formats. */
    gcvSURF_R8                  = 1100,
    gcvSURF_X8R8,
    gcvSURF_G8R8,
    gcvSURF_X8G8R8,
    gcvSURF_A8R8,
    gcvSURF_R16,
    gcvSURF_X16R16,
    gcvSURF_G16R16,
    gcvSURF_X16G16R16,
    gcvSURF_A16R16,
    gcvSURF_R32,
    gcvSURF_X32R32,
    gcvSURF_G32R32,
    gcvSURF_X32G32R32,
    gcvSURF_A32R32,
    gcvSURF_RG16,
    gcvSURF_R8_SNORM,
    gcvSURF_G8R8_SNORM,

    gcvSURF_R8_1_X8R8G8B8,
    gcvSURF_G8R8_1_X8R8G8B8,

    /* Floating point formats. */
    gcvSURF_R16F                = 1200,
    gcvSURF_X16R16F,
    gcvSURF_G16R16F,
    gcvSURF_X16G16R16F,
    gcvSURF_B16G16R16F,
    gcvSURF_X16B16G16R16F,
    gcvSURF_A16B16G16R16F,
    gcvSURF_R32F,
    gcvSURF_X32R32F,
    gcvSURF_G32R32F,
    gcvSURF_X32G32R32F,
    gcvSURF_B32G32R32F,
    gcvSURF_X32B32G32R32F,
    gcvSURF_A32B32G32R32F,
    gcvSURF_A16F,
    gcvSURF_L16F,
    gcvSURF_A16L16F,
    gcvSURF_A16R16F,
    gcvSURF_A32F,
    gcvSURF_L32F,
    gcvSURF_A32L32F,
    gcvSURF_A32R32F,
    gcvSURF_E5B9G9R9,
    gcvSURF_B10G11R11F,

    gcvSURF_X16B16G16R16F_2_A8R8G8B8,
    gcvSURF_A16B16G16R16F_2_A8R8G8B8,
    gcvSURF_A16B16G16R16F_2_G16R16F,
    gcvSURF_G32R32F_2_A8R8G8B8,
    gcvSURF_X32B32G32R32F_2_G32R32F,
    gcvSURF_A32B32G32R32F_2_G32R32F,
    gcvSURF_X32B32G32R32F_4_A8R8G8B8,
    gcvSURF_A32B32G32R32F_4_A8R8G8B8,

    gcvSURF_R16F_1_A4R4G4B4,
    gcvSURF_G16R16F_1_A8R8G8B8,
    gcvSURF_B16G16R16F_2_A8R8G8B8,

    gcvSURF_R32F_1_A8R8G8B8,
    gcvSURF_B32G32R32F_3_A8R8G8B8,
    gcvSURF_B10G11R11F_1_A8R8G8B8,

    gcvSURF_A32F_1_R32F,
    gcvSURF_L32F_1_R32F,
    gcvSURF_A32L32F_1_G32R32F,



    /* sRGB format. */
    gcvSURF_SBGR8               = 1400,
    gcvSURF_A8_SBGR8,
    gcvSURF_X8_SBGR8,
    gcvSURF_A8_SRGB8,
    gcvSURF_X8_SRGB8,

    /* Integer formats. */
    gcvSURF_R8I                 = 1500,
    gcvSURF_R8UI,
    gcvSURF_R16I,
    gcvSURF_R16UI,
    gcvSURF_R32I,
    gcvSURF_R32UI,
    gcvSURF_X8R8I,
    gcvSURF_G8R8I,
    gcvSURF_X8R8UI,
    gcvSURF_G8R8UI,
    gcvSURF_X16R16I,
    gcvSURF_G16R16I,
    gcvSURF_X16R16UI,
    gcvSURF_G16R16UI,
    gcvSURF_X32R32I,
    gcvSURF_G32R32I,
    gcvSURF_X32R32UI,
    gcvSURF_G32R32UI,
    gcvSURF_X8G8R8I,
    gcvSURF_B8G8R8I,
    gcvSURF_X8G8R8UI,
    gcvSURF_B8G8R8UI,
    gcvSURF_X16G16R16I,
    gcvSURF_B16G16R16I,
    gcvSURF_X16G16R16UI,
    gcvSURF_B16G16R16UI,
    gcvSURF_X32G32R32I,
    gcvSURF_B32G32R32I,
    gcvSURF_X32G32R32UI,
    gcvSURF_B32G32R32UI,
    gcvSURF_X8B8G8R8I,
    gcvSURF_A8B8G8R8I,
    gcvSURF_X8B8G8R8UI,
    gcvSURF_A8B8G8R8UI,
    gcvSURF_X16B16G16R16I,
    gcvSURF_A16B16G16R16I,
    gcvSURF_X16B16G16R16UI,
    gcvSURF_A16B16G16R16UI,
    gcvSURF_X32B32G32R32I,
    gcvSURF_A32B32G32R32I,
    gcvSURF_X32B32G32R32UI,
    gcvSURF_A32B32G32R32UI,
    gcvSURF_A2B10G10R10UI,
    gcvSURF_G32R32I_2_A8R8G8B8,
    gcvSURF_G32R32I_1_G32R32F,
    gcvSURF_G32R32UI_2_A8R8G8B8,
    gcvSURF_G32R32UI_1_G32R32F,
    gcvSURF_X16B16G16R16I_2_A8R8G8B8,
    gcvSURF_X16B16G16R16I_1_G32R32F,
    gcvSURF_A16B16G16R16I_2_A8R8G8B8,
    gcvSURF_A16B16G16R16I_1_G32R32F,
    gcvSURF_X16B16G16R16UI_2_A8R8G8B8,
    gcvSURF_X16B16G16R16UI_1_G32R32F,
    gcvSURF_A16B16G16R16UI_2_A8R8G8B8,
    gcvSURF_A16B16G16R16UI_1_G32R32F,
    gcvSURF_X32B32G32R32I_2_G32R32I,
    gcvSURF_A32B32G32R32I_2_G32R32I,
    gcvSURF_A32B32G32R32I_2_G32R32F,
    gcvSURF_X32B32G32R32I_3_A8R8G8B8,
    gcvSURF_A32B32G32R32I_4_A8R8G8B8,
    gcvSURF_X32B32G32R32UI_2_G32R32UI,
    gcvSURF_A32B32G32R32UI_2_G32R32UI,
    gcvSURF_A32B32G32R32UI_2_G32R32F,
    gcvSURF_X32B32G32R32UI_3_A8R8G8B8,
    gcvSURF_A32B32G32R32UI_4_A8R8G8B8,
    gcvSURF_A2B10G10R10UI_1_A8R8G8B8,
    gcvSURF_A8B8G8R8I_1_A8R8G8B8,
    gcvSURF_A8B8G8R8UI_1_A8R8G8B8,
    gcvSURF_R8I_1_A4R4G4B4,
    gcvSURF_R8UI_1_A4R4G4B4,
    gcvSURF_R16I_1_A4R4G4B4,
    gcvSURF_R16UI_1_A4R4G4B4,
    gcvSURF_R32I_1_A8R8G8B8,
    gcvSURF_R32UI_1_A8R8G8B8,
    gcvSURF_X8R8I_1_A4R4G4B4,
    gcvSURF_X8R8UI_1_A4R4G4B4,
    gcvSURF_G8R8I_1_A4R4G4B4,
    gcvSURF_G8R8UI_1_A4R4G4B4,
    gcvSURF_X16R16I_1_A4R4G4B4,
    gcvSURF_X16R16UI_1_A4R4G4B4,
    gcvSURF_G16R16I_1_A8R8G8B8,
    gcvSURF_G16R16UI_1_A8R8G8B8,
    gcvSURF_X32R32I_1_A8R8G8B8,
    gcvSURF_X32R32UI_1_A8R8G8B8,
    gcvSURF_X8G8R8I_1_A4R4G4B4,
    gcvSURF_X8G8R8UI_1_A4R4G4B4,
    gcvSURF_B8G8R8I_1_A8R8G8B8,
    gcvSURF_B8G8R8UI_1_A8R8G8B8,
    gcvSURF_B16G16R16I_2_A8R8G8B8,
    gcvSURF_B16G16R16I_1_G32R32F,
    gcvSURF_B16G16R16UI_2_A8R8G8B8,
    gcvSURF_B16G16R16UI_1_G32R32F,
    gcvSURF_B32G32R32I_3_A8R8G8B8,
    gcvSURF_B32G32R32UI_3_A8R8G8B8,
    gcvSURF_A16B16G16R16_2_A8R8G8B8,
    gcvSURF_R8G8B8_1_A8R8G8B8,
    gcvSURF_G16R16_1_A8R8G8B8,
    gcvSURF_A2B10G10R10_1_A8R8G8B8,
    gcvSURF_A2R10G10B10_1_A8R8G8B8,
    gcvSURF_A2W10V10U10_1_A8R8G8B8,

    /* ASTC formats. */
    gcvSURF_ASTC4x4             = 1600,
    gcvSURF_ASTC5x4,
    gcvSURF_ASTC5x5,
    gcvSURF_ASTC6x5,
    gcvSURF_ASTC6x6,
    gcvSURF_ASTC8x5,
    gcvSURF_ASTC8x6,
    gcvSURF_ASTC8x8,
    gcvSURF_ASTC10x5,
    gcvSURF_ASTC10x6,
    gcvSURF_ASTC10x8,
    gcvSURF_ASTC10x10,
    gcvSURF_ASTC12x10,
    gcvSURF_ASTC12x12,
    gcvSURF_ASTC4x4_SRGB,
    gcvSURF_ASTC5x4_SRGB,
    gcvSURF_ASTC5x5_SRGB,
    gcvSURF_ASTC6x5_SRGB,
    gcvSURF_ASTC6x6_SRGB,
    gcvSURF_ASTC8x5_SRGB,
    gcvSURF_ASTC8x6_SRGB,
    gcvSURF_ASTC8x8_SRGB,
    gcvSURF_ASTC10x5_SRGB,
    gcvSURF_ASTC10x6_SRGB,
    gcvSURF_ASTC10x8_SRGB,
    gcvSURF_ASTC10x10_SRGB,
    gcvSURF_ASTC12x10_SRGB,
    gcvSURF_ASTC12x12_SRGB,

    /* Recompile format*/
    gcvSURF_L16_1_A4R4G4B4 = 1700,
    gcvSURF_V16U16_1_A8R8G8B8,
    gcvSURF_Q8W8V8U8_1_A8R8G8B8,
    gcvSURF_X8L8V8U8_1_A8R8G8B8,
    gcvSURF_R3G3B2_1_A8R8G8B8,
    gcvSURF_A8R3G3B2_1_A8R8G8B8,
    gcvSURF_W11V11U10_1_A8R8G8B8,
    gcvSURF_Q16W16V16U16_2_A8R8G8B8,
    gcvSURF_W11V11U10,
    gcvSURF_V8U8_1_A4R4G4B4,
    gcvSURF_A8B8G8R8_1_A8R8G8B8,
    gcvSURF_A32R32G32B32_1_A8R8G8B8,
    gcvSURF_X16B16G16R16F_1_A8R8G8B8,
    gcvSURF_A16B16G16R16F_1_A8R8G8B8,
    gcvSURF_G32R32F_1_A8R8G8B8,
    gcvSURF_X32B32G32R32F_1_A8R8G8B8,
    gcvSURF_A32B32G32R32F_1_A8R8G8B8,
    gcvSURF_G32R32I_1_A8R8G8B8,
    gcvSURF_G32R32UI_1_A8R8G8B8,
    gcvSURF_A32B32G32R32I_1_A8R8G8B8,
    gcvSURF_A32B32G32R32UI_1_A8R8G8B8,
    gcvSURF_Q16W16V16U16_1_A8R8G8B8,
    gcvSURF_A16B16G16R16_1_A8R8G8B8,

    /* Integer formats (2)) */
    gcvSURF_R10G10B10A2UI   = 1800,
    gcvSURF_R5G6B5UI,
    gcvSURF_B5G6R5UI,
    gcvSURF_R3G3B2UI,
    gcvSURF_B2G3R3UI,
    gcvSURF_R4G4B4A4UI,
    gcvSURF_A4B4G4R4UI,
    gcvSURF_R5G5B5A1UI,
    gcvSURF_A1B5G5R5UI,
    gcvSURF_R8G8B8A8UI,

    /* GL4 formats */
    gcvSURF_G8              = 1900,
    gcvSURF_B8,
    gcvSURF_G32F,
    gcvSURF_B32F,

    /* Intensity formats */
    gcvSURF_I4              = 2000,
    gcvSURF_I8,
    gcvSURF_I12,
    gcvSURF_I16,
}
gceSURF_FORMAT;

/* Pipes. */
typedef enum _gcePIPE_SELECT
{
    gcvPIPE_INVALID = ~0,
    gcvPIPE_3D      =  0,
    gcvPIPE_2D
}
gcePIPE_SELECT;

/* Hardware type. */
typedef enum _gceHARDWARE_TYPE
{
    gcvHARDWARE_INVALID,
    gcvHARDWARE_3D2D,
    gcvHARDWARE_3D,
    gcvHARDWARE_2D,
    gcvHARDWARE_VIP,
    gcvHARDWARE_VG,
    gcvHARDWARE_NUM_TYPES,
}
gceHARDWARE_TYPE;

/* User signal command codes. */
typedef enum _gceUSER_SIGNAL_COMMAND_CODES
{
    gcvUSER_SIGNAL_CREATE,
    gcvUSER_SIGNAL_DESTROY,
    gcvUSER_SIGNAL_SIGNAL,
    gcvUSER_SIGNAL_WAIT,
    gcvUSER_SIGNAL_MAP,
    gcvUSER_SIGNAL_UNMAP,
}
gceUSER_SIGNAL_COMMAND_CODES;

/* Shared buffer command codes. */
typedef enum _gceSHBUF_COMMAND_CODES
{
    gcvSHBUF_CREATE,
    gcvSHBUF_DESTROY,
    gcvSHBUF_MAP,
    gcvSHBUF_WRITE,
    gcvSHBUF_READ,
}
gceSHBUF_COMMAND_CODES;

/* Event locations. */
typedef enum _gceKERNEL_WHERE
{
    gcvKERNEL_COMMAND,
    gcvKERNEL_VERTEX,
    gcvKERNEL_TRIANGLE,
    gcvKERNEL_TEXTURE,
    gcvKERNEL_PIXEL,
    gcvKERNEL_BLT,
}
gceKERNEL_WHERE;

typedef enum _gceBLOCK
{
    gcvBLOCK_COMMAND,
    gcvBLOCK_TESSELLATOR,
    gcvBLOCK_TESSELLATOR2,
    gcvBLOCK_TESSELLATOR3,
    gcvBLOCK_RASTER,
    gcvBLOCK_VG,
    gcvBLOCK_VG2,
    gcvBLOCK_VG3,
    gcvBLOCK_PIXEL,

    /* Number of defined blocks. */
    gcvBLOCK_COUNT
}
gceBLOCK;

typedef enum _gceCORE_3D_MASK
{
    gcvCORE_3D_0_MASK   = (1 << 0),
    gcvCORE_3D_1_MASK   = (1 << 1),

    gcvCORE_3D_ALL_MASK = (0xFFFF)
}
gceCORE_3D_MASK;

typedef enum _gceCORE_3D_ID
{
    gcvCORE_3D_0_ID       = 0,
    gcvCORE_3D_1_ID       = 1,

    gcvCORE_3D_ID_INVALID = ~0UL
}
gceCORE_3D_ID;


typedef enum _gceCHIP_FLAG
{
    gcvCHIP_FLAG_MSAA_COHERENCEY_ECO_FIX = 1 << 0,
    gcvCHIP_FLAG_GC2000_R2               = 1 << 1,
    gcvCHIP_AXI_BUS128_BITS              = 1 << 2,
}
gceCHIP_FLAG;

/* If different, choose render engine */
#define PRIORITY_ENGINE(a, b) gcmMIN(a,b)

typedef enum
{
    gcvENGINE_RENDER            = 0,
    gcvENGINE_BLT               = 1,
    gcvENGINE_GPU_ENGINE_COUNT  = 2,
    gcvENGINE_CPU               = gcvENGINE_GPU_ENGINE_COUNT,
    gcvENGINE_ALL_COUNT         = gcvENGINE_CPU + 1,
    gcvENGINE_INVALID           = gcvENGINE_ALL_COUNT + 0x100
}
gceENGINE;

/* CORE enum. */
typedef enum _gceCORE
{
    gcvCORE_MAJOR,
    gcvCORE_3D1,
    gcvCORE_3D2,
    gcvCORE_3D3,
    gcvCORE_3D4,
    gcvCORE_3D5,
    gcvCORE_3D6,
    gcvCORE_3D7,
    gcvCORE_3D_MAX = gcvCORE_3D7,
    gcvCORE_2D,
    gcvCORE_VG,
#if gcdDEC_ENABLE_AHB
    gcvCORE_DEC,
#endif
    gcvCORE_COUNT
}
gceCORE;

#define gcdCHIP_COUNT               gcvCORE_COUNT

typedef enum _gceSECURE_MODE
{
    /* For cores without gcvFEATURE_SECURITY. */
    gcvSECURE_NONE,

    /* Use registers added in gcvFEATURE_SECURITY in normal driver,
    ** In this mode, GPU always works under non secure mode and
    ** should not touch secure buffer. It is used to test basic function.
    */
    gcvSECURE_IN_NORMAL,

    /* Make use of gcvFEATURE_SECURITY in trust application. */
    gcvSECURE_IN_TA
}
gceSECURE_MODE;

/* kernel driver compression option, as it's a system global option,
** it means kernel driver allows the options, NOT necessarily means it must be on.
*/
typedef enum _gceCOMPRESSION_OPTION
{
    gcvCOMPRESSION_OPTION_NONE       = 0x0, /* No any compression */
    gcvCOMPRESSION_OPTION_COLOR      = 0x1, /* Compression for non-msaa color format */
    gcvCOMPRESSION_OPTION_DEPTH      = 0x2, /* Compression for non-msaa depth format */
    gcvCOMPRESSION_OPTION_MSAA_COLOR = 0x4, /* Compression for msaa color */
    gcvCOMPRESSION_OPTION_MSAA_DEPTH = 0x8, /* Compression for msaa depth */

    /* default compressio option */
    gcvCOMPRESSION_OPTION_DEFAULT    = gcvCOMPRESSION_OPTION_DEPTH      |
                                       gcvCOMPRESSION_OPTION_COLOR      |
                                       gcvCOMPRESSION_OPTION_MSAA_COLOR |
                                       gcvCOMPRESSION_OPTION_MSAA_DEPTH,
}
gceCOMPRESSION_OPTION;

typedef enum _gceSRAM_INTERNAL
{
    gcvSRAM_INTERNAL0 = 0,
    gcvSRAM_INTERNAL1,

    gcvSRAM_INTER_COUNT
}
gceSRAM_INTERNAL;

typedef enum _gceSRAM_EXTERNAL
{
    gcvSRAM_EXTERNAL0 = 0,
    gcvSRAM_EXTERNAL1,

    gcvSRAM_EXT_COUNT
}
gceSRAM_EXTERNAL;

typedef enum _gceFLATMAP_FLAG
{
    gcvFLATMAP_DIRECT,
    gcvFLATMAP_SHIFT,
}
gceFLATMAP_FLAG;

/* Video memory alloation type. */
typedef enum _gceVIDMEM_TYPE
{
    gcvVIDMEM_TYPE_GENERIC          = gcvSURF_TYPE_UNKNOWN,
    gcvVIDMEM_TYPE_INDEX_BUFFER     = gcvSURF_INDEX,
    gcvVIDMEM_TYPE_VERTEX_BUFFER    = gcvSURF_VERTEX,
    gcvVIDMEM_TYPE_TEXTURE          = gcvSURF_TEXTURE,
    gcvVIDMEM_TYPE_COLOR_BUFFER     = gcvSURF_RENDER_TARGET,
    gcvVIDMEM_TYPE_DEPTH_BUFFER     = gcvSURF_DEPTH,
    gcvVIDMEM_TYPE_BITMAP           = gcvSURF_BITMAP,
    gcvVIDMEM_TYPE_TILE_STATUS      = gcvSURF_TILE_STATUS,
    gcvVIDMEM_TYPE_IMAGE            = gcvSURF_IMAGE,
    gcvVIDMEM_TYPE_MASK             = gcvSURF_MASK,
    gcvVIDMEM_TYPE_SCISSOR          = gcvSURF_SCISSOR,
    gcvVIDMEM_TYPE_HZ_BUFFER        = gcvSURF_HIERARCHICAL_DEPTH,
    gcvVIDMEM_TYPE_ICACHE           = gcvSURF_ICACHE,
    gcvVIDMEM_TYPE_TXDESC           = gcvSURF_TXDESC,
    gcvVIDMEM_TYPE_FENCE            = gcvSURF_FENCE,
    gcvVIDMEM_TYPE_TFBHEADER        = gcvSURF_TFBHEADER,
    gcvVIDMEM_TYPE_COMMAND,
    gcvVIDMEM_TYPE_COUNT
}
gceVIDMEM_TYPE;

typedef enum _gceTASK
{
    gcvTASK_LINK,
    gcvTASK_CLUSTER,
    gcvTASK_INCREMENT,
    gcvTASK_DECREMENT,
    gcvTASK_SIGNAL,
    gcvTASK_LOCKDOWN,
    gcvTASK_UNLOCK_VIDEO_MEMORY,
    gcvTASK_FREE_VIDEO_MEMORY,
    gcvTASK_FREE_CONTIGUOUS_MEMORY,
}
gceTASK;

/******************************************************************************\
********************************* Status Codes *********************************
\******************************************************************************/

typedef enum _gceSTATUS
{
    gcvSTATUS_OK                    =   0,
    gcvSTATUS_FALSE                 =   0,
    gcvSTATUS_TRUE                  =   1,
    gcvSTATUS_NO_MORE_DATA          =   2,
    gcvSTATUS_CACHED                =   3,
    gcvSTATUS_MIPMAP_TOO_LARGE      =   4,
    gcvSTATUS_NAME_NOT_FOUND        =   5,
    gcvSTATUS_NOT_OUR_INTERRUPT     =   6,
    gcvSTATUS_MISMATCH              =   7,
    gcvSTATUS_MIPMAP_TOO_SMALL      =   8,
    gcvSTATUS_LARGER                =   9,
    gcvSTATUS_SMALLER               =   10,
    gcvSTATUS_CHIP_NOT_READY        =   11,
    gcvSTATUS_NEED_CONVERSION       =   12,
    gcvSTATUS_SKIP                  =   13,
    gcvSTATUS_DATA_TOO_LARGE        =   14,
    gcvSTATUS_INVALID_CONFIG        =   15,
    gcvSTATUS_CHANGED               =   16,
    gcvSTATUS_NOT_SUPPORT_DITHER    =   17,
    gcvSTATUS_EXECUTED              =   18,
    gcvSTATUS_TERMINATE             =   19,

    gcvSTATUS_INVALID_ARGUMENT      =   -1,
    gcvSTATUS_INVALID_OBJECT        =   -2,
    gcvSTATUS_OUT_OF_MEMORY         =   -3,
    gcvSTATUS_MEMORY_LOCKED         =   -4,
    gcvSTATUS_MEMORY_UNLOCKED       =   -5,
    gcvSTATUS_HEAP_CORRUPTED        =   -6,
    gcvSTATUS_GENERIC_IO            =   -7,
    gcvSTATUS_INVALID_ADDRESS       =   -8,
    gcvSTATUS_CONTEXT_LOSSED        =   -9,
    gcvSTATUS_TOO_COMPLEX           =   -10,
    gcvSTATUS_BUFFER_TOO_SMALL      =   -11,
    gcvSTATUS_INTERFACE_ERROR       =   -12,
    gcvSTATUS_NOT_SUPPORTED         =   -13,
    gcvSTATUS_MORE_DATA             =   -14,
    gcvSTATUS_TIMEOUT               =   -15,
    gcvSTATUS_OUT_OF_RESOURCES      =   -16,
    gcvSTATUS_INVALID_DATA          =   -17,
    gcvSTATUS_INVALID_MIPMAP        =   -18,
    gcvSTATUS_NOT_FOUND             =   -19,
    gcvSTATUS_NOT_ALIGNED           =   -20,
    gcvSTATUS_INVALID_REQUEST       =   -21,
    gcvSTATUS_GPU_NOT_RESPONDING    =   -22,
    gcvSTATUS_TIMER_OVERFLOW        =   -23,
    gcvSTATUS_VERSION_MISMATCH      =   -24,
    gcvSTATUS_LOCKED                =   -25,
    gcvSTATUS_INTERRUPTED           =   -26,
    gcvSTATUS_DEVICE                =   -27,
    gcvSTATUS_NOT_MULTI_PIPE_ALIGNED =   -28,
    gcvSTATUS_OUT_OF_SAMPLER         =   -29,

    /* Linker errors. */
    gcvSTATUS_GLOBAL_TYPE_MISMATCH              =   -1000,
    gcvSTATUS_TOO_MANY_ATTRIBUTES               =   -1001,
    gcvSTATUS_TOO_MANY_UNIFORMS                 =   -1002,
    gcvSTATUS_TOO_MANY_VARYINGS                 =   -1003,
    gcvSTATUS_UNDECLARED_VARYING                =   -1004,
    gcvSTATUS_VARYING_TYPE_MISMATCH             =   -1005,
    gcvSTATUS_MISSING_MAIN                      =   -1006,
    gcvSTATUS_NAME_MISMATCH                     =   -1007,
    gcvSTATUS_INVALID_INDEX                     =   -1008,
    gcvSTATUS_UNIFORM_MISMATCH                  =   -1009,
    gcvSTATUS_UNSAT_LIB_SYMBOL                  =   -1010,
    gcvSTATUS_TOO_MANY_SHADERS                  =   -1011,
    gcvSTATUS_LINK_INVALID_SHADERS              =   -1012,
    gcvSTATUS_CS_NO_WORKGROUP_SIZE              =   -1013,
    gcvSTATUS_LINK_LIB_ERROR                    =   -1014,

    gcvSTATUS_SHADER_VERSION_MISMATCH           =   -1015,
    gcvSTATUS_TOO_MANY_INSTRUCTION              =   -1016,
    gcvSTATUS_SSBO_MISMATCH                     =   -1017,
    gcvSTATUS_TOO_MANY_OUTPUT                   =   -1018,
    gcvSTATUS_TOO_MANY_INPUT                    =   -1019,
    gcvSTATUS_NOT_SUPPORT_CL                    =   -1020,
    gcvSTATUS_NOT_SUPPORT_INTEGER               =   -1021,
    gcvSTATUS_UNIFORM_TYPE_MISMATCH             =   -1022,

    gcvSTATUS_MISSING_PRIMITIVE_TYPE            =   -1023,
    gcvSTATUS_MISSING_OUTPUT_VERTEX_COUNT       =   -1024,
    gcvSTATUS_NON_INVOCATION_ID_AS_INDEX        =   -1025,
    gcvSTATUS_INPUT_ARRAY_SIZE_MISMATCH         =   -1026,
    gcvSTATUS_OUTPUT_ARRAY_SIZE_MISMATCH        =   -1027,
    gcvSTATUS_LOCATION_ALIASED                  =   -1028,
    gcvSTATUS_LOCATION_OVERLAP                  =   -1029,
    gcvSTATUS_LOCATION_NOTCONSISTENT            =   -1030,

    /* Compiler errors. */
    gcvSTATUS_COMPILER_FE_PREPROCESSOR_ERROR    =   -2000,
    gcvSTATUS_COMPILER_FE_PARSER_ERROR          =   -2001,

    /* Recompilation Errors */
    gcvSTATUS_RECOMPILER_CONVERT_UNIMPLEMENTED  =   -3000,
}
gceSTATUS;

/* The patch types. */
enum _gceHAL_PATCH_TYPE
{
    gcvHAL_PATCH_VIDMEM_ADDRESS = 1,
    gcvHAL_PATCH_MCFE_SEMAPHORE,
    gcvHAL_PATCH_VIDMEM_TIMESTAMP,

    /* Must be the last one for counting. */
    gcvHAL_PATCH_TYPE_COUNT,
};

/******************************************************************************\
********************************* Command Codes ********************************
\******************************************************************************/

typedef enum _gceHAL_COMMAND_CODES
{
    /*************** Common ***************/

    /* Chip info: count, type and so on. */
    gcvHAL_CHIP_INFO,

    /* HAL driver version. */
    gcvHAL_VERSION,

    /* Query chip id and options. */
    gcvHAL_QUERY_CHIP_IDENTITY,
    gcvHAL_QUERY_CHIP_OPTION,

    /* Query chip frequency, used by CL. */
    gcvHAL_QUERY_CHIP_FREQUENCY,

    /* Query system pool video memory, used by CL. */
    gcvHAL_QUERY_VIDEO_MEMORY,

    /* Memory management. */
    gcvHAL_ALLOCATE_LINEAR_VIDEO_MEMORY,
    gcvHAL_WRAP_USER_MEMORY,
    gcvHAL_RELEASE_VIDEO_MEMORY,
    gcvHAL_LOCK_VIDEO_MEMORY,
    gcvHAL_UNLOCK_VIDEO_MEMORY,
    gcvHAL_BOTTOM_HALF_UNLOCK_VIDEO_MEMORY,
    gcvHAL_MAP_MEMORY,
    gcvHAL_UNMAP_MEMORY,

    /* Cache operations. */
    gcvHAL_CACHE,

    /* HAL user attach and detach. */
    gcvHAL_ATTACH,
    gcvHAL_DETACH,

    /* Event commit. */
    gcvHAL_EVENT_COMMIT,

    /* User command commit. */
    gcvHAL_COMMIT,

    /* Set hardware timeout, used by CL. */
    gcvHAL_SET_TIMEOUT,

    /* User signal operations. */
    gcvHAL_USER_SIGNAL,

    /* Event signal, commit stall. */
    gcvHAL_SIGNAL,

    /* Profile related. */
    gcvHAL_SET_PROFILE_SETTING,
    gcvHAL_READ_PROFILER_REGISTER_SETTING,
    gcvHAL_READ_ALL_PROFILE_REGISTERS_PART1,
    gcvHAL_READ_ALL_PROFILE_REGISTERS_PART2,

    /* Query process database info when debug trace and proflie. */
    gcvHAL_DATABASE,

    /* Power managment enable/disable. */
    gcvHAL_CONFIG_POWER_MANAGEMENT,

    /* Debug/dump feature. */
    gcvHAL_DEBUG_DUMP,

    /*************** Common end ***************/

    /*************** GPU only ***************/
    /* Register operations, 2D only. */
    gcvHAL_READ_REGISTER,
    gcvHAL_WRITE_REGISTER,
    gcvHAL_PROFILE_REGISTERS_2D,

    /* Get base address for old mmu. */
    gcvHAL_GET_BASE_ADDRESS,

    /* Read frame database, 3D only. */
    gcvHAL_GET_FRAME_INFO,

    /* Set video memory meta data. */
    gcvHAL_SET_VIDEO_MEMORY_METADATA,

    /* Query command buffer, VG only. */
    gcvHAL_QUERY_COMMAND_BUFFER,

    /* Reset time stamp. */
    gcvHAL_QUERY_RESET_TIME_STAMP,

    /* Create native fence. */
    gcvHAL_CREATE_NATIVE_FENCE,

    /* Wait native fence. */
    gcvHAL_WAIT_NATIVE_FENCE,

    /* Wait until GPU finishes access to a resource. */
    gcvHAL_WAIT_FENCE,

    /* Video memory node operations. */
    gcvHAL_EXPORT_VIDEO_MEMORY,
    gcvHAL_NAME_VIDEO_MEMORY,
    gcvHAL_IMPORT_VIDEO_MEMORY,

    /* Mutex Operation. */
    gcvHAL_DEVICE_MUTEX,
    /*************** GPU only end ***************/

    /*************** DEC only ***************/
    /* DEC200 test. */
    gcvHAL_DEC200_TEST,

    /* DEC300 related operations. */
    gcvHAL_DEC300_READ,
    gcvHAL_DEC300_WRITE,
    gcvHAL_DEC300_FLUSH,
    gcvHAL_DEC300_FLUSH_WAIT,
    /*************** DEC only end ***************/

    /*************** OS specific ***************/

    /* Android gralloc: shared buffer operations. */
    gcvHAL_SHBUF,

    /* Android gralloc: get graphic buffer fd. */
    gcvHAL_GET_GRAPHIC_BUFFER_FD,

    /* Vsimulator only. */
    gcvHAL_UPDATE_DEBUG_CALLBACK,
    gcvHAL_CONFIG_CTX_FRAMEWORK,

    /* Non paged memory management backup compatibility, windows, qnx. */
    gcvHAL_ALLOCATE_NON_PAGED_MEMORY,
    gcvHAL_FREE_NON_PAGED_MEMORY,

    /* Write user data, windows only. */
    gcvHAL_WRITE_DATA,

    /*************** OS specific end ***************/

    /*************** Reserved ***************/
    gcvHAL_SET_IDLE,
    gcvHAL_RESET,

    /* Command commit done, kernel event only. */
    gcvHAL_COMMIT_DONE,

    /* Get video memory file description. */
    gcvHAL_GET_VIDEO_MEMORY_FD,

    /* Get profile setting. */
    gcvHAL_GET_PROFILE_SETTING,

    /* Read/Write register ex. */
    gcvHAL_READ_REGISTER_EX,
    gcvHAL_WRITE_REGISTER_EX,

    /* Power managment state. */
    gcvHAL_SET_POWER_MANAGEMENT_STATE,
    gcvHAL_QUERY_POWER_MANAGEMENT_STATE,

    /* Set debug level. */
    gcvHAL_SET_DEBUG_LEVEL_ZONE,

    /* Dump info. */
    gcvHAL_DUMP_GPU_STATE,
    gcvHAL_DUMP_EVENT,
    gcvHAL_DUMP_GPU_PROFILE,

    /* Timer. */
    gcvHAL_TIMESTAMP,

    /* FSCALE_VAL. */
    gcvHAL_SET_FSCALE_VALUE,
    gcvHAL_GET_FSCALE_VALUE,

    /* Destory MMU. */
    gcvHAL_DESTROY_MMU,
    /*************** Reserved end ***************/
}
gceHAL_COMMAND_CODES;

/******************************************************************************\
******************************** gcsOBJECT Object *******************************
\******************************************************************************/

/* Macro to combine four characters into a Charcater Code. */
#define gcmCC(c1, c2, c3, c4) \
(\
    (char) (c1) \
    | \
    ((char) (c2) <<  8) \
    | \
    ((char) (c3) << 16) \
    | \
    ((char) (c4) << 24) \
)

/* Type of objects. */
typedef enum _gceOBJECT_TYPE
{
    gcvOBJ_UNKNOWN              = 0,
    gcvOBJ_2D                   = gcmCC('2','D',' ',' '),
    gcvOBJ_3D                   = gcmCC('3','D',' ',' '),
    gcvOBJ_ATTRIBUTE            = gcmCC('A','T','T','R'),
    gcvOBJ_BRUSHCACHE           = gcmCC('B','R','U','$'),
    gcvOBJ_BRUSHNODE            = gcmCC('B','R','U','n'),
    gcvOBJ_BRUSH                = gcmCC('B','R','U','o'),
    gcvOBJ_BUFFER               = gcmCC('B','U','F','R'),
    gcvOBJ_COMMAND              = gcmCC('C','M','D',' '),
    gcvOBJ_COMMANDBUFFER        = gcmCC('C','M','D','B'),
    gcvOBJ_CONTEXT              = gcmCC('C','T','X','T'),
    gcvOBJ_DEVICE               = gcmCC('D','E','V',' '),
    gcvOBJ_DUMP                 = gcmCC('D','U','M','P'),
    gcvOBJ_EVENT                = gcmCC('E','V','N','T'),
    gcvOBJ_FUNCTION             = gcmCC('F','U','N','C'),
    gcvOBJ_HAL                  = gcmCC('H','A','L',' '),
    gcvOBJ_HARDWARE             = gcmCC('H','A','R','D'),
    gcvOBJ_HEAP                 = gcmCC('H','E','A','P'),
    gcvOBJ_INDEX                = gcmCC('I','N','D','X'),
    gcvOBJ_INTERRUPT            = gcmCC('I','N','T','R'),
    gcvOBJ_KERNEL               = gcmCC('K','E','R','N'),
    gcvOBJ_KERNEL_FUNCTION      = gcmCC('K','F','C','N'),
    gcvOBJ_MEMORYBUFFER         = gcmCC('M','E','M','B'),
    gcvOBJ_MMU                  = gcmCC('M','M','U',' '),
    gcvOBJ_OS                   = gcmCC('O','S',' ',' '),
    gcvOBJ_OUTPUT               = gcmCC('O','U','T','P'),
    gcvOBJ_PAINT                = gcmCC('P','N','T',' '),
    gcvOBJ_PATH                 = gcmCC('P','A','T','H'),
    gcvOBJ_QUEUE                = gcmCC('Q','U','E',' '),
    gcvOBJ_SAMPLER              = gcmCC('S','A','M','P'),
    gcvOBJ_SHADER               = gcmCC('S','H','D','R'),
    gcvOBJ_VIR_SHADER           = gcmCC('V','S','D','R'),
    gcvOBJ_STREAM               = gcmCC('S','T','R','M'),
    gcvOBJ_SURF                 = gcmCC('S','U','R','F'),
    gcvOBJ_TEXTURE              = gcmCC('T','X','T','R'),
    gcvOBJ_UNIFORM              = gcmCC('U','N','I','F'),
    gcvOBJ_VARIABLE             = gcmCC('V','A','R','I'),
    gcvOBJ_VERTEX               = gcmCC('V','R','T','X'),
    gcvOBJ_VIDMEM               = gcmCC('V','M','E','M'),
    gcvOBJ_VIDMEM_BLOCK         = gcmCC('V','M','B','K'),
    gcvOBJ_VG                   = gcmCC('V','G',' ',' '),
    gcvOBJ_BUFOBJ               = gcmCC('B','U','F','O'),
    gcvOBJ_UNIFORM_BLOCK        = gcmCC('U','B','L','K'),
    gcvOBJ_CL                   = gcmCC('C','L',' ',' '),
    gcvOBJ_STORAGE_BLOCK        = gcmCC('S','B','L','K'),
    gcvOBJ_IO_BLOCK             = gcmCC('I','O','B','K'),
}
gceOBJECT_TYPE;

/* Video memory pool type. */
typedef enum _gcePOOL
{
    gcvPOOL_UNKNOWN = 0,
    gcvPOOL_DEFAULT,
    gcvPOOL_LOCAL,
    gcvPOOL_LOCAL_INTERNAL,
    gcvPOOL_LOCAL_EXTERNAL,
    gcvPOOL_UNIFIED,
    gcvPOOL_SYSTEM,
    gcvPOOL_SRAM,
    gcvPOOL_VIRTUAL,
    gcvPOOL_USER,
    gcvPOOL_INTERNAL_SRAM,
    gcvPOOL_EXTERNAL_SRAM,

    gcvPOOL_NUMBER_OF_POOLS
}
gcePOOL;

typedef enum _gceDUMP_BUFFER_TYPE
{
    gcvDUMP_BUFFER_USER_STRING,
    gcvDUMP_BUFFER_VERIFY,

    gcvDUMP_BUFFER_MEMORY,
    gcvDUMP_BUFFER_TEXTURE,
    gcvDUMP_BUFFER_STREAM,
    gcvDUMP_BUFFER_INDEX,
    gcvDUMP_BUFFER_BUFOBJ,
    gcvDUMP_BUFFER_IMAGE,
    /* A type of command, but should not execute directly. */
    gcvDUMP_BUFFER_INSTRUCTION,
    gcvDUMP_BUFFER_CONTEXT,
    gcvDUMP_BUFFER_COMMAND,
    gcvDUMP_BUFFER_ASYNC_COMMAND,
    gcvDUMP_BUFFER_USER_TYPE_LAST = gcvDUMP_BUFFER_ASYNC_COMMAND,

    gcvDUMP_BUFFER_KERNEL_CONTEXT,
    gcvDUMP_BUFFER_KERNEL_COMMAND,

    gcvDUMP_BUFFER_PHYSICAL_MEMORY,

    gcvDUMP_BUFFER_TYPE_COUNT,
}
gceDUMP_BUFFER_TYPE;

typedef enum _gceProfilerMode
{
    gcvPROFILER_PROBE_MODE = 0,
    gcvPROFILER_AHB_MODE   = 1,
}
gceProfilerMode;

#ifdef __cplusplus
}
#endif

#endif /* __gc_hal_enum_shared_h_ */



