/**
 * @file       x01f10_mode_tbls.h
 * @brief      OX01F10 sensor mode tables
 * @date       2021/07/26
 * @par        Copyright
 *             2021- Shikino High-Tech Co.,LTD. All rights reserved.
 *
 *             This program is free software; you can redistribute it and/or modify it
 *             under the terms and conditions of the GNU General Public License,
 *             version 2, as published by the Free Software Foundation.
 *
 *             This program is distributed in the hope it will be useful, but WITHOUT
 *             ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *             FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *             more details.
 *
 *             You should have received a copy of the GNU General Public License
 *             along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __OX01F10_MODE_TBLS__
#define __OX01F10_MODE_TBLS__

#define OX01F10_TABLE_WAIT_MS	0
#define OX01F10_TABLE_END	1
#define OX01F10_WAIT_MS		10
#define OX01F10_DEFAULT_MODE	0

#define OX01F10_DEFAULT_WIDTH	1344
#define OX01F10_DEFAULT_HEIGHT	1020
#define OX01F10_DEFAULT_DATAFMT	MEDIA_BUS_FMT_UYVY8_1X16

struct reg_8 {
	u16 addr;
	u8 val;
};
#define ox01f10_reg struct reg_8

enum {
	MODE_1344x1020 = 0,
	MODE_UNKNOWN
};

static const int ox01f10_30fps[] = {
	30,
};

static const ox01f10_reg ox01f10_start[] = {
	{0x0100, 0x01},
	{OX01F10_TABLE_END, 0x00}
};

static const ox01f10_reg ox01f10_stop[] = {
	{0x0100, 0x00},
	{OX01F10_TABLE_END, 0x00}
};

static const ox01f10_reg ox01f10_mode_1340x1020[] = {
	{OX01F10_TABLE_WAIT_MS, OX01F10_WAIT_MS},
	{ 0x0100, 0x01 },
	{ 0x3d84, 0x40 },
	{ 0x3d88, 0x20 },
	{ 0x3d89, 0x2e },
	{ 0x3d8a, 0x20 },
	{ 0x3d8b, 0x2f },
	{ 0x3d81, 0x01 },
	{OX01F10_TABLE_WAIT_MS, 20},
	{ 0x0100, 0x00 },
	{ 0x107, 0x1 },
	{OX01F10_TABLE_WAIT_MS, 30},
	{ 0x8004, 0x4 },
	{ 0xa10a, 0x0 },
	{ 0xa11e, 0x7f },
	{ 0xa11d, 0x0 },
	{ 0xa110, 0x80 },
	{ 0xa10f, 0x18 },
	{ 0xa10e, 0x0 },
	{ 0xa10d, 0x0 },
	{ 0x8198, 0x10 },
	{ 0x8199, 0x0 },
	{ 0x819a, 0x18 },
	{ 0x819b, 0x0 },
	{ 0x819c, 0x0 },
	{ 0x819d, 0x0 },
	{ 0x819e, 0x0 },
	{ 0x819f, 0x0 },
	{ 0xb000, 0x0 },
	{ 0xb001, 0x18 },
	{ 0xb002, 0x0 },
	{ 0xb003, 0x10 },
	{ 0xb004, 0x0 },
	{ 0xb005, 0x0 },
	{ 0xb006, 0x0 },
	{ 0xb007, 0x0 },
	{ 0xb008, 0x0 },
	{ 0xb009, 0x0 },
	{ 0xb00a, 0x0 },
	{ 0xb00b, 0x0 },
	{ 0xb00c, 0x0 },
	{ 0xb00d, 0x0 },
	{ 0xb00e, 0x0 },
	{ 0xb00f, 0x0 },
	{ 0xb010, 0x98 },
	{ 0xb011, 0xe0 },
	{ 0xb012, 0xbc },
	{ 0xb013, 0x0 },
	{ 0xb014, 0x18 },
	{ 0xb015, 0x0 },
	{ 0xb016, 0x47 },
	{ 0xb017, 0xa8 },
	{ 0xb018, 0x80 },
	{ 0xb019, 0x8c },
	{ 0xb01a, 0xe0 },
	{ 0xb01b, 0x1c },
	{ 0xb01c, 0x4c },
	{ 0xb01d, 0x18 },
	{ 0xb01e, 0x0 },
	{ 0xb01f, 0x98 },
	{ 0xb020, 0xe0 },
	{ 0xb021, 0x90 },
	{ 0xb022, 0x80 },
	{ 0xb023, 0x18 },
	{ 0xb024, 0x0 },
	{ 0xb025, 0x8c },
	{ 0xb026, 0xe0 },
	{ 0xb027, 0x12 },
	{ 0xb028, 0x2c },
	{ 0xb029, 0x18 },
	{ 0xb02a, 0x0 },
	{ 0xb02b, 0x4b },
	{ 0xb02c, 0xec },
	{ 0xb02d, 0x80 },
	{ 0xb02e, 0x98 },
	{ 0xb02f, 0xe0 },
	{ 0xb030, 0x5c },
	{ 0xb031, 0xc0 },
	{ 0xb032, 0x18 },
	{ 0xb033, 0x0 },
	{ 0xb034, 0x8c },
	{ 0xb035, 0xe0 },
	{ 0xb036, 0x33 },
	{ 0xb037, 0xcc },
	{ 0xb038, 0x18 },
	{ 0xb039, 0x0 },
	{ 0xb03a, 0x47 },
	{ 0xb03b, 0xb8 },
	{ 0xb03c, 0x80 },
	{ 0xb03d, 0x8c },
	{ 0xb03e, 0xe0 },
	{ 0xb03f, 0x6a },
	{ 0xb040, 0x2c },
	{ 0xb041, 0x18 },
	{ 0xb042, 0x0 },
	{ 0xb043, 0x47 },
	{ 0xb044, 0xa2 },
	{ 0xb045, 0x0 },
	{ 0xb046, 0x2c },
	{ 0xb047, 0xc7 },
	{ 0xb048, 0x60 },
	{ 0xb049, 0x25 },
	{ 0xb04a, 0x63 },
	{ 0xb04b, 0x0 },
	{ 0xb04c, 0x0 },
	{ 0xb04d, 0xa8 },
	{ 0xb04e, 0xc0 },
	{ 0xb04f, 0xa6 },
	{ 0xb050, 0x29 },
	{ 0xb051, 0xe0 },
	{ 0xb052, 0x2c },
	{ 0xb053, 0xc7 },
	{ 0xb054, 0x60 },
	{ 0xb055, 0x24 },
	{ 0xb056, 0xc6 },
	{ 0xb057, 0xb7 },
	{ 0xb058, 0x34 },
	{ 0xb059, 0xc6 },
	{ 0xb05a, 0x10 },
	{ 0xb05b, 0x40 },
	{ 0xb05c, 0x6 },
	{ 0xb05d, 0x6c },
	{ 0xb05e, 0x2d },
	{ 0xb05f, 0x47 },
	{ 0xb060, 0x54 },
	{ 0xb061, 0x98 },
	{ 0xb062, 0xe0 },
	{ 0xb063, 0x2 },
	{ 0xb064, 0x42 },
	{ 0xb065, 0xf0 },
	{ 0xb066, 0x0 },
	{ 0xb067, 0x65 },
	{ 0xb068, 0x47 },
	{ 0xb069, 0x55 },
	{ 0xb06a, 0x0 },
	{ 0xb06b, 0x68 },
	{ 0xb06c, 0x1 },
	{ 0xb06d, 0x58 },
	{ 0xb06e, 0xd4 },
	{ 0xb06f, 0x8 },
	{ 0xb070, 0xd6 },
	{ 0xb071, 0x1f },
	{ 0xb072, 0x8c },
	{ 0xb073, 0xe0 },
	{ 0xb074, 0x6a },
	{ 0xb075, 0x2c },
	{ 0xb076, 0x18 },
	{ 0xb077, 0x0 },
	{ 0xb078, 0x24 },
	{ 0xb079, 0xe7 },
	{ 0xb07a, 0x64 },
	{ 0xb07b, 0x3e },
	{ 0xb07c, 0x7 },
	{ 0xb07d, 0x38 },
	{ 0xb07e, 0x40 },
	{ 0xb07f, 0x7 },
	{ 0xb080, 0xc8 },
	{ 0xb081, 0x1 },
	{ 0xb082, 0x5f },
	{ 0xb083, 0x0 },
	{ 0xb084, 0x68 },
	{ 0xb085, 0xd4 },
	{ 0xb086, 0x9f },
	{ 0xb087, 0x56 },
	{ 0xb088, 0x1f },
	{ 0xb089, 0x41 },
	{ 0xb08a, 0xa },
	{ 0xb08b, 0x97 },
	{ 0xb08c, 0x31 },
	{ 0xb08d, 0x40 },
	{ 0xb08e, 0x49 },
	{ 0xb08f, 0xe },
	{ 0xb090, 0xb8 },
	{ 0xb091, 0x8c },
	{ 0xb092, 0xe0 },
	{ 0xb093, 0x6a },
	{ 0xb094, 0x2c },
	{ 0xb095, 0x18 },
	{ 0xb096, 0x0 },
	{ 0xb097, 0x38 },
	{ 0xb098, 0xc0 },
	{ 0xb099, 0x5a },
	{ 0xb09a, 0x4 },
	{ 0xb09b, 0x8b },
	{ 0xb09c, 0x20 },
	{ 0xb09d, 0xc7 },
	{ 0xb09e, 0x24 },
	{ 0xb09f, 0x20 },
	{ 0xb0a0, 0x7 },
	{ 0xb0a1, 0xa4 },
	{ 0xb0a2, 0x2c },
	{ 0xb0a3, 0xe7 },
	{ 0xb0a4, 0x60 },
	{ 0xb0a5, 0x25 },
	{ 0xb0a6, 0x87 },
	{ 0xb0a7, 0x22 },
	{ 0xb0a8, 0x21 },
	{ 0xb0a9, 0x67 },
	{ 0xb0aa, 0x22 },
	{ 0xb0ab, 0x4 },
	{ 0xb0ac, 0x6c },
	{ 0xb0ad, 0xd4 },
	{ 0xb0ae, 0x1f },
	{ 0xb0af, 0x4c },
	{ 0xb0b0, 0x1f },
	{ 0xb0b1, 0x5 },
	{ 0xb0b2, 0x43 },
	{ 0xb0b3, 0x45 },
	{ 0xb0b4, 0x3 },
	{ 0xb0b5, 0x8a },
	{ 0xb0b6, 0xd8 },
	{ 0xb0b7, 0x60 },
	{ 0xb0b8, 0x0 },
	{ 0xb0b9, 0x80 },
	{ 0xb0ba, 0x39 },
	{ 0xb0bb, 0x40 },
	{ 0xb0bc, 0x13 },
	{ 0xb0bd, 0x0 },
	{ 0xb0be, 0x80 },
	{ 0xb0bf, 0xd4 },
	{ 0xb0c0, 0xb7 },
	{ 0xb0c1, 0xa6 },
	{ 0xb0c2, 0x1f },
	{ 0xb0c3, 0x8c },
	{ 0xb0c4, 0xe0 },
	{ 0xb0c5, 0x6a },
	{ 0xb0c6, 0x2c },
	{ 0xb0c7, 0x18 },
	{ 0xb0c8, 0x0 },
	{ 0xb0c9, 0x24 },
	{ 0xb0ca, 0xe7 },
	{ 0xb0cb, 0xa4 },
	{ 0xb0cc, 0x3e },
	{ 0xb0cd, 0x7 },
	{ 0xb0ce, 0x38 },
	{ 0xb0cf, 0x40 },
	{ 0xb0d0, 0x87 },
	{ 0xb0d1, 0x8 },
	{ 0xb0d2, 0x1 },
	{ 0xb0d3, 0x5f },
	{ 0xb0d4, 0x0 },
	{ 0xb0d5, 0x68 },
	{ 0xb0d6, 0xd4 },
	{ 0xb0d7, 0x15 },
	{ 0xb0d8, 0x56 },
	{ 0xb0d9, 0x1f },
	{ 0xb0da, 0x41 },
	{ 0xb0db, 0xa },
	{ 0xb0dc, 0x97 },
	{ 0xb0dd, 0xf },
	{ 0xb0de, 0xd7 },
	{ 0xb0df, 0xd8 },
	{ 0xb0e0, 0x60 },
	{ 0xb0e1, 0xc0 },
	{ 0xb0e2, 0x80 },
	{ 0xb0e3, 0x0 },
	{ 0xb0e4, 0x80 },
	{ 0xb0e5, 0x0 },
	{ 0xb0e6, 0xa0 },
	{ 0xb0e7, 0x0 },
	{ 0xb0e8, 0xc0 },
	{ 0xb0e9, 0xd4 },
	{ 0xb0ea, 0xd8 },
	{ 0xb0eb, 0xb0 },
	{ 0xb0ec, 0x1f },
	{ 0xb0ed, 0x4 },
	{ 0xb0ee, 0x6c },
	{ 0xb0ef, 0x4 },
	{ 0xb0f0, 0x8b },
	{ 0xb0f1, 0xd4 },
	{ 0xb0f2, 0xbe },
	{ 0xb0f3, 0xcc },
	{ 0xb0f4, 0x1f },
	{ 0xb0f5, 0x5 },
	{ 0xb0f6, 0x43 },
	{ 0xb0f7, 0x45 },
	{ 0xb0f8, 0x3 },
	{ 0xb0f9, 0xb0 },
	{ 0xb0fa, 0xd8 },
	{ 0xb0fb, 0x60 },
	{ 0xb0fc, 0x0 },
	{ 0xb0fd, 0x80 },
	{ 0xb0fe, 0x0 },
	{ 0xb0ff, 0x88 },
	{ 0xb100, 0xd4 },
	{ 0xb101, 0x35 },
	{ 0xb102, 0xa6 },
	{ 0xb103, 0x1f },
	{ 0xb104, 0x4 },
	{ 0xb105, 0x6a },
	{ 0xb106, 0x47 },
	{ 0xb107, 0xb2 },
	{ 0xb108, 0x0 },
	{ 0xb109, 0x47 },
	{ 0xb10a, 0xa4 },
	{ 0xb10b, 0x0 },
	{ 0xb10c, 0x2c },
	{ 0xb10d, 0x83 },
	{ 0xb10e, 0x60 },
	{ 0xb10f, 0x2e },
	{ 0xb110, 0xe3 },
	{ 0xb111, 0x5c },
	{ 0xb112, 0xc4 },
	{ 0xb113, 0xc4 },
	{ 0xb114, 0x1e },
	{ 0xb115, 0x10 },
	{ 0xb116, 0xc4 },
	{ 0xb117, 0xe4 },
	{ 0xb118, 0x9e },
	{ 0xb119, 0x10 },
	{ 0xb11a, 0x6c },
	{ 0xb11b, 0xa6 },
	{ 0xb11c, 0x18 },
	{ 0xb11d, 0x6c },
	{ 0xb11e, 0xe7 },
	{ 0xb11f, 0x8 },
	{ 0xb120, 0x60 },
	{ 0xb121, 0xc7 },
	{ 0xb122, 0x29 },
	{ 0xb123, 0x5 },
	{ 0xb124, 0x43 },
	{ 0xb125, 0xc4 },
	{ 0xb126, 0xe4 },
	{ 0xb127, 0x5e },
	{ 0xb128, 0x10 },
	{ 0xb129, 0x6c },
	{ 0xb12a, 0xe7 },
	{ 0xb12b, 0x10 },
	{ 0xb12c, 0x60 },
	{ 0xb12d, 0xe7 },
	{ 0xb12e, 0x31 },
	{ 0xb12f, 0xc4 },
	{ 0xb130, 0xc4 },
	{ 0xb131, 0xde },
	{ 0xb132, 0x10 },
	{ 0xb133, 0x60 },
	{ 0xb134, 0xe6 },
	{ 0xb135, 0x39 },
	{ 0xb136, 0x2c },
	{ 0xb137, 0xf7 },
	{ 0xb138, 0x0 },
	{ 0xb139, 0xc4 },
	{ 0xb13a, 0xe4 },
	{ 0xb13b, 0x3e },
	{ 0xb13c, 0x10 },
	{ 0xb13d, 0xc4 },
	{ 0xb13e, 0xc4 },
	{ 0xb13f, 0xbe },
	{ 0xb140, 0x10 },
	{ 0xb141, 0x6c },
	{ 0xb142, 0xe7 },
	{ 0xb143, 0x10 },
	{ 0xb144, 0x60 },
	{ 0xb145, 0xe6 },
	{ 0xb146, 0x39 },
	{ 0xb147, 0x94 },
	{ 0xb148, 0xe7 },
	{ 0xb149, 0xf },
	{ 0xb14a, 0xff },
	{ 0xb14b, 0xff },
	{ 0xb14c, 0xff },
	{ 0xb14d, 0x28 },
	{ 0xb14e, 0xf7 },
	{ 0xb14f, 0x20 },
	{ 0xb150, 0xc4 },
	{ 0xb151, 0xe4 },
	{ 0xb152, 0x6e },
	{ 0xb153, 0x10 },
	{ 0xb154, 0x20 },
	{ 0xb155, 0xf7 },
	{ 0xb156, 0x60 },
	{ 0xb157, 0x2c },
	{ 0xb158, 0xc3 },
	{ 0xb159, 0x60 },
	{ 0xb15a, 0x2c },
	{ 0xb15b, 0xe3 },
	{ 0xb15c, 0x5c },
	{ 0xb15d, 0xc4 },
	{ 0xb15e, 0xc6 },
	{ 0xb15f, 0xee },
	{ 0xb160, 0x10 },
	{ 0xb161, 0x20 },
	{ 0xb162, 0xc7 },
	{ 0xb163, 0xe0 },
	{ 0xb164, 0x2c },
	{ 0xb165, 0xc3 },
	{ 0xb166, 0x60 },
	{ 0xb167, 0x2c },
	{ 0xb168, 0xe3 },
	{ 0xb169, 0x5c },
	{ 0xb16a, 0xc4 },
	{ 0xb16b, 0xc6 },
	{ 0xb16c, 0x7e },
	{ 0xb16d, 0x10 },
	{ 0xb16e, 0x20 },
	{ 0xb16f, 0xc7 },
	{ 0xb170, 0x10 },
	{ 0xb171, 0x2c },
	{ 0xb172, 0xc3 },
	{ 0xb173, 0x60 },
	{ 0xb174, 0x2c },
	{ 0xb175, 0xe3 },
	{ 0xb176, 0x5c },
	{ 0xb177, 0xc4 },
	{ 0xb178, 0xc6 },
	{ 0xb179, 0xfe },
	{ 0xb17a, 0x10 },
	{ 0xb17b, 0x20 },
	{ 0xb17c, 0xc7 },
	{ 0xb17d, 0x90 },
	{ 0xb17e, 0x2c },
	{ 0xb17f, 0xc3 },
	{ 0xb180, 0x60 },
	{ 0xb181, 0x2c },
	{ 0xb182, 0xe3 },
	{ 0xb183, 0x5c },
	{ 0xb184, 0xc4 },
	{ 0xb185, 0xc6 },
	{ 0xb186, 0xae },
	{ 0xb187, 0x10 },
	{ 0xb188, 0x20 },
	{ 0xb189, 0xc7 },
	{ 0xb18a, 0x50 },
	{ 0xb18b, 0x2c },
	{ 0xb18c, 0xc3 },
	{ 0xb18d, 0x60 },
	{ 0xb18e, 0x2c },
	{ 0xb18f, 0xe3 },
	{ 0xb190, 0x5c },
	{ 0xb191, 0xc4 },
	{ 0xb192, 0xc6 },
	{ 0xb193, 0xce },
	{ 0xb194, 0x10 },
	{ 0xb195, 0x20 },
	{ 0xb196, 0xc7 },
	{ 0xb197, 0xd0 },
	{ 0xb198, 0x2c },
	{ 0xb199, 0xc3 },
	{ 0xb19a, 0x60 },
	{ 0xb19b, 0x2c },
	{ 0xb19c, 0xe3 },
	{ 0xb19d, 0x5c },
	{ 0xb19e, 0xc4 },
	{ 0xb19f, 0xc6 },
	{ 0xb1a0, 0x2e },
	{ 0xb1a1, 0x10 },
	{ 0xb1a2, 0x20 },
	{ 0xb1a3, 0xc7 },
	{ 0xb1a4, 0x30 },
	{ 0xb1a5, 0x8c },
	{ 0xb1a6, 0xe0 },
	{ 0xb1a7, 0x47 },
	{ 0xb1a8, 0xcc },
	{ 0xb1a9, 0x18 },
	{ 0xb1aa, 0x0 },
	{ 0xb1ab, 0x24 },
	{ 0xb1ac, 0xe7 },
	{ 0xb1ad, 0xc0 },
	{ 0xb1ae, 0x40 },
	{ 0xb1af, 0x7 },
	{ 0xb1b0, 0xa8 },
	{ 0xb1b1, 0x8c },
	{ 0xb1b2, 0xe0 },
	{ 0xb1b3, 0x6a },
	{ 0xb1b4, 0x2c },
	{ 0xb1b5, 0x18 },
	{ 0xb1b6, 0x0 },
	{ 0xb1b7, 0x2c },
	{ 0xb1b8, 0xe7 },
	{ 0xb1b9, 0x60 },
	{ 0xb1ba, 0x24 },
	{ 0xb1bb, 0xe7 },
	{ 0xb1bc, 0xc0 },
	{ 0xb1bd, 0x34 },
	{ 0xb1be, 0xe7 },
	{ 0xb1bf, 0x10 },
	{ 0xb1c0, 0x41 },
	{ 0xb1c1, 0x7 },
	{ 0xb1c2, 0x38 },
	{ 0xb1c3, 0x98 },
	{ 0xb1c4, 0x60 },
	{ 0xb1c5, 0xc0 },
	{ 0xb1c6, 0x19 },
	{ 0xb1c7, 0x4 },
	{ 0xb1c8, 0x1 },
	{ 0xb1c9, 0x0 },
	{ 0xb1ca, 0x80 },
	{ 0xb1cb, 0xd4 },
	{ 0xb1cc, 0x40 },
	{ 0xb1cd, 0x86 },
	{ 0xb1ce, 0x1f },
	{ 0xb1cf, 0x98 },
	{ 0xb1d0, 0x60 },
	{ 0xb1d1, 0xef },
	{ 0xb1d2, 0x99 },
	{ 0xb1d3, 0x4 },
	{ 0xb1d4, 0x1 },
	{ 0xb1d5, 0x38 },
	{ 0xb1d6, 0x80 },
	{ 0xb1d7, 0xff },
	{ 0xb1d8, 0xd4 },
	{ 0xb1d9, 0xaf },
	{ 0xb1da, 0x6 },
	{ 0xb1db, 0x1f },
	{ 0xb1dc, 0x8c },
	{ 0xb1dd, 0xe0 },
	{ 0xb1de, 0x47 },
	{ 0xb1df, 0xcc },
	{ 0xb1e0, 0x18 },
	{ 0xb1e1, 0x0 },
	{ 0xb1e2, 0x24 },
	{ 0xb1e3, 0xe7 },
	{ 0xb1e4, 0x40 },
	{ 0xb1e5, 0x40 },
	{ 0xb1e6, 0x7 },
	{ 0xb1e7, 0xd8 },
	{ 0xb1e8, 0x8c },
	{ 0xb1e9, 0xe0 },
	{ 0xb1ea, 0x6a },
	{ 0xb1eb, 0x2c },
	{ 0xb1ec, 0x18 },
	{ 0xb1ed, 0x0 },
	{ 0xb1ee, 0x2c },
	{ 0xb1ef, 0xe7 },
	{ 0xb1f0, 0x60 },
	{ 0xb1f1, 0x24 },
	{ 0xb1f2, 0xe7 },
	{ 0xb1f3, 0x0 },
	{ 0xb1f4, 0x6c },
	{ 0xb1f5, 0xe7 },
	{ 0xb1f6, 0x18 },
	{ 0xb1f7, 0x94 },
	{ 0xb1f8, 0xe7 },
	{ 0xb1f9, 0x0 },
	{ 0xb1fa, 0x0 },
	{ 0xb1fb, 0x0 },
	{ 0xb1fc, 0x80 },
	{ 0xb1fd, 0x41 },
	{ 0xb1fe, 0x7 },
	{ 0xb1ff, 0x58 },
	{ 0xb200, 0x98 },
	{ 0xb201, 0x60 },
	{ 0xb202, 0x80 },
	{ 0xb203, 0xa },
	{ 0xb204, 0x4 },
	{ 0xb205, 0x1 },
	{ 0xb206, 0xd4 },
	{ 0xb207, 0xfc },
	{ 0xb208, 0x86 },
	{ 0xb209, 0x1f },
	{ 0xb20a, 0x34 },
	{ 0xb20b, 0x83 },
	{ 0xb20c, 0xfe },
	{ 0xb20d, 0x98 },
	{ 0xb20e, 0x60 },
	{ 0xb20f, 0x80 },
	{ 0xb210, 0xa },
	{ 0xb211, 0x4 },
	{ 0xb212, 0x1 },
	{ 0xb213, 0xd4 },
	{ 0xb214, 0x5d },
	{ 0xb215, 0x6 },
	{ 0xb216, 0x1f },
	{ 0xb217, 0xd4 },
	{ 0xb218, 0x55 },
	{ 0xb219, 0x23 },
	{ 0xb21a, 0x1f },
	{ 0xb21b, 0x98 },
	{ 0xb21c, 0x60 },
	{ 0xb21d, 0xe0 },
	{ 0xb21e, 0x1 },
	{ 0xb21f, 0x4 },
	{ 0xb220, 0x1 },
	{ 0xb221, 0xd4 },
	{ 0xb222, 0x24 },
	{ 0xb223, 0x86 },
	{ 0xb224, 0x1f },
	{ 0xb225, 0x38 },
	{ 0xb226, 0x83 },
	{ 0xb227, 0x8 },
	{ 0xb228, 0x98 },
	{ 0xb229, 0x60 },
	{ 0xb22a, 0xe0 },
	{ 0xb22b, 0x1 },
	{ 0xb22c, 0x4 },
	{ 0xb22d, 0x1 },
	{ 0xb22e, 0x3e },
	{ 0xb22f, 0x4 },
	{ 0xb230, 0x20 },
	{ 0xb231, 0xd4 },
	{ 0xb232, 0x39 },
	{ 0xb233, 0x6 },
	{ 0xb234, 0x1f },
	{ 0xb235, 0x98 },
	{ 0xb236, 0x60 },
	{ 0xb237, 0xe0 },
	{ 0xb238, 0x1 },
	{ 0xb239, 0x4 },
	{ 0xb23a, 0x1 },
	{ 0xb23b, 0xd4 },
	{ 0xb23c, 0x50 },
	{ 0xb23d, 0x86 },
	{ 0xb23e, 0x1f },
	{ 0xb23f, 0x34 },
	{ 0xb240, 0x83 },
	{ 0xb241, 0xf7 },
	{ 0xb242, 0x98 },
	{ 0xb243, 0x60 },
	{ 0xb244, 0xe0 },
	{ 0xb245, 0x1 },
	{ 0xb246, 0x4 },
	{ 0xb247, 0x1 },
	{ 0xb248, 0xd4 },
	{ 0xb249, 0xa1 },
	{ 0xb24a, 0x6 },
	{ 0xb24b, 0x1f },
	{ 0xb24c, 0x8c },
	{ 0xb24d, 0xe0 },
	{ 0xb24e, 0x62 },
	{ 0xb24f, 0x2c },
	{ 0xb250, 0x18 },
	{ 0xb251, 0x0 },
	{ 0xb252, 0x40 },
	{ 0xb253, 0x7 },
	{ 0xb254, 0x50 },
	{ 0xb255, 0x4 },
	{ 0xb256, 0x6a },
	{ 0xb257, 0x47 },
	{ 0xb258, 0xd1 },
	{ 0xb259, 0x38 },
	{ 0xb25a, 0xe },
	{ 0xb25b, 0xec },
	{ 0xb25c, 0x24 },
	{ 0xb25d, 0xea },
	{ 0xb25e, 0x0 },
	{ 0xb25f, 0x41 },
	{ 0xb260, 0x27 },
	{ 0xb261, 0xd8 },
	{ 0xb262, 0x2c },
	{ 0xb263, 0xea },
	{ 0xb264, 0x60 },
	{ 0xb265, 0x24 },
	{ 0xb266, 0xe7 },
	{ 0xb267, 0xc0 },
	{ 0xb268, 0x34 },
	{ 0xb269, 0xe7 },
	{ 0xb26a, 0x4 },
	{ 0xb26b, 0x40 },
	{ 0xb26c, 0x7 },
	{ 0xb26d, 0xf0 },
	{ 0xb26e, 0x4 },
	{ 0xb26f, 0x6a },
	{ 0xb270, 0xd4 },
	{ 0xb271, 0xc6 },
	{ 0xb272, 0xe },
	{ 0xb273, 0x1f },
	{ 0xb274, 0x4 },
	{ 0xb275, 0x6a },
	{ 0xb276, 0xd4 },
	{ 0xb277, 0xa },
	{ 0xb278, 0x4e },
	{ 0xb279, 0x1f },
	{ 0xb27a, 0x2c },
	{ 0xb27b, 0xca },
	{ 0xb27c, 0x60 },
	{ 0xb27d, 0x24 },
	{ 0xb27e, 0xe6 },
	{ 0xb27f, 0xb7 },
	{ 0xb280, 0x3e },
	{ 0xb281, 0x7 },
	{ 0xb282, 0x39 },
	{ 0xb283, 0x42 },
	{ 0xb284, 0x7 },
	{ 0xb285, 0xe6 },
	{ 0xb286, 0xc4 },
	{ 0xb287, 0xe6 },
	{ 0xb288, 0x29 },
	{ 0xb289, 0xe0 },
	{ 0xb28a, 0x41 },
	{ 0xb28b, 0x87 },
	{ 0xb28c, 0x6 },
	{ 0xb28d, 0x20 },
	{ 0xb28e, 0xea },
	{ 0xb28f, 0x3c },
	{ 0xb290, 0x98 },
	{ 0xb291, 0x60 },
	{ 0xb292, 0x0 },
	{ 0xb293, 0xe1 },
	{ 0xb294, 0x4 },
	{ 0xb295, 0x1 },
	{ 0xb296, 0x20 },
	{ 0xb297, 0xa },
	{ 0xb298, 0xbc },
	{ 0xb299, 0xd4 },
	{ 0xb29a, 0x5c },
	{ 0xb29b, 0x6 },
	{ 0xb29c, 0x1f },
	{ 0xb29d, 0x34 },
	{ 0xb29e, 0x63 },
	{ 0xb29f, 0x80 },
	{ 0xb2a0, 0x41 },
	{ 0xb2a1, 0x3 },
	{ 0xb2a2, 0x4c },
	{ 0xb2a3, 0x98 },
	{ 0xb2a4, 0x60 },
	{ 0xb2a5, 0xce },
	{ 0xb2a6, 0x1 },
	{ 0xb2a7, 0x4 },
	{ 0xb2a8, 0x1 },
	{ 0xb2a9, 0xd4 },
	{ 0xb2aa, 0x39 },
	{ 0xb2ab, 0x6 },
	{ 0xb2ac, 0x1f },
	{ 0xb2ad, 0x34 },
	{ 0xb2ae, 0x83 },
	{ 0xb2af, 0xbf },
	{ 0xb2b0, 0x98 },
	{ 0xb2b1, 0x60 },
	{ 0xb2b2, 0xce },
	{ 0xb2b3, 0x1 },
	{ 0xb2b4, 0x4 },
	{ 0xb2b5, 0x1 },
	{ 0xb2b6, 0xd4 },
	{ 0xb2b7, 0xe8 },
	{ 0xb2b8, 0x6 },
	{ 0xb2b9, 0x1f },
	{ 0xb2ba, 0x98 },
	{ 0xb2bb, 0x60 },
	{ 0xb2bc, 0xc1 },
	{ 0xb2bd, 0x1 },
	{ 0xb2be, 0x4 },
	{ 0xb2bf, 0x1 },
	{ 0xb2c0, 0xd4 },
	{ 0xb2c1, 0xa1 },
	{ 0xb2c2, 0x6 },
	{ 0xb2c3, 0x1f },
	{ 0xb2c4, 0x38 },
	{ 0xb2c5, 0x83 },
	{ 0xb2c6, 0x20 },
	{ 0xb2c7, 0x3e },
	{ 0xb2c8, 0x4 },
	{ 0xb2c9, 0x20 },
	{ 0xb2ca, 0x98 },
	{ 0xb2cb, 0x60 },
	{ 0xb2cc, 0xc1 },
	{ 0xb2cd, 0x1 },
	{ 0xb2ce, 0x4 },
	{ 0xb2cf, 0x1 },
	{ 0xb2d0, 0xd },
	{ 0xb2d1, 0xa0 },
	{ 0xb2d2, 0x0 },
	{ 0xb2d3, 0xec },
	{ 0xb2d4, 0x20 },
	{ 0xb2d5, 0xea },
	{ 0xb2d6, 0x7c },
	{ 0xb2d7, 0x98 },
	{ 0xb2d8, 0x60 },
	{ 0xb2d9, 0xb4 },
	{ 0xb2da, 0xb5 },
	{ 0xb2db, 0x4 },
	{ 0xb2dc, 0x1 },
	{ 0xb2dd, 0x24 },
	{ 0xb2de, 0x8a },
	{ 0xb2df, 0x7c },
	{ 0xb2e0, 0x34 },
	{ 0xb2e1, 0x84 },
	{ 0xb2e2, 0xf },
	{ 0xb2e3, 0x38 },
	{ 0xb2e4, 0x84 },
	{ 0xb2e5, 0x30 },
	{ 0xb2e6, 0xd4 },
	{ 0xb2e7, 0xe7 },
	{ 0xb2e8, 0xfa },
	{ 0xb2e9, 0x1f },
	{ 0xb2ea, 0x2c },
	{ 0xb2eb, 0xea },
	{ 0xb2ec, 0x60 },
	{ 0xb2ed, 0x24 },
	{ 0xb2ee, 0xe7 },
	{ 0xb2ef, 0x80 },
	{ 0xb2f0, 0x6c },
	{ 0xb2f1, 0xe7 },
	{ 0xb2f2, 0x8 },
	{ 0xb2f3, 0x94 },
	{ 0xb2f4, 0xe7 },
	{ 0xb2f5, 0x0 },
	{ 0xb2f6, 0x0 },
	{ 0xb2f7, 0x80 },
	{ 0xb2f8, 0x0 },
	{ 0xb2f9, 0x40 },
	{ 0xb2fa, 0x7 },
	{ 0xb2fb, 0xb0 },
	{ 0xb2fc, 0x0 },
	{ 0xb2fd, 0x64 },
	{ 0xb2fe, 0x0 },
	{ 0xb2ff, 0x80 },
	{ 0xb300, 0xd4 },
	{ 0xb301, 0x49 },
	{ 0xb302, 0x26 },
	{ 0xb303, 0x1f },
	{ 0xb304, 0xc },
	{ 0xb305, 0x40 },
	{ 0xb306, 0x4 },
	{ 0xb307, 0x6a },
	{ 0xb308, 0xd4 },
	{ 0xb309, 0xc3 },
	{ 0xb30a, 0x56 },
	{ 0xb30b, 0x1f },
	{ 0xb30c, 0x98 },
	{ 0xb30d, 0x60 },
	{ 0xb30e, 0xa0 },
	{ 0xb30f, 0x1 },
	{ 0xb310, 0x4 },
	{ 0xb311, 0x1 },
	{ 0xb312, 0xd4 },
	{ 0xb313, 0xcc },
	{ 0xb314, 0x6 },
	{ 0xb315, 0x1f },
	{ 0xb316, 0x34 },
	{ 0xb317, 0x83 },
	{ 0xb318, 0xbf },
	{ 0xb319, 0x98 },
	{ 0xb31a, 0x60 },
	{ 0xb31b, 0xa0 },
	{ 0xb31c, 0x1 },
	{ 0xb31d, 0x4 },
	{ 0xb31e, 0x1 },
	{ 0xb31f, 0xd4 },
	{ 0xb320, 0x75 },
	{ 0xb321, 0xfa },
	{ 0xb322, 0x1f },
	{ 0xb323, 0x2c },
	{ 0xb324, 0xea },
	{ 0xb325, 0x60 },
	{ 0xb326, 0x4 },
	{ 0xb327, 0x6a },
	{ 0xb328, 0xc0 },
	{ 0xb329, 0x7 },
	{ 0xb32a, 0x29 },
	{ 0xb32b, 0xe0 },
	{ 0xb32c, 0x0 },
	{ 0xb32d, 0x88 },
	{ 0xb32e, 0xd4 },
	{ 0xb32f, 0xd8 },
	{ 0xb330, 0x96 },
	{ 0xb331, 0x1f },
	{ 0xb332, 0x0 },
	{ 0xb333, 0xec },
	{ 0xb334, 0x20 },
	{ 0xb335, 0xea },
	{ 0xb336, 0x0 },
	{ 0xb337, 0x47 },
	{ 0xb338, 0xb4 },
	{ 0xb339, 0x0 },
	{ 0xb33a, 0x8c },
	{ 0xb33b, 0xe0 },
	{ 0xb33c, 0x6a },
	{ 0xb33d, 0x2c },
	{ 0xb33e, 0x18 },
	{ 0xb33f, 0x0 },
	{ 0xb340, 0x47 },
	{ 0xb341, 0xa8 },
	{ 0xb342, 0x80 },
	{ 0xb343, 0x2c },
	{ 0xb344, 0xc7 },
	{ 0xb345, 0x60 },
	{ 0xb346, 0x24 },
	{ 0xb347, 0xe6 },
	{ 0xb348, 0x40 },
	{ 0xb349, 0x6c },
	{ 0xb34a, 0xe7 },
	{ 0xb34b, 0xe1 },
	{ 0xb34c, 0x40 },
	{ 0xb34d, 0x7 },
	{ 0xb34e, 0xd4 },
	{ 0xb34f, 0x24 },
	{ 0xb350, 0xe6 },
	{ 0xb351, 0x34 },
	{ 0xb352, 0x98 },
	{ 0xb353, 0x60 },
	{ 0xb354, 0xe0 },
	{ 0xb355, 0x80 },
	{ 0xb356, 0x4 },
	{ 0xb357, 0x1 },
	{ 0xb358, 0x34 },
	{ 0xb359, 0xe7 },
	{ 0xb35a, 0x2 },
	{ 0xb35b, 0x0 },
	{ 0xb35c, 0x88 },
	{ 0xb35d, 0xd0 },
	{ 0xb35e, 0x40 },
	{ 0xb35f, 0x76 },
	{ 0xb360, 0x58 },
	{ 0xb361, 0xd4 },
	{ 0xb362, 0xf5 },
	{ 0xb363, 0x6 },
	{ 0xb364, 0x1f },
	{ 0xb365, 0x98 },
	{ 0xb366, 0x60 },
	{ 0xb367, 0x18 },
	{ 0xb368, 0x1 },
	{ 0xb369, 0x4 },
	{ 0xb36a, 0x1 },
	{ 0xb36b, 0x98 },
	{ 0xb36c, 0x80 },
	{ 0xb36d, 0x0 },
	{ 0xb36e, 0x8 },
	{ 0xb36f, 0x0 },
	{ 0xb370, 0x3 },
	{ 0xb371, 0xd4 },
	{ 0xb372, 0x9f },
	{ 0xb373, 0x7a },
	{ 0xb374, 0x1f },
	{ 0xb375, 0xc },
	{ 0xb376, 0x0 },
	{ 0xb377, 0x98 },
	{ 0xb378, 0x60 },
	{ 0xb379, 0x0 },
	{ 0xb37a, 0xe1 },
	{ 0xb37b, 0x4 },
	{ 0xb37c, 0x1 },
	{ 0xb37d, 0xd4 },
	{ 0xb37e, 0x6a },
	{ 0xb37f, 0xfa },
	{ 0xb380, 0x1f },
	{ 0xb381, 0x34 },
	{ 0xb382, 0x63 },
	{ 0xb383, 0x80 },
	{ 0xb384, 0x41 },
	{ 0xb385, 0x3 },
	{ 0xb386, 0x94 },
	{ 0xb387, 0x98 },
	{ 0xb388, 0x60 },
	{ 0xb389, 0x85 },
	{ 0xb38a, 0x1 },
	{ 0xb38b, 0x4 },
	{ 0xb38c, 0x1 },
	{ 0xb38d, 0xd4 },
	{ 0xb38e, 0x1d },
	{ 0xb38f, 0xfa },
	{ 0xb390, 0x1f },
	{ 0xb391, 0x34 },
	{ 0xb392, 0x63 },
	{ 0xb393, 0xc0 },
	{ 0xb394, 0x40 },
	{ 0xb395, 0x3 },
	{ 0xb396, 0x70 },
	{ 0xb397, 0x98 },
	{ 0xb398, 0x60 },
	{ 0xb399, 0x85 },
	{ 0xb39a, 0x1 },
	{ 0xb39b, 0x4 },
	{ 0xb39c, 0x1 },
	{ 0xb39d, 0x38 },
	{ 0xb39e, 0x80 },
	{ 0xb39f, 0xff },
	{ 0xb3a0, 0xc },
	{ 0xb3a1, 0xf0 },
	{ 0xb3a2, 0x98 },
	{ 0xb3a3, 0x60 },
	{ 0xb3a4, 0x85 },
	{ 0xb3a5, 0x1 },
	{ 0xb3a6, 0x4 },
	{ 0xb3a7, 0x1 },
	{ 0xb3a8, 0x38 },
	{ 0xb3a9, 0x80 },
	{ 0xb3aa, 0x3f },
	{ 0xb3ab, 0xe },
	{ 0xb3ac, 0x30 },
	{ 0xb3ad, 0x98 },
	{ 0xb3ae, 0x60 },
	{ 0xb3af, 0xf4 },
	{ 0xb3b0, 0xb5 },
	{ 0xb3b1, 0x4 },
	{ 0xb3b2, 0x1 },
	{ 0xb3b3, 0x38 },
	{ 0xb3b4, 0x80 },
	{ 0xb3b5, 0x9c },
	{ 0xb3b6, 0xd4 },
	{ 0xb3b7, 0xe8 },
	{ 0xb3b8, 0xfa },
	{ 0xb3b9, 0x1f },
	{ 0xb3ba, 0x98 },
	{ 0xb3bb, 0x60 },
	{ 0xb3bc, 0x85 },
	{ 0xb3bd, 0x1 },
	{ 0xb3be, 0x4 },
	{ 0xb3bf, 0x1 },
	{ 0xb3c0, 0xd4 },
	{ 0xb3c1, 0xa1 },
	{ 0xb3c2, 0xfa },
	{ 0xb3c3, 0x1f },
	{ 0xb3c4, 0x34 },
	{ 0xb3c5, 0x63 },
	{ 0xb3c6, 0xc0 },
	{ 0xb3c7, 0x40 },
	{ 0xb3c8, 0x3 },
	{ 0xb3c9, 0xb0 },
	{ 0xb3ca, 0x98 },
	{ 0xb3cb, 0x60 },
	{ 0xb3cc, 0x85 },
	{ 0xb3cd, 0x1 },
	{ 0xb3ce, 0x4 },
	{ 0xb3cf, 0x1 },
	{ 0xb3d0, 0x0 },
	{ 0xb3d1, 0x8c },
	{ 0xb3d2, 0xd },
	{ 0xb3d3, 0x40 },
	{ 0xb3d4, 0x98 },
	{ 0xb3d5, 0x60 },
	{ 0xb3d6, 0x85 },
	{ 0xb3d7, 0x1 },
	{ 0xb3d8, 0x4 },
	{ 0xb3d9, 0x1 },
	{ 0xb3da, 0x0 },
	{ 0xb3db, 0x80 },
	{ 0xb3dc, 0xd4 },
	{ 0xb3dd, 0x8f },
	{ 0xb3de, 0x7a },
	{ 0xb3df, 0x1f },
	{ 0xb3e0, 0x98 },
	{ 0xb3e1, 0x60 },
	{ 0xb3e2, 0x10 },
	{ 0xb3e3, 0x1 },
	{ 0xb3e4, 0x4 },
	{ 0xb3e5, 0x1 },
	{ 0xb3e6, 0x0 },
	{ 0xb3e7, 0x80 },
	{ 0xb3e8, 0xd4 },
	{ 0xb3e9, 0xa7 },
	{ 0xb3ea, 0x7a },
	{ 0xb3eb, 0x1f },
	{ 0xb3ec, 0x98 },
	{ 0xb3ed, 0x60 },
	{ 0xb3ee, 0xd0 },
	{ 0xb3ef, 0x1 },
	{ 0xb3f0, 0x4 },
	{ 0xb3f1, 0x1 },
	{ 0xb3f2, 0x0 },
	{ 0xb3f3, 0x80 },
	{ 0xb3f4, 0xd4 },
	{ 0xb3f5, 0x9b },
	{ 0xb3f6, 0x7a },
	{ 0xb3f7, 0x1f },
	{ 0xb3f8, 0x98 },
	{ 0xb3f9, 0x60 },
	{ 0xb3fa, 0x3 },
	{ 0xb3fb, 0x1 },
	{ 0xb3fc, 0x4 },
	{ 0xb3fd, 0x1 },
	{ 0xb3fe, 0x0 },
	{ 0xb3ff, 0x80 },
	{ 0xb400, 0xd4 },
	{ 0xb401, 0xb3 },
	{ 0xb402, 0x7a },
	{ 0xb403, 0x1f },
	{ 0xb404, 0x98 },
	{ 0xb405, 0x60 },
	{ 0xb406, 0x10 },
	{ 0xb407, 0x75 },
	{ 0xb408, 0x4 },
	{ 0xb409, 0x1 },
	{ 0xb40a, 0x0 },
	{ 0xb40b, 0x80 },
	{ 0xb40c, 0xd4 },
	{ 0xb40d, 0x83 },
	{ 0xb40e, 0x7a },
	{ 0xb40f, 0x1f },
	{ 0xb410, 0x98 },
	{ 0xb411, 0x60 },
	{ 0xb412, 0x5 },
	{ 0xb413, 0x1 },
	{ 0xb414, 0x4 },
	{ 0xb415, 0x1 },
	{ 0xb416, 0x38 },
	{ 0xb417, 0x80 },
	{ 0xb418, 0xef },
	{ 0xb419, 0xd4 },
	{ 0xb41a, 0x2d },
	{ 0xb41b, 0x7a },
	{ 0xb41c, 0x1f },
	{ 0xb41d, 0x98 },
	{ 0xb41e, 0x60 },
	{ 0xb41f, 0x45 },
	{ 0xb420, 0x1 },
	{ 0xb421, 0x4 },
	{ 0xb422, 0x1 },
	{ 0xb423, 0x0 },
	{ 0xb424, 0x8c },
	{ 0xb425, 0xd4 },
	{ 0xb426, 0x15 },
	{ 0xb427, 0x7a },
	{ 0xb428, 0x1f },
	{ 0xb429, 0x98 },
	{ 0xb42a, 0x60 },
	{ 0xb42b, 0x0 },
	{ 0xb42c, 0x25 },
	{ 0xb42d, 0x4 },
	{ 0xb42e, 0x1 },
	{ 0xb42f, 0x0 },
	{ 0xb430, 0x80 },
	{ 0xb431, 0xd4 },
	{ 0xb432, 0x39 },
	{ 0xb433, 0x7a },
	{ 0xb434, 0x1f },
	{ 0xb435, 0x8c },
	{ 0xb436, 0xe0 },
	{ 0xb437, 0x6a },
	{ 0xb438, 0x2c },
	{ 0xb439, 0x18 },
	{ 0xb43a, 0x0 },
	{ 0xb43b, 0x2c },
	{ 0xb43c, 0xe7 },
	{ 0xb43d, 0x60 },
	{ 0xb43e, 0x24 },
	{ 0xb43f, 0xe7 },
	{ 0xb440, 0x80 },
	{ 0xb441, 0x6c },
	{ 0xb442, 0xe7 },
	{ 0xb443, 0x8 },
	{ 0xb444, 0x94 },
	{ 0xb445, 0xe7 },
	{ 0xb446, 0x0 },
	{ 0xb447, 0x0 },
	{ 0xb448, 0x20 },
	{ 0xb449, 0x0 },
	{ 0xb44a, 0x40 },
	{ 0xb44b, 0x7 },
	{ 0xb44c, 0x96 },
	{ 0xb44d, 0x98 },
	{ 0xb44e, 0x60 },
	{ 0xb44f, 0x86 },
	{ 0xb450, 0x1 },
	{ 0xb451, 0x4 },
	{ 0xb452, 0x1 },
	{ 0xb453, 0x38 },
	{ 0xb454, 0x80 },
	{ 0xb455, 0x11 },
	{ 0xb456, 0xd4 },
	{ 0xb457, 0xee },
	{ 0xb458, 0x7a },
	{ 0xb459, 0x1f },
	{ 0xb45a, 0x8c },
	{ 0xb45b, 0xe0 },
	{ 0xb45c, 0x6a },
	{ 0xb45d, 0x2c },
	{ 0xb45e, 0x18 },
	{ 0xb45f, 0x0 },
	{ 0xb460, 0x98 },
	{ 0xb461, 0x60 },
	{ 0xb462, 0x56 },
	{ 0xb463, 0x1 },
	{ 0xb464, 0x4 },
	{ 0xb465, 0x1 },
	{ 0xb466, 0x2c },
	{ 0xb467, 0xa7 },
	{ 0xb468, 0x60 },
	{ 0xb469, 0x24 },
	{ 0xb46a, 0xe5 },
	{ 0xb46b, 0x8 },
	{ 0xb46c, 0x24 },
	{ 0xb46d, 0x85 },
	{ 0xb46e, 0x88 },
	{ 0xb46f, 0x6c },
	{ 0xb470, 0xc7 },
	{ 0xb471, 0x18 },
	{ 0xb472, 0x6c },
	{ 0xb473, 0x84 },
	{ 0xb474, 0x8 },
	{ 0xb475, 0x60 },
	{ 0xb476, 0xe4 },
	{ 0xb477, 0x31 },
	{ 0xb478, 0x24 },
	{ 0xb479, 0x85 },
	{ 0xb47a, 0x48 },
	{ 0xb47b, 0x6c },
	{ 0xb47c, 0x84 },
	{ 0xb47d, 0x10 },
	{ 0xb47e, 0x60 },
	{ 0xb47f, 0x84 },
	{ 0xb480, 0x39 },
	{ 0xb481, 0x24 },
	{ 0xb482, 0xe5 },
	{ 0xb483, 0xc8 },
	{ 0xb484, 0x60 },
	{ 0xb485, 0x87 },
	{ 0xb486, 0x21 },
	{ 0xb487, 0x6c },
	{ 0xb488, 0x84 },
	{ 0xb489, 0xc1 },
	{ 0xb48a, 0x98 },
	{ 0xb48b, 0xe0 },
	{ 0xb48c, 0x2 },
	{ 0xb48d, 0x42 },
	{ 0xb48e, 0xf0 },
	{ 0xb48f, 0x0 },
	{ 0xb490, 0x64 },
	{ 0xb491, 0x84 },
	{ 0xb492, 0x3d },
	{ 0xb493, 0x3e },
	{ 0xb494, 0x4 },
	{ 0xb495, 0x20 },
	{ 0xb496, 0xd4 },
	{ 0xb497, 0xec },
	{ 0xb498, 0x7a },
	{ 0xb499, 0x1f },
	{ 0xb49a, 0x98 },
	{ 0xb49b, 0x60 },
	{ 0xb49c, 0x0 },
	{ 0xb49d, 0xc0 },
	{ 0xb49e, 0x4 },
	{ 0xb49f, 0x1 },
	{ 0xb4a0, 0x38 },
	{ 0xb4a1, 0x80 },
	{ 0xb4a2, 0x7c },
	{ 0xb4a3, 0xd4 },
	{ 0xb4a4, 0x54 },
	{ 0xb4a5, 0x7a },
	{ 0xb4a6, 0x1f },
	{ 0xb4a7, 0x98 },
	{ 0xb4a8, 0x60 },
	{ 0xb4a9, 0x4 },
	{ 0xb4aa, 0xc0 },
	{ 0xb4ab, 0x4 },
	{ 0xb4ac, 0x1 },
	{ 0xb4ad, 0x0 },
	{ 0xb4ae, 0x86 },
	{ 0xb4af, 0xd4 },
	{ 0xb4b0, 0x78 },
	{ 0xb4b1, 0x7a },
	{ 0xb4b2, 0x1f },
	{ 0xb4b3, 0x98 },
	{ 0xb4b4, 0x60 },
	{ 0xb4b5, 0xea },
	{ 0xb4b6, 0x1 },
	{ 0xb4b7, 0x4 },
	{ 0xb4b8, 0x1 },
	{ 0xb4b9, 0xd4 },
	{ 0xb4ba, 0x31 },
	{ 0xb4bb, 0x7a },
	{ 0xb4bc, 0x1f },
	{ 0xb4bd, 0x98 },
	{ 0xb4be, 0x83 },
	{ 0xb4bf, 0x1 },
	{ 0xb4c0, 0xff },
	{ 0xb4c1, 0xff },
	{ 0xb4c2, 0xff },
	{ 0xb4c3, 0x98 },
	{ 0xb4c4, 0x60 },
	{ 0xb4c5, 0xea },
	{ 0xb4c6, 0x1 },
	{ 0xb4c7, 0x4 },
	{ 0xb4c8, 0x1 },
	{ 0xb4c9, 0x3e },
	{ 0xb4ca, 0x4 },
	{ 0xb4cb, 0x20 },
	{ 0xb4cc, 0xd4 },
	{ 0xb4cd, 0x80 },
	{ 0xb4ce, 0x7a },
	{ 0xb4cf, 0x1f },
	{ 0xb4d0, 0x98 },
	{ 0xb4d1, 0x60 },
	{ 0xb4d2, 0xfa },
	{ 0xb4d3, 0x1 },
	{ 0xb4d4, 0x4 },
	{ 0xb4d5, 0x1 },
	{ 0xb4d6, 0xd4 },
	{ 0xb4d7, 0xf6 },
	{ 0xb4d8, 0x7a },
	{ 0xb4d9, 0x1f },
	{ 0xb4da, 0x98 },
	{ 0xb4db, 0x83 },
	{ 0xb4dc, 0x1 },
	{ 0xb4dd, 0xff },
	{ 0xb4de, 0xff },
	{ 0xb4df, 0xff },
	{ 0xb4e0, 0x98 },
	{ 0xb4e1, 0x60 },
	{ 0xb4e2, 0xfa },
	{ 0xb4e3, 0x1 },
	{ 0xb4e4, 0x4 },
	{ 0xb4e5, 0x1 },
	{ 0xb4e6, 0x3e },
	{ 0xb4e7, 0x4 },
	{ 0xb4e8, 0x20 },
	{ 0xb4e9, 0xd4 },
	{ 0xb4ea, 0x27 },
	{ 0xb4eb, 0xba },
	{ 0xb4ec, 0x1f },
	{ 0xb4ed, 0x98 },
	{ 0xb4ee, 0x60 },
	{ 0xb4ef, 0xb0 },
	{ 0xb4f0, 0x5 },
	{ 0xb4f1, 0x4 },
	{ 0xb4f2, 0x1 },
	{ 0xb4f3, 0xd4 },
	{ 0xb4f4, 0x4a },
	{ 0xb4f5, 0x7a },
	{ 0xb4f6, 0x1f },
	{ 0xb4f7, 0x38 },
	{ 0xb4f8, 0x83 },
	{ 0xb4f9, 0x80 },
	{ 0xb4fa, 0x98 },
	{ 0xb4fb, 0x60 },
	{ 0xb4fc, 0xb0 },
	{ 0xb4fd, 0x5 },
	{ 0xb4fe, 0x4 },
	{ 0xb4ff, 0x1 },
	{ 0xb500, 0x3e },
	{ 0xb501, 0x4 },
	{ 0xb502, 0x20 },
	{ 0xb503, 0x47 },
	{ 0xb504, 0xc8 },
	{ 0xb505, 0x80 },
	{ 0xb506, 0xd5 },
	{ 0xb507, 0xe3 },
	{ 0xb508, 0xba },
	{ 0xb509, 0x1f },
	{ 0xb50a, 0x47 },
	{ 0xb50b, 0xa8 },
	{ 0xb50c, 0x80 },
	{ 0xb50d, 0x4a },
	{ 0xb50e, 0xe4 },
	{ 0xb50f, 0xa0 },
	{ 0xb510, 0x49 },
	{ 0xb511, 0x64 },
	{ 0xb512, 0x40 },
	{ 0xb513, 0x48 },
	{ 0xb514, 0x1c },
	{ 0xb515, 0x40 },
	{ 0xb516, 0x49 },
	{ 0xb517, 0x70 },
	{ 0xb518, 0xa0 },
	{ 0xb519, 0x49 },
	{ 0xb51a, 0xc4 },
	{ 0xb51b, 0xa0 },
	{ 0xb51c, 0x47 },
	{ 0xb51d, 0xc8 },
	{ 0xb51e, 0x80 },
	{ 0xb51f, 0x46 },
	{ 0xb520, 0xe1 },
	{ 0xb521, 0x68 },
	{ 0xb522, 0x47 },
	{ 0xb523, 0xa7 },
	{ 0xb524, 0x40 },
	{ 0xb525, 0x6 },
	{ 0xb526, 0x87 },
	{ 0xb527, 0x98 },
	{ 0xb528, 0xe0 },
	{ 0xb529, 0x44 },
	{ 0xb52a, 0x0 },
	{ 0xb52b, 0x80 },
	{ 0xb52c, 0x0 },
	{ 0xb52d, 0x5 },
	{ 0xb52e, 0xa3 },
	{ 0xb52f, 0x8c },
	{ 0xb530, 0xe0 },
	{ 0xb531, 0x1b },
	{ 0xb532, 0xa2 },
	{ 0xb533, 0x18 },
	{ 0xb534, 0x0 },
	{ 0xb535, 0x5 },
	{ 0xb536, 0x44 },
	{ 0xb537, 0xc4 },
	{ 0xb538, 0xe5 },
	{ 0xb539, 0x22 },
	{ 0xb53a, 0x80 },
	{ 0xb53b, 0x6 },
	{ 0xb53c, 0x65 },
	{ 0xb53d, 0x6 },
	{ 0xb53e, 0x26 },
	{ 0xb53f, 0x6 },
	{ 0xb540, 0x48 },
	{ 0xb541, 0x41 },
	{ 0xb542, 0x7 },
	{ 0xb543, 0x90 },
	{ 0xb544, 0x24 },
	{ 0xb545, 0xe5 },
	{ 0xb546, 0x5 },
	{ 0xb547, 0x40 },
	{ 0xb548, 0x7 },
	{ 0xb549, 0x28 },
	{ 0xb54a, 0xd8 },
	{ 0xb54b, 0xed },
	{ 0xb54c, 0x35 },
	{ 0xb54d, 0x0 },
	{ 0xb54e, 0x6c },
	{ 0xb54f, 0xe7 },
	{ 0xb550, 0x80 },
	{ 0xb551, 0x8 },
	{ 0xb552, 0xf4 },
	{ 0xb553, 0x29 },
	{ 0xb554, 0x87 },
	{ 0xb555, 0x80 },
	{ 0xb556, 0x6d },
	{ 0xb557, 0x8c },
	{ 0xb558, 0x10 },
	{ 0xb559, 0xf },
	{ 0xb55a, 0x60 },
	{ 0xb55b, 0x30 },
	{ 0xb55c, 0xe3 },
	{ 0xb55d, 0x10 },
	{ 0xb55e, 0x6c },
	{ 0xb55f, 0xe7 },
	{ 0xb560, 0x40 },
	{ 0xb561, 0x8 },
	{ 0xb562, 0xf4 },
	{ 0xb563, 0x6c },
	{ 0xb564, 0xc3 },
	{ 0xb565, 0x40 },
	{ 0xb566, 0x8 },
	{ 0xb567, 0xd4 },
	{ 0xb568, 0x2d },
	{ 0xb569, 0x87 },
	{ 0xb56a, 0x60 },
	{ 0xb56b, 0x6c },
	{ 0xb56c, 0xec },
	{ 0xb56d, 0x20 },
	{ 0xb56e, 0x29 },
	{ 0xb56f, 0x86 },
	{ 0xb570, 0x81 },
	{ 0xb571, 0x65 },
	{ 0xb572, 0x87 },
	{ 0xb573, 0x65 },
	{ 0xb574, 0x0 },
	{ 0xb575, 0x88 },
	{ 0xb576, 0x6e },
	{ 0xb577, 0xd },
	{ 0xb578, 0x80 },
	{ 0xb579, 0x61 },
	{ 0xb57a, 0x74 },
	{ 0xb57b, 0x84 },
	{ 0xb57c, 0x98 },
	{ 0xb57d, 0xa0 },
	{ 0xb57e, 0xff },
	{ 0xb57f, 0xff },
	{ 0xb580, 0x0 },
	{ 0xb581, 0x0 },
	{ 0xb582, 0x28 },
	{ 0xb583, 0x6b },
	{ 0xb584, 0xeb },
	{ 0xb585, 0xd4 },
	{ 0xb586, 0xb4 },
	{ 0xb587, 0xa3 },
	{ 0xb588, 0x1f },
	{ 0xb589, 0x98 },
	{ 0xb58a, 0xa0 },
	{ 0xb58b, 0xff },
	{ 0xb58c, 0xff },
	{ 0xb58d, 0x0 },
	{ 0xb58e, 0x0 },
	{ 0xb58f, 0x5 },
	{ 0xb590, 0xc3 },
	{ 0xb591, 0x0 },
	{ 0xb592, 0x88 },
	{ 0xb593, 0x4 },
	{ 0xb594, 0x6a },
	{ 0xb595, 0xd4 },
	{ 0xb596, 0xb8 },
	{ 0xb597, 0xa3 },
	{ 0xb598, 0x1f },
	{ 0xb599, 0xc4 },
	{ 0xb59a, 0xf3 },
	{ 0xb59b, 0xf2 },
	{ 0xb59c, 0x80 },
	{ 0xb59d, 0x5 },
	{ 0xb59e, 0xe3 },
	{ 0xb59f, 0xc8 },
	{ 0xb5a0, 0x6b },
	{ 0xb5a1, 0xfa },
	{ 0xb5a2, 0x80 },
	{ 0xb5a3, 0x0 },
	{ 0xb5a4, 0xf3 },
	{ 0xb5a5, 0x60 },
	{ 0xb5a6, 0x63 },
	{ 0xb5a7, 0x3e },
	{ 0xb5a8, 0x0 },
	{ 0xb5a9, 0x88 },
	{ 0xb5aa, 0x0 },
	{ 0xb5ab, 0xaf },
	{ 0xb5ac, 0xd4 },
	{ 0xb5ad, 0x60 },
	{ 0xb5ae, 0xa3 },
	{ 0xb5af, 0x1f },
	{ 0xb5b0, 0xc4 },
	{ 0xb5b1, 0xf3 },
	{ 0xb5b2, 0xf2 },
	{ 0xb5b3, 0x80 },
	{ 0xb5b4, 0x6 },
	{ 0xb5b5, 0xa3 },
	{ 0xb5b6, 0x28 },
	{ 0xb5b7, 0x6b },
	{ 0xb5b8, 0xd3 },
	{ 0xb5b9, 0x0 },
	{ 0xb5ba, 0xf3 },
	{ 0xb5bb, 0x60 },
	{ 0xb5bc, 0x63 },
	{ 0xb5bd, 0x3e },
	{ 0xb5be, 0x4 },
	{ 0xb5bf, 0x95 },
	{ 0xb5c0, 0x0 },
	{ 0xb5c1, 0xaf },
	{ 0xb5c2, 0xd4 },
	{ 0xb5c3, 0xf },
	{ 0xb5c4, 0x23 },
	{ 0xb5c5, 0x1f },
	{ 0xb5c6, 0x24 },
	{ 0xb5c7, 0xf3 },
	{ 0xb5c8, 0x65 },
	{ 0xb5c9, 0x6 },
	{ 0xb5ca, 0xc3 },
	{ 0xb5cb, 0x95 },
	{ 0xb5cc, 0xce },
	{ 0xb5cd, 0xff },
	{ 0xb5ce, 0xff },
	{ 0xb5cf, 0x0 },
	{ 0xb5d0, 0x0 },
	{ 0xb5d1, 0x95 },
	{ 0xb5d2, 0xef },
	{ 0xb5d3, 0xff },
	{ 0xb5d4, 0xff },
	{ 0xb5d5, 0x0 },
	{ 0xb5d6, 0x0 },
	{ 0xb5d7, 0x40 },
	{ 0xb5d8, 0x7 },
	{ 0xb5d9, 0x6 },
	{ 0xb5da, 0xc4 },
	{ 0xb5db, 0xd3 },
	{ 0xb5dc, 0xf2 },
	{ 0xb5dd, 0x80 },
	{ 0xb5de, 0x38 },
	{ 0xb5df, 0xe0 },
	{ 0xb5e0, 0x8 },
	{ 0xb5e1, 0x60 },
	{ 0xb5e2, 0xcc },
	{ 0xb5e3, 0x36 },
	{ 0xb5e4, 0x64 },
	{ 0xb5e5, 0xc6 },
	{ 0xb5e6, 0x75 },
	{ 0xb5e7, 0x4 },
	{ 0xb5e8, 0x95 },
	{ 0xb5e9, 0x64 },
	{ 0xb5ea, 0x66 },
	{ 0xb5eb, 0x7d },
	{ 0xb5ec, 0x28 },
	{ 0xb5ed, 0xeb },
	{ 0xb5ee, 0x1e },
	{ 0xb5ef, 0x6c },
	{ 0xb5f0, 0x63 },
	{ 0xb5f1, 0x21 },
	{ 0xb5f2, 0x98 },
	{ 0xb5f3, 0xa0 },
	{ 0xb5f4, 0xff },
	{ 0xb5f5, 0xff },
	{ 0xb5f6, 0x0 },
	{ 0xb5f7, 0x0 },
	{ 0xb5f8, 0xd4 },
	{ 0xb5f9, 0x5d },
	{ 0xb5fa, 0x23 },
	{ 0xb5fb, 0x1f },
	{ 0xb5fc, 0x5 },
	{ 0xb5fd, 0x43 },
	{ 0xb5fe, 0xd3 },
	{ 0xb5ff, 0xac },
	{ 0xb600, 0x3f },
	{ 0xb601, 0x80 },
	{ 0xb602, 0x24 },
	{ 0xb603, 0xf3 },
	{ 0xb604, 0xe5 },
	{ 0xb605, 0x40 },
	{ 0xb606, 0x7 },
	{ 0xb607, 0x68 },
	{ 0xb608, 0x6c },
	{ 0xb609, 0x63 },
	{ 0xb60a, 0x20 },
	{ 0xb60b, 0x64 },
	{ 0xb60c, 0x63 },
	{ 0xb60d, 0xb5 },
	{ 0xb60e, 0x28 },
	{ 0xb60f, 0xab },
	{ 0xb610, 0x8b },
	{ 0xb611, 0x38 },
	{ 0xb612, 0x80 },
	{ 0xb613, 0x8 },
	{ 0xb614, 0xd4 },
	{ 0xb615, 0x79 },
	{ 0xb616, 0x23 },
	{ 0xb617, 0x1f },
	{ 0xb618, 0x28 },
	{ 0xb619, 0x6b },
	{ 0xb61a, 0x1e },
	{ 0xb61b, 0x5 },
	{ 0xb61c, 0x56 },
	{ 0xb61d, 0x64 },
	{ 0xb61e, 0xcf },
	{ 0xb61f, 0x73 },
	{ 0xb620, 0x29 },
	{ 0xb621, 0x4b },
	{ 0xb622, 0x55 },
	{ 0xb623, 0x64 },
	{ 0xb624, 0xa6 },
	{ 0xb625, 0x53 },
	{ 0xb626, 0xc4 },
	{ 0xb627, 0xd3 },
	{ 0xb628, 0xf2 },
	{ 0xb629, 0x80 },
	{ 0xb62a, 0x0 },
	{ 0xb62b, 0xd8 },
	{ 0xb62c, 0x60 },
	{ 0xb62d, 0xc5 },
	{ 0xb62e, 0x37 },
	{ 0xb62f, 0x6c },
	{ 0xb630, 0xc6 },
	{ 0xb631, 0xc1 },
	{ 0xb632, 0x28 },
	{ 0xb633, 0xd2 },
	{ 0xb634, 0x0 },
	{ 0xb635, 0xf },
	{ 0xb636, 0x28 },
	{ 0xb637, 0x24 },
	{ 0xb638, 0xf3 },
	{ 0xb639, 0xe5 },
	{ 0xb63a, 0x2a },
	{ 0xb63b, 0xab },
	{ 0xb63c, 0x55 },
	{ 0xb63d, 0x40 },
	{ 0xb63e, 0x7 },
	{ 0xb63f, 0x8c },
	{ 0xb640, 0xc5 },
	{ 0xb641, 0x53 },
	{ 0xb642, 0xf2 },
	{ 0xb643, 0x80 },
	{ 0xb644, 0x28 },
	{ 0xb645, 0xab },
	{ 0xb646, 0x8b },
	{ 0xb647, 0x61 },
	{ 0xb648, 0x4c },
	{ 0xb649, 0x56 },
	{ 0xb64a, 0x65 },
	{ 0xb64b, 0x4a },
	{ 0xb64c, 0x75 },
	{ 0xb64d, 0x65 },
	{ 0xb64e, 0x4a },
	{ 0xb64f, 0x7d },
	{ 0xb650, 0x6d },
	{ 0xb651, 0x4a },
	{ 0xb652, 0x21 },
	{ 0xb653, 0x6c },
	{ 0xb654, 0x6a },
	{ 0xb655, 0x20 },
	{ 0xb656, 0x64 },
	{ 0xb657, 0x63 },
	{ 0xb658, 0xad },
	{ 0xb659, 0x38 },
	{ 0xb65a, 0x80 },
	{ 0xb65b, 0x8 },
	{ 0xb65c, 0xd4 },
	{ 0xb65d, 0x6a },
	{ 0xb65e, 0x23 },
	{ 0xb65f, 0x1f },
	{ 0xb660, 0x3e },
	{ 0xb661, 0xc },
	{ 0xb662, 0x3a },
	{ 0xb663, 0x28 },
	{ 0xb664, 0x6b },
	{ 0xb665, 0x1e },
	{ 0xb666, 0x6c },
	{ 0xb667, 0xe7 },
	{ 0xb668, 0x11 },
	{ 0xb669, 0x28 },
	{ 0xb66a, 0xf2 },
	{ 0xb66b, 0x0 },
	{ 0xb66c, 0xc },
	{ 0xb66d, 0xe0 },
	{ 0xb66e, 0x38 },
	{ 0xb66f, 0xe0 },
	{ 0xb670, 0x8 },
	{ 0xb671, 0x1 },
	{ 0xb672, 0x48 },
	{ 0xb673, 0x28 },
	{ 0xb674, 0xeb },
	{ 0xb675, 0x1e },
	{ 0xb676, 0x64 },
	{ 0xb677, 0xee },
	{ 0xb678, 0x7b },
	{ 0xb679, 0x64 },
	{ 0xb67a, 0xc7 },
	{ 0xb67b, 0xab },
	{ 0xb67c, 0xc4 },
	{ 0xb67d, 0xf3 },
	{ 0xb67e, 0xf2 },
	{ 0xb67f, 0x80 },
	{ 0xb680, 0x0 },
	{ 0xb681, 0xf2 },
	{ 0xb682, 0x60 },
	{ 0xb683, 0xe6 },
	{ 0xb684, 0x3f },
	{ 0xb685, 0x28 },
	{ 0xb686, 0xf2 },
	{ 0xb687, 0x0 },
	{ 0xb688, 0xc4 },
	{ 0xb689, 0xf3 },
	{ 0xb68a, 0xf2 },
	{ 0xb68b, 0x80 },
	{ 0xb68c, 0x28 },
	{ 0xb68d, 0xab },
	{ 0xb68e, 0xd5 },
	{ 0xb68f, 0x0 },
	{ 0xb690, 0xf3 },
	{ 0xb691, 0xa },
	{ 0xb692, 0x13 },
	{ 0xb693, 0x64 },
	{ 0xb694, 0xe5 },
	{ 0xb695, 0x38 },
	{ 0xb696, 0x28 },
	{ 0xb697, 0xf0 },
	{ 0xb698, 0x5d },
	{ 0xb699, 0x29 },
	{ 0xb69a, 0xb },
	{ 0xb69b, 0x9e },
	{ 0xb69c, 0x29 },
	{ 0xb69d, 0x10 },
	{ 0xb69e, 0x3 },
	{ 0xb69f, 0x2c },
	{ 0xb6a0, 0xf1 },
	{ 0xb6a1, 0x58 },
	{ 0xb6a2, 0x9d },
	{ 0xb6a3, 0xc7 },
	{ 0xb6a4, 0x54 },
	{ 0xb6a5, 0x0 },
	{ 0xb6a6, 0x80 },
	{ 0xb6a7, 0x0 },
	{ 0xb6a8, 0x47 },
	{ 0xb6a9, 0x2c },
	{ 0xb6aa, 0x80 },
	{ 0xb6ab, 0x98 },
	{ 0xb6ac, 0x60 },
	{ 0xb6ad, 0xac },
	{ 0xb6ae, 0xb8 },
	{ 0xb6af, 0x18 },
	{ 0xb6b0, 0x0 },
	{ 0xb6b1, 0x4 },
	{ 0xb6b2, 0x8d },
	{ 0xb6b3, 0x4 },
	{ 0xb6b4, 0xd5 },
	{ 0xb6b5, 0x4 },
	{ 0xb6b6, 0xf6 },
	{ 0xb6b7, 0xd4 },
	{ 0xb6b8, 0xc2 },
	{ 0xb6b9, 0x2 },
	{ 0xb6ba, 0x1f },
	{ 0xb6bb, 0x2c },
	{ 0xb6bc, 0xf1 },
	{ 0xb6bd, 0x58 },
	{ 0xb6be, 0x9d },
	{ 0xb6bf, 0xc7 },
	{ 0xb6c0, 0xd4 },
	{ 0xb6c1, 0x0 },
	{ 0xb6c2, 0x80 },
	{ 0xb6c3, 0x0 },
	{ 0xb6c4, 0x47 },
	{ 0xb6c5, 0x2d },
	{ 0xb6c6, 0x80 },
	{ 0xb6c7, 0x28 },
	{ 0xb6c8, 0xab },
	{ 0xb6c9, 0xd5 },
	{ 0xb6ca, 0x98 },
	{ 0xb6cb, 0x60 },
	{ 0xb6cc, 0x90 },
	{ 0xb6cd, 0xb8 },
	{ 0xb6ce, 0x18 },
	{ 0xb6cf, 0x0 },
	{ 0xb6d0, 0x4 },
	{ 0xb6d1, 0x8d },
	{ 0xb6d2, 0x2d },
	{ 0xb6d3, 0x41 },
	{ 0xb6d4, 0x0 },
	{ 0xb6d5, 0x4 },
	{ 0xb6d6, 0xcc },
	{ 0xb6d7, 0x4 },
	{ 0xb6d8, 0xef },
	{ 0xb6d9, 0x5 },
	{ 0xb6da, 0xe },
	{ 0xb6db, 0xd4 },
	{ 0xb6dc, 0xf8 },
	{ 0xb6dd, 0x2 },
	{ 0xb6de, 0x1f },
	{ 0xb6df, 0x41 },
	{ 0xb6e0, 0xd },
	{ 0xb6e1, 0x64 },
	{ 0xb6e2, 0x2c },
	{ 0xb6e3, 0xf1 },
	{ 0xb6e4, 0x58 },
	{ 0xb6e5, 0x9d },
	{ 0xb6e6, 0xc7 },
	{ 0xb6e7, 0x27 },
	{ 0xb6e8, 0x0 },
	{ 0xb6e9, 0x80 },
	{ 0xb6ea, 0x0 },
	{ 0xb6eb, 0x47 },
	{ 0xb6ec, 0x2a },
	{ 0xb6ed, 0x20 },
	{ 0xb6ee, 0x28 },
	{ 0xb6ef, 0x94 },
	{ 0xb6f0, 0xbb },
	{ 0xb6f1, 0x98 },
	{ 0xb6f2, 0x60 },
	{ 0xb6f3, 0xa7 },
	{ 0xb6f4, 0x38 },
	{ 0xb6f5, 0x18 },
	{ 0xb6f6, 0x0 },
	{ 0xb6f7, 0x3e },
	{ 0xb6f8, 0x4 },
	{ 0xb6f9, 0x23 },
	{ 0xb6fa, 0x2c },
	{ 0xb6fb, 0xb4 },
	{ 0xb6fc, 0x64 },
	{ 0xb6fd, 0x28 },
	{ 0xb6fe, 0xd4 },
	{ 0xb6ff, 0x81 },
	{ 0xb700, 0x28 },
	{ 0xb701, 0xf4 },
	{ 0xb702, 0xb1 },
	{ 0xb703, 0xd },
	{ 0xb704, 0x90 },
	{ 0xb705, 0x41 },
	{ 0xb706, 0x8d },
	{ 0xb707, 0xd4 },
	{ 0xb708, 0x2c },
	{ 0xb709, 0xf1 },
	{ 0xb70a, 0x58 },
	{ 0xb70b, 0x9d },
	{ 0xb70c, 0xc7 },
	{ 0xb70d, 0xa7 },
	{ 0xb70e, 0x0 },
	{ 0xb70f, 0x80 },
	{ 0xb710, 0x0 },
	{ 0xb711, 0x47 },
	{ 0xb712, 0x2f },
	{ 0xb713, 0x80 },
	{ 0xb714, 0x28 },
	{ 0xb715, 0x94 },
	{ 0xb716, 0xfb },
	{ 0xb717, 0x2c },
	{ 0xb718, 0xb4 },
	{ 0xb719, 0x54 },
	{ 0xb71a, 0x28 },
	{ 0xb71b, 0xd4 },
	{ 0xb71c, 0xa1 },
	{ 0xb71d, 0x28 },
	{ 0xb71e, 0xf4 },
	{ 0xb71f, 0x89 },
	{ 0xb720, 0x98 },
	{ 0xb721, 0x60 },
	{ 0xb722, 0x83 },
	{ 0xb723, 0x38 },
	{ 0xb724, 0x18 },
	{ 0xb725, 0x0 },
	{ 0xb726, 0x3e },
	{ 0xb727, 0x4 },
	{ 0xb728, 0x23 },
	{ 0xb729, 0x47 },
	{ 0xb72a, 0xc7 },
	{ 0xb72b, 0x40 },
	{ 0xb72c, 0xd5 },
	{ 0xb72d, 0x73 },
	{ 0xb72e, 0xfc },
	{ 0xb72f, 0x1f },
	{ 0xb730, 0x47 },
	{ 0xb731, 0xb7 },
	{ 0xb732, 0x40 },
	{ 0xb733, 0x47 },
	{ 0xb734, 0xa9 },
	{ 0xb735, 0xc0 },
	{ 0xb736, 0x6e },
	{ 0xb737, 0x3 },
	{ 0xb738, 0x80 },
	{ 0xb739, 0x61 },
	{ 0xb73a, 0x86 },
	{ 0xb73b, 0x84 },
	{ 0xb73c, 0x5 },
	{ 0xb73d, 0x63 },
	{ 0xb73e, 0x28 },
	{ 0xb73f, 0x6c },
	{ 0xb740, 0xeb },
	{ 0xb741, 0x98 },
	{ 0xb742, 0xe0 },
	{ 0xb743, 0x84 },
	{ 0xb744, 0x0 },
	{ 0xb745, 0x80 },
	{ 0xb746, 0x0 },
	{ 0xb747, 0x5 },
	{ 0xb748, 0xc5 },
	{ 0xb749, 0x98 },
	{ 0xb74a, 0xa0 },
	{ 0xb74b, 0xff },
	{ 0xb74c, 0xff },
	{ 0xb74d, 0x0 },
	{ 0xb74e, 0x0 },
	{ 0xb74f, 0x5 },
	{ 0xb750, 0xe4 },
	{ 0xb751, 0x8c },
	{ 0xb752, 0xe0 },
	{ 0xb753, 0x1b },
	{ 0xb754, 0xa2 },
	{ 0xb755, 0x18 },
	{ 0xb756, 0x0 },
	{ 0xb757, 0x6 },
	{ 0xb758, 0x26 },
	{ 0xb759, 0x0 },
	{ 0xb75a, 0x88 },
	{ 0xb75b, 0xd4 },
	{ 0xb75c, 0xea },
	{ 0xb75d, 0xc3 },
	{ 0xb75e, 0x1f },
	{ 0xb75f, 0x5 },
	{ 0xb760, 0x43 },
	{ 0xb761, 0xc8 },
	{ 0xb762, 0x6c },
	{ 0xb763, 0xfa },
	{ 0xb764, 0x80 },
	{ 0xb765, 0x98 },
	{ 0xb766, 0xa0 },
	{ 0xb767, 0xff },
	{ 0xb768, 0xff },
	{ 0xb769, 0x0 },
	{ 0xb76a, 0x0 },
	{ 0xb76b, 0x0 },
	{ 0xb76c, 0x88 },
	{ 0xb76d, 0xd4 },
	{ 0xb76e, 0xa2 },
	{ 0xb76f, 0xc3 },
	{ 0xb770, 0x1f },
	{ 0xb771, 0xc8 },
	{ 0xb772, 0x6c },
	{ 0xb773, 0x7a },
	{ 0xb774, 0x80 },
	{ 0xb775, 0xc4 },
	{ 0xb776, 0xef },
	{ 0xb777, 0x22 },
	{ 0xb778, 0x80 },
	{ 0xb779, 0x41 },
	{ 0xb77a, 0x7 },
	{ 0xb77b, 0x90 },
	{ 0xb77c, 0x24 },
	{ 0xb77d, 0xef },
	{ 0xb77e, 0x5 },
	{ 0xb77f, 0x40 },
	{ 0xb780, 0x7 },
	{ 0xb781, 0x30 },
	{ 0xb782, 0xc9 },
	{ 0xb783, 0xac },
	{ 0xb784, 0x9a },
	{ 0xb785, 0x80 },
	{ 0xb786, 0x6d },
	{ 0xb787, 0xad },
	{ 0xb788, 0x20 },
	{ 0xb789, 0xc },
	{ 0xb78a, 0x60 },
	{ 0xb78b, 0x30 },
	{ 0xb78c, 0xeb },
	{ 0xb78d, 0x10 },
	{ 0xb78e, 0x6c },
	{ 0xb78f, 0xe7 },
	{ 0xb790, 0x40 },
	{ 0xb791, 0x6c },
	{ 0xb792, 0xcb },
	{ 0xb793, 0x40 },
	{ 0xb794, 0x8 },
	{ 0xb795, 0xf1 },
	{ 0xb796, 0x8 },
	{ 0xb797, 0xd1 },
	{ 0xb798, 0x28 },
	{ 0xb799, 0xc6 },
	{ 0xb79a, 0x81 },
	{ 0xb79b, 0x2d },
	{ 0xb79c, 0xa7 },
	{ 0xb79d, 0x60 },
	{ 0xb79e, 0x65 },
	{ 0xb79f, 0xad },
	{ 0xb7a0, 0x35 },
	{ 0xb7a1, 0x2c },
	{ 0xb7a2, 0xee },
	{ 0xb7a3, 0x58 },
	{ 0xb7a4, 0x9d },
	{ 0xb7a5, 0xc7 },
	{ 0xb7a6, 0x92 },
	{ 0xb7a7, 0x0 },
	{ 0xb7a8, 0x80 },
	{ 0xb7a9, 0x0 },
	{ 0xb7aa, 0x47 },
	{ 0xb7ab, 0x28 },
	{ 0xb7ac, 0x80 },
	{ 0xb7ad, 0x98 },
	{ 0xb7ae, 0x60 },
	{ 0xb7af, 0xd3 },
	{ 0xb7b0, 0xb8 },
	{ 0xb7b1, 0x18 },
	{ 0xb7b2, 0x0 },
	{ 0xb7b3, 0x4 },
	{ 0xb7b4, 0x8b },
	{ 0xb7b5, 0x4 },
	{ 0xb7b6, 0xad },
	{ 0xb7b7, 0xd4 },
	{ 0xb7b8, 0xc2 },
	{ 0xb7b9, 0xfc },
	{ 0xb7ba, 0x1f },
	{ 0xb7bb, 0x95 },
	{ 0xb7bc, 0x4a },
	{ 0xb7bd, 0xff },
	{ 0xb7be, 0xff },
	{ 0xb7bf, 0x0 },
	{ 0xb7c0, 0x0 },
	{ 0xb7c1, 0x65 },
	{ 0xb7c2, 0x4d },
	{ 0xb7c3, 0x55 },
	{ 0xb7c4, 0xc8 },
	{ 0xb7c5, 0xec },
	{ 0xb7c6, 0xfa },
	{ 0xb7c7, 0x80 },
	{ 0xb7c8, 0x6d },
	{ 0xb7c9, 0x4a },
	{ 0xb7ca, 0x20 },
	{ 0xb7cb, 0x64 },
	{ 0xb7cc, 0x6a },
	{ 0xb7cd, 0x3d },
	{ 0xb7ce, 0xa },
	{ 0xb7cf, 0xf },
	{ 0xb7d0, 0x28 },
	{ 0xb7d1, 0xac },
	{ 0xb7d2, 0xa3 },
	{ 0xb7d3, 0x28 },
	{ 0xb7d4, 0x90 },
	{ 0xb7d5, 0x9b },
	{ 0xb7d6, 0x28 },
	{ 0xb7d7, 0x61 },
	{ 0xb7d8, 0x60 },
	{ 0xb7d9, 0x3e },
	{ 0xb7da, 0x3 },
	{ 0xb7db, 0x1a },
	{ 0xb7dc, 0xd4 },
	{ 0xb7dd, 0x6b },
	{ 0xb7de, 0x43 },
	{ 0xb7df, 0x1f },
	{ 0xb7e0, 0x2c },
	{ 0xb7e1, 0xee },
	{ 0xb7e2, 0x58 },
	{ 0xb7e3, 0x28 },
	{ 0xb7e4, 0x61 },
	{ 0xb7e5, 0x60 },
	{ 0xb7e6, 0x4 },
	{ 0xb7e7, 0xa3 },
	{ 0xb7e8, 0x9d },
	{ 0xb7e9, 0xc7 },
	{ 0xb7ea, 0x2 },
	{ 0xb7eb, 0x0 },
	{ 0xb7ec, 0x80 },
	{ 0xb7ed, 0x0 },
	{ 0xb7ee, 0x47 },
	{ 0xb7ef, 0x24 },
	{ 0xb7f0, 0x80 },
	{ 0xb7f1, 0x98 },
	{ 0xb7f2, 0x60 },
	{ 0xb7f3, 0xdd },
	{ 0xb7f4, 0xb8 },
	{ 0xb7f5, 0x18 },
	{ 0xb7f6, 0x0 },
	{ 0xb7f7, 0x4 },
	{ 0xb7f8, 0x8b },
	{ 0xb7f9, 0x3e },
	{ 0xb7fa, 0x5 },
	{ 0xb7fb, 0x2a },
	{ 0xb7fc, 0xd4 },
	{ 0xb7fd, 0x7f },
	{ 0xb7fe, 0x7c },
	{ 0xb7ff, 0x1f },
	{ 0xb800, 0x3e },
	{ 0xb801, 0xb },
	{ 0xb802, 0x3c },
	{ 0xb803, 0x0 },
	{ 0xb804, 0xff },
	{ 0xb805, 0x42 },
	{ 0xb806, 0x7 },
	{ 0xb807, 0x68 },
	{ 0xb808, 0x24 },
	{ 0xb809, 0xef },
	{ 0xb80a, 0x48 },
	{ 0xb80b, 0x40 },
	{ 0xb80c, 0x7 },
	{ 0xb80d, 0x8 },
	{ 0xb80e, 0x30 },
	{ 0xb80f, 0xc1 },
	{ 0xb810, 0x60 },
	{ 0xb811, 0x4 },
	{ 0xb812, 0x6f },
	{ 0xb813, 0x4 },
	{ 0xb814, 0x8e },
	{ 0xb815, 0x4 },
	{ 0xb816, 0xb1 },
	{ 0xb817, 0xd4 },
	{ 0xb818, 0x10 },
	{ 0xb819, 0x44 },
	{ 0xb81a, 0x9f },
	{ 0xb81b, 0x28 },
	{ 0xb81c, 0xe1 },
	{ 0xb81d, 0xe0 },
	{ 0xb81e, 0x28 },
	{ 0xb81f, 0xf0 },
	{ 0xb820, 0x2d },
	{ 0xb821, 0x2c },
	{ 0xb822, 0xee },
	{ 0xb823, 0x58 },
	{ 0xb824, 0x9d },
	{ 0xb825, 0xc7 },
	{ 0xb826, 0x82 },
	{ 0xb827, 0x0 },
	{ 0xb828, 0x80 },
	{ 0xb829, 0x0 },
	{ 0xb82a, 0x47 },
	{ 0xb82b, 0x20 },
	{ 0xb82c, 0x80 },
	{ 0xb82d, 0x28 },
	{ 0xb82e, 0x8f },
	{ 0xb82f, 0xad },
	{ 0xb830, 0x98 },
	{ 0xb831, 0x60 },
	{ 0xb832, 0x95 },
	{ 0xb833, 0xb8 },
	{ 0xb834, 0x18 },
	{ 0xb835, 0x0 },
	{ 0xb836, 0xd4 },
	{ 0xb837, 0x23 },
	{ 0xb838, 0x7c },
	{ 0xb839, 0x1f },
	{ 0xb83a, 0x2c },
	{ 0xb83b, 0xee },
	{ 0xb83c, 0x58 },
	{ 0xb83d, 0x9d },
	{ 0xb83e, 0xc7 },
	{ 0xb83f, 0x9c },
	{ 0xb840, 0x0 },
	{ 0xb841, 0x80 },
	{ 0xb842, 0x0 },
	{ 0xb843, 0x47 },
	{ 0xb844, 0x24 },
	{ 0xb845, 0x80 },
	{ 0xb846, 0x28 },
	{ 0xb847, 0xa1 },
	{ 0xb848, 0xe0 },
	{ 0xb849, 0x98 },
	{ 0xb84a, 0x60 },
	{ 0xb84b, 0x49 },
	{ 0xb84c, 0xb8 },
	{ 0xb84d, 0x18 },
	{ 0xb84e, 0x0 },
	{ 0xb84f, 0x4 },
	{ 0xb850, 0x8b },
	{ 0xb851, 0xd4 },
	{ 0xb852, 0x95 },
	{ 0xb853, 0x7c },
	{ 0xb854, 0x1f },
	{ 0xb855, 0x30 },
	{ 0xb856, 0x61 },
	{ 0xb857, 0x60 },
	{ 0xb858, 0xd4 },
	{ 0xb859, 0xa8 },
	{ 0xb85a, 0x1c },
	{ 0xb85b, 0x9f },
	{ 0xb85c, 0x28 },
	{ 0xb85d, 0x6c },
	{ 0xb85e, 0x25 },
	{ 0xb85f, 0x2c },
	{ 0xb860, 0xee },
	{ 0xb861, 0x58 },
	{ 0xb862, 0x9d },
	{ 0xb863, 0xc7 },
	{ 0xb864, 0x94 },
	{ 0xb865, 0x0 },
	{ 0xb866, 0x80 },
	{ 0xb867, 0x0 },
	{ 0xb868, 0x47 },
	{ 0xb869, 0x22 },
	{ 0xb86a, 0x80 },
	{ 0xb86b, 0x28 },
	{ 0xb86c, 0xc1 },
	{ 0xb86d, 0xe0 },
	{ 0xb86e, 0x98 },
	{ 0xb86f, 0x60 },
	{ 0xb870, 0x2e },
	{ 0xb871, 0xb8 },
	{ 0xb872, 0x18 },
	{ 0xb873, 0x0 },
	{ 0xb874, 0x4 },
	{ 0xb875, 0x8b },
	{ 0xb876, 0x4 },
	{ 0xb877, 0xad },
	{ 0xb878, 0xd4 },
	{ 0xb879, 0x41 },
	{ 0xb87a, 0x7c },
	{ 0xb87b, 0x1f },
	{ 0xb87c, 0x2c },
	{ 0xb87d, 0xee },
	{ 0xb87e, 0x58 },
	{ 0xb87f, 0x9d },
	{ 0xb880, 0xc7 },
	{ 0xb881, 0x1c },
	{ 0xb882, 0x0 },
	{ 0xb883, 0x80 },
	{ 0xb884, 0x0 },
	{ 0xb885, 0x47 },
	{ 0xb886, 0x24 },
	{ 0xb887, 0x80 },
	{ 0xb888, 0x28 },
	{ 0xb889, 0xac },
	{ 0xb88a, 0xa5 },
	{ 0xb88b, 0x98 },
	{ 0xb88c, 0x60 },
	{ 0xb88d, 0xba },
	{ 0xb88e, 0xb8 },
	{ 0xb88f, 0x18 },
	{ 0xb890, 0x0 },
	{ 0xb891, 0x4 },
	{ 0xb892, 0x8b },
	{ 0xb893, 0xd4 },
	{ 0xb894, 0xe6 },
	{ 0xb895, 0x7c },
	{ 0xb896, 0x1f },
	{ 0xb897, 0x28 },
	{ 0xb898, 0x61 },
	{ 0xb899, 0xe0 },
	{ 0xb89a, 0x47 },
	{ 0xb89b, 0xb9 },
	{ 0xb89c, 0xc0 },
	{ 0xb89d, 0x98 },
	{ 0xb89e, 0xe0 },
	{ 0xb89f, 0x64 },
	{ 0xb8a0, 0x0 },
	{ 0xb8a1, 0x80 },
	{ 0xb8a2, 0x0 },
	{ 0xb8a3, 0x47 },
	{ 0xb8a4, 0xae },
	{ 0xb8a5, 0x80 },
	{ 0xb8a6, 0x8c },
	{ 0xb8a7, 0xe0 },
	{ 0xb8a8, 0x1b },
	{ 0xb8a9, 0xa2 },
	{ 0xb8aa, 0x18 },
	{ 0xb8ab, 0x0 },
	{ 0xb8ac, 0x5 },
	{ 0xb8ad, 0x85 },
	{ 0xb8ae, 0x5 },
	{ 0xb8af, 0x63 },
	{ 0xb8b0, 0x5 },
	{ 0xb8b1, 0x44 },
	{ 0xb8b2, 0xd4 },
	{ 0xb8b3, 0xde },
	{ 0xb8b4, 0xb4 },
	{ 0xb8b5, 0x9f },
	{ 0xb8b6, 0x4 },
	{ 0xb8b7, 0x8a },
	{ 0xb8b8, 0x5 },
	{ 0xb8b9, 0xc3 },
	{ 0xb8ba, 0x4 },
	{ 0xb8bb, 0xac },
	{ 0xb8bc, 0x4 },
	{ 0xb8bd, 0xce },
	{ 0xb8be, 0x4 },
	{ 0xb8bf, 0x6b },
	{ 0xb8c0, 0xd4 },
	{ 0xb8c1, 0xa0 },
	{ 0xb8c2, 0x74 },
	{ 0xb8c3, 0x9f },
	{ 0xb8c4, 0x28 },
	{ 0xb8c5, 0xea },
	{ 0xb8c6, 0xa0 },
	{ 0xb8c7, 0xc8 },
	{ 0xb8c8, 0x6b },
	{ 0xb8c9, 0xfa },
	{ 0xb8ca, 0x80 },
	{ 0xb8cb, 0x8 },
	{ 0xb8cc, 0xee },
	{ 0xb8cd, 0x98 },
	{ 0xb8ce, 0x63 },
	{ 0xb8cf, 0x0 },
	{ 0xb8d0, 0x0 },
	{ 0xb8d1, 0x4 },
	{ 0xb8d2, 0x1 },
	{ 0xb8d3, 0x29 },
	{ 0xb8d4, 0xec },
	{ 0xb8d5, 0xb9 },
	{ 0xb8d6, 0x29 },
	{ 0xb8d7, 0xcc },
	{ 0xb8d8, 0x59 },
	{ 0xb8d9, 0x28 },
	{ 0xb8da, 0xec },
	{ 0xb8db, 0x39 },
	{ 0xb8dc, 0xd4 },
	{ 0xb8dd, 0x96 },
	{ 0xb8de, 0x5a },
	{ 0xb8df, 0x1f },
	{ 0xb8e0, 0x5 },
	{ 0xb8e1, 0xa3 },
	{ 0xb8e2, 0xc8 },
	{ 0xb8e3, 0x6b },
	{ 0xb8e4, 0x86 },
	{ 0xb8e5, 0x80 },
	{ 0xb8e6, 0x6d },
	{ 0xb8e7, 0xad },
	{ 0xb8e8, 0x10 },
	{ 0xb8e9, 0x98 },
	{ 0xb8ea, 0x63 },
	{ 0xb8eb, 0x0 },
	{ 0xb8ec, 0x0 },
	{ 0xb8ed, 0x4 },
	{ 0xb8ee, 0x1 },
	{ 0xb8ef, 0xd4 },
	{ 0xb8f0, 0x6a },
	{ 0xb8f1, 0x5a },
	{ 0xb8f2, 0x1f },
	{ 0xb8f3, 0x61 },
	{ 0xb8f4, 0xa3 },
	{ 0xb8f5, 0x69 },
	{ 0xb8f6, 0x3e },
	{ 0xb8f7, 0xd },
	{ 0xb8f8, 0x3a },
	{ 0xb8f9, 0xd2 },
	{ 0xb8fa, 0x9e },
	{ 0xb8fb, 0x7b },
	{ 0xb8fc, 0x60 },
	{ 0xb8fd, 0xd4 },
	{ 0xb8fe, 0x48 },
	{ 0xb8ff, 0xa3 },
	{ 0xb900, 0x1f },
	{ 0xb901, 0x9d },
	{ 0xb902, 0xc3 },
	{ 0xb903, 0x42 },
	{ 0xb904, 0x0 },
	{ 0xb905, 0x80 },
	{ 0xb906, 0x0 },
	{ 0xb907, 0x47 },
	{ 0xb908, 0x2b },
	{ 0xb909, 0x0 },
	{ 0xb90a, 0x98 },
	{ 0xb90b, 0x60 },
	{ 0xb90c, 0xc1 },
	{ 0xb90d, 0x38 },
	{ 0xb90e, 0x18 },
	{ 0xb90f, 0x0 },
	{ 0xb910, 0xd4 },
	{ 0xb911, 0x57 },
	{ 0xb912, 0xbc },
	{ 0xb913, 0x1f },
	{ 0xb914, 0x0 },
	{ 0xb915, 0xe4 },
	{ 0xb916, 0x20 },
	{ 0xb917, 0xeb },
	{ 0xb918, 0x98 },
	{ 0xb919, 0x29 },
	{ 0xb91a, 0xaa },
	{ 0xb91b, 0x20 },
	{ 0xb91c, 0x24 },
	{ 0xb91d, 0xeb },
	{ 0xb91e, 0x14 },
	{ 0xb91f, 0x41 },
	{ 0xb920, 0x7 },
	{ 0xb921, 0xe2 },
	{ 0xb922, 0x24 },
	{ 0xb923, 0xca },
	{ 0xb924, 0xf8 },
	{ 0xb925, 0x8c },
	{ 0xb926, 0xe0 },
	{ 0xb927, 0x4a },
	{ 0xb928, 0xa2 },
	{ 0xb929, 0x18 },
	{ 0xb92a, 0x0 },
	{ 0xb92b, 0x41 },
	{ 0xb92c, 0x86 },
	{ 0xb92d, 0x4 },
	{ 0xb92e, 0xc4 },
	{ 0xb92f, 0x87 },
	{ 0xb930, 0x17 },
	{ 0xb931, 0x80 },
	{ 0xb932, 0x28 },
	{ 0xb933, 0xc7 },
	{ 0xb934, 0xa0 },
	{ 0xb935, 0x60 },
	{ 0xb936, 0xc6 },
	{ 0xb937, 0x25 },
	{ 0xb938, 0xc8 },
	{ 0xb939, 0x87 },
	{ 0xb93a, 0xd6 },
	{ 0xb93b, 0x80 },
	{ 0xb93c, 0x60 },
	{ 0xb93d, 0x86 },
	{ 0xb93e, 0x25 },
	{ 0xb93f, 0x28 },
	{ 0xb940, 0x8b },
	{ 0xb941, 0x63 },
	{ 0xb942, 0xc8 },
	{ 0xb943, 0xe7 },
	{ 0xb944, 0xe6 },
	{ 0xb945, 0x80 },
	{ 0xb946, 0x28 },
	{ 0xb947, 0xeb },
	{ 0xb948, 0x13 },
	{ 0xb949, 0xe },
	{ 0xb94a, 0xe0 },
	{ 0xb94b, 0xc4 },
	{ 0xb94c, 0xc7 },
	{ 0xb94d, 0x17 },
	{ 0xb94e, 0x80 },
	{ 0xb94f, 0x28 },
	{ 0xb950, 0x87 },
	{ 0xb951, 0xa0 },
	{ 0xb952, 0x60 },
	{ 0xb953, 0x84 },
	{ 0xb954, 0x35 },
	{ 0xb955, 0xc8 },
	{ 0xb956, 0xc7 },
	{ 0xb957, 0x96 },
	{ 0xb958, 0x80 },
	{ 0xb959, 0xc8 },
	{ 0xb95a, 0xe7 },
	{ 0xb95b, 0xd6 },
	{ 0xb95c, 0x80 },
	{ 0xb95d, 0x60 },
	{ 0xb95e, 0x84 },
	{ 0xb95f, 0x35 },
	{ 0xb960, 0x60 },
	{ 0xb961, 0xe4 },
	{ 0xb962, 0x3d },
	{ 0xb963, 0x28 },
	{ 0xb964, 0xeb },
	{ 0xb965, 0x63 },
	{ 0xb966, 0x28 },
	{ 0xb967, 0x8c },
	{ 0xb968, 0xb9 },
	{ 0xb969, 0x38 },
	{ 0xb96a, 0x60 },
	{ 0xb96b, 0x30 },
	{ 0xb96c, 0x0 },
	{ 0xb96d, 0xa0 },
	{ 0xb96e, 0xd4 },
	{ 0xb96f, 0x8d },
	{ 0xb970, 0xa0 },
	{ 0xb971, 0x1f },
	{ 0xb972, 0x42 },
	{ 0xb973, 0x3 },
	{ 0xb974, 0xd0 },
	{ 0xb975, 0x4 },
	{ 0xb976, 0x6a },
	{ 0xb977, 0x0 },
	{ 0xb978, 0x8c },
	{ 0xb979, 0xd4 },
	{ 0xb97a, 0x78 },
	{ 0xb97b, 0x75 },
	{ 0xb97c, 0x1f },
	{ 0xb97d, 0x2c },
	{ 0xb97e, 0xea },
	{ 0xb97f, 0x42 },
	{ 0xb980, 0x28 },
	{ 0xb981, 0x8c },
	{ 0xb982, 0xb9 },
	{ 0xb983, 0x28 },
	{ 0xb984, 0x87 },
	{ 0xb985, 0x7c },
	{ 0xb986, 0x2c },
	{ 0xb987, 0xea },
	{ 0xb988, 0x58 },
	{ 0xb989, 0x9d },
	{ 0xb98a, 0xc7 },
	{ 0xb98b, 0xb4 },
	{ 0xb98c, 0x0 },
	{ 0xb98d, 0x80 },
	{ 0xb98e, 0x0 },
	{ 0xb98f, 0x47 },
	{ 0xb990, 0x2a },
	{ 0xb991, 0x80 },
	{ 0xb992, 0x28 },
	{ 0xb993, 0xca },
	{ 0xb994, 0xa0 },
	{ 0xb995, 0x98 },
	{ 0xb996, 0x60 },
	{ 0xb997, 0x6 },
	{ 0xb998, 0x38 },
	{ 0xb999, 0x18 },
	{ 0xb99a, 0x0 },
	{ 0xb99b, 0x4 },
	{ 0xb99c, 0xae },
	{ 0xb99d, 0x47 },
	{ 0xb99e, 0xce },
	{ 0xb99f, 0x80 },
	{ 0xb9a0, 0xd5 },
	{ 0xb9a1, 0x5a },
	{ 0xb9a2, 0xbc },
	{ 0xb9a3, 0x1f },
	{ 0xb9a4, 0x47 },
	{ 0xb9a5, 0xbe },
	{ 0xb9a6, 0x80 },
	{ 0xb9a7, 0x47 },
	{ 0xb9a8, 0xae },
	{ 0xb9a9, 0x80 },
	{ 0xb9aa, 0x5 },
	{ 0xb9ab, 0x87 },
	{ 0xb9ac, 0x98 },
	{ 0xb9ad, 0xe0 },
	{ 0xb9ae, 0x90 },
	{ 0xb9af, 0x0 },
	{ 0xb9b0, 0x80 },
	{ 0xb9b1, 0x0 },
	{ 0xb9b2, 0x5 },
	{ 0xb9b3, 0x63 },
	{ 0xb9b4, 0x8c },
	{ 0xb9b5, 0xe0 },
	{ 0xb9b6, 0x1b },
	{ 0xb9b7, 0xa2 },
	{ 0xb9b8, 0x18 },
	{ 0xb9b9, 0x0 },
	{ 0xb9ba, 0x4 },
	{ 0xb9bb, 0x66 },
	{ 0xb9bc, 0xc4 },
	{ 0xb9bd, 0xec },
	{ 0xb9be, 0x95 },
	{ 0xb9bf, 0x80 },
	{ 0xb9c0, 0x5 },
	{ 0xb9c1, 0xe8 },
	{ 0xb9c2, 0x2d },
	{ 0xb9c3, 0x41 },
	{ 0xb9c4, 0x44 },
	{ 0xb9c5, 0x60 },
	{ 0xb9c6, 0x80 },
	{ 0xb9c7, 0x25 },
	{ 0xb9c8, 0x40 },
	{ 0xb9c9, 0x7 },
	{ 0xb9ca, 0x44 },
	{ 0xb9cb, 0x42 },
	{ 0xb9cc, 0x4 },
	{ 0xb9cd, 0xf8 },
	{ 0xb9ce, 0x43 },
	{ 0xb9cf, 0x8b },
	{ 0xb9d0, 0x38 },
	{ 0xb9d1, 0x41 },
	{ 0xb9d2, 0xb },
	{ 0xb9d3, 0x88 },
	{ 0xb9d4, 0x4 },
	{ 0xb9d5, 0x65 },
	{ 0xb9d6, 0x4 },
	{ 0xb9d7, 0x8c },
	{ 0xb9d8, 0x4 },
	{ 0xb9d9, 0xa8 },
	{ 0xb9da, 0x4 },
	{ 0xb9db, 0xca },
	{ 0xb9dc, 0xd4 },
	{ 0xb9dd, 0x4e },
	{ 0xb9de, 0x50 },
	{ 0xb9df, 0x9f },
	{ 0xb9e0, 0xf },
	{ 0xb9e1, 0xb0 },
	{ 0xb9e2, 0x28 },
	{ 0xb9e3, 0x8a },
	{ 0xb9e4, 0xc1 },
	{ 0xb9e5, 0x28 },
	{ 0xb9e6, 0xaa },
	{ 0xb9e7, 0xf1 },
	{ 0xb9e8, 0xf },
	{ 0xb9e9, 0x10 },
	{ 0xb9ea, 0x42 },
	{ 0xb9eb, 0x4 },
	{ 0xb9ec, 0x68 },
	{ 0xb9ed, 0x44 },
	{ 0xb9ee, 0xb },
	{ 0xb9ef, 0xc8 },
	{ 0xb9f0, 0x4 },
	{ 0xb9f1, 0x85 },
	{ 0xb9f2, 0x4 },
	{ 0xb9f3, 0x6b },
	{ 0xb9f4, 0x4 },
	{ 0xb9f5, 0xac },
	{ 0xb9f6, 0x4 },
	{ 0xb9f7, 0xcf },
	{ 0xb9f8, 0x4 },
	{ 0xb9f9, 0xea },
	{ 0xb9fa, 0xd4 },
	{ 0xb9fb, 0x14 },
	{ 0xb9fc, 0x90 },
	{ 0xb9fd, 0x9f },
	{ 0xb9fe, 0xe },
	{ 0xb9ff, 0x60 },
	{ 0xba00, 0x6c },
	{ 0xba01, 0xeb },
	{ 0xba02, 0x40 },
	{ 0xba03, 0x8 },
	{ 0xba04, 0xea },
	{ 0xba05, 0x28 },
	{ 0xba06, 0x87 },
	{ 0xba07, 0xfe },
	{ 0xba08, 0x28 },
	{ 0xba09, 0xa7 },
	{ 0xba0a, 0xd1 },
	{ 0xba0b, 0x2c },
	{ 0xba0c, 0xca },
	{ 0xba0d, 0x68 },
	{ 0xba0e, 0x2c },
	{ 0xba0f, 0xea },
	{ 0xba10, 0x48 },
	{ 0xba11, 0x5 },
	{ 0xba12, 0xc },
	{ 0xba13, 0xd4 },
	{ 0xba14, 0x73 },
	{ 0xba15, 0x90 },
	{ 0xba16, 0x9f },
	{ 0xba17, 0x24 },
	{ 0xba18, 0xec },
	{ 0xba19, 0x94 },
	{ 0xba1a, 0x5 },
	{ 0xba1b, 0xc3 },
	{ 0xba1c, 0x31 },
	{ 0xba1d, 0xab },
	{ 0xba1e, 0x10 },
	{ 0xba1f, 0x40 },
	{ 0xba20, 0x7 },
	{ 0xba21, 0xca },
	{ 0xba22, 0xc4 },
	{ 0xba23, 0xec },
	{ 0xba24, 0x95 },
	{ 0xba25, 0x80 },
	{ 0xba26, 0x41 },
	{ 0xba27, 0x7 },
	{ 0xba28, 0x32 },
	{ 0xba29, 0xc4 },
	{ 0xba2a, 0x6c },
	{ 0xba2b, 0x15 },
	{ 0xba2c, 0x80 },
	{ 0xba2d, 0x38 },
	{ 0xba2e, 0xa0 },
	{ 0xba2f, 0x10 },
	{ 0xba30, 0x0 },
	{ 0xba31, 0x82 },
	{ 0xba32, 0xd4 },
	{ 0xba33, 0x1 },
	{ 0xba34, 0x3 },
	{ 0xba35, 0x1f },
	{ 0xba36, 0x30 },
	{ 0xba37, 0xeb },
	{ 0xba38, 0x36 },
	{ 0xba39, 0x6c },
	{ 0xba3a, 0xe7 },
	{ 0xba3b, 0x80 },
	{ 0xba3c, 0x8 },
	{ 0xba3d, 0xea },
	{ 0xba3e, 0x0 },
	{ 0xba3f, 0x73 },
	{ 0xba40, 0x3e },
	{ 0xba41, 0x3 },
	{ 0xba42, 0x18 },
	{ 0xba43, 0x28 },
	{ 0xba44, 0xe7 },
	{ 0xba45, 0xa0 },
	{ 0xba46, 0x3e },
	{ 0xba47, 0x7 },
	{ 0xba48, 0x3b },
	{ 0xba49, 0x64 },
	{ 0xba4a, 0xe7 },
	{ 0xba4b, 0x18 },
	{ 0xba4c, 0x3c },
	{ 0xba4d, 0x27 },
	{ 0xba4e, 0x8 },
	{ 0xba4f, 0x47 },
	{ 0xba50, 0x2c },
	{ 0xba51, 0x40 },
	{ 0xba52, 0x6c },
	{ 0xba53, 0xed },
	{ 0xba54, 0x40 },
	{ 0xba55, 0x8 },
	{ 0xba56, 0xea },
	{ 0xba57, 0x2d },
	{ 0xba58, 0xc7 },
	{ 0xba59, 0x60 },
	{ 0xba5a, 0x2c },
	{ 0xba5b, 0xef },
	{ 0xba5c, 0x58 },
	{ 0xba5d, 0x9d },
	{ 0xba5e, 0xc7 },
	{ 0xba5f, 0x67 },
	{ 0xba60, 0x0 },
	{ 0xba61, 0x80 },
	{ 0xba62, 0x0 },
	{ 0xba63, 0x47 },
	{ 0xba64, 0x2f },
	{ 0xba65, 0x0 },
	{ 0xba66, 0x98 },
	{ 0xba67, 0x60 },
	{ 0xba68, 0x95 },
	{ 0xba69, 0x38 },
	{ 0xba6a, 0x18 },
	{ 0xba6b, 0x0 },
	{ 0xba6c, 0x4 },
	{ 0xba6d, 0x8e },
	{ 0xba6e, 0xd4 },
	{ 0xba6f, 0x31 },
	{ 0xba70, 0x3c },
	{ 0xba71, 0x1f },
	{ 0xba72, 0x24 },
	{ 0xba73, 0xec },
	{ 0xba74, 0xf9 },
	{ 0xba75, 0x40 },
	{ 0xba76, 0x7 },
	{ 0xba77, 0x50 },
	{ 0xba78, 0xc4 },
	{ 0xba79, 0xea },
	{ 0xba7a, 0x54 },
	{ 0xba7b, 0x80 },
	{ 0xba7c, 0x41 },
	{ 0xba7d, 0x7 },
	{ 0xba7e, 0xd0 },
	{ 0xba7f, 0x6c },
	{ 0xba80, 0xed },
	{ 0xba81, 0x40 },
	{ 0xba82, 0x8 },
	{ 0xba83, 0xea },
	{ 0xba84, 0x2d },
	{ 0xba85, 0xc7 },
	{ 0xba86, 0x20 },
	{ 0xba87, 0x6d },
	{ 0xba88, 0xad },
	{ 0xba89, 0x40 },
	{ 0xba8a, 0x9 },
	{ 0xba8b, 0xaa },
	{ 0xba8c, 0x30 },
	{ 0xba8d, 0xeb },
	{ 0xba8e, 0x40 },
	{ 0xba8f, 0x6c },
	{ 0xba90, 0xe7 },
	{ 0xba91, 0x40 },
	{ 0xba92, 0x2c },
	{ 0xba93, 0xcf },
	{ 0xba94, 0x42 },
	{ 0xba95, 0x2c },
	{ 0xba96, 0xad },
	{ 0xba97, 0x60 },
	{ 0xba98, 0x8 },
	{ 0xba99, 0xe6 },
	{ 0xba9a, 0x2c },
	{ 0xba9b, 0xa7 },
	{ 0xba9c, 0x0 },
	{ 0xba9d, 0x2c },
	{ 0xba9e, 0xef },
	{ 0xba9f, 0x58 },
	{ 0xbaa0, 0x9d },
	{ 0xbaa1, 0xc7 },
	{ 0xbaa2, 0xe0 },
	{ 0xbaa3, 0x0 },
	{ 0xbaa4, 0x80 },
	{ 0xbaa5, 0x0 },
	{ 0xbaa6, 0x47 },
	{ 0xbaa7, 0x23 },
	{ 0xbaa8, 0x80 },
	{ 0xbaa9, 0x2c },
	{ 0xbaaa, 0xca },
	{ 0xbaab, 0x68 },
	{ 0xbaac, 0x2c },
	{ 0xbaad, 0xea },
	{ 0xbaae, 0x48 },
	{ 0xbaaf, 0xc5 },
	{ 0xbab0, 0xa },
	{ 0xbab1, 0x54 },
	{ 0xbab2, 0x80 },
	{ 0xbab3, 0x98 },
	{ 0xbab4, 0x60 },
	{ 0xbab5, 0x91 },
	{ 0xbab6, 0x38 },
	{ 0xbab7, 0x18 },
	{ 0xbab8, 0x0 },
	{ 0xbab9, 0x4 },
	{ 0xbaba, 0x8b },
	{ 0xbabb, 0x47 },
	{ 0xbabc, 0xce },
	{ 0xbabd, 0x80 },
	{ 0xbabe, 0xd5 },
	{ 0xbabf, 0x3c },
	{ 0xbac0, 0x3c },
	{ 0xbac1, 0x1f },
	{ 0xbac2, 0x47 },
	{ 0xbac3, 0xbe },
	{ 0xbac4, 0x80 },
	{ 0xbac5, 0x47 },
	{ 0xbac6, 0xa9 },
	{ 0xbac7, 0x80 },
	{ 0xbac8, 0x5 },
	{ 0xbac9, 0x63 },
	{ 0xbaca, 0x24 },
	{ 0xbacb, 0x64 },
	{ 0xbacc, 0x54 },
	{ 0xbacd, 0x38 },
	{ 0xbace, 0xa0 },
	{ 0xbacf, 0xff },
	{ 0xbad0, 0x5 },
	{ 0xbad1, 0x44 },
	{ 0xbad2, 0x0 },
	{ 0xbad3, 0x80 },
	{ 0xbad4, 0xd4 },
	{ 0xbad5, 0x7b },
	{ 0xbad6, 0xfd },
	{ 0xbad7, 0x1f },
	{ 0xbad8, 0x6 },
	{ 0xbad9, 0x23 },
	{ 0xbada, 0x24 },
	{ 0xbadb, 0x6a },
	{ 0xbadc, 0xd4 },
	{ 0xbadd, 0x38 },
	{ 0xbade, 0xa0 },
	{ 0xbadf, 0xff },
	{ 0xbae0, 0x0 },
	{ 0xbae1, 0x80 },
	{ 0xbae2, 0xd4 },
	{ 0xbae3, 0xb },
	{ 0xbae4, 0xfd },
	{ 0xbae5, 0x1f },
	{ 0xbae6, 0x6 },
	{ 0xbae7, 0x3 },
	{ 0xbae8, 0x24 },
	{ 0xbae9, 0x6a },
	{ 0xbaea, 0x34 },
	{ 0xbaeb, 0x38 },
	{ 0xbaec, 0xa0 },
	{ 0xbaed, 0xff },
	{ 0xbaee, 0x0 },
	{ 0xbaef, 0x80 },
	{ 0xbaf0, 0xd4 },
	{ 0xbaf1, 0x43 },
	{ 0xbaf2, 0xfd },
	{ 0xbaf3, 0x1f },
	{ 0xbaf4, 0x5 },
	{ 0xbaf5, 0xc3 },
	{ 0xbaf6, 0x24 },
	{ 0xbaf7, 0x6a },
	{ 0xbaf8, 0xb4 },
	{ 0xbaf9, 0x38 },
	{ 0xbafa, 0xa0 },
	{ 0xbafb, 0xff },
	{ 0xbafc, 0x0 },
	{ 0xbafd, 0x80 },
	{ 0xbafe, 0xd4 },
	{ 0xbaff, 0x2d },
	{ 0xbb00, 0xfd },
	{ 0xbb01, 0x1f },
	{ 0xbb02, 0x5 },
	{ 0xbb03, 0xa3 },
	{ 0xbb04, 0x24 },
	{ 0xbb05, 0x6a },
	{ 0xbb06, 0x74 },
	{ 0xbb07, 0x38 },
	{ 0xbb08, 0xa0 },
	{ 0xbb09, 0xff },
	{ 0xbb0a, 0x0 },
	{ 0xbb0b, 0x88 },
	{ 0xbb0c, 0xd4 },
	{ 0xbb0d, 0x65 },
	{ 0xbb0e, 0xfd },
	{ 0xbb0f, 0x1f },
	{ 0xbb10, 0x5 },
	{ 0xbb11, 0xe3 },
	{ 0xbb12, 0x24 },
	{ 0xbb13, 0x6a },
	{ 0xbb14, 0xf4 },
	{ 0xbb15, 0x38 },
	{ 0xbb16, 0xa0 },
	{ 0xbb17, 0xff },
	{ 0xbb18, 0x0 },
	{ 0xbb19, 0x88 },
	{ 0xbb1a, 0xd4 },
	{ 0xbb1b, 0x19 },
	{ 0xbb1c, 0xfd },
	{ 0xbb1d, 0x1f },
	{ 0xbb1e, 0x5 },
	{ 0xbb1f, 0x83 },
	{ 0xbb20, 0x24 },
	{ 0xbb21, 0x6a },
	{ 0xbb22, 0xc },
	{ 0xbb23, 0x38 },
	{ 0xbb24, 0xa0 },
	{ 0xbb25, 0xff },
	{ 0xbb26, 0x0 },
	{ 0xbb27, 0x88 },
	{ 0xbb28, 0xd4 },
	{ 0xbb29, 0x51 },
	{ 0xbb2a, 0xfd },
	{ 0xbb2b, 0x1f },
	{ 0xbb2c, 0x3e },
	{ 0xbb2d, 0x11 },
	{ 0xbb2e, 0x38 },
	{ 0xbb2f, 0xd3 },
	{ 0xbb30, 0x96 },
	{ 0xbb31, 0x79 },
	{ 0xbb32, 0x0 },
	{ 0xbb33, 0x3e },
	{ 0xbb34, 0xf },
	{ 0xbb35, 0x18 },
	{ 0xbb36, 0xe },
	{ 0xbb37, 0x88 },
	{ 0xbb38, 0x3e },
	{ 0xbb39, 0x10 },
	{ 0xbb3a, 0x38 },
	{ 0xbb3b, 0xd3 },
	{ 0xbb3c, 0x96 },
	{ 0xbb3d, 0x7c },
	{ 0xbb3e, 0x80 },
	{ 0xbb3f, 0x4 },
	{ 0xbb40, 0xa7 },
	{ 0xbb41, 0x4 },
	{ 0xbb42, 0x6b },
	{ 0xbb43, 0x3e },
	{ 0xbb44, 0x11 },
	{ 0xbb45, 0x20 },
	{ 0xbb46, 0x3e },
	{ 0xbb47, 0xf },
	{ 0xbb48, 0x30 },
	{ 0xbb49, 0x3e },
	{ 0xbb4a, 0xc },
	{ 0xbb4b, 0x38 },
	{ 0xbb4c, 0xc },
	{ 0xbb4d, 0x50 },
	{ 0xbb4e, 0x3e },
	{ 0xbb4f, 0xe },
	{ 0xbb50, 0x38 },
	{ 0xbb51, 0xd3 },
	{ 0xbb52, 0x96 },
	{ 0xbb53, 0x79 },
	{ 0xbb54, 0x0 },
	{ 0xbb55, 0x3e },
	{ 0xbb56, 0xc },
	{ 0xbb57, 0x18 },
	{ 0xbb58, 0xf },
	{ 0xbb59, 0x10 },
	{ 0xbb5a, 0x6 },
	{ 0xbb5b, 0xe3 },
	{ 0xbb5c, 0x3e },
	{ 0xbb5d, 0xd },
	{ 0xbb5e, 0x38 },
	{ 0xbb5f, 0x3e },
	{ 0xbb60, 0x3 },
	{ 0xbb61, 0x18 },
	{ 0xbb62, 0xd3 },
	{ 0xbb63, 0x96 },
	{ 0xbb64, 0x79 },
	{ 0xbb65, 0x80 },
	{ 0xbb66, 0x4 },
	{ 0xbb67, 0x6b },
	{ 0xbb68, 0x3e },
	{ 0xbb69, 0xe },
	{ 0xbb6a, 0x20 },
	{ 0xbb6b, 0x3e },
	{ 0xbb6c, 0xd },
	{ 0xbb6d, 0x28 },
	{ 0xbb6e, 0x3e },
	{ 0xbb6f, 0xc },
	{ 0xbb70, 0x30 },
	{ 0xbb71, 0x3e },
	{ 0xbb72, 0x17 },
	{ 0xbb73, 0x38 },
	{ 0xbb74, 0xd4 },
	{ 0xbb75, 0x86 },
	{ 0xbb76, 0xfd },
	{ 0xbb77, 0x1f },
	{ 0xbb78, 0x3e },
	{ 0xbb79, 0x3 },
	{ 0xbb7a, 0x18 },
	{ 0xbb7b, 0x47 },
	{ 0xbb7c, 0xb9 },
	{ 0xbb7d, 0x80 },
	{ 0xbb7e, 0x47 },
	{ 0xbb7f, 0xa1 },
	{ 0xbb80, 0x40 },
	{ 0xbb81, 0xd9 },
	{ 0xbb82, 0xa6 },
	{ 0xbb83, 0x3c },
	{ 0xbb84, 0x10 },
	{ 0xbb85, 0x6 },
	{ 0xbb86, 0x3 },
	{ 0xbb87, 0x5 },
	{ 0xbb88, 0xc4 },
	{ 0xbb89, 0x5 },
	{ 0xbb8a, 0xe5 },
	{ 0xbb8b, 0x1 },
	{ 0xbb8c, 0x40 },
	{ 0xbb8d, 0x1 },
	{ 0xbb8e, 0x80 },
	{ 0xbb8f, 0x1 },
	{ 0xbb90, 0x60 },
	{ 0xbb91, 0x3e },
	{ 0xbb92, 0xa },
	{ 0xbb93, 0x18 },
	{ 0xbb94, 0x4 },
	{ 0xbb95, 0x90 },
	{ 0xbb96, 0x4 },
	{ 0xbb97, 0xae },
	{ 0xbb98, 0x4 },
	{ 0xbb99, 0xcf },
	{ 0xbb9a, 0x4b },
	{ 0xbb9b, 0x53 },
	{ 0xbb9c, 0xff },
	{ 0xbb9d, 0x28 },
	{ 0xbb9e, 0xed },
	{ 0xbb9f, 0x80 },
	{ 0xbba0, 0x66 },
	{ 0xbba1, 0xea },
	{ 0xbba2, 0x1b },
	{ 0xbba3, 0x67 },
	{ 0xbba4, 0x7 },
	{ 0xbba5, 0x1b },
	{ 0xbba6, 0x64 },
	{ 0xbba7, 0xf7 },
	{ 0xbba8, 0x3b },
	{ 0xbba9, 0x1 },
	{ 0xbbaa, 0x58 },
	{ 0xbbab, 0x9 },
	{ 0xbbac, 0x78 },
	{ 0xbbad, 0x9 },
	{ 0xbbae, 0x87 },
	{ 0xbbaf, 0x1 },
	{ 0xbbb0, 0xb4 },
	{ 0xbbb1, 0x9d },
	{ 0xbbb2, 0xca },
	{ 0xbbb3, 0x0 },
	{ 0xbbb4, 0x80 },
	{ 0xbbb5, 0x0 },
	{ 0xbbb6, 0x0 },
	{ 0xbbb7, 0x47 },
	{ 0xbbb8, 0x25 },
	{ 0xbbb9, 0xbf },
	{ 0xbbba, 0x0 },
	{ 0xbbbb, 0x88 },
	{ 0xbbbc, 0x0 },
	{ 0xbbbd, 0xaf },
	{ 0xbbbe, 0x4 },
	{ 0xbbbf, 0x6c },
	{ 0xbbc0, 0xd4 },
	{ 0xbbc1, 0x4f },
	{ 0xbbc2, 0x7d },
	{ 0xbbc3, 0x1f },
	{ 0xbbc4, 0x0 },
	{ 0xbbc5, 0x88 },
	{ 0xbbc6, 0x2c },
	{ 0xbbc7, 0x61 },
	{ 0xbbc8, 0x20 },
	{ 0xbbc9, 0x0 },
	{ 0xbbca, 0xaf },
	{ 0xbbcb, 0x4 },
	{ 0xbbcc, 0x6b },
	{ 0xbbcd, 0xd4 },
	{ 0xbbce, 0xa7 },
	{ 0xbbcf, 0x7d },
	{ 0xbbd0, 0x1f },
	{ 0xbbd1, 0x2c },
	{ 0xbbd2, 0xc1 },
	{ 0xbbd3, 0x60 },
	{ 0xbbd4, 0x2c },
	{ 0xbbd5, 0x8e },
	{ 0xbbd6, 0x58 },
	{ 0xbbd7, 0x64 },
	{ 0xbbd8, 0xe6 },
	{ 0xbbd9, 0x1d },
	{ 0xbbda, 0x4 },
	{ 0xbbdb, 0xa3 },
	{ 0xbbdc, 0x9d },
	{ 0xbbdd, 0xc4 },
	{ 0xbbde, 0x8c },
	{ 0xbbdf, 0x0 },
	{ 0xbbe0, 0x80 },
	{ 0xbbe1, 0x0 },
	{ 0xbbe2, 0x3e },
	{ 0xbbe3, 0x7 },
	{ 0xbbe4, 0x50 },
	{ 0xbbe5, 0x47 },
	{ 0xbbe6, 0x2f },
	{ 0xbbe7, 0x0 },
	{ 0xbbe8, 0x98 },
	{ 0xbbe9, 0x60 },
	{ 0xbbea, 0xa3 },
	{ 0xbbeb, 0xd8 },
	{ 0xbbec, 0x18 },
	{ 0xbbed, 0x0 },
	{ 0xbbee, 0x4 },
	{ 0xbbef, 0x8a },
	{ 0xbbf0, 0xd4 },
	{ 0xbbf1, 0x50 },
	{ 0xbbf2, 0xdc },
	{ 0xbbf3, 0x1f },
	{ 0xbbf4, 0x4 },
	{ 0xbbf5, 0x6a },
	{ 0xbbf6, 0x47 },
	{ 0xbbf7, 0xb1 },
	{ 0xbbf8, 0x40 },
	{ 0xbbf9, 0x47 },
	{ 0xbbfa, 0xa1 },
	{ 0xbbfb, 0x40 },
	{ 0xbbfc, 0x31 },
	{ 0xbbfd, 0x86 },
	{ 0xbbfe, 0x40 },
	{ 0xbbff, 0xd9 },
	{ 0xbc00, 0x65 },
	{ 0xbc01, 0x32 },
	{ 0xbc02, 0x80 },
	{ 0xbc03, 0xd9 },
	{ 0xbc04, 0xc5 },
	{ 0xbc05, 0xa },
	{ 0xbc06, 0x80 },
	{ 0xbc07, 0x5 },
	{ 0xbc08, 0xe4 },
	{ 0xbc09, 0x5 },
	{ 0xbc0a, 0x45 },
	{ 0xbc0b, 0x3e },
	{ 0xbc0c, 0x5 },
	{ 0xbc0d, 0x80 },
	{ 0xbc0e, 0xc8 },
	{ 0xbc0f, 0xcc },
	{ 0xbc10, 0xff },
	{ 0xbc11, 0xff },
	{ 0xbc12, 0x28 },
	{ 0xbc13, 0x6b },
	{ 0xbc14, 0x80 },
	{ 0xbc15, 0x28 },
	{ 0xbc16, 0xec },
	{ 0xbc17, 0x80 },
	{ 0xbc18, 0xd3 },
	{ 0xbc19, 0x8c },
	{ 0xbc1a, 0x3c },
	{ 0xbc1b, 0xa0 },
	{ 0xbc1c, 0x60 },
	{ 0xbc1d, 0x63 },
	{ 0xbc1e, 0x35 },
	{ 0xbc1f, 0x0 },
	{ 0xbc20, 0x80 },
	{ 0xbc21, 0x64 },
	{ 0xbc22, 0x63 },
	{ 0xbc23, 0x3b },
	{ 0xbc24, 0x24 },
	{ 0xbc25, 0xaa },
	{ 0xbc26, 0xf },
	{ 0xbc27, 0x6c },
	{ 0xbc28, 0x63 },
	{ 0xbc29, 0x32 },
	{ 0xbc2a, 0x3e },
	{ 0xbc2b, 0x3 },
	{ 0xbc2c, 0x18 },
	{ 0xbc2d, 0x2c },
	{ 0xbc2e, 0xc1 },
	{ 0xbc2f, 0x20 },
	{ 0xbc30, 0x2c },
	{ 0xbc31, 0xe1 },
	{ 0xbc32, 0x0 },
	{ 0xbc33, 0xd4 },
	{ 0xbc34, 0xfe },
	{ 0xbc35, 0x7d },
	{ 0xbc36, 0x1f },
	{ 0xbc37, 0x24 },
	{ 0xbc38, 0x8a },
	{ 0xbc39, 0xf },
	{ 0xbc3a, 0x3e },
	{ 0xbc3b, 0xa },
	{ 0xbc3c, 0x28 },
	{ 0xbc3d, 0x60 },
	{ 0xbc3e, 0x64 },
	{ 0xbc3f, 0x1d },
	{ 0xbc40, 0x3e },
	{ 0xbc41, 0x3 },
	{ 0xbc42, 0x68 },
	{ 0xbc43, 0x2c },
	{ 0xbc44, 0xe1 },
	{ 0xbc45, 0x40 },
	{ 0xbc46, 0x2c },
	{ 0xbc47, 0xc1 },
	{ 0xbc48, 0x60 },
	{ 0xbc49, 0xd2 },
	{ 0xbc4a, 0xcb },
	{ 0xbc4b, 0xf },
	{ 0xbc4c, 0x80 },
	{ 0xbc4d, 0x2c },
	{ 0xbc4e, 0xaf },
	{ 0xbc4f, 0x58 },
	{ 0xbc50, 0x9d },
	{ 0xbc51, 0xc5 },
	{ 0xbc52, 0x66 },
	{ 0xbc53, 0x0 },
	{ 0xbc54, 0x80 },
	{ 0xbc55, 0x0 },
	{ 0xbc56, 0x47 },
	{ 0xbc57, 0x24 },
	{ 0xbc58, 0x80 },
	{ 0xbc59, 0x28 },
	{ 0xbc5a, 0xab },
	{ 0xbc5b, 0x80 },
	{ 0xbc5c, 0x98 },
	{ 0xbc5d, 0x60 },
	{ 0xbc5e, 0x50 },
	{ 0xbc5f, 0x38 },
	{ 0xbc60, 0x18 },
	{ 0xbc61, 0x0 },
	{ 0xbc62, 0x5 },
	{ 0xbc63, 0xd },
	{ 0xbc64, 0xd4 },
	{ 0xbc65, 0x69 },
	{ 0xbc66, 0x5c },
	{ 0xbc67, 0x1f },
	{ 0xbc68, 0x21 },
	{ 0xbc69, 0xaa },
	{ 0xbc6a, 0xf },
	{ 0xbc6b, 0x1 },
	{ 0xbc6c, 0x74 },
	{ 0xbc6d, 0x31 },
	{ 0xbc6e, 0x8c },
	{ 0xbc6f, 0x30 },
	{ 0xbc70, 0x1 },
	{ 0xbc71, 0x58 },
	{ 0xbc72, 0xd2 },
	{ 0xbc73, 0xd6 },
	{ 0xbc74, 0xe3 },
	{ 0xbc75, 0x9f },
	{ 0xbc76, 0x47 },
	{ 0xbc77, 0xb1 },
	{ 0xbc78, 0x40 },
	{ 0xbc79, 0x98 },
	{ 0xbc7a, 0xe0 },
	{ 0xbc7b, 0xc0 },
	{ 0xbc7c, 0x0 },
	{ 0xbc7d, 0x80 },
	{ 0xbc7e, 0x0 },
	{ 0xbc7f, 0x47 },
	{ 0xbc80, 0xaa },
	{ 0xbc81, 0x80 },
	{ 0xbc82, 0x8c },
	{ 0xbc83, 0xe0 },
	{ 0xbc84, 0x1b },
	{ 0xbc85, 0xa2 },
	{ 0xbc86, 0x18 },
	{ 0xbc87, 0x0 },
	{ 0xbc88, 0x5 },
	{ 0xbc89, 0xa3 },
	{ 0xbc8a, 0x8d },
	{ 0xbc8b, 0x80 },
	{ 0xbc8c, 0x4d },
	{ 0xbc8d, 0x16 },
	{ 0xbc8e, 0x4 },
	{ 0xbc8f, 0x1 },
	{ 0xbc90, 0x5 },
	{ 0xbc91, 0x64 },
	{ 0xbc92, 0x6c },
	{ 0xbc93, 0xec },
	{ 0xbc94, 0x9 },
	{ 0xbc95, 0x5 },
	{ 0xbc96, 0x45 },
	{ 0xbc97, 0x20 },
	{ 0xbc98, 0xe5 },
	{ 0xbc99, 0xf },
	{ 0xbc9a, 0x24 },
	{ 0xbc9b, 0xe4 },
	{ 0xbc9c, 0x32 },
	{ 0xbc9d, 0x40 },
	{ 0xbc9e, 0x7 },
	{ 0xbc9f, 0x88 },
	{ 0xbca0, 0x8c },
	{ 0xbca1, 0xc0 },
	{ 0xbca2, 0x5a },
	{ 0xbca3, 0xa2 },
	{ 0xbca4, 0x18 },
	{ 0xbca5, 0x0 },
	{ 0xbca6, 0x48 },
	{ 0xbca7, 0x6d },
	{ 0xbca8, 0xff },
	{ 0xbca9, 0x20 },
	{ 0xbcaa, 0x6a },
	{ 0xbcab, 0x8f },
	{ 0xbcac, 0xc },
	{ 0xbcad, 0x40 },
	{ 0xbcae, 0x3e },
	{ 0xbcaf, 0xc },
	{ 0xbcb0, 0x60 },
	{ 0xbcb1, 0x21 },
	{ 0xbcb2, 0x85 },
	{ 0xbcb3, 0x8f },
	{ 0xbcb4, 0x21 },
	{ 0xbcb5, 0x8b },
	{ 0xbcb6, 0xb2 },
	{ 0xbcb7, 0xc4 },
	{ 0xbcb8, 0xed },
	{ 0xbcb9, 0xa2 },
	{ 0xbcba, 0x80 },
	{ 0xbcbb, 0x40 },
	{ 0xbcbc, 0x7 },
	{ 0xbcbd, 0x68 },
	{ 0xbcbe, 0x8c },
	{ 0xbcbf, 0xc0 },
	{ 0xbcc0, 0x6a },
	{ 0xbcc1, 0xa2 },
	{ 0xbcc2, 0x18 },
	{ 0xbcc3, 0x0 },
	{ 0xbcc4, 0x4 },
	{ 0xbcc5, 0x6d },
	{ 0xbcc6, 0xd8 },
	{ 0xbcc7, 0xc6 },
	{ 0xbcc8, 0x34 },
	{ 0xbcc9, 0x80 },
	{ 0xbcca, 0x4 },
	{ 0xbccb, 0x8b },
	{ 0xbccc, 0x4 },
	{ 0xbccd, 0xaa },
	{ 0xbcce, 0x4b },
	{ 0xbccf, 0x53 },
	{ 0xbcd0, 0xff },
	{ 0xbcd1, 0x2c },
	{ 0xbcd2, 0xeb },
	{ 0xbcd3, 0x42 },
	{ 0xbcd4, 0x24 },
	{ 0xbcd5, 0xca },
	{ 0xbcd6, 0xf },
	{ 0xbcd7, 0x98 },
	{ 0xbcd8, 0xa0 },
	{ 0xbcd9, 0xff },
	{ 0xbcda, 0xff },
	{ 0xbcdb, 0x0 },
	{ 0xbcdc, 0x0 },
	{ 0xbcdd, 0x0 },
	{ 0xbcde, 0x88 },
	{ 0xbcdf, 0x20 },
	{ 0xbce0, 0xc7 },
	{ 0xbce1, 0x0 },
	{ 0xbce2, 0x2c },
	{ 0xbce3, 0xeb },
	{ 0xbce4, 0x42 },
	{ 0xbce5, 0x24 },
	{ 0xbce6, 0xca },
	{ 0xbce7, 0x8f },
	{ 0xbce8, 0x20 },
	{ 0xbce9, 0xc7 },
	{ 0xbcea, 0x80 },
	{ 0xbceb, 0x28 },
	{ 0xbcec, 0x6b },
	{ 0xbced, 0xb0 },
	{ 0xbcee, 0xd4 },
	{ 0xbcef, 0x23 },
	{ 0xbcf0, 0xbd },
	{ 0xbcf1, 0x1f },
	{ 0xbcf2, 0x28 },
	{ 0xbcf3, 0x6b },
	{ 0xbcf4, 0x30 },
	{ 0xbcf5, 0x98 },
	{ 0xbcf6, 0xa0 },
	{ 0xbcf7, 0xff },
	{ 0xbcf8, 0xff },
	{ 0xbcf9, 0x0 },
	{ 0xbcfa, 0x0 },
	{ 0xbcfb, 0x0 },
	{ 0xbcfc, 0x88 },
	{ 0xbcfd, 0x28 },
	{ 0xbcfe, 0x6b },
	{ 0xbcff, 0xf0 },
	{ 0xbd00, 0xd4 },
	{ 0xbd01, 0x4d },
	{ 0xbd02, 0xbd },
	{ 0xbd03, 0x1f },
	{ 0xbd04, 0x28 },
	{ 0xbd05, 0x6b },
	{ 0xbd06, 0x70 },
	{ 0xbd07, 0x98 },
	{ 0xbd08, 0xa0 },
	{ 0xbd09, 0xff },
	{ 0xbd0a, 0xff },
	{ 0xbd0b, 0x0 },
	{ 0xbd0c, 0x0 },
	{ 0xbd0d, 0x0 },
	{ 0xbd0e, 0x88 },
	{ 0xbd0f, 0x28 },
	{ 0xbd10, 0x6b },
	{ 0xbd11, 0x88 },
	{ 0xbd12, 0xd4 },
	{ 0xbd13, 0x5 },
	{ 0xbd14, 0xbd },
	{ 0xbd15, 0x1f },
	{ 0xbd16, 0x28 },
	{ 0xbd17, 0x6b },
	{ 0xbd18, 0x8 },
	{ 0xbd19, 0x4 },
	{ 0xbd1a, 0x8b },
	{ 0xbd1b, 0x4 },
	{ 0xbd1c, 0x6a },
	{ 0xbd1d, 0xd4 },
	{ 0xbd1e, 0xe7 },
	{ 0xbd1f, 0x40 },
	{ 0xbd20, 0x9f },
	{ 0xbd21, 0x4 },
	{ 0xbd22, 0x8b },
	{ 0xbd23, 0x4 },
	{ 0xbd24, 0xaa },
	{ 0xbd25, 0x0 },
	{ 0xbd26, 0xc0 },
	{ 0xbd27, 0x4 },
	{ 0xbd28, 0x6d },
	{ 0xbd29, 0xd4 },
	{ 0xbd2a, 0x46 },
	{ 0xbd2b, 0x80 },
	{ 0xbd2c, 0x9f },
	{ 0xbd2d, 0x28 },
	{ 0xbd2e, 0x6a },
	{ 0xbd2f, 0x3b },
	{ 0xbd30, 0x0 },
	{ 0xbd31, 0xc8 },
	{ 0xbd32, 0x4 },
	{ 0xbd33, 0x6d },
	{ 0xbd34, 0x4 },
	{ 0xbd35, 0x8b },
	{ 0xbd36, 0x4 },
	{ 0xbd37, 0xaa },
	{ 0xbd38, 0xd4 },
	{ 0xbd39, 0xca },
	{ 0xbd3a, 0x80 },
	{ 0xbd3b, 0x9f },
	{ 0xbd3c, 0x28 },
	{ 0xbd3d, 0x6a },
	{ 0xbd3e, 0x7b },
	{ 0xbd3f, 0x24 },
	{ 0xbd40, 0xcb },
	{ 0xbd41, 0xac },
	{ 0xbd42, 0x34 },
	{ 0xbd43, 0xe6 },
	{ 0xbd44, 0xbf },
	{ 0xbd45, 0x0 },
	{ 0xbd46, 0xff },
	{ 0xbd47, 0x45 },
	{ 0xbd48, 0x7 },
	{ 0xbd49, 0x8 },
	{ 0xbd4a, 0x0 },
	{ 0xbd4b, 0xe2 },
	{ 0xbd4c, 0x60 },
	{ 0xbd4d, 0xe6 },
	{ 0xbd4e, 0x3a },
	{ 0xbd4f, 0x3e },
	{ 0xbd50, 0x7 },
	{ 0xbd51, 0x38 },
	{ 0xbd52, 0x0 },
	{ 0xbd53, 0xff },
	{ 0xbd54, 0x42 },
	{ 0xbd55, 0x7 },
	{ 0xbd56, 0x62 },
	{ 0xbd57, 0x28 },
	{ 0xbd58, 0x6a },
	{ 0xbd59, 0x7 },
	{ 0xbd5a, 0x2c },
	{ 0xbd5b, 0xeb },
	{ 0xbd5c, 0x42 },
	{ 0xbd5d, 0x28 },
	{ 0xbd5e, 0xca },
	{ 0xbd5f, 0xbb },
	{ 0xbd60, 0x28 },
	{ 0xbd61, 0xc7 },
	{ 0xbd62, 0x40 },
	{ 0xbd63, 0x28 },
	{ 0xbd64, 0xca },
	{ 0xbd65, 0xfb },
	{ 0xbd66, 0x28 },
	{ 0xbd67, 0xc7 },
	{ 0xbd68, 0x20 },
	{ 0xbd69, 0x28 },
	{ 0xbd6a, 0xca },
	{ 0xbd6b, 0x87 },
	{ 0xbd6c, 0x28 },
	{ 0xbd6d, 0xc7 },
	{ 0xbd6e, 0x60 },
	{ 0xbd6f, 0x2c },
	{ 0xbd70, 0xeb },
	{ 0xbd71, 0x58 },
	{ 0xbd72, 0x9d },
	{ 0xbd73, 0x87 },
	{ 0xbd74, 0x20 },
	{ 0xbd75, 0x0 },
	{ 0xbd76, 0x80 },
	{ 0xbd77, 0x0 },
	{ 0xbd78, 0x47 },
	{ 0xbd79, 0x3f },
	{ 0xbd7a, 0x40 },
	{ 0xbd7b, 0x28 },
	{ 0xbd7c, 0x8a },
	{ 0xbd7d, 0xbb },
	{ 0xbd7e, 0x28 },
	{ 0xbd7f, 0xaa },
	{ 0xbd80, 0xfb },
	{ 0xbd81, 0x28 },
	{ 0xbd82, 0xca },
	{ 0xbd83, 0x87 },
	{ 0xbd84, 0x98 },
	{ 0xbd85, 0x60 },
	{ 0xbd86, 0x7c },
	{ 0xbd87, 0x38 },
	{ 0xbd88, 0x18 },
	{ 0xbd89, 0x0 },
	{ 0xbd8a, 0x3e },
	{ 0xbd8b, 0x4 },
	{ 0xbd8c, 0x23 },
	{ 0xbd8d, 0x3e },
	{ 0xbd8e, 0x5 },
	{ 0xbd8f, 0x2b },
	{ 0xbd90, 0x3e },
	{ 0xbd91, 0x6 },
	{ 0xbd92, 0x33 },
	{ 0xbd93, 0x47 },
	{ 0xbd94, 0xca },
	{ 0xbd95, 0x80 },
	{ 0xbd96, 0xd5 },
	{ 0xbd97, 0x26 },
	{ 0xbd98, 0x9c },
	{ 0xbd99, 0x1f },
	{ 0xbd9a, 0x0 },
	{ 0xbd9b, 0xef },
	{ 0xbd9c, 0x28 },
	{ 0xbd9d, 0xea },
	{ 0xbd9e, 0x7 },
	{ 0xbd9f, 0x41 },
	{ 0xbda0, 0xc6 },
	{ 0xbda1, 0xdd },
	{ 0xbda2, 0x28 },
	{ 0xbda3, 0xea },
	{ 0xbda4, 0x7b },
	{ 0xbda5, 0xe },
	{ 0xbda6, 0xb7 },
	{ 0xbda7, 0x47 },
	{ 0xbda8, 0xba },
	{ 0xbda9, 0x80 },
	{ 0xbdaa, 0x98 },
	{ 0xbdab, 0xe0 },
	{ 0xbdac, 0xcc },
	{ 0xbdad, 0xe0 },
	{ 0xbdae, 0x18 },
	{ 0xbdaf, 0x0 },
	{ 0xbdb0, 0x8c },
	{ 0xbdb1, 0xe0 },
	{ 0xbdb2, 0x2f },
	{ 0xbdb3, 0x62 },
	{ 0xbdb4, 0x18 },
	{ 0xbdb5, 0x0 },
	{ 0xbdb6, 0x98 },
	{ 0xbdb7, 0xe0 },
	{ 0xbdb8, 0x44 },
	{ 0xbdb9, 0xa0 },
	{ 0xbdba, 0x18 },
	{ 0xbdbb, 0x0 },
	{ 0xbdbc, 0x8c },
	{ 0xbdbd, 0xe0 },
	{ 0xbdbe, 0xf },
	{ 0xbdbf, 0x62 },
	{ 0xbdc0, 0x18 },
	{ 0xbdc1, 0x0 },
	{ 0xbdc2, 0x98 },
	{ 0xbdc3, 0xe0 },
	{ 0xbdc4, 0xb9 },
	{ 0xbdc5, 0x10 },
	{ 0xbdc6, 0x18 },
	{ 0xbdc7, 0x0 },
	{ 0xbdc8, 0x8c },
	{ 0xbdc9, 0xe0 },
	{ 0xbdca, 0x17 },
	{ 0xbdcb, 0x62 },
	{ 0xbdcc, 0x18 },
	{ 0xbdcd, 0x0 },
	{ 0xbdce, 0x98 },
	{ 0xbdcf, 0xe0 },
	{ 0xbdd0, 0xe5 },
	{ 0xbdd1, 0x90 },
	{ 0xbdd2, 0x18 },
	{ 0xbdd3, 0x0 },
	{ 0xbdd4, 0x8c },
	{ 0xbdd5, 0xe0 },
	{ 0xbdd6, 0x2a },
	{ 0xbdd7, 0xe2 },
	{ 0xbdd8, 0x18 },
	{ 0xbdd9, 0x0 },
	{ 0xbdda, 0x98 },
	{ 0xbddb, 0xe0 },
	{ 0xbddc, 0x9e },
	{ 0xbddd, 0x30 },
	{ 0xbdde, 0x18 },
	{ 0xbddf, 0x0 },
	{ 0xbde0, 0x8c },
	{ 0xbde1, 0xe0 },
	{ 0xbde2, 0x36 },
	{ 0xbde3, 0xe2 },
	{ 0xbde4, 0x18 },
	{ 0xbde5, 0x0 },
	{ 0xbde6, 0x47 },
	{ 0xbde7, 0xd2 },
	{ 0xbde8, 0x48 },
	{ 0xbde9, 0xd8 },
	{ 0xbdea, 0xe0 },
	{ 0xbdeb, 0xb5 },
	{ 0xbdec, 0x60 },
	{ 0xbded, 0x28 },
	{ 0xbdee, 0xe3 },
	{ 0xbdef, 0x7c },
	{ 0xbdf0, 0x47 },
	{ 0xbdf1, 0xd2 },
	{ 0xbdf2, 0x48 },
	{ 0xbdf3, 0x98 },
	{ 0xbdf4, 0xe0 },
	{ 0xbdf5, 0x97 },
	{ 0xbdf6, 0xb0 },
	{ 0xbdf7, 0x18 },
	{ 0xbdf8, 0x0 },
	{ 0xbdf9, 0x8c },
	{ 0xbdfa, 0xe0 },
	{ 0xbdfb, 0x1a },
	{ 0xbdfc, 0xec },
	{ 0xbdfd, 0x18 },
	{ 0xbdfe, 0x0 },
	{ 0xbdff, 0x47 },
	{ 0xbe00, 0xd2 },
	{ 0xbe01, 0x48 },
	{ 0xbe02, 0x47 },
	{ 0xbe03, 0xa2 },
	{ 0xbe04, 0x42 },
	{ 0xbe05, 0x26 },
	{ 0xbe06, 0xe3 },
	{ 0xbe07, 0x3a },
	{ 0xbe08, 0x40 },
	{ 0xbe09, 0x97 },
	{ 0xbe0a, 0x70 },
	{ 0xbe0b, 0x33 },
	{ 0xbe0c, 0xa1 },
	{ 0xbe0d, 0x10 },
	{ 0xbe0e, 0x3 },
	{ 0xbe0f, 0x0 },
	{ 0xbe10, 0xd9 },
	{ 0xbe11, 0x20 },
	{ 0xbe12, 0x0 },
	{ 0xbe13, 0x2 },
	{ 0xbe14, 0xf },
	{ 0xbe15, 0x64 },
	{ 0xbe16, 0x0 },
	{ 0xbe17, 0x92 },
	{ 0xbe18, 0x3 },
	{ 0xbe19, 0x40 },
	{ 0xbe1a, 0x63 },
	{ 0xbe1b, 0xc6 },
	{ 0xbe1c, 0xd4 },
	{ 0xbe1d, 0x7 },
	{ 0xbe1e, 0x84 },
	{ 0xbe1f, 0x3 },
	{ 0xbe20, 0x20 },
	{ 0xbe21, 0x63 },
	{ 0xbe22, 0x19 },
	{ 0xbe23, 0xd4 },
	{ 0xbe24, 0x62 },
	{ 0xbe25, 0xe7 },
	{ 0xbe26, 0xc4 },
	{ 0xbe27, 0x63 },
	{ 0xbe28, 0xbe },
	{ 0xbe29, 0xcc },
	{ 0xbe2a, 0x2e },
	{ 0xbe2b, 0xf7 },
	{ 0xbe2c, 0x40 },
	{ 0xbe2d, 0x2f },
	{ 0xbe2e, 0x7c },
	{ 0xbe2f, 0x40 },
	{ 0xbe30, 0xd3 },
	{ 0xbe31, 0xaf },
	{ 0xbe32, 0xb1 },
	{ 0xbe33, 0x40 },
	{ 0xbe34, 0x62 },
	{ 0xbe35, 0xfb },
	{ 0xbe36, 0xbd },
	{ 0xbe37, 0x2b },
	{ 0xbe38, 0x63 },
	{ 0xbe39, 0x8f },
	{ 0xbe3a, 0x6f },
	{ 0xbe3b, 0x7b },
	{ 0xbe3c, 0x21 },
	{ 0xbe3d, 0x67 },
	{ 0xbe3e, 0x77 },
	{ 0xbe3f, 0xdb },
	{ 0xbe40, 0x2e },
	{ 0xbe41, 0xfd },
	{ 0xbe42, 0x40 },
	{ 0xbe43, 0xa },
	{ 0xbe44, 0xfb },
	{ 0xbe45, 0x33 },
	{ 0xbe46, 0x61 },
	{ 0xbe47, 0x10 },
	{ 0xbe48, 0xb },
	{ 0xbe49, 0x1b },
	{ 0xbe4a, 0x2e },
	{ 0xbe4b, 0xfd },
	{ 0xbe4c, 0x0 },
	{ 0xbe4d, 0x6e },
	{ 0xbe4e, 0xf7 },
	{ 0xbe4f, 0x20 },
	{ 0xbe50, 0x2f },
	{ 0xbe51, 0x7c },
	{ 0xbe52, 0x40 },
	{ 0xbe53, 0x66 },
	{ 0xbe54, 0xf7 },
	{ 0xbe55, 0xdd },
	{ 0xbe56, 0xc },
	{ 0xbe57, 0x20 },
	{ 0xbe58, 0x33 },
	{ 0xbe59, 0x61 },
	{ 0xbe5a, 0x10 },
	{ 0xbe5b, 0xb },
	{ 0xbe5c, 0x1b },
	{ 0xbe5d, 0x2f },
	{ 0xbe5e, 0x7d },
	{ 0xbe5f, 0x40 },
	{ 0xbe60, 0x6f },
	{ 0xbe61, 0x7b },
	{ 0xbe62, 0x20 },
	{ 0xbe63, 0x66 },
	{ 0xbe64, 0xfb },
	{ 0xbe65, 0xbd },
	{ 0xbe66, 0x3 },
	{ 0xbe67, 0x32 },
	{ 0xbe68, 0x33 },
	{ 0xbe69, 0x9c },
	{ 0xbe6a, 0x10 },
	{ 0xbe6b, 0x3c },
	{ 0xbe6c, 0x39 },
	{ 0xbe6d, 0x4 },
	{ 0xbe6e, 0x2e },
	{ 0xbe6f, 0xf8 },
	{ 0xbe70, 0x0 },
	{ 0xbe71, 0x47 },
	{ 0xbe72, 0x20 },
	{ 0xbe73, 0xdf },
	{ 0xbe74, 0x33 },
	{ 0xbe75, 0x5a },
	{ 0xbe76, 0x4 },
	{ 0xbe77, 0x30 },
	{ 0xbe78, 0x84 },
	{ 0xbe79, 0x2 },
	{ 0xbe7a, 0x9d },
	{ 0xbe7b, 0x9a },
	{ 0xbe7c, 0x0 },
	{ 0xbe7d, 0x80 },
	{ 0xbe7e, 0x0 },
	{ 0xbe7f, 0x0 },
	{ 0xbe80, 0x47 },
	{ 0xbe81, 0x35 },
	{ 0xbe82, 0x9f },
	{ 0xbe83, 0x0 },
	{ 0xbe84, 0xc0 },
	{ 0xbe85, 0x1 },
	{ 0xbe86, 0x40 },
	{ 0xbe87, 0x0 },
	{ 0xbe88, 0xe0 },
	{ 0xbe89, 0x60 },
	{ 0xbe8a, 0x87 },
	{ 0xbe8b, 0x34 },
	{ 0xbe8c, 0x32 },
	{ 0xbe8d, 0xe1 },
	{ 0xbe8e, 0x10 },
	{ 0xbe8f, 0x8 },
	{ 0xbe90, 0x97 },
	{ 0xbe91, 0x0 },
	{ 0xbe92, 0xf2 },
	{ 0xbe93, 0x3c },
	{ 0xbe94, 0x27 },
	{ 0xbe95, 0x4 },
	{ 0xbe96, 0x2c },
	{ 0xbe97, 0x84 },
	{ 0xbe98, 0x40 },
	{ 0xbe99, 0x9 },
	{ 0xbe9a, 0x44 },
	{ 0xbe9b, 0x47 },
	{ 0xbe9c, 0x27 },
	{ 0xbe9d, 0x7f },
	{ 0xbe9e, 0x30 },
	{ 0xbe9f, 0xc6 },
	{ 0xbea0, 0x4 },
	{ 0xbea1, 0x9d },
	{ 0xbea2, 0x86 },
	{ 0xbea3, 0x0 },
	{ 0xbea4, 0x80 },
	{ 0xbea5, 0x0 },
	{ 0xbea6, 0x0 },
	{ 0xbea7, 0x47 },
	{ 0xbea8, 0x30 },
	{ 0xbea9, 0x7f },
	{ 0xbeaa, 0x6d },
	{ 0xbeab, 0x4a },
	{ 0xbeac, 0x61 },
	{ 0xbead, 0xf },
	{ 0xbeae, 0xa4 },
	{ 0xbeaf, 0x6d },
	{ 0xbeb0, 0x78 },
	{ 0xbeb1, 0x80 },
	{ 0xbeb2, 0x2 },
	{ 0xbeb3, 0xe0 },
	{ 0xbeb4, 0x63 },
	{ 0xbeb5, 0x97 },
	{ 0xbeb6, 0xc4 },
	{ 0xbeb7, 0x63 },
	{ 0xbeb8, 0x27 },
	{ 0xbeb9, 0xe4 },
	{ 0xbeba, 0x63 },
	{ 0xbebb, 0xdd },
	{ 0xbebc, 0xbc },
	{ 0xbebd, 0x2d },
	{ 0xbebe, 0x59 },
	{ 0xbebf, 0x40 },
	{ 0xbec0, 0x40 },
	{ 0xbec1, 0xa },
	{ 0xbec2, 0xb8 },
	{ 0xbec3, 0x6f },
	{ 0xbec4, 0x77 },
	{ 0xbec5, 0x80 },
	{ 0xbec6, 0xb },
	{ 0xbec7, 0x6b },
	{ 0xbec8, 0xb },
	{ 0xbec9, 0x64 },
	{ 0xbeca, 0x25 },
	{ 0xbecb, 0x83 },
	{ 0xbecc, 0xda },
	{ 0xbecd, 0x2f },
	{ 0xbece, 0x5b },
	{ 0xbecf, 0x60 },
	{ 0xbed0, 0x67 },
	{ 0xbed1, 0x4c },
	{ 0xbed2, 0xd3 },
	{ 0xbed3, 0x6f },
	{ 0xbed4, 0x5a },
	{ 0xbed5, 0xe1 },
	{ 0xbed6, 0xd3 },
	{ 0xbed7, 0x95 },
	{ 0xbed8, 0xa3 },
	{ 0xbed9, 0x0 },
	{ 0xbeda, 0x2c },
	{ 0xbedb, 0x19 },
	{ 0xbedc, 0x0 },
	{ 0xbedd, 0x2d },
	{ 0xbede, 0x3e },
	{ 0xbedf, 0x0 },
	{ 0xbee0, 0xc },
	{ 0xbee1, 0x20 },
	{ 0xbee2, 0xb },
	{ 0xbee3, 0x86 },
	{ 0xbee4, 0x2f },
	{ 0xbee5, 0x3c },
	{ 0xbee6, 0x40 },
	{ 0xbee7, 0x6f },
	{ 0xbee8, 0x39 },
	{ 0xbee9, 0x20 },
	{ 0xbeea, 0x67 },
	{ 0xbeeb, 0x39 },
	{ 0xbeec, 0x55 },
	{ 0xbeed, 0x2f },
	{ 0xbeee, 0x3e },
	{ 0xbeef, 0x0 },
	{ 0xbef0, 0x2 },
	{ 0xbef1, 0xf2 },
	{ 0xbef2, 0x3c },
	{ 0xbef3, 0x37 },
	{ 0xbef4, 0x4 },
	{ 0xbef5, 0x47 },
	{ 0xbef6, 0x2f },
	{ 0xbef7, 0xdf },
	{ 0xbef8, 0x33 },
	{ 0xbef9, 0x18 },
	{ 0xbefa, 0x4 },
	{ 0xbefb, 0x33 },
	{ 0xbefc, 0xbd },
	{ 0xbefd, 0x4 },
	{ 0xbefe, 0x9d },
	{ 0xbeff, 0x98 },
	{ 0xbf00, 0x0 },
	{ 0xbf01, 0x80 },
	{ 0xbf02, 0x0 },
	{ 0xbf03, 0x0 },
	{ 0xbf04, 0x47 },
	{ 0xbf05, 0x3d },
	{ 0xbf06, 0x5f },
	{ 0xbf07, 0x2 },
	{ 0xbf08, 0xe0 },
	{ 0xbf09, 0x0 },
	{ 0xbf0a, 0xc0 },
	{ 0xbf0b, 0x3 },
	{ 0xbf0c, 0x20 },
	{ 0xbf0d, 0x0 },
	{ 0xbf0e, 0x80 },
	{ 0xbf0f, 0x63 },
	{ 0xbf10, 0x4 },
	{ 0xbf11, 0xbc },
	{ 0xbf12, 0x63 },
	{ 0xbf13, 0x47 },
	{ 0xbf14, 0xc4 },
	{ 0xbf15, 0x2f },
	{ 0xbf16, 0x5a },
	{ 0xbf17, 0x40 },
	{ 0xbf18, 0x40 },
	{ 0xbf19, 0x1a },
	{ 0xbf1a, 0xf0 },
	{ 0xbf1b, 0x33 },
	{ 0xbf1c, 0x41 },
	{ 0xbf1d, 0x10 },
	{ 0xbf1e, 0xb },
	{ 0xbf1f, 0x1a },
	{ 0xbf20, 0x0 },
	{ 0xbf21, 0xd8 },
	{ 0xbf22, 0x2f },
	{ 0xbf23, 0x18 },
	{ 0xbf24, 0x40 },
	{ 0xbf25, 0xb },
	{ 0xbf26, 0x38 },
	{ 0xbf27, 0x0 },
	{ 0xbf28, 0x92 },
	{ 0xbf29, 0x3c },
	{ 0xbf2a, 0x24 },
	{ 0xbf2b, 0x4 },
	{ 0xbf2c, 0x47 },
	{ 0xbf2d, 0x2c },
	{ 0xbf2e, 0x7f },
	{ 0xbf2f, 0x32 },
	{ 0xbf30, 0xf7 },
	{ 0xbf31, 0x4 },
	{ 0xbf32, 0x9d },
	{ 0xbf33, 0x97 },
	{ 0xbf34, 0x0 },
	{ 0xbf35, 0x80 },
	{ 0xbf36, 0x0 },
	{ 0xbf37, 0x0 },
	{ 0xbf38, 0x47 },
	{ 0xbf39, 0x3a },
	{ 0xbf3a, 0xbf },
	{ 0xbf3b, 0x5 },
	{ 0xbf3c, 0x45 },
	{ 0xbf3d, 0xd3 },
	{ 0xbf3e, 0x90 },
	{ 0xbf3f, 0x6e },
	{ 0xbf40, 0x0 },
	{ 0xbf41, 0x65 },
	{ 0xbf42, 0x59 },
	{ 0xbf43, 0x35 },
	{ 0xbf44, 0x2c },
	{ 0xbf45, 0xa1 },
	{ 0xbf46, 0x20 },
	{ 0xbf47, 0xd4 },
	{ 0xbf48, 0x13 },
	{ 0xbf49, 0x7d },
	{ 0xbf4a, 0x1f },
	{ 0xbf4b, 0x2c },
	{ 0xbf4c, 0xa1 },
	{ 0xbf4d, 0x60 },
	{ 0xbf4e, 0x9d },
	{ 0xbf4f, 0xc3 },
	{ 0xbf50, 0xb0 },
	{ 0xbf51, 0x0 },
	{ 0xbf52, 0x90 },
	{ 0xbf53, 0x0 },
	{ 0xbf54, 0x47 },
	{ 0xbf55, 0x28 },
	{ 0xbf56, 0x80 },
	{ 0xbf57, 0x98 },
	{ 0xbf58, 0x60 },
	{ 0xbf59, 0xcc },
	{ 0xbf5a, 0xf8 },
	{ 0xbf5b, 0x18 },
	{ 0xbf5c, 0x0 },
	{ 0xbf5d, 0x4 },
	{ 0xbf5e, 0x85 },
	{ 0xbf5f, 0x4 },
	{ 0xbf60, 0xaa },
	{ 0xbf61, 0xd4 },
	{ 0xbf62, 0x99 },
	{ 0xbf63, 0xec },
	{ 0xbf64, 0x1f },
	{ 0xbf65, 0x4 },
	{ 0xbf66, 0x6a },
	{ 0xbf67, 0x47 },
	{ 0xbf68, 0xb2 },
	{ 0xbf69, 0x42 },
	{ 0xbf6a, 0x47 },
	{ 0xbf6b, 0xa1 },
	{ 0xbf6c, 0x40 },
	{ 0xbf6d, 0xcc },
	{ 0xbf6e, 0xe4 },
	{ 0xbf6f, 0x6d },
	{ 0xbf70, 0x40 },
	{ 0xbf71, 0x5 },
	{ 0xbf72, 0xc5 },
	{ 0xbf73, 0x3d },
	{ 0xbf74, 0x87 },
	{ 0xbf75, 0x28 },
	{ 0xbf76, 0x65 },
	{ 0xbf77, 0x85 },
	{ 0xbf78, 0x3a },
	{ 0xbf79, 0x5 },
	{ 0xbf7a, 0x44 },
	{ 0xbf7b, 0xc8 },
	{ 0xbf7c, 0xa4 },
	{ 0xbf7d, 0x87 },
	{ 0xbf7e, 0x40 },
	{ 0xbf7f, 0xcd },
	{ 0xbf80, 0xa4 },
	{ 0xbf81, 0x61 },
	{ 0xbf82, 0x40 },
	{ 0xbf83, 0xcc },
	{ 0xbf84, 0x84 },
	{ 0xbf85, 0x4b },
	{ 0xbf86, 0x40 },
	{ 0xbf87, 0x5 },
	{ 0xbf88, 0xe6 },
	{ 0xbf89, 0x60 },
	{ 0xbf8a, 0xc5 },
	{ 0xbf8b, 0x65 },
	{ 0xbf8c, 0x5 },
	{ 0xbf8d, 0x63 },
	{ 0xbf8e, 0x66 },
	{ 0xbf8f, 0xe4 },
	{ 0xbf90, 0x33 },
	{ 0xbf91, 0x60 },
	{ 0xbf92, 0xc5 },
	{ 0xbf93, 0x3d },
	{ 0xbf94, 0x0 },
	{ 0xbf95, 0xd8 },
	{ 0xbf96, 0x64 },
	{ 0xbf97, 0xd7 },
	{ 0xbf98, 0x34 },
	{ 0xbf99, 0xc8 },
	{ 0xbf9a, 0x6a },
	{ 0xbf9b, 0xa7 },
	{ 0xbf9c, 0x40 },
	{ 0xbf9d, 0x3d },
	{ 0xbf9e, 0x86 },
	{ 0xbf9f, 0x20 },
	{ 0xbfa0, 0x64 },
	{ 0xbfa1, 0xe6 },
	{ 0xbfa2, 0x22 },
	{ 0xbfa3, 0x60 },
	{ 0xbfa4, 0xe7 },
	{ 0xbfa5, 0x1d },
	{ 0xbfa6, 0xd9 },
	{ 0xbfa7, 0xad },
	{ 0xbfa8, 0x0 },
	{ 0xbfa9, 0xd },
	{ 0xbfaa, 0x9 },
	{ 0xbfab, 0xa5 },
	{ 0xbfac, 0x24 },
	{ 0xbfad, 0xcb },
	{ 0xbfae, 0xc1 },
	{ 0xbfaf, 0x64 },
	{ 0xbfb0, 0xe7 },
	{ 0xbfb1, 0x33 },
	{ 0xbfb2, 0x6c },
	{ 0xbfb3, 0xe7 },
	{ 0xbfb4, 0x21 },
	{ 0xbfb5, 0x8 },
	{ 0xbfb6, 0xe3 },
	{ 0xbfb7, 0x3e },
	{ 0xbfb8, 0x7 },
	{ 0xbfb9, 0x1a },
	{ 0xbfba, 0xc8 },
	{ 0xbfbb, 0x6a },
	{ 0xbfbc, 0x27 },
	{ 0xbfbd, 0x40 },
	{ 0xbfbe, 0xd4 },
	{ 0xbfbf, 0x8b },
	{ 0xbfc0, 0x5d },
	{ 0xbfc1, 0x1f },
	{ 0xbfc2, 0xc8 },
	{ 0xbfc3, 0xca },
	{ 0xbfc4, 0x87 },
	{ 0xbfc5, 0x40 },
	{ 0xbfc6, 0x94 },
	{ 0xbfc7, 0xe3 },
	{ 0xbfc8, 0xff },
	{ 0xbfc9, 0xff },
	{ 0xbfca, 0x0 },
	{ 0xbfcb, 0x0 },
	{ 0xbfcc, 0x60 },
	{ 0xbfcd, 0xe6 },
	{ 0xbfce, 0x3d },
	{ 0xbfcf, 0x3d },
	{ 0xbfd0, 0x87 },
	{ 0xbfd1, 0x68 },
	{ 0xbfd2, 0x28 },
	{ 0xbfd3, 0x8b },
	{ 0xbfd4, 0x89 },
	{ 0xbfd5, 0x64 },
	{ 0xbfd6, 0xe7 },
	{ 0xbfd7, 0x6a },
	{ 0xbfd8, 0x60 },
	{ 0xbfd9, 0xe7 },
	{ 0xbfda, 0x6d },
	{ 0xbfdb, 0x64 },
	{ 0xbfdc, 0xe7 },
	{ 0xbfdd, 0x23 },
	{ 0xbfde, 0xc8 },
	{ 0xbfdf, 0x6a },
	{ 0xbfe0, 0x27 },
	{ 0xbfe1, 0x40 },
	{ 0xbfe2, 0xd8 },
	{ 0xbfe3, 0x67 },
	{ 0xbfe4, 0x0 },
	{ 0xbfe5, 0x10 },
	{ 0xbfe6, 0xd8 },
	{ 0xbfe7, 0xe7 },
	{ 0xbfe8, 0xff },
	{ 0xbfe9, 0xe8 },
	{ 0xbfea, 0x3d },
	{ 0xbfeb, 0x3 },
	{ 0xbfec, 0x0 },
	{ 0xbfed, 0xcc },
	{ 0xbfee, 0xaa },
	{ 0xbfef, 0x4b },
	{ 0xbff0, 0x40 },
	{ 0xbff1, 0x64 },
	{ 0xbff2, 0xe7 },
	{ 0xbff3, 0x1a },
	{ 0xbff4, 0x6c },
	{ 0xbff5, 0x67 },
	{ 0xbff6, 0x32 },
	{ 0xbff7, 0x60 },
	{ 0xbff8, 0xa6 },
	{ 0xbff9, 0x2d },
	{ 0xbffa, 0x8 },
	{ 0xbffb, 0x6d },
	{ 0xbffc, 0x0 },
	{ 0xbffd, 0x80 },
	{ 0xbffe, 0xd4 },
	{ 0xbfff, 0x89 },
	{ 0xc000, 0x5d },
	{ 0xc001, 0x1f },
	{ 0xc002, 0xcc },
	{ 0xc003, 0xea },
	{ 0xc004, 0x4b },
	{ 0xc005, 0x40 },
	{ 0xc006, 0x5 },
	{ 0xc007, 0xa3 },
	{ 0xc008, 0x28 },
	{ 0xc009, 0x6b },
	{ 0xc00a, 0xb2 },
	{ 0xc00b, 0xd8 },
	{ 0xc00c, 0xa0 },
	{ 0xc00d, 0x0 },
	{ 0xc00e, 0x8 },
	{ 0xc00f, 0x8 },
	{ 0xc010, 0xe3 },
	{ 0xc011, 0x6c },
	{ 0xc012, 0xe7 },
	{ 0xc013, 0x30 },
	{ 0xc014, 0x8 },
	{ 0xc015, 0xef },
	{ 0xc016, 0x8 },
	{ 0xc017, 0xe3 },
	{ 0xc018, 0x0 },
	{ 0xc019, 0xff },
	{ 0xc01a, 0x8 },
	{ 0xc01b, 0x6f },
	{ 0xc01c, 0x64 },
	{ 0xc01d, 0x67 },
	{ 0xc01e, 0x1c },
	{ 0xc01f, 0x0 },
	{ 0xc020, 0x80 },
	{ 0xc021, 0xd4 },
	{ 0xc022, 0x76 },
	{ 0xc023, 0x5d },
	{ 0xc024, 0x1f },
	{ 0xc025, 0xc8 },
	{ 0xc026, 0xca },
	{ 0xc027, 0xe7 },
	{ 0xc028, 0x40 },
	{ 0xc029, 0x24 },
	{ 0xc02a, 0xeb },
	{ 0xc02b, 0xc9 },
	{ 0xc02c, 0x60 },
	{ 0xc02d, 0x63 },
	{ 0xc02e, 0x35 },
	{ 0xc02f, 0xd8 },
	{ 0xc030, 0xa0 },
	{ 0xc031, 0x0 },
	{ 0xc032, 0x8 },
	{ 0xc033, 0x0 },
	{ 0xc034, 0x80 },
	{ 0xc035, 0x64 },
	{ 0xc036, 0x63 },
	{ 0xc037, 0x3b },
	{ 0xc038, 0x30 },
	{ 0xc039, 0xe3 },
	{ 0xc03a, 0xf0 },
	{ 0xc03b, 0x3d },
	{ 0xc03c, 0x3 },
	{ 0xc03d, 0x0 },
	{ 0xc03e, 0x64 },
	{ 0xc03f, 0x67 },
	{ 0xc040, 0x1a },
	{ 0xc041, 0x6c },
	{ 0xc042, 0x63 },
	{ 0xc043, 0x22 },
	{ 0xc044, 0x8 },
	{ 0xc045, 0x66 },
	{ 0xc046, 0xd4 },
	{ 0xc047, 0x92 },
	{ 0xc048, 0x5d },
	{ 0xc049, 0x1f },
	{ 0xc04a, 0xc8 },
	{ 0xc04b, 0xaa },
	{ 0xc04c, 0x87 },
	{ 0xc04d, 0x40 },
	{ 0xc04e, 0xcc },
	{ 0xc04f, 0xea },
	{ 0xc050, 0x5d },
	{ 0xc051, 0x40 },
	{ 0xc052, 0x61 },
	{ 0xc053, 0x65 },
	{ 0xc054, 0x65 },
	{ 0xc055, 0x0 },
	{ 0xc056, 0x80 },
	{ 0xc057, 0x64 },
	{ 0xc058, 0xeb },
	{ 0xc059, 0x3b },
	{ 0xc05a, 0xc8 },
	{ 0xc05b, 0x6a },
	{ 0xc05c, 0x67 },
	{ 0xc05d, 0x40 },
	{ 0xc05e, 0xd9 },
	{ 0xc05f, 0x67 },
	{ 0xc060, 0x0 },
	{ 0xc061, 0x10 },
	{ 0xc062, 0xd8 },
	{ 0xc063, 0xe7 },
	{ 0xc064, 0xff },
	{ 0xc065, 0xe8 },
	{ 0xc066, 0x3d },
	{ 0xc067, 0xb },
	{ 0xc068, 0x0 },
	{ 0xc069, 0x65 },
	{ 0xc06a, 0x67 },
	{ 0xc06b, 0x5a },
	{ 0xc06c, 0x6d },
	{ 0xc06d, 0x6b },
	{ 0xc06e, 0x32 },
	{ 0xc06f, 0x61 },
	{ 0xc070, 0x65 },
	{ 0xc071, 0x5d },
	{ 0xc072, 0x60 },
	{ 0xc073, 0xeb },
	{ 0xc074, 0x6d },
	{ 0xc075, 0x94 },
	{ 0xc076, 0x63 },
	{ 0xc077, 0xff },
	{ 0xc078, 0xff },
	{ 0xc079, 0x0 },
	{ 0xc07a, 0x0 },
	{ 0xc07b, 0x64 },
	{ 0xc07c, 0x67 },
	{ 0xc07d, 0x1b },
	{ 0xc07e, 0xd8 },
	{ 0xc07f, 0xe3 },
	{ 0xc080, 0xff },
	{ 0xc081, 0xf0 },
	{ 0xc082, 0x3d },
	{ 0xc083, 0x3 },
	{ 0xc084, 0x0 },
	{ 0xc085, 0x64 },
	{ 0xc086, 0x67 },
	{ 0xc087, 0x1a },
	{ 0xc088, 0x6c },
	{ 0xc089, 0x63 },
	{ 0xc08a, 0x32 },
	{ 0xc08b, 0x8 },
	{ 0xc08c, 0x6d },
	{ 0xc08d, 0xcc },
	{ 0xc08e, 0xea },
	{ 0xc08f, 0x4b },
	{ 0xc090, 0x40 },
	{ 0xc091, 0x60 },
	{ 0xc092, 0xa5 },
	{ 0xc093, 0x3d },
	{ 0xc094, 0xd4 },
	{ 0xc095, 0xdf },
	{ 0xc096, 0x9d },
	{ 0xc097, 0x1f },
	{ 0xc098, 0xc8 },
	{ 0xc099, 0xea },
	{ 0xc09a, 0x87 },
	{ 0xc09b, 0x40 },
	{ 0xc09c, 0x6 },
	{ 0xc09d, 0x3 },
	{ 0xc09e, 0xcc },
	{ 0xc09f, 0x6a },
	{ 0xc0a0, 0x4b },
	{ 0xc0a1, 0x40 },
	{ 0xc0a2, 0xd8 },
	{ 0xc0a3, 0xa0 },
	{ 0xc0a4, 0x0 },
	{ 0xc0a5, 0x8 },
	{ 0xc0a6, 0x60 },
	{ 0xc0a7, 0xe7 },
	{ 0xc0a8, 0x1d },
	{ 0xc0a9, 0x60 },
	{ 0xc0aa, 0xe7 },
	{ 0xc0ab, 0x85 },
	{ 0xc0ac, 0x6c },
	{ 0xc0ad, 0xe7 },
	{ 0xc0ae, 0x30 },
	{ 0xc0af, 0x0 },
	{ 0xc0b0, 0x80 },
	{ 0xc0b1, 0xcc },
	{ 0xc0b2, 0x6a },
	{ 0xc0b3, 0x6d },
	{ 0xc0b4, 0x40 },
	{ 0xc0b5, 0x60 },
	{ 0xc0b6, 0x63 },
	{ 0xc0b7, 0x65 },
	{ 0xc0b8, 0x0 },
	{ 0xc0b9, 0x78 },
	{ 0xc0ba, 0x64 },
	{ 0xc0bb, 0x67 },
	{ 0xc0bc, 0x1c },
	{ 0xc0bd, 0xd4 },
	{ 0xc0be, 0x4b },
	{ 0xc0bf, 0x9d },
	{ 0xc0c0, 0x1f },
	{ 0xc0c1, 0xcc },
	{ 0xc0c2, 0xca },
	{ 0xc0c3, 0x6d },
	{ 0xc0c4, 0x40 },
	{ 0xc0c5, 0x5 },
	{ 0xc0c6, 0xe3 },
	{ 0xc0c7, 0xd3 },
	{ 0xc0c8, 0x1c },
	{ 0xc0c9, 0x6d },
	{ 0xc0ca, 0x40 },
	{ 0xc0cb, 0xcc },
	{ 0xc0cc, 0xaa },
	{ 0xc0cd, 0x61 },
	{ 0xc0ce, 0x40 },
	{ 0xc0cf, 0xd8 },
	{ 0xc0d0, 0xe0 },
	{ 0xc0d1, 0x0 },
	{ 0xc0d2, 0xa },
	{ 0xc0d3, 0x60 },
	{ 0xc0d4, 0xe7 },
	{ 0xc0d5, 0x2d },
	{ 0xc0d6, 0x60 },
	{ 0xc0d7, 0xa6 },
	{ 0xc0d8, 0x75 },
	{ 0xc0d9, 0x64 },
	{ 0xc0da, 0xa3 },
	{ 0xc0db, 0x2b },
	{ 0xc0dc, 0xd8 },
	{ 0xc0dd, 0xc5 },
	{ 0xc0de, 0x0 },
	{ 0xc0df, 0x10 },
	{ 0xc0e0, 0xd8 },
	{ 0xc0e1, 0xa5 },
	{ 0xc0e2, 0xff },
	{ 0xc0e3, 0xe8 },
	{ 0xc0e4, 0x3d },
	{ 0xc0e5, 0x6 },
	{ 0xc0e6, 0x0 },
	{ 0xc0e7, 0x64 },
	{ 0xc0e8, 0xa5 },
	{ 0xc0e9, 0x32 },
	{ 0xc0ea, 0x6c },
	{ 0xc0eb, 0xa5 },
	{ 0xc0ec, 0x32 },
	{ 0xc0ed, 0x60 },
	{ 0xc0ee, 0xa7 },
	{ 0xc0ef, 0x2d },
	{ 0xc0f0, 0xd },
	{ 0xc0f1, 0x80 },
	{ 0xc0f2, 0xcc },
	{ 0xc0f3, 0xaa },
	{ 0xc0f4, 0x6b },
	{ 0xc0f5, 0x40 },
	{ 0xc0f6, 0xcd },
	{ 0xc0f7, 0xca },
	{ 0xc0f8, 0x61 },
	{ 0xc0f9, 0x40 },
	{ 0xc0fa, 0xd8 },
	{ 0xc0fb, 0xe0 },
	{ 0xc0fc, 0x0 },
	{ 0xc0fd, 0xa },
	{ 0xc0fe, 0x61 },
	{ 0xc0ff, 0xc7 },
	{ 0xc100, 0x75 },
	{ 0xc101, 0x3d },
	{ 0xc102, 0x8e },
	{ 0xc103, 0x28 },
	{ 0xc104, 0x65 },
	{ 0xc105, 0xc5 },
	{ 0xc106, 0x72 },
	{ 0xc107, 0xd4 },
	{ 0xc108, 0x10 },
	{ 0xc109, 0xbd },
	{ 0xc10a, 0x1f },
	{ 0xc10b, 0x9d },
	{ 0xc10c, 0xc3 },
	{ 0xc10d, 0x30 },
	{ 0xc10e, 0x0 },
	{ 0xc10f, 0x90 },
	{ 0xc110, 0x0 },
	{ 0xc111, 0x47 },
	{ 0xc112, 0x27 },
	{ 0xc113, 0x80 },
	{ 0xc114, 0xc8 },
	{ 0xc115, 0x8a },
	{ 0xc116, 0xa7 },
	{ 0xc117, 0x40 },
	{ 0xc118, 0xc8 },
	{ 0xc119, 0xaa },
	{ 0xc11a, 0xe7 },
	{ 0xc11b, 0x40 },
	{ 0xc11c, 0x2d },
	{ 0xc11d, 0xc1 },
	{ 0xc11e, 0x0 },
	{ 0xc11f, 0x98 },
	{ 0xc120, 0x60 },
	{ 0xc121, 0xe4 },
	{ 0xc122, 0x78 },
	{ 0xc123, 0x18 },
	{ 0xc124, 0x0 },
	{ 0xc125, 0x4 },
	{ 0xc126, 0xcb },
	{ 0xc127, 0x4 },
	{ 0xc128, 0xf0 },
	{ 0xc129, 0x5 },
	{ 0xc12a, 0xd },
	{ 0xc12b, 0xd4 },
	{ 0xc12c, 0xf3 },
	{ 0xc12d, 0xac },
	{ 0xc12e, 0x1f },
	{ 0xc12f, 0xd4 },
	{ 0xc130, 0x7 },
	{ 0xc131, 0x3d },
	{ 0xc132, 0x1f },
	{ 0xc133, 0x9d },
	{ 0xc134, 0xc3 },
	{ 0xc135, 0x30 },
	{ 0xc136, 0x0 },
	{ 0xc137, 0x90 },
	{ 0xc138, 0x0 },
	{ 0xc139, 0x47 },
	{ 0xc13a, 0x2b },
	{ 0xc13b, 0x80 },
	{ 0xc13c, 0xc8 },
	{ 0xc13d, 0xaa },
	{ 0xc13e, 0x87 },
	{ 0xc13f, 0x40 },
	{ 0xc140, 0xcc },
	{ 0xc141, 0xca },
	{ 0xc142, 0x4b },
	{ 0xc143, 0x40 },
	{ 0xc144, 0xcc },
	{ 0xc145, 0xea },
	{ 0xc146, 0x6d },
	{ 0xc147, 0x40 },
	{ 0xc148, 0x98 },
	{ 0xc149, 0x60 },
	{ 0xc14a, 0x37 },
	{ 0xc14b, 0xb8 },
	{ 0xc14c, 0x18 },
	{ 0xc14d, 0x0 },
	{ 0xc14e, 0x4 },
	{ 0xc14f, 0x8f },
	{ 0xc150, 0x5 },
	{ 0xc151, 0xc },
	{ 0xc152, 0xd4 },
	{ 0xc153, 0x15 },
	{ 0xc154, 0xac },
	{ 0xc155, 0x1f },
	{ 0xc156, 0x4 },
	{ 0xc157, 0x6e },
	{ 0xc158, 0x47 },
	{ 0xc159, 0xb1 },
	{ 0xc15a, 0x40 },
	{ 0xc15b, 0x47 },
	{ 0xc15c, 0xaa },
	{ 0xc15d, 0xc0 },
	{ 0xc15e, 0x5 },
	{ 0xc15f, 0x63 },
	{ 0xc160, 0xc8 },
	{ 0xc161, 0x65 },
	{ 0xc162, 0x87 },
	{ 0xc163, 0x40 },
	{ 0xc164, 0x5 },
	{ 0xc165, 0x85 },
	{ 0xc166, 0x5 },
	{ 0xc167, 0x44 },
	{ 0xc168, 0x98 },
	{ 0xc169, 0xa0 },
	{ 0xc16a, 0x0 },
	{ 0xc16b, 0x3 },
	{ 0xc16c, 0x0 },
	{ 0xc16d, 0x0 },
	{ 0xc16e, 0xd8 },
	{ 0xc16f, 0x80 },
	{ 0xc170, 0x0 },
	{ 0xc171, 0xa },
	{ 0xc172, 0x2c },
	{ 0xc173, 0xc1 },
	{ 0xc174, 0x20 },
	{ 0xc175, 0xd4 },
	{ 0xc176, 0x58 },
	{ 0xc177, 0x9d },
	{ 0xc178, 0x1f },
	{ 0xc179, 0xc8 },
	{ 0xc17a, 0x6c },
	{ 0xc17b, 0x7 },
	{ 0xc17c, 0x40 },
	{ 0xc17d, 0x4 },
	{ 0xc17e, 0xa3 },
	{ 0xc17f, 0x24 },
	{ 0xc180, 0xeb },
	{ 0xc181, 0xd9 },
	{ 0xc182, 0x2c },
	{ 0xc183, 0xc1 },
	{ 0xc184, 0x60 },
	{ 0xc185, 0x41 },
	{ 0xc186, 0x7 },
	{ 0xc187, 0x42 },
	{ 0xc188, 0xcc },
	{ 0xc189, 0x8c },
	{ 0xc18a, 0x6d },
	{ 0xc18b, 0x40 },
	{ 0xc18c, 0xd3 },
	{ 0xc18d, 0xc },
	{ 0xc18e, 0x48 },
	{ 0xc18f, 0x40 },
	{ 0xc190, 0x24 },
	{ 0xc191, 0xeb },
	{ 0xc192, 0x9c },
	{ 0xc193, 0x60 },
	{ 0xc194, 0xc4 },
	{ 0xc195, 0x35 },
	{ 0xc196, 0x64 },
	{ 0xc197, 0xc6 },
	{ 0xc198, 0x3b },
	{ 0xc199, 0x30 },
	{ 0xc19a, 0xe6 },
	{ 0xc19b, 0x10 },
	{ 0xc19c, 0x30 },
	{ 0xc19d, 0xc6 },
	{ 0xc19e, 0xe8 },
	{ 0xc19f, 0x3d },
	{ 0xc1a0, 0x7 },
	{ 0xc1a1, 0x0 },
	{ 0xc1a2, 0x64 },
	{ 0xc1a3, 0xc6 },
	{ 0xc1a4, 0x3a },
	{ 0xc1a5, 0x6c },
	{ 0xc1a6, 0xc6 },
	{ 0xc1a7, 0x22 },
	{ 0xc1a8, 0x60 },
	{ 0xc1a9, 0xc4 },
	{ 0xc1aa, 0x35 },
	{ 0xc1ab, 0xc },
	{ 0xc1ac, 0xe0 },
	{ 0xc1ad, 0x24 },
	{ 0xc1ae, 0xeb },
	{ 0xc1af, 0xe0 },
	{ 0xc1b0, 0x60 },
	{ 0xc1b1, 0xc6 },
	{ 0xc1b2, 0x25 },
	{ 0xc1b3, 0x64 },
	{ 0xc1b4, 0xc6 },
	{ 0xc1b5, 0x3b },
	{ 0xc1b6, 0x30 },
	{ 0xc1b7, 0xe6 },
	{ 0xc1b8, 0x10 },
	{ 0xc1b9, 0x30 },
	{ 0xc1ba, 0xc6 },
	{ 0xc1bb, 0xe8 },
	{ 0xc1bc, 0x3d },
	{ 0xc1bd, 0x7 },
	{ 0xc1be, 0x0 },
	{ 0xc1bf, 0x64 },
	{ 0xc1c0, 0xc6 },
	{ 0xc1c1, 0x3a },
	{ 0xc1c2, 0x6c },
	{ 0xc1c3, 0xc6 },
	{ 0xc1c4, 0x22 },
	{ 0xc1c5, 0x8 },
	{ 0xc1c6, 0xc4 },
	{ 0xc1c7, 0xd8 },
	{ 0xc1c8, 0x80 },
	{ 0xc1c9, 0x0 },
	{ 0xc1ca, 0xa },
	{ 0xc1cb, 0x4 },
	{ 0xc1cc, 0x66 },
	{ 0xc1cd, 0x3e },
	{ 0xc1ce, 0x5 },
	{ 0xc1cf, 0x2a },
	{ 0xc1d0, 0xd4 },
	{ 0xc1d1, 0xfd },
	{ 0xc1d2, 0x1d },
	{ 0xc1d3, 0x1f },
	{ 0xc1d4, 0xcc },
	{ 0xc1d5, 0x6c },
	{ 0xc1d6, 0x2d },
	{ 0xc1d7, 0x40 },
	{ 0xc1d8, 0x24 },
	{ 0xc1d9, 0xeb },
	{ 0xc1da, 0x45 },
	{ 0xc1db, 0x40 },
	{ 0xc1dc, 0x7 },
	{ 0xc1dd, 0x88 },
	{ 0xc1de, 0x2c },
	{ 0xc1df, 0x6b },
	{ 0xc1e0, 0x5d },
	{ 0xc1e1, 0x6c },
	{ 0xc1e2, 0x63 },
	{ 0xc1e3, 0x20 },
	{ 0xc1e4, 0xd4 },
	{ 0xc1e5, 0x5d },
	{ 0xc1e6, 0x9d },
	{ 0xc1e7, 0x1f },
	{ 0xc1e8, 0xcc },
	{ 0xc1e9, 0x6c },
	{ 0xc1ea, 0x2d },
	{ 0xc1eb, 0x40 },
	{ 0xc1ec, 0x24 },
	{ 0xc1ed, 0xeb },
	{ 0xc1ee, 0x5 },
	{ 0xc1ef, 0x40 },
	{ 0xc1f0, 0x7 },
	{ 0xc1f1, 0x34 },
	{ 0xc1f2, 0x24 },
	{ 0xc1f3, 0xeb },
	{ 0xc1f4, 0x85 },
	{ 0xc1f5, 0x2c },
	{ 0xc1f6, 0x6b },
	{ 0xc1f7, 0x79 },
	{ 0xc1f8, 0xcd },
	{ 0xc1f9, 0xac },
	{ 0xc1fa, 0x6d },
	{ 0xc1fb, 0x40 },
	{ 0xc1fc, 0x3e },
	{ 0xc1fd, 0x7 },
	{ 0xc1fe, 0x39 },
	{ 0xc1ff, 0x6c },
	{ 0xc200, 0x63 },
	{ 0xc201, 0x20 },
	{ 0xc202, 0x6c },
	{ 0xc203, 0xe7 },
	{ 0xc204, 0x10 },
	{ 0xc205, 0x9 },
	{ 0xc206, 0xa7 },
	{ 0xc207, 0xd4 },
	{ 0xc208, 0xe9 },
	{ 0xc209, 0x9d },
	{ 0xc20a, 0x1f },
	{ 0xc20b, 0xc8 },
	{ 0xc20c, 0xac },
	{ 0xc20d, 0x87 },
	{ 0xc20e, 0x40 },
	{ 0xc20f, 0x4 },
	{ 0xc210, 0x83 },
	{ 0xc211, 0x4 },
	{ 0xc212, 0x6d },
	{ 0xc213, 0xd4 },
	{ 0xc214, 0x3e },
	{ 0xc215, 0x1d },
	{ 0xc216, 0x1f },
	{ 0xc217, 0xcc },
	{ 0xc218, 0x6c },
	{ 0xc219, 0x2d },
	{ 0xc21a, 0x40 },
	{ 0xc21b, 0xc8 },
	{ 0xc21c, 0xec },
	{ 0xc21d, 0xed },
	{ 0xc21e, 0x40 },
	{ 0xc21f, 0xc8 },
	{ 0xc220, 0xea },
	{ 0xc221, 0x35 },
	{ 0xc222, 0x80 },
	{ 0xc223, 0xc8 },
	{ 0xc224, 0xea },
	{ 0xc225, 0x25 },
	{ 0xc226, 0x80 },
	{ 0xc227, 0x28 },
	{ 0xc228, 0xeb },
	{ 0xc229, 0xf },
	{ 0xc22a, 0x47 },
	{ 0xc22b, 0xba },
	{ 0xc22c, 0xc0 },
	{ 0xc22d, 0x47 },
	{ 0xc22e, 0xa7 },
	{ 0xc22f, 0x40 },
	{ 0xc230, 0x25 },
	{ 0xc231, 0x44 },
	{ 0xc232, 0x2f },
	{ 0xc233, 0x24 },
	{ 0xc234, 0xe4 },
	{ 0xc235, 0xaf },
	{ 0xc236, 0x5 },
	{ 0xc237, 0x83 },
	{ 0xc238, 0x6d },
	{ 0xc239, 0x4a },
	{ 0xc23a, 0x10 },
	{ 0xc23b, 0x9 },
	{ 0xc23c, 0x47 },
	{ 0xc23d, 0x6 },
	{ 0xc23e, 0xa4 },
	{ 0xc23f, 0x24 },
	{ 0xc240, 0x64 },
	{ 0xc241, 0x4f },
	{ 0xc242, 0x24 },
	{ 0xc243, 0xe4 },
	{ 0xc244, 0xcf },
	{ 0xc245, 0x6c },
	{ 0xc246, 0x63 },
	{ 0xc247, 0x10 },
	{ 0xc248, 0x8 },
	{ 0xc249, 0x67 },
	{ 0xc24a, 0x6c },
	{ 0xc24b, 0x63 },
	{ 0xc24c, 0x20 },
	{ 0xc24d, 0x5 },
	{ 0xc24e, 0x65 },
	{ 0xc24f, 0x5 },
	{ 0xc250, 0xa6 },
	{ 0xc251, 0x25 },
	{ 0xc252, 0xc4 },
	{ 0xc253, 0xe2 },
	{ 0xc254, 0x25 },
	{ 0xc255, 0xe4 },
	{ 0xc256, 0x4a },
	{ 0xc257, 0xd4 },
	{ 0xc258, 0xe2 },
	{ 0xc259, 0x9d },
	{ 0xc25a, 0x1f },
	{ 0xc25b, 0x6 },
	{ 0xc25c, 0x63 },
	{ 0xc25d, 0x6c },
	{ 0xc25e, 0x6a },
	{ 0xc25f, 0x20 },
	{ 0xc260, 0xd4 },
	{ 0xc261, 0x7c },
	{ 0xc262, 0x9d },
	{ 0xc263, 0x1f },
	{ 0xc264, 0x6 },
	{ 0xc265, 0x43 },
	{ 0xc266, 0x28 },
	{ 0xc267, 0x75 },
	{ 0xc268, 0xa5 },
	{ 0xc269, 0x2 },
	{ 0xc26a, 0xcf },
	{ 0xc26b, 0x6c },
	{ 0xc26c, 0x63 },
	{ 0xc26d, 0x20 },
	{ 0xc26e, 0xd4 },
	{ 0xc26f, 0xc },
	{ 0xc270, 0x9d },
	{ 0xc271, 0x1f },
	{ 0xc272, 0x5 },
	{ 0xc273, 0x43 },
	{ 0xc274, 0x28 },
	{ 0xc275, 0x75 },
	{ 0xc276, 0xe5 },
	{ 0xc277, 0x6d },
	{ 0xc278, 0xef },
	{ 0xc279, 0x21 },
	{ 0xc27a, 0x6c },
	{ 0xc27b, 0x63 },
	{ 0xc27c, 0x20 },
	{ 0xc27d, 0xd4 },
	{ 0xc27e, 0x84 },
	{ 0xc27f, 0x9d },
	{ 0xc280, 0x1f },
	{ 0xc281, 0x6 },
	{ 0xc282, 0x23 },
	{ 0xc283, 0x28 },
	{ 0xc284, 0x75 },
	{ 0xc285, 0x95 },
	{ 0xc286, 0x6c },
	{ 0xc287, 0x63 },
	{ 0xc288, 0x20 },
	{ 0xc289, 0xd4 },
	{ 0xc28a, 0xa8 },
	{ 0xc28b, 0x9d },
	{ 0xc28c, 0x1f },
	{ 0xc28d, 0x6 },
	{ 0xc28e, 0x3 },
	{ 0xc28f, 0x28 },
	{ 0xc290, 0x75 },
	{ 0xc291, 0x92 },
	{ 0xc292, 0x6c },
	{ 0xc293, 0x63 },
	{ 0xc294, 0x20 },
	{ 0xc295, 0xd4 },
	{ 0xc296, 0x90 },
	{ 0xc297, 0x9d },
	{ 0xc298, 0x1f },
	{ 0xc299, 0x6 },
	{ 0xc29a, 0x83 },
	{ 0xc29b, 0x24 },
	{ 0xc29c, 0x75 },
	{ 0xc29d, 0x6a },
	{ 0xc29e, 0x6f },
	{ 0xc29f, 0xe },
	{ 0xc2a0, 0x21 },
	{ 0xc2a1, 0x62 },
	{ 0xc2a2, 0xd6 },
	{ 0xc2a3, 0xc7 },
	{ 0xc2a4, 0x0 },
	{ 0xc2a5, 0x80 },
	{ 0xc2a6, 0x2f },
	{ 0xc2a7, 0x1 },
	{ 0xc2a8, 0x20 },
	{ 0xc2a9, 0x0 },
	{ 0xc2aa, 0xac },
	{ 0xc2ab, 0xd4 },
	{ 0xc2ac, 0xe0 },
	{ 0xc2ad, 0x1d },
	{ 0xc2ae, 0x1f },
	{ 0xc2af, 0x3e },
	{ 0xc2b0, 0x3 },
	{ 0xc2b1, 0x18 },
	{ 0xc2b2, 0x20 },
	{ 0xc2b3, 0x75 },
	{ 0xc2b4, 0x6a },
	{ 0xc2b5, 0x6c },
	{ 0xc2b6, 0xa3 },
	{ 0xc2b7, 0x81 },
	{ 0xc2b8, 0x34 },
	{ 0xc2b9, 0x83 },
	{ 0xc2ba, 0x80 },
	{ 0xc2bb, 0x24 },
	{ 0xc2bc, 0xec },
	{ 0xc2bd, 0xac },
	{ 0xc2be, 0x2f },
	{ 0xc2bf, 0x1 },
	{ 0xc2c0, 0x60 },
	{ 0xc2c1, 0x3c },
	{ 0xc2c2, 0x27 },
	{ 0xc2c3, 0x40 },
	{ 0xc2c4, 0x64 },
	{ 0xc2c5, 0xa5 },
	{ 0xc2c6, 0x2 },
	{ 0xc2c7, 0x6c },
	{ 0xc2c8, 0xe5 },
	{ 0xc2c9, 0x40 },
	{ 0xc2ca, 0x8 },
	{ 0xc2cb, 0xeb },
	{ 0xc2cc, 0x28 },
	{ 0xc2cd, 0xc7 },
	{ 0xc2ce, 0xfe },
	{ 0xc2cf, 0x28 },
	{ 0xc2d0, 0xe7 },
	{ 0xc2d1, 0xd1 },
	{ 0xc2d2, 0x64 },
	{ 0xc2d3, 0xc6 },
	{ 0xc2d4, 0x3b },
	{ 0xc2d5, 0x24 },
	{ 0xc2d6, 0xec },
	{ 0xc2d7, 0x32 },
	{ 0xc2d8, 0x40 },
	{ 0xc2d9, 0x7 },
	{ 0xc2da, 0xa8 },
	{ 0xc2db, 0x41 },
	{ 0xc2dc, 0x5 },
	{ 0xc2dd, 0x10 },
	{ 0xc2de, 0x24 },
	{ 0xc2df, 0xeb },
	{ 0xc2e0, 0xf },
	{ 0xc2e1, 0xe },
	{ 0xc2e2, 0x20 },
	{ 0xc2e3, 0x2 },
	{ 0xc2e4, 0xe0 },
	{ 0xc2e5, 0x41 },
	{ 0xc2e6, 0x85 },
	{ 0xc2e7, 0xc8 },
	{ 0xc2e8, 0x24 },
	{ 0xc2e9, 0xec },
	{ 0xc2ea, 0xb2 },
	{ 0xc2eb, 0xf },
	{ 0xc2ec, 0x80 },
	{ 0xc2ed, 0x8 },
	{ 0xc2ee, 0xab },
	{ 0xc2ef, 0x24 },
	{ 0xc2f0, 0xe5 },
	{ 0xc2f1, 0xf },
	{ 0xc2f2, 0x66 },
	{ 0xc2f3, 0xe4 },
	{ 0xc2f4, 0x3b },
	{ 0xc2f5, 0x3e },
	{ 0xc2f6, 0x17 },
	{ 0xc2f7, 0xb8 },
	{ 0xc2f8, 0x0 },
	{ 0xc2f9, 0x6f },
	{ 0xc2fa, 0xd3 },
	{ 0xc2fb, 0xcd },
	{ 0xc2fc, 0x64 },
	{ 0xc2fd, 0x80 },
	{ 0xc2fe, 0x60 },
	{ 0xc2ff, 0xc6 },
	{ 0xc300, 0xc6 },
	{ 0xc301, 0x34 },
	{ 0xc302, 0x6e },
	{ 0xc303, 0xf0 },
	{ 0xc304, 0x60 },
	{ 0xc305, 0x66 },
	{ 0xc306, 0x1f },
	{ 0xc307, 0x2 },
	{ 0xc308, 0xf8 },
	{ 0xc309, 0x64 },
	{ 0xc30a, 0x63 },
	{ 0xc30b, 0xbd },
	{ 0xc30c, 0x0 },
	{ 0xc30d, 0x80 },
	{ 0xc30e, 0x98 },
	{ 0xc30f, 0xa0 },
	{ 0xc310, 0xff },
	{ 0xc311, 0xff },
	{ 0xc312, 0x0 },
	{ 0xc313, 0x0 },
	{ 0xc314, 0xd4 },
	{ 0xc315, 0x79 },
	{ 0xc316, 0xed },
	{ 0xc317, 0x1f },
	{ 0xc318, 0x28 },
	{ 0xc319, 0x75 },
	{ 0xc31a, 0x77 },
	{ 0xc31b, 0x5 },
	{ 0xc31c, 0xc3 },
	{ 0xc31d, 0x40 },
	{ 0xc31e, 0xf },
	{ 0xc31f, 0xb4 },
	{ 0xc320, 0x28 },
	{ 0xc321, 0xb5 },
	{ 0xc322, 0xe3 },
	{ 0xc323, 0xd3 },
	{ 0xc324, 0x86 },
	{ 0xc325, 0x5b },
	{ 0xc326, 0x0 },
	{ 0xc327, 0x28 },
	{ 0xc328, 0x95 },
	{ 0xc329, 0xa3 },
	{ 0xc32a, 0x4 },
	{ 0xc32b, 0xd1 },
	{ 0xc32c, 0x4 },
	{ 0xc32d, 0xf3 },
	{ 0xc32e, 0xc },
	{ 0xc32f, 0x28 },
	{ 0xc330, 0x28 },
	{ 0xc331, 0xf5 },
	{ 0xc332, 0x93 },
	{ 0xc333, 0xd3 },
	{ 0xc334, 0x86 },
	{ 0xc335, 0x77 },
	{ 0xc336, 0x0 },
	{ 0xc337, 0x4 },
	{ 0xc338, 0x85 },
	{ 0xc339, 0x4 },
	{ 0xc33a, 0xd3 },
	{ 0xc33b, 0x4 },
	{ 0xc33c, 0xa7 },
	{ 0xc33d, 0x4 },
	{ 0xc33e, 0xf2 },
	{ 0xc33f, 0xf },
	{ 0xc340, 0xf0 },
	{ 0xc341, 0x4 },
	{ 0xc342, 0x87 },
	{ 0xc343, 0x28 },
	{ 0xc344, 0xb5 },
	{ 0xc345, 0xd3 },
	{ 0xc346, 0x4 },
	{ 0xc347, 0xd2 },
	{ 0xc348, 0xd },
	{ 0xc349, 0xe0 },
	{ 0xc34a, 0x24 },
	{ 0xc34b, 0xf5 },
	{ 0xc34c, 0x24 },
	{ 0xc34d, 0x40 },
	{ 0xc34e, 0x7 },
	{ 0xc34f, 0xb8 },
	{ 0xc350, 0x24 },
	{ 0xc351, 0xec },
	{ 0xc352, 0xa8 },
	{ 0xc353, 0x28 },
	{ 0xc354, 0x95 },
	{ 0xc355, 0x84 },
	{ 0xc356, 0x30 },
	{ 0xc357, 0xe7 },
	{ 0xc358, 0x3a },
	{ 0xc359, 0x6c },
	{ 0xc35a, 0xe7 },
	{ 0xc35b, 0x80 },
	{ 0xc35c, 0x8 },
	{ 0xc35d, 0xeb },
	{ 0xc35e, 0x4 },
	{ 0xc35f, 0xd1 },
	{ 0xc360, 0x28 },
	{ 0xc361, 0x67 },
	{ 0xc362, 0xa0 },
	{ 0xc363, 0x28 },
	{ 0xc364, 0xb5 },
	{ 0xc365, 0xc4 },
	{ 0xc366, 0x4 },
	{ 0xc367, 0xf0 },
	{ 0xc368, 0xd },
	{ 0xc369, 0xa0 },
	{ 0xc36a, 0x24 },
	{ 0xc36b, 0xf5 },
	{ 0xc36c, 0x2 },
	{ 0xc36d, 0x40 },
	{ 0xc36e, 0x7 },
	{ 0xc36f, 0xe8 },
	{ 0xc370, 0xcc },
	{ 0xc371, 0x6b },
	{ 0xc372, 0x49 },
	{ 0xc373, 0x40 },
	{ 0xc374, 0x28 },
	{ 0xc375, 0x95 },
	{ 0xc376, 0xc2 },
	{ 0xc377, 0x28 },
	{ 0xc378, 0xb5 },
	{ 0xc379, 0xa2 },
	{ 0xc37a, 0x4 },
	{ 0xc37b, 0xd4 },
	{ 0xc37c, 0x4 },
	{ 0xc37d, 0xea },
	{ 0xc37e, 0xd4 },
	{ 0xc37f, 0xea },
	{ 0xc380, 0xed },
	{ 0xc381, 0x1f },
	{ 0xc382, 0x5 },
	{ 0xc383, 0x43 },
	{ 0xc384, 0x24 },
	{ 0xc385, 0xf5 },
	{ 0xc386, 0xca },
	{ 0xc387, 0x40 },
	{ 0xc388, 0x7 },
	{ 0xc389, 0xa2 },
	{ 0xc38a, 0x28 },
	{ 0xc38b, 0x95 },
	{ 0xc38c, 0x93 },
	{ 0xc38d, 0x28 },
	{ 0xc38e, 0xed },
	{ 0xc38f, 0xc0 },
	{ 0xc390, 0x24 },
	{ 0xc391, 0xd5 },
	{ 0xc392, 0x8a },
	{ 0xc393, 0xd3 },
	{ 0xc394, 0x9c },
	{ 0xc395, 0x40 },
	{ 0xc396, 0x80 },
	{ 0xc397, 0x4 },
	{ 0xc398, 0x6e },
	{ 0xc399, 0x28 },
	{ 0xc39a, 0x95 },
	{ 0xc39b, 0xa3 },
	{ 0xc39c, 0x28 },
	{ 0xc39d, 0xb5 },
	{ 0xc39e, 0xe3 },
	{ 0xc39f, 0x4 },
	{ 0xc3a0, 0xca },
	{ 0xc3a1, 0xf },
	{ 0xc3a2, 0x10 },
	{ 0xc3a3, 0x38 },
	{ 0xc3a4, 0xa0 },
	{ 0xc3a5, 0x8 },
	{ 0xc3a6, 0x60 },
	{ 0xc3a7, 0xa5 },
	{ 0xc3a8, 0x35 },
	{ 0xc3a9, 0x4 },
	{ 0xc3aa, 0x6e },
	{ 0xc3ab, 0x66 },
	{ 0xc3ac, 0xe7 },
	{ 0xc3ad, 0x33 },
	{ 0xc3ae, 0x65 },
	{ 0xc3af, 0x4a },
	{ 0xc3b0, 0x2b },
	{ 0xc3b1, 0x4 },
	{ 0xc3b2, 0xc7 },
	{ 0xc3b3, 0x9 },
	{ 0xc3b4, 0x57 },
	{ 0xc3b5, 0x30 },
	{ 0xc3b6, 0xaa },
	{ 0xc3b7, 0xf0 },
	{ 0xc3b8, 0x3d },
	{ 0xc3b9, 0xa },
	{ 0xc3ba, 0x0 },
	{ 0xc3bb, 0x65 },
	{ 0xc3bc, 0x45 },
	{ 0xc3bd, 0x52 },
	{ 0xc3be, 0x6c },
	{ 0xc3bf, 0xea },
	{ 0xc3c0, 0x22 },
	{ 0xc3c1, 0x28 },
	{ 0xc3c2, 0xb5 },
	{ 0xc3c3, 0xd3 },
	{ 0xc3c4, 0xd4 },
	{ 0xc3c5, 0x88 },
	{ 0xc3c6, 0xed },
	{ 0xc3c7, 0x1f },
	{ 0xc3c8, 0x5 },
	{ 0xc3c9, 0x43 },
	{ 0xc3ca, 0xe },
	{ 0xc3cb, 0x68 },
	{ 0xc3cc, 0x24 },
	{ 0xc3cd, 0xf5 },
	{ 0xc3ce, 0x0 },
	{ 0xc3cf, 0x40 },
	{ 0xc3d0, 0x47 },
	{ 0xc3d1, 0x5c },
	{ 0xc3d2, 0xd1 },
	{ 0xc3d3, 0xd0 },
	{ 0xc3d4, 0x73 },
	{ 0xc3d5, 0x0 },
	{ 0xc3d6, 0x41 },
	{ 0xc3d7, 0x87 },
	{ 0xc3d8, 0xb2 },
	{ 0xc3d9, 0x29 },
	{ 0xc3da, 0x4d },
	{ 0xc3db, 0xc0 },
	{ 0xc3dc, 0xf },
	{ 0xc3dd, 0x88 },
	{ 0xc3de, 0x40 },
	{ 0xc3df, 0xc7 },
	{ 0xc3e0, 0x3c },
	{ 0xc3e1, 0x41 },
	{ 0xc3e2, 0x27 },
	{ 0xc3e3, 0x42 },
	{ 0xc3e4, 0x24 },
	{ 0xc3e5, 0xb5 },
	{ 0xc3e6, 0xa },
	{ 0xc3e7, 0x38 },
	{ 0xc3e8, 0xe0 },
	{ 0xc3e9, 0x8 },
	{ 0xc3ea, 0x60 },
	{ 0xc3eb, 0xe7 },
	{ 0xc3ec, 0x2d },
	{ 0xc3ed, 0x28 },
	{ 0xc3ee, 0xcd },
	{ 0xc3ef, 0xc0 },
	{ 0xc3f0, 0x65 },
	{ 0xc3f1, 0x4a },
	{ 0xc3f2, 0x3b },
	{ 0xc3f3, 0x64 },
	{ 0xc3f4, 0xc5 },
	{ 0xc3f5, 0x33 },
	{ 0xc3f6, 0x9 },
	{ 0xc3f7, 0x46 },
	{ 0xc3f8, 0x30 },
	{ 0xc3f9, 0xea },
	{ 0xc3fa, 0x10 },
	{ 0xc3fb, 0x31 },
	{ 0xc3fc, 0x4a },
	{ 0xc3fd, 0xe8 },
	{ 0xc3fe, 0x3d },
	{ 0xc3ff, 0x7 },
	{ 0xc400, 0x0 },
	{ 0xc401, 0x65 },
	{ 0xc402, 0x4a },
	{ 0xc403, 0x3a },
	{ 0xc404, 0x6d },
	{ 0xc405, 0x4a },
	{ 0xc406, 0x22 },
	{ 0xc407, 0xc },
	{ 0xc408, 0xe0 },
	{ 0xc409, 0x28 },
	{ 0xc40a, 0xed },
	{ 0xc40b, 0xc0 },
	{ 0xc40c, 0x9 },
	{ 0xc40d, 0x47 },
	{ 0xc40e, 0x1 },
	{ 0xc40f, 0x58 },
	{ 0xc410, 0x6c },
	{ 0xc411, 0xea },
	{ 0xc412, 0xf9 },
	{ 0xc413, 0x9 },
	{ 0xc414, 0x47 },
	{ 0xc415, 0x6d },
	{ 0xc416, 0x4a },
	{ 0xc417, 0x82 },
	{ 0xc418, 0xf },
	{ 0xc419, 0x40 },
	{ 0xc41a, 0x28 },
	{ 0xc41b, 0xed },
	{ 0xc41c, 0xc0 },
	{ 0xc41d, 0x3d },
	{ 0xc41e, 0x87 },
	{ 0xc41f, 0x50 },
	{ 0xc420, 0x65 },
	{ 0xc421, 0x4a },
	{ 0xc422, 0x3a },
	{ 0xc423, 0xcc },
	{ 0xc424, 0xeb },
	{ 0xc425, 0x7e },
	{ 0xc426, 0x40 },
	{ 0xc427, 0xd8 },
	{ 0xc428, 0x60 },
	{ 0xc429, 0x0 },
	{ 0xc42a, 0xa },
	{ 0xc42b, 0x60 },
	{ 0xc42c, 0x63 },
	{ 0xc42d, 0x3d },
	{ 0xc42e, 0xd8 },
	{ 0xc42f, 0xa0 },
	{ 0xc430, 0x0 },
	{ 0xc431, 0xa },
	{ 0xc432, 0x0 },
	{ 0xc433, 0x80 },
	{ 0xc434, 0xd4 },
	{ 0xc435, 0xda },
	{ 0xc436, 0x6d },
	{ 0xc437, 0x1f },
	{ 0xc438, 0x24 },
	{ 0xc439, 0xb5 },
	{ 0xc43a, 0xdc },
	{ 0xc43b, 0x38 },
	{ 0xc43c, 0xc0 },
	{ 0xc43d, 0x8 },
	{ 0xc43e, 0x60 },
	{ 0xc43f, 0xc6 },
	{ 0xc440, 0x2d },
	{ 0xc441, 0x0 },
	{ 0xc442, 0x80 },
	{ 0xc443, 0x64 },
	{ 0xc444, 0xc3 },
	{ 0xc445, 0x33 },
	{ 0xc446, 0x65 },
	{ 0xc447, 0x4a },
	{ 0xc448, 0x2b },
	{ 0xc449, 0x2c },
	{ 0xc44a, 0x61 },
	{ 0xc44b, 0x20 },
	{ 0xc44c, 0x9 },
	{ 0xc44d, 0x46 },
	{ 0xc44e, 0x30 },
	{ 0xc44f, 0x6a },
	{ 0xc450, 0x10 },
	{ 0xc451, 0x31 },
	{ 0xc452, 0x4a },
	{ 0xc453, 0xe8 },
	{ 0xc454, 0x3d },
	{ 0xc455, 0x3 },
	{ 0xc456, 0x0 },
	{ 0xc457, 0x64 },
	{ 0xc458, 0x6a },
	{ 0xc459, 0x1a },
	{ 0xc45a, 0xd8 },
	{ 0xc45b, 0xa0 },
	{ 0xc45c, 0x0 },
	{ 0xc45d, 0xa },
	{ 0xc45e, 0x6c },
	{ 0xc45f, 0x63 },
	{ 0xc460, 0x22 },
	{ 0xc461, 0xd4 },
	{ 0xc462, 0x74 },
	{ 0xc463, 0x6d },
	{ 0xc464, 0x1f },
	{ 0xc465, 0x2c },
	{ 0xc466, 0xac },
	{ 0xc467, 0x58 },
	{ 0xc468, 0xcc },
	{ 0xc469, 0x6b },
	{ 0xc46a, 0x1 },
	{ 0xc46b, 0x40 },
	{ 0xc46c, 0x4 },
	{ 0xc46d, 0xc3 },
	{ 0xc46e, 0x9d },
	{ 0xc46f, 0xc5 },
	{ 0xc470, 0x80 },
	{ 0xc471, 0x0 },
	{ 0xc472, 0x90 },
	{ 0xc473, 0x0 },
	{ 0xc474, 0x2c },
	{ 0xc475, 0xe1 },
	{ 0xc476, 0x60 },
	{ 0xc477, 0x47 },
	{ 0xc478, 0x26 },
	{ 0xc479, 0x80 },
	{ 0xc47a, 0xcc },
	{ 0xc47b, 0x8b },
	{ 0xc47c, 0x49 },
	{ 0xc47d, 0x40 },
	{ 0xc47e, 0x98 },
	{ 0xc47f, 0x60 },
	{ 0xc480, 0x17 },
	{ 0xc481, 0x78 },
	{ 0xc482, 0x18 },
	{ 0xc483, 0x0 },
	{ 0xc484, 0x4 },
	{ 0xc485, 0xae },
	{ 0xc486, 0x47 },
	{ 0xc487, 0xc7 },
	{ 0xc488, 0x40 },
	{ 0xc489, 0xd5 },
	{ 0xc48a, 0x8e },
	{ 0xc48b, 0x4c },
	{ 0xc48c, 0x1f },
	{ 0xc48d, 0x47 },
	{ 0xc48e, 0xb7 },
	{ 0xc48f, 0x40 },
	{ 0xc490, 0x47 },
	{ 0xc491, 0xad },
	{ 0xc492, 0xc0 },
	{ 0xc493, 0x25 },
	{ 0xc494, 0x44 },
	{ 0xc495, 0x1f },
	{ 0xc496, 0x24 },
	{ 0xc497, 0xe4 },
	{ 0xc498, 0x9f },
	{ 0xc499, 0x5 },
	{ 0xc49a, 0xa3 },
	{ 0xc49b, 0x6d },
	{ 0xc49c, 0x4a },
	{ 0xc49d, 0x10 },
	{ 0xc49e, 0x9 },
	{ 0xc49f, 0x47 },
	{ 0xc4a0, 0x5 },
	{ 0xc4a1, 0xc4 },
	{ 0xc4a2, 0x24 },
	{ 0xc4a3, 0x64 },
	{ 0xc4a4, 0x6f },
	{ 0xc4a5, 0x24 },
	{ 0xc4a6, 0xe4 },
	{ 0xc4a7, 0xef },
	{ 0xc4a8, 0x6c },
	{ 0xc4a9, 0x63 },
	{ 0xc4aa, 0x10 },
	{ 0xc4ab, 0x8 },
	{ 0xc4ac, 0x67 },
	{ 0xc4ad, 0x6c },
	{ 0xc4ae, 0x63 },
	{ 0xc4af, 0x20 },
	{ 0xc4b0, 0x5 },
	{ 0xc4b1, 0x85 },
	{ 0xc4b2, 0x26 },
	{ 0xc4b3, 0x4 },
	{ 0xc4b4, 0x4a },
	{ 0xc4b5, 0x5 },
	{ 0xc4b6, 0xe6 },
	{ 0xc4b7, 0xd4 },
	{ 0xc4b8, 0xe7 },
	{ 0xc4b9, 0x6d },
	{ 0xc4ba, 0x1f },
	{ 0xc4bb, 0x2c },
	{ 0xc4bc, 0x61 },
	{ 0xc4bd, 0x20 },
	{ 0xc4be, 0x6c },
	{ 0xc4bf, 0x6a },
	{ 0xc4c0, 0x20 },
	{ 0xc4c1, 0xd4 },
	{ 0xc4c2, 0xbb },
	{ 0xc4c3, 0x6d },
	{ 0xc4c4, 0x1f },
	{ 0xc4c5, 0x6 },
	{ 0xc4c6, 0x63 },
	{ 0xc4c7, 0x28 },
	{ 0xc4c8, 0x6e },
	{ 0xc4c9, 0xd2 },
	{ 0xc4ca, 0x36 },
	{ 0xc4cb, 0x10 },
	{ 0xc4cc, 0xf0 },
	{ 0xc4cd, 0x6c },
	{ 0xc4ce, 0x63 },
	{ 0xc4cf, 0x20 },
	{ 0xc4d0, 0xd4 },
	{ 0xc4d1, 0x73 },
	{ 0xc4d2, 0x6d },
	{ 0xc4d3, 0x1f },
	{ 0xc4d4, 0x5 },
	{ 0xc4d5, 0x43 },
	{ 0xc4d6, 0x28 },
	{ 0xc4d7, 0x6e },
	{ 0xc4d8, 0xd5 },
	{ 0xc4d9, 0x6c },
	{ 0xc4da, 0x63 },
	{ 0xc4db, 0x20 },
	{ 0xc4dc, 0xd4 },
	{ 0xc4dd, 0x43 },
	{ 0xc4de, 0x6d },
	{ 0xc4df, 0x1f },
	{ 0xc4e0, 0x6 },
	{ 0xc4e1, 0x43 },
	{ 0xc4e2, 0x28 },
	{ 0xc4e3, 0x6e },
	{ 0xc4e4, 0xb5 },
	{ 0xc4e5, 0x6c },
	{ 0xc4e6, 0x63 },
	{ 0xc4e7, 0x20 },
	{ 0xc4e8, 0xd4 },
	{ 0xc4e9, 0x6d },
	{ 0xc4ea, 0x6d },
	{ 0xc4eb, 0x1f },
	{ 0xc4ec, 0x6 },
	{ 0xc4ed, 0x23 },
	{ 0xc4ee, 0x28 },
	{ 0xc4ef, 0x6e },
	{ 0xc4f0, 0xaa },
	{ 0xc4f1, 0x6c },
	{ 0xc4f2, 0x63 },
	{ 0xc4f3, 0x20 },
	{ 0xc4f4, 0xd4 },
	{ 0xc4f5, 0x55 },
	{ 0xc4f6, 0x6d },
	{ 0xc4f7, 0x1f },
	{ 0xc4f8, 0x2c },
	{ 0xc4f9, 0xe1 },
	{ 0xc4fa, 0x60 },
	{ 0xc4fb, 0x29 },
	{ 0xc4fc, 0x6e },
	{ 0xc4fd, 0xf7 },
	{ 0xc4fe, 0x40 },
	{ 0xc4ff, 0x10 },
	{ 0xc500, 0xf4 },
	{ 0xc501, 0x2a },
	{ 0xc502, 0xee },
	{ 0xc503, 0xe3 },
	{ 0xc504, 0xd3 },
	{ 0xc505, 0x97 },
	{ 0xc506, 0x7f },
	{ 0xc507, 0x0 },
	{ 0xc508, 0x4 },
	{ 0xc509, 0x6b },
	{ 0xc50a, 0x28 },
	{ 0xc50b, 0x8e },
	{ 0xc50c, 0xa3 },
	{ 0xc50d, 0x4 },
	{ 0xc50e, 0xb7 },
	{ 0xc50f, 0x4 },
	{ 0xc510, 0xd2 },
	{ 0xc511, 0xc },
	{ 0xc512, 0x28 },
	{ 0xc513, 0x28 },
	{ 0xc514, 0xae },
	{ 0xc515, 0x93 },
	{ 0xc516, 0x4 },
	{ 0xc517, 0x6b },
	{ 0xc518, 0xd3 },
	{ 0xc519, 0x96 },
	{ 0xc51a, 0x53 },
	{ 0xc51b, 0x0 },
	{ 0xc51c, 0x4 },
	{ 0xc51d, 0xc7 },
	{ 0xc51e, 0x4 },
	{ 0xc51f, 0x97 },
	{ 0xc520, 0x4 },
	{ 0xc521, 0xf3 },
	{ 0xc522, 0xf },
	{ 0xc523, 0xf0 },
	{ 0xc524, 0x4 },
	{ 0xc525, 0x85 },
	{ 0xc526, 0x4 },
	{ 0xc527, 0xd3 },
	{ 0xc528, 0x28 },
	{ 0xc529, 0xae },
	{ 0xc52a, 0xd3 },
	{ 0xc52b, 0xd },
	{ 0xc52c, 0xe0 },
	{ 0xc52d, 0x24 },
	{ 0xc52e, 0xee },
	{ 0xc52f, 0x24 },
	{ 0xc530, 0x40 },
	{ 0xc531, 0x7 },
	{ 0xc532, 0xb8 },
	{ 0xc533, 0x24 },
	{ 0xc534, 0xad },
	{ 0xc535, 0xa8 },
	{ 0xc536, 0x28 },
	{ 0xc537, 0x8e },
	{ 0xc538, 0x84 },
	{ 0xc539, 0x30 },
	{ 0xc53a, 0xa5 },
	{ 0xc53b, 0x3a },
	{ 0xc53c, 0x6c },
	{ 0xc53d, 0xa5 },
	{ 0xc53e, 0x80 },
	{ 0xc53f, 0x8 },
	{ 0xc540, 0xac },
	{ 0xc541, 0x4 },
	{ 0xc542, 0xd2 },
	{ 0xc543, 0x28 },
	{ 0xc544, 0x65 },
	{ 0xc545, 0xa0 },
	{ 0xc546, 0x28 },
	{ 0xc547, 0xae },
	{ 0xc548, 0xc4 },
	{ 0xc549, 0x4 },
	{ 0xc54a, 0xf1 },
	{ 0xc54b, 0xd },
	{ 0xc54c, 0xa0 },
	{ 0xc54d, 0x24 },
	{ 0xc54e, 0xee },
	{ 0xc54f, 0x2 },
	{ 0xc550, 0x40 },
	{ 0xc551, 0x7 },
	{ 0xc552, 0xe8 },
	{ 0xc553, 0x4 },
	{ 0xc554, 0xc3 },
	{ 0xc555, 0x28 },
	{ 0xc556, 0x8e },
	{ 0xc557, 0xc2 },
	{ 0xc558, 0xcc },
	{ 0xc559, 0x6c },
	{ 0xc55a, 0x49 },
	{ 0xc55b, 0x40 },
	{ 0xc55c, 0x28 },
	{ 0xc55d, 0xae },
	{ 0xc55e, 0xa2 },
	{ 0xc55f, 0x4 },
	{ 0xc560, 0xea },
	{ 0xc561, 0xd4 },
	{ 0xc562, 0x2e },
	{ 0xc563, 0xad },
	{ 0xc564, 0x1f },
	{ 0xc565, 0x5 },
	{ 0xc566, 0x43 },
	{ 0xc567, 0x24 },
	{ 0xc568, 0xee },
	{ 0xc569, 0x0 },
	{ 0xc56a, 0x40 },
	{ 0xc56b, 0x47 },
	{ 0xc56c, 0x5c },
	{ 0xc56d, 0xd1 },
	{ 0xc56e, 0xd0 },
	{ 0xc56f, 0x73 },
	{ 0xc570, 0x0 },
	{ 0xc571, 0x41 },
	{ 0xc572, 0x87 },
	{ 0xc573, 0xb2 },
	{ 0xc574, 0x29 },
	{ 0xc575, 0x4f },
	{ 0xc576, 0xc0 },
	{ 0xc577, 0xf },
	{ 0xc578, 0x88 },
	{ 0xc579, 0x40 },
	{ 0xc57a, 0xc7 },
	{ 0xc57b, 0x3c },
	{ 0xc57c, 0x41 },
	{ 0xc57d, 0x27 },
	{ 0xc57e, 0x42 },
	{ 0xc57f, 0x24 },
	{ 0xc580, 0xae },
	{ 0xc581, 0xa },
	{ 0xc582, 0x38 },
	{ 0xc583, 0xe0 },
	{ 0xc584, 0x8 },
	{ 0xc585, 0x60 },
	{ 0xc586, 0xe7 },
	{ 0xc587, 0x2d },
	{ 0xc588, 0x28 },
	{ 0xc589, 0xcf },
	{ 0xc58a, 0xc0 },
	{ 0xc58b, 0x65 },
	{ 0xc58c, 0x4a },
	{ 0xc58d, 0x3b },
	{ 0xc58e, 0x64 },
	{ 0xc58f, 0xc5 },
	{ 0xc590, 0x33 },
	{ 0xc591, 0x9 },
	{ 0xc592, 0x46 },
	{ 0xc593, 0x30 },
	{ 0xc594, 0xea },
	{ 0xc595, 0x10 },
	{ 0xc596, 0x31 },
	{ 0xc597, 0x4a },
	{ 0xc598, 0xe8 },
	{ 0xc599, 0x3d },
	{ 0xc59a, 0x7 },
	{ 0xc59b, 0x0 },
	{ 0xc59c, 0x65 },
	{ 0xc59d, 0x4a },
	{ 0xc59e, 0x3a },
	{ 0xc59f, 0x6d },
	{ 0xc5a0, 0x4a },
	{ 0xc5a1, 0x22 },
	{ 0xc5a2, 0xc },
	{ 0xc5a3, 0xe0 },
	{ 0xc5a4, 0x28 },
	{ 0xc5a5, 0xef },
	{ 0xc5a6, 0xc0 },
	{ 0xc5a7, 0x9 },
	{ 0xc5a8, 0x47 },
	{ 0xc5a9, 0x1 },
	{ 0xc5aa, 0x58 },
	{ 0xc5ab, 0x6c },
	{ 0xc5ac, 0xea },
	{ 0xc5ad, 0xf9 },
	{ 0xc5ae, 0x9 },
	{ 0xc5af, 0x47 },
	{ 0xc5b0, 0x6d },
	{ 0xc5b1, 0x4a },
	{ 0xc5b2, 0x82 },
	{ 0xc5b3, 0xf },
	{ 0xc5b4, 0x40 },
	{ 0xc5b5, 0x28 },
	{ 0xc5b6, 0xef },
	{ 0xc5b7, 0xc0 },
	{ 0xc5b8, 0x3d },
	{ 0xc5b9, 0x87 },
	{ 0xc5ba, 0x50 },
	{ 0xc5bb, 0x65 },
	{ 0xc5bc, 0x4a },
	{ 0xc5bd, 0x3a },
	{ 0xc5be, 0xcc },
	{ 0xc5bf, 0xec },
	{ 0xc5c0, 0x7e },
	{ 0xc5c1, 0x40 },
	{ 0xc5c2, 0xd8 },
	{ 0xc5c3, 0x60 },
	{ 0xc5c4, 0x0 },
	{ 0xc5c5, 0xa },
	{ 0xc5c6, 0x60 },
	{ 0xc5c7, 0x63 },
	{ 0xc5c8, 0x3d },
	{ 0xc5c9, 0xd8 },
	{ 0xc5ca, 0xa0 },
	{ 0xc5cb, 0x0 },
	{ 0xc5cc, 0xa },
	{ 0xc5cd, 0x0 },
	{ 0xc5ce, 0x80 },
	{ 0xc5cf, 0xd4 },
	{ 0xc5d0, 0x3 },
	{ 0xc5d1, 0x2d },
	{ 0xc5d2, 0x1f },
	{ 0xc5d3, 0x24 },
	{ 0xc5d4, 0xce },
	{ 0xc5d5, 0xdc },
	{ 0xc5d6, 0x38 },
	{ 0xc5d7, 0xe0 },
	{ 0xc5d8, 0x8 },
	{ 0xc5d9, 0x60 },
	{ 0xc5da, 0xe7 },
	{ 0xc5db, 0x35 },
	{ 0xc5dc, 0xd8 },
	{ 0xc5dd, 0xa0 },
	{ 0xc5de, 0x0 },
	{ 0xc5df, 0xa },
	{ 0xc5e0, 0x0 },
	{ 0xc5e1, 0x80 },
	{ 0xc5e2, 0x64 },
	{ 0xc5e3, 0x63 },
	{ 0xc5e4, 0x3b },
	{ 0xc5e5, 0x65 },
	{ 0xc5e6, 0x4a },
	{ 0xc5e7, 0x33 },
	{ 0xc5e8, 0x9 },
	{ 0xc5e9, 0x43 },
	{ 0xc5ea, 0x30 },
	{ 0xc5eb, 0x6a },
	{ 0xc5ec, 0x10 },
	{ 0xc5ed, 0x31 },
	{ 0xc5ee, 0x4a },
	{ 0xc5ef, 0xe8 },
	{ 0xc5f0, 0x3d },
	{ 0xc5f1, 0x3 },
	{ 0xc5f2, 0x0 },
	{ 0xc5f3, 0x64 },
	{ 0xc5f4, 0x6a },
	{ 0xc5f5, 0x1a },
	{ 0xc5f6, 0x6c },
	{ 0xc5f7, 0x63 },
	{ 0xc5f8, 0x22 },
	{ 0xc5f9, 0xd4 },
	{ 0xc5fa, 0x69 },
	{ 0xc5fb, 0x2d },
	{ 0xc5fc, 0x1f },
	{ 0xc5fd, 0x2c },
	{ 0xc5fe, 0xed },
	{ 0xc5ff, 0x58 },
	{ 0xc600, 0xcc },
	{ 0xc601, 0x6c },
	{ 0xc602, 0x21 },
	{ 0xc603, 0x40 },
	{ 0xc604, 0x4 },
	{ 0xc605, 0x83 },
	{ 0xc606, 0x9d },
	{ 0xc607, 0xc7 },
	{ 0xc608, 0x10 },
	{ 0xc609, 0x0 },
	{ 0xc60a, 0x90 },
	{ 0xc60b, 0x0 },
	{ 0xc60c, 0x47 },
	{ 0xc60d, 0x24 },
	{ 0xc60e, 0x80 },
	{ 0xc60f, 0x98 },
	{ 0xc610, 0x60 },
	{ 0xc611, 0xc3 },
	{ 0xc612, 0x78 },
	{ 0xc613, 0x18 },
	{ 0xc614, 0x0 },
	{ 0xc615, 0x4 },
	{ 0xc616, 0xab },
	{ 0xc617, 0x47 },
	{ 0xc618, 0xcd },
	{ 0xc619, 0xc0 },
	{ 0xc61a, 0xd5 },
	{ 0xc61b, 0x7 },
	{ 0xc61c, 0xc },
	{ 0xc61d, 0x1f },
	{ 0xc61e, 0x47 },
	{ 0xc61f, 0xbd },
	{ 0xc620, 0xc0 },
	{ 0xc621, 0x47 },
	{ 0xc622, 0xa7 },
	{ 0xc623, 0x0 },
	{ 0xc624, 0x6 },
	{ 0xc625, 0x43 },
	{ 0xc626, 0x29 },
	{ 0xc627, 0xe3 },
	{ 0xc628, 0xe6 },
	{ 0xc629, 0x29 },
	{ 0xc62a, 0xa3 },
	{ 0xc62b, 0xee },
	{ 0xc62c, 0xc8 },
	{ 0xc62d, 0x65 },
	{ 0xc62e, 0x87 },
	{ 0xc62f, 0x40 },
	{ 0xc630, 0x6 },
	{ 0xc631, 0x65 },
	{ 0xc632, 0x5 },
	{ 0xc633, 0x84 },
	{ 0xc634, 0x98 },
	{ 0xc635, 0xa0 },
	{ 0xc636, 0x0 },
	{ 0xc637, 0x3 },
	{ 0xc638, 0x0 },
	{ 0xc639, 0x0 },
	{ 0xc63a, 0xd8 },
	{ 0xc63b, 0x80 },
	{ 0xc63c, 0x0 },
	{ 0xc63d, 0xa },
	{ 0xc63e, 0x5 },
	{ 0xc63f, 0x66 },
	{ 0xc640, 0x6 },
	{ 0xc641, 0x27 },
	{ 0xc642, 0x6 },
	{ 0xc643, 0x8 },
	{ 0xc644, 0xd4 },
	{ 0xc645, 0xd2 },
	{ 0xc646, 0x2d },
	{ 0xc647, 0x1f },
	{ 0xc648, 0xc8 },
	{ 0xc649, 0x73 },
	{ 0xc64a, 0x7 },
	{ 0xc64b, 0x40 },
	{ 0xc64c, 0xd8 },
	{ 0xc64d, 0x80 },
	{ 0xc64e, 0x0 },
	{ 0xc64f, 0xa },
	{ 0xc650, 0x98 },
	{ 0xc651, 0xa0 },
	{ 0xc652, 0x0 },
	{ 0xc653, 0x3 },
	{ 0xc654, 0x0 },
	{ 0xc655, 0x0 },
	{ 0xc656, 0x3e },
	{ 0xc657, 0xf },
	{ 0xc658, 0x70 },
	{ 0xc659, 0xcc },
	{ 0xc65a, 0x73 },
	{ 0xc65b, 0x6d },
	{ 0xc65c, 0x40 },
	{ 0xc65d, 0xd4 },
	{ 0xc65e, 0x4c },
	{ 0xc65f, 0x2d },
	{ 0xc660, 0x1f },
	{ 0xc661, 0xca },
	{ 0xc662, 0xd3 },
	{ 0xc663, 0x87 },
	{ 0xc664, 0x40 },
	{ 0xc665, 0xcc },
	{ 0xc666, 0xd3 },
	{ 0xc667, 0x5d },
	{ 0xc668, 0x40 },
	{ 0xc669, 0x60 },
	{ 0xc66a, 0xf6 },
	{ 0xc66b, 0x1d },
	{ 0xc66c, 0x64 },
	{ 0xc66d, 0xe7 },
	{ 0xc66e, 0x33 },
	{ 0xc66f, 0xcd },
	{ 0xc670, 0x53 },
	{ 0xc671, 0x61 },
	{ 0xc672, 0x40 },
	{ 0xc673, 0xda },
	{ 0xc674, 0xa7 },
	{ 0xc675, 0x0 },
	{ 0xc676, 0x10 },
	{ 0xc677, 0xd8 },
	{ 0xc678, 0xe7 },
	{ 0xc679, 0xff },
	{ 0xc67a, 0xe8 },
	{ 0xc67b, 0x3d },
	{ 0xc67c, 0x15 },
	{ 0xc67d, 0x0 },
	{ 0xc67e, 0x66 },
	{ 0xc67f, 0xa7 },
	{ 0xc680, 0xaa },
	{ 0xc681, 0xd8 },
	{ 0xc682, 0xe0 },
	{ 0xc683, 0x0 },
	{ 0xc684, 0xa },
	{ 0xc685, 0x61 },
	{ 0xc686, 0x47 },
	{ 0xc687, 0x55 },
	{ 0xc688, 0x6e },
	{ 0xc689, 0xb5 },
	{ 0xc68a, 0x32 },
	{ 0xc68b, 0x62 },
	{ 0xc68c, 0xa0 },
	{ 0xc68d, 0xad },
	{ 0xc68e, 0x62 },
	{ 0xc68f, 0x80 },
	{ 0xc690, 0xad },
	{ 0xc691, 0xcc },
	{ 0xc692, 0xf3 },
	{ 0xc693, 0x7b },
	{ 0xc694, 0x40 },
	{ 0xc695, 0xcc },
	{ 0xc696, 0x73 },
	{ 0xc697, 0x2d },
	{ 0xc698, 0x40 },
	{ 0xc699, 0x60 },
	{ 0xc69a, 0x63 },
	{ 0xc69b, 0x3d },
	{ 0xc69c, 0x64 },
	{ 0xc69d, 0x63 },
	{ 0xc69e, 0x33 },
	{ 0xc69f, 0xd8 },
	{ 0xc6a0, 0xe3 },
	{ 0xc6a1, 0x0 },
	{ 0xc6a2, 0x10 },
	{ 0xc6a3, 0xd8 },
	{ 0xc6a4, 0x63 },
	{ 0xc6a5, 0xff },
	{ 0xc6a6, 0xe8 },
	{ 0xc6a7, 0x3d },
	{ 0xc6a8, 0x7 },
	{ 0xc6a9, 0x0 },
	{ 0xc6aa, 0x64 },
	{ 0xc6ab, 0x63 },
	{ 0xc6ac, 0x3a },
	{ 0xc6ad, 0x6c },
	{ 0xc6ae, 0x63 },
	{ 0xc6af, 0x32 },
	{ 0xc6b0, 0x61 },
	{ 0xc6b1, 0x4a },
	{ 0xc6b2, 0x1d },
	{ 0xc6b3, 0xd4 },
	{ 0xc6b4, 0x3a },
	{ 0xc6b5, 0xed },
	{ 0xc6b6, 0x1f },
	{ 0xc6b7, 0x9d },
	{ 0xc6b8, 0xc3 },
	{ 0xc6b9, 0xd0 },
	{ 0xc6ba, 0x0 },
	{ 0xc6bb, 0x90 },
	{ 0xc6bc, 0x0 },
	{ 0xc6bd, 0x47 },
	{ 0xc6be, 0x26 },
	{ 0xc6bf, 0x80 },
	{ 0xc6c0, 0x98 },
	{ 0xc6c1, 0x60 },
	{ 0xc6c2, 0x21 },
	{ 0xc6c3, 0x78 },
	{ 0xc6c4, 0x18 },
	{ 0xc6c5, 0x0 },
	{ 0xc6c6, 0x60 },
	{ 0xc6c7, 0xb6 },
	{ 0xc6c8, 0xac },
	{ 0xc6c9, 0x4 },
	{ 0xc6ca, 0x8b },
	{ 0xc6cb, 0x4 },
	{ 0xc6cc, 0xd4 },
	{ 0xc6cd, 0x4 },
	{ 0xc6ce, 0xea },
	{ 0xc6cf, 0xd4 },
	{ 0xc6d0, 0xd4 },
	{ 0xc6d1, 0xc },
	{ 0xc6d2, 0x1f },
	{ 0xc6d3, 0x2b },
	{ 0xc6d4, 0x92 },
	{ 0xc6d5, 0x96 },
	{ 0xc6d6, 0x2b },
	{ 0xc6d7, 0x12 },
	{ 0xc6d8, 0xd6 },
	{ 0xc6d9, 0x6 },
	{ 0xc6da, 0xb4 },
	{ 0xc6db, 0xd3 },
	{ 0xc6dc, 0xf9 },
	{ 0xc6dd, 0x8f },
	{ 0xc6de, 0x88 },
	{ 0xc6df, 0x2b },
	{ 0xc6e0, 0x52 },
	{ 0xc6e1, 0xb6 },
	{ 0xc6e2, 0xd3 },
	{ 0xc6e3, 0xf1 },
	{ 0xc6e4, 0xa1 },
	{ 0xc6e5, 0x88 },
	{ 0xc6e6, 0x2b },
	{ 0xc6e7, 0x72 },
	{ 0xc6e8, 0xf6 },
	{ 0xc6e9, 0xd3 },
	{ 0xc6ea, 0xf5 },
	{ 0xc6eb, 0xb8 },
	{ 0xc6ec, 0x88 },
	{ 0xc6ed, 0x28 },
	{ 0xc6ee, 0x92 },
	{ 0xc6ef, 0x8e },
	{ 0xc6f0, 0x28 },
	{ 0xc6f1, 0xf2 },
	{ 0xc6f2, 0xce },
	{ 0xc6f3, 0xd3 },
	{ 0xc6f4, 0xc8 },
	{ 0xc6f5, 0x7e },
	{ 0xc6f6, 0x8 },
	{ 0xc6f7, 0x2b },
	{ 0xc6f8, 0x32 },
	{ 0xc6f9, 0xae },
	{ 0xc6fa, 0xd3 },
	{ 0xc6fb, 0xcf },
	{ 0xc6fc, 0x90 },
	{ 0xc6fd, 0x8 },
	{ 0xc6fe, 0x28 },
	{ 0xc6ff, 0xb2 },
	{ 0xc700, 0x9e },
	{ 0xc701, 0x2a },
	{ 0xc702, 0xf2 },
	{ 0xc703, 0xde },
	{ 0xc704, 0xd3 },
	{ 0xc705, 0xcb },
	{ 0xc706, 0x76 },
	{ 0xc707, 0xf0 },
	{ 0xc708, 0x28 },
	{ 0xc709, 0xd2 },
	{ 0xc70a, 0xbe },
	{ 0xc70b, 0xd3 },
	{ 0xc70c, 0xee },
	{ 0xc70d, 0x6f },
	{ 0xc70e, 0x70 },
	{ 0xc70f, 0xd3 },
	{ 0xc710, 0x57 },
	{ 0xc711, 0xc5 },
	{ 0xc712, 0x0 },
	{ 0xc713, 0x6 },
	{ 0xc714, 0xa4 },
	{ 0xc715, 0x5 },
	{ 0xc716, 0x45 },
	{ 0xc717, 0xf },
	{ 0xc718, 0x1c },
	{ 0xc719, 0xd3 },
	{ 0xc71a, 0x57 },
	{ 0xc71b, 0x87 },
	{ 0xc71c, 0x20 },
	{ 0xc71d, 0x63 },
	{ 0xc71e, 0x98 },
	{ 0xc71f, 0xe5 },
	{ 0xc720, 0x60 },
	{ 0xc721, 0x87 },
	{ 0xc722, 0x25 },
	{ 0xc723, 0x3 },
	{ 0xc724, 0x98 },
	{ 0xc725, 0x6c },
	{ 0xc726, 0x84 },
	{ 0xc727, 0x30 },
	{ 0xc728, 0x64 },
	{ 0xc729, 0x84 },
	{ 0xc72a, 0xe4 },
	{ 0xc72b, 0x63 },
	{ 0xc72c, 0x18 },
	{ 0xc72d, 0x5d },
	{ 0xc72e, 0x64 },
	{ 0xc72f, 0x98 },
	{ 0xc730, 0x23 },
	{ 0xc731, 0xda },
	{ 0xc732, 0xa4 },
	{ 0xc733, 0x0 },
	{ 0xc734, 0x10 },
	{ 0xc735, 0xd8 },
	{ 0xc736, 0x84 },
	{ 0xc737, 0xff },
	{ 0xc738, 0xe8 },
	{ 0xc739, 0x3d },
	{ 0xc73a, 0x15 },
	{ 0xc73b, 0x0 },
	{ 0xc73c, 0x66 },
	{ 0xc73d, 0xa4 },
	{ 0xc73e, 0xaa },
	{ 0xc73f, 0x6e },
	{ 0xc740, 0xb5 },
	{ 0xc741, 0x32 },
	{ 0xc742, 0x62 },
	{ 0xc743, 0xa7 },
	{ 0xc744, 0xad },
	{ 0xc745, 0x60 },
	{ 0xc746, 0xf7 },
	{ 0xc747, 0x2d },
	{ 0xc748, 0x6c },
	{ 0xc749, 0xe7 },
	{ 0xc74a, 0x30 },
	{ 0xc74b, 0x64 },
	{ 0xc74c, 0xa7 },
	{ 0xc74d, 0xe4 },
	{ 0xc74e, 0x64 },
	{ 0xc74f, 0xb8 },
	{ 0xc750, 0x2b },
	{ 0xc751, 0xd9 },
	{ 0xc752, 0x45 },
	{ 0xc753, 0x0 },
	{ 0xc754, 0x10 },
	{ 0xc755, 0xd8 },
	{ 0xc756, 0xa5 },
	{ 0xc757, 0xff },
	{ 0xc758, 0xe8 },
	{ 0xc759, 0x3d },
	{ 0xc75a, 0xa },
	{ 0xc75b, 0x0 },
	{ 0xc75c, 0x65 },
	{ 0xc75d, 0x45 },
	{ 0xc75e, 0x52 },
	{ 0xc75f, 0x6d },
	{ 0xc760, 0x4a },
	{ 0xc761, 0x32 },
	{ 0xc762, 0x61 },
	{ 0xc763, 0x57 },
	{ 0xc764, 0x55 },
	{ 0xc765, 0xe },
	{ 0xc766, 0xa4 },
	{ 0xc767, 0xd3 },
	{ 0xc768, 0x57 },
	{ 0xc769, 0xa7 },
	{ 0xc76a, 0x20 },
	{ 0xc76b, 0x63 },
	{ 0xc76c, 0x1a },
	{ 0xc76d, 0xc5 },
	{ 0xc76e, 0x60 },
	{ 0xc76f, 0xf9 },
	{ 0xc770, 0x3d },
	{ 0xc771, 0x3 },
	{ 0xc772, 0x18 },
	{ 0xc773, 0x6c },
	{ 0xc774, 0xe7 },
	{ 0xc775, 0x30 },
	{ 0xc776, 0x64 },
	{ 0xc777, 0xe7 },
	{ 0xc778, 0xc4 },
	{ 0xc779, 0x63 },
	{ 0xc77a, 0x5a },
	{ 0xc77b, 0x5d },
	{ 0xc77c, 0x64 },
	{ 0xc77d, 0xfa },
	{ 0xc77e, 0x3b },
	{ 0xc77f, 0xd8 },
	{ 0xc780, 0xa7 },
	{ 0xc781, 0x0 },
	{ 0xc782, 0x10 },
	{ 0xc783, 0xd8 },
	{ 0xc784, 0xe7 },
	{ 0xc785, 0xff },
	{ 0xc786, 0xe8 },
	{ 0xc787, 0x3d },
	{ 0xc788, 0x5 },
	{ 0xc789, 0x0 },
	{ 0xc78a, 0x64 },
	{ 0xc78b, 0xe7 },
	{ 0xc78c, 0x2a },
	{ 0xc78d, 0x6c },
	{ 0xc78e, 0xe7 },
	{ 0xc78f, 0x32 },
	{ 0xc790, 0x62 },
	{ 0xc791, 0xb9 },
	{ 0xc792, 0x3d },
	{ 0xc793, 0x60 },
	{ 0xc794, 0xe6 },
	{ 0xc795, 0xbd },
	{ 0xc796, 0x6c },
	{ 0xc797, 0xe7 },
	{ 0xc798, 0x30 },
	{ 0xc799, 0x66 },
	{ 0xc79a, 0xe7 },
	{ 0xc79b, 0xc4 },
	{ 0xc79c, 0x66 },
	{ 0xc79d, 0xfa },
	{ 0xc79e, 0xbb },
	{ 0xc79f, 0xd9 },
	{ 0xc7a0, 0x57 },
	{ 0xc7a1, 0x0 },
	{ 0xc7a2, 0x10 },
	{ 0xc7a3, 0xda },
	{ 0xc7a4, 0xf7 },
	{ 0xc7a5, 0xff },
	{ 0xc7a6, 0xe8 },
	{ 0xc7a7, 0x3d },
	{ 0xc7a8, 0xa },
	{ 0xc7a9, 0x0 },
	{ 0xc7aa, 0x65 },
	{ 0xc7ab, 0x57 },
	{ 0xc7ac, 0x52 },
	{ 0xc7ad, 0x6d },
	{ 0xc7ae, 0x4a },
	{ 0xc7af, 0x32 },
	{ 0xc7b0, 0x61 },
	{ 0xc7b1, 0x46 },
	{ 0xc7b2, 0x55 },
	{ 0xc7b3, 0xf },
	{ 0xc7b4, 0x88 },
	{ 0xc7b5, 0x6 },
	{ 0xc7b6, 0xb4 },
	{ 0xc7b7, 0xd3 },
	{ 0xc7b8, 0x57 },
	{ 0xc7b9, 0xbc },
	{ 0xc7ba, 0x20 },
	{ 0xc7bb, 0x63 },
	{ 0xc7bc, 0x7b },
	{ 0xc7bd, 0xd5 },
	{ 0xc7be, 0x60 },
	{ 0xc7bf, 0xf4 },
	{ 0xc7c0, 0xcd },
	{ 0xc7c1, 0x61 },
	{ 0xc7c2, 0x4a },
	{ 0xc7c3, 0x35 },
	{ 0xc7c4, 0x3 },
	{ 0xc7c5, 0x78 },
	{ 0xc7c6, 0x6c },
	{ 0xc7c7, 0xe7 },
	{ 0xc7c8, 0x30 },
	{ 0xc7c9, 0x6d },
	{ 0xc7ca, 0x4a },
	{ 0xc7cb, 0x30 },
	{ 0xc7cc, 0x65 },
	{ 0xc7cd, 0x4a },
	{ 0xc7ce, 0xdc },
	{ 0xc7cf, 0x64 },
	{ 0xc7d0, 0xe7 },
	{ 0xc7d1, 0xdc },
	{ 0xc7d2, 0x63 },
	{ 0xc7d3, 0x4b },
	{ 0xc7d4, 0xd5 },
	{ 0xc7d5, 0x64 },
	{ 0xc7d6, 0xfa },
	{ 0xc7d7, 0x3b },
	{ 0xc7d8, 0x67 },
	{ 0xc7d9, 0x5a },
	{ 0xc7da, 0x53 },
	{ 0xc7db, 0xda },
	{ 0xc7dc, 0xa7 },
	{ 0xc7dd, 0xff },
	{ 0xc7de, 0xf0 },
	{ 0xc7df, 0x3d },
	{ 0xc7e0, 0x7 },
	{ 0xc7e1, 0x0 },
	{ 0xc7e2, 0xd9 },
	{ 0xc7e3, 0x5a },
	{ 0xc7e4, 0xff },
	{ 0xc7e5, 0xf0 },
	{ 0xc7e6, 0x64 },
	{ 0xc7e7, 0xf5 },
	{ 0xc7e8, 0x3a },
	{ 0xc7e9, 0x3d },
	{ 0xc7ea, 0x1a },
	{ 0xc7eb, 0x0 },
	{ 0xc7ec, 0x67 },
	{ 0xc7ed, 0x4a },
	{ 0xc7ee, 0xd2 },
	{ 0xc7ef, 0x6c },
	{ 0xc7f0, 0xe7 },
	{ 0xc7f1, 0x32 },
	{ 0xc7f2, 0x6d },
	{ 0xc7f3, 0x5a },
	{ 0xc7f4, 0x32 },
	{ 0xc7f5, 0x62 },
	{ 0xc7f6, 0xb9 },
	{ 0xc7f7, 0x3c },
	{ 0xc7f8, 0x9 },
	{ 0xc7f9, 0x46 },
	{ 0xc7fa, 0x28 },
	{ 0xc7fb, 0x72 },
	{ 0xc7fc, 0xf7 },
	{ 0xc7fd, 0x2a },
	{ 0xc7fe, 0xf2 },
	{ 0xc7ff, 0xe3 },
	{ 0xc800, 0xd3 },
	{ 0xc801, 0x87 },
	{ 0xc802, 0x70 },
	{ 0xc803, 0x80 },
	{ 0xc804, 0x28 },
	{ 0xc805, 0x92 },
	{ 0xc806, 0xa3 },
	{ 0xc807, 0x4 },
	{ 0xc808, 0xb7 },
	{ 0xc809, 0x6c },
	{ 0xc80a, 0xcf },
	{ 0xc80b, 0x11 },
	{ 0xc80c, 0x4 },
	{ 0xc80d, 0xee },
	{ 0xc80e, 0xd },
	{ 0xc80f, 0x60 },
	{ 0xc810, 0x28 },
	{ 0xc811, 0xb2 },
	{ 0xc812, 0x93 },
	{ 0xc813, 0x6c },
	{ 0xc814, 0xed },
	{ 0xc815, 0x11 },
	{ 0xc816, 0x4 },
	{ 0xc817, 0x97 },
	{ 0xc818, 0x4 },
	{ 0xc819, 0xce },
	{ 0xc81a, 0xd3 },
	{ 0xc81b, 0xca },
	{ 0xc81c, 0x37 },
	{ 0xc81d, 0x0 },
	{ 0xc81e, 0x4 },
	{ 0xc81f, 0x85 },
	{ 0xc820, 0x28 },
	{ 0xc821, 0xb2 },
	{ 0xc822, 0xd3 },
	{ 0xc823, 0x4 },
	{ 0xc824, 0xc7 },
	{ 0xc825, 0x3e },
	{ 0xc826, 0xd },
	{ 0xc827, 0x38 },
	{ 0xc828, 0xd4 },
	{ 0xc829, 0xb5 },
	{ 0xc82a, 0x4d },
	{ 0xc82b, 0x1f },
	{ 0xc82c, 0xc8 },
	{ 0xc82d, 0xb3 },
	{ 0xc82e, 0x87 },
	{ 0xc82f, 0x40 },
	{ 0xc830, 0x5 },
	{ 0xc831, 0xa3 },
	{ 0xc832, 0x0 },
	{ 0xc833, 0x80 },
	{ 0xc834, 0x4 },
	{ 0xc835, 0x74 },
	{ 0xc836, 0xd4 },
	{ 0xc837, 0x9a },
	{ 0xc838, 0x4d },
	{ 0xc839, 0x1f },
	{ 0xc83a, 0x5 },
	{ 0xc83b, 0xc3 },
	{ 0xc83c, 0x60 },
	{ 0xc83d, 0x63 },
	{ 0xc83e, 0xad },
	{ 0xc83f, 0x98 },
	{ 0xc840, 0xa0 },
	{ 0xc841, 0x81 },
	{ 0xc842, 0x1 },
	{ 0xc843, 0x1 },
	{ 0xc844, 0x1 },
	{ 0xc845, 0x0 },
	{ 0xc846, 0x80 },
	{ 0xc847, 0x65 },
	{ 0xc848, 0xa3 },
	{ 0xc849, 0x6b },
	{ 0xc84a, 0x68 },
	{ 0xc84b, 0xcd },
	{ 0xc84c, 0x2b },
	{ 0xc84d, 0x4 },
	{ 0xc84e, 0xae },
	{ 0xc84f, 0x8 },
	{ 0xc850, 0xcd },
	{ 0xc851, 0x6c },
	{ 0xc852, 0xc6 },
	{ 0xc853, 0xe2 },
	{ 0xc854, 0x6d },
	{ 0xc855, 0xad },
	{ 0xc856, 0xfa },
	{ 0xc857, 0x60 },
	{ 0xc858, 0x66 },
	{ 0xc859, 0x6d },
	{ 0xc85a, 0x8 },
	{ 0xc85b, 0x75 },
	{ 0xc85c, 0xd4 },
	{ 0xc85d, 0xcc },
	{ 0xc85e, 0x4d },
	{ 0xc85f, 0x1f },
	{ 0xc860, 0xd3 },
	{ 0xc861, 0x6 },
	{ 0xc862, 0xab },
	{ 0xc863, 0x0 },
	{ 0xc864, 0x28 },
	{ 0xc865, 0xf2 },
	{ 0xc866, 0xb6 },
	{ 0xc867, 0x3d },
	{ 0xc868, 0xcb },
	{ 0xc869, 0x38 },
	{ 0xc86a, 0x65 },
	{ 0xc86b, 0x4a },
	{ 0xc86c, 0x1a },
	{ 0xc86d, 0xcc },
	{ 0xc86e, 0xb3 },
	{ 0xc86f, 0x4b },
	{ 0xc870, 0x40 },
	{ 0xc871, 0x24 },
	{ 0xc872, 0xd2 },
	{ 0xc873, 0x21 },
	{ 0xc874, 0x60 },
	{ 0xc875, 0xe3 },
	{ 0xc876, 0x2d },
	{ 0xc877, 0x0 },
	{ 0xc878, 0x80 },
	{ 0xc879, 0x64 },
	{ 0xc87a, 0xe7 },
	{ 0xc87b, 0x33 },
	{ 0xc87c, 0x30 },
	{ 0xc87d, 0xc7 },
	{ 0xc87e, 0xf0 },
	{ 0xc87f, 0x3d },
	{ 0xc880, 0x7 },
	{ 0xc881, 0x0 },
	{ 0xc882, 0x64 },
	{ 0xc883, 0xe6 },
	{ 0xc884, 0x3a },
	{ 0xc885, 0x6c },
	{ 0xc886, 0xe7 },
	{ 0xc887, 0x22 },
	{ 0xc888, 0x60 },
	{ 0xc889, 0x65 },
	{ 0xc88a, 0x3c },
	{ 0xc88b, 0xc8 },
	{ 0xc88c, 0xb3 },
	{ 0xc88d, 0x87 },
	{ 0xc88e, 0x40 },
	{ 0xc88f, 0xcc },
	{ 0xc890, 0x73 },
	{ 0xc891, 0xb },
	{ 0xc892, 0x40 },
	{ 0xc893, 0xd4 },
	{ 0xc894, 0x3f },
	{ 0xc895, 0x8d },
	{ 0xc896, 0x1f },
	{ 0xc897, 0xc8 },
	{ 0xc898, 0xf3 },
	{ 0xc899, 0x87 },
	{ 0xc89a, 0x40 },
	{ 0xc89b, 0xcc },
	{ 0xc89c, 0x73 },
	{ 0xc89d, 0xb },
	{ 0xc89e, 0x40 },
	{ 0xc89f, 0x60 },
	{ 0xc8a0, 0xe7 },
	{ 0xc8a1, 0x1d },
	{ 0xc8a2, 0x3e },
	{ 0xc8a3, 0x7 },
	{ 0xc8a4, 0x3a },
	{ 0xc8a5, 0xc8 },
	{ 0xc8a6, 0xec },
	{ 0xc8a7, 0xd },
	{ 0xc8a8, 0x80 },
	{ 0xc8a9, 0x9f },
	{ 0xc8aa, 0xa },
	{ 0xc8ab, 0x0 },
	{ 0xc8ac, 0xa },
	{ 0xc8ad, 0x0 },
	{ 0xc8ae, 0x0 },
	{ 0xc8af, 0xc8 },
	{ 0xc8b0, 0xec },
	{ 0xc8b1, 0x65 },
	{ 0xc8b2, 0x80 },
	{ 0xc8b3, 0xd8 },
	{ 0xc8b4, 0xe0 },
	{ 0xc8b5, 0x0 },
	{ 0xc8b6, 0xa },
	{ 0xc8b7, 0x65 },
	{ 0xc8b8, 0x4a },
	{ 0xc8b9, 0x3a },
	{ 0xc8ba, 0x2d },
	{ 0xc8bb, 0xd1 },
	{ 0xc8bc, 0x0 },
	{ 0xc8bd, 0x2d },
	{ 0xc8be, 0x50 },
	{ 0xc8bf, 0x0 },
	{ 0xc8c0, 0x47 },
	{ 0xc8c1, 0xb7 },
	{ 0xc8c2, 0x0 },
	{ 0xc8c3, 0x47 },
	{ 0xc8c4, 0xae },
	{ 0xc8c5, 0xc0 },
	{ 0xc8c6, 0x5 },
	{ 0xc8c7, 0x43 },
	{ 0xc8c8, 0x5 },
	{ 0xc8c9, 0xa6 },
	{ 0xc8ca, 0x28 },
	{ 0xc8cb, 0x63 },
	{ 0xc8cc, 0xb1 },
	{ 0xc8cd, 0x28 },
	{ 0xc8ce, 0xca },
	{ 0xc8cf, 0x81 },
	{ 0xc8d0, 0x2c },
	{ 0xc8d1, 0xe1 },
	{ 0xc8d2, 0x20 },
	{ 0xc8d3, 0x64 },
	{ 0xc8d4, 0x63 },
	{ 0xc8d5, 0x33 },
	{ 0xc8d6, 0x5 },
	{ 0xc8d7, 0xc5 },
	{ 0xc8d8, 0x5 },
	{ 0xc8d9, 0xe4 },
	{ 0xc8da, 0x0 },
	{ 0xc8db, 0x82 },
	{ 0xc8dc, 0xd4 },
	{ 0xc8dd, 0x4b },
	{ 0xc8de, 0x2d },
	{ 0xc8df, 0x1f },
	{ 0xc8e0, 0x28 },
	{ 0xc8e1, 0xca },
	{ 0xc8e2, 0xfe },
	{ 0xc8e3, 0x5 },
	{ 0xc8e4, 0x83 },
	{ 0xc8e5, 0x28 },
	{ 0xc8e6, 0x6a },
	{ 0xc8e7, 0xd1 },
	{ 0xc8e8, 0x0 },
	{ 0xc8e9, 0x82 },
	{ 0xc8ea, 0x64 },
	{ 0xc8eb, 0x63 },
	{ 0xc8ec, 0x33 },
	{ 0xc8ed, 0xd4 },
	{ 0xc8ee, 0x83 },
	{ 0xc8ef, 0x2d },
	{ 0xc8f0, 0x1f },
	{ 0xc8f1, 0x2c },
	{ 0xc8f2, 0xe1 },
	{ 0xc8f3, 0x60 },
	{ 0xc8f4, 0x61 },
	{ 0xc8f5, 0x8c },
	{ 0xc8f6, 0x1d },
	{ 0xc8f7, 0x24 },
	{ 0xc8f8, 0xe7 },
	{ 0xc8f9, 0xac },
	{ 0xc8fa, 0x34 },
	{ 0xc8fb, 0xc7 },
	{ 0xc8fc, 0xbf },
	{ 0xc8fd, 0x40 },
	{ 0xc8fe, 0x86 },
	{ 0xc8ff, 0x38 },
	{ 0xc900, 0x28 },
	{ 0xc901, 0xea },
	{ 0xc902, 0x91 },
	{ 0xc903, 0x28 },
	{ 0xc904, 0x6a },
	{ 0xc905, 0xa9 },
	{ 0xc906, 0x0 },
	{ 0xc907, 0x82 },
	{ 0xc908, 0x64 },
	{ 0xc909, 0x63 },
	{ 0xc90a, 0x3b },
	{ 0xc90b, 0xd4 },
	{ 0xc90c, 0xc5 },
	{ 0xc90d, 0x2d },
	{ 0xc90e, 0x1f },
	{ 0xc90f, 0x28 },
	{ 0xc910, 0xea },
	{ 0xc911, 0xe1 },
	{ 0xc912, 0x5 },
	{ 0xc913, 0x63 },
	{ 0xc914, 0x28 },
	{ 0xc915, 0x6a },
	{ 0xc916, 0xc9 },
	{ 0xc917, 0xd },
	{ 0xc918, 0xe0 },
	{ 0xc919, 0x0 },
	{ 0xc91a, 0x60 },
	{ 0xc91b, 0x41 },
	{ 0xc91c, 0x87 },
	{ 0xc91d, 0x64 },
	{ 0xc91e, 0x28 },
	{ 0xc91f, 0xea },
	{ 0xc920, 0xa1 },
	{ 0xc921, 0x28 },
	{ 0xc922, 0x6a },
	{ 0xc923, 0x89 },
	{ 0xc924, 0x0 },
	{ 0xc925, 0x82 },
	{ 0xc926, 0x64 },
	{ 0xc927, 0x63 },
	{ 0xc928, 0x3b },
	{ 0xc929, 0xd4 },
	{ 0xc92a, 0xa1 },
	{ 0xc92b, 0x2d },
	{ 0xc92c, 0x1f },
	{ 0xc92d, 0x28 },
	{ 0xc92e, 0xea },
	{ 0xc92f, 0xc1 },
	{ 0xc930, 0x5 },
	{ 0xc931, 0x63 },
	{ 0xc932, 0x28 },
	{ 0xc933, 0x6a },
	{ 0xc934, 0xf1 },
	{ 0xc935, 0x64 },
	{ 0xc936, 0x63 },
	{ 0xc937, 0x3b },
	{ 0xc938, 0x0 },
	{ 0xc939, 0x82 },
	{ 0xc93a, 0xd4 },
	{ 0xc93b, 0x2e },
	{ 0xc93c, 0x2d },
	{ 0xc93d, 0x1f },
	{ 0xc93e, 0x60 },
	{ 0xc93f, 0x6b },
	{ 0xc940, 0x1d },
	{ 0xc941, 0x2d },
	{ 0xc942, 0x8f },
	{ 0xc943, 0x0 },
	{ 0xc944, 0x2c },
	{ 0xc945, 0x6e },
	{ 0xc946, 0x0 },
	{ 0xc947, 0x60 },
	{ 0xc948, 0x6c },
	{ 0xc949, 0x1d },
	{ 0xc94a, 0x2c },
	{ 0xc94b, 0x6d },
	{ 0xc94c, 0x0 },
	{ 0xc94d, 0x47 },
	{ 0xc94e, 0xbe },
	{ 0xc94f, 0xc0 },
	{ 0xc950, 0x98 },
	{ 0xc951, 0xe0 },
	{ 0xc952, 0x40 },
	{ 0xc953, 0x70 },
	{ 0xc954, 0x18 },
	{ 0xc955, 0x0 },
	{ 0xc956, 0x8c },
	{ 0xc957, 0xe0 },
	{ 0xc958, 0xe },
	{ 0xc959, 0x62 },
	{ 0xc95a, 0x18 },
	{ 0xc95b, 0x0 },
	{ 0xc95c, 0x98 },
	{ 0xc95d, 0xe0 },
	{ 0xc95e, 0xda },
	{ 0xc95f, 0x88 },
	{ 0xc960, 0x18 },
	{ 0xc961, 0x0 },
	{ 0xc962, 0x8c },
	{ 0xc963, 0xe0 },
	{ 0xc964, 0x34 },
	{ 0xc965, 0x62 },
	{ 0xc966, 0x18 },
	{ 0xc967, 0x0 },
	{ 0xc968, 0x98 },
	{ 0xc969, 0xe0 },
	{ 0xc96a, 0xb4 },
	{ 0xc96b, 0x48 },
	{ 0xc96c, 0x18 },
	{ 0xc96d, 0x0 },
	{ 0xc96e, 0x8c },
	{ 0xc96f, 0xe0 },
	{ 0xc970, 0x29 },
	{ 0xc971, 0x62 },
	{ 0xc972, 0x18 },
	{ 0xc973, 0x0 },
	{ 0xc974, 0x98 },
	{ 0xc975, 0xe0 },
	{ 0xc976, 0x9 },
	{ 0xc977, 0x28 },
	{ 0xc978, 0x18 },
	{ 0xc979, 0x0 },
	{ 0xc97a, 0x8c },
	{ 0xc97b, 0xe0 },
	{ 0xc97c, 0x9 },
	{ 0xc97d, 0x62 },
	{ 0xc97e, 0x18 },
	{ 0xc97f, 0x0 },
	{ 0xc980, 0x98 },
	{ 0xc981, 0xe0 },
	{ 0xc982, 0x84 },
	{ 0xc983, 0x68 },
	{ 0xc984, 0x18 },
	{ 0xc985, 0x0 },
	{ 0xc986, 0x8c },
	{ 0xc987, 0xe0 },
	{ 0xc988, 0x28 },
	{ 0xc989, 0x62 },
	{ 0xc98a, 0x18 },
	{ 0xc98b, 0x0 },
	{ 0xc98c, 0x98 },
	{ 0xc98d, 0xe0 },
	{ 0xc98e, 0x56 },
	{ 0xc98f, 0xf0 },
	{ 0xc990, 0x18 },
	{ 0xc991, 0x0 },
	{ 0xc992, 0x8c },
	{ 0xc993, 0xe0 },
	{ 0xc994, 0x8 },
	{ 0xc995, 0x62 },
	{ 0xc996, 0x18 },
	{ 0xc997, 0x0 },
	{ 0xc998, 0x98 },
	{ 0xc999, 0xe0 },
	{ 0xc99a, 0xc3 },
	{ 0xc99b, 0x18 },
	{ 0xc99c, 0x18 },
	{ 0xc99d, 0x0 },
	{ 0xc99e, 0x8c },
	{ 0xc99f, 0xe0 },
	{ 0xc9a0, 0x26 },
	{ 0xc9a1, 0x62 },
	{ 0xc9a2, 0x18 },
	{ 0xc9a3, 0x0 },
	{ 0xc9a4, 0x47 },
	{ 0xc9a5, 0xd2 },
	{ 0xc9a6, 0x48 },
	{ 0xc9a7, 0x47 },
	{ 0xc9a8, 0xd2 },
	{ 0xc9a9, 0x48 },
	{ 0xc9aa, 0x47 },
	{ 0xc9ab, 0xd2 },
	{ 0xc9ac, 0x48 },
	{ 0xc9ad, 0x8c },
	{ 0xc9ae, 0x80 },
	{ 0xc9af, 0x5a },
	{ 0xc9b0, 0xa2 },
	{ 0xc9b1, 0x18 },
	{ 0xc9b2, 0x0 },
	{ 0xc9b3, 0x38 },
	{ 0xc9b4, 0xe0 },
	{ 0xc9b5, 0x88 },
	{ 0xc9b6, 0x98 },
	{ 0xc9b7, 0x60 },
	{ 0xc9b8, 0x22 },
	{ 0xc9b9, 0x80 },
	{ 0xc9ba, 0x64 },
	{ 0xc9bb, 0x1 },
	{ 0xc9bc, 0xd8 },
	{ 0xc9bd, 0x84 },
	{ 0xc9be, 0x1c },
	{ 0xc9bf, 0x80 },
	{ 0xc9c0, 0x99 },
	{ 0xc9c1, 0x0 },
	{ 0xc9c2, 0x9 },
	{ 0xc9c3, 0xce },
	{ 0xc9c4, 0x18 },
	{ 0xc9c5, 0x1 },
	{ 0xc9c6, 0x47 },
	{ 0xc9c7, 0xa8 },
	{ 0xc9c8, 0x80 },
	{ 0xc9c9, 0x8c },
	{ 0xc9ca, 0xe0 },
	{ 0xc9cb, 0x1b },
	{ 0xc9cc, 0xa2 },
	{ 0xc9cd, 0x18 },
	{ 0xc9ce, 0x0 },
	{ 0xc9cf, 0xd8 },
	{ 0xc9d0, 0xe0 },
	{ 0xc9d1, 0x20 },
	{ 0xc9d2, 0xe0 },
	{ 0xc9d3, 0x0 },
	{ 0xc9d4, 0xa0 },
	{ 0xc9d5, 0x0 },
	{ 0xc9d6, 0xc0 },
	{ 0xc9d7, 0xd4 },
	{ 0xc9d8, 0x1e },
	{ 0xc9d9, 0x75 },
	{ 0xc9da, 0x1f },
	{ 0xc9db, 0x8c },
	{ 0xc9dc, 0x80 },
	{ 0xc9dd, 0x5a },
	{ 0xc9de, 0xa2 },
	{ 0xc9df, 0x18 },
	{ 0xc9e0, 0x0 },
	{ 0xc9e1, 0x98 },
	{ 0xc9e2, 0x60 },
	{ 0xc9e3, 0x0 },
	{ 0xc9e4, 0x16 },
	{ 0xc9e5, 0x4 },
	{ 0xc9e6, 0x1 },
	{ 0xc9e7, 0xd8 },
	{ 0xc9e8, 0xe0 },
	{ 0xc9e9, 0x1c },
	{ 0xc9ea, 0x80 },
	{ 0xc9eb, 0x99 },
	{ 0xc9ec, 0x0 },
	{ 0xc9ed, 0x19 },
	{ 0xc9ee, 0xce },
	{ 0xc9ef, 0x18 },
	{ 0xc9f0, 0x1 },
	{ 0xc9f1, 0x0 },
	{ 0xc9f2, 0xa0 },
	{ 0xc9f3, 0x0 },
	{ 0xc9f4, 0xc0 },
	{ 0xc9f5, 0xd4 },
	{ 0xc9f6, 0x5a },
	{ 0xc9f7, 0x75 },
	{ 0xc9f8, 0x1f },
	{ 0xc9f9, 0x8c },
	{ 0xc9fa, 0x80 },
	{ 0xc9fb, 0x5a },
	{ 0xc9fc, 0xa2 },
	{ 0xc9fd, 0x18 },
	{ 0xc9fe, 0x0 },
	{ 0xc9ff, 0x98 },
	{ 0xca00, 0x60 },
	{ 0xca01, 0x1c },
	{ 0xca02, 0xd6 },
	{ 0xca03, 0x4 },
	{ 0xca04, 0x1 },
	{ 0xca05, 0xd8 },
	{ 0xca06, 0x84 },
	{ 0xca07, 0x3c },
	{ 0xca08, 0x50 },
	{ 0xca09, 0xd8 },
	{ 0xca0a, 0xe0 },
	{ 0xca0b, 0x1c },
	{ 0xca0c, 0x80 },
	{ 0xca0d, 0x99 },
	{ 0xca0e, 0x0 },
	{ 0xca0f, 0x5 },
	{ 0xca10, 0xce },
	{ 0xca11, 0x18 },
	{ 0xca12, 0x1 },
	{ 0xca13, 0x0 },
	{ 0xca14, 0xa0 },
	{ 0xca15, 0x0 },
	{ 0xca16, 0xc0 },
	{ 0xca17, 0xd4 },
	{ 0xca18, 0x1c },
	{ 0xca19, 0x75 },
	{ 0xca1a, 0x1f },
	{ 0xca1b, 0x8c },
	{ 0xca1c, 0x60 },
	{ 0xca1d, 0x6a },
	{ 0xca1e, 0xa2 },
	{ 0xca1f, 0x18 },
	{ 0xca20, 0x0 },
	{ 0xca21, 0x98 },
	{ 0xca22, 0x80 },
	{ 0xca23, 0x0 },
	{ 0xca24, 0x0 },
	{ 0xca25, 0x64 },
	{ 0xca26, 0x1 },
	{ 0xca27, 0xd8 },
	{ 0xca28, 0x63 },
	{ 0xca29, 0x1d },
	{ 0xca2a, 0x40 },
	{ 0xca2b, 0xd8 },
	{ 0xca2c, 0xe0 },
	{ 0xca2d, 0x22 },
	{ 0xca2e, 0x80 },
	{ 0xca2f, 0x99 },
	{ 0xca30, 0x0 },
	{ 0xca31, 0xd },
	{ 0xca32, 0xce },
	{ 0xca33, 0x18 },
	{ 0xca34, 0x1 },
	{ 0xca35, 0x0 },
	{ 0xca36, 0xa0 },
	{ 0xca37, 0x0 },
	{ 0xca38, 0xc0 },
	{ 0xca39, 0xd4 },
	{ 0xca3a, 0x68 },
	{ 0xca3b, 0x75 },
	{ 0xca3c, 0x1f },
	{ 0xca3d, 0x8c },
	{ 0xca3e, 0x60 },
	{ 0xca3f, 0x6a },
	{ 0xca40, 0xa2 },
	{ 0xca41, 0x18 },
	{ 0xca42, 0x0 },
	{ 0xca43, 0x98 },
	{ 0xca44, 0x80 },
	{ 0xca45, 0x0 },
	{ 0xca46, 0x6 },
	{ 0xca47, 0x4 },
	{ 0xca48, 0x1 },
	{ 0xca49, 0x38 },
	{ 0xca4a, 0xe0 },
	{ 0xca4b, 0x3 },
	{ 0xca4c, 0x99 },
	{ 0xca4d, 0x0 },
	{ 0xca4e, 0x1d },
	{ 0xca4f, 0xce },
	{ 0xca50, 0x18 },
	{ 0xca51, 0x1 },
	{ 0xca52, 0x0 },
	{ 0xca53, 0xa0 },
	{ 0xca54, 0x0 },
	{ 0xca55, 0xc0 },
	{ 0xca56, 0xd4 },
	{ 0xca57, 0x9f },
	{ 0xca58, 0xb5 },
	{ 0xca59, 0x1f },
	{ 0xca5a, 0x8c },
	{ 0xca5b, 0x60 },
	{ 0xca5c, 0x6a },
	{ 0xca5d, 0xa2 },
	{ 0xca5e, 0x18 },
	{ 0xca5f, 0x0 },
	{ 0xca60, 0x98 },
	{ 0xca61, 0x80 },
	{ 0xca62, 0x3 },
	{ 0xca63, 0x6 },
	{ 0xca64, 0x4 },
	{ 0xca65, 0x1 },
	{ 0xca66, 0xd8 },
	{ 0xca67, 0x63 },
	{ 0xca68, 0x3 },
	{ 0xca69, 0x0 },
	{ 0xca6a, 0x99 },
	{ 0xca6b, 0x0 },
	{ 0xca6c, 0x3 },
	{ 0xca6d, 0xce },
	{ 0xca6e, 0x18 },
	{ 0xca6f, 0x1 },
	{ 0xca70, 0x0 },
	{ 0xca71, 0xa0 },
	{ 0xca72, 0x0 },
	{ 0xca73, 0xc0 },
	{ 0xca74, 0x0 },
	{ 0xca75, 0xe2 },
	{ 0xca76, 0xd4 },
	{ 0xca77, 0x9b },
	{ 0xca78, 0xb5 },
	{ 0xca79, 0x1f },
	{ 0xca7a, 0x8c },
	{ 0xca7b, 0x60 },
	{ 0xca7c, 0x6a },
	{ 0xca7d, 0xa2 },
	{ 0xca7e, 0x18 },
	{ 0xca7f, 0x0 },
	{ 0xca80, 0x98 },
	{ 0xca81, 0x80 },
	{ 0xca82, 0x23 },
	{ 0xca83, 0x6 },
	{ 0xca84, 0x4 },
	{ 0xca85, 0x1 },
	{ 0xca86, 0x38 },
	{ 0xca87, 0xe0 },
	{ 0xca88, 0x3 },
	{ 0xca89, 0x99 },
	{ 0xca8a, 0x0 },
	{ 0xca8b, 0x13 },
	{ 0xca8c, 0xce },
	{ 0xca8d, 0x18 },
	{ 0xca8e, 0x1 },
	{ 0xca8f, 0x0 },
	{ 0xca90, 0xa0 },
	{ 0xca91, 0x0 },
	{ 0xca92, 0xc0 },
	{ 0xca93, 0xd4 },
	{ 0xca94, 0x3d },
	{ 0xca95, 0xb5 },
	{ 0xca96, 0x1f },
	{ 0xca97, 0x8c },
	{ 0xca98, 0x60 },
	{ 0xca99, 0x6a },
	{ 0xca9a, 0xa2 },
	{ 0xca9b, 0x18 },
	{ 0xca9c, 0x0 },
	{ 0xca9d, 0x98 },
	{ 0xca9e, 0x80 },
	{ 0xca9f, 0x21 },
	{ 0xcaa0, 0x86 },
	{ 0xcaa1, 0x4 },
	{ 0xcaa2, 0x1 },
	{ 0xcaa3, 0xd8 },
	{ 0xcaa4, 0x63 },
	{ 0xcaa5, 0x23 },
	{ 0xcaa6, 0x0 },
	{ 0xcaa7, 0x99 },
	{ 0xcaa8, 0x0 },
	{ 0xcaa9, 0xb },
	{ 0xcaaa, 0xce },
	{ 0xcaab, 0x18 },
	{ 0xcaac, 0x1 },
	{ 0xcaad, 0x0 },
	{ 0xcaae, 0xa0 },
	{ 0xcaaf, 0x0 },
	{ 0xcab0, 0xc0 },
	{ 0xcab1, 0x0 },
	{ 0xcab2, 0xe2 },
	{ 0xcab3, 0xd4 },
	{ 0xcab4, 0x39 },
	{ 0xcab5, 0xb5 },
	{ 0xcab6, 0x1f },
	{ 0xcab7, 0x8c },
	{ 0xcab8, 0x60 },
	{ 0xcab9, 0x6a },
	{ 0xcaba, 0xa2 },
	{ 0xcabb, 0x18 },
	{ 0xcabc, 0x0 },
	{ 0xcabd, 0x98 },
	{ 0xcabe, 0x80 },
	{ 0xcabf, 0x12 },
	{ 0xcac0, 0x46 },
	{ 0xcac1, 0x4 },
	{ 0xcac2, 0x1 },
	{ 0xcac3, 0xd8 },
	{ 0xcac4, 0x63 },
	{ 0xcac5, 0x13 },
	{ 0xcac6, 0x0 },
	{ 0xcac7, 0x99 },
	{ 0xcac8, 0x0 },
	{ 0xcac9, 0x1b },
	{ 0xcaca, 0xce },
	{ 0xcacb, 0x18 },
	{ 0xcacc, 0x1 },
	{ 0xcacd, 0x0 },
	{ 0xcace, 0xa0 },
	{ 0xcacf, 0x0 },
	{ 0xcad0, 0xc0 },
	{ 0xcad1, 0x0 },
	{ 0xcad2, 0xe2 },
	{ 0xcad3, 0xd4 },
	{ 0xcad4, 0x3e },
	{ 0xcad5, 0xb5 },
	{ 0xcad6, 0x1f },
	{ 0xcad7, 0x8c },
	{ 0xcad8, 0x60 },
	{ 0xcad9, 0x6a },
	{ 0xcada, 0xa2 },
	{ 0xcadb, 0x18 },
	{ 0xcadc, 0x0 },
	{ 0xcadd, 0x98 },
	{ 0xcade, 0x80 },
	{ 0xcadf, 0x32 },
	{ 0xcae0, 0x46 },
	{ 0xcae1, 0x4 },
	{ 0xcae2, 0x1 },
	{ 0xcae3, 0xd8 },
	{ 0xcae4, 0x63 },
	{ 0xcae5, 0x33 },
	{ 0xcae6, 0x0 },
	{ 0xcae7, 0xd8 },
	{ 0xcae8, 0xe0 },
	{ 0xcae9, 0x37 },
	{ 0xcaea, 0x80 },
	{ 0xcaeb, 0x99 },
	{ 0xcaec, 0x0 },
	{ 0xcaed, 0x7 },
	{ 0xcaee, 0xce },
	{ 0xcaef, 0x18 },
	{ 0xcaf0, 0x1 },
	{ 0xcaf1, 0x0 },
	{ 0xcaf2, 0xa0 },
	{ 0xcaf3, 0x0 },
	{ 0xcaf4, 0xc0 },
	{ 0xcaf5, 0xd4 },
	{ 0xcaf6, 0x5a },
	{ 0xcaf7, 0xb5 },
	{ 0xcaf8, 0x1f },
	{ 0xcaf9, 0x8c },
	{ 0xcafa, 0x80 },
	{ 0xcafb, 0x5a },
	{ 0xcafc, 0xa2 },
	{ 0xcafd, 0x18 },
	{ 0xcafe, 0x0 },
	{ 0xcaff, 0x99 },
	{ 0xcb00, 0x0 },
	{ 0xcb01, 0xf },
	{ 0xcb02, 0xce },
	{ 0xcb03, 0x18 },
	{ 0xcb04, 0x1 },
	{ 0xcb05, 0x98 },
	{ 0xcb06, 0x60 },
	{ 0xcb07, 0x1c },
	{ 0xcb08, 0x96 },
	{ 0xcb09, 0x4 },
	{ 0xcb0a, 0x1 },
	{ 0xcb0b, 0xd8 },
	{ 0xcb0c, 0x84 },
	{ 0xcb0d, 0x3c },
	{ 0xcb0e, 0x10 },
	{ 0xcb0f, 0xd8 },
	{ 0xcb10, 0xe0 },
	{ 0xcb11, 0x0 },
	{ 0xcb12, 0x40 },
	{ 0xcb13, 0x0 },
	{ 0xcb14, 0xc0 },
	{ 0xcb15, 0x0 },
	{ 0xcb16, 0xa0 },
	{ 0xcb17, 0xd4 },
	{ 0xcb18, 0x1c },
	{ 0xcb19, 0xb5 },
	{ 0xcb1a, 0x1f },
	{ 0xcb1b, 0x98 },
	{ 0xcb1c, 0xe0 },
	{ 0xcb1d, 0x9 },
	{ 0xcb1e, 0xce },
	{ 0xcb1f, 0x18 },
	{ 0xcb20, 0x1 },
	{ 0xcb21, 0x98 },
	{ 0xcb22, 0x60 },
	{ 0xcb23, 0x3c },
	{ 0xcb24, 0xf6 },
	{ 0xcb25, 0x4 },
	{ 0xcb26, 0x1 },
	{ 0xcb27, 0x98 },
	{ 0xcb28, 0x80 },
	{ 0xcb29, 0xe0 },
	{ 0xcb2a, 0x80 },
	{ 0xcb2b, 0xff },
	{ 0xcb2c, 0xff },
	{ 0xcb2d, 0x0 },
	{ 0xcb2e, 0xaf },
	{ 0xcb2f, 0x8c },
	{ 0xcb30, 0xe0 },
	{ 0xcb31, 0x20 },
	{ 0xcb32, 0xf6 },
	{ 0xcb33, 0x4 },
	{ 0xcb34, 0x1 },
	{ 0xcb35, 0x98 },
	{ 0xcb36, 0xe0 },
	{ 0xcb37, 0xd },
	{ 0xcb38, 0xce },
	{ 0xcb39, 0x18 },
	{ 0xcb3a, 0x1 },
	{ 0xcb3b, 0x8c },
	{ 0xcb3c, 0xe0 },
	{ 0xcb3d, 0x10 },
	{ 0xcb3e, 0xf6 },
	{ 0xcb3f, 0x4 },
	{ 0xcb40, 0x1 },
	{ 0xcb41, 0x98 },
	{ 0xcb42, 0xe0 },
	{ 0xcb43, 0xf },
	{ 0xcb44, 0xce },
	{ 0xcb45, 0x18 },
	{ 0xcb46, 0x1 },
	{ 0xcb47, 0x8c },
	{ 0xcb48, 0xe0 },
	{ 0xcb49, 0x30 },
	{ 0xcb4a, 0xf6 },
	{ 0xcb4b, 0x4 },
	{ 0xcb4c, 0x1 },
	{ 0xcb4d, 0x98 },
	{ 0xcb4e, 0xe0 },
	{ 0xcb4f, 0x0 },
	{ 0xcb50, 0x0 },
	{ 0xcb51, 0x40 },
	{ 0xcb52, 0x0 },
	{ 0xcb53, 0x8c },
	{ 0xcb54, 0xe0 },
	{ 0xcb55, 0x34 },
	{ 0xcb56, 0xf6 },
	{ 0xcb57, 0x4 },
	{ 0xcb58, 0x1 },
	{ 0xcb59, 0x98 },
	{ 0xcb5a, 0xe0 },
	{ 0xcb5b, 0x0 },
	{ 0xcb5c, 0x0 },
	{ 0xcb5d, 0x0 },
	{ 0xcb5e, 0x4 },
	{ 0xcb5f, 0x8c },
	{ 0xcb60, 0xe0 },
	{ 0xcb61, 0xc },
	{ 0xcb62, 0xf6 },
	{ 0xcb63, 0x4 },
	{ 0xcb64, 0x1 },
	{ 0xcb65, 0x98 },
	{ 0xcb66, 0xe0 },
	{ 0xcb67, 0x0 },
	{ 0xcb68, 0x0 },
	{ 0xcb69, 0x2 },
	{ 0xcb6a, 0x0 },
	{ 0xcb6b, 0x8c },
	{ 0xcb6c, 0xe0 },
	{ 0xcb6d, 0x2c },
	{ 0xcb6e, 0xf6 },
	{ 0xcb6f, 0x4 },
	{ 0xcb70, 0x1 },
	{ 0xcb71, 0x98 },
	{ 0xcb72, 0xe0 },
	{ 0xcb73, 0xc0 },
	{ 0xcb74, 0xe0 },
	{ 0xcb75, 0x80 },
	{ 0xcb76, 0x0 },
	{ 0xcb77, 0x8c },
	{ 0xcb78, 0xe0 },
	{ 0xcb79, 0x24 },
	{ 0xcb7a, 0xf6 },
	{ 0xcb7b, 0x4 },
	{ 0xcb7c, 0x1 },
	{ 0xcb7d, 0xd4 },
	{ 0xcb7e, 0xd5 },
	{ 0xcb7f, 0xf5 },
	{ 0xcb80, 0x1f },
	{ 0xcb81, 0x0 },
	{ 0xcb82, 0xea },
	{ 0xcb83, 0x98 },
	{ 0xcb84, 0x60 },
	{ 0xcb85, 0x22 },
	{ 0xcb86, 0xf6 },
	{ 0xcb87, 0x4 },
	{ 0xcb88, 0x1 },
	{ 0xcb89, 0xd8 },
	{ 0xcb8a, 0x80 },
	{ 0xcb8b, 0x0 },
	{ 0xcb8c, 0x4 },
	{ 0xcb8d, 0xd8 },
	{ 0xcb8e, 0xa0 },
	{ 0xcb8f, 0x0 },
	{ 0xcb90, 0x4 },
	{ 0xcb91, 0x8c },
	{ 0xcb92, 0xe0 },
	{ 0xcb93, 0x2 },
	{ 0xcb94, 0xf6 },
	{ 0xcb95, 0x4 },
	{ 0xcb96, 0x1 },
	{ 0xcb97, 0xd4 },
	{ 0xcb98, 0x89 },
	{ 0xcb99, 0xf5 },
	{ 0xcb9a, 0x1f },
	{ 0xcb9b, 0x0 },
	{ 0xcb9c, 0xe8 },
	{ 0xcb9d, 0x8c },
	{ 0xcb9e, 0xe0 },
	{ 0xcb9f, 0x12 },
	{ 0xcba0, 0xf6 },
	{ 0xcba1, 0x4 },
	{ 0xcba2, 0x1 },
	{ 0xcba3, 0x47 },
	{ 0xcba4, 0xb8 },
	{ 0xcba5, 0x80 },
	{ 0xcba6, 0x98 },
	{ 0xcba7, 0xe0 },
	{ 0xcba8, 0xb5 },
	{ 0xcba9, 0x98 },
	{ 0xcbaa, 0x18 },
	{ 0xcbab, 0x0 },
	{ 0xcbac, 0x8c },
	{ 0xcbad, 0xe0 },
	{ 0xcbae, 0x15 },
	{ 0xcbaf, 0xa2 },
	{ 0xcbb0, 0x18 },
	{ 0xcbb1, 0x0 },
	{ 0xcbb2, 0x47 },
	{ 0xcbb3, 0xd2 },
	{ 0xcbb4, 0x48 },
	{ 0xcbb5, 0x0 },
	{ 0xcbb6, 0x0 },
	{ 0xcbb7, 0x0 },
	{ 0xcbb8, 0x74 },
	{ 0xcbb9, 0x69 },
	{ 0xcbba, 0x6d },
	{ 0xcbbb, 0x65 },
	{ 0xcbbc, 0x6f },
	{ 0xcbbd, 0x75 },
	{ 0xcbbe, 0x74 },
	{ 0xcbbf, 0x3d },
	{ 0xcbc0, 0x25 },
	{ 0xcbc1, 0x64 },
	{ 0xcbc2, 0xa },
	{ 0xcbc3, 0x0 },
	{ 0xcbc4, 0x0 },
	{ 0xcbc5, 0x48 },
	{ 0xcbc6, 0x69 },
	{ 0xcbc7, 0x73 },
	{ 0xcbc8, 0x74 },
	{ 0xcbc9, 0x4d },
	{ 0xcbca, 0x65 },
	{ 0xcbcb, 0x61 },
	{ 0xcbcc, 0x6e },
	{ 0xcbcd, 0x3a },
	{ 0xcbce, 0x25 },
	{ 0xcbcf, 0x78 },
	{ 0xcbd0, 0x2c },
	{ 0xcbd1, 0x20 },
	{ 0xcbd2, 0x53 },
	{ 0xcbd3, 0x75 },
	{ 0xcbd4, 0x6d },
	{ 0xcbd5, 0x50 },
	{ 0xcbd6, 0x6f },
	{ 0xcbd7, 0x69 },
	{ 0xcbd8, 0x6e },
	{ 0xcbd9, 0x74 },
	{ 0xcbda, 0x3a },
	{ 0xcbdb, 0x25 },
	{ 0xcbdc, 0x78 },
	{ 0xcbdd, 0x2c },
	{ 0xcbde, 0x20 },
	{ 0xcbdf, 0x53 },
	{ 0xcbe0, 0x75 },
	{ 0xcbe1, 0x6d },
	{ 0xcbe2, 0x59 },
	{ 0xcbe3, 0x3a },
	{ 0xcbe4, 0x25 },
	{ 0xcbe5, 0x78 },
	{ 0xcbe6, 0xa },
	{ 0xcbe7, 0x0 },
	{ 0xcbe8, 0x4c },
	{ 0xcbe9, 0x52 },
	{ 0xcbea, 0x61 },
	{ 0xcbeb, 0x74 },
	{ 0xcbec, 0x69 },
	{ 0xcbed, 0x6f },
	{ 0xcbee, 0x3a },
	{ 0xcbef, 0x25 },
	{ 0xcbf0, 0x78 },
	{ 0xcbf1, 0x2c },
	{ 0xcbf2, 0x20 },
	{ 0xcbf3, 0x53 },
	{ 0xcbf4, 0x52 },
	{ 0xcbf5, 0x61 },
	{ 0xcbf6, 0x74 },
	{ 0xcbf7, 0x69 },
	{ 0xcbf8, 0x6f },
	{ 0xcbf9, 0x3a },
	{ 0xcbfa, 0x25 },
	{ 0xcbfb, 0x78 },
	{ 0xcbfc, 0x2c },
	{ 0xcbfd, 0x20 },
	{ 0xcbfe, 0x56 },
	{ 0xcbff, 0x53 },
	{ 0xcc00, 0x52 },
	{ 0xcc01, 0x61 },
	{ 0xcc02, 0x74 },
	{ 0xcc03, 0x69 },
	{ 0xcc04, 0x6f },
	{ 0xcc05, 0x3a },
	{ 0xcc06, 0x25 },
	{ 0xcc07, 0x78 },
	{ 0xcc08, 0xa },
	{ 0xcc09, 0x0 },
	{ 0xcc0a, 0x53 },
	{ 0xcc0b, 0x74 },
	{ 0xcc0c, 0x61 },
	{ 0xcc0d, 0x4d },
	{ 0xcc0e, 0x65 },
	{ 0xcc0f, 0x3a },
	{ 0xcc10, 0x25 },
	{ 0xcc11, 0x78 },
	{ 0xcc12, 0x2c },
	{ 0xcc13, 0x20 },
	{ 0xcc14, 0x69 },
	{ 0xcc15, 0x73 },
	{ 0xcc16, 0x70 },
	{ 0xcc17, 0x42 },
	{ 0xcc18, 0x6c },
	{ 0xcc19, 0x63 },
	{ 0xcc1a, 0x3a },
	{ 0xcc1b, 0x25 },
	{ 0xcc1c, 0x78 },
	{ 0xcc1d, 0x2c },
	{ 0xcc1e, 0x20 },
	{ 0xcc1f, 0x6c },
	{ 0xcc20, 0x6f },
	{ 0xcc21, 0x77 },
	{ 0xcc22, 0x6c },
	{ 0xcc23, 0x3a },
	{ 0xcc24, 0x25 },
	{ 0xcc25, 0x78 },
	{ 0xcc26, 0x2c },
	{ 0xcc27, 0x20 },
	{ 0xcc28, 0x67 },
	{ 0xcc29, 0x61 },
	{ 0xcc2a, 0x69 },
	{ 0xcc2b, 0x6e },
	{ 0xcc2c, 0x3a },
	{ 0xcc2d, 0x25 },
	{ 0xcc2e, 0x78 },
	{ 0xcc2f, 0x2c },
	{ 0xcc30, 0x20 },
	{ 0xcc31, 0x52 },
	{ 0xcc32, 0x65 },
	{ 0xcc33, 0x61 },
	{ 0xcc34, 0x6c },
	{ 0xcc35, 0x4d },
	{ 0xcc36, 0x65 },
	{ 0xcc37, 0x61 },
	{ 0xcc38, 0x6e },
	{ 0xcc39, 0x3a },
	{ 0xcc3a, 0x25 },
	{ 0xcc3b, 0x78 },
	{ 0xcc3c, 0xa },
	{ 0xcc3d, 0x0 },
	{ 0xcc3e, 0x4c },
	{ 0xcc3f, 0x52 },
	{ 0xcc40, 0x61 },
	{ 0xcc41, 0x74 },
	{ 0xcc42, 0x69 },
	{ 0xcc43, 0x6f },
	{ 0xcc44, 0x3a },
	{ 0xcc45, 0x25 },
	{ 0xcc46, 0x78 },
	{ 0xcc47, 0x2c },
	{ 0xcc48, 0x20 },
	{ 0xcc49, 0x53 },
	{ 0xcc4a, 0x52 },
	{ 0xcc4b, 0x61 },
	{ 0xcc4c, 0x74 },
	{ 0xcc4d, 0x69 },
	{ 0xcc4e, 0x6f },
	{ 0xcc4f, 0x3a },
	{ 0xcc50, 0x25 },
	{ 0xcc51, 0x78 },
	{ 0xcc52, 0x2c },
	{ 0xcc53, 0x20 },
	{ 0xcc54, 0x56 },
	{ 0xcc55, 0x53 },
	{ 0xcc56, 0x52 },
	{ 0xcc57, 0x61 },
	{ 0xcc58, 0x74 },
	{ 0xcc59, 0x69 },
	{ 0xcc5a, 0x6f },
	{ 0xcc5b, 0x3a },
	{ 0xcc5c, 0x25 },
	{ 0xcc5d, 0x78 },
	{ 0xcc5e, 0xa },
	{ 0xcc5f, 0x0 },
	{ 0xcc60, 0x43 },
	{ 0xcc61, 0x75 },
	{ 0xcc62, 0x72 },
	{ 0xcc63, 0x72 },
	{ 0xcc64, 0x65 },
	{ 0xcc65, 0x6e },
	{ 0xcc66, 0x74 },
	{ 0xcc67, 0x56 },
	{ 0xcc68, 0x54 },
	{ 0xcc69, 0x53 },
	{ 0xcc6a, 0x3a },
	{ 0xcc6b, 0x25 },
	{ 0xcc6c, 0x78 },
	{ 0xcc6d, 0x2c },
	{ 0xcc6e, 0x20 },
	{ 0xcc6f, 0x41 },
	{ 0xcc70, 0x64 },
	{ 0xcc71, 0x64 },
	{ 0xcc72, 0x3a },
	{ 0xcc73, 0x25 },
	{ 0xcc74, 0x78 },
	{ 0xcc75, 0x2c },
	{ 0xcc76, 0x20 },
	{ 0xcc77, 0x56 },
	{ 0xcc78, 0x54 },
	{ 0xcc79, 0x53 },
	{ 0xcc7a, 0x42 },
	{ 0xcc7b, 0x61 },
	{ 0xcc7c, 0x73 },
	{ 0xcc7d, 0x65 },
	{ 0xcc7e, 0x3a },
	{ 0xcc7f, 0x25 },
	{ 0xcc80, 0x78 },
	{ 0xcc81, 0xa },
	{ 0xcc82, 0x0 },
	{ 0xcc83, 0x56 },
	{ 0xcc84, 0x54 },
	{ 0xcc85, 0x53 },
	{ 0xcc86, 0x3a },
	{ 0xcc87, 0xa },
	{ 0xcc88, 0x0 },
	{ 0xcc89, 0x25 },
	{ 0xcc8a, 0x78 },
	{ 0xcc8b, 0x2c },
	{ 0xcc8c, 0x20 },
	{ 0xcc8d, 0x45 },
	{ 0xcc8e, 0x3a },
	{ 0xcc8f, 0x25 },
	{ 0xcc90, 0x78 },
	{ 0xcc91, 0x2c },
	{ 0xcc92, 0x20 },
	{ 0xcc93, 0x4d },
	{ 0xcc94, 0x69 },
	{ 0xcc95, 0x6e },
	{ 0xcc96, 0x3a },
	{ 0xcc97, 0x25 },
	{ 0xcc98, 0x78 },
	{ 0xcc99, 0x2c },
	{ 0xcc9a, 0x20 },
	{ 0xcc9b, 0x4d },
	{ 0xcc9c, 0x61 },
	{ 0xcc9d, 0x78 },
	{ 0xcc9e, 0x3a },
	{ 0xcc9f, 0x25 },
	{ 0xcca0, 0x78 },
	{ 0xcca1, 0x2c },
	{ 0xcca2, 0x20 },
	{ 0xcca3, 0x46 },
	{ 0xcca4, 0x3a },
	{ 0xcca5, 0x25 },
	{ 0xcca6, 0x78 },
	{ 0xcca7, 0xa },
	{ 0xcca8, 0x0 },
	{ 0xcca9, 0x6b },
	{ 0xccaa, 0x65 },
	{ 0xccab, 0x65 },
	{ 0xccac, 0x70 },
	{ 0xccad, 0x45 },
	{ 0xccae, 0x78 },
	{ 0xccaf, 0x70 },
	{ 0xccb0, 0x49 },
	{ 0xccb1, 0x6e },
	{ 0xccb2, 0x64 },
	{ 0xccb3, 0x65 },
	{ 0xccb4, 0x78 },
	{ 0xccb5, 0x2c },
	{ 0xccb6, 0x20 },
	{ 0xccb7, 0x65 },
	{ 0xccb8, 0x78 },
	{ 0xccb9, 0x70 },
	{ 0xccba, 0x49 },
	{ 0xccbb, 0x6e },
	{ 0xccbc, 0x3a },
	{ 0xccbd, 0x25 },
	{ 0xccbe, 0x78 },
	{ 0xccbf, 0xa },
	{ 0xccc0, 0x0 },
	{ 0xccc1, 0x53 },
	{ 0xccc2, 0x5f },
	{ 0xccc3, 0x52 },
	{ 0xccc4, 0x61 },
	{ 0xccc5, 0x74 },
	{ 0xccc6, 0x69 },
	{ 0xccc7, 0x6f },
	{ 0xccc8, 0x3a },
	{ 0xccc9, 0x25 },
	{ 0xccca, 0x78 },
	{ 0xcccb, 0x2c },
	{ 0xcccc, 0x20 },
	{ 0xcccd, 0x65 },
	{ 0xccce, 0x78 },
	{ 0xcccf, 0x70 },
	{ 0xccd0, 0x49 },
	{ 0xccd1, 0x6e },
	{ 0xccd2, 0x3a },
	{ 0xccd3, 0x25 },
	{ 0xccd4, 0x78 },
	{ 0xccd5, 0x2c },
	{ 0xccd6, 0x20 },
	{ 0xccd7, 0x45 },
	{ 0xccd8, 0x78 },
	{ 0xccd9, 0x3a },
	{ 0xccda, 0x25 },
	{ 0xccdb, 0x78 },
	{ 0xccdc, 0x2c },
	{ 0xccdd, 0x20 },
	{ 0xccde, 0x47 },
	{ 0xccdf, 0x61 },
	{ 0xcce0, 0x3a },
	{ 0xcce1, 0x25 },
	{ 0xcce2, 0x78 },
	{ 0xcce3, 0xa },
	{ 0xcce4, 0x0 },
	{ 0xcce5, 0x4c },
	{ 0xcce6, 0x5f },
	{ 0xcce7, 0x52 },
	{ 0xcce8, 0x61 },
	{ 0xcce9, 0x74 },
	{ 0xccea, 0x69 },
	{ 0xcceb, 0x6f },
	{ 0xccec, 0x3a },
	{ 0xcced, 0x25 },
	{ 0xccee, 0x78 },
	{ 0xccef, 0x2c },
	{ 0xccf0, 0x20 },
	{ 0xccf1, 0x65 },
	{ 0xccf2, 0x78 },
	{ 0xccf3, 0x70 },
	{ 0xccf4, 0x49 },
	{ 0xccf5, 0x6e },
	{ 0xccf6, 0x3a },
	{ 0xccf7, 0x25 },
	{ 0xccf8, 0x78 },
	{ 0xccf9, 0x2c },
	{ 0xccfa, 0x20 },
	{ 0xccfb, 0x45 },
	{ 0xccfc, 0x78 },
	{ 0xccfd, 0x3a },
	{ 0xccfe, 0x25 },
	{ 0xccff, 0x78 },
	{ 0xcd00, 0x2c },
	{ 0xcd01, 0x20 },
	{ 0xcd02, 0x47 },
	{ 0xcd03, 0x61 },
	{ 0xcd04, 0x3a },
	{ 0xcd05, 0x25 },
	{ 0xcd06, 0x78 },
	{ 0xcd07, 0xa },
	{ 0xcd08, 0x0 },
	{ 0xcd09, 0x25 },
	{ 0xcd0a, 0x78 },
	{ 0xcd0b, 0x2c },
	{ 0xcd0c, 0x20 },
	{ 0xcd0d, 0x41 },
	{ 0xcd0e, 0x70 },
	{ 0xcd0f, 0x70 },
	{ 0xcd10, 0x6c },
	{ 0xcd11, 0x79 },
	{ 0xcd12, 0x44 },
	{ 0xcd13, 0x47 },
	{ 0xcd14, 0x3a },
	{ 0xcd15, 0x25 },
	{ 0xcd16, 0x78 },
	{ 0xcd17, 0x2c },
	{ 0xcd18, 0x20 },
	{ 0xcd19, 0x54 },
	{ 0xcd1a, 0x47 },
	{ 0xcd1b, 0x3a },
	{ 0xcd1c, 0x25 },
	{ 0xcd1d, 0x78 },
	{ 0xcd1e, 0x2c },
	{ 0xcd1f, 0x20 },
	{ 0xcd20, 0x41 },
	{ 0xcd21, 0x47 },
	{ 0xcd22, 0x3a },
	{ 0xcd23, 0x25 },
	{ 0xcd24, 0x78 },
	{ 0xcd25, 0x2c },
	{ 0xcd26, 0x20 },
	{ 0xcd27, 0x43 },
	{ 0xcd28, 0x47 },
	{ 0xcd29, 0x3a },
	{ 0xcd2a, 0x25 },
	{ 0xcd2b, 0x78 },
	{ 0xcd2c, 0x2c },
	{ 0xcd2d, 0x20 },
	{ 0xcd2e, 0x44 },
	{ 0xcd2f, 0x47 },
	{ 0xcd30, 0x3a },
	{ 0xcd31, 0x25 },
	{ 0xcd32, 0x78 },
	{ 0xcd33, 0xa },
	{ 0xcd34, 0x0 },
	{ 0xcd35, 0x25 },
	{ 0xcd36, 0x78 },
	{ 0xcd37, 0x2c },
	{ 0xcd38, 0x20 },
	{ 0xcd39, 0x44 },
	{ 0xcd3a, 0x47 },
	{ 0xcd3b, 0x31 },
	{ 0xcd3c, 0x3a },
	{ 0xcd3d, 0x25 },
	{ 0xcd3e, 0x78 },
	{ 0xcd3f, 0x2c },
	{ 0xcd40, 0x20 },
	{ 0xcd41, 0x44 },
	{ 0xcd42, 0x47 },
	{ 0xcd43, 0x4d },
	{ 0xcd44, 0x69 },
	{ 0xcd45, 0x6e },
	{ 0xcd46, 0x3a },
	{ 0xcd47, 0x25 },
	{ 0xcd48, 0x78 },
	{ 0xcd49, 0x2c },
	{ 0xcd4a, 0x20 },
	{ 0xcd4b, 0x44 },
	{ 0xcd4c, 0x47 },
	{ 0xcd4d, 0x4d },
	{ 0xcd4e, 0x61 },
	{ 0xcd4f, 0x78 },
	{ 0xcd50, 0x3a },
	{ 0xcd51, 0x25 },
	{ 0xcd52, 0x78 },
	{ 0xcd53, 0x2c },
	{ 0xcd54, 0x20 },
	{ 0xcd55, 0x44 },
	{ 0xcd56, 0x47 },
	{ 0xcd57, 0x32 },
	{ 0xcd58, 0x3a },
	{ 0xcd59, 0x25 },
	{ 0xcd5a, 0x78 },
	{ 0xcd5b, 0xa },
	{ 0xcd5c, 0x0 },
	{ 0xcd5d, 0x25 },
	{ 0xcd5e, 0x78 },
	{ 0xcd5f, 0x2c },
	{ 0xcd60, 0x20 },
	{ 0xcd61, 0x20 },
	{ 0xcd62, 0x41 },
	{ 0xcd63, 0x70 },
	{ 0xcd64, 0x70 },
	{ 0xcd65, 0x6c },
	{ 0xcd66, 0x79 },
	{ 0xcd67, 0x41 },
	{ 0xcd68, 0x6e },
	{ 0xcd69, 0x61 },
	{ 0xcd6a, 0x41 },
	{ 0xcd6b, 0x67 },
	{ 0xcd6c, 0x61 },
	{ 0xcd6d, 0x69 },
	{ 0xcd6e, 0x6e },
	{ 0xcd6f, 0x3a },
	{ 0xcd70, 0x25 },
	{ 0xcd71, 0x78 },
	{ 0xcd72, 0xa },
	{ 0xcd73, 0x0 },
	{ 0xcd74, 0x25 },
	{ 0xcd75, 0x78 },
	{ 0xcd76, 0x2c },
	{ 0xcd77, 0x20 },
	{ 0xcd78, 0x54 },
	{ 0xcd79, 0x6f },
	{ 0xcd7a, 0x74 },
	{ 0xcd7b, 0x61 },
	{ 0xcd7c, 0x6c },
	{ 0xcd7d, 0x47 },
	{ 0xcd7e, 0x61 },
	{ 0xcd7f, 0x69 },
	{ 0xcd80, 0x6e },
	{ 0xcd81, 0x3a },
	{ 0xcd82, 0x25 },
	{ 0xcd83, 0x78 },
	{ 0xcd84, 0x2c },
	{ 0xcd85, 0x20 },
	{ 0xcd86, 0x41 },
	{ 0xcd87, 0x6e },
	{ 0xcd88, 0x61 },
	{ 0xcd89, 0x47 },
	{ 0xcd8a, 0x61 },
	{ 0xcd8b, 0x69 },
	{ 0xcd8c, 0x6e },
	{ 0xcd8d, 0x3a },
	{ 0xcd8e, 0x25 },
	{ 0xcd8f, 0x78 },
	{ 0xcd90, 0xa },
	{ 0xcd91, 0x0 },
	{ 0xcd92, 0x25 },
	{ 0xcd93, 0x78 },
	{ 0xcd94, 0x2c },
	{ 0xcd95, 0x20 },
	{ 0xcd96, 0x42 },
	{ 0xcd97, 0x65 },
	{ 0xcd98, 0x66 },
	{ 0xcd99, 0x6f },
	{ 0xcd9a, 0x72 },
	{ 0xcd9b, 0x65 },
	{ 0xcd9c, 0x20 },
	{ 0xcd9d, 0x43 },
	{ 0xcd9e, 0x6f },
	{ 0xcd9f, 0x6e },
	{ 0xcda0, 0x76 },
	{ 0xcda1, 0x65 },
	{ 0xcda2, 0x72 },
	{ 0xcda3, 0x74 },
	{ 0xcda4, 0x3a },
	{ 0xcda5, 0x25 },
	{ 0xcda6, 0x78 },
	{ 0xcda7, 0xa },
	{ 0xcda8, 0x0 },
	{ 0xcda9, 0x4d },
	{ 0xcdaa, 0x61 },
	{ 0xcdab, 0x6e },
	{ 0xcdac, 0x75 },
	{ 0xcdad, 0x61 },
	{ 0xcdae, 0x6c },
	{ 0xcdaf, 0x41 },
	{ 0xcdb0, 0x6e },
	{ 0xcdb1, 0x61 },
	{ 0xcdb2, 0x47 },
	{ 0xcdb3, 0x61 },
	{ 0xcdb4, 0x69 },
	{ 0xcdb5, 0x6e },
	{ 0xcdb6, 0x3a },
	{ 0xcdb7, 0x25 },
	{ 0xcdb8, 0x78 },
	{ 0xcdb9, 0xa },
	{ 0xcdba, 0x0 },
	{ 0xcdbb, 0x25 },
	{ 0xcdbc, 0x78 },
	{ 0xcdbd, 0x2c },
	{ 0xcdbe, 0x20 },
	{ 0xcdbf, 0x41 },
	{ 0xcdc0, 0x6e },
	{ 0xcdc1, 0x61 },
	{ 0xcdc2, 0x47 },
	{ 0xcdc3, 0x61 },
	{ 0xcdc4, 0x69 },
	{ 0xcdc5, 0x6e },
	{ 0xcdc6, 0x3a },
	{ 0xcdc7, 0x25 },
	{ 0xcdc8, 0x78 },
	{ 0xcdc9, 0xa },
	{ 0xcdca, 0x0 },
	{ 0xcdcb, 0x25 },
	{ 0xcdcc, 0x78 },
	{ 0xcdcd, 0x2c },
	{ 0xcdce, 0x20 },
	{ 0xcdcf, 0x54 },
	{ 0xcdd0, 0x6f },
	{ 0xcdd1, 0x74 },
	{ 0xcdd2, 0x61 },
	{ 0xcdd3, 0x6c },
	{ 0xcdd4, 0x47 },
	{ 0xcdd5, 0x61 },
	{ 0xcdd6, 0x69 },
	{ 0xcdd7, 0x6e },
	{ 0xcdd8, 0x3a },
	{ 0xcdd9, 0x25 },
	{ 0xcdda, 0x78 },
	{ 0xcddb, 0xa },
	{ 0xcddc, 0x0 },
	{ 0xcddd, 0x54 },
	{ 0xcdde, 0x61 },
	{ 0xcddf, 0x72 },
	{ 0xcde0, 0x67 },
	{ 0xcde1, 0x65 },
	{ 0xcde2, 0x74 },
	{ 0xcde3, 0x59 },
	{ 0xcde4, 0x3a },
	{ 0xcde5, 0x20 },
	{ 0xcde6, 0x30 },
	{ 0xcde7, 0x78 },
	{ 0xcde8, 0x25 },
	{ 0xcde9, 0x78 },
	{ 0xcdea, 0xa },
	{ 0xcdeb, 0x0 },
	{ 0xcdec, 0x4d },
	{ 0xcded, 0x61 },
	{ 0xcdee, 0x78 },
	{ 0xcdef, 0x4c },
	{ 0xcdf0, 0x53 },
	{ 0xcdf1, 0x72 },
	{ 0xcdf2, 0x20 },
	{ 0xcdf3, 0x30 },
	{ 0xcdf4, 0x78 },
	{ 0xcdf5, 0x25 },
	{ 0xcdf6, 0x78 },
	{ 0xcdf7, 0x2c },
	{ 0xcdf8, 0x20 },
	{ 0xcdf9, 0x48 },
	{ 0xcdfa, 0x44 },
	{ 0xcdfb, 0x52 },
	{ 0xcdfc, 0x48 },
	{ 0xcdfd, 0x6c },
	{ 0xcdfe, 0x20 },
	{ 0xcdff, 0x30 },
	{ 0xce00, 0x78 },
	{ 0xce01, 0x25 },
	{ 0xce02, 0x78 },
	{ 0xce03, 0x2c },
	{ 0xce04, 0x20 },
	{ 0xce05, 0x6e },
	{ 0xce06, 0x4c },
	{ 0xce07, 0x20 },
	{ 0xce08, 0x30 },
	{ 0xce09, 0x78 },
	{ 0xce0a, 0x25 },
	{ 0xce0b, 0x78 },
	{ 0xce0c, 0x2c },
	{ 0xce0d, 0x20 },
	{ 0xce0e, 0x4c },
	{ 0xce0f, 0x53 },
	{ 0xce10, 0x48 },
	{ 0xce11, 0x6c },
	{ 0xce12, 0x20 },
	{ 0xce13, 0x30 },
	{ 0xce14, 0x78 },
	{ 0xce15, 0x25 },
	{ 0xce16, 0x78 },
	{ 0xce17, 0x2c },
	{ 0xce18, 0x20 },
	{ 0xce19, 0x6c },
	{ 0xce1a, 0x73 },
	{ 0xce1b, 0x6d },
	{ 0xce1c, 0x65 },
	{ 0xce1d, 0x61 },
	{ 0xce1e, 0x6e },
	{ 0xce1f, 0x20 },
	{ 0xce20, 0x30 },
	{ 0xce21, 0x78 },
	{ 0xce22, 0x25 },
	{ 0xce23, 0x78 },
	{ 0xce24, 0x20 },
	{ 0xce25, 0xa },
	{ 0xce26, 0x0 },
	{ 0xce27, 0x4c },
	{ 0xce28, 0x53 },
	{ 0xce29, 0x4d },
	{ 0xce2a, 0x65 },
	{ 0xce2b, 0x61 },
	{ 0xce2c, 0x6e },
	{ 0xce2d, 0x59 },
	{ 0xce2e, 0x4c },
	{ 0xce2f, 0x69 },
	{ 0xce30, 0x6d },
	{ 0xce31, 0x3a },
	{ 0xce32, 0x20 },
	{ 0xce33, 0x30 },
	{ 0xce34, 0x78 },
	{ 0xce35, 0x25 },
	{ 0xce36, 0x78 },
	{ 0xce37, 0x2c },
	{ 0xce38, 0x20 },
	{ 0xce39, 0x62 },
	{ 0xce3a, 0x6c },
	{ 0xce3b, 0x65 },
	{ 0xce3c, 0x6e },
	{ 0xce3d, 0x64 },
	{ 0xce3e, 0x57 },
	{ 0xce3f, 0x3a },
	{ 0xce40, 0x20 },
	{ 0xce41, 0x30 },
	{ 0xce42, 0x78 },
	{ 0xce43, 0x25 },
	{ 0xce44, 0x78 },
	{ 0xce45, 0x2c },
	{ 0xce46, 0x20 },
	{ 0xce47, 0x31 },
	{ 0xce48, 0x50 },
	{ 0xce49, 0x4f },
	{ 0xce4a, 0x75 },
	{ 0xce4b, 0x74 },
	{ 0xce4c, 0x3a },
	{ 0xce4d, 0x20 },
	{ 0xce4e, 0x30 },
	{ 0xce4f, 0x78 },
	{ 0xce50, 0x25 },
	{ 0xce51, 0x78 },
	{ 0xce52, 0x2c },
	{ 0xce53, 0x20 },
	{ 0xce54, 0x32 },
	{ 0xce55, 0x50 },
	{ 0xce56, 0x4f },
	{ 0xce57, 0x75 },
	{ 0xce58, 0x74 },
	{ 0xce59, 0x3a },
	{ 0xce5a, 0x20 },
	{ 0xce5b, 0x30 },
	{ 0xce5c, 0x78 },
	{ 0xce5d, 0x25 },
	{ 0xce5e, 0x78 },
	{ 0xce5f, 0x2c },
	{ 0xce60, 0x20 },
	{ 0xce61, 0x32 },
	{ 0xce62, 0x50 },
	{ 0xce63, 0x4f },
	{ 0xce64, 0x75 },
	{ 0xce65, 0x74 },
	{ 0xce66, 0x4c },
	{ 0xce67, 0x69 },
	{ 0xce68, 0x6d },
	{ 0xce69, 0x3a },
	{ 0xce6a, 0x20 },
	{ 0xce6b, 0x30 },
	{ 0xce6c, 0x78 },
	{ 0xce6d, 0x25 },
	{ 0xce6e, 0x78 },
	{ 0xce6f, 0x2c },
	{ 0xce70, 0x20 },
	{ 0xce71, 0x4c },
	{ 0xce72, 0x43 },
	{ 0xce73, 0x6f },
	{ 0xce74, 0x6d },
	{ 0xce75, 0x70 },
	{ 0xce76, 0x4d },
	{ 0xce77, 0x69 },
	{ 0xce78, 0x6e },
	{ 0xce79, 0x4c },
	{ 0xce7a, 0x69 },
	{ 0xce7b, 0x6d },
	{ 0xce7c, 0x3a },
	{ 0xce7d, 0x20 },
	{ 0xce7e, 0x30 },
	{ 0xce7f, 0x78 },
	{ 0xce80, 0x25 },
	{ 0xce81, 0x78 },
	{ 0xce82, 0xa },
	{ 0xce83, 0x0 },
	{ 0xce84, 0x56 },
	{ 0xce85, 0x53 },
	{ 0xce86, 0x43 },
	{ 0xce87, 0x52 },
	{ 0xce88, 0x61 },
	{ 0xce89, 0x74 },
	{ 0xce8a, 0x69 },
	{ 0xce8b, 0x6f },
	{ 0xce8c, 0x3a },
	{ 0xce8d, 0x20 },
	{ 0xce8e, 0x30 },
	{ 0xce8f, 0x78 },
	{ 0xce90, 0x25 },
	{ 0xce91, 0x78 },
	{ 0xce92, 0x2c },
	{ 0xce93, 0x20 },
	{ 0xce94, 0x31 },
	{ 0xce95, 0x50 },
	{ 0xce96, 0x2d },
	{ 0xce97, 0x4b },
	{ 0xce98, 0x6e },
	{ 0xce99, 0x65 },
	{ 0xce9a, 0x65 },
	{ 0xce9b, 0x50 },
	{ 0xce9c, 0x4f },
	{ 0xce9d, 0x75 },
	{ 0xce9e, 0x74 },
	{ 0xce9f, 0x3a },
	{ 0xcea0, 0x20 },
	{ 0xcea1, 0x30 },
	{ 0xcea2, 0x78 },
	{ 0xcea3, 0x25 },
	{ 0xcea4, 0x78 },
	{ 0xcea5, 0x2c },
	{ 0xcea6, 0x20 },
	{ 0xcea7, 0x31 },
	{ 0xcea8, 0x50 },
	{ 0xcea9, 0x2d },
	{ 0xceaa, 0x4c },
	{ 0xceab, 0x3a },
	{ 0xceac, 0x20 },
	{ 0xcead, 0x30 },
	{ 0xceae, 0x78 },
	{ 0xceaf, 0x25 },
	{ 0xceb0, 0x78 },
	{ 0xceb1, 0x2c },
	{ 0xceb2, 0x20 },
	{ 0xceb3, 0x4c },
	{ 0xceb4, 0x53 },
	{ 0xceb5, 0x31 },
	{ 0xceb6, 0x50 },
	{ 0xceb7, 0x2d },
	{ 0xceb8, 0x45 },
	{ 0xceb9, 0x51 },
	{ 0xceba, 0x4c },
	{ 0xcebb, 0x3a },
	{ 0xcebc, 0x20 },
	{ 0xcebd, 0x30 },
	{ 0xcebe, 0x78 },
	{ 0xcebf, 0x25 },
	{ 0xcec0, 0x78 },
	{ 0xcec1, 0xa },
	{ 0xcec2, 0x0 },
	{ 0xcec3, 0x6e },
	{ 0xcec4, 0x4c },
	{ 0xcec5, 0x44 },
	{ 0xcec6, 0x52 },
	{ 0xcec7, 0x54 },
	{ 0xcec8, 0x61 },
	{ 0xcec9, 0x72 },
	{ 0xceca, 0x67 },
	{ 0xcecb, 0x65 },
	{ 0xcecc, 0x74 },
	{ 0xcecd, 0x59 },
	{ 0xcece, 0x20 },
	{ 0xcecf, 0x3d },
	{ 0xced0, 0x20 },
	{ 0xced1, 0x30 },
	{ 0xced2, 0x78 },
	{ 0xced3, 0x25 },
	{ 0xced4, 0x78 },
	{ 0xced5, 0x2c },
	{ 0xced6, 0x6e },
	{ 0xced7, 0x42 },
	{ 0xced8, 0x72 },
	{ 0xced9, 0x69 },
	{ 0xceda, 0x67 },
	{ 0xcedb, 0x68 },
	{ 0xcedc, 0x74 },
	{ 0xcedd, 0x6e },
	{ 0xcede, 0x65 },
	{ 0xcedf, 0x73 },
	{ 0xcee0, 0x73 },
	{ 0xcee1, 0x3d },
	{ 0xcee2, 0x30 },
	{ 0xcee3, 0x78 },
	{ 0xcee4, 0x25 },
	{ 0xcee5, 0x78 },
	{ 0xcee6, 0xa },
	{ 0xcee7, 0x0 },
	{ 0xcee8, 0x6e },
	{ 0xcee9, 0x4c },
	{ 0xceea, 0x6f },
	{ 0xceeb, 0x67 },
	{ 0xceec, 0x44 },
	{ 0xceed, 0x79 },
	{ 0xceee, 0x6e },
	{ 0xceef, 0x61 },
	{ 0xcef0, 0x6d },
	{ 0xcef1, 0x69 },
	{ 0xcef2, 0x63 },
	{ 0xcef3, 0x52 },
	{ 0xcef4, 0x61 },
	{ 0xcef5, 0x6e },
	{ 0xcef6, 0x67 },
	{ 0xcef7, 0x65 },
	{ 0xcef8, 0x20 },
	{ 0xcef9, 0x3d },
	{ 0xcefa, 0x20 },
	{ 0xcefb, 0x30 },
	{ 0xcefc, 0x78 },
	{ 0xcefd, 0x25 },
	{ 0xcefe, 0x78 },
	{ 0xceff, 0x2c },
	{ 0xcf00, 0x6e },
	{ 0xcf01, 0x42 },
	{ 0xcf02, 0x72 },
	{ 0xcf03, 0x69 },
	{ 0xcf04, 0x67 },
	{ 0xcf05, 0x68 },
	{ 0xcf06, 0x74 },
	{ 0xcf07, 0x6e },
	{ 0xcf08, 0x65 },
	{ 0xcf09, 0x73 },
	{ 0xcf0a, 0x73 },
	{ 0xcf0b, 0x3d },
	{ 0xcf0c, 0x30 },
	{ 0xcf0d, 0x78 },
	{ 0xcf0e, 0x25 },
	{ 0xcf0f, 0x78 },
	{ 0xcf10, 0x2c },
	{ 0xcf11, 0x20 },
	{ 0xcf12, 0x6e },
	{ 0xcf13, 0x54 },
	{ 0xcf14, 0x61 },
	{ 0xcf15, 0x72 },
	{ 0xcf16, 0x67 },
	{ 0xcf17, 0x65 },
	{ 0xcf18, 0x74 },
	{ 0xcf19, 0x59 },
	{ 0xcf1a, 0x20 },
	{ 0xcf1b, 0x3d },
	{ 0xcf1c, 0x20 },
	{ 0xcf1d, 0x30 },
	{ 0xcf1e, 0x78 },
	{ 0xcf1f, 0x25 },
	{ 0xcf20, 0x78 },
	{ 0xcf21, 0x2c },
	{ 0xcf22, 0x20 },
	{ 0xcf23, 0x4e },
	{ 0xcf24, 0x6f },
	{ 0xcf25, 0x72 },
	{ 0xcf26, 0x4d },
	{ 0xcf27, 0x65 },
	{ 0xcf28, 0x61 },
	{ 0xcf29, 0x6e },
	{ 0xcf2a, 0x20 },
	{ 0xcf2b, 0x3d },
	{ 0xcf2c, 0x20 },
	{ 0xcf2d, 0x30 },
	{ 0xcf2e, 0x78 },
	{ 0xcf2f, 0x25 },
	{ 0xcf30, 0x78 },
	{ 0xcf31, 0xa },
	{ 0xcf32, 0x0 },
	{ 0xcf33, 0x4c },
	{ 0xcf34, 0x53 },
	{ 0xcf35, 0x6d },
	{ 0xcf36, 0x65 },
	{ 0xcf37, 0x61 },
	{ 0xcf38, 0x6e },
	{ 0xcf39, 0x31 },
	{ 0xcf3a, 0x20 },
	{ 0xcf3b, 0x3d },
	{ 0xcf3c, 0x20 },
	{ 0xcf3d, 0x30 },
	{ 0xcf3e, 0x78 },
	{ 0xcf3f, 0x25 },
	{ 0xcf40, 0x78 },
	{ 0xcf41, 0x2c },
	{ 0xcf42, 0x20 },
	{ 0xcf43, 0x4c },
	{ 0xcf44, 0x53 },
	{ 0xcf45, 0x6d },
	{ 0xcf46, 0x65 },
	{ 0xcf47, 0x61 },
	{ 0xcf48, 0x6e },
	{ 0xcf49, 0x32 },
	{ 0xcf4a, 0x20 },
	{ 0xcf4b, 0x3d },
	{ 0xcf4c, 0x20 },
	{ 0xcf4d, 0x30 },
	{ 0xcf4e, 0x78 },
	{ 0xcf4f, 0x25 },
	{ 0xcf50, 0x78 },
	{ 0xcf51, 0x20 },
	{ 0xcf52, 0x20 },
	{ 0xcf53, 0x20 },
	{ 0xcf54, 0xa },
	{ 0xcf55, 0x0 },
	{ 0xcf56, 0x46 },
	{ 0xcf57, 0x69 },
	{ 0xcf58, 0x6e },
	{ 0xcf59, 0x61 },
	{ 0xcf5a, 0x6c },
	{ 0xcf5b, 0x20 },
	{ 0xcf5c, 0x56 },
	{ 0xcf5d, 0x61 },
	{ 0xcf5e, 0x6c },
	{ 0xcf5f, 0x20 },
	{ 0xcf60, 0x57 },
	{ 0xcf61, 0x69 },
	{ 0xcf62, 0x74 },
	{ 0xcf63, 0x68 },
	{ 0xcf64, 0x20 },
	{ 0xcf65, 0x57 },
	{ 0xcf66, 0x65 },
	{ 0xcf67, 0x69 },
	{ 0xcf68, 0x67 },
	{ 0xcf69, 0x68 },
	{ 0xcf6a, 0x74 },
	{ 0xcf6b, 0x3a },
	{ 0xcf6c, 0x20 },
	{ 0xcf6d, 0x30 },
	{ 0xcf6e, 0x78 },
	{ 0xcf6f, 0x25 },
	{ 0xcf70, 0x78 },
	{ 0xcf71, 0x2c },
	{ 0xcf72, 0x20 },
	{ 0xcf73, 0x30 },
	{ 0xcf74, 0x78 },
	{ 0xcf75, 0x25 },
	{ 0xcf76, 0x78 },
	{ 0xcf77, 0x2c },
	{ 0xcf78, 0x20 },
	{ 0xcf79, 0x30 },
	{ 0xcf7a, 0x78 },
	{ 0xcf7b, 0x25 },
	{ 0xcf7c, 0x78 },
	{ 0xcf7d, 0x2c },
	{ 0xcf7e, 0x20 },
	{ 0xcf7f, 0x30 },
	{ 0xcf80, 0x78 },
	{ 0xcf81, 0x25 },
	{ 0xcf82, 0x78 },
	{ 0xcf83, 0xa },
	{ 0xcf84, 0x0 },
	{ 0xcf85, 0x42 },
	{ 0xcf86, 0x61 },
	{ 0xcf87, 0x73 },
	{ 0xcf88, 0x65 },
	{ 0xcf89, 0x4d },
	{ 0xcf8a, 0x61 },
	{ 0xcf8b, 0x70 },
	{ 0xcf8c, 0x20 },
	{ 0xcf8d, 0x56 },
	{ 0xcf8e, 0x61 },
	{ 0xcf8f, 0x6c },
	{ 0xcf90, 0x20 },
	{ 0xcf91, 0x57 },
	{ 0xcf92, 0x69 },
	{ 0xcf93, 0x74 },
	{ 0xcf94, 0x68 },
	{ 0xcf95, 0x20 },
	{ 0xcf96, 0x57 },
	{ 0xcf97, 0x65 },
	{ 0xcf98, 0x69 },
	{ 0xcf99, 0x67 },
	{ 0xcf9a, 0x68 },
	{ 0xcf9b, 0x74 },
	{ 0xcf9c, 0x3a },
	{ 0xcf9d, 0x20 },
	{ 0xcf9e, 0x30 },
	{ 0xcf9f, 0x78 },
	{ 0xcfa0, 0x25 },
	{ 0xcfa1, 0x78 },
	{ 0xcfa2, 0x2c },
	{ 0xcfa3, 0x20 },
	{ 0xcfa4, 0x30 },
	{ 0xcfa5, 0x78 },
	{ 0xcfa6, 0x25 },
	{ 0xcfa7, 0x78 },
	{ 0xcfa8, 0x2c },
	{ 0xcfa9, 0x20 },
	{ 0xcfaa, 0x30 },
	{ 0xcfab, 0x78 },
	{ 0xcfac, 0x25 },
	{ 0xcfad, 0x78 },
	{ 0xcfae, 0x2c },
	{ 0xcfaf, 0x20 },
	{ 0xcfb0, 0x30 },
	{ 0xcfb1, 0x78 },
	{ 0xcfb2, 0x25 },
	{ 0xcfb3, 0x78 },
	{ 0xcfb4, 0xa },
	{ 0xcfb5, 0x0 },
	{ 0xcfb6, 0x52 },
	{ 0xcfb7, 0x4f },
	{ 0xcfb8, 0x49 },
	{ 0xcfb9, 0x20 },
	{ 0xcfba, 0x57 },
	{ 0xcfbb, 0x65 },
	{ 0xcfbc, 0x69 },
	{ 0xcfbd, 0x67 },
	{ 0xcfbe, 0x68 },
	{ 0xcfbf, 0x74 },
	{ 0xcfc0, 0x3a },
	{ 0xcfc1, 0x20 },
	{ 0xcfc2, 0x30 },
	{ 0xcfc3, 0x78 },
	{ 0xcfc4, 0x25 },
	{ 0xcfc5, 0x78 },
	{ 0xcfc6, 0x2c },
	{ 0xcfc7, 0x20 },
	{ 0xcfc8, 0x30 },
	{ 0xcfc9, 0x78 },
	{ 0xcfca, 0x25 },
	{ 0xcfcb, 0x78 },
	{ 0xcfcc, 0x2c },
	{ 0xcfcd, 0x20 },
	{ 0xcfce, 0x30 },
	{ 0xcfcf, 0x78 },
	{ 0xcfd0, 0x25 },
	{ 0xcfd1, 0x78 },
	{ 0xcfd2, 0x2c },
	{ 0xcfd3, 0x20 },
	{ 0xcfd4, 0x30 },
	{ 0xcfd5, 0x78 },
	{ 0xcfd6, 0x25 },
	{ 0xcfd7, 0x78 },
	{ 0xcfd8, 0x2c },
	{ 0xcfd9, 0x20 },
	{ 0xcfda, 0x30 },
	{ 0xcfdb, 0x78 },
	{ 0xcfdc, 0x25 },
	{ 0xcfdd, 0x78 },
	{ 0xcfde, 0x2c },
	{ 0xcfdf, 0x20 },
	{ 0xcfe0, 0x30 },
	{ 0xcfe1, 0x78 },
	{ 0xcfe2, 0x25 },
	{ 0xcfe3, 0x78 },
	{ 0xcfe4, 0xa },
	{ 0xcfe5, 0x0 },
	{ 0xcfe6, 0x52 },
	{ 0xcfe7, 0x4f },
	{ 0xcfe8, 0x49 },
	{ 0xcfe9, 0x5f },
	{ 0xcfea, 0x30 },
	{ 0xcfeb, 0x3a },
	{ 0xcfec, 0x20 },
	{ 0xcfed, 0x30 },
	{ 0xcfee, 0x78 },
	{ 0xcfef, 0x25 },
	{ 0xcff0, 0x78 },
	{ 0xcff1, 0x2c },
	{ 0xcff2, 0x20 },
	{ 0xcff3, 0x30 },
	{ 0xcff4, 0x78 },
	{ 0xcff5, 0x25 },
	{ 0xcff6, 0x78 },
	{ 0xcff7, 0x2c },
	{ 0xcff8, 0x20 },
	{ 0xcff9, 0x30 },
	{ 0xcffa, 0x78 },
	{ 0xcffb, 0x25 },
	{ 0xcffc, 0x78 },
	{ 0xcffd, 0x2c },
	{ 0xcffe, 0x20 },
	{ 0xcfff, 0x30 },
	{ 0xd000, 0x78 },
	{ 0xd001, 0x25 },
	{ 0xd002, 0x78 },
	{ 0xd003, 0xa },
	{ 0xd004, 0x0 },
	{ 0xd005, 0x41 },
	{ 0xd006, 0x57 },
	{ 0xd007, 0x42 },
	{ 0xd008, 0x20 },
	{ 0xd009, 0x53 },
	{ 0xd00a, 0x74 },
	{ 0xd00b, 0x61 },
	{ 0xd00c, 0x74 },
	{ 0xd00d, 0x69 },
	{ 0xd00e, 0x73 },
	{ 0xd00f, 0x74 },
	{ 0xd010, 0x69 },
	{ 0xd011, 0x63 },
	{ 0xd012, 0x3a },
	{ 0xd013, 0x20 },
	{ 0xd014, 0x30 },
	{ 0xd015, 0x78 },
	{ 0xd016, 0x25 },
	{ 0xd017, 0x78 },
	{ 0xd018, 0x2c },
	{ 0xd019, 0x20 },
	{ 0xd01a, 0x30 },
	{ 0xd01b, 0x78 },
	{ 0xd01c, 0x25 },
	{ 0xd01d, 0x78 },
	{ 0xd01e, 0x2c },
	{ 0xd01f, 0x20 },
	{ 0xd020, 0x30 },
	{ 0xd021, 0x78 },
	{ 0xd022, 0x25 },
	{ 0xd023, 0x78 },
	{ 0xd024, 0x2c },
	{ 0xd025, 0x20 },
	{ 0xd026, 0x30 },
	{ 0xd027, 0x78 },
	{ 0xd028, 0x25 },
	{ 0xd029, 0x78 },
	{ 0xd02a, 0xa },
	{ 0xd02b, 0x0 },
	{ 0xd02c, 0x4f },
	{ 0xd02d, 0x70 },
	{ 0xd02e, 0x65 },
	{ 0xd02f, 0x6e },
	{ 0xd030, 0x20 },
	{ 0xd031, 0x54 },
	{ 0xd032, 0x48 },
	{ 0xd033, 0x45 },
	{ 0xd034, 0x20 },
	{ 0xd035, 0x43 },
	{ 0xd036, 0x6c },
	{ 0xd037, 0x69 },
	{ 0xd038, 0x70 },
	{ 0xd039, 0x50 },
	{ 0xd03a, 0x72 },
	{ 0xd03b, 0x6f },
	{ 0xd03c, 0x74 },
	{ 0xd03d, 0x65 },
	{ 0xd03e, 0x63 },
	{ 0xd03f, 0x74 },
	{ 0xd040, 0xa },
	{ 0xd041, 0x0 },
	{ 0xd042, 0x0 },
	{ 0xd043, 0x0 },
	{ 0xd044, 0xe8 },
	{ 0xd045, 0x8d },
	{ 0xa10a, 0x0 },
	{ 0xa11e, 0x7f },
	{ 0xa11d, 0x0 },
	{ 0xa110, 0x80 },
	{ 0xa10f, 0x18 },
	{ 0xa10e, 0x4c },
	{ 0xa10d, 0x0 },
	{ 0x300, 0x3e },
	{ 0x301, 0xc8 },
	{ 0x302, 0x20 },
	{ 0x303, 0x4 },
	{ 0x305, 0xe0 },
	{ 0x307, 0x1 },
	{ 0x308, 0x11 },
	{ 0x300, 0x3a },
	{ 0x320, 0x16 },
	{ 0x321, 0x31 },
	{ 0x323, 0x4 },
	{ 0x324, 0x1 },
	{ 0x325, 0xe6 },
	{ 0x326, 0x98 },
	{ 0x327, 0xa },
	{ 0x329, 0x2 },
	{ 0x32a, 0x8 },
	{ 0x32b, 0x1 },
	{ 0x32d, 0x0 },
	{ 0x330, 0xb },
	{ 0x331, 0x2 },
	{ 0x320, 0x12 },
	{ 0x8182, 0xc8 },
	{ 0x8004, 0x4 },
	{ 0x8005, 0x14 },
	{ 0x8006, 0x3 },
	{ 0x8068, 0x3 },
	{ 0x806c, 0x1 },
	{ 0x806d, 0x1 },
	{ 0x8050, 0xff },
	{ 0x8051, 0xff },
	{ 0x8052, 0xff },
	{ 0x8053, 0xff },
	{ 0x8054, 0xff },
	{ 0x8055, 0xff },
	{ 0x8056, 0xff },
	{ 0x8057, 0xff },
	{ 0x8060, 0x1 },
	{ 0x8061, 0x86 },
	{ 0x8064, 0x66 },
	{ 0x8066, 0x80 },
	{ 0x8078, 0xff },
	{ 0x8079, 0xff },
	{ 0x807a, 0xff },
	{ 0xd800, 0xe8 },
	{ 0xd801, 0x20 },
	{ 0xd802, 0x80 },
	{ 0xd803, 0x1b },
	{ 0xd804, 0x4 },
	{ 0xd805, 0xd3 },
	{ 0xd806, 0xf6 },
	{ 0xd807, 0x40 },
	{ 0xd808, 0x2 },
	{ 0xd809, 0xdc },
	{ 0xd80a, 0x6c },
	{ 0xd80b, 0x0 },
	{ 0xd80c, 0x3 },
	{ 0xd80d, 0x56 },
	{ 0xd80e, 0x7e },
	{ 0xd80f, 0x0 },
	{ 0xd810, 0x1 },
	{ 0xd811, 0x6e },
	{ 0xd812, 0x36 },
	{ 0xd813, 0x0 },
	{ 0xd818, 0xff },
	{ 0xd819, 0xff },
	{ 0xd81a, 0xff },
	{ 0xd81b, 0xff },
	{ 0xd81c, 0xff },
	{ 0xd81d, 0xff },
	{ 0xd81e, 0xff },
	{ 0xd81f, 0xff },
	{ 0xd820, 0x0 },
	{ 0xd821, 0x0 },
	{ 0xd822, 0x0 },
	{ 0xd823, 0x0 },
	{ 0xd824, 0x0 },
	{ 0xd825, 0x0 },
	{ 0xd826, 0x0 },
	{ 0xd827, 0x0 },
	{ 0xd829, 0x0 },
	{ 0xd82a, 0x0 },
	{ 0xd82b, 0x0 },
	{ 0xd82c, 0x12 },
	{ 0xd830, 0x6 },
	{ 0xd831, 0x6f },
	{ 0xd832, 0xf3 },
	{ 0xd833, 0x0 },
	{ 0xd838, 0x1 },
	{ 0xd839, 0x6e },
	{ 0xd83a, 0x36 },
	{ 0xd83b, 0x0 },
	{ 0xd83c, 0x5 },
	{ 0xd83d, 0x50 },
	{ 0xd83e, 0x4 },
	{ 0xd83f, 0xc },
	{ 0xd840, 0xc },
	{ 0xd841, 0xa8 },
	{ 0xd842, 0x4 },
	{ 0xd843, 0x57 },
	{ 0xd844, 0x1 },
	{ 0xd845, 0x0 },
	{ 0xd846, 0x0 },
	{ 0xd847, 0x0 },
	{ 0xd850, 0x2 },
	{ 0xd851, 0x2 },
	{ 0xd852, 0x22 },
	{ 0xd853, 0x1 },
	{ 0xd854, 0xb0 },
	{ 0xd855, 0x0 },
	{ 0xd856, 0x1 },
	{ 0xd857, 0x0 },
	{ 0xd858, 0x87 },
	{ 0xd859, 0x0 },
	{ 0xd85a, 0x1 },
	{ 0xd85b, 0x0 },
	{ 0xd894, 0x87 },
	{ 0xd895, 0x0 },
	{ 0xd896, 0x0 },
	{ 0xd897, 0x80 },
	{ 0xd898, 0xb0 },
	{ 0xd899, 0x0 },
	{ 0xd89a, 0x0 },
	{ 0xd89b, 0x80 },
	{ 0xd8e8, 0x0 },
	{ 0xd8e9, 0x0 },
	{ 0xd8ea, 0x0 },
	{ 0xd8eb, 0x2 },
	{ 0xd8ec, 0x0 },
	{ 0xd8ed, 0x4 },
	{ 0xe068, 0x10 },
	{ 0xe069, 0x57 },
	{ 0xe072, 0x28 },
	{ 0xe073, 0x1 },
	{ 0xe074, 0x4 },
	{ 0xe075, 0x10 },
	{ 0xe076, 0x1 },
	{ 0xe077, 0x0 },
	{ 0xe078, 0xc0 },
	{ 0xe079, 0x0 },
	{ 0xe07a, 0x82 },
	{ 0xe07b, 0x9 },
	{ 0xe07c, 0xb4 },
	{ 0xe07d, 0xc5 },
	{ 0xe07e, 0x1 },
	{ 0xe07f, 0x86 },
	{ 0xe080, 0x0 },
	{ 0xe0ca, 0x4 },
	{ 0xe0cb, 0x2d },
	{ 0xe0cc, 0x4 },
	{ 0xe0cd, 0x2d },
	{ 0xe0ce, 0x0 },
	{ 0xe0cf, 0x20 },
	{ 0xe0d0, 0xa },
	{ 0xe0d1, 0x0 },
	{ 0xe0d3, 0x5 },
	{ 0xe0d4, 0x20 },
	{ 0xe0d5, 0x1 },
	{ 0x8601, 0x30 },
	{ 0x8603, 0x8c },
	{ 0x8604, 0x1 },
	{ 0x8605, 0xac },
	{ 0x8610, 0x38 },
	{ 0x8611, 0x5 },
	{ 0x8612, 0x38 },
	{ 0x8613, 0x5 },
	{ 0x9803, 0x2 },
	{ 0x99f0, 0xbf },
	{ 0x99f1, 0x2 },
	{ 0x99f4, 0x73 },
	{ 0x9801, 0x84 },
	{ 0x8088, 0x0 },
	{ 0x8008, 0xc },
	{ 0x800b, 0x4 },
	{ 0x8040, 0x1 },
	{ 0x8041, 0x4 },
	{ 0x8042, 0x1 },
	{ 0x8194, 0x80 },
	{ 0x80a0, 0x16 },
	{ 0x80a8, 0x9 },
	{ 0x80e0, 0xa0 },
	{ 0x80e1, 0xa },
	{ 0x80e2, 0x20 },
	{ 0x80e4, 0x42 },
	{ 0x80e5, 0x25 },
	{ 0x80e9, 0xc0 },
	{ 0x80ea, 0x7c },
	{ 0x80eb, 0x5c },
	{ 0x4888, 0x98 },
	{ 0x3009, 0x2a },
	{ 0x302d, 0x4 },
	{ 0x3012, 0x41 },
	{ 0x3502, 0x8 },
	{ 0x3504, 0x88 },
	{ 0x3508, 0x0 },
	{ 0x3542, 0x20 },
	{ 0x3544, 0x88 },
	{ 0x3548, 0x0 },
	{ 0x3582, 0x1 },
	{ 0x3584, 0x88 },
	{ 0x3588, 0x0 },
	{ 0x3600, 0x1 },
	{ 0x3601, 0xe0 },
	{ 0x3603, 0xc8 },
	{ 0x3604, 0x3 },
	{ 0x3605, 0x49 },
	{ 0x3606, 0x0 },
	{ 0x3607, 0x2 },
	{ 0x3608, 0xc8 },
	{ 0x3609, 0x71 },
	{ 0x360a, 0x10 },
	{ 0x360b, 0x8 },
	{ 0x360c, 0x0 },
	{ 0x360f, 0x68 },
	{ 0x3610, 0x62 },
	{ 0x3611, 0x66 },
	{ 0x3612, 0x68 },
	{ 0x3613, 0x6 },
	{ 0x3615, 0x89 },
	{ 0x361a, 0x22 },
	{ 0x361b, 0x94 },
	{ 0x361c, 0x83 },
	{ 0x3638, 0x0 },
	{ 0x3644, 0x0 },
	{ 0x3648, 0x0 },
	{ 0x364c, 0xe },
	{ 0x364d, 0xe },
	{ 0x364e, 0xe },
	{ 0x364f, 0xe },
	{ 0x3652, 0x98 },
	{ 0x3653, 0x4 },
	{ 0x3654, 0x4a },
	{ 0x3655, 0xd },
	{ 0x3656, 0xc },
	{ 0x3657, 0x80 },
	{ 0x3658, 0x0 },
	{ 0x3670, 0xf },
	{ 0x3682, 0x30 },
	{ 0x3683, 0x0 },
	{ 0x3684, 0x2 },
	{ 0x3685, 0x80 },
	{ 0x3696, 0x4 },
	{ 0x3663, 0x20 },
	{ 0x366f, 0x0 },
	{ 0x3673, 0x2a },
	{ 0x3d92, 0x5d },
	{ 0x3d93, 0x56 },
	{ 0x3da5, 0x28 },
	{ 0x3da6, 0x80 },
	{ 0x3da7, 0x3 },
	{ 0x3d8c, 0x20 },
	{ 0x3d8d, 0x11 },
	{ 0x370b, 0xba },
	{ 0x3738, 0x61 },
	{ 0x3756, 0x4a },
	{ 0x3757, 0x5a },
	{ 0x376c, 0x77 },
	{ 0x3799, 0x3 },
	{ 0x37c8, 0x22 },
	{ 0x37ca, 0x22 },
	{ 0x3c3b, 0x18 },
	{ 0x3c63, 0xe },
	{ 0x380c, 0x8 },
	{ 0x380d, 0x70 },
	{ 0x381c, 0x8 },
	{ 0x3820, 0x1 },
	{ 0x3826, 0x4 },
	{ 0x3827, 0x4f },
	{ 0x382a, 0x1 },
	{ 0x382d, 0x1 },
	{ 0x3833, 0x42 },
	{ 0x3881, 0x1 },
	{ 0x3a84, 0x36 },
	{ 0x3ad4, 0x1 },
	{ 0x4008, 0x2 },
	{ 0x4009, 0xd },
	{ 0x400b, 0xd0 },
	{ 0x400e, 0x10 },
	{ 0x401b, 0x14 },
	{ 0x401c, 0x14 },
	{ 0x401d, 0x14 },
	{ 0x4032, 0x3e },
	{ 0x40b2, 0xc0 },
	{ 0x450d, 0x8 },
	{ 0x4d09, 0xcf },
	{ 0x4d0a, 0x6a },
	{ 0x4d0b, 0x78 },
	{ 0x4d0c, 0xa9 },
	{ 0x4d0d, 0xc },
	{ 0x4d0e, 0x80 },
	{ 0x4d14, 0x69 },
	{ 0x4d17, 0x2 },
	{ 0x4e04, 0xeb },
	{ 0x4e08, 0x51 },
	{ 0x4e0c, 0xa3 },
	{ 0x4e0e, 0x3a },
	{ 0xb271, 0x0 },
	{ 0xb366, 0xfd },
	{ 0xb367, 0x60 },
	{ 0xb368, 0xfe },
	{ 0xb369, 0x0 },
	{ 0xb43e, 0x1 },
	{ 0xb43f, 0x80 },
	{ 0xb440, 0x1 },
	{ 0xb441, 0x80 },
	{ 0xb364, 0x28 },
	{ 0xb365, 0x14 },
	{ 0xb26a, 0x1 },
	{ 0xb26b, 0x2 },
	{ 0xb2a4, 0x0 },
	{ 0xb2a5, 0x0 },
	{ 0xb2a6, 0x0 },
	{ 0xb2a7, 0x0 },
	{ 0xb2a8, 0x58 },
	{ 0xb2a9, 0x88 },
	{ 0xb2aa, 0x0 },
	{ 0xb2ab, 0x0 },
	{ 0xb2ac, 0x0 },
	{ 0xb2ad, 0x0 },
	{ 0xb2ae, 0x0 },
	{ 0xb2af, 0x88 },
	{ 0xb2b0, 0x88 },
	{ 0xb2b1, 0x88 },
	{ 0xb2b2, 0x0 },
	{ 0xb2b3, 0x0 },
	{ 0xb2b4, 0x0 },
	{ 0xb2b5, 0x0 },
	{ 0xb2b6, 0x8 },
	{ 0xb2b7, 0x88 },
	{ 0xb2b8, 0x88 },
	{ 0xb2b9, 0x80 },
	{ 0xb2ba, 0x0 },
	{ 0xb2bb, 0x0 },
	{ 0xb2bc, 0x0 },
	{ 0xb2bd, 0x0 },
	{ 0xb2be, 0x88 },
	{ 0xb2bf, 0x88 },
	{ 0xb2c0, 0x88 },
	{ 0xb2c1, 0x0 },
	{ 0xb2c2, 0x0 },
	{ 0xb2c3, 0x0 },
	{ 0xb2c4, 0x0 },
	{ 0xb2c5, 0x8 },
	{ 0xb2c6, 0x88 },
	{ 0xb2c7, 0x88 },
	{ 0xb2c8, 0x88 },
	{ 0xb2c9, 0x0 },
	{ 0xb2ca, 0x0 },
	{ 0xb2cb, 0x0 },
	{ 0xb2cc, 0x0 },
	{ 0xb2cd, 0x8 },
	{ 0xb2ce, 0x88 },
	{ 0xb2cf, 0x88 },
	{ 0xb2d0, 0x88 },
	{ 0xb2d1, 0x0 },
	{ 0xb2d2, 0x0 },
	{ 0xb2d3, 0x0 },
	{ 0xb2d4, 0x0 },
	{ 0xb2d5, 0x8 },
	{ 0xb2d6, 0x8a },
	{ 0xb2d7, 0xaa },
	{ 0xb2d8, 0xaa },
	{ 0xb2d9, 0x0 },
	{ 0xb2da, 0x0 },
	{ 0xb2db, 0x0 },
	{ 0xb2dc, 0x0 },
	{ 0xb2dd, 0x88 },
	{ 0xb2de, 0x8a },
	{ 0xb2df, 0xac },
	{ 0xb2e0, 0xaa },
	{ 0xb2e1, 0x0 },
	{ 0xb2e2, 0x0 },
	{ 0xb2e3, 0x0 },
	{ 0xb2e4, 0x8 },
	{ 0xb2e5, 0x88 },
	{ 0xb2e6, 0x88 },
	{ 0xb2e7, 0xac },
	{ 0xb2e8, 0xcc },
	{ 0xb2e9, 0xc0 },
	{ 0xb2ea, 0x0 },
	{ 0xb2eb, 0x0 },
	{ 0xb2ec, 0x88 },
	{ 0xb2ed, 0x88 },
	{ 0xb2ee, 0x8a },
	{ 0xb2ef, 0xcc },
	{ 0xb2f0, 0xcc },
	{ 0xb2f1, 0xcc },
	{ 0xb2f2, 0x0 },
	{ 0xb2f3, 0x0 },
	{ 0xb2f4, 0x0 },
	{ 0xb2f5, 0x0 },
	{ 0xb2f6, 0x0 },
	{ 0xb2f7, 0xe },
	{ 0xb2f8, 0xee },
	{ 0xb2f9, 0xee },
	{ 0xb2fa, 0x0 },
	{ 0xb2fb, 0x0 },
	{ 0xb2fc, 0x0 },
	{ 0xb2fd, 0x0 },
	{ 0xb2fe, 0x0 },
	{ 0xb2ff, 0xe },
	{ 0xb300, 0xee },
	{ 0xb301, 0xee },
	{ 0xb302, 0x0 },
	{ 0xb303, 0x0 },
	{ 0xb304, 0x0 },
	{ 0xb305, 0x0 },
	{ 0xb306, 0x0 },
	{ 0xb307, 0xe },
	{ 0xb308, 0xee },
	{ 0xb309, 0xee },
	{ 0xb30a, 0x0 },
	{ 0xb30b, 0x0 },
	{ 0xb30c, 0x0 },
	{ 0xb30d, 0x0 },
	{ 0xb30e, 0x0 },
	{ 0xb30f, 0xe },
	{ 0xb310, 0xee },
	{ 0xb311, 0xee },
	{ 0xb312, 0x0 },
	{ 0xb313, 0x0 },
	{ 0xb314, 0x0 },
	{ 0xb315, 0x0 },
	{ 0xb316, 0x0 },
	{ 0xb317, 0xe },
	{ 0xb318, 0xee },
	{ 0xb319, 0xee },
	{ 0xb31a, 0x0 },
	{ 0xb31b, 0x0 },
	{ 0xb31c, 0x0 },
	{ 0xb31d, 0x0 },
	{ 0xb31e, 0x0 },
	{ 0xb31f, 0x0 },
	{ 0xb320, 0xee },
	{ 0xb321, 0xe2 },
	{ 0xb322, 0x0 },
	{ 0xb323, 0x0 },
	{ 0xb324, 0xff },
	{ 0xb325, 0xff },
	{ 0xb326, 0xff },
	{ 0xb327, 0xff },
	{ 0xb328, 0xff },
	{ 0xb329, 0xff },
	{ 0xb32a, 0xff },
	{ 0xb32b, 0xff },
	{ 0xb32c, 0xff },
	{ 0xb32d, 0xff },
	{ 0xb32e, 0xff },
	{ 0xb32f, 0xff },
	{ 0xb330, 0xff },
	{ 0xb331, 0xff },
	{ 0xb332, 0xff },
	{ 0xb333, 0xff },
	{ 0xb334, 0xff },
	{ 0xb335, 0xff },
	{ 0xb336, 0xff },
	{ 0xb337, 0xff },
	{ 0xb338, 0xff },
	{ 0xb339, 0xff },
	{ 0xb33a, 0xff },
	{ 0xb33b, 0xff },
	{ 0xb33c, 0xff },
	{ 0xb33d, 0xff },
	{ 0xb33e, 0xff },
	{ 0xb33f, 0xff },
	{ 0xb340, 0xff },
	{ 0xb341, 0xff },
	{ 0xb342, 0xff },
	{ 0xb343, 0xff },
	{ 0xb344, 0xff },
	{ 0xb345, 0xff },
	{ 0xb346, 0xff },
	{ 0xb347, 0xff },
	{ 0xb348, 0xff },
	{ 0xb349, 0xff },
	{ 0xb34a, 0xff },
	{ 0xb34b, 0xff },
	{ 0xb34c, 0xff },
	{ 0xb34d, 0xff },
	{ 0xb34e, 0xff },
	{ 0xb34f, 0xff },
	{ 0xb350, 0xff },
	{ 0xb351, 0xff },
	{ 0xb352, 0xff },
	{ 0xb353, 0xff },
	{ 0xb354, 0xff },
	{ 0xb355, 0xff },
	{ 0xb356, 0xff },
	{ 0xb357, 0xff },
	{ 0xb358, 0xff },
	{ 0xb359, 0xff },
	{ 0xb35a, 0xff },
	{ 0xb35b, 0xff },
	{ 0xb35c, 0xff },
	{ 0xb35d, 0xff },
	{ 0xb35e, 0xff },
	{ 0xb35f, 0xff },
	{ 0xb360, 0xff },
	{ 0xb361, 0xff },
	{ 0xb362, 0xff },
	{ 0xb363, 0xff },
	{ 0xb51b, 0x10 },
	{ 0xb51d, 0x10 },
	{ 0xb51f, 0xc },
	{ 0xb54d, 0x4 },
	{ 0xb54f, 0x8 },
	{ 0xb550, 0x0 },
	{ 0xb551, 0x0 },
	{ 0xb7d1, 0x1c },
	{ 0xb7d2, 0x18 },
	{ 0xb7d3, 0x14 },
	{ 0xb7d4, 0x10 },
	{ 0xb7d5, 0xc },
	{ 0xb7d6, 0x8 },
	{ 0xb7d7, 0x4 },
	{ 0xb7d8, 0x4 },
	{ 0xb7d9, 0x2 },
	{ 0xb7da, 0x4 },
	{ 0xb7db, 0x8 },
	{ 0xb7dc, 0xc },
	{ 0xb7dd, 0x10 },
	{ 0xb7de, 0x12 },
	{ 0xb7df, 0x14 },
	{ 0xb7e0, 0x18 },
	{ 0xb496, 0x8 },
	{ 0xb4ea, 0x1 },
	{ 0xb4b8, 0x0 },
	{ 0xb4b9, 0x40 },
	{ 0xb4ba, 0x0 },
	{ 0xb4bb, 0x80 },
	{ 0xb4bc, 0x1 },
	{ 0xb4bd, 0x0 },
	{ 0xb4be, 0x2 },
	{ 0xb4bf, 0x0 },
	{ 0xb4c0, 0x2 },
	{ 0xb4c1, 0x80 },
	{ 0xb4c2, 0x3 },
	{ 0xb4c3, 0x0 },
	{ 0xb4c4, 0x3 },
	{ 0xb4c5, 0x80 },
	{ 0xb4c6, 0x4 },
	{ 0xb4c7, 0x0 },
	{ 0xb4c8, 0x4 },
	{ 0xb4c9, 0x80 },
	{ 0xb4ca, 0x5 },
	{ 0xb4cb, 0x0 },
	{ 0xb4cc, 0x6 },
	{ 0xb4cd, 0x0 },
	{ 0xb4ce, 0x7 },
	{ 0xb4cf, 0x0 },
	{ 0xb4d0, 0x9 },
	{ 0xb4d1, 0x0 },
	{ 0xb4d2, 0xb },
	{ 0xb4d3, 0x0 },
	{ 0xb4d4, 0xd },
	{ 0xb4d5, 0x0 },
	{ 0xb4d6, 0xf },
	{ 0xb4d7, 0xf0 },
	{ 0x5900, 0xa },
	{ 0x5906, 0x11 },
	{ 0x5911, 0x0 },
	{ 0x5920, 0x0 },
	{ 0x5921, 0x4 },
	{ 0x5922, 0x3 },
	{ 0x5923, 0xc0 },
	{ 0x5801, 0x51 },
	{ 0x5811, 0x0 },
	{ 0x5801, 0x50 },
	{ 0x5814, 0x80 },
	{ 0x5815, 0x80 },
	{ 0x5816, 0x80 },
	{ 0x5817, 0x80 },
	{ 0x5818, 0x80 },
	{ 0x5819, 0x80 },
	{ 0x581a, 0x80 },
	{ 0x581b, 0x80 },
	{ 0x581c, 0x80 },
	{ 0x581d, 0x80 },
	{ 0x581e, 0x80 },
	{ 0x581f, 0x80 },
	{ 0x5820, 0x78 },
	{ 0x5821, 0x60 },
	{ 0x5822, 0x60 },
	{ 0x5823, 0x60 },
	{ 0x5824, 0x40 },
	{ 0x5825, 0x40 },
	{ 0x5826, 0x70 },
	{ 0x5827, 0x50 },
	{ 0x5828, 0x30 },
	{ 0x5829, 0x20 },
	{ 0x582a, 0x20 },
	{ 0x582b, 0x20 },
	{ 0x582c, 0x60 },
	{ 0x582d, 0x40 },
	{ 0x582e, 0x20 },
	{ 0x582f, 0x0 },
	{ 0x5830, 0x0 },
	{ 0x5831, 0x0 },
	{ 0x5832, 0x80 },
	{ 0x5833, 0x80 },
	{ 0x5834, 0x80 },
	{ 0x5835, 0x80 },
	{ 0x5836, 0x80 },
	{ 0x5837, 0x80 },
	{ 0x5838, 0x80 },
	{ 0x5839, 0x80 },
	{ 0x583a, 0x80 },
	{ 0x583b, 0x80 },
	{ 0x583c, 0x80 },
	{ 0x583d, 0x80 },
	{ 0x583e, 0x78 },
	{ 0x583f, 0x60 },
	{ 0x5840, 0x60 },
	{ 0x5841, 0x60 },
	{ 0x5842, 0x40 },
	{ 0x5843, 0x40 },
	{ 0x5844, 0x70 },
	{ 0x5845, 0x50 },
	{ 0x5846, 0x30 },
	{ 0x5847, 0x20 },
	{ 0x5848, 0x20 },
	{ 0x5849, 0x20 },
	{ 0x584a, 0x60 },
	{ 0x584b, 0x40 },
	{ 0x584c, 0x20 },
	{ 0x584d, 0x0 },
	{ 0x584e, 0x0 },
	{ 0x584f, 0x0 },
	{ 0x5ac1, 0x18 },
	{ 0x5000, 0x67 },
	{ 0x5001, 0x3f },
	{ 0x5002, 0xff },
	{ 0x5003, 0xff },
	{ 0x500d, 0x33 },
	{ 0x500e, 0x3c },
	{ 0x5010, 0x5 },
	{ 0x5011, 0x50 },
	{ 0x5012, 0x4 },
	{ 0x5013, 0xc },
	{ 0x5047, 0x15 },
	{ 0x5051, 0xa },
	{ 0x5053, 0x8 },
	{ 0x5054, 0x5 },
	{ 0x5055, 0x40 },
	{ 0x5056, 0x3 },
	{ 0x5057, 0xfc },
	{ 0x5059, 0xa },
	{ 0x505b, 0x8 },
	{ 0x505c, 0x5 },
	{ 0x505d, 0x40 },
	{ 0x505e, 0x3 },
	{ 0x505f, 0xfc },
	{ 0x5340, 0xc6 },
	{ 0x5380, 0xc6 },
	{ 0x53c0, 0xc6 },
	{ 0x5343, 0x88 },
	{ 0x5383, 0x88 },
	{ 0x53c3, 0x88 },
	{ 0x5358, 0x20 },
	{ 0x5359, 0x4a },
	{ 0x535a, 0x21 },
	{ 0x535b, 0xfd },
	{ 0x598b, 0x28 },
	{ 0x8700, 0x9 },
	{ 0x8703, 0xd0 },
	{ 0x8734, 0x78 },
	{ 0x8735, 0xa },
	{ 0x8738, 0x3c },
	{ 0x8739, 0x5 },
	{ 0x874c, 0x40 },
	{ 0x874e, 0xfc },
	{ 0x8750, 0x3c },
	{ 0x8752, 0xfc },
	{ 0x8754, 0xc5 },
	{ 0x8755, 0xb4 },
	{ 0xaa01, 0x10 },
	{ 0xad1b, 0x5 },
	{ 0xad1c, 0x40 },
	{ 0xad1d, 0x3 },
	{ 0xad1e, 0xfc },
	{ 0xad1f, 0x5 },
	{ 0xad20, 0x40 },
	{ 0xad21, 0x3 },
	{ 0xad22, 0xfc },
	{ 0xad39, 0x1e },
	{ 0xad3a, 0x1e },
	{ 0xad3d, 0x5 },
	{ 0xad3e, 0x40 },
	{ 0xad3f, 0x5 },
	{ 0xad40, 0x40 },
	{ 0xad2d, 0x3 },
	{ 0xad15, 0x90 },
	{ 0xad5a, 0x0 },
	{ 0xad2c, 0x4b },
	{ 0xad13, 0x3 },
	{ 0xad14, 0x11 },
	{ 0xad04, 0x43 },
	{ 0xad0b, 0x48 },
	{ 0xad0f, 0x2f },
	{ 0xade7, 0x11 },
	{ 0x8810, 0x60 },
	{ 0x8811, 0x9 },
	{ 0x8814, 0xbf },
	{ 0x8815, 0x12 },
	{ 0x8818, 0xc1 },
	{ 0x8819, 0x12 },
	{ 0x8820, 0xe8 },
	{ 0x8821, 0x3 },
	{ 0x8824, 0x7 },
	{ 0x8840, 0x3 },
	{ 0x8844, 0x56 },
	{ 0x8845, 0x2e },
	{ 0x8846, 0x0 },
	{ 0x8848, 0x3 },
	{ 0x884c, 0xba },
	{ 0x884d, 0xd },
	{ 0x884e, 0x0 },
	{ 0x8801, 0x0 },
	{ 0x8802, 0x1 },
	{ 0x8804, 0x2 },
	{ 0x8800, 0x7 },
	{ 0x8802, 0x0 },
	{ 0x5091, 0x7f },
	{ 0x5007, 0x20 },
	{ 0x5414, 0x3 },
	{ 0x5415, 0x10 },
	{ 0x5416, 0x48 },
	{ 0x5417, 0xc0 },
	{ 0x55d4, 0x3 },
	{ 0x55d5, 0x10 },
	{ 0x55d6, 0x70 },
	{ 0x55d7, 0xdb },
	{ 0x8500, 0x50 },
	{ 0x8501, 0x5 },
	{ 0x8502, 0xf },
	{ 0x8504, 0x2b },
	{ 0x8505, 0x20 },
	{ 0x8507, 0xfe },
	{ 0x8509, 0xfe },
	{ 0x850b, 0xfe },
	{ 0x850d, 0x41 },
	{ 0x850e, 0x30 },
	{ 0x850f, 0x26 },
	{ 0x8516, 0x10 },
	{ 0x8517, 0xdb },
	{ 0x8518, 0x14 },
	{ 0x8519, 0x78 },
	{ 0x851a, 0xca },
	{ 0x851b, 0x22 },
	{ 0x851c, 0xc2 },
	{ 0x851d, 0x8 },
	{ 0x851e, 0xc2 },
	{ 0x851f, 0x88 },
	{ 0x8520, 0xe0 },
	{ 0x8521, 0xf5 },
	{ 0x8522, 0x38 },
	{ 0x8524, 0x3c },
	{ 0x8525, 0x5 },
	{ 0x8526, 0xfc },
	{ 0x8527, 0x3 },
	{ 0x8530, 0x12 },
	{ 0xa000, 0xe7 },
	{ 0xa001, 0xcf },
	{ 0xa002, 0xff },
	{ 0xa00c, 0x0 },
	{ 0xa00d, 0x0 },
	{ 0xa00f, 0x7d },
	{ 0xa010, 0x3e },
	{ 0xa011, 0xe5 },
	{ 0xa012, 0xf },
	{ 0xa013, 0x50 },
	{ 0xa013, 0x0 },
	{ 0x810c, 0x0 },
	{ 0x8194, 0x0 },
	{ 0xd828, 0x18 },
	{ 0x3009, 0x2e },
	{ 0x3c63, 0x2 },
	{ 0xe0ae, 0x80 },
	{ 0xe0af, 0x1 },
	{ 0xb728, 0x1 },
	{ 0xb729, 0x1 },
	{ 0xb51b, 0x10 },
	{ 0xb51d, 0x10 },
	{ 0xb51f, 0x10 },
	{ 0xb52d, 0xa },
	{ 0xb52f, 0x10 },
	{ 0xb531, 0x10 },
	{ 0xb538, 0x1 },
	{ 0xb539, 0x1 },
	{ 0xb53a, 0x1 },
	{ 0xb53b, 0x1 },
	{ 0xb4f0, 0x0 },
	{ 0xb4f1, 0x0 },
	{ 0xb4f2, 0x1 },
	{ 0xb4f3, 0x0 },
	{ 0xb4f4, 0x0 },
	{ 0xb4f5, 0x0 },
	{ 0xb4f6, 0x1 },
	{ 0xb4f7, 0x0 },
	{ 0xb4f8, 0x0 },
	{ 0xb4f9, 0x0 },
	{ 0xb4fa, 0x1 },
	{ 0xb4fb, 0x0 },
	{ 0xb4fc, 0x0 },
	{ 0xb4fd, 0x0 },
	{ 0xb4fe, 0x15 },
	{ 0xb4ff, 0xde },
	{ 0xb500, 0x0 },
	{ 0xb501, 0x0 },
	{ 0xb502, 0x1 },
	{ 0xb503, 0x0 },
	{ 0xb504, 0x0 },
	{ 0xb505, 0x0 },
	{ 0xb506, 0x1 },
	{ 0xb507, 0x0 },
	{ 0xb1e0, 0x60 },
	{ 0xb124, 0x0 },
	{ 0xb125, 0x68 },
	{ 0x51c2, 0x1 },
	{ 0x51c3, 0x21 },
	{ 0x51c4, 0x1 },
	{ 0x51c5, 0x7b },
	{ 0x51c6, 0x1 },
	{ 0x51c7, 0x21 },
	{ 0x51ca, 0x0 },
	{ 0x51cb, 0xbd },
	{ 0x5202, 0x1 },
	{ 0x5203, 0x21 },
	{ 0x5204, 0x1 },
	{ 0x5205, 0x7b },
	{ 0x5206, 0x1 },
	{ 0x5207, 0x21 },
	{ 0x520a, 0x0 },
	{ 0x520b, 0xbd },
	{ 0x5242, 0x1 },
	{ 0x5243, 0x21 },
	{ 0x5244, 0x1 },
	{ 0x5245, 0x7b },
	{ 0x5246, 0x1 },
	{ 0x5247, 0x21 },
	{ 0x524a, 0x0 },
	{ 0x524b, 0xbd },
	{ 0x5003, 0xff },
	{ 0xb475, 0x0 },
	{ 0xb466, 0x0 },
	{ 0xb467, 0x6b },
	{ 0xb468, 0x0 },
	{ 0xb469, 0x80 },
	{ 0xb46a, 0x0 },
	{ 0xb46b, 0xd0 },
	{ 0xb46c, 0x0 },
	{ 0xb46d, 0xee },
	{ 0xb462, 0x0 },
	{ 0xb463, 0x20 },
	{ 0xb464, 0x0 },
	{ 0xb465, 0x80 },
	{ 0xb47c, 0x40 },
	{ 0xb47d, 0x40 },
	{ 0xb47e, 0x15 },
	{ 0xb47f, 0x15 },
	{ 0xb472, 0x1 },
	{ 0xc740, 0x1 },
	{ 0xc741, 0x0 },
	{ 0xc742, 0x0 },
	{ 0xc743, 0x0 },
	{ 0xc744, 0x0 },
	{ 0xc745, 0x0 },
	{ 0xc746, 0x0 },
	{ 0xc747, 0x1 },
	{ 0xc748, 0x0 },
	{ 0xc749, 0x0 },
	{ 0xc74a, 0x0 },
	{ 0xc74b, 0x0 },
	{ 0xc74c, 0x0 },
	{ 0xc74d, 0x0 },
	{ 0xc74e, 0x0 },
	{ 0xc74f, 0x0 },
	{ 0xc750, 0x0 },
	{ 0xc751, 0x0 },
	{ 0xc752, 0x0 },
	{ 0xc753, 0x0 },
	{ 0xc754, 0x0 },
	{ 0xc755, 0x0 },
	{ 0xc756, 0x0 },
	{ 0xc757, 0x0 },
	{ 0xc758, 0x0 },
	{ 0xc759, 0x0 },
	{ 0xc75a, 0x0 },
	{ 0xc75b, 0x1 },
	{ 0xc75c, 0x1 },
	{ 0xc75d, 0x0 },
	{ 0xc75e, 0x0 },
	{ 0xc75f, 0x0 },
	{ 0xc760, 0x0 },
	{ 0xc761, 0x0 },
	{ 0xc762, 0x0 },
	{ 0xc763, 0x1 },
	{ 0xc764, 0x1 },
	{ 0xc765, 0x0 },
	{ 0xc766, 0x0 },
	{ 0xc767, 0x0 },
	{ 0xc768, 0x0 },
	{ 0xc769, 0x0 },
	{ 0xc76a, 0x0 },
	{ 0xc76b, 0x0 },
	{ 0xc76c, 0x0 },
	{ 0xc76d, 0x0 },
	{ 0xc76e, 0x0 },
	{ 0xc76f, 0x0 },
	{ 0xc770, 0x0 },
	{ 0xc771, 0x0 },
	{ 0xc772, 0x0 },
	{ 0xc773, 0x0 },
	{ 0xc774, 0x0 },
	{ 0xc775, 0x0 },
	{ 0xc776, 0x0 },
	{ 0xc777, 0x0 },
	{ 0xc778, 0x1 },
	{ 0xc779, 0x0 },
	{ 0xc77a, 0x0 },
	{ 0xc77b, 0x0 },
	{ 0xc77c, 0x0 },
	{ 0xc77d, 0x0 },
	{ 0xc77e, 0x0 },
	{ 0xc77f, 0x1 },
	{ 0xc780, 0x3e },
	{ 0xc781, 0x3e },
	{ 0xc782, 0x3f },
	{ 0xc783, 0x3f },
	{ 0xc784, 0x40 },
	{ 0xc785, 0x40 },
	{ 0xc786, 0x3c },
	{ 0xc787, 0x3c },
	{ 0xc788, 0x3e },
	{ 0xc789, 0x3e },
	{ 0xc78a, 0x40 },
	{ 0xc78b, 0x40 },
	{ 0xc78c, 0x3f },
	{ 0xc78d, 0x40 },
	{ 0xc78e, 0x3c },
	{ 0xc78f, 0x3d },
	{ 0xc790, 0x41 },
	{ 0xc791, 0x41 },
	{ 0xc792, 0x40 },
	{ 0xc793, 0x40 },
	{ 0xc794, 0x41 },
	{ 0xc795, 0x40 },
	{ 0xc796, 0x40 },
	{ 0xc797, 0x3f },
	{ 0xc798, 0x41 },
	{ 0xc799, 0x41 },
	{ 0xc79a, 0x41 },
	{ 0xc79b, 0x41 },
	{ 0xc79c, 0x40 },
	{ 0xc79d, 0x40 },
	{ 0xc79e, 0x40 },
	{ 0xc79f, 0x40 },
	{ 0xc7a0, 0x40 },
	{ 0xc7a1, 0x40 },
	{ 0xc7a2, 0x40 },
	{ 0xc7a3, 0x40 },
	{ 0xc7a4, 0x40 },
	{ 0xc7a5, 0x41 },
	{ 0xc7a6, 0x40 },
	{ 0xc7a7, 0x41 },
	{ 0xc7a8, 0x41 },
	{ 0xc7a9, 0x40 },
	{ 0xc7aa, 0x41 },
	{ 0xc7ab, 0x40 },
	{ 0xc7ac, 0x41 },
	{ 0xc7ad, 0x40 },
	{ 0xc7ae, 0x40 },
	{ 0xc7af, 0x3f },
	{ 0xc7b0, 0x3c },
	{ 0xc7b1, 0x3d },
	{ 0xc7b2, 0x3f },
	{ 0xc7b3, 0x40 },
	{ 0xc7b4, 0x3f },
	{ 0xc7b5, 0x3e },
	{ 0xc7b6, 0x3b },
	{ 0xc7b7, 0x3a },
	{ 0xc7b8, 0x3d },
	{ 0xc7b9, 0x3d },
	{ 0xc7ba, 0x40 },
	{ 0xc7bb, 0x40 },
	{ 0xc7bc, 0x40 },
	{ 0xc7bd, 0x3d },
	{ 0xc7be, 0x3b },
	{ 0xc7bf, 0x38 },
	{ 0xc7c0, 0x45 },
	{ 0xc7c1, 0x46 },
	{ 0xc7c2, 0x44 },
	{ 0xc7c3, 0x45 },
	{ 0xc7c4, 0x44 },
	{ 0xc7c5, 0x44 },
	{ 0xc7c6, 0x46 },
	{ 0xc7c7, 0x46 },
	{ 0xc7c8, 0x46 },
	{ 0xc7c9, 0x47 },
	{ 0xc7ca, 0x43 },
	{ 0xc7cb, 0x44 },
	{ 0xc7cc, 0x43 },
	{ 0xc7cd, 0x44 },
	{ 0xc7ce, 0x45 },
	{ 0xc7cf, 0x46 },
	{ 0xc7d0, 0x41 },
	{ 0xc7d1, 0x41 },
	{ 0xc7d2, 0x41 },
	{ 0xc7d3, 0x41 },
	{ 0xc7d4, 0x41 },
	{ 0xc7d5, 0x41 },
	{ 0xc7d6, 0x43 },
	{ 0xc7d7, 0x43 },
	{ 0xc7d8, 0x42 },
	{ 0xc7d9, 0x42 },
	{ 0xc7da, 0x40 },
	{ 0xc7db, 0x40 },
	{ 0xc7dc, 0x40 },
	{ 0xc7dd, 0x41 },
	{ 0xc7de, 0x42 },
	{ 0xc7df, 0x43 },
	{ 0xc7e0, 0x42 },
	{ 0xc7e1, 0x41 },
	{ 0xc7e2, 0x41 },
	{ 0xc7e3, 0x40 },
	{ 0xc7e4, 0x41 },
	{ 0xc7e5, 0x41 },
	{ 0xc7e6, 0x42 },
	{ 0xc7e7, 0x42 },
	{ 0xc7e8, 0x44 },
	{ 0xc7e9, 0x44 },
	{ 0xc7ea, 0x42 },
	{ 0xc7eb, 0x42 },
	{ 0xc7ec, 0x42 },
	{ 0xc7ed, 0x42 },
	{ 0xc7ee, 0x44 },
	{ 0xc7ef, 0x44 },
	{ 0xc7f0, 0x46 },
	{ 0xc7f1, 0x44 },
	{ 0xc7f2, 0x45 },
	{ 0xc7f3, 0x43 },
	{ 0xc7f4, 0x44 },
	{ 0xc7f5, 0x45 },
	{ 0xc7f6, 0x44 },
	{ 0xc7f7, 0x45 },
	{ 0xc7f8, 0x48 },
	{ 0xc7f9, 0x47 },
	{ 0xc7fa, 0x46 },
	{ 0xc7fb, 0x45 },
	{ 0xc7fc, 0x45 },
	{ 0xc7fd, 0x46 },
	{ 0xc7fe, 0x46 },
	{ 0xc7ff, 0x47 },
	{ 0xc680, 0x1 },
	{ 0xc681, 0x0 },
	{ 0xc682, 0x0 },
	{ 0xc683, 0x0 },
	{ 0xc684, 0x0 },
	{ 0xc685, 0x0 },
	{ 0xc686, 0x0 },
	{ 0xc687, 0x1 },
	{ 0xc688, 0x0 },
	{ 0xc689, 0x0 },
	{ 0xc68a, 0x0 },
	{ 0xc68b, 0x0 },
	{ 0xc68c, 0x0 },
	{ 0xc68d, 0x0 },
	{ 0xc68e, 0x0 },
	{ 0xc68f, 0x0 },
	{ 0xc690, 0x0 },
	{ 0xc691, 0x0 },
	{ 0xc692, 0x0 },
	{ 0xc693, 0x0 },
	{ 0xc694, 0x0 },
	{ 0xc695, 0x0 },
	{ 0xc696, 0x0 },
	{ 0xc697, 0x0 },
	{ 0xc698, 0x0 },
	{ 0xc699, 0x0 },
	{ 0xc69a, 0x0 },
	{ 0xc69b, 0x1 },
	{ 0xc69c, 0x1 },
	{ 0xc69d, 0x0 },
	{ 0xc69e, 0x0 },
	{ 0xc69f, 0x0 },
	{ 0xc6a0, 0x0 },
	{ 0xc6a1, 0x0 },
	{ 0xc6a2, 0x0 },
	{ 0xc6a3, 0x1 },
	{ 0xc6a4, 0x1 },
	{ 0xc6a5, 0x0 },
	{ 0xc6a6, 0x0 },
	{ 0xc6a7, 0x0 },
	{ 0xc6a8, 0x0 },
	{ 0xc6a9, 0x0 },
	{ 0xc6aa, 0x0 },
	{ 0xc6ab, 0x0 },
	{ 0xc6ac, 0x0 },
	{ 0xc6ad, 0x0 },
	{ 0xc6ae, 0x0 },
	{ 0xc6af, 0x0 },
	{ 0xc6b0, 0x0 },
	{ 0xc6b1, 0x0 },
	{ 0xc6b2, 0x0 },
	{ 0xc6b3, 0x0 },
	{ 0xc6b4, 0x0 },
	{ 0xc6b5, 0x0 },
	{ 0xc6b6, 0x0 },
	{ 0xc6b7, 0x0 },
	{ 0xc6b8, 0x1 },
	{ 0xc6b9, 0x0 },
	{ 0xc6ba, 0x0 },
	{ 0xc6bb, 0x0 },
	{ 0xc6bc, 0x0 },
	{ 0xc6bd, 0x0 },
	{ 0xc6be, 0x0 },
	{ 0xc6bf, 0x1 },
	{ 0xc6c0, 0x3e },
	{ 0xc6c1, 0x3e },
	{ 0xc6c2, 0x3f },
	{ 0xc6c3, 0x3f },
	{ 0xc6c4, 0x40 },
	{ 0xc6c5, 0x3f },
	{ 0xc6c6, 0x3c },
	{ 0xc6c7, 0x3b },
	{ 0xc6c8, 0x3d },
	{ 0xc6c9, 0x3d },
	{ 0xc6ca, 0x40 },
	{ 0xc6cb, 0x40 },
	{ 0xc6cc, 0x40 },
	{ 0xc6cd, 0x3f },
	{ 0xc6ce, 0x3e },
	{ 0xc6cf, 0x3d },
	{ 0xc6d0, 0x41 },
	{ 0xc6d1, 0x41 },
	{ 0xc6d2, 0x40 },
	{ 0xc6d3, 0x40 },
	{ 0xc6d4, 0x40 },
	{ 0xc6d5, 0x40 },
	{ 0xc6d6, 0x3f },
	{ 0xc6d7, 0x3f },
	{ 0xc6d8, 0x40 },
	{ 0xc6d9, 0x40 },
	{ 0xc6da, 0x41 },
	{ 0xc6db, 0x41 },
	{ 0xc6dc, 0x40 },
	{ 0xc6dd, 0x40 },
	{ 0xc6de, 0x41 },
	{ 0xc6df, 0x41 },
	{ 0xc6e0, 0x40 },
	{ 0xc6e1, 0x40 },
	{ 0xc6e2, 0x40 },
	{ 0xc6e3, 0x40 },
	{ 0xc6e4, 0x40 },
	{ 0xc6e5, 0x41 },
	{ 0xc6e6, 0x3f },
	{ 0xc6e7, 0x40 },
	{ 0xc6e8, 0x42 },
	{ 0xc6e9, 0x41 },
	{ 0xc6ea, 0x41 },
	{ 0xc6eb, 0x40 },
	{ 0xc6ec, 0x40 },
	{ 0xc6ed, 0x40 },
	{ 0xc6ee, 0x3f },
	{ 0xc6ef, 0x3f },
	{ 0xc6f0, 0x3e },
	{ 0xc6f1, 0x3f },
	{ 0xc6f2, 0x3e },
	{ 0xc6f3, 0x3f },
	{ 0xc6f4, 0x3f },
	{ 0xc6f5, 0x3e },
	{ 0xc6f6, 0x3b },
	{ 0xc6f7, 0x3a },
	{ 0xc6f8, 0x40 },
	{ 0xc6f9, 0x40 },
	{ 0xc6fa, 0x3f },
	{ 0xc6fb, 0x3f },
	{ 0xc6fc, 0x3f },
	{ 0xc6fd, 0x3d },
	{ 0xc6fe, 0x3b },
	{ 0xc6ff, 0x39 },
	{ 0xc700, 0x48 },
	{ 0xc701, 0x47 },
	{ 0xc702, 0x45 },
	{ 0xc703, 0x44 },
	{ 0xc704, 0x44 },
	{ 0xc705, 0x44 },
	{ 0xc706, 0x48 },
	{ 0xc707, 0x48 },
	{ 0xc708, 0x46 },
	{ 0xc709, 0x45 },
	{ 0xc70a, 0x45 },
	{ 0xc70b, 0x44 },
	{ 0xc70c, 0x44 },
	{ 0xc70d, 0x44 },
	{ 0xc70e, 0x45 },
	{ 0xc70f, 0x45 },
	{ 0xc710, 0x43 },
	{ 0xc711, 0x43 },
	{ 0xc712, 0x41 },
	{ 0xc713, 0x41 },
	{ 0xc714, 0x41 },
	{ 0xc715, 0x42 },
	{ 0xc716, 0x44 },
	{ 0xc717, 0x45 },
	{ 0xc718, 0x41 },
	{ 0xc719, 0x41 },
	{ 0xc71a, 0x41 },
	{ 0xc71b, 0x41 },
	{ 0xc71c, 0x41 },
	{ 0xc71d, 0x42 },
	{ 0xc71e, 0x41 },
	{ 0xc71f, 0x42 },
	{ 0xc720, 0x42 },
	{ 0xc721, 0x42 },
	{ 0xc722, 0x41 },
	{ 0xc723, 0x41 },
	{ 0xc724, 0x41 },
	{ 0xc725, 0x41 },
	{ 0xc726, 0x42 },
	{ 0xc727, 0x42 },
	{ 0xc728, 0x44 },
	{ 0xc729, 0x44 },
	{ 0xc72a, 0x42 },
	{ 0xc72b, 0x42 },
	{ 0xc72c, 0x42 },
	{ 0xc72d, 0x43 },
	{ 0xc72e, 0x44 },
	{ 0xc72f, 0x45 },
	{ 0xc730, 0x47 },
	{ 0xc731, 0x45 },
	{ 0xc732, 0x46 },
	{ 0xc733, 0x44 },
	{ 0xc734, 0x44 },
	{ 0xc735, 0x46 },
	{ 0xc736, 0x45 },
	{ 0xc737, 0x47 },
	{ 0xc738, 0x49 },
	{ 0xc739, 0x47 },
	{ 0xc73a, 0x47 },
	{ 0xc73b, 0x45 },
	{ 0xc73c, 0x45 },
	{ 0xc73d, 0x48 },
	{ 0xc73e, 0x47 },
	{ 0xc73f, 0x4a },
	{ 0xc5c0, 0x1 },
	{ 0xc5c1, 0x0 },
	{ 0xc5c2, 0x0 },
	{ 0xc5c3, 0x0 },
	{ 0xc5c4, 0x0 },
	{ 0xc5c5, 0x0 },
	{ 0xc5c6, 0x0 },
	{ 0xc5c7, 0x1 },
	{ 0xc5c8, 0x0 },
	{ 0xc5c9, 0x0 },
	{ 0xc5ca, 0x0 },
	{ 0xc5cb, 0x0 },
	{ 0xc5cc, 0x0 },
	{ 0xc5cd, 0x0 },
	{ 0xc5ce, 0x0 },
	{ 0xc5cf, 0x0 },
	{ 0xc5d0, 0x0 },
	{ 0xc5d1, 0x0 },
	{ 0xc5d2, 0x0 },
	{ 0xc5d3, 0x0 },
	{ 0xc5d4, 0x0 },
	{ 0xc5d5, 0x0 },
	{ 0xc5d6, 0x0 },
	{ 0xc5d7, 0x0 },
	{ 0xc5d8, 0x0 },
	{ 0xc5d9, 0x0 },
	{ 0xc5da, 0x0 },
	{ 0xc5db, 0x1 },
	{ 0xc5dc, 0x1 },
	{ 0xc5dd, 0x0 },
	{ 0xc5de, 0x0 },
	{ 0xc5df, 0x0 },
	{ 0xc5e0, 0x0 },
	{ 0xc5e1, 0x0 },
	{ 0xc5e2, 0x0 },
	{ 0xc5e3, 0x1 },
	{ 0xc5e4, 0x1 },
	{ 0xc5e5, 0x0 },
	{ 0xc5e6, 0x0 },
	{ 0xc5e7, 0x0 },
	{ 0xc5e8, 0x0 },
	{ 0xc5e9, 0x0 },
	{ 0xc5ea, 0x0 },
	{ 0xc5eb, 0x0 },
	{ 0xc5ec, 0x0 },
	{ 0xc5ed, 0x0 },
	{ 0xc5ee, 0x0 },
	{ 0xc5ef, 0x0 },
	{ 0xc5f0, 0x0 },
	{ 0xc5f1, 0x0 },
	{ 0xc5f2, 0x0 },
	{ 0xc5f3, 0x0 },
	{ 0xc5f4, 0x0 },
	{ 0xc5f5, 0x0 },
	{ 0xc5f6, 0x0 },
	{ 0xc5f7, 0x0 },
	{ 0xc5f8, 0x1 },
	{ 0xc5f9, 0x0 },
	{ 0xc5fa, 0x0 },
	{ 0xc5fb, 0x0 },
	{ 0xc5fc, 0x0 },
	{ 0xc5fd, 0x0 },
	{ 0xc5fe, 0x0 },
	{ 0xc5ff, 0x1 },
	{ 0xc600, 0x40 },
	{ 0xc601, 0x42 },
	{ 0xc602, 0x40 },
	{ 0xc603, 0x42 },
	{ 0xc604, 0x41 },
	{ 0xc605, 0x42 },
	{ 0xc606, 0x3c },
	{ 0xc607, 0x3d },
	{ 0xc608, 0x41 },
	{ 0xc609, 0x41 },
	{ 0xc60a, 0x41 },
	{ 0xc60b, 0x41 },
	{ 0xc60c, 0x41 },
	{ 0xc60d, 0x42 },
	{ 0xc60e, 0x3b },
	{ 0xc60f, 0x3c },
	{ 0xc610, 0x42 },
	{ 0xc611, 0x43 },
	{ 0xc612, 0x42 },
	{ 0xc613, 0x43 },
	{ 0xc614, 0x42 },
	{ 0xc615, 0x42 },
	{ 0xc616, 0x42 },
	{ 0xc617, 0x42 },
	{ 0xc618, 0x43 },
	{ 0xc619, 0x42 },
	{ 0xc61a, 0x43 },
	{ 0xc61b, 0x42 },
	{ 0xc61c, 0x42 },
	{ 0xc61d, 0x42 },
	{ 0xc61e, 0x41 },
	{ 0xc61f, 0x41 },
	{ 0xc620, 0x42 },
	{ 0xc621, 0x42 },
	{ 0xc622, 0x42 },
	{ 0xc623, 0x42 },
	{ 0xc624, 0x42 },
	{ 0xc625, 0x42 },
	{ 0xc626, 0x42 },
	{ 0xc627, 0x42 },
	{ 0xc628, 0x42 },
	{ 0xc629, 0x41 },
	{ 0xc62a, 0x43 },
	{ 0xc62b, 0x42 },
	{ 0xc62c, 0x42 },
	{ 0xc62d, 0x42 },
	{ 0xc62e, 0x40 },
	{ 0xc62f, 0x40 },
	{ 0xc630, 0x3e },
	{ 0xc631, 0x41 },
	{ 0xc632, 0x3f },
	{ 0xc633, 0x42 },
	{ 0xc634, 0x41 },
	{ 0xc635, 0x3f },
	{ 0xc636, 0x3f },
	{ 0xc637, 0x3d },
	{ 0xc638, 0x3e },
	{ 0xc639, 0x40 },
	{ 0xc63a, 0x40 },
	{ 0xc63b, 0x42 },
	{ 0xc63c, 0x41 },
	{ 0xc63d, 0x3f },
	{ 0xc63e, 0x3d },
	{ 0xc63f, 0x3b },
	{ 0xc640, 0x49 },
	{ 0xc641, 0x48 },
	{ 0xc642, 0x45 },
	{ 0xc643, 0x44 },
	{ 0xc644, 0x43 },
	{ 0xc645, 0x46 },
	{ 0xc646, 0x45 },
	{ 0xc647, 0x48 },
	{ 0xc648, 0x47 },
	{ 0xc649, 0x48 },
	{ 0xc64a, 0x43 },
	{ 0xc64b, 0x44 },
	{ 0xc64c, 0x43 },
	{ 0xc64d, 0x45 },
	{ 0xc64e, 0x44 },
	{ 0xc64f, 0x46 },
	{ 0xc650, 0x43 },
	{ 0xc651, 0x42 },
	{ 0xc652, 0x42 },
	{ 0xc653, 0x41 },
	{ 0xc654, 0x41 },
	{ 0xc655, 0x42 },
	{ 0xc656, 0x43 },
	{ 0xc657, 0x44 },
	{ 0xc658, 0x41 },
	{ 0xc659, 0x42 },
	{ 0xc65a, 0x40 },
	{ 0xc65b, 0x41 },
	{ 0xc65c, 0x41 },
	{ 0xc65d, 0x41 },
	{ 0xc65e, 0x42 },
	{ 0xc65f, 0x42 },
	{ 0xc660, 0x42 },
	{ 0xc661, 0x42 },
	{ 0xc662, 0x41 },
	{ 0xc663, 0x41 },
	{ 0xc664, 0x41 },
	{ 0xc665, 0x41 },
	{ 0xc666, 0x42 },
	{ 0xc667, 0x42 },
	{ 0xc668, 0x44 },
	{ 0xc669, 0x44 },
	{ 0xc66a, 0x42 },
	{ 0xc66b, 0x42 },
	{ 0xc66c, 0x42 },
	{ 0xc66d, 0x42 },
	{ 0xc66e, 0x44 },
	{ 0xc66f, 0x44 },
	{ 0xc670, 0x45 },
	{ 0xc671, 0x43 },
	{ 0xc672, 0x46 },
	{ 0xc673, 0x44 },
	{ 0xc674, 0x44 },
	{ 0xc675, 0x45 },
	{ 0xc676, 0x44 },
	{ 0xc677, 0x45 },
	{ 0xc678, 0x47 },
	{ 0xc679, 0x45 },
	{ 0xc67a, 0x47 },
	{ 0xc67b, 0x45 },
	{ 0xc67c, 0x45 },
	{ 0xc67d, 0x46 },
	{ 0xc67e, 0x46 },
	{ 0xc67f, 0x47 },
	{ 0x5900, 0x0a },
	{ 0xb366, 0xfd },
	{ 0xb367, 0x58 },
	{ 0xb368, 0xfe },
	{ 0xb369, 0xb9 },
	{ 0x5906, 0x11 },
	{ 0xb36c, 0x0a },
	{ 0x5911, 0x00 },
	{ 0xb364, 0x2c },
	{ 0xb365, 0x1a },
	{ 0x593c, 0x00 },
	{ 0x593d, 0x0a },
	{ 0x593e, 0x00 },
	{ 0x593f, 0x0a },
	{ 0x5940, 0x04 },
	{ 0x5941, 0xe2 },
	{ 0x5942, 0x03 },
	{ 0x5943, 0xac },
	{ 0x590d, 0xa7 },
	{ 0x590e, 0xa0 },
	{ 0x5907, 0xff },
	{ 0x5908, 0xff },
	{ 0x5909, 0xff },
	{ 0x590a, 0xff },
	{ 0x590b, 0xff },
	{ 0x590c, 0xff },
	{ 0x5944, 0x00 },
	{ 0x5945, 0x00 },
	{ 0x5950, 0x00 },
	{ 0x5951, 0x00 },
	{ 0x5912, 0x40 },
	{ 0x5919, 0x40 },
	{ 0x5924, 0x00 },
	{ 0x5925, 0x0e },
	{ 0x5930, 0x03 },
	{ 0x5931, 0xe0 },
	{ 0x5946, 0x00 },
	{ 0x5947, 0x00 },
	{ 0x5952, 0x00 },
	{ 0x5953, 0x00 },
	{ 0x5913, 0x40 },
	{ 0x591a, 0x40 },
	{ 0x5926, 0x00 },
	{ 0x5927, 0x0e },
	{ 0x5932, 0x03 },
	{ 0x5933, 0xe0 },
	{ 0x5948, 0x00 },
	{ 0x5949, 0x00 },
	{ 0x5954, 0x00 },
	{ 0x5955, 0x00 },
	{ 0x5914, 0x40 },
	{ 0x591b, 0x40 },
	{ 0x5928, 0x00 },
	{ 0x5929, 0x0e },
	{ 0x5934, 0x03 },
	{ 0x5935, 0xe0 },
	{ 0x594a, 0x00 },
	{ 0x594b, 0x00 },
	{ 0x5956, 0x00 },
	{ 0x5957, 0x00 },
	{ 0x5915, 0x40 },
	{ 0x591c, 0x00 },
	{ 0x592a, 0x00 },
	{ 0x592b, 0x0e },
	{ 0x5936, 0x03 },
	{ 0x5937, 0xe0 },
	{ 0x594c, 0x00 },
	{ 0x594d, 0x00 },
	{ 0x5958, 0x00 },
	{ 0x5959, 0x00 },
	{ 0x5916, 0x40 },
	{ 0x591d, 0x40 },
	{ 0x592c, 0x00 },
	{ 0x592d, 0x0e },
	{ 0x5938, 0x03 },
	{ 0x5939, 0xe0 },
	{ 0x594e, 0x00 },
	{ 0x594f, 0x00 },
	{ 0x595a, 0x00 },
	{ 0x595b, 0x00 },
	{ 0x5917, 0x40 },
	{ 0x591e, 0x40 },
	{ 0x592e, 0x00 },
	{ 0x592f, 0x0e },
	{ 0x593a, 0x03 },
	{ 0x593b, 0xe0 },
	{ 0xb2a4, 0x00 },
	{ 0xb2a5, 0x00 },
	{ 0xb2a6, 0x00 },
	{ 0xb2a7, 0x00 },
	{ 0xb2a8, 0x00 },
	{ 0xb2a9, 0x00 },
	{ 0xb2aa, 0x00 },
	{ 0xb2ab, 0x00 },
	{ 0xb2ac, 0x00 },
	{ 0xb2ad, 0x00 },
	{ 0xb2ae, 0x00 },
	{ 0xb2af, 0x44 },
	{ 0xb2b0, 0x40 },
	{ 0xb2b1, 0x00 },
	{ 0xb2b2, 0x00 },
	{ 0xb2b3, 0x00 },
	{ 0xb2b4, 0x00 },
	{ 0xb2b5, 0x00 },
	{ 0xb2b6, 0x00 },
	{ 0xb2b7, 0x44 },
	{ 0xb2b8, 0x40 },
	{ 0xb2b9, 0x00 },
	{ 0xb2ba, 0x00 },
	{ 0xb2bb, 0x00 },
	{ 0xb2bc, 0x00 },
	{ 0xb2bd, 0x00 },
	{ 0xb2be, 0x09 },
	{ 0xb2bf, 0x99 },
	{ 0xb2c0, 0x90 },
	{ 0xb2c1, 0x00 },
	{ 0xb2c2, 0x00 },
	{ 0xb2c3, 0x00 },
	{ 0xb2c4, 0x00 },
	{ 0xb2c5, 0x00 },
	{ 0xb2c6, 0x99 },
	{ 0xb2c7, 0x99 },
	{ 0xb2c8, 0x90 },
	{ 0xb2c9, 0x00 },
	{ 0xb2ca, 0x00 },
	{ 0xb2cb, 0x00 },
	{ 0xb2cc, 0x00 },
	{ 0xb2cd, 0x09 },
	{ 0xb2ce, 0x99 },
	{ 0xb2cf, 0x99 },
	{ 0xb2d0, 0x99 },
	{ 0xb2d1, 0x00 },
	{ 0xb2d2, 0x00 },
	{ 0xb2d3, 0x00 },
	{ 0xb2d4, 0x00 },
	{ 0xb2d5, 0x19 },
	{ 0xb2d6, 0x99 },
	{ 0xb2d7, 0x99 },
	{ 0xb2d8, 0x99 },
	{ 0xb2d9, 0x00 },
	{ 0xb2da, 0x00 },
	{ 0xb2db, 0x00 },
	{ 0xb2dc, 0x00 },
	{ 0xb2dd, 0x09 },
	{ 0xb2de, 0x99 },
	{ 0xb2df, 0x99 },
	{ 0xb2e0, 0x99 },
	{ 0xb2e1, 0x00 },
	{ 0xb2e2, 0x00 },
	{ 0xb2e3, 0x00 },
	{ 0xb2e4, 0x00 },
	{ 0xb2e5, 0x00 },
	{ 0xb2e6, 0x99 },
	{ 0xb2e7, 0x99 },
	{ 0xb2e8, 0x99 },
	{ 0xb2e9, 0x00 },
	{ 0xb2ea, 0x00 },
	{ 0xb2eb, 0x00 },
	{ 0xb2ec, 0x00 },
	{ 0xb2ed, 0x00 },
	{ 0xb2ee, 0x09 },
	{ 0xb2ef, 0x99 },
	{ 0xb2f0, 0x99 },
	{ 0xb2f1, 0x90 },
	{ 0xb2f2, 0x00 },
	{ 0xb2f3, 0x00 },
	{ 0xb2f4, 0x00 },
	{ 0xb2f5, 0x00 },
	{ 0xb2f6, 0x00 },
	{ 0xb2f7, 0x99 },
	{ 0xb2f8, 0x99 },
	{ 0xb2f9, 0x90 },
	{ 0xb2fa, 0x00 },
	{ 0xb2fb, 0x00 },
	{ 0xb2fc, 0x00 },
	{ 0xb2fd, 0x00 },
	{ 0xb2fe, 0x00 },
	{ 0xb2ff, 0x99 },
	{ 0xb300, 0x99 },
	{ 0xb301, 0x99 },
	{ 0xb302, 0x00 },
	{ 0xb303, 0x00 },
	{ 0xb304, 0x00 },
	{ 0xb305, 0x00 },
	{ 0xb306, 0x00 },
	{ 0xb307, 0x26 },
	{ 0xb308, 0xee },
	{ 0xb309, 0xe6 },
	{ 0xb30a, 0x20 },
	{ 0xb30b, 0x00 },
	{ 0xb30c, 0x00 },
	{ 0xb30d, 0x00 },
	{ 0xb30e, 0x00 },
	{ 0xb30f, 0x06 },
	{ 0xb310, 0xee },
	{ 0xb311, 0xe6 },
	{ 0xb312, 0x00 },
	{ 0xb313, 0x00 },
	{ 0xb314, 0x00 },
	{ 0xb315, 0x00 },
	{ 0xb316, 0x00 },
	{ 0xb317, 0x00 },
	{ 0xb318, 0x66 },
	{ 0xb319, 0x60 },
	{ 0xb31a, 0x00 },
	{ 0xb31b, 0x00 },
	{ 0xb31c, 0x00 },
	{ 0xb31d, 0x00 },
	{ 0xb31e, 0x00 },
	{ 0xb31f, 0x00 },
	{ 0xb320, 0x02 },
	{ 0xb321, 0x00 },
	{ 0xb322, 0x00 },
	{ 0xb323, 0x00 },
	{ 0xb284, 0x00 },
	{ 0xb285, 0x00 },
	{ 0xb286, 0xc0 },
	{ 0xb287, 0x01 },
	{ 0xb288, 0xc0 },
	{ 0xb289, 0x01 },
	{ 0xb28a, 0xe0 },
	{ 0xb28b, 0x01 },
	{ 0xb28c, 0xf0 },
	{ 0xb28d, 0x01 },
	{ 0xb28e, 0xf8 },
	{ 0xb28f, 0x03 },
	{ 0xb290, 0xfc },
	{ 0xb291, 0x03 },
	{ 0xb292, 0xf8 },
	{ 0xb293, 0x03 },
	{ 0xb294, 0xf0 },
	{ 0xb295, 0x03 },
	{ 0xb296, 0xe0 },
	{ 0xb297, 0x07 },
	{ 0xb298, 0xc0 },
	{ 0xb299, 0x07 },
	{ 0xb29a, 0xc0 },
	{ 0xb29b, 0x0f },
	{ 0xb29c, 0xc0 },
	{ 0xb29d, 0x1f },
	{ 0xb29e, 0x80 },
	{ 0xb29f, 0x0f },
	{ 0xb2a0, 0x00 },
	{ 0xb2a1, 0x07 },
	{ 0xb2a2, 0x00 },
	{ 0xb2a3, 0x02 },
	{ 0xb324, 0x00 },
	{ 0xb325, 0x00 },
	{ 0xb326, 0xc0 },
	{ 0xb327, 0x01 },
	{ 0xb328, 0xc0 },
	{ 0xb329, 0x01 },
	{ 0xb32a, 0xe0 },
	{ 0xb32b, 0x01 },
	{ 0xb32c, 0xf0 },
	{ 0xb32d, 0x01 },
	{ 0xb32e, 0xf8 },
	{ 0xb32f, 0x03 },
	{ 0xb330, 0xfc },
	{ 0xb331, 0x03 },
	{ 0xb332, 0xf8 },
	{ 0xb333, 0x03 },
	{ 0xb334, 0xf0 },
	{ 0xb335, 0x03 },
	{ 0xb336, 0xe0 },
	{ 0xb337, 0x07 },
	{ 0xb338, 0xc0 },
	{ 0xb339, 0x07 },
	{ 0xb33a, 0xc0 },
	{ 0xb33b, 0x0f },
	{ 0xb33c, 0xc0 },
	{ 0xb33d, 0x1f },
	{ 0xb33e, 0x80 },
	{ 0xb33f, 0x0f },
	{ 0xb340, 0x00 },
	{ 0xb341, 0x07 },
	{ 0xb342, 0x00 },
	{ 0xb343, 0x02 },
	{ 0xb344, 0x00 },
	{ 0xb345, 0x00 },
	{ 0xb346, 0xc0 },
	{ 0xb347, 0x01 },
	{ 0xb348, 0xc0 },
	{ 0xb349, 0x01 },
	{ 0xb34a, 0xe0 },
	{ 0xb34b, 0x01 },
	{ 0xb34c, 0xf0 },
	{ 0xb34d, 0x01 },
	{ 0xb34e, 0xf8 },
	{ 0xb34f, 0x03 },
	{ 0xb350, 0xfc },
	{ 0xb351, 0x03 },
	{ 0xb352, 0xf8 },
	{ 0xb353, 0x03 },
	{ 0xb354, 0xf0 },
	{ 0xb355, 0x03 },
	{ 0xb356, 0xe0 },
	{ 0xb357, 0x07 },
	{ 0xb358, 0xc0 },
	{ 0xb359, 0x07 },
	{ 0xb35a, 0xc0 },
	{ 0xb35b, 0x0f },
	{ 0xb35c, 0xc0 },
	{ 0xb35d, 0x1f },
	{ 0xb35e, 0x80 },
	{ 0xb35f, 0x0f },
	{ 0xb360, 0x00 },
	{ 0xb361, 0x07 },
	{ 0xb362, 0x00 },
	{ 0xb363, 0x02 },
	{ 0xb36d, 0x0 },
	{ 0xb272, 0x3 },
	{ 0xb273, 0xb8 },
	{ 0xb274, 0x1 },
	{ 0xb275, 0x0 },
	{ 0xb276, 0x1 },
	{ 0xb277, 0x28 },
	{ 0xb278, 0x3 },
	{ 0xb279, 0xb8 },
	{ 0xb27a, 0x1 },
	{ 0xb27b, 0x0 },
	{ 0xb27c, 0x1 },
	{ 0xb27d, 0x28 },
	{ 0xb27e, 0x3 },
	{ 0xb27f, 0xb8 },
	{ 0xb280, 0x1 },
	{ 0xb281, 0x0 },
	{ 0xb282, 0x1 },
	{ 0xb283, 0x28 },
	{ 0xb271, 0x00 },
	{ 0xb414, 0x00 },
	{ 0xb415, 0x00 },
	{ 0xb416, 0x01 },
	{ 0xb417, 0x00 },
	{ 0xb418, 0x00 },
	{ 0xb419, 0x00 },
	{ 0xb41a, 0x02 },
	{ 0xb41b, 0x00 },
	{ 0xb41c, 0x00 },
	{ 0xb41d, 0x00 },
	{ 0xb41e, 0x03 },
	{ 0xb41f, 0x00 },
	{ 0xb420, 0x00 },
	{ 0xb421, 0x00 },
	{ 0xb422, 0x04 },
	{ 0xb423, 0x00 },
	{ 0xE0E0, 0x88 },
	{ 0xE0E1, 0x25 },
	{ 0xE0E2, 0x1c },
	{ 0xE0E3, 0x30 },
	{ 0xE0E4, 0xd4 },
	{ 0xE0E5, 0x07 },
	{ 0xE0E6, 0xd0 },
	{ 0xE0E7, 0x0f },
	{ 0xE0E8, 0xa0 },
	{ 0xE0E9, 0x09 },
	{ 0xE0EA, 0x14 },
	{ 0xE0EB, 0x05 },
	{ 0xE0EC, 0xcc },
	{ 0xE0ED, 0x03 },
	{ 0xE0EE, 0xe8 },
	{ 0xE0EF, 0x07 },
	{ 0xE0F0, 0xb0 },
	{ 0xE0F1, 0x09 },
	{ 0xE0F2, 0xb0 },
	{ 0xE0F3, 0x03 },
	{ 0xE0F4, 0xe8 },
	{ 0xE0F5, 0x05 },
	{ 0xE0F6, 0xad },
	{ 0xE0F7, 0x0b },
	{ 0xE0F8, 0x10 },
	{ 0xE0F9, 0x03 },
	{ 0xE0FA, 0xe8 },
	{ 0xb264, 0x7 },
	{ 0xb265, 0xff },
	{ 0xb266, 0x7 },
	{ 0xb267, 0xff },
	{ 0xb268, 0x7 },
	{ 0xb269, 0xff },
	{ 0x5ac1, 0x18 },
	{ 0x5ac2, 0x26 },
	{ 0x5580, 0x3 },
	{ 0x5582, 0x80 },
	{ 0x5600, 0x3 },
	{ 0x5602, 0x80 },
	{ 0x5680, 0x3 },
	{ 0x5682, 0x80 },
	{ 0xb761, 0x6 },
	{ 0xb762, 0x10 },
	{ 0xb763, 0x18 },
	{ 0xb764, 0x20 },
	{ 0xb765, 0x23 },
	{ 0xb766, 0x27 },
	{ 0xb767, 0x2f },
	{ 0xb768, 0x36 },
	{ 0xb769, 0x4 },
	{ 0xb76a, 0x6 },
	{ 0xb76b, 0xa },
	{ 0xb76c, 0xa },
	{ 0xb76d, 0xa },
	{ 0xb76e, 0xa },
	{ 0xb76f, 0xa },
	{ 0xb770, 0xa },
	{ 0xb771, 0x4 },
	{ 0xb772, 0x6 },
	{ 0xb773, 0xa },
	{ 0xb774, 0xa },
	{ 0xb775, 0xa },
	{ 0xb776, 0xa },
	{ 0xb777, 0xa },
	{ 0xb778, 0xa },
	{ 0xb779, 0xe },
	{ 0xb77a, 0x14 },
	{ 0xb77b, 0x1e },
	{ 0xb77c, 0x1e },
	{ 0xb77d, 0x20 },
	{ 0xb77e, 0x22 },
	{ 0xb77f, 0x24 },
	{ 0xb780, 0x28 },
	{ 0xb781, 0xe },
	{ 0xb782, 0x14 },
	{ 0xb783, 0x1e },
	{ 0xb784, 0x1e },
	{ 0xb785, 0x20 },
	{ 0xb786, 0x22 },
	{ 0xb787, 0x24 },
	{ 0xb788, 0x28 },
	{ 0xb789, 0xe },
	{ 0xb78a, 0x14 },
	{ 0xb78b, 0x1e },
	{ 0xb78c, 0x1e },
	{ 0xb78d, 0x20 },
	{ 0xb78e, 0x22 },
	{ 0xb78f, 0x24 },
	{ 0xb790, 0x28 },
	{ 0xb791, 0x5 },
	{ 0xb792, 0x5 },
	{ 0xb793, 0x5 },
	{ 0xb794, 0x4 },
	{ 0xb795, 0x4 },
	{ 0xb796, 0x4 },
	{ 0xb797, 0x4 },
	{ 0xb798, 0x3 },
	{ 0xb799, 0x7 },
	{ 0xb79a, 0x6 },
	{ 0xb79b, 0x5 },
	{ 0xb79c, 0x4 },
	{ 0xb79d, 0x4 },
	{ 0xb79e, 0x4 },
	{ 0xb79f, 0x4 },
	{ 0xb7a0, 0x4 },
	{ 0xb7a1, 0x8 },
	{ 0xb7a2, 0x6 },
	{ 0xb7a3, 0x5 },
	{ 0xb7a4, 0x4 },
	{ 0xb7a5, 0x4 },
	{ 0xb7a6, 0x4 },
	{ 0xb7a7, 0x4 },
	{ 0xb7a8, 0x4 },
	{ 0xb7a9, 0x5 },
	{ 0xb7aa, 0x5 },
	{ 0xb7ab, 0x4 },
	{ 0xb7ac, 0x4 },
	{ 0xb7ad, 0x4 },
	{ 0xb7ae, 0x4 },
	{ 0xb7af, 0x4 },
	{ 0xb7b0, 0x4 },
	{ 0xb7b1, 0x5 },
	{ 0xb7b2, 0x5 },
	{ 0xb7b3, 0x4 },
	{ 0xb7b4, 0x4 },
	{ 0xb7b5, 0x4 },
	{ 0xb7b6, 0x4 },
	{ 0xb7b7, 0x4 },
	{ 0xb7b8, 0x4 },
	{ 0xb7b9, 0x5 },
	{ 0xb7ba, 0x5 },
	{ 0xb7bb, 0x4 },
	{ 0xb7bc, 0x4 },
	{ 0xb7bd, 0x4 },
	{ 0xb7be, 0x4 },
	{ 0xb7bf, 0x4 },
	{ 0xb7c0, 0x4 },
	{ 0xb7c1, 0x4 },
	{ 0xb7c2, 0x8 },
	{ 0xb7c3, 0xc },
	{ 0xb7c4, 0x10 },
	{ 0xb7c5, 0x12 },
	{ 0xb7c6, 0x14 },
	{ 0xb7c7, 0x16 },
	{ 0xb7c8, 0x18 },
	{ 0xb7c9, 0x0 },
	{ 0xb7ca, 0x0 },
	{ 0xb7cb, 0x0 },
	{ 0xb7cc, 0x0 },
	{ 0xb7cd, 0x0 },
	{ 0xb7ce, 0x0 },
	{ 0xb7cf, 0x0 },
	{ 0xb7d0, 0x0 },
	{ 0xb7d1, 0xa },
	{ 0xb7d2, 0x8 },
	{ 0xb7d3, 0x6 },
	{ 0xb7d4, 0x0 },
	{ 0xb7d5, 0x0 },
	{ 0xb7d6, 0x0 },
	{ 0xb7d7, 0x0 },
	{ 0xb7d8, 0x0 },
	{ 0xb7d9, 0x1 },
	{ 0xb7da, 0x1 },
	{ 0xb7db, 0x1 },
	{ 0xb7dc, 0x0 },
	{ 0xb7dd, 0x0 },
	{ 0xb7de, 0x0 },
	{ 0xb7df, 0x0 },
	{ 0xb7e0, 0x0 },
	{ 0xb146, 0x1 },
	{ 0xb173, 0xf8 },
	{ 0xb179, 0x10 },
	{ 0xb17e, 0x0 },
	{ 0xb17f, 0x18 },
	{ 0xb185, 0x10 },
	{ 0xb175, 0x40 },
	{ 0xb17b, 0x10 },
	{ 0xb180, 0x0 },
	{ 0xb181, 0x18 },
	{ 0xb187, 0x10 },
	{ 0xb177, 0x40 },
	{ 0xb17d, 0x10 },
	{ 0xb182, 0x0 },
	{ 0xb183, 0x18 },
	{ 0xb189, 0x10 },
	{ 0xb219, 0x38 },
	{ 0xb21a, 0x30 },
	{ 0x598b, 0x60 },
	{ 0x59aa, 0x0 },
	{ 0x59ab, 0x0 },
	{ 0x59ae, 0x0 },
	{ 0x59af, 0x0 },
	{ 0x59b2, 0x4 },
	{ 0x59b3, 0xf6 },
	{ 0x59b6, 0x3 },
	{ 0x59b7, 0x93 },
	{ 0x59ac, 0x0 },
	{ 0x59ad, 0x0 },
	{ 0x59b0, 0x0 },
	{ 0x59b1, 0x0 },
	{ 0x59b4, 0x4 },
	{ 0x59b5, 0xf6 },
	{ 0x59b8, 0x3 },
	{ 0x59b9, 0x93 },
	{ 0x59a4, 0x6 },
	{ 0x59a5, 0x1 },
	{ 0x59a6, 0x0 },
	{ 0x59a7, 0x20 },
	{ 0x59a8, 0x0 },
	{ 0x59a9, 0x40 },
	{ 0xb0ae, 0x18 },
	{ 0xb0af, 0x68 },
	{ 0xb0b0, 0x18 },
	{ 0xb0b1, 0x68 },
	{ 0xb1a3, 0x1 },
	{ 0xb210, 0x1 },
	{ 0xb213, 0x7 },
	{ 0x5a03, 0xd },
	{ 0xb218, 0x0 },
	{ 0xb211, 0x2 },
	{ 0xb660, 0x1 },
	{ 0xb68c, 0x0 },
	{ 0xb68d, 0x0 },
	{ 0xb68e, 0x60 },
	{ 0xb68f, 0x0 },
	{ 0x5801, 0x51 },
	{ 0x5811, 0x0 },
	{ 0xb662, 0x48 },
	{ 0xb663, 0x0 },
	{ 0xb664, 0x4a },
	{ 0xb665, 0x66 },
	{ 0xb666, 0x4c },
	{ 0xb667, 0xcd },
	{ 0xb668, 0x50 },
	{ 0xb669, 0x0 },
	{ 0xb66a, 0x28 },
	{ 0xb66b, 0x0 },
	{ 0xb66c, 0x38 },
	{ 0xb66d, 0x0 },
	{ 0xb66e, 0x48 },
	{ 0xb66f, 0x0 },
	{ 0xb670, 0x50 },
	{ 0xb671, 0x0 },
	{ 0xb672, 0x52 },
	{ 0xb673, 0x0 },
	{ 0x5814, 0x80 },
	{ 0x5815, 0x80 },
	{ 0x5816, 0x80 },
	{ 0x5817, 0x80 },
	{ 0x5818, 0x80 },
	{ 0x5819, 0x80 },
	{ 0x581a, 0x80 },
	{ 0x581b, 0x80 },
	{ 0x581c, 0x80 },
	{ 0x581d, 0x80 },
	{ 0x581e, 0x80 },
	{ 0x581f, 0x80 },
	{ 0x5820, 0x80 },
	{ 0x5821, 0x80 },
	{ 0x5822, 0x60 },
	{ 0x5823, 0x40 },
	{ 0x5824, 0x0 },
	{ 0x5825, 0x0 },
	{ 0x5826, 0x80 },
	{ 0x5827, 0x60 },
	{ 0x5828, 0x40 },
	{ 0x5829, 0x0 },
	{ 0x582a, 0x0 },
	{ 0x582b, 0x0 },
	{ 0x582c, 0x40 },
	{ 0x582d, 0x20 },
	{ 0x582e, 0x0 },
	{ 0x582f, 0x0 },
	{ 0x5830, 0x0 },
	{ 0x5831, 0x0 },
	{ 0x5832, 0x80 },
	{ 0x5833, 0x80 },
	{ 0x5834, 0x80 },
	{ 0x5835, 0x80 },
	{ 0x5836, 0x80 },
	{ 0x5837, 0x80 },
	{ 0x5838, 0x80 },
	{ 0x5839, 0x80 },
	{ 0x583a, 0x80 },
	{ 0x583b, 0x80 },
	{ 0x583c, 0x80 },
	{ 0x583d, 0x80 },
	{ 0x583e, 0x80 },
	{ 0x583f, 0x80 },
	{ 0x5840, 0x60 },
	{ 0x5841, 0x40 },
	{ 0x5842, 0x0 },
	{ 0x5843, 0x0 },
	{ 0x5844, 0x80 },
	{ 0x5845, 0x60 },
	{ 0x5846, 0x40 },
	{ 0x5847, 0x0 },
	{ 0x5848, 0x0 },
	{ 0x5849, 0x0 },
	{ 0x584a, 0x40 },
	{ 0x584b, 0x20 },
	{ 0x584c, 0x0 },
	{ 0x584d, 0x0 },
	{ 0x584e, 0x0 },
	{ 0x584f, 0x0 },
	{ 0xb560, 0x0 },
	{ 0xb576, 0xa },
	{ 0xb57c, 0x1 },
	{ 0xb57d, 0x7 },
	{ 0xb5b2, 0x11 },
	{ 0xb5b3, 0x0 },
	{ 0xb5b6, 0x1 },
	{ 0xb5a7, 0x2 },
	{ 0xb584, 0x1 },
	{ 0xb5a0, 0x0 },
	{ 0xb624, 0x0 },
	{ 0xb625, 0xa },
	{ 0xb626, 0x2 },
	{ 0xb627, 0x30 },
	{ 0xb628, 0xa },
	{ 0xb629, 0x50 },
	{ 0xb62a, 0x2a },
	{ 0xb62b, 0x50 },
	{ 0xb606, 0x1 },
	{ 0xb607, 0x10 },
	{ 0xb652, 0x0 },
	{ 0xb653, 0xa4 },
	{ 0xb654, 0x0 },
	{ 0xb655, 0x80 },
	{ 0xb608, 0x0 },
	{ 0xb609, 0x40 },
	{ 0xb60a, 0x0 },
	{ 0xb60b, 0xb4 },
	{ 0xb656, 0x0 },
	{ 0xb657, 0x84 },
	{ 0xb658, 0x0 },
	{ 0xb659, 0x70 },
	{ 0xb60c, 0x0 },
	{ 0xb60d, 0x60 },
	{ 0xb5e0, 0x9 },
	{ 0xb5e1, 0x9 },
	{ 0xb5e2, 0x9 },
	{ 0xb5c6, 0x10 },
	{ 0xb5c7, 0x20 },
	{ 0xb5d6, 0x40 },
	{ 0xb5d7, 0x60 },
	{ 0xb599, 0x10 },
	{ 0xb574, 0x10 },
	{ 0xb567, 0x10 },
	{ 0xb57e, 0x4 },
	{ 0xb5f0, 0x0 },
	{ 0xb5f1, 0x0 },
	{ 0xb59d, 0x0 },
	{ 0xb59e, 0x2 },
	{ 0xb596, 0x1 },
	{ 0xb597, 0xc },
	{ 0xb54c, 0x0 },
	{ 0xb54d, 0x1 },
	{ 0xb54e, 0x0 },
	{ 0xb54f, 0x2 },
	{ 0xb550, 0x0 },
	{ 0xb551, 0x0 },
	{ 0xb6d2, 0x1 },
	{ 0xb6a0, 0x0 },
	{ 0xb6a1, 0x7b },
	{ 0xb6a2, 0x0 },
	{ 0xb6a3, 0x94 },
	{ 0xb6a4, 0x0 },
	{ 0xb6a5, 0xc8 },
	{ 0xb6a6, 0x1 },
	{ 0xb6a7, 0x6b },
	{ 0xb6a8, 0x6 },
	{ 0xb6a9, 0x4a },
	{ 0xb6aa, 0xff },
	{ 0xb6ab, 0xb5 },
	{ 0xb6ac, 0x0 },
	{ 0xb6ad, 0x65 },
	{ 0xb6ae, 0x2 },
	{ 0xb6af, 0x51 },
	{ 0xb6b0, 0x0 },
	{ 0xb6b1, 0xf3 },
	{ 0xb6b2, 0x2 },
	{ 0xb6b3, 0x6c },
	{ 0xb6b4, 0x2 },
	{ 0xb6b5, 0x89 },
	{ 0xb6b6, 0x0 },
	{ 0xb6b7, 0x9 },
	{ 0xb6b8, 0x0 },
	{ 0xb6b9, 0xb6 },
	{ 0xb6ba, 0x2 },
	{ 0xb6bb, 0x9 },
	{ 0xb6bc, 0x2 },
	{ 0xb6bd, 0x20 },
	{ 0xb6be, 0xff },
	{ 0xb6bf, 0x4d },
	{ 0xb6c0, 0x4 },
	{ 0xb6c1, 0xf9 },
	{ 0xb6c2, 0xff },
	{ 0xb6c3, 0xcd },
	{ 0xb6c4, 0x0 },
	{ 0xb6c5, 0xac },
	{ 0xb6c6, 0x1 },
	{ 0xb6c7, 0x71 },
	{ 0xb6c8, 0x0 },
	{ 0xb6c9, 0xe0 },
	{ 0xb6ca, 0x1 },
	{ 0xb6cb, 0xb5 },
	{ 0xb6d3, 0x30 },
	{ 0xb690, 0x0 },
	{ 0xb691, 0x0 },
	{ 0xb692, 0x0 },
	{ 0xb693, 0x30 },
	{ 0xb694, 0x0 },
	{ 0xb695, 0x0 },
	{ 0xb696, 0x1 },
	{ 0xb697, 0xa },
	{ 0xb698, 0x0 },
	{ 0xb699, 0x0 },
	{ 0xb69a, 0x8 },
	{ 0xb69b, 0x63 },
	{ 0xb69c, 0x0 },
	{ 0xb69d, 0x1 },
	{ 0xb69e, 0xc6 },
	{ 0xb69f, 0xa8 },
	{ 0xb6d4, 0x30 },
	{ 0xb6d5, 0x30 },
	{ 0xb6d6, 0x28 },
	{ 0xb6d7, 0x28 },
	{ 0xb6d8, 0x1a },
	{ 0xb6d9, 0x1a },
	{ 0xb6da, 0x10 },
	{ 0xb6db, 0x10 },
	{ 0xb4ea, 0x2 },
	{ 0xb490, 0x0 },
	{ 0xb491, 0x0 },
	{ 0xb492, 0x1 },
	{ 0xb493, 0x0 },
	{ 0xb494, 0x0 },
	{ 0xb495, 0x0 },
	{ 0xb496, 0xd },
	{ 0xb497, 0x20 },
	{ 0xb498, 0x1 },
	{ 0xb499, 0x60 },
	{ 0xb49a, 0x2 },
	{ 0xb49b, 0x36 },
	{ 0xb49c, 0x3 },
	{ 0xb49d, 0x70 },
	{ 0xb49e, 0x5 },
	{ 0xb49f, 0x50 },
	{ 0xb4a0, 0x6 },
	{ 0xb4a1, 0x10 },
	{ 0xb4a2, 0x6 },
	{ 0xb4a3, 0xd0 },
	{ 0xb4a4, 0x7 },
	{ 0xb4a5, 0x60 },
	{ 0xb4a6, 0x8 },
	{ 0xb4a7, 0x0 },
	{ 0xb4a8, 0x8 },
	{ 0xb4a9, 0x80 },
	{ 0xb4aa, 0x9 },
	{ 0xb4ab, 0x0 },
	{ 0xb4ac, 0x9 },
	{ 0xb4ad, 0xd0 },
	{ 0xb4ae, 0xa },
	{ 0xb4af, 0x90 },
	{ 0xb4b0, 0xb },
	{ 0xb4b1, 0xf0 },
	{ 0xb4b2, 0xd },
	{ 0xb4b3, 0x50 },
	{ 0xb4b4, 0xe },
	{ 0xb4b5, 0x80 },
	{ 0xb4b6, 0xf },
	{ 0xb4b7, 0xf0 },
	{ 0xb4b8, 0x0 },
	{ 0xb4b9, 0x60 },
	{ 0xb4ba, 0x0 },
	{ 0xb4bb, 0xf0 },
	{ 0xb4bc, 0x2 },
	{ 0xb4bd, 0x60 },
	{ 0xb4be, 0x4 },
	{ 0xb4bf, 0x90 },
	{ 0xb4c0, 0x5 },
	{ 0xb4c1, 0x60 },
	{ 0xb4c2, 0x6 },
	{ 0xb4c3, 0x30 },
	{ 0xb4c4, 0x6 },
	{ 0xb4c5, 0xf0 },
	{ 0xb4c6, 0x7 },
	{ 0xb4c7, 0xa0 },
	{ 0xb4c8, 0x8 },
	{ 0xb4c9, 0x30 },
	{ 0xb4ca, 0x8 },
	{ 0xb4cb, 0xc0 },
	{ 0xb4cc, 0x9 },
	{ 0xb4cd, 0x90 },
	{ 0xb4ce, 0xa },
	{ 0xb4cf, 0x60 },
	{ 0xb4d0, 0xb },
	{ 0xb4d1, 0xb0 },
	{ 0xb4d2, 0xd },
	{ 0xb4d3, 0x0 },
	{ 0xb4d4, 0xe },
	{ 0xb4d5, 0x30 },
	{ 0xb4d6, 0xf },
	{ 0xb4d7, 0xf0 },
	{ 0xb4d8, 0x0 },
	{ 0xb4d9, 0xc0 },
	{ 0xb4da, 0x0 },
	{ 0xb4db, 0xa8 },
	{ 0xb4dc, 0x0 },
	{ 0xb4dd, 0x98 },
	{ 0xb4de, 0x0 },
	{ 0xb4df, 0xc0 },
	{ 0xb4e0, 0x0 },
	{ 0xb4e1, 0xa0 },
	{ 0xb4e2, 0x0 },
	{ 0xb4e3, 0x90 },
	{ 0x5b40, 0x41 },
	{ 0x5b44, 0x12 },
	{ 0x5b45, 0x0 },
	{ 0x5b49, 0x2 },
	{ 0x5b4a, 0x10 },
	{ 0x5b4b, 0x60 },
	{ 0x5b46, 0xc },
	{ 0x503c, 0x1 },
	{ 0x5034, 0x0 },
	{ 0x5035, 0x1f },
	{ 0x5036, 0x28 },
	{ 0x5037, 0x0 },
	{ 0x5038, 0x0 },
	{ 0x5039, 0x2d },
	{ 0x503a, 0x0 },
	{ 0x503b, 0x5a },
	{ 0x5900, 0xb },
	{ 0x5003, 0xfb },
	{OX01F10_TABLE_END, 0x0000}
};

static const ox01f10_reg *ox01f10_mode_table[] = {
	[MODE_1344x1020]	= ox01f10_mode_1340x1020
};

#endif  /* __OX01F10_MODE_TBLS__ */

