// SPDX-License-Identifier: MIT
/*
 * Copyright (c) 2023 Atmark Techno,Inc.
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "device-info.h"

int read_to_end(int fd, void *buf, int count)
{
	int n, total = 0;
	while (count > 0) {
		n = read(fd, buf, count);
		if (n < 0 && errno == EAGAIN)
			continue;
		if (n < 0)
			return -1;
		if (n == 0) {
			return total;
		}
		buf += n;
		count -= n;
		total += n;
	}
	return total;
}

int read_full(int fd, void *buf, int count)
{
	int rc = read_to_end(fd, buf, count);
	if (rc > 0 && rc != count) {
		// no good errno for "file too short"..
		errno = EIO;
		return -1;
	}
	return rc;
}

void xfail(const char *message)
{
	fprintf(stderr, "%s\n", message);
	exit(EXIT_FAILURE);
}

char *xstrdup(const char *str)
{
	char *result;

	result = strdup(str);
	if (result == NULL) {
		fprintf(stderr, "Fatal: memory allocation failed\n");
		exit(EXIT_FAILURE);
	}
	return result;
}
