// SPDX-License-Identifier: MIT
/*
 * Copyright (c) 2023 Atmark Techno,Inc.
 */

#pragma once

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#define IMX8ULP_BT_FUSE_SEL_OFFSET 0x7C  // fuse Bank 3 Word 7
#define IMX8ULP_USDHC_OFFSET 0x84  // fuse Bank 4 Word 1
#define IMX8ULP_SJC_DISABLE_OFFSET 0x104 // fuse Bank 8 Word 1
#define IMX8ULP_SRK_HASH_OFFSET 0x01E0  // fuse Bank 15 Word 0

// jtag setting masks
#define IMX8ULP_SJC_DISABLE_MASK 0x100

// boot setting masks
#define IMX8ULP_BT_FUSE_SEL_MASK 0x8000
#define IMX8ULP_USDHC_MASK 0x1C000000
#define IMX8ULP_USDHC_DEVICE_TYPE_MASK 0x2000000

// jtag setting masks
#define IMX8ULP_SJC_DISABLE_TRUE 0x100

// Boot setting values
#define IMX8ULP_BT_FUSE_SEL_PROGRAMMED  0x8000
#define IMX8ULP_USDHC_EMMC 0x00000000
#define IMX8ULP_USDHC_DEVICE_TYPE_EMMC 0x0000000

// secureboot setting values
#define IMX8ULP_NO_SRK_HASH 0x00000000

enum secure_status secure_status_jtag_imx8ulp(unsigned char *ocotp_data);
int is_secure_fuse_jtag_imx8ulp(unsigned char *ocotp_data);
char *secure_status_to_string_jtag_imx8ulp(enum secure_status status);
int print_fuse_status_jtag_imx8ulp(unsigned char *ocotp_data);
int write_fuse_jtag_imx8ulp(int fd);

enum secure_status secure_status_sd_boot_imx8ulp(unsigned char *ocotp_data);
int is_secure_fuse_sd_boot_imx8ulp(unsigned char *ocotp_data);
char *secure_status_to_string_sd_boot_imx8ulp(enum secure_status status);
int print_fuse_status_sd_boot_imx8ulp(unsigned char *ocotp_data);
int write_fuse_sd_boot_imx8ulp(int fd);

enum secure_status secure_status_secureboot_imx8ulp(unsigned char *ocotp_data);
int print_fuse_status_secureboot_imx8ulp(unsigned char *ocotp_data);
int is_secure_fuse_secureboot_imx8ulp(unsigned char *ocotp_data);
int write_fuse_secureboot_srk_imx8ulp(int fd);
int write_fuse_secureboot_close_imx8ulp(void);
int cmp_fuse_secureboot_srk_imx8ulp(unsigned char *ocotp_data);
int close_precheck_imx8ulp(char *close_precheck_data);
