// SPDX-License-Identifier: MIT
/*
 * Copyright (c) 2023 Atmark Techno,Inc.
 */

#pragma once

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define IMX8MP_JTAG_OFFSET 0x1C // fuse Bank 1 Word 3
#define IMX8MP_BOOT_MODE_FUSES_OFFSET 0x1C // fuse Bank 1 Word 3
// "bt_fuse_sel" is same as "boot_mode_fuses" offset
#define IMX8MP_FORCE_BT_FROM_FUSE_OFFSET 0x20 // fuse Bank 2 Word 0
#define IMX8MP_BOOT_CFG_LOCK_OFFSET 0x00 // fuse Bank 0 Word 0
// "cst_srk_lock" is same as "boot_cfg_lock" offset
#define IMX8MP_SRK_HASH_OFFSET 0x60  // fuse Bank 6 Word 0
#define IMX8MP_SEC_CONFIG_OFFSET 0x1C // fuse Bank 1 Word 3

// JTAG setting masks
#define IMX8MP_SJC_DISABLE_MASK 0x200000
#define IMX8MP_JTAG_SMODE_MASK 0xC00000
#define IMX8MP_KTE_MASK 0x100000

// boot setting masks
#define IMX8MP_BOOT_MODE_FUSES_MASK 0xF000
#define IMX8MP_FORCE_BT_FROM_FUSE_MASK 0x100000
#define IMX8MP_BT_FUSE_SEL_MASK 0x10000000

// secureboot setting masks
#define IMX8MP_SEC_CONFIG_MASK 0x2000000

// lock setting masks
#define IMX8MP_BOOT_CFG_LOCK_MASK 0xC
#define IMX8MP_CST_SRK_LOCK_MASK 0x200

// JTAG setting values
#define IMX8MP_SJC_DISABLE_TRUE 0x200000
#define IMX8MP_JTAG_SMODE_JTAG_ENABLE 0x000000
#define IMX8MP_JTAG_SMODE_SECURE 0x400000
#define IMX8MP_JTAG_SMODE_UNKNOWN 0x800000
#define IMX8MP_JTAG_SMODE_NO_DEBUG 0xC00000
#define IMX8MP_KTE_KILL 0x100000

// Boot setting values
#define IMX8MP_BOOT_MODE_FUSES_EMMC  0x2000
#define IMX8MP_FORCE_BT_FROM_FUSE_ENABLE 0x100000
#define IMX8MP_BT_FUSE_SEL_PROGRAMMED 0x10000000

// lock setting values
#define IMX8MP_BOOT_CFG_LOCK_OPWP 0xC
#define IMX8MP_CST_SRK_LOCK_ENABLE 0x200

// secureboot setting values
#define IMX8MP_NO_SRK_HASH 0x00000000
#define IMX8MP_SEC_CONFIG_ENABLE 0x2000000

int print_fuse_status_lock_imx8mp(unsigned char *ocotp_data);
int print_fuse_status_jtag_imx8mp(unsigned char *ocotp_data);
int print_fuse_status_sd_boot_imx8mp(unsigned char *ocotp_data);
int print_fuse_status_secureboot_imx8mp(unsigned char *ocotp_data);
int write_fuse_lock_imx8mp(int fd);
int write_fuse_jtag_imx8mp(int fd);
int write_fuse_sd_boot_imx8mp(int fd);
int write_fuse_secureboot_srk_imx8mp(int fd);
int write_fuse_secureboot_close_imx8mp(int fd);
int is_secure_fuse_boot_cfg_lock_imx8mp(unsigned char *ocotp_data);
int is_secure_fuse_jtag_imx8mp(unsigned char *ocotp_data);
int is_secure_fuse_sd_boot_imx8mp(unsigned char *ocotp_data);
int is_secure_fuse_secureboot_imx8mp(unsigned char *ocotp_data);
enum secure_status secure_status_jtag_imx8mp(unsigned char *ocotp_data);
enum secure_status secure_status_sd_boot_imx8mp(unsigned char *ocotp_data);
enum secure_status secure_status_secureboot_imx8mp(unsigned char *ocotp_data);
enum secure_status secure_status_boot_cfg_lock_imx8mp(unsigned char *ocotp_data);
enum secure_status secure_status_cst_srk_lock_imx8mp(unsigned char *ocotp_data);
int cmp_fuse_secureboot_srk_imx8mp(unsigned char *ocotp_data);
int close_precheck_imx8mp(char *ocotp_data);
char *secure_status_to_string_lock_imx8mp(enum secure_status status);
char *fuse_status_jtag_imx8mp(unsigned char *ocotp_data);
char *secure_status_to_string_sd_boot_imx8mp(enum secure_status status);
char *secure_status_to_string_secureboot_imx8mp(enum secure_status status);
