// SPDX-License-Identifier: MIT
/*
 * Copyright (c) 2023 Atmark Techno,Inc.
 */

#pragma once

#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define IMX6ULL_JTAG_OFFSET 0x18 // fuse Bank 0 Word 6
#define IMX6ULL_BOOT_DEVICE_USDHC_BUS_OFFSET 0x14 // fuse Bank 0 Ward 5
#define IMX6ULL_BT_FUSE_SEL_OFFSET 0x18 // fuse Bank 0 Ward 6
#define IMX6ULL_BOOT_CFG_LOCK_OFFSET 0x00 // fuse Bank 0 Ward 0

// JTAG setting masks
#define IMX6ULL_SJC_DISABLE_MASK 0x100000
#define IMX6ULL_JTAG_SMODE_MASK 0xc00000
#define	IMX6ULL_KTE_MASK 0x4000000

// boot setting masks
#define IMX6ULL_BOOT_DEVICE_MASK 0xE0
#define IMX6ULL_USDHC_MASK 0x1800
#define IMX6ULL_BT_FUSE_SEL_MASK 0x10
#define IMX6ULL_BUS_WIDTH_MASK 0xE000

// lock setting masks
#define IMX6ULL_BOOT_CFG_LOCK_MASK 0xC

// JTAG setting values
#define IMX6ULL_SJC_DISABLE_TRUE 0x100000
#define IMX6ULL_JTAG_SMODE_JTAG_ENABLE 0x000000
#define IMX6ULL_JTAG_SMODE_SECURE 0x400000
#define IMX6ULL_JTAG_SMODE_UNKNOWN 0x800000
#define IMX6ULL_JTAG_SMODE_NO_DEBUG 0xc00000
#define IMX6ULL_KTE_KILL 0x4000000

// Boot setting values
#define IMX6ULL_BOOT_DEVICE_EMMC 0x60
#define IMX6ULL_USDHC_EMMC 0x000
#define IMX6ULL_BT_FUSE_SEL_PROGRAMMED 0x10
#define IMX6ULL_BUS_WIDTH_8BIT 0x4000

// lock setting values
#define IMX6ULL_BOOT_CFG_LOCK_OPWP 0xC

int print_fuse_status_lock_imx6ull(unsigned char *ocotp_data);
int print_fuse_status_jtag_imx6ull(unsigned char *ocotp_data);
int print_fuse_status_sd_boot_imx6ull(unsigned char *ocotp_data);
int write_fuse_lock_imx6ull(int fd);
int write_fuse_jtag_imx6ull(int fd);
int write_fuse_sd_boot_imx6ull(int fd);
int is_secure_fuse_boot_cfg_lock_imx6ull(unsigned char *ocotp_data);
int is_secure_fuse_jtag_imx6ull(unsigned char *ocotp_data);
int is_secure_fuse_sd_boot_imx6ull(unsigned char *ocotp_data);
enum secure_status secure_status_jtag_imx6ull(unsigned char *ocotp_data);
enum secure_status secure_status_sd_boot_imx6ull(unsigned char *ocotp_data);
enum secure_status secure_status_boot_cfg_lock_imx6ull(unsigned char *ocotp_data);
char *secure_status_to_string_lock_imx6ull(enum secure_status status);
char *fuse_status_jtag_imx6ull(unsigned char *ocotp_data);
char *fuse_status_sd_boot_imx6ull(unsigned char *ocotp_data);
