// SPDX-License-Identifier: MIT
/*
 * Copyright (c) 2023 Atmark Techno,Inc.
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include "device-info.h"

#define ABOS_VERSION_FILE "/etc/atmark-release"
#define ABOS_MAX_VERSION_SIZE 256

int print_abos_version(void)
{
	int fd, rc, len;
	char abos_version[ABOS_MAX_VERSION_SIZE];

	fd = open(ABOS_VERSION_FILE, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "Could not open %s: %m\n", ABOS_VERSION_FILE);
		return 1;
	}

	len = read_to_end(fd, abos_version, ABOS_MAX_VERSION_SIZE);
	close(fd);
	if (len < 0) {
		fprintf(stderr, "Could not read %s: %m\n", ABOS_VERSION_FILE);
		return 1;
	}
	if (abos_version[len-1] == '\n')
		len--;
	abos_version[len] = 0;

	if (is_print_env)
		rc = printf("export AT_ABOS_VERSION=%s\n", abos_version);
	else
		rc = printf("%s\n", abos_version);

	return rc < 0;
}
