// SPDX-License-Identifier: MIT

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/sysmacros.h>

#include "linmuxcfg/linmuxcfg.h"

#define MUX_PORT_NUM 3
#define DRIVER_NODE "/dev/" MUX_CFG_NAME

static int enable_mux(char *portpath)
{
    int iInstance = 0;
    int fd;
    int ret = -1;

    dev_t devnum = makedev(MUX_FS_MAJOR, 0);

    if (!portpath) {
        return ret;
    }

    mknod(DRIVER_NODE, S_IFCHR|0644, devnum);
    fd = open(DRIVER_NODE, 0);
    if (fd == -1) {
        perror("open driver node");
        fprintf(stderr, "ems31-mux: failed to open driver node.\n");
        goto bail;
    }

    if (SetBasePort(fd, iInstance, portpath)) {
        fprintf(stderr, "ems31-mux: failed to set base port.\n");
        goto bail;
    }
    if (SetBaudRate(fd, iInstance, 460800)) {
        fprintf(stderr, "ems31-mux: failed to set baud rate.\n");
        goto bail;
    }
    if (SetNumberOfChannels(fd, iInstance, MUX_PORT_NUM)) {
        fprintf(stderr, "ems31-mux: failed to set number of mux channels.\n");
        goto bail;
    }
/*
    if (SetInitOn(fd, iInstance, 1)) {
        fprintf(stderr, "ems31-mux: failed to set init on\n");
    }
    if (SetInitCommand(fd, iInstance, 0, "AT+CMUX=0")) {
        fprintf(stderr, "ems31-mux: failed to set init command.\n");
    }
    if (SetStartDelay(fd, iInstance, 2000)) {
        fprintf(stderr, "ems31-mux: failed to set start delay.\n");
    }
 */
    if (SetSwitchoffOn(fd, iInstance, 0)) {
        fprintf(stderr, "ems31-mux: failed to set switchoff.\n");
        goto bail;
    }

    ret = 0;

bail:
    close(fd);
    return ret;
}

static void usage()
{
    fprintf(stderr, "Usage: ems31-mux port\n");
    fprintf(stderr, "  port: ex. /dev/ttymxc3\n");
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
        usage();
        return -1;
    }
    return enable_mux(argv[1]);
}
